/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.certificate;

import com.android.internal.annotations.VisibleForTesting;
import com.android.server.locksettings.recoverablekeystore.certificate.CertParsingException;
import com.android.server.locksettings.recoverablekeystore.certificate.CertUtils;
import com.android.server.locksettings.recoverablekeystore.certificate.CertValidationException;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public final class CertXml {
    private static final String METADATA_NODE_TAG = "metadata";
    private static final String METADATA_SERIAL_NODE_TAG = "serial";
    private static final String METADATA_REFRESH_INTERVAL_NODE_TAG = "refresh-interval";
    private static final String ENDPOINT_CERT_LIST_TAG = "endpoints";
    private static final String ENDPOINT_CERT_ITEM_TAG = "cert";
    private static final String INTERMEDIATE_CERT_LIST_TAG = "intermediates";
    private static final String INTERMEDIATE_CERT_ITEM_TAG = "cert";
    private final long serial;
    private final long refreshInterval;
    private final List<X509Certificate> intermediateCerts;
    private final List<X509Certificate> endpointCerts;

    private CertXml(long serial, long refreshInterval, List<X509Certificate> intermediateCerts, List<X509Certificate> endpointCerts) {
        this.serial = serial;
        this.refreshInterval = refreshInterval;
        this.intermediateCerts = intermediateCerts;
        this.endpointCerts = endpointCerts;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @VisibleForTesting
    List<X509Certificate> getAllIntermediateCerts() {
        return this.intermediateCerts;
    }

    @VisibleForTesting
    List<X509Certificate> getAllEndpointCerts() {
        return this.endpointCerts;
    }

    public CertPath getRandomEndpointCert(X509Certificate trustedRoot) throws CertValidationException {
        return this.getEndpointCert(new SecureRandom().nextInt(this.endpointCerts.size()), null, trustedRoot);
    }

    @VisibleForTesting
    CertPath getEndpointCert(int index, Date validationDate, X509Certificate trustedRoot) throws CertValidationException {
        X509Certificate chosenCert = this.endpointCerts.get(index);
        return CertUtils.validateCert(validationDate, trustedRoot, this.intermediateCerts, chosenCert);
    }

    public static CertXml parse(byte[] bytes) throws CertParsingException {
        Element rootNode = CertUtils.getXmlRootNode(bytes);
        return new CertXml(CertXml.parseSerial(rootNode), CertXml.parseRefreshInterval(rootNode), CertXml.parseIntermediateCerts(rootNode), CertXml.parseEndpointCerts(rootNode));
    }

    private static long parseSerial(Element rootNode) throws CertParsingException {
        List<String> contents = CertUtils.getXmlNodeContents(1, rootNode, METADATA_NODE_TAG, METADATA_SERIAL_NODE_TAG);
        return Long.parseLong(contents.get(0));
    }

    private static long parseRefreshInterval(Element rootNode) throws CertParsingException {
        List<String> contents = CertUtils.getXmlNodeContents(1, rootNode, METADATA_NODE_TAG, METADATA_REFRESH_INTERVAL_NODE_TAG);
        return Long.parseLong(contents.get(0));
    }

    private static List<X509Certificate> parseIntermediateCerts(Element rootNode) throws CertParsingException {
        List<String> contents = CertUtils.getXmlNodeContents(0, rootNode, INTERMEDIATE_CERT_LIST_TAG, "cert");
        ArrayList<X509Certificate> res = new ArrayList<X509Certificate>();
        for (String content : contents) {
            res.add(CertUtils.decodeCert(CertUtils.decodeBase64(content)));
        }
        return Collections.unmodifiableList(res);
    }

    private static List<X509Certificate> parseEndpointCerts(Element rootNode) throws CertParsingException {
        List<String> contents = CertUtils.getXmlNodeContents(2, rootNode, ENDPOINT_CERT_LIST_TAG, "cert");
        ArrayList<X509Certificate> res = new ArrayList<X509Certificate>();
        for (String content : contents) {
            res.add(CertUtils.decodeCert(CertUtils.decodeBase64(content)));
        }
        return Collections.unmodifiableList(res);
    }
}

