/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.certificate;

import com.android.internal.annotations.VisibleForTesting;
import com.android.server.locksettings.recoverablekeystore.certificate.CertParsingException;
import com.android.server.locksettings.recoverablekeystore.certificate.CertValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CertUtils {
    private static final String CERT_FORMAT = "X.509";
    private static final String CERT_PATH_ALG = "PKIX";
    private static final String CERT_STORE_ALG = "Collection";
    private static final String SIGNATURE_ALG = "SHA256withRSA";
    static final int MUST_EXIST_UNENFORCED = 0;
    static final int MUST_EXIST_EXACTLY_ONE = 1;
    static final int MUST_EXIST_AT_LEAST_ONE = 2;

    private CertUtils() {
    }

    static X509Certificate decodeCert(byte[] certBytes) throws CertParsingException {
        return CertUtils.decodeCert(new ByteArrayInputStream(certBytes));
    }

    static X509Certificate decodeCert(InputStream inStream) throws CertParsingException {
        CertificateFactory certFactory;
        try {
            certFactory = CertificateFactory.getInstance(CERT_FORMAT);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        try {
            return (X509Certificate)certFactory.generateCertificate(inStream);
        }
        catch (CertificateException e) {
            throw new CertParsingException(e);
        }
    }

    static Element getXmlRootNode(byte[] xmlBytes) throws CertParsingException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
            document.getDocumentElement().normalize();
            return document.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CertParsingException(e);
        }
    }

    static List<String> getXmlNodeContents(int mustExist, Element rootNode, String ... nodeTags) throws CertParsingException {
        NodeList nodeList;
        String expression = String.join((CharSequence)"/", nodeTags);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            nodeList = (NodeList)xPath.compile(expression).evaluate(rootNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new CertParsingException(e);
        }
        switch (mustExist) {
            case 0: {
                break;
            }
            case 1: {
                if (nodeList.getLength() == 1) break;
                throw new CertParsingException("The XML file must contain exactly one node with the path " + expression);
            }
            case 2: {
                if (nodeList.getLength() != 0) break;
                throw new CertParsingException("The XML file must contain at least one node with the path " + expression);
            }
            default: {
                throw new UnsupportedOperationException("This value of MustExist is not supported: " + mustExist);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            result.add(node.getTextContent().replaceAll("\\s", ""));
        }
        return result;
    }

    public static byte[] decodeBase64(String str) throws CertParsingException {
        try {
            return Base64.getDecoder().decode(str);
        }
        catch (IllegalArgumentException e) {
            throw new CertParsingException(e);
        }
    }

    static void verifyRsaSha256Signature(PublicKey signerPublicKey, byte[] signature, byte[] signedBytes) throws CertValidationException {
        Signature verifier;
        try {
            verifier = Signature.getInstance(SIGNATURE_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            verifier.initVerify(signerPublicKey);
            verifier.update(signedBytes);
            if (!verifier.verify(signature)) {
                throw new CertValidationException("The signature is invalid");
            }
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new CertValidationException(e);
        }
    }

    static CertPath validateCert(Date validationDate, X509Certificate trustedRoot, List<X509Certificate> intermediateCerts, X509Certificate leafCert) throws CertValidationException {
        CertPathValidator certPathValidator;
        PKIXParameters pkixParams = CertUtils.buildPkixParams(validationDate, trustedRoot, intermediateCerts, leafCert);
        CertPath certPath = CertUtils.buildCertPath(pkixParams);
        try {
            certPathValidator = CertPathValidator.getInstance(CERT_PATH_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            certPathValidator.validate(certPath, pkixParams);
        }
        catch (InvalidAlgorithmParameterException | CertPathValidatorException e) {
            throw new CertValidationException(e);
        }
        return certPath;
    }

    public static void validateCertPath(X509Certificate trustedRoot, CertPath certPath) throws CertValidationException {
        CertUtils.validateCertPath(null, trustedRoot, certPath);
    }

    @VisibleForTesting
    static void validateCertPath(Date validationDate, X509Certificate trustedRoot, CertPath certPath) throws CertValidationException {
        if (certPath.getCertificates().isEmpty()) {
            throw new CertValidationException("The given certificate path is empty");
        }
        if (!(certPath.getCertificates().get(0) instanceof X509Certificate)) {
            throw new CertValidationException("The given certificate path does not contain X509 certificates");
        }
        List<? extends Certificate> certificates = certPath.getCertificates();
        X509Certificate leafCert = (X509Certificate)certificates.get(0);
        List<? extends Certificate> intermediateCerts = certificates.subList(1, certificates.size());
        CertUtils.validateCert(validationDate, trustedRoot, intermediateCerts, leafCert);
    }

    @VisibleForTesting
    static CertPath buildCertPath(PKIXParameters pkixParams) throws CertValidationException {
        CertPathBuilder certPathBuilder;
        try {
            certPathBuilder = CertPathBuilder.getInstance(CERT_PATH_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            return certPathBuilder.build(pkixParams).getCertPath();
        }
        catch (InvalidAlgorithmParameterException | CertPathBuilderException e) {
            throw new CertValidationException(e);
        }
    }

    @VisibleForTesting
    static PKIXParameters buildPkixParams(Date validationDate, X509Certificate trustedRoot, List<X509Certificate> intermediateCerts, X509Certificate leafCert) throws CertValidationException {
        PKIXBuilderParameters pkixParams;
        CertStore certStore;
        HashSet<TrustAnchor> trustedAnchors = new HashSet<TrustAnchor>();
        trustedAnchors.add(new TrustAnchor(trustedRoot, null));
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(intermediateCerts);
        certs.add(leafCert);
        try {
            certStore = CertStore.getInstance(CERT_STORE_ALG, new CollectionCertStoreParameters(certs));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertValidationException(e);
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(leafCert);
        try {
            pkixParams = new PKIXBuilderParameters(trustedAnchors, (CertSelector)certSelector);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertValidationException(e);
        }
        pkixParams.addCertStore(certStore);
        pkixParams.setDate(validationDate);
        pkixParams.setRevocationEnabled(false);
        return pkixParams;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MustExist {
    }
}

