/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.content.Context;
import android.content.pm.UserInfo;
import android.hardware.weaver.V1_0.IWeaver;
import android.hardware.weaver.V1_0.WeaverConfig;
import android.os.RemoteException;
import android.os.UserManager;
import android.service.gatekeeper.GateKeeperResponse;
import android.service.gatekeeper.IGateKeeperService;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.ICheckCredentialProgressCallback;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.locksettings.LockSettingsStorage;
import com.android.server.locksettings.SyntheticPasswordCrypto;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import libcore.util.HexEncoding;

public class SyntheticPasswordManager {
    private static final String SP_BLOB_NAME = "spblob";
    private static final String SP_E0_NAME = "e0";
    private static final String SP_P1_NAME = "p1";
    private static final String SP_HANDLE_NAME = "handle";
    private static final String SECDISCARDABLE_NAME = "secdis";
    private static final int SECDISCARDABLE_LENGTH = 16384;
    private static final String PASSWORD_DATA_NAME = "pwd";
    private static final String WEAVER_SLOT_NAME = "weaver";
    public static final long DEFAULT_HANDLE = 0L;
    private static final String DEFAULT_PASSWORD = "default-password";
    private static final byte WEAVER_VERSION = 1;
    private static final int INVALID_WEAVER_SLOT = -1;
    private static final byte SYNTHETIC_PASSWORD_VERSION_V1 = 1;
    private static final byte SYNTHETIC_PASSWORD_VERSION = 2;
    private static final byte SYNTHETIC_PASSWORD_PASSWORD_BASED = 0;
    private static final byte SYNTHETIC_PASSWORD_TOKEN_BASED = 1;
    private static final byte SYNTHETIC_PASSWORD_LENGTH = 32;
    private static final int PASSWORD_SCRYPT_N = 11;
    private static final int PASSWORD_SCRYPT_R = 3;
    private static final int PASSWORD_SCRYPT_P = 1;
    private static final int PASSWORD_SALT_LENGTH = 16;
    private static final int PASSWORD_TOKEN_LENGTH = 32;
    private static final String TAG = "SyntheticPasswordManager";
    private static final byte[] PERSONALISATION_SECDISCARDABLE = "secdiscardable-transform".getBytes();
    private static final byte[] PERSONALIZATION_KEY_STORE_PASSWORD = "keystore-password".getBytes();
    private static final byte[] PERSONALIZATION_USER_GK_AUTH = "user-gk-authentication".getBytes();
    private static final byte[] PERSONALIZATION_SP_GK_AUTH = "sp-gk-authentication".getBytes();
    private static final byte[] PERSONALIZATION_FBE_KEY = "fbe-key".getBytes();
    private static final byte[] PERSONALIZATION_AUTHSECRET_KEY = "authsecret-hal".getBytes();
    private static final byte[] PERSONALIZATION_SP_SPLIT = "sp-split".getBytes();
    private static final byte[] PERSONALIZATION_PASSWORD_HASH = "pw-hash".getBytes();
    private static final byte[] PERSONALIZATION_E0 = "e0-encryption".getBytes();
    private static final byte[] PERSONALISATION_WEAVER_PASSWORD = "weaver-pwd".getBytes();
    private static final byte[] PERSONALISATION_WEAVER_KEY = "weaver-key".getBytes();
    private static final byte[] PERSONALISATION_WEAVER_TOKEN = "weaver-token".getBytes();
    private final Context mContext;
    private LockSettingsStorage mStorage;
    private IWeaver mWeaver;
    private WeaverConfig mWeaverConfig;
    private final UserManager mUserManager;
    private ArrayMap<Integer, ArrayMap<Long, TokenData>> tokenMap = new ArrayMap();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public SyntheticPasswordManager(Context context, LockSettingsStorage storage, UserManager userManager) {
        this.mContext = context;
        this.mStorage = storage;
        this.mUserManager = userManager;
    }

    @VisibleForTesting
    protected IWeaver getWeaverService() throws RemoteException {
        try {
            return IWeaver.getService();
        }
        catch (NoSuchElementException e) {
            Slog.i(TAG, "Device does not support weaver");
            return null;
        }
    }

    public synchronized void initWeaverService() {
        if (this.mWeaver != null) {
            return;
        }
        try {
            this.mWeaverConfig = null;
            this.mWeaver = this.getWeaverService();
            if (this.mWeaver != null) {
                this.mWeaver.getConfig((status, config) -> {
                    if (status == 0 && config.slots > 0) {
                        this.mWeaverConfig = config;
                    } else {
                        Slog.e(TAG, "Failed to get weaver config, status " + status + " slots: " + config.slots);
                        this.mWeaver = null;
                    }
                });
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to get weaver service", e);
        }
    }

    private synchronized boolean isWeaverAvailable() {
        if (this.mWeaver == null) {
            this.initWeaverService();
        }
        return this.mWeaver != null && this.mWeaverConfig.slots > 0;
    }

    private byte[] weaverEnroll(int slot, byte[] key, byte[] value) throws RemoteException {
        int writeStatus;
        if (slot == -1 || slot >= this.mWeaverConfig.slots) {
            throw new RuntimeException("Invalid slot for weaver");
        }
        if (key == null) {
            key = new byte[this.mWeaverConfig.keySize];
        } else if (key.length != this.mWeaverConfig.keySize) {
            throw new RuntimeException("Invalid key size for weaver");
        }
        if (value == null) {
            value = SyntheticPasswordManager.secureRandom(this.mWeaverConfig.valueSize);
        }
        if ((writeStatus = this.mWeaver.write(slot, SyntheticPasswordManager.toByteArrayList(key), SyntheticPasswordManager.toByteArrayList(value))) != 0) {
            Log.e(TAG, "weaver write failed, slot: " + slot + " status: " + writeStatus);
            return null;
        }
        return value;
    }

    private VerifyCredentialResponse weaverVerify(int slot, byte[] key) throws RemoteException {
        if (slot == -1 || slot >= this.mWeaverConfig.slots) {
            throw new RuntimeException("Invalid slot for weaver");
        }
        if (key == null) {
            key = new byte[this.mWeaverConfig.keySize];
        } else if (key.length != this.mWeaverConfig.keySize) {
            throw new RuntimeException("Invalid key size for weaver");
        }
        VerifyCredentialResponse[] response = new VerifyCredentialResponse[1];
        this.mWeaver.read(slot, SyntheticPasswordManager.toByteArrayList(key), (status, readResponse) -> {
            switch (status) {
                case 0: {
                    response[0] = new VerifyCredentialResponse(SyntheticPasswordManager.fromByteArrayList(readResponse.value));
                    break;
                }
                case 3: {
                    response[0] = new VerifyCredentialResponse(readResponse.timeout);
                    Log.e(TAG, "weaver read failed (THROTTLE), slot: " + slot);
                    break;
                }
                case 2: {
                    if (readResponse.timeout == 0) {
                        response[0] = VerifyCredentialResponse.ERROR;
                        Log.e(TAG, "weaver read failed (INCORRECT_KEY), slot: " + slot);
                        break;
                    }
                    response[0] = new VerifyCredentialResponse(readResponse.timeout);
                    Log.e(TAG, "weaver read failed (INCORRECT_KEY/THROTTLE), slot: " + slot);
                    break;
                }
                case 1: {
                    response[0] = VerifyCredentialResponse.ERROR;
                    Log.e(TAG, "weaver read failed (FAILED), slot: " + slot);
                    break;
                }
                default: {
                    response[0] = VerifyCredentialResponse.ERROR;
                    Log.e(TAG, "weaver read unknown status " + status + ", slot: " + slot);
                }
            }
        });
        return response[0];
    }

    public void removeUser(int userId) {
        for (long handle : this.mStorage.listSyntheticPasswordHandlesForUser(SP_BLOB_NAME, userId)) {
            this.destroyWeaverSlot(handle, userId);
            this.destroySPBlobKey(this.getHandleName(handle));
        }
    }

    public int getCredentialType(long handle, int userId) {
        byte[] passwordData = this.loadState(PASSWORD_DATA_NAME, handle, userId);
        if (passwordData == null) {
            Log.w(TAG, "getCredentialType: encountered empty password data for user " + userId);
            return -1;
        }
        return PasswordData.fromBytes((byte[])passwordData).passwordType;
    }

    public AuthenticationToken newSyntheticPasswordAndSid(IGateKeeperService gatekeeper, byte[] hash, String credential, int userId) throws RemoteException {
        AuthenticationToken result = AuthenticationToken.create();
        if (hash != null) {
            GateKeeperResponse response = gatekeeper.enroll(userId, hash, credential.getBytes(), result.deriveGkPassword());
            if (response.getResponseCode() != 0) {
                Log.w(TAG, "Fail to migrate SID, assuming no SID, user " + userId);
                this.clearSidForUser(userId);
            } else {
                this.saveSyntheticPasswordHandle(response.getPayload(), userId);
            }
        } else {
            this.clearSidForUser(userId);
        }
        this.saveEscrowData(result, userId);
        return result;
    }

    public void newSidForUser(IGateKeeperService gatekeeper, AuthenticationToken authToken, int userId) throws RemoteException {
        GateKeeperResponse response = gatekeeper.enroll(userId, null, null, authToken.deriveGkPassword());
        if (response.getResponseCode() != 0) {
            Log.e(TAG, "Fail to create new SID for user " + userId);
            return;
        }
        this.saveSyntheticPasswordHandle(response.getPayload(), userId);
    }

    public void clearSidForUser(int userId) {
        this.destroyState(SP_HANDLE_NAME, 0L, userId);
    }

    public boolean hasSidForUser(int userId) {
        return this.hasState(SP_HANDLE_NAME, 0L, userId);
    }

    private byte[] loadSyntheticPasswordHandle(int userId) {
        return this.loadState(SP_HANDLE_NAME, 0L, userId);
    }

    private void saveSyntheticPasswordHandle(byte[] spHandle, int userId) {
        this.saveState(SP_HANDLE_NAME, spHandle, 0L, userId);
    }

    private boolean loadEscrowData(AuthenticationToken authToken, int userId) {
        AuthenticationToken.access$702(authToken, this.loadState(SP_E0_NAME, 0L, userId));
        AuthenticationToken.access$802(authToken, this.loadState(SP_P1_NAME, 0L, userId));
        return authToken.E0 != null && authToken.P1 != null;
    }

    private void saveEscrowData(AuthenticationToken authToken, int userId) {
        this.saveState(SP_E0_NAME, authToken.E0, 0L, userId);
        this.saveState(SP_P1_NAME, authToken.P1, 0L, userId);
    }

    public boolean hasEscrowData(int userId) {
        return this.hasState(SP_E0_NAME, 0L, userId) && this.hasState(SP_P1_NAME, 0L, userId);
    }

    public void destroyEscrowData(int userId) {
        this.destroyState(SP_E0_NAME, 0L, userId);
        this.destroyState(SP_P1_NAME, 0L, userId);
    }

    private int loadWeaverSlot(long handle, int userId) {
        int LENGTH = 5;
        byte[] data = this.loadState(WEAVER_SLOT_NAME, handle, userId);
        if (data == null || data.length != 5) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put(data, 0, data.length);
        buffer.flip();
        if (buffer.get() != 1) {
            Log.e(TAG, "Invalid weaver slot version of handle " + handle);
            return -1;
        }
        return buffer.getInt();
    }

    private void saveWeaverSlot(int slot, long handle, int userId) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put((byte)1);
        buffer.putInt(slot);
        this.saveState(WEAVER_SLOT_NAME, buffer.array(), handle, userId);
    }

    private void destroyWeaverSlot(long handle, int userId) {
        int slot = this.loadWeaverSlot(handle, userId);
        this.destroyState(WEAVER_SLOT_NAME, handle, userId);
        if (slot != -1) {
            Set<Integer> usedSlots = this.getUsedWeaverSlots();
            if (!usedSlots.contains(slot)) {
                Log.i(TAG, "Destroy weaver slot " + slot + " for user " + userId);
                try {
                    this.weaverEnroll(slot, null, null);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to destroy slot", e);
                }
            } else {
                Log.w(TAG, "Skip destroying reused weaver slot " + slot + " for user " + userId);
            }
        }
    }

    private Set<Integer> getUsedWeaverSlots() {
        Map<Integer, List<Long>> slotHandles = this.mStorage.listSyntheticPasswordHandlesForAllUsers(WEAVER_SLOT_NAME);
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Map.Entry<Integer, List<Long>> entry : slotHandles.entrySet()) {
            for (Long handle : entry.getValue()) {
                int slot = this.loadWeaverSlot(handle, entry.getKey());
                slots.add(slot);
            }
        }
        return slots;
    }

    private int getNextAvailableWeaverSlot() {
        Set<Integer> usedSlots = this.getUsedWeaverSlots();
        for (int i = 0; i < this.mWeaverConfig.slots; ++i) {
            if (usedSlots.contains(i)) continue;
            return i;
        }
        throw new RuntimeException("Run out of weaver slots.");
    }

    public long createPasswordBasedSyntheticPassword(IGateKeeperService gatekeeper, String credential, int credentialType, AuthenticationToken authToken, int requestedQuality, int userId) throws RemoteException {
        byte[] applicationId;
        long sid;
        if (credential == null || credentialType == -1) {
            credentialType = -1;
            credential = DEFAULT_PASSWORD;
        }
        long handle = SyntheticPasswordManager.generateHandle();
        PasswordData pwd = PasswordData.create(credentialType);
        byte[] pwdToken = this.computePasswordToken(credential, pwd);
        if (this.isWeaverAvailable()) {
            int weaverSlot = this.getNextAvailableWeaverSlot();
            Log.i(TAG, "Weaver enroll password to slot " + weaverSlot + " for user " + userId);
            byte[] weaverSecret = this.weaverEnroll(weaverSlot, this.passwordTokenToWeaverKey(pwdToken), null);
            if (weaverSecret == null) {
                Log.e(TAG, "Fail to enroll user password under weaver " + userId);
                return 0L;
            }
            this.saveWeaverSlot(weaverSlot, handle, userId);
            this.synchronizeWeaverFrpPassword(pwd, requestedQuality, userId, weaverSlot);
            pwd.passwordHandle = null;
            sid = 0L;
            applicationId = this.transformUnderWeaverSecret(pwdToken, weaverSecret);
        } else {
            gatekeeper.clearSecureUserId(this.fakeUid(userId));
            GateKeeperResponse response = gatekeeper.enroll(this.fakeUid(userId), null, null, this.passwordTokenToGkInput(pwdToken));
            if (response.getResponseCode() != 0) {
                Log.e(TAG, "Fail to enroll user password when creating SP for user " + userId);
                return 0L;
            }
            pwd.passwordHandle = response.getPayload();
            sid = this.sidFromPasswordHandle(pwd.passwordHandle);
            applicationId = this.transformUnderSecdiscardable(pwdToken, this.createSecdiscardable(handle, userId));
            this.synchronizeFrpPassword(pwd, requestedQuality, userId);
        }
        this.saveState(PASSWORD_DATA_NAME, pwd.toBytes(), handle, userId);
        this.createSyntheticPasswordBlob(handle, (byte)0, authToken, applicationId, sid, userId);
        return handle;
    }

    public VerifyCredentialResponse verifyFrpCredential(IGateKeeperService gatekeeper, String userCredential, int credentialType, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        LockSettingsStorage.PersistentData persistentData = this.mStorage.readPersistentDataBlock();
        if (persistentData.type == 1) {
            PasswordData pwd = PasswordData.fromBytes(persistentData.payload);
            byte[] pwdToken = this.computePasswordToken(userCredential, pwd);
            GateKeeperResponse response = gatekeeper.verifyChallenge(this.fakeUid(persistentData.userId), 0L, pwd.passwordHandle, this.passwordTokenToGkInput(pwdToken));
            return VerifyCredentialResponse.fromGateKeeperResponse(response);
        }
        if (persistentData.type == 2) {
            PasswordData pwd = PasswordData.fromBytes(persistentData.payload);
            byte[] pwdToken = this.computePasswordToken(userCredential, pwd);
            int weaverSlot = persistentData.userId;
            return this.weaverVerify(weaverSlot, this.passwordTokenToWeaverKey(pwdToken)).stripPayload();
        }
        Log.e(TAG, "persistentData.type must be TYPE_SP or TYPE_SP_WEAVER, but is " + persistentData.type);
        return VerifyCredentialResponse.ERROR;
    }

    public void migrateFrpPasswordLocked(long handle, UserInfo userInfo, int requestedQuality) {
        if (this.mStorage.getPersistentDataBlock() != null && LockPatternUtils.userOwnsFrpCredential(this.mContext, userInfo)) {
            PasswordData pwd = PasswordData.fromBytes(this.loadState(PASSWORD_DATA_NAME, handle, userInfo.id));
            if (pwd.passwordType != -1) {
                int weaverSlot = this.loadWeaverSlot(handle, userInfo.id);
                if (weaverSlot != -1) {
                    this.synchronizeWeaverFrpPassword(pwd, requestedQuality, userInfo.id, weaverSlot);
                } else {
                    this.synchronizeFrpPassword(pwd, requestedQuality, userInfo.id);
                }
            }
        }
    }

    private void synchronizeFrpPassword(PasswordData pwd, int requestedQuality, int userId) {
        if (this.mStorage.getPersistentDataBlock() != null && LockPatternUtils.userOwnsFrpCredential(this.mContext, this.mUserManager.getUserInfo(userId))) {
            if (pwd.passwordType != -1) {
                this.mStorage.writePersistentDataBlock(1, userId, requestedQuality, pwd.toBytes());
            } else {
                this.mStorage.writePersistentDataBlock(0, userId, 0, null);
            }
        }
    }

    private void synchronizeWeaverFrpPassword(PasswordData pwd, int requestedQuality, int userId, int weaverSlot) {
        if (this.mStorage.getPersistentDataBlock() != null && LockPatternUtils.userOwnsFrpCredential(this.mContext, this.mUserManager.getUserInfo(userId))) {
            if (pwd.passwordType != -1) {
                this.mStorage.writePersistentDataBlock(2, weaverSlot, requestedQuality, pwd.toBytes());
            } else {
                this.mStorage.writePersistentDataBlock(0, 0, 0, null);
            }
        }
    }

    public long createTokenBasedSyntheticPassword(byte[] token, int userId) {
        long handle = SyntheticPasswordManager.generateHandle();
        if (!this.tokenMap.containsKey(userId)) {
            this.tokenMap.put(userId, new ArrayMap());
        }
        TokenData tokenData = new TokenData();
        byte[] secdiscardable = SyntheticPasswordManager.secureRandom(16384);
        if (this.isWeaverAvailable()) {
            tokenData.weaverSecret = SyntheticPasswordManager.secureRandom(this.mWeaverConfig.valueSize);
            tokenData.secdiscardableOnDisk = SyntheticPasswordCrypto.encrypt(tokenData.weaverSecret, PERSONALISATION_WEAVER_TOKEN, secdiscardable);
        } else {
            tokenData.secdiscardableOnDisk = secdiscardable;
            tokenData.weaverSecret = null;
        }
        tokenData.aggregatedSecret = this.transformUnderSecdiscardable(token, secdiscardable);
        this.tokenMap.get(userId).put(handle, tokenData);
        return handle;
    }

    public Set<Long> getPendingTokensForUser(int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return Collections.emptySet();
        }
        return this.tokenMap.get(userId).keySet();
    }

    public boolean removePendingToken(long handle, int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return false;
        }
        return this.tokenMap.get(userId).remove(handle) != null;
    }

    public boolean activateTokenBasedSyntheticPassword(long handle, AuthenticationToken authToken, int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return false;
        }
        TokenData tokenData = this.tokenMap.get(userId).get(handle);
        if (tokenData == null) {
            return false;
        }
        if (!this.loadEscrowData(authToken, userId)) {
            Log.w(TAG, "User is not escrowable");
            return false;
        }
        if (this.isWeaverAvailable()) {
            int slot = this.getNextAvailableWeaverSlot();
            try {
                Log.i(TAG, "Weaver enroll token to slot " + slot + " for user " + userId);
                this.weaverEnroll(slot, null, tokenData.weaverSecret);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to enroll weaver secret when activating token", e);
                return false;
            }
            this.saveWeaverSlot(slot, handle, userId);
        }
        this.saveSecdiscardable(handle, tokenData.secdiscardableOnDisk, userId);
        this.createSyntheticPasswordBlob(handle, (byte)1, authToken, tokenData.aggregatedSecret, 0L, userId);
        this.tokenMap.get(userId).remove(handle);
        return true;
    }

    private void createSyntheticPasswordBlob(long handle, byte type, AuthenticationToken authToken, byte[] applicationId, long sid, int userId) {
        byte[] secret = type == 1 ? authToken.computeP0() : authToken.syntheticPassword.getBytes();
        byte[] content = this.createSPBlob(this.getHandleName(handle), secret, applicationId, sid);
        byte[] blob = new byte[content.length + 1 + 1];
        blob[0] = 2;
        blob[1] = type;
        System.arraycopy((byte[])content, (int)0, (byte[])blob, (int)2, (int)content.length);
        this.saveState(SP_BLOB_NAME, blob, handle, userId);
    }

    public AuthenticationResult unwrapPasswordBasedSyntheticPassword(IGateKeeperService gatekeeper, long handle, String credential, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        byte[] applicationId;
        long sid;
        if (credential == null) {
            credential = DEFAULT_PASSWORD;
        }
        AuthenticationResult result = new AuthenticationResult();
        PasswordData pwd = PasswordData.fromBytes(this.loadState(PASSWORD_DATA_NAME, handle, userId));
        result.credentialType = pwd.passwordType;
        byte[] pwdToken = this.computePasswordToken(credential, pwd);
        int weaverSlot = this.loadWeaverSlot(handle, userId);
        if (weaverSlot != -1) {
            if (!this.isWeaverAvailable()) {
                Log.e(TAG, "No weaver service to unwrap password based SP");
                result.gkResponse = VerifyCredentialResponse.ERROR;
                return result;
            }
            result.gkResponse = this.weaverVerify(weaverSlot, this.passwordTokenToWeaverKey(pwdToken));
            if (result.gkResponse.getResponseCode() != 0) {
                return result;
            }
            sid = 0L;
            applicationId = this.transformUnderWeaverSecret(pwdToken, result.gkResponse.getPayload());
        } else {
            byte[] gkPwdToken = this.passwordTokenToGkInput(pwdToken);
            GateKeeperResponse response = gatekeeper.verifyChallenge(this.fakeUid(userId), 0L, pwd.passwordHandle, gkPwdToken);
            int responseCode = response.getResponseCode();
            if (responseCode == 0) {
                result.gkResponse = VerifyCredentialResponse.OK;
                if (response.getShouldReEnroll()) {
                    GateKeeperResponse reenrollResponse = gatekeeper.enroll(this.fakeUid(userId), pwd.passwordHandle, gkPwdToken, gkPwdToken);
                    if (reenrollResponse.getResponseCode() == 0) {
                        pwd.passwordHandle = reenrollResponse.getPayload();
                        this.saveState(PASSWORD_DATA_NAME, pwd.toBytes(), handle, userId);
                        this.synchronizeFrpPassword(pwd, pwd.passwordType == 1 ? 65536 : 327680, userId);
                    } else {
                        Log.w(TAG, "Fail to re-enroll user password for user " + userId);
                    }
                }
            } else {
                if (responseCode == 1) {
                    result.gkResponse = new VerifyCredentialResponse(response.getTimeout());
                    return result;
                }
                result.gkResponse = VerifyCredentialResponse.ERROR;
                return result;
            }
            sid = this.sidFromPasswordHandle(pwd.passwordHandle);
            applicationId = this.transformUnderSecdiscardable(pwdToken, this.loadSecdiscardable(handle, userId));
        }
        if (progressCallback != null) {
            progressCallback.onCredentialVerified();
        }
        result.authToken = this.unwrapSyntheticPasswordBlob(handle, (byte)0, applicationId, sid, userId);
        result.gkResponse = this.verifyChallenge(gatekeeper, result.authToken, 0L, userId);
        return result;
    }

    public AuthenticationResult unwrapTokenBasedSyntheticPassword(IGateKeeperService gatekeeper, long handle, byte[] token, int userId) throws RemoteException {
        AuthenticationResult result = new AuthenticationResult();
        byte[] secdiscardable = this.loadSecdiscardable(handle, userId);
        int slotId = this.loadWeaverSlot(handle, userId);
        if (slotId != -1) {
            if (!this.isWeaverAvailable()) {
                Log.e(TAG, "No weaver service to unwrap token based SP");
                result.gkResponse = VerifyCredentialResponse.ERROR;
                return result;
            }
            VerifyCredentialResponse response = this.weaverVerify(slotId, null);
            if (response.getResponseCode() != 0 || response.getPayload() == null) {
                Log.e(TAG, "Failed to retrieve weaver secret when unwrapping token");
                result.gkResponse = VerifyCredentialResponse.ERROR;
                return result;
            }
            secdiscardable = SyntheticPasswordCrypto.decrypt(response.getPayload(), PERSONALISATION_WEAVER_TOKEN, secdiscardable);
        }
        byte[] applicationId = this.transformUnderSecdiscardable(token, secdiscardable);
        result.authToken = this.unwrapSyntheticPasswordBlob(handle, (byte)1, applicationId, 0L, userId);
        if (result.authToken != null) {
            result.gkResponse = this.verifyChallenge(gatekeeper, result.authToken, 0L, userId);
            if (result.gkResponse == null) {
                result.gkResponse = VerifyCredentialResponse.OK;
            }
        } else {
            result.gkResponse = VerifyCredentialResponse.ERROR;
        }
        return result;
    }

    private AuthenticationToken unwrapSyntheticPasswordBlob(long handle, byte type, byte[] applicationId, long sid, int userId) {
        byte[] blob = this.loadState(SP_BLOB_NAME, handle, userId);
        if (blob == null) {
            return null;
        }
        byte version = blob[0];
        if (version != 2 && version != 1) {
            throw new RuntimeException("Unknown blob version");
        }
        if (blob[1] != type) {
            throw new RuntimeException("Invalid blob type");
        }
        byte[] secret = version == 1 ? SyntheticPasswordCrypto.decryptBlobV1(this.getHandleName(handle), Arrays.copyOfRange(blob, 2, blob.length), applicationId) : this.decryptSPBlob(this.getHandleName(handle), Arrays.copyOfRange(blob, 2, blob.length), applicationId);
        if (secret == null) {
            Log.e(TAG, "Fail to decrypt SP for user " + userId);
            return null;
        }
        AuthenticationToken result = new AuthenticationToken();
        if (type == 1) {
            if (!this.loadEscrowData(result, userId)) {
                Log.e(TAG, "User is not escrowable: " + userId);
                return null;
            }
            result.recreate(secret);
        } else {
            result.syntheticPassword = new String(secret);
        }
        if (version == 1) {
            Log.i(TAG, "Upgrade v1 SP blob for user " + userId + ", type = " + type);
            this.createSyntheticPasswordBlob(handle, type, result, applicationId, sid, userId);
        }
        return result;
    }

    public VerifyCredentialResponse verifyChallenge(IGateKeeperService gatekeeper, AuthenticationToken auth, long challenge, int userId) throws RemoteException {
        VerifyCredentialResponse result;
        byte[] spHandle = this.loadSyntheticPasswordHandle(userId);
        if (spHandle == null) {
            return null;
        }
        GateKeeperResponse response = gatekeeper.verifyChallenge(userId, challenge, spHandle, auth.deriveGkPassword());
        int responseCode = response.getResponseCode();
        if (responseCode == 0) {
            result = new VerifyCredentialResponse(response.getPayload());
            if (response.getShouldReEnroll()) {
                response = gatekeeper.enroll(userId, spHandle, spHandle, auth.deriveGkPassword());
                if (response.getResponseCode() == 0) {
                    spHandle = response.getPayload();
                    this.saveSyntheticPasswordHandle(spHandle, userId);
                    return this.verifyChallenge(gatekeeper, auth, challenge, userId);
                }
                Log.w(TAG, "Fail to re-enroll SP handle for user " + userId);
            }
        } else {
            result = responseCode == 1 ? new VerifyCredentialResponse(response.getTimeout()) : VerifyCredentialResponse.ERROR;
        }
        return result;
    }

    public boolean existsHandle(long handle, int userId) {
        return this.hasState(SP_BLOB_NAME, handle, userId);
    }

    public void destroyTokenBasedSyntheticPassword(long handle, int userId) {
        this.destroySyntheticPassword(handle, userId);
        this.destroyState(SECDISCARDABLE_NAME, handle, userId);
    }

    public void destroyPasswordBasedSyntheticPassword(long handle, int userId) {
        this.destroySyntheticPassword(handle, userId);
        this.destroyState(SECDISCARDABLE_NAME, handle, userId);
        this.destroyState(PASSWORD_DATA_NAME, handle, userId);
    }

    private void destroySyntheticPassword(long handle, int userId) {
        this.destroyState(SP_BLOB_NAME, handle, userId);
        this.destroySPBlobKey(this.getHandleName(handle));
        if (this.hasState(WEAVER_SLOT_NAME, handle, userId)) {
            this.destroyWeaverSlot(handle, userId);
        }
    }

    private byte[] transformUnderWeaverSecret(byte[] data, byte[] secret) {
        byte[] weaverSecret = SyntheticPasswordCrypto.personalisedHash(PERSONALISATION_WEAVER_PASSWORD, new byte[][]{secret});
        byte[] result = new byte[data.length + weaverSecret.length];
        System.arraycopy((byte[])data, (int)0, (byte[])result, (int)0, (int)data.length);
        System.arraycopy((byte[])weaverSecret, (int)0, (byte[])result, (int)data.length, (int)weaverSecret.length);
        return result;
    }

    private byte[] transformUnderSecdiscardable(byte[] data, byte[] rawSecdiscardable) {
        byte[] secdiscardable = SyntheticPasswordCrypto.personalisedHash(PERSONALISATION_SECDISCARDABLE, new byte[][]{rawSecdiscardable});
        byte[] result = new byte[data.length + secdiscardable.length];
        System.arraycopy((byte[])data, (int)0, (byte[])result, (int)0, (int)data.length);
        System.arraycopy((byte[])secdiscardable, (int)0, (byte[])result, (int)data.length, (int)secdiscardable.length);
        return result;
    }

    private byte[] createSecdiscardable(long handle, int userId) {
        byte[] data = SyntheticPasswordManager.secureRandom(16384);
        this.saveSecdiscardable(handle, data, userId);
        return data;
    }

    private void saveSecdiscardable(long handle, byte[] secdiscardable, int userId) {
        this.saveState(SECDISCARDABLE_NAME, secdiscardable, handle, userId);
    }

    private byte[] loadSecdiscardable(long handle, int userId) {
        return this.loadState(SECDISCARDABLE_NAME, handle, userId);
    }

    private boolean hasState(String stateName, long handle, int userId) {
        return !ArrayUtils.isEmpty(this.loadState(stateName, handle, userId));
    }

    private byte[] loadState(String stateName, long handle, int userId) {
        return this.mStorage.readSyntheticPasswordState(userId, handle, stateName);
    }

    private void saveState(String stateName, byte[] data, long handle, int userId) {
        this.mStorage.writeSyntheticPasswordState(userId, handle, stateName, data);
    }

    private void destroyState(String stateName, long handle, int userId) {
        this.mStorage.deleteSyntheticPasswordState(userId, handle, stateName);
    }

    protected byte[] decryptSPBlob(String blobKeyName, byte[] blob, byte[] applicationId) {
        return SyntheticPasswordCrypto.decryptBlob(blobKeyName, blob, applicationId);
    }

    protected byte[] createSPBlob(String blobKeyName, byte[] data, byte[] applicationId, long sid) {
        return SyntheticPasswordCrypto.createBlob(blobKeyName, data, applicationId, sid);
    }

    protected void destroySPBlobKey(String keyAlias) {
        SyntheticPasswordCrypto.destroyBlobKey(keyAlias);
    }

    public static long generateHandle() {
        long result;
        SecureRandom rng = new SecureRandom();
        while ((result = rng.nextLong()) == 0L) {
        }
        return result;
    }

    private int fakeUid(int uid) {
        return 100000 + uid;
    }

    protected static byte[] secureRandom(int length) {
        try {
            return SecureRandom.getInstance("SHA1PRNG").generateSeed(length);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getHandleName(long handle) {
        return String.format("%s%x", "synthetic_password_", handle);
    }

    private byte[] computePasswordToken(String password, PasswordData data) {
        return this.scrypt(password, data.salt, 1 << data.scryptN, 1 << data.scryptR, 1 << data.scryptP, 32);
    }

    private byte[] passwordTokenToGkInput(byte[] token) {
        return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_USER_GK_AUTH, new byte[][]{token});
    }

    private byte[] passwordTokenToWeaverKey(byte[] token) {
        byte[] key = SyntheticPasswordCrypto.personalisedHash(PERSONALISATION_WEAVER_KEY, new byte[][]{token});
        if (key.length < this.mWeaverConfig.keySize) {
            throw new RuntimeException("weaver key length too small");
        }
        return Arrays.copyOf(key, this.mWeaverConfig.keySize);
    }

    protected long sidFromPasswordHandle(byte[] handle) {
        return this.nativeSidFromPasswordHandle(handle);
    }

    protected byte[] scrypt(String password, byte[] salt, int N, int r, int p, int outLen) {
        return this.nativeScrypt(password.getBytes(), salt, N, r, p, outLen);
    }

    native long nativeSidFromPasswordHandle(byte[] var1);

    native byte[] nativeScrypt(byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    protected static ArrayList<Byte> toByteArrayList(byte[] data) {
        ArrayList<Byte> result = new ArrayList<Byte>(data.length);
        for (int i = 0; i < data.length; ++i) {
            result.add(data[i]);
        }
        return result;
    }

    protected static byte[] fromByteArrayList(ArrayList<Byte> data) {
        byte[] result = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            result[i] = data.get(i);
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static class TokenData {
        byte[] secdiscardableOnDisk;
        byte[] weaverSecret;
        byte[] aggregatedSecret;

        TokenData() {
        }
    }

    static class PasswordData {
        byte scryptN;
        byte scryptR;
        byte scryptP;
        public int passwordType;
        byte[] salt;
        public byte[] passwordHandle;

        PasswordData() {
        }

        public static PasswordData create(int passwordType) {
            PasswordData result = new PasswordData();
            result.scryptN = (byte)11;
            result.scryptR = (byte)3;
            result.scryptP = 1;
            result.passwordType = passwordType;
            result.salt = SyntheticPasswordManager.secureRandom(16);
            return result;
        }

        public static PasswordData fromBytes(byte[] data) {
            PasswordData result = new PasswordData();
            ByteBuffer buffer = ByteBuffer.allocate(data.length);
            buffer.put(data, 0, data.length);
            buffer.flip();
            result.passwordType = buffer.getInt();
            result.scryptN = buffer.get();
            result.scryptR = buffer.get();
            result.scryptP = buffer.get();
            int saltLen = buffer.getInt();
            result.salt = new byte[saltLen];
            buffer.get(result.salt);
            int handleLen = buffer.getInt();
            if (handleLen > 0) {
                result.passwordHandle = new byte[handleLen];
                buffer.get(result.passwordHandle);
            } else {
                result.passwordHandle = null;
            }
            return result;
        }

        public byte[] toBytes() {
            ByteBuffer buffer = ByteBuffer.allocate(11 + this.salt.length + 4 + (this.passwordHandle != null ? this.passwordHandle.length : 0));
            buffer.putInt(this.passwordType);
            buffer.put(this.scryptN);
            buffer.put(this.scryptR);
            buffer.put(this.scryptP);
            buffer.putInt(this.salt.length);
            buffer.put(this.salt);
            if (this.passwordHandle != null && this.passwordHandle.length > 0) {
                buffer.putInt(this.passwordHandle.length);
                buffer.put(this.passwordHandle);
            } else {
                buffer.putInt(0);
            }
            return buffer.array();
        }
    }

    static class AuthenticationToken {
        private byte[] E0;
        private byte[] P1;
        private String syntheticPassword;

        AuthenticationToken() {
        }

        public String deriveKeyStorePassword() {
            return SyntheticPasswordManager.bytesToHex(SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_KEY_STORE_PASSWORD, new byte[][]{this.syntheticPassword.getBytes()}));
        }

        public byte[] deriveGkPassword() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_SP_GK_AUTH, new byte[][]{this.syntheticPassword.getBytes()});
        }

        public byte[] deriveDiskEncryptionKey() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_FBE_KEY, new byte[][]{this.syntheticPassword.getBytes()});
        }

        public byte[] deriveVendorAuthSecret() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_AUTHSECRET_KEY, new byte[][]{this.syntheticPassword.getBytes()});
        }

        public byte[] derivePasswordHashFactor() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_PASSWORD_HASH, new byte[][]{this.syntheticPassword.getBytes()});
        }

        private void initialize(byte[] P0, byte[] P1) {
            this.P1 = P1;
            this.syntheticPassword = String.valueOf(HexEncoding.encode(SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_SP_SPLIT, P0, P1)));
            this.E0 = SyntheticPasswordCrypto.encrypt(this.syntheticPassword.getBytes(), PERSONALIZATION_E0, P0);
        }

        public void recreate(byte[] secret) {
            this.initialize(secret, this.P1);
        }

        protected static AuthenticationToken create() {
            AuthenticationToken result = new AuthenticationToken();
            result.initialize(SyntheticPasswordManager.secureRandom(32), SyntheticPasswordManager.secureRandom(32));
            return result;
        }

        public byte[] computeP0() {
            if (this.E0 == null) {
                return null;
            }
            return SyntheticPasswordCrypto.decrypt(this.syntheticPassword.getBytes(), PERSONALIZATION_E0, this.E0);
        }

        static /* synthetic */ byte[] access$702(AuthenticationToken x0, byte[] x1) {
            x0.E0 = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$802(AuthenticationToken x0, byte[] x1) {
            x0.P1 = x1;
            return x1;
        }
    }

    static class AuthenticationResult {
        public AuthenticationToken authToken;
        public VerifyCredentialResponse gkResponse;
        public int credentialType;

        AuthenticationResult() {
        }
    }
}

