/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.util.Log;
import android.util.NtpTrustedTime;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.location.ExponentialBackOff;
import java.util.Date;

class NtpTimeHelper {
    private static final String TAG = "NtpTimeHelper";
    private static final boolean DEBUG = Log.isLoggable("NtpTimeHelper", 3);
    private static final int STATE_PENDING_NETWORK = 0;
    private static final int STATE_RETRIEVING_AND_INJECTING = 1;
    private static final int STATE_IDLE = 2;
    @VisibleForTesting
    static final long NTP_INTERVAL = 86400000L;
    @VisibleForTesting
    static final long RETRY_INTERVAL = 300000L;
    private static final long MAX_RETRY_INTERVAL = 14400000L;
    private static final long WAKELOCK_TIMEOUT_MILLIS = 60000L;
    private static final String WAKELOCK_KEY = "NtpTimeHelper";
    private final ExponentialBackOff mNtpBackOff = new ExponentialBackOff(300000L, 14400000L);
    private final ConnectivityManager mConnMgr;
    private final NtpTrustedTime mNtpTime;
    private final PowerManager.WakeLock mWakeLock;
    private final Handler mHandler;
    @GuardedBy(value="this")
    private final InjectNtpTimeCallback mCallback;
    @GuardedBy(value="this")
    private int mInjectNtpTimeState = 0;
    @GuardedBy(value="this")
    private boolean mOnDemandTimeInjection;

    @VisibleForTesting
    NtpTimeHelper(Context context, Looper looper, InjectNtpTimeCallback callback, NtpTrustedTime ntpTime) {
        this.mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        this.mCallback = callback;
        this.mNtpTime = ntpTime;
        this.mHandler = new Handler(looper);
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "NtpTimeHelper");
    }

    NtpTimeHelper(Context context, Looper looper, InjectNtpTimeCallback callback) {
        this(context, looper, callback, NtpTrustedTime.getInstance(context));
    }

    synchronized void enablePeriodicTimeInjection() {
        this.mOnDemandTimeInjection = true;
    }

    synchronized void onNetworkAvailable() {
        if (this.mInjectNtpTimeState == 0) {
            this.retrieveAndInjectNtpTime();
        }
    }

    private boolean isNetworkConnected() {
        NetworkInfo activeNetworkInfo = this.mConnMgr.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    synchronized void retrieveAndInjectNtpTime() {
        if (this.mInjectNtpTimeState == 1) {
            return;
        }
        if (!this.isNetworkConnected()) {
            this.mInjectNtpTimeState = 0;
            return;
        }
        this.mInjectNtpTimeState = 1;
        this.mWakeLock.acquire(60000L);
        new Thread(this::blockingGetNtpTimeAndInject).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingGetNtpTimeAndInject() {
        boolean refreshSuccess = true;
        if (this.mNtpTime.getCacheAge() >= 86400000L) {
            refreshSuccess = this.mNtpTime.forceRefresh();
        }
        NtpTimeHelper ntpTimeHelper = this;
        synchronized (ntpTimeHelper) {
            long delay;
            this.mInjectNtpTimeState = 2;
            if (this.mNtpTime.getCacheAge() < 86400000L) {
                long time = this.mNtpTime.getCachedNtpTime();
                long timeReference = this.mNtpTime.getCachedNtpTimeReference();
                long certainty = this.mNtpTime.getCacheCertainty();
                if (DEBUG) {
                    long now = System.currentTimeMillis();
                    Log.d("NtpTimeHelper", "NTP server returned: " + time + " (" + new Date(time) + ") reference: " + timeReference + " certainty: " + certainty + " system time offset: " + (time - now));
                }
                this.mHandler.post(() -> this.mCallback.injectTime(time, timeReference, (int)certainty));
                delay = 86400000L;
                this.mNtpBackOff.reset();
            } else {
                Log.e("NtpTimeHelper", "requestTime failed");
                delay = this.mNtpBackOff.nextBackoffMillis();
            }
            if (DEBUG) {
                Log.d("NtpTimeHelper", String.format("onDemandTimeInjection=%s, refreshSuccess=%s, delay=%s", this.mOnDemandTimeInjection, refreshSuccess, delay));
            }
            if (this.mOnDemandTimeInjection || !refreshSuccess) {
                this.mHandler.postDelayed(this::retrieveAndInjectNtpTime, delay);
            }
        }
        try {
            this.mWakeLock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface InjectNtpTimeCallback {
        public void injectTime(long var1, long var3, int var5);
    }
}

