/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

class GnssSatelliteBlacklistHelper {
    private static final String TAG = "GnssBlacklistHelper";
    private static final boolean DEBUG = Log.isLoggable("GnssBlacklistHelper", 3);
    private static final String BLACKLIST_DELIMITER = ",";
    private final Context mContext;
    private final GnssSatelliteBlacklistCallback mCallback;

    GnssSatelliteBlacklistHelper(Context context, Looper looper, GnssSatelliteBlacklistCallback callback) {
        this.mContext = context;
        this.mCallback = callback;
        ContentObserver contentObserver = new ContentObserver(new Handler(looper)){

            @Override
            public void onChange(boolean selfChange) {
                GnssSatelliteBlacklistHelper.this.updateSatelliteBlacklist();
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("gnss_satellite_blacklist"), true, contentObserver, -1);
    }

    void updateSatelliteBlacklist() {
        List<Integer> blacklistValues;
        ContentResolver resolver = this.mContext.getContentResolver();
        String blacklist = Settings.Global.getString(resolver, "gnss_satellite_blacklist");
        if (blacklist == null) {
            blacklist = "";
        }
        if (DEBUG) {
            Log.d(TAG, String.format("Update GNSS satellite blacklist: %s", blacklist));
        }
        try {
            blacklistValues = GnssSatelliteBlacklistHelper.parseSatelliteBlacklist(blacklist);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Exception thrown when parsing blacklist string.", e);
            return;
        }
        if (blacklistValues.size() % 2 != 0) {
            Log.e(TAG, "blacklist string has odd number of values.Aborting updateSatelliteBlacklist");
            return;
        }
        int length = blacklistValues.size() / 2;
        int[] constellations = new int[length];
        int[] svids = new int[length];
        for (int i = 0; i < length; ++i) {
            constellations[i] = blacklistValues.get(i * 2);
            svids[i] = blacklistValues.get(i * 2 + 1);
        }
        this.mCallback.onUpdateSatelliteBlacklist(constellations, svids);
    }

    @VisibleForTesting
    static List<Integer> parseSatelliteBlacklist(String blacklist) throws NumberFormatException {
        String[] strings = blacklist.split(BLACKLIST_DELIMITER);
        ArrayList<Integer> parsed = new ArrayList<Integer>(strings.length);
        for (String string2 : strings) {
            if ("".equals(string2 = string2.trim())) continue;
            int value = Integer.parseInt(string2);
            if (value < 0) {
                throw new NumberFormatException("Negative value is invalid.");
            }
            parsed.add(value);
        }
        return parsed;
    }

    static interface GnssSatelliteBlacklistCallback {
        public void onUpdateSatelliteBlacklist(int[] var1, int[] var2);
    }
}

