/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.lights;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Trace;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.SystemService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;

public class LightsService
extends SystemService {
    static final String TAG = "LightsService";
    static final boolean DEBUG = false;
    final LightImpl[] mLights = new LightImpl[8];
    private final LightsManager mService = new LightsManager(){

        @Override
        public Light getLight(int id2) {
            if (0 <= id2 && id2 < 8) {
                return LightsService.this.mLights[id2];
            }
            return null;
        }
    };
    private Handler mH = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            LightImpl light = (LightImpl)msg.obj;
            light.stopFlashing();
        }
    };

    public LightsService(Context context) {
        super(context);
        for (int i = 0; i < 8; ++i) {
            this.mLights[i] = new LightImpl(i);
        }
    }

    @Override
    public void onStart() {
        this.publishLocalService(LightsManager.class, this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
    }

    private int getVrDisplayMode() {
        int currentUser = ActivityManager.getCurrentUser();
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "vr_display_mode", 0, currentUser);
    }

    static native void setLight_native(int var0, int var1, int var2, int var3, int var4, int var5);

    private final class LightImpl
    extends Light {
        private int mId;
        private int mColor;
        private int mMode;
        private int mOnMS;
        private int mOffMS;
        private boolean mFlashing;
        private int mBrightnessMode;
        private int mLastBrightnessMode;
        private int mLastColor;
        private boolean mVrModeEnabled;
        private boolean mUseLowPersistenceForVR;
        private boolean mInitialized;

        private LightImpl(int id2) {
            this.mId = id2;
        }

        @Override
        public void setBrightness(int brightness) {
            this.setBrightness(brightness, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBrightness(int brightness, int brightnessMode) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                if (brightnessMode == 2) {
                    Slog.w(LightsService.TAG, "setBrightness with LOW_PERSISTENCE unexpected #" + this.mId + ": brightness=0x" + Integer.toHexString(brightness));
                    return;
                }
                int color2 = brightness & 0xFF;
                color2 = 0xFF000000 | color2 << 16 | color2 << 8 | color2;
                this.setLightLocked(color2, 0, 0, 0, brightnessMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColor(int color2) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(color2, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlashing(int color2, int mode, int onMS, int offMS) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(color2, mode, onMS, offMS, 0);
            }
        }

        @Override
        public void pulse() {
            this.pulse(0xFFFFFF, 7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pulse(int color2, int onMS) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                if (this.mColor == 0 && !this.mFlashing) {
                    this.setLightLocked(color2, 2, onMS, 1000, 0);
                    this.mColor = 0;
                    LightsService.this.mH.sendMessageDelayed(Message.obtain(LightsService.this.mH, 1, this), onMS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void turnOff() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(0, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVrMode(boolean enabled) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                if (this.mVrModeEnabled != enabled) {
                    this.mVrModeEnabled = enabled;
                    boolean bl = this.mUseLowPersistenceForVR = LightsService.this.getVrDisplayMode() == 0;
                    if (this.shouldBeInLowPersistenceMode()) {
                        this.mLastBrightnessMode = this.mBrightnessMode;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopFlashing() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(this.mColor, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setLightLocked(int color2, int mode, int onMS, int offMS, int brightnessMode) {
            if (this.shouldBeInLowPersistenceMode()) {
                brightnessMode = 2;
            } else if (brightnessMode == 2) {
                brightnessMode = this.mLastBrightnessMode;
            }
            if (!this.mInitialized || color2 != this.mColor || mode != this.mMode || onMS != this.mOnMS || offMS != this.mOffMS || this.mBrightnessMode != brightnessMode) {
                this.mInitialized = true;
                this.mLastColor = this.mColor;
                this.mColor = color2;
                this.mMode = mode;
                this.mOnMS = onMS;
                this.mOffMS = offMS;
                this.mBrightnessMode = brightnessMode;
                Trace.traceBegin(131072L, "setLight(" + this.mId + ", 0x" + Integer.toHexString(color2) + ")");
                try {
                    LightsService.setLight_native(this.mId, color2, mode, onMS, offMS, brightnessMode);
                }
                finally {
                    Trace.traceEnd(131072L);
                }
            }
        }

        private boolean shouldBeInLowPersistenceMode() {
            return this.mVrModeEnabled && this.mUseLowPersistenceForVR;
        }
    }
}

