/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AlarmManager;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public final class TimeController
extends StateController {
    private static final String TAG = "JobScheduler.Time";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Time", 3);
    private final String DEADLINE_TAG = "*job.deadline*";
    private final String DELAY_TAG = "*job.delay*";
    private long mNextJobExpiredElapsedMillis;
    private long mNextDelayExpiredElapsedMillis;
    private final boolean mChainedAttributionEnabled;
    private AlarmManager mAlarmService = null;
    private final List<JobStatus> mTrackedJobs = new LinkedList<JobStatus>();
    private final AlarmManager.OnAlarmListener mDeadlineExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            if (DEBUG) {
                Slog.d(TimeController.TAG, "Deadline-expired alarm fired");
            }
            TimeController.this.checkExpiredDeadlinesAndResetAlarm();
        }
    };
    private final AlarmManager.OnAlarmListener mNextDelayExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            if (DEBUG) {
                Slog.d(TimeController.TAG, "Delay-expired alarm fired");
            }
            TimeController.this.checkExpiredDelaysAndResetAlarm();
        }
    };

    public TimeController(JobSchedulerService service) {
        super(service);
        this.mNextJobExpiredElapsedMillis = Long.MAX_VALUE;
        this.mNextDelayExpiredElapsedMillis = Long.MAX_VALUE;
        this.mChainedAttributionEnabled = WorkSource.isChainedBatteryAttributionEnabled(this.mContext);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus job, JobStatus lastJob) {
        if (job.hasTimingDelayConstraint() || job.hasDeadlineConstraint()) {
            this.maybeStopTrackingJobLocked(job, null, false);
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (job.hasDeadlineConstraint() && this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                return;
            }
            if (job.hasTimingDelayConstraint() && this.evaluateTimingDelayConstraint(job, nowElapsedMillis) && !job.hasDeadlineConstraint()) {
                return;
            }
            boolean isInsert = false;
            ListIterator<JobStatus> it = this.mTrackedJobs.listIterator(this.mTrackedJobs.size());
            while (it.hasPrevious()) {
                JobStatus ts = it.previous();
                if (ts.getLatestRunTimeElapsed() >= job.getLatestRunTimeElapsed()) continue;
                isInsert = true;
                break;
            }
            if (isInsert) {
                it.next();
            }
            it.add(job);
            job.setTrackingController(32);
            this.maybeUpdateAlarmsLocked(job.hasTimingDelayConstraint() ? job.getEarliestRunTime() : Long.MAX_VALUE, job.hasDeadlineConstraint() ? job.getLatestRunTimeElapsed() : Long.MAX_VALUE, this.deriveWorkSource(job.getSourceUid(), job.getSourcePackageName()));
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus job, JobStatus incomingJob, boolean forUpdate) {
        if (job.clearTrackingController(32) && this.mTrackedJobs.remove(job)) {
            this.checkExpiredDelaysAndResetAlarm();
            this.checkExpiredDeadlinesAndResetAlarm();
        }
    }

    private boolean canStopTrackingJobLocked(JobStatus job) {
        return !(job.hasTimingDelayConstraint() && (job.satisfiedConstraints & Integer.MIN_VALUE) == 0 || job.hasDeadlineConstraint() && (job.satisfiedConstraints & 0x40000000) == 0);
    }

    private void ensureAlarmServiceLocked() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiredDeadlinesAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nextExpiryTime = Long.MAX_VALUE;
            int nextExpiryUid = 0;
            String nextExpiryPackageName = null;
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            Iterator<JobStatus> it = this.mTrackedJobs.iterator();
            while (it.hasNext()) {
                JobStatus job = it.next();
                if (!job.hasDeadlineConstraint()) continue;
                if (this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                    this.mStateChangedListener.onRunJobNow(job);
                    it.remove();
                    continue;
                }
                nextExpiryTime = job.getLatestRunTimeElapsed();
                nextExpiryUid = job.getSourceUid();
                nextExpiryPackageName = job.getSourcePackageName();
                break;
            }
            this.setDeadlineExpiredAlarmLocked(nextExpiryTime, this.deriveWorkSource(nextExpiryUid, nextExpiryPackageName));
        }
    }

    private boolean evaluateDeadlineConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDeadline = job.getLatestRunTimeElapsed();
        if (jobDeadline <= nowElapsedMillis) {
            if (job.hasTimingDelayConstraint()) {
                job.setTimingDelayConstraintSatisfied(true);
            }
            job.setDeadlineConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiredDelaysAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            long nextDelayTime = Long.MAX_VALUE;
            int nextDelayUid = 0;
            String nextDelayPackageName = null;
            boolean ready = false;
            Iterator<JobStatus> it = this.mTrackedJobs.iterator();
            while (it.hasNext()) {
                long jobDelayTime;
                JobStatus job = it.next();
                if (!job.hasTimingDelayConstraint()) continue;
                if (this.evaluateTimingDelayConstraint(job, nowElapsedMillis)) {
                    if (this.canStopTrackingJobLocked(job)) {
                        it.remove();
                    }
                    if (!job.isReady()) continue;
                    ready = true;
                    continue;
                }
                if (job.isConstraintSatisfied(Integer.MIN_VALUE) || nextDelayTime <= (jobDelayTime = job.getEarliestRunTime())) continue;
                nextDelayTime = jobDelayTime;
                nextDelayUid = job.getSourceUid();
                nextDelayPackageName = job.getSourcePackageName();
            }
            if (ready) {
                this.mStateChangedListener.onControllerStateChanged();
            }
            this.setDelayExpiredAlarmLocked(nextDelayTime, this.deriveWorkSource(nextDelayUid, nextDelayPackageName));
        }
    }

    private WorkSource deriveWorkSource(int uid, String packageName) {
        if (this.mChainedAttributionEnabled) {
            WorkSource ws = new WorkSource();
            ws.createWorkChain().addNode(uid, packageName).addNode(1000, "JobScheduler");
            return ws;
        }
        return packageName == null ? new WorkSource(uid) : new WorkSource(uid, packageName);
    }

    private boolean evaluateTimingDelayConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDelayTime = job.getEarliestRunTime();
        if (jobDelayTime <= nowElapsedMillis) {
            job.setTimingDelayConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    private void maybeUpdateAlarmsLocked(long delayExpiredElapsed, long deadlineExpiredElapsed, WorkSource ws) {
        if (delayExpiredElapsed < this.mNextDelayExpiredElapsedMillis) {
            this.setDelayExpiredAlarmLocked(delayExpiredElapsed, ws);
        }
        if (deadlineExpiredElapsed < this.mNextJobExpiredElapsedMillis) {
            this.setDeadlineExpiredAlarmLocked(deadlineExpiredElapsed, ws);
        }
    }

    private void setDelayExpiredAlarmLocked(long alarmTimeElapsedMillis, WorkSource ws) {
        this.mNextDelayExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithListenerLocked("*job.delay*", this.mNextDelayExpiredListener, this.mNextDelayExpiredElapsedMillis, ws);
    }

    private void setDeadlineExpiredAlarmLocked(long alarmTimeElapsedMillis, WorkSource ws) {
        this.mNextJobExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithListenerLocked("*job.deadline*", this.mDeadlineExpiredListener, this.mNextJobExpiredElapsedMillis, ws);
    }

    private long maybeAdjustAlarmTime(long proposedAlarmTimeElapsedMillis) {
        long earliestWakeupTimeElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        if (proposedAlarmTimeElapsedMillis < earliestWakeupTimeElapsed) {
            return earliestWakeupTimeElapsed;
        }
        return proposedAlarmTimeElapsedMillis;
    }

    private void updateAlarmWithListenerLocked(String tag, AlarmManager.OnAlarmListener listener, long alarmTimeElapsed, WorkSource ws) {
        this.ensureAlarmServiceLocked();
        if (alarmTimeElapsed == Long.MAX_VALUE) {
            this.mAlarmService.cancel(listener);
        } else {
            if (DEBUG) {
                Slog.d(TAG, "Setting " + tag + " for: " + alarmTimeElapsed);
            }
            this.mAlarmService.set(2, alarmTimeElapsed, -1L, 0L, tag, listener, null, ws);
        }
    }

    @Override
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        pw.println("Elapsed clock: " + nowElapsed);
        pw.print("Next delay alarm in ");
        TimeUtils.formatDuration(this.mNextDelayExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.print("Next deadline alarm in ");
        TimeUtils.formatDuration(this.mNextJobExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.println();
        for (JobStatus ts : this.mTrackedJobs) {
            if (!predicate.test(ts)) continue;
            pw.print("#");
            ts.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, ts.getSourceUid());
            pw.print(": Delay=");
            if (ts.hasTimingDelayConstraint()) {
                TimeUtils.formatDuration(ts.getEarliestRunTime(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.print(", Deadline=");
            if (ts.hasDeadlineConstraint()) {
                TimeUtils.formatDuration(ts.getLatestRunTimeElapsed(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.println();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268040L);
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        proto.write(0x10300000001L, nowElapsed);
        proto.write(1112396529666L, this.mNextDelayExpiredElapsedMillis - nowElapsed);
        proto.write(0x10300000003L, this.mNextJobExpiredElapsedMillis - nowElapsed);
        for (JobStatus ts : this.mTrackedJobs) {
            if (!predicate.test(ts)) continue;
            long tsToken = proto.start(2246267895812L);
            ts.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1133871366147L, ts.hasTimingDelayConstraint());
            proto.write(1112396529668L, ts.getEarliestRunTime() - nowElapsed);
            proto.write(1133871366149L, ts.hasDeadlineConstraint());
            proto.write(1112396529670L, ts.getLatestRunTimeElapsed() - nowElapsed);
            proto.end(tsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }
}

