/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkPolicyManager;
import android.net.NetworkRequest;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.Objects;
import java.util.function.Predicate;

public final class ConnectivityController
extends StateController
implements ConnectivityManager.OnNetworkActiveListener {
    private static final String TAG = "JobScheduler.Connectivity";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Connectivity", 3);
    private final ConnectivityManager mConnManager;
    private final NetworkPolicyManager mNetPolicyManager;
    @GuardedBy(value="mLock")
    private final ArraySet<JobStatus> mTrackedJobs = new ArraySet();
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities capabilities) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onCapabilitiesChanged: " + network);
            }
            ConnectivityController.this.updateTrackedJobs(-1, network);
        }

        @Override
        public void onLost(Network network) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onLost: " + network);
            }
            ConnectivityController.this.updateTrackedJobs(-1, network);
        }
    };
    private final INetworkPolicyListener mNetPolicyListener = new NetworkPolicyManager.Listener(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onUidRulesChanged: " + uid);
            }
            ConnectivityController.this.updateTrackedJobs(uid, null);
        }
    };

    public ConnectivityController(JobSchedulerService service) {
        super(service);
        this.mConnManager = this.mContext.getSystemService(ConnectivityManager.class);
        this.mNetPolicyManager = this.mContext.getSystemService(NetworkPolicyManager.class);
        NetworkRequest request = new NetworkRequest.Builder().clearCapabilities().build();
        this.mConnManager.registerNetworkCallback(request, this.mNetworkCallback);
        this.mNetPolicyManager.registerListener(this.mNetPolicyListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (jobStatus.hasConnectivityConstraint()) {
            this.updateConstraintsSatisfied(jobStatus);
            this.mTrackedJobs.add(jobStatus);
            jobStatus.setTrackingController(2);
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.clearTrackingController(2)) {
            this.mTrackedJobs.remove(jobStatus);
        }
    }

    private static boolean isInsane(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        long estimatedBytes = jobStatus.getEstimatedNetworkBytes();
        if (estimatedBytes == -1L) {
            return false;
        }
        long slowest = NetworkCapabilities.minBandwidth(capabilities.getLinkDownstreamBandwidthKbps(), capabilities.getLinkUpstreamBandwidthKbps());
        if (slowest == 0L) {
            return false;
        }
        long estimatedMillis = estimatedBytes * 1000L / (slowest * 1024L / 8L);
        if (estimatedMillis > 600000L) {
            Slog.w(TAG, "Estimated " + estimatedBytes + " bytes over " + slowest + " kbps network would take " + estimatedMillis + "ms; that's insane!");
            return true;
        }
        return false;
    }

    private static boolean isCongestionDelayed(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (!capabilities.hasCapability(20)) {
            return jobStatus.getFractionRunTime() < constants.CONN_CONGESTION_DELAY_FRAC;
        }
        return false;
    }

    private static boolean isStrictSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        return jobStatus.getJob().getRequiredNetwork().networkCapabilities.satisfiedByNetworkCapabilities(capabilities);
    }

    private static boolean isRelaxedSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (!jobStatus.getJob().isPrefetch()) {
            return false;
        }
        NetworkCapabilities relaxed = new NetworkCapabilities(jobStatus.getJob().getRequiredNetwork().networkCapabilities).removeCapability(11);
        if (relaxed.satisfiedByNetworkCapabilities(capabilities)) {
            return jobStatus.getFractionRunTime() > constants.CONN_PREFETCH_RELAX_FRAC;
        }
        return false;
    }

    @VisibleForTesting
    static boolean isSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (network == null || capabilities == null) {
            return false;
        }
        if (ConnectivityController.isInsane(jobStatus, network, capabilities, constants)) {
            return false;
        }
        if (ConnectivityController.isCongestionDelayed(jobStatus, network, capabilities, constants)) {
            return false;
        }
        if (ConnectivityController.isStrictSatisfied(jobStatus, network, capabilities, constants)) {
            return true;
        }
        return ConnectivityController.isRelaxedSatisfied(jobStatus, network, capabilities, constants);
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus) {
        Network network = this.mConnManager.getActiveNetworkForUid(jobStatus.getSourceUid());
        NetworkCapabilities capabilities = this.mConnManager.getNetworkCapabilities(network);
        return this.updateConstraintsSatisfied(jobStatus, network, capabilities);
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        boolean ignoreBlocked = (jobStatus.getFlags() & 1) != 0;
        NetworkInfo info = this.mConnManager.getNetworkInfoForUid(network, jobStatus.getSourceUid(), ignoreBlocked);
        boolean connected = info != null && info.isConnected();
        boolean satisfied = ConnectivityController.isSatisfied(jobStatus, network, capabilities, this.mConstants);
        boolean changed = jobStatus.setConnectivityConstraintSatisfied(connected && satisfied);
        jobStatus.network = network;
        if (DEBUG) {
            Slog.i(TAG, "Connectivity " + (changed ? "CHANGED" : "unchanged") + " for " + jobStatus + ": connected=" + connected + " satisfied=" + satisfied);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrackedJobs(int filterUid, Network filterNetwork) {
        Object object = this.mLock;
        synchronized (object) {
            SparseArray<Network> uidToNetwork = new SparseArray<Network>();
            SparseArray<NetworkCapabilities> networkToCapabilities = new SparseArray<NetworkCapabilities>();
            boolean changed = false;
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                boolean forceUpdate;
                boolean uidMatch;
                JobStatus js = this.mTrackedJobs.valueAt(i);
                int uid = js.getSourceUid();
                boolean bl = uidMatch = filterUid == -1 || filterUid == uid;
                if (!uidMatch) continue;
                Network network = (Network)uidToNetwork.get(uid);
                if (network == null) {
                    network = this.mConnManager.getActiveNetworkForUid(uid);
                    uidToNetwork.put(uid, network);
                }
                boolean networkMatch = filterNetwork == null || Objects.equals(filterNetwork, network);
                boolean bl2 = forceUpdate = !Objects.equals(js.network, network);
                if (!networkMatch && !forceUpdate) continue;
                int netId = network != null ? network.netId : -1;
                NetworkCapabilities capabilities = (NetworkCapabilities)networkToCapabilities.get(netId);
                if (capabilities == null) {
                    capabilities = this.mConnManager.getNetworkCapabilities(network);
                    networkToCapabilities.put(netId, capabilities);
                }
                changed |= this.updateConstraintsSatisfied(js, network, capabilities);
            }
            if (changed) {
                this.mStateChangedListener.onControllerStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkActive() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                JobStatus js = this.mTrackedJobs.valueAt(i);
                if (!js.isReady()) continue;
                if (DEBUG) {
                    Slog.d(TAG, "Running " + js + " due to network activity.");
                }
                this.mStateChangedListener.onRunJobNow(js);
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.valueAt(i);
            if (!predicate.test(js)) continue;
            pw.print("#");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.print(": ");
            pw.print(js.getJob().getRequiredNetwork());
            pw.println();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268035L);
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.valueAt(i);
            if (!predicate.test(js)) continue;
            long jsToken = proto.start(0x20B00000002L);
            js.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, js.getSourceUid());
            NetworkRequest rn = js.getJob().getRequiredNetwork();
            if (rn != null) {
                rn.writeToProto(proto, 1146756268035L);
            }
            proto.end(jsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }
}

