/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.PendingIntent;
import android.app.SynchronousUserSwitchObserver;
import android.app.TaskStackListener;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.hardware.biometrics.IBiometricPromptReceiver;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprintClientCallback;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintClientActiveCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceLockoutResetCallback;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.KeyStore;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.SystemService;
import com.android.server.fingerprint.AuthenticationClient;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.EnrollClient;
import com.android.server.fingerprint.EnumerateClient;
import com.android.server.fingerprint.FingerprintUtils;
import com.android.server.fingerprint.InternalEnumerateClient;
import com.android.server.fingerprint.InternalRemovalClient;
import com.android.server.fingerprint.RemovalClient;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FingerprintService
extends SystemService
implements IHwBinder.DeathRecipient {
    static final String TAG = "FingerprintService";
    static final boolean DEBUG = true;
    private static final boolean CLEANUP_UNUSED_FP = true;
    private static final String FP_DATA_DIR = "fpdata";
    private static final int MSG_USER_SWITCHING = 10;
    private static final String ACTION_LOCKOUT_RESET = "com.android.server.fingerprint.ACTION_LOCKOUT_RESET";
    private static final String KEY_LOCKOUT_RESET_USER = "lockout_reset_user";
    private final ArrayList<FingerprintServiceLockoutResetMonitor> mLockoutMonitors = new ArrayList();
    private final CopyOnWriteArrayList<IFingerprintClientActiveCallback> mClientActiveCallbacks = new CopyOnWriteArrayList();
    private final Map<Integer, Long> mAuthenticatorIds = Collections.synchronizedMap(new HashMap());
    private final AppOpsManager mAppOps;
    private static final long FAIL_LOCKOUT_TIMEOUT_MS = 30000L;
    private static final int MAX_FAILED_ATTEMPTS_LOCKOUT_TIMED = 5;
    private static final int MAX_FAILED_ATTEMPTS_LOCKOUT_PERMANENT = 20;
    private static final long CANCEL_TIMEOUT_LIMIT = 3000L;
    private final String mKeyguardPackage;
    private int mCurrentUserId = -10000;
    private final FingerprintUtils mFingerprintUtils = FingerprintUtils.getInstance();
    private Context mContext;
    private long mHalDeviceId;
    private SparseBooleanArray mTimedLockoutCleared;
    private SparseIntArray mFailedAttempts;
    @GuardedBy(value="this")
    private IBiometricsFingerprint mDaemon;
    private IStatusBarService mStatusBarService;
    private final IActivityManager mActivityManager;
    private final PowerManager mPowerManager;
    private final AlarmManager mAlarmManager;
    private final UserManager mUserManager;
    private ClientMonitor mCurrentClient;
    private ClientMonitor mPendingClient;
    private PerformanceStats mPerformanceStats;
    private IBinder mToken = new Binder();
    private ArrayList<UserFingerprint> mUnknownFingerprints = new ArrayList();
    private HashMap<Integer, PerformanceStats> mPerformanceMap = new HashMap();
    private HashMap<Integer, PerformanceStats> mCryptoPerformanceMap = new HashMap();
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    FingerprintService.this.handleUserSwitching(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(FingerprintService.TAG, "Unknown message:" + msg.what);
                }
            }
        }
    };
    private final BroadcastReceiver mLockoutReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (FingerprintService.ACTION_LOCKOUT_RESET.equals(intent.getAction())) {
                int user = intent.getIntExtra(FingerprintService.KEY_LOCKOUT_RESET_USER, 0);
                FingerprintService.this.resetFailedAttemptsForUser(false, user);
            }
        }
    };
    private final Runnable mResetFailedAttemptsForCurrentUserRunnable = new Runnable(){

        @Override
        public void run() {
            FingerprintService.this.resetFailedAttemptsForUser(true, ActivityManager.getCurrentUser());
        }
    };
    private final Runnable mResetClientState = new Runnable(){

        @Override
        public void run() {
            Slog.w(FingerprintService.TAG, "Client " + (FingerprintService.this.mCurrentClient != null ? FingerprintService.this.mCurrentClient.getOwnerString() : "null") + " failed to respond to cancel, starting client " + (FingerprintService.this.mPendingClient != null ? FingerprintService.this.mPendingClient.getOwnerString() : "null"));
            FingerprintService.this.mCurrentClient = null;
            FingerprintService.this.startClient(FingerprintService.this.mPendingClient, false);
        }
    };
    private final TaskStackListener mTaskStackListener = new TaskStackListener(){

        @Override
        public void onTaskStackChanged() {
            try {
                String topPackage;
                if (!(FingerprintService.this.mCurrentClient instanceof AuthenticationClient)) {
                    return;
                }
                String currentClient = FingerprintService.this.mCurrentClient.getOwnerString();
                if (FingerprintService.this.isKeyguard(currentClient)) {
                    return;
                }
                List<ActivityManager.RunningTaskInfo> runningTasks = FingerprintService.this.mActivityManager.getTasks(1);
                if (!runningTasks.isEmpty() && !(topPackage = runningTasks.get((int)0).topActivity.getPackageName()).contentEquals(currentClient)) {
                    Slog.e(FingerprintService.TAG, "Stopping background authentication, top: " + topPackage + " currentClient: " + currentClient);
                    FingerprintService.this.mCurrentClient.stop(false);
                }
            }
            catch (RemoteException e) {
                Slog.e(FingerprintService.TAG, "Unable to get running tasks", e);
            }
        }
    };
    private IBiometricsFingerprintClientCallback mDaemonCallback = new IBiometricsFingerprintClientCallback.Stub(){

        @Override
        public void onEnrollResult(final long deviceId, final int fingerId, final int groupId, final int remaining) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleEnrollResult(deviceId, fingerId, groupId, remaining);
                }
            });
        }

        @Override
        public void onAcquired(final long deviceId, final int acquiredInfo, final int vendorCode) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleAcquired(deviceId, acquiredInfo, vendorCode);
                }
            });
        }

        @Override
        public void onAuthenticated(final long deviceId, final int fingerId, final int groupId, final ArrayList<Byte> token) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleAuthenticated(deviceId, fingerId, groupId, token);
                }
            });
        }

        @Override
        public void onError(final long deviceId, final int error, final int vendorCode) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleError(deviceId, error, vendorCode);
                }
            });
        }

        @Override
        public void onRemoved(final long deviceId, final int fingerId, final int groupId, final int remaining) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleRemoved(deviceId, fingerId, groupId, remaining);
                }
            });
        }

        @Override
        public void onEnumerate(final long deviceId, final int fingerId, final int groupId, final int remaining) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleEnumerate(deviceId, fingerId, groupId, remaining);
                }
            });
        }
    };

    public FingerprintService(Context context) {
        super(context);
        this.mContext = context;
        this.mKeyguardPackage = ComponentName.unflattenFromString(context.getResources().getString(17039692)).getPackageName();
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
        this.mAlarmManager = this.mContext.getSystemService(AlarmManager.class);
        this.mContext.registerReceiver(this.mLockoutReceiver, new IntentFilter(ACTION_LOCKOUT_RESET), "android.permission.RESET_FINGERPRINT_LOCKOUT", null);
        this.mUserManager = UserManager.get(this.mContext);
        this.mTimedLockoutCleared = new SparseBooleanArray();
        this.mFailedAttempts = new SparseIntArray();
        this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
        ActivityManager cfr_ignored_0 = (ActivityManager)context.getSystemService("activity");
        this.mActivityManager = ActivityManager.getService();
    }

    @Override
    public void serviceDied(long cookie) {
        Slog.v(TAG, "fingerprint HAL died");
        MetricsLogger.count(this.mContext, "fingerprintd_died", 1);
        this.handleError(this.mHalDeviceId, 1, 0);
    }

    public synchronized IBiometricsFingerprint getFingerprintDaemon() {
        if (this.mDaemon == null) {
            Slog.v(TAG, "mDaemon was null, reconnect to fingerprint");
            try {
                this.mDaemon = IBiometricsFingerprint.getService();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get biometric interface", e);
            }
            if (this.mDaemon == null) {
                Slog.w(TAG, "fingerprint HIDL not available");
                return null;
            }
            this.mDaemon.asBinder().linkToDeath(this, 0L);
            try {
                this.mHalDeviceId = this.mDaemon.setNotify(this.mDaemonCallback);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to open fingerprint HAL", e);
                this.mDaemon = null;
            }
            Slog.v(TAG, "Fingerprint HAL id: " + this.mHalDeviceId);
            if (this.mHalDeviceId != 0L) {
                this.loadAuthenticatorIds();
                this.updateActiveGroup(ActivityManager.getCurrentUser(), null);
                this.doFingerprintCleanupForUser(ActivityManager.getCurrentUser());
            } else {
                Slog.w(TAG, "Failed to open Fingerprint HAL!");
                MetricsLogger.count(this.mContext, "fingerprintd_openhal_error", 1);
                this.mDaemon = null;
            }
        }
        return this.mDaemon;
    }

    private void loadAuthenticatorIds() {
        long t = System.currentTimeMillis();
        this.mAuthenticatorIds.clear();
        for (UserInfo user : UserManager.get(this.mContext).getUsers(true)) {
            int userId = this.getUserOrWorkProfileId(null, user.id);
            if (this.mAuthenticatorIds.containsKey(userId)) continue;
            this.updateActiveGroup(userId, null);
        }
        t = System.currentTimeMillis() - t;
        if (t > 1000L) {
            Slog.w(TAG, "loadAuthenticatorIds() taking too long: " + t + "ms");
        }
    }

    private void doFingerprintCleanupForUser(int userId) {
        this.enumerateUser(userId);
    }

    private void clearEnumerateState() {
        Slog.v(TAG, "clearEnumerateState()");
        this.mUnknownFingerprints.clear();
    }

    private void enumerateUser(int userId) {
        Slog.v(TAG, "Enumerating user(" + userId + ")");
        boolean restricted = !this.hasPermission("android.permission.MANAGE_FINGERPRINT");
        this.startEnumerate(this.mToken, userId, null, restricted, true);
    }

    private void cleanupUnknownFingerprints() {
        if (!this.mUnknownFingerprints.isEmpty()) {
            UserFingerprint uf = this.mUnknownFingerprints.get(0);
            this.mUnknownFingerprints.remove(uf);
            boolean restricted = !this.hasPermission("android.permission.MANAGE_FINGERPRINT");
            this.startRemove(this.mToken, uf.f.getFingerId(), uf.f.getGroupId(), uf.userId, null, restricted, true);
        } else {
            this.clearEnumerateState();
        }
    }

    protected void handleEnumerate(long deviceId, int fingerId, int groupId, int remaining) {
        ClientMonitor client = this.mCurrentClient;
        if (!(client instanceof InternalRemovalClient) && !(client instanceof EnumerateClient)) {
            return;
        }
        client.onEnumerationResult(fingerId, groupId, remaining);
        if (remaining == 0) {
            if (client instanceof InternalEnumerateClient) {
                List<Fingerprint> unknownFingerprints = ((InternalEnumerateClient)client).getUnknownFingerprints();
                if (!unknownFingerprints.isEmpty()) {
                    Slog.w(TAG, "Adding " + unknownFingerprints.size() + " fingerprints for deletion");
                }
                for (Fingerprint f : unknownFingerprints) {
                    this.mUnknownFingerprints.add(new UserFingerprint(f, client.getTargetUserId()));
                }
                this.removeClient(client);
                this.cleanupUnknownFingerprints();
            } else {
                this.removeClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleError(long deviceId, int error, int vendorCode) {
        ClientMonitor client = this.mCurrentClient;
        if (client instanceof InternalRemovalClient || client instanceof InternalEnumerateClient) {
            this.clearEnumerateState();
        }
        if (client != null && client.onError(error, vendorCode)) {
            this.removeClient(client);
        }
        Slog.v(TAG, "handleError(client=" + (client != null ? client.getOwnerString() : "null") + ", error = " + error + ")");
        if (error == 5) {
            this.mHandler.removeCallbacks(this.mResetClientState);
            if (this.mPendingClient != null) {
                Slog.v(TAG, "start pending client " + this.mPendingClient.getOwnerString());
                this.startClient(this.mPendingClient, false);
                this.mPendingClient = null;
            }
        } else if (error == 1) {
            Slog.w(TAG, "Got ERROR_HW_UNAVAILABLE; try reconnecting next client.");
            FingerprintService fingerprintService = this;
            synchronized (fingerprintService) {
                this.mDaemon = null;
                this.mHalDeviceId = 0L;
                this.mCurrentUserId = -10000;
            }
        }
    }

    protected void handleRemoved(long deviceId, int fingerId, int groupId, int remaining) {
        Slog.w(TAG, "Removed: fid=" + fingerId + ", gid=" + groupId + ", dev=" + deviceId + ", rem=" + remaining);
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onRemoved(fingerId, groupId, remaining)) {
            this.removeClient(client);
            if (!this.hasEnrolledFingerprints(groupId)) {
                this.updateActiveGroup(groupId, null);
            }
        }
        if (client instanceof InternalRemovalClient && !this.mUnknownFingerprints.isEmpty()) {
            this.cleanupUnknownFingerprints();
        } else if (client instanceof InternalRemovalClient) {
            this.clearEnumerateState();
        }
    }

    protected void handleAuthenticated(long deviceId, int fingerId, int groupId, ArrayList<Byte> token) {
        ClientMonitor client = this.mCurrentClient;
        if (fingerId != 0) {
            byte[] byteToken = new byte[token.size()];
            for (int i = 0; i < token.size(); ++i) {
                byteToken[i] = token.get(i);
            }
            KeyStore.getInstance().addAuthToken(byteToken);
        }
        if (client != null && client.onAuthenticated(fingerId, groupId)) {
            this.removeClient(client);
        }
        if (fingerId != 0) {
            ++this.mPerformanceStats.accept;
        } else {
            ++this.mPerformanceStats.reject;
        }
    }

    protected void handleAcquired(long deviceId, int acquiredInfo, int vendorCode) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onAcquired(acquiredInfo, vendorCode)) {
            this.removeClient(client);
        }
        if (this.mPerformanceStats != null && this.getLockoutMode() == 0 && client instanceof AuthenticationClient) {
            ++this.mPerformanceStats.acquire;
        }
    }

    protected void handleEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onEnrollResult(fingerId, groupId, remaining)) {
            this.removeClient(client);
            this.updateActiveGroup(groupId, null);
        }
    }

    private void userActivity() {
        long now = SystemClock.uptimeMillis();
        this.mPowerManager.userActivity(now, 2, 0);
    }

    void handleUserSwitching(int userId) {
        if (this.mCurrentClient instanceof InternalRemovalClient || this.mCurrentClient instanceof InternalEnumerateClient) {
            Slog.w(TAG, "User switched while performing cleanup");
            this.removeClient(this.mCurrentClient);
            this.clearEnumerateState();
        }
        this.updateActiveGroup(userId, null);
        this.doFingerprintCleanupForUser(userId);
    }

    private void removeClient(ClientMonitor client) {
        if (client != null) {
            client.destroy();
            if (client != this.mCurrentClient && this.mCurrentClient != null) {
                Slog.w(TAG, "Unexpected client: " + client.getOwnerString() + "expected: " + this.mCurrentClient != null ? this.mCurrentClient.getOwnerString() : "null");
            }
        }
        if (this.mCurrentClient != null) {
            Slog.v(TAG, "Done with client: " + client.getOwnerString());
            this.mCurrentClient = null;
        }
        if (this.mPendingClient == null) {
            this.notifyClientActiveCallbacks(false);
        }
    }

    private int getLockoutMode() {
        int currentUser = ActivityManager.getCurrentUser();
        int failedAttempts = this.mFailedAttempts.get(currentUser, 0);
        if (failedAttempts >= 20) {
            return 2;
        }
        if (failedAttempts > 0 && !this.mTimedLockoutCleared.get(currentUser, false) && failedAttempts % 5 == 0) {
            return 1;
        }
        return 0;
    }

    private void scheduleLockoutResetForUser(int userId) {
        this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + 30000L, this.getLockoutResetIntentForUser(userId));
    }

    private void cancelLockoutResetForUser(int userId) {
        this.mAlarmManager.cancel(this.getLockoutResetIntentForUser(userId));
    }

    private PendingIntent getLockoutResetIntentForUser(int userId) {
        return PendingIntent.getBroadcast(this.mContext, userId, new Intent(ACTION_LOCKOUT_RESET).putExtra(KEY_LOCKOUT_RESET_USER, userId), 0x8000000);
    }

    public long startPreEnroll(IBinder token) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPreEnroll: no fingerprint HAL!");
            return 0L;
        }
        try {
            return daemon.preEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPreEnroll failed", e);
            return 0L;
        }
    }

    public int startPostEnroll(IBinder token) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPostEnroll: no fingerprint HAL!");
            return 0;
        }
        try {
            return daemon.postEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPostEnroll failed", e);
            return 0;
        }
    }

    private void startClient(ClientMonitor newClient, boolean initiatedByClient) {
        ClientMonitor currentClient = this.mCurrentClient;
        if (currentClient != null) {
            Slog.v(TAG, "request stop current client " + currentClient.getOwnerString());
            if (currentClient instanceof InternalEnumerateClient || currentClient instanceof InternalRemovalClient) {
                if (newClient != null) {
                    Slog.w(TAG, "Internal cleanup in progress but trying to start client " + newClient.getClass().getSuperclass().getSimpleName() + "(" + newClient.getOwnerString() + "), initiatedByClient = " + initiatedByClient);
                }
            } else {
                currentClient.stop(initiatedByClient);
            }
            this.mPendingClient = newClient;
            this.mHandler.removeCallbacks(this.mResetClientState);
            this.mHandler.postDelayed(this.mResetClientState, 3000L);
        } else if (newClient != null) {
            this.mCurrentClient = newClient;
            Slog.v(TAG, "starting client " + newClient.getClass().getSuperclass().getSimpleName() + "(" + newClient.getOwnerString() + "), initiatedByClient = " + initiatedByClient);
            this.notifyClientActiveCallbacks(true);
            newClient.start();
        }
    }

    void startRemove(IBinder token, int fingerId, int groupId, int userId, IFingerprintServiceReceiver receiver, boolean restricted, boolean internal) {
        if (token == null) {
            Slog.w(TAG, "startRemove: token is null");
            return;
        }
        if (receiver == null) {
            Slog.w(TAG, "startRemove: receiver is null");
            return;
        }
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startRemove: no fingerprint HAL!");
            return;
        }
        if (internal) {
            Context context = this.getContext();
            InternalRemovalClient client = new InternalRemovalClient(context, this.mHalDeviceId, token, receiver, fingerId, groupId, userId, restricted, context.getOpPackageName()){

                @Override
                public void notifyUserActivity() {
                }

                @Override
                public IBiometricsFingerprint getFingerprintDaemon() {
                    return FingerprintService.this.getFingerprintDaemon();
                }
            };
            this.startClient(client, true);
        } else {
            RemovalClient client = new RemovalClient(this.getContext(), this.mHalDeviceId, token, receiver, fingerId, groupId, userId, restricted, token.toString()){

                @Override
                public void notifyUserActivity() {
                    FingerprintService.this.userActivity();
                }

                @Override
                public IBiometricsFingerprint getFingerprintDaemon() {
                    return FingerprintService.this.getFingerprintDaemon();
                }
            };
            this.startClient(client, true);
        }
    }

    void startEnumerate(IBinder token, int userId, IFingerprintServiceReceiver receiver, boolean restricted, boolean internal) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startEnumerate: no fingerprint HAL!");
            return;
        }
        if (internal) {
            List<Fingerprint> enrolledList = this.getEnrolledFingerprints(userId);
            Context context = this.getContext();
            InternalEnumerateClient client = new InternalEnumerateClient(context, this.mHalDeviceId, token, receiver, userId, userId, restricted, context.getOpPackageName(), enrolledList){

                @Override
                public void notifyUserActivity() {
                }

                @Override
                public IBiometricsFingerprint getFingerprintDaemon() {
                    return FingerprintService.this.getFingerprintDaemon();
                }
            };
            this.startClient(client, true);
        } else {
            EnumerateClient client = new EnumerateClient(this.getContext(), this.mHalDeviceId, token, receiver, userId, userId, restricted, token.toString()){

                @Override
                public void notifyUserActivity() {
                    FingerprintService.this.userActivity();
                }

                @Override
                public IBiometricsFingerprint getFingerprintDaemon() {
                    return FingerprintService.this.getFingerprintDaemon();
                }
            };
            this.startClient(client, true);
        }
    }

    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId);
    }

    public boolean hasEnrolledFingerprints(int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.checkPermission("android.permission.INTERACT_ACROSS_USERS");
        }
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size() > 0;
    }

    boolean hasPermission(String permission2) {
        return this.getContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    void checkPermission(String permission2) {
        this.getContext().enforceCallingOrSelfPermission(permission2, "Must have " + permission2 + " permission.");
    }

    int getEffectiveUserId(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um != null) {
            long callingIdentity = Binder.clearCallingIdentity();
            userId = um.getCredentialOwnerProfile(userId);
            Binder.restoreCallingIdentity(callingIdentity);
        } else {
            Slog.e(TAG, "Unable to acquire UserManager");
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUserOrProfile(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um == null) {
            Slog.e(TAG, "Unable to acquire UserManager");
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            for (int profileId : um.getEnabledProfileIds(ActivityManager.getCurrentUser())) {
                if (profileId != userId) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return false;
    }

    private boolean isForegroundActivity(int uid, int pid) {
        try {
            List<ActivityManager.RunningAppProcessInfo> procs = ActivityManager.getService().getRunningAppProcesses();
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                ActivityManager.RunningAppProcessInfo proc = procs.get(i);
                if (proc.pid != pid || proc.uid != uid || proc.importance > 125) continue;
                return true;
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "am.getRunningAppProcesses() failed");
        }
        return false;
    }

    private boolean canUseFingerprint(String opPackageName, boolean requireForeground, int uid, int pid, int userId) {
        if (this.getContext().checkCallingPermission("android.permission.USE_FINGERPRINT") != 0) {
            this.checkPermission("android.permission.USE_BIOMETRIC");
        }
        if (this.isKeyguard(opPackageName)) {
            return true;
        }
        if (!this.isCurrentUserOrProfile(userId)) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; not a current user or profile");
            return false;
        }
        if (this.mAppOps.noteOp(55, uid, opPackageName) != 0) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; permission denied");
            return false;
        }
        if (requireForeground && !this.isForegroundActivity(uid, pid) && !this.currentClient(opPackageName)) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; not in foreground");
            return false;
        }
        return true;
    }

    private boolean currentClient(String opPackageName) {
        return this.mCurrentClient != null && this.mCurrentClient.getOwnerString().equals(opPackageName);
    }

    private boolean isKeyguard(String clientPackage) {
        return this.mKeyguardPackage.equals(clientPackage);
    }

    private void addLockoutResetMonitor(FingerprintServiceLockoutResetMonitor monitor) {
        if (!this.mLockoutMonitors.contains(monitor)) {
            this.mLockoutMonitors.add(monitor);
        }
    }

    private void removeLockoutResetCallback(FingerprintServiceLockoutResetMonitor monitor) {
        this.mLockoutMonitors.remove(monitor);
    }

    private void notifyLockoutResetMonitors() {
        for (int i = 0; i < this.mLockoutMonitors.size(); ++i) {
            this.mLockoutMonitors.get(i).sendLockoutReset();
        }
    }

    private void notifyClientActiveCallbacks(boolean isActive) {
        CopyOnWriteArrayList<IFingerprintClientActiveCallback> callbacks = this.mClientActiveCallbacks;
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                ((IFingerprintClientActiveCallback)callbacks.get(i)).onClientActiveChanged(isActive);
                continue;
            }
            catch (RemoteException re) {
                this.mClientActiveCallbacks.remove(callbacks.get(i));
            }
        }
    }

    private void startAuthentication(IBinder token, long opId, int callingUserId, int groupId, IFingerprintServiceReceiver receiver, int flags, boolean restricted, String opPackageName, Bundle bundle, IBiometricPromptReceiver dialogReceiver) {
        this.updateActiveGroup(groupId, opPackageName);
        Slog.v(TAG, "startAuthentication(" + opPackageName + ")");
        AuthenticationClient client = new AuthenticationClient(this.getContext(), this.mHalDeviceId, token, receiver, this.mCurrentUserId, groupId, opId, restricted, opPackageName, bundle, dialogReceiver, this.mStatusBarService){

            @Override
            public void onStart() {
                try {
                    FingerprintService.this.mActivityManager.registerTaskStackListener(FingerprintService.this.mTaskStackListener);
                }
                catch (RemoteException e) {
                    Slog.e(FingerprintService.TAG, "Could not register task stack listener", e);
                }
            }

            @Override
            public void onStop() {
                try {
                    FingerprintService.this.mActivityManager.unregisterTaskStackListener(FingerprintService.this.mTaskStackListener);
                }
                catch (RemoteException e) {
                    Slog.e(FingerprintService.TAG, "Could not unregister task stack listener", e);
                }
            }

            @Override
            public int handleFailedAttempt() {
                int currentUser = ActivityManager.getCurrentUser();
                FingerprintService.this.mFailedAttempts.put(currentUser, FingerprintService.this.mFailedAttempts.get(currentUser, 0) + 1);
                FingerprintService.this.mTimedLockoutCleared.put(ActivityManager.getCurrentUser(), false);
                int lockoutMode = FingerprintService.this.getLockoutMode();
                if (lockoutMode == 2) {
                    ++((FingerprintService)FingerprintService.this).mPerformanceStats.permanentLockout;
                } else if (lockoutMode == 1) {
                    ++((FingerprintService)FingerprintService.this).mPerformanceStats.lockout;
                }
                if (lockoutMode != 0) {
                    FingerprintService.this.scheduleLockoutResetForUser(currentUser);
                    return lockoutMode;
                }
                return 0;
            }

            @Override
            public void resetFailedAttempts() {
                FingerprintService.this.resetFailedAttemptsForUser(true, ActivityManager.getCurrentUser());
            }

            @Override
            public void notifyUserActivity() {
                FingerprintService.this.userActivity();
            }

            @Override
            public IBiometricsFingerprint getFingerprintDaemon() {
                return FingerprintService.this.getFingerprintDaemon();
            }
        };
        int lockoutMode = this.getLockoutMode();
        if (lockoutMode != 0) {
            int errorCode;
            Slog.v(TAG, "In lockout mode(" + lockoutMode + ") ; disallowing authentication");
            int n = errorCode = lockoutMode == 1 ? 7 : 9;
            if (!client.onError(errorCode, 0)) {
                Slog.w(TAG, "Cannot send permanent lockout message to client");
            }
            return;
        }
        this.startClient(client, true);
    }

    private void startEnrollment(IBinder token, byte[] cryptoToken, int userId, IFingerprintServiceReceiver receiver, int flags, boolean restricted, String opPackageName) {
        this.updateActiveGroup(userId, opPackageName);
        int groupId = userId;
        EnrollClient client = new EnrollClient(this.getContext(), this.mHalDeviceId, token, receiver, userId, groupId, cryptoToken, restricted, opPackageName){

            @Override
            public IBiometricsFingerprint getFingerprintDaemon() {
                return FingerprintService.this.getFingerprintDaemon();
            }

            @Override
            public void notifyUserActivity() {
                FingerprintService.this.userActivity();
            }
        };
        this.startClient(client, true);
    }

    protected void resetFailedAttemptsForUser(boolean clearAttemptCounter, int userId) {
        if (this.getLockoutMode() != 0) {
            Slog.v(TAG, "Reset fingerprint lockout, clearAttemptCounter=" + clearAttemptCounter);
        }
        if (clearAttemptCounter) {
            this.mFailedAttempts.put(userId, 0);
        }
        this.mTimedLockoutCleared.put(userId, true);
        this.cancelLockoutResetForUser(userId);
        this.notifyLockoutResetMonitors();
    }

    private void dumpInternal(PrintWriter pw) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Fingerprint Manager");
            JSONArray sets = new JSONArray();
            for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
                int userId = user.getUserHandle().getIdentifier();
                int N = this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size();
                PerformanceStats stats = this.mPerformanceMap.get(userId);
                PerformanceStats cryptoStats = this.mCryptoPerformanceMap.get(userId);
                JSONObject set = new JSONObject();
                set.put("id", userId);
                set.put("count", N);
                set.put("accept", stats != null ? stats.accept : 0);
                set.put("reject", stats != null ? stats.reject : 0);
                set.put("acquire", stats != null ? stats.acquire : 0);
                set.put("lockout", stats != null ? stats.lockout : 0);
                set.put("permanentLockout", stats != null ? stats.permanentLockout : 0);
                set.put("acceptCrypto", cryptoStats != null ? cryptoStats.accept : 0);
                set.put("rejectCrypto", cryptoStats != null ? cryptoStats.reject : 0);
                set.put("acquireCrypto", cryptoStats != null ? cryptoStats.acquire : 0);
                set.put("lockoutCrypto", cryptoStats != null ? cryptoStats.lockout : 0);
                set.put("permanentLockoutCrypto", cryptoStats != null ? cryptoStats.permanentLockout : 0);
                sets.put(set);
            }
            dump.put("prints", sets);
        }
        catch (JSONException e) {
            Slog.e(TAG, "dump formatting failure", e);
        }
        pw.println(dump);
    }

    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
            PerformanceStats crypto;
            int userId = user.getUserHandle().getIdentifier();
            long userToken = proto.start(2246267895809L);
            proto.write(0x10500000001L, userId);
            proto.write(1120986464258L, this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size());
            PerformanceStats normal = this.mPerformanceMap.get(userId);
            if (normal != null) {
                long countsToken = proto.start(1146756268035L);
                proto.write(0x10500000001L, normal.accept);
                proto.write(1120986464258L, normal.reject);
                proto.write(1120986464259L, normal.acquire);
                proto.write(1120986464260L, normal.lockout);
                proto.write(0x10500000005L, normal.permanentLockout);
                proto.end(countsToken);
            }
            if ((crypto = this.mCryptoPerformanceMap.get(userId)) != null) {
                long countsToken = proto.start(1146756268036L);
                proto.write(0x10500000001L, crypto.accept);
                proto.write(1120986464258L, crypto.reject);
                proto.write(1120986464259L, crypto.acquire);
                proto.write(1120986464260L, crypto.lockout);
                proto.write(0x10500000005L, crypto.permanentLockout);
                proto.end(countsToken);
            }
            proto.end(userToken);
        }
        proto.flush();
        this.mPerformanceMap.clear();
        this.mCryptoPerformanceMap.clear();
    }

    @Override
    public void onStart() {
        this.publishBinderService("fingerprint", new FingerprintServiceWrapper());
        SystemServerInitThreadPool.get().submit(this::getFingerprintDaemon, "FingerprintService.onStart");
        this.listenForUserSwitches();
    }

    private void updateActiveGroup(int userId, String clientPackage) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon != null) {
            try {
                userId = this.getUserOrWorkProfileId(clientPackage, userId);
                if (userId != this.mCurrentUserId) {
                    File baseDir;
                    File fpDir;
                    int firstSdkInt = Build.VERSION.FIRST_SDK_INT;
                    if (firstSdkInt < 1) {
                        Slog.e(TAG, "First SDK version " + firstSdkInt + " is invalid; must be at least VERSION_CODES.BASE");
                    }
                    if (!(fpDir = new File(baseDir = firstSdkInt <= 27 ? Environment.getUserSystemDirectory(userId) : Environment.getDataVendorDeDirectory(userId), FP_DATA_DIR)).exists()) {
                        if (!fpDir.mkdir()) {
                            Slog.v(TAG, "Cannot make directory: " + fpDir.getAbsolutePath());
                            return;
                        }
                        if (!SELinux.restorecon(fpDir)) {
                            Slog.w(TAG, "Restorecons failed. Directory will have wrong label.");
                            return;
                        }
                    }
                    daemon.setActiveGroup(userId, fpDir.getAbsolutePath());
                    this.mCurrentUserId = userId;
                }
                this.mAuthenticatorIds.put(userId, this.hasEnrolledFingerprints(userId) ? daemon.getAuthenticatorId() : 0L);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to setActiveGroup():", e);
            }
        }
    }

    private int getUserOrWorkProfileId(String clientPackage, int userId) {
        if (!this.isKeyguard(clientPackage) && this.isWorkProfile(userId)) {
            return userId;
        }
        return this.getEffectiveUserId(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorkProfile(int userId) {
        UserInfo userInfo = null;
        long token = Binder.clearCallingIdentity();
        try {
            userInfo = this.mUserManager.getUserInfo(userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return userInfo != null && userInfo.isManagedProfile();
    }

    private void listenForUserSwitches() {
        try {
            ActivityManager.getService().registerUserSwitchObserver(new SynchronousUserSwitchObserver(){

                @Override
                public void onUserSwitching(int newUserId) throws RemoteException {
                    FingerprintService.this.mHandler.obtainMessage(10, newUserId, 0).sendToTarget();
                }
            }, TAG);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to listen for user switching event", e);
        }
    }

    public long getAuthenticatorId(String opPackageName) {
        int userId = this.getUserOrWorkProfileId(opPackageName, UserHandle.getCallingUserId());
        return this.mAuthenticatorIds.getOrDefault(userId, 0L);
    }

    private final class FingerprintServiceWrapper
    extends IFingerprintService.Stub {
        private FingerprintServiceWrapper() {
        }

        @Override
        public long preEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPreEnroll(token);
        }

        @Override
        public int postEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPostEnroll(token);
        }

        @Override
        public void enroll(final IBinder token, final byte[] cryptoToken, final int userId, final IFingerprintServiceReceiver receiver, final int flags, final String opPackageName) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            int limit = FingerprintService.this.mContext.getResources().getInteger(17694789);
            int enrolled = FingerprintService.this.getEnrolledFingerprints(userId).size();
            if (enrolled >= limit) {
                Slog.w(FingerprintService.TAG, "Too many fingerprints registered");
                return;
            }
            if (!FingerprintService.this.isCurrentUserOrProfile(userId)) {
                return;
            }
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startEnrollment(token, cryptoToken, userId, receiver, flags, restricted, opPackageName);
                }
            });
        }

        private boolean isRestricted() {
            boolean restricted = !FingerprintService.this.hasPermission("android.permission.MANAGE_FINGERPRINT");
            return restricted;
        }

        @Override
        public void cancelEnrollment(final IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ClientMonitor client = FingerprintService.this.mCurrentClient;
                    if (client instanceof EnrollClient && client.getToken() == token) {
                        client.stop(client.getToken() == token);
                    }
                }
            });
        }

        @Override
        public void authenticate(final IBinder token, final long opId, final int groupId, final IFingerprintServiceReceiver receiver, final int flags, final String opPackageName, final Bundle bundle, final IBiometricPromptReceiver dialogReceiver) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            final int callingUserId = UserHandle.getCallingUserId();
            final boolean restricted = this.isRestricted();
            if (!FingerprintService.this.canUseFingerprint(opPackageName, true, callingUid, callingPid, callingUserId)) {
                Slog.v(FingerprintService.TAG, "authenticate(): reject " + opPackageName);
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MetricsLogger.histogram(FingerprintService.this.mContext, "fingerprint_token", opId != 0L ? 1 : 0);
                    HashMap pmap = opId == 0L ? FingerprintService.this.mPerformanceMap : FingerprintService.this.mCryptoPerformanceMap;
                    PerformanceStats stats = (PerformanceStats)pmap.get(FingerprintService.this.mCurrentUserId);
                    if (stats == null) {
                        stats = new PerformanceStats();
                        pmap.put(FingerprintService.this.mCurrentUserId, stats);
                    }
                    FingerprintService.this.mPerformanceStats = stats;
                    FingerprintService.this.startAuthentication(token, opId, callingUserId, groupId, receiver, flags, restricted, opPackageName, bundle, dialogReceiver);
                }
            });
        }

        @Override
        public void cancelAuthentication(final IBinder token, String opPackageName) {
            int callingUserId;
            int callingPid;
            int callingUid = Binder.getCallingUid();
            if (!FingerprintService.this.canUseFingerprint(opPackageName, true, callingUid, callingPid = Binder.getCallingPid(), callingUserId = UserHandle.getCallingUserId())) {
                Slog.v(FingerprintService.TAG, "cancelAuthentication(): reject " + opPackageName);
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ClientMonitor client = FingerprintService.this.mCurrentClient;
                    if (client instanceof AuthenticationClient) {
                        if (client.getToken() == token) {
                            Slog.v(FingerprintService.TAG, "stop client " + client.getOwnerString());
                            client.stop(client.getToken() == token);
                        } else {
                            Slog.v(FingerprintService.TAG, "can't stop client " + client.getOwnerString() + " since tokens don't match");
                        }
                    } else if (client != null) {
                        Slog.v(FingerprintService.TAG, "can't cancel non-authenticating client " + client.getOwnerString());
                    }
                }
            });
        }

        @Override
        public void setActiveUser(final int userId) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.updateActiveGroup(userId, null);
                }
            });
        }

        @Override
        public void remove(final IBinder token, final int fingerId, final int groupId, final int userId, final IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startRemove(token, fingerId, groupId, userId, receiver, restricted, false);
                }
            });
        }

        @Override
        public void enumerate(final IBinder token, final int userId, final IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startEnumerate(token, userId, receiver, restricted, false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHardwareDetected(long deviceId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            long token = Binder.clearCallingIdentity();
            try {
                IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
                boolean bl = daemon != null && FingerprintService.this.mHalDeviceId != 0L;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void rename(final int fingerId, final int groupId, final String name) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            if (!FingerprintService.this.isCurrentUserOrProfile(groupId)) {
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.mFingerprintUtils.renameFingerprintForUser(FingerprintService.this.mContext, fingerId, groupId, name);
                }
            });
        }

        @Override
        public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return Collections.emptyList();
            }
            return FingerprintService.this.getEnrolledFingerprints(userId);
        }

        @Override
        public boolean hasEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            return FingerprintService.this.hasEnrolledFingerprints(userId);
        }

        @Override
        public long getAuthenticatorId(String opPackageName) {
            return FingerprintService.this.getAuthenticatorId(opPackageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(FingerprintService.this.mContext, FingerprintService.TAG, pw)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                if (args.length > 0 && "--proto".equals(args[0])) {
                    FingerprintService.this.dumpProto(fd);
                } else {
                    FingerprintService.this.dumpInternal(pw);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void resetTimeout(byte[] token) {
            FingerprintService.this.checkPermission("android.permission.RESET_FINGERPRINT_LOCKOUT");
            FingerprintService.this.mHandler.post(FingerprintService.this.mResetFailedAttemptsForCurrentUserRunnable);
        }

        @Override
        public void addLockoutResetCallback(final IFingerprintServiceLockoutResetCallback callback) throws RemoteException {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.addLockoutResetMonitor(new FingerprintServiceLockoutResetMonitor(callback));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClientActive() {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService fingerprintService = FingerprintService.this;
            synchronized (fingerprintService) {
                return FingerprintService.this.mCurrentClient != null || FingerprintService.this.mPendingClient != null;
            }
        }

        @Override
        public void addClientActiveCallback(IFingerprintClientActiveCallback callback) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mClientActiveCallbacks.add(callback);
        }

        @Override
        public void removeClientActiveCallback(IFingerprintClientActiveCallback callback) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mClientActiveCallbacks.remove(callback);
        }
    }

    private class FingerprintServiceLockoutResetMonitor
    implements IBinder.DeathRecipient {
        private static final long WAKELOCK_TIMEOUT_MS = 2000L;
        private final IFingerprintServiceLockoutResetCallback mCallback;
        private final PowerManager.WakeLock mWakeLock;
        private final Runnable mRemoveCallbackRunnable = new Runnable(){

            @Override
            public void run() {
                FingerprintServiceLockoutResetMonitor.this.releaseWakelock();
                FingerprintService.this.removeLockoutResetCallback(FingerprintServiceLockoutResetMonitor.this);
            }
        };

        public FingerprintServiceLockoutResetMonitor(IFingerprintServiceLockoutResetCallback callback) {
            this.mCallback = callback;
            this.mWakeLock = FingerprintService.this.mPowerManager.newWakeLock(1, "lockout reset callback");
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(FingerprintService.TAG, "caught remote exception in linkToDeath", e);
            }
        }

        public void sendLockoutReset() {
            if (this.mCallback != null) {
                try {
                    this.mWakeLock.acquire(2000L);
                    this.mCallback.onLockoutReset(FingerprintService.this.mHalDeviceId, new IRemoteCallback.Stub(){

                        @Override
                        public void sendResult(Bundle data) throws RemoteException {
                            FingerprintServiceLockoutResetMonitor.this.releaseWakelock();
                        }
                    });
                }
                catch (DeadObjectException e) {
                    Slog.w(FingerprintService.TAG, "Death object while invoking onLockoutReset: ", e);
                    FingerprintService.this.mHandler.post(this.mRemoveCallbackRunnable);
                }
                catch (RemoteException e) {
                    Slog.w(FingerprintService.TAG, "Failed to invoke onLockoutReset: ", e);
                    this.releaseWakelock();
                }
            }
        }

        @Override
        public void binderDied() {
            Slog.e(FingerprintService.TAG, "Lockout reset callback binder died");
            FingerprintService.this.mHandler.post(this.mRemoveCallbackRunnable);
        }

        private void releaseWakelock() {
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
    }

    private class UserFingerprint {
        Fingerprint f;
        int userId;

        public UserFingerprint(Fingerprint f, int userId) {
            this.f = f;
            this.userId = userId;
        }
    }

    private class PerformanceStats {
        int accept;
        int reject;
        int acquire;
        int lockout;
        int permanentLockout;

        private PerformanceStats() {
        }
    }
}

