/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyCache;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.admin.NetworkEvent;
import android.app.admin.PasswordMetrics;
import android.app.admin.SecurityLog;
import android.app.admin.SystemUpdateInfo;
import android.app.admin.SystemUpdatePolicy;
import android.app.backup.IBackupManager;
import android.app.backup.ISelectBackupTransportCallback;
import android.app.trust.TrustManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.StringParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.AudioManager;
import android.media.IAudioService;
import android.net.ConnectivityManager;
import android.net.IIpConnectivityMetrics;
import android.net.ProxyInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.os.storage.StorageManager;
import android.provider.ContactsContract;
import android.provider.ContactsInternal;
import android.provider.Settings;
import android.provider.Telephony;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChain;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.ParcelableKeyGenParameterSpec;
import android.service.persistentdata.PersistentDataBlockManager;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BackgroundThread;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.Preconditions;
import com.android.internal.util.StatLogger;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.SystemService;
import com.android.server.devicepolicy.BaseIDevicePolicyManager;
import com.android.server.devicepolicy.CertificateMonitor;
import com.android.server.devicepolicy.CryptoTestHelper;
import com.android.server.devicepolicy.DeviceAdminServiceController;
import com.android.server.devicepolicy.DevicePolicyCacheImpl;
import com.android.server.devicepolicy.DevicePolicyConstants;
import com.android.server.devicepolicy.NetworkLogger;
import com.android.server.devicepolicy.OverlayPackagesProvider;
import com.android.server.devicepolicy.Owners;
import com.android.server.devicepolicy.RemoteBugreportUtils;
import com.android.server.devicepolicy.SecurityLogMonitor;
import com.android.server.devicepolicy.TransferOwnershipMetadataManager;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.pm.UserRestrictionsUtils;
import com.android.server.storage.DeviceStorageMonitorInternal;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DevicePolicyManagerService
extends BaseIDevicePolicyManager {
    protected static final String LOG_TAG = "DevicePolicyManager";
    private static final boolean VERBOSE_LOG = false;
    private static final String DEVICE_POLICIES_XML = "device_policies.xml";
    private static final String TRANSFER_OWNERSHIP_PARAMETERS_XML = "transfer-ownership-parameters.xml";
    private static final String TAG_ACCEPTED_CA_CERTIFICATES = "accepted-ca-certificate";
    private static final String TAG_LOCK_TASK_COMPONENTS = "lock-task-component";
    private static final String TAG_LOCK_TASK_FEATURES = "lock-task-features";
    private static final String TAG_STATUS_BAR = "statusbar";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_NAME = "name";
    private static final String DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML = "do-not-ask-credentials-on-boot";
    private static final String TAG_AFFILIATION_ID = "affiliation-id";
    private static final String TAG_LAST_SECURITY_LOG_RETRIEVAL = "last-security-log-retrieval";
    private static final String TAG_LAST_BUG_REPORT_REQUEST = "last-bug-report-request";
    private static final String TAG_LAST_NETWORK_LOG_RETRIEVAL = "last-network-log-retrieval";
    private static final String TAG_ADMIN_BROADCAST_PENDING = "admin-broadcast-pending";
    private static final String TAG_CURRENT_INPUT_METHOD_SET = "current-ime-set";
    private static final String TAG_OWNER_INSTALLED_CA_CERT = "owner-installed-ca-cert";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_ALIAS = "alias";
    private static final String TAG_INITIALIZATION_BUNDLE = "initialization-bundle";
    private static final String TAG_PASSWORD_TOKEN_HANDLE = "password-token";
    private static final String TAG_PASSWORD_VALIDITY = "password-validity";
    private static final String TAG_TRANSFER_OWNERSHIP_BUNDLE = "transfer-ownership-bundle";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long MS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long EXPIRATION_GRACE_PERIOD_MS = 5L * MS_PER_DAY;
    private static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final String ATTR_PERMISSION_PROVIDER = "permission-provider";
    private static final String ATTR_SETUP_COMPLETE = "setup-complete";
    private static final String ATTR_PROVISIONING_STATE = "provisioning-state";
    private static final String ATTR_PERMISSION_POLICY = "permission-policy";
    private static final String ATTR_DEVICE_PROVISIONING_CONFIG_APPLIED = "device-provisioning-config-applied";
    private static final String ATTR_DEVICE_PAIRED = "device-paired";
    private static final String ATTR_DELEGATED_CERT_INSTALLER = "delegated-cert-installer";
    private static final String ATTR_APPLICATION_RESTRICTIONS_MANAGER = "application-restrictions-manager";
    private static final String[] DELEGATIONS = new String[]{"delegation-cert-install", "delegation-app-restrictions", "delegation-block-uninstall", "delegation-enable-system-app", "delegation-keep-uninstalled-packages", "delegation-package-access", "delegation-permission-grant", "delegation-install-existing-package", "delegation-keep-uninstalled-packages"};
    private static final String PROPERTY_DEVICE_OWNER_PRESENT = "ro.device_owner";
    private static final int STATUS_BAR_DISABLE_MASK = 0x2070000;
    private static final int STATUS_BAR_DISABLE2_MASK = 1;
    private static final Set<String> SECURE_SETTINGS_WHITELIST = new ArraySet<String>();
    private static final Set<String> SECURE_SETTINGS_DEVICEOWNER_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_DEPRECATED;
    private static final Set<String> SYSTEM_SETTINGS_WHITELIST;
    private static final int PROFILE_KEYGUARD_FEATURES_PROFILE_ONLY = 8;
    private static final int PROFILE_KEYGUARD_FEATURES = 440;
    private static final int DEVICE_ADMIN_DEACTIVATE_TIMEOUT = 10000;
    private static final long MINIMUM_STRONG_AUTH_TIMEOUT_MS;
    private static final String LOG_TAG_PROFILE_OWNER = "profile-owner";
    private static final String LOG_TAG_DEVICE_OWNER = "device-owner";
    final Context mContext;
    final Injector mInjector;
    final IPackageManager mIPackageManager;
    final UserManager mUserManager;
    final UserManagerInternal mUserManagerInternal;
    final UsageStatsManagerInternal mUsageStatsManagerInternal;
    final TelephonyManager mTelephonyManager;
    private final LockPatternUtils mLockPatternUtils;
    private final DevicePolicyConstants mConstants;
    private final DeviceAdminServiceController mDeviceAdminServiceController;
    private final OverlayPackagesProvider mOverlayPackagesProvider;
    private final DevicePolicyCacheImpl mPolicyCache = new DevicePolicyCacheImpl();
    private final Set<Pair<String, Integer>> mPackagesToRemove = new ArraySet<Pair<String, Integer>>();
    final LocalService mLocalService;
    @VisibleForTesting
    final Owners mOwners;
    private final Binder mToken = new Binder();
    final boolean mHasFeature;
    final boolean mIsWatch;
    private final CertificateMonitor mCertificateMonitor;
    private final SecurityLogMonitor mSecurityLogMonitor;
    @GuardedBy(value="getLockObject()")
    private NetworkLogger mNetworkLogger;
    private final AtomicBoolean mRemoteBugreportServiceIsActive = new AtomicBoolean();
    private final AtomicBoolean mRemoteBugreportSharingAccepted = new AtomicBoolean();
    private final SetupContentObserver mSetupContentObserver;
    private static boolean ENABLE_LOCK_GUARD;
    private final StatLogger mStatLogger = new StatLogger(new String[]{"LockGuard.guard()"});
    private final Object mLockDoNoUseDirectly = LockGuard.installNewLock(7, true);
    @VisibleForTesting
    final TransferOwnershipMetadataManager mTransferOwnershipMetadataManager;
    private final Runnable mRemoteBugreportTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (DevicePolicyManagerService.this.mRemoteBugreportServiceIsActive.get()) {
                DevicePolicyManagerService.this.onBugreportFailed();
            }
        }
    };
    private final BroadcastReceiver mRemoteBugreportFinishedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.REMOTE_BUGREPORT_DISPATCH".equals(intent.getAction()) && DevicePolicyManagerService.this.mRemoteBugreportServiceIsActive.get()) {
                DevicePolicyManagerService.this.onBugreportFinished(intent);
            }
        }
    };
    private final BroadcastReceiver mRemoteBugreportConsentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            DevicePolicyManagerService.this.mInjector.getNotificationManager().cancel(DevicePolicyManagerService.LOG_TAG, 678432343);
            if ("com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED".equals(action)) {
                DevicePolicyManagerService.this.onBugreportSharingAccepted();
            } else if ("com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED".equals(action)) {
                DevicePolicyManagerService.this.onBugreportSharingDeclined();
            }
            DevicePolicyManagerService.this.mContext.unregisterReceiver(DevicePolicyManagerService.this.mRemoteBugreportConsentReceiver);
        }
    };
    @GuardedBy(value="getLockObject()")
    final SparseArray<DevicePolicyData> mUserData = new SparseArray();
    @GuardedBy(value="getLockObject()")
    final SparseArray<PasswordMetrics> mUserPasswordMetrics = new SparseArray();
    final Handler mHandler;
    final Handler mBackgroundHandler;
    final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object;
            String action = intent.getAction();
            final int userHandle = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            if ("android.intent.action.USER_STARTED".equals(action) && userHandle == DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserId()) {
                object = DevicePolicyManagerService.this.getLockObject();
                synchronized (object) {
                    if (DevicePolicyManagerService.this.isNetworkLoggingEnabledInternalLocked()) {
                        DevicePolicyManagerService.this.setNetworkLoggingActiveInternal(true);
                    }
                }
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) && userHandle == DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserId() && DevicePolicyManagerService.this.getDeviceOwnerRemoteBugreportUri() != null) {
                IntentFilter filterConsent = new IntentFilter();
                filterConsent.addAction("com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED");
                filterConsent.addAction("com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED");
                DevicePolicyManagerService.this.mContext.registerReceiver(DevicePolicyManagerService.this.mRemoteBugreportConsentReceiver, filterConsent);
                DevicePolicyManagerService.this.mInjector.getNotificationManager().notifyAsUser(DevicePolicyManagerService.LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(DevicePolicyManagerService.this.mContext, 3), UserHandle.ALL);
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification(userHandle);
                    }
                });
            }
            if ("android.intent.action.USER_ADDED".equals(action)) {
                this.sendDeviceOwnerUserCommand("android.app.action.USER_ADDED", userHandle);
                object = DevicePolicyManagerService.this.getLockObject();
                synchronized (object) {
                    DevicePolicyManagerService.this.maybePauseDeviceWideLoggingLocked();
                }
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                this.sendDeviceOwnerUserCommand("android.app.action.USER_REMOVED", userHandle);
                object = DevicePolicyManagerService.this.getLockObject();
                synchronized (object) {
                    boolean isRemovedUserAffiliated = DevicePolicyManagerService.this.isUserAffiliatedWithDeviceLocked(userHandle);
                    DevicePolicyManagerService.this.removeUserData(userHandle);
                    if (!isRemovedUserAffiliated) {
                        DevicePolicyManagerService.this.discardDeviceWideLogsLocked();
                        DevicePolicyManagerService.this.maybeResumeDeviceWideLoggingLocked();
                    }
                }
            }
            if ("android.intent.action.USER_STARTED".equals(action)) {
                this.sendDeviceOwnerUserCommand("android.app.action.USER_STARTED", userHandle);
                object = DevicePolicyManagerService.this.getLockObject();
                synchronized (object) {
                    DevicePolicyManagerService.this.maybeSendAdminEnabledBroadcastLocked(userHandle);
                    DevicePolicyManagerService.this.mUserData.remove(userHandle);
                }
                DevicePolicyManagerService.this.handlePackagesChanged(null, userHandle);
            } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                this.sendDeviceOwnerUserCommand("android.app.action.USER_STOPPED", userHandle);
            } else if ("android.intent.action.USER_SWITCHED".equals(action)) {
                this.sendDeviceOwnerUserCommand("android.app.action.USER_SWITCHED", userHandle);
            } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                object = DevicePolicyManagerService.this.getLockObject();
                synchronized (object) {
                    DevicePolicyManagerService.this.maybeSendAdminEnabledBroadcastLocked(userHandle);
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                DevicePolicyManagerService.this.handlePackagesChanged(null, userHandle);
            } else if ("android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_ADDED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(action) && !intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.MANAGED_PROFILE_ADDED".equals(action)) {
                DevicePolicyManagerService.this.clearWipeProfileNotification();
            } else if ("android.intent.action.DATE_CHANGED".equals(action) || "android.intent.action.TIME_SET".equals(action)) {
                DevicePolicyManagerService.this.updateSystemUpdateFreezePeriodsRecord(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceOwnerUserCommand(String action, int userHandle) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                ActiveAdmin deviceOwner = DevicePolicyManagerService.this.getDeviceOwnerAdminLocked();
                if (deviceOwner != null) {
                    Bundle extras = new Bundle();
                    extras.putParcelable("android.intent.extra.USER", UserHandle.of(userHandle));
                    DevicePolicyManagerService.this.sendAdminCommandLocked(deviceOwner, action, extras, null, true);
                }
            }
        }
    };

    final Object getLockObject() {
        if (ENABLE_LOCK_GUARD) {
            long start = this.mStatLogger.getTime();
            LockGuard.guard(7);
            this.mStatLogger.logDurationStat(0, start);
        }
        return this.mLockDoNoUseDirectly;
    }

    final void ensureLocked() {
        if (Thread.holdsLock(this.mLockDoNoUseDirectly)) {
            return;
        }
        Slog.wtfStack(LOG_TAG, "Not holding DPMS lock.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackagesChanged(String packageName, int userHandle) {
        boolean removedAdmin = false;
        DevicePolicyData policy = this.getUserData(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                ActiveAdmin aa = policy.mAdminList.get(i);
                try {
                    String adminPackage = aa.info.getPackageName();
                    if (packageName != null && !packageName.equals(adminPackage) || this.mIPackageManager.getPackageInfo(adminPackage, 0, userHandle) != null && this.mIPackageManager.getReceiverInfo(aa.info.getComponent(), 786432, userHandle) != null) continue;
                    removedAdmin = true;
                    policy.mAdminList.remove(i);
                    policy.mAdminMap.remove(aa.info.getComponent());
                    this.pushActiveAdminPackagesLocked(userHandle);
                    this.pushMeteredDisabledPackagesLocked(userHandle);
                    continue;
                }
                catch (RemoteException adminPackage) {
                    // empty catch block
                }
            }
            if (removedAdmin) {
                this.validatePasswordOwnerLocked(policy);
            }
            boolean removedDelegate = false;
            for (int i = policy.mDelegationMap.size() - 1; i >= 0; --i) {
                String delegatePackage = policy.mDelegationMap.keyAt(i);
                if (!this.isRemovedPackage(packageName, delegatePackage, userHandle)) continue;
                policy.mDelegationMap.removeAt(i);
                removedDelegate = true;
            }
            ComponentName owner = this.getOwnerComponent(userHandle);
            if (packageName != null && owner != null && owner.getPackageName().equals(packageName)) {
                this.startOwnerService(userHandle, "package-broadcast");
            }
            if (removedAdmin || removedDelegate) {
                this.saveSettingsLocked(policy.mUserHandle);
            }
        }
        if (removedAdmin) {
            this.pushUserRestrictions(userHandle);
        }
    }

    private boolean isRemovedPackage(String changedPackage, String targetPackage, int userHandle) {
        try {
            return targetPackage != null && (changedPackage == null || changedPackage.equals(targetPackage)) && this.mIPackageManager.getPackageInfo(targetPackage, 0, userHandle) == null;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public DevicePolicyManagerService(Context context) {
        this(new Injector(context));
    }

    @VisibleForTesting
    DevicePolicyManagerService(Injector injector) {
        this.mInjector = injector;
        this.mContext = Preconditions.checkNotNull(injector.mContext);
        this.mHandler = new Handler(Preconditions.checkNotNull(injector.getMyLooper()));
        this.mConstants = DevicePolicyConstants.loadFromString(this.mInjector.settingsGlobalGetString("device_policy_constants"));
        this.mOwners = Preconditions.checkNotNull(injector.newOwners());
        this.mUserManager = Preconditions.checkNotNull(injector.getUserManager());
        this.mUserManagerInternal = Preconditions.checkNotNull(injector.getUserManagerInternal());
        this.mUsageStatsManagerInternal = Preconditions.checkNotNull(injector.getUsageStatsManagerInternal());
        this.mIPackageManager = Preconditions.checkNotNull(injector.getIPackageManager());
        this.mTelephonyManager = Preconditions.checkNotNull(injector.getTelephonyManager());
        this.mLocalService = new LocalService();
        this.mLockPatternUtils = injector.newLockPatternUtils();
        this.mSecurityLogMonitor = new SecurityLogMonitor(this);
        this.mHasFeature = this.mInjector.hasFeature();
        this.mIsWatch = this.mInjector.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        this.mBackgroundHandler = BackgroundThread.getHandler();
        this.mCertificateMonitor = new CertificateMonitor(this, this.mInjector, this.mBackgroundHandler);
        this.mDeviceAdminServiceController = new DeviceAdminServiceController(this, this.mConstants);
        this.mOverlayPackagesProvider = new OverlayPackagesProvider(this.mContext);
        this.mTransferOwnershipMetadataManager = this.mInjector.newTransferOwnershipMetadataManager();
        if (!this.mHasFeature) {
            this.mSetupContentObserver = null;
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.intent.action.USER_STOPPED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.DATE_CHANGED");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        LocalServices.addService(DevicePolicyManagerInternal.class, this.mLocalService);
        this.mSetupContentObserver = new SetupContentObserver(this.mHandler);
        this.mUserManagerInternal.addUserRestrictionsListener(new RestrictionsListener(this.mContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserData(int userHandle) {
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy == null) {
                policy = new DevicePolicyData(userHandle);
                this.mUserData.append(userHandle, policy);
                this.loadSettingsLocked(policy, userHandle);
            }
            return policy;
        }
    }

    PasswordMetrics getUserPasswordMetricsLocked(int userHandle) {
        return this.mUserPasswordMetrics.get(userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserDataUnchecked(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            DevicePolicyData devicePolicyData = this.getUserData(userHandle);
            return devicePolicyData;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserData(int userHandle) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (userHandle == 0) {
                Slog.w(LOG_TAG, "Tried to remove device policy file for user 0! Ignoring.");
                return;
            }
            this.mPolicyCache.onUserRemoved(userHandle);
            this.mOwners.removeProfileOwner(userHandle);
            this.mOwners.writeProfileOwner(userHandle);
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy != null) {
                this.mUserData.remove(userHandle);
            }
            if (this.mUserPasswordMetrics.get(userHandle) != null) {
                this.mUserPasswordMetrics.remove(userHandle);
            }
            File policyFile = new File(this.mInjector.environmentGetUserSystemDirectory(userHandle), DEVICE_POLICIES_XML);
            policyFile.delete();
            Slog.i(LOG_TAG, "Removed device policy file " + policyFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadOwners() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mOwners.load();
            this.setDeviceOwnerSystemPropertyLocked();
            this.findOwnerComponentIfNecessaryLocked();
            this.migrateUserRestrictionsIfNecessaryLocked();
            this.maybeSetDefaultDeviceOwnerUserRestrictionsLocked();
            this.updateDeviceOwnerLocked();
        }
    }

    private void maybeSetDefaultDeviceOwnerUserRestrictionsLocked() {
        ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
        if (deviceOwner != null) {
            this.maybeSetDefaultRestrictionsForAdminLocked(this.mOwners.getDeviceOwnerUserId(), deviceOwner, UserRestrictionsUtils.getDefaultEnabledForDeviceOwner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSetDefaultProfileOwnerUserRestrictions() {
        Object object = this.getLockObject();
        synchronized (object) {
            for (int userId : this.mOwners.getProfileOwnerKeys()) {
                ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userId);
                if (profileOwner == null || !this.mUserManager.isManagedProfile(userId)) continue;
                this.maybeSetDefaultRestrictionsForAdminLocked(userId, profileOwner, UserRestrictionsUtils.getDefaultEnabledForManagedProfiles());
                this.ensureUnknownSourcesRestrictionForProfileOwnerLocked(userId, profileOwner, false);
            }
        }
    }

    private void ensureUnknownSourcesRestrictionForProfileOwnerLocked(int userId, ActiveAdmin profileOwner, boolean newOwner) {
        if (newOwner || this.mInjector.settingsSecureGetIntForUser("unknown_sources_default_reversed", 0, userId) != 0) {
            profileOwner.ensureUserRestrictions().putBoolean("no_install_unknown_sources", true);
            this.saveUserRestrictionsLocked(userId);
            this.mInjector.settingsSecurePutIntForUser("unknown_sources_default_reversed", 0, userId);
        }
    }

    private void maybeSetDefaultRestrictionsForAdminLocked(int userId, ActiveAdmin admin, Set<String> defaultRestrictions) {
        if (defaultRestrictions.equals(admin.defaultEnabledRestrictionsAlreadySet)) {
            return;
        }
        Slog.i(LOG_TAG, "New user restrictions need to be set by default for user " + userId);
        ArraySet<String> restrictionsToSet = new ArraySet<String>(defaultRestrictions);
        restrictionsToSet.removeAll(admin.defaultEnabledRestrictionsAlreadySet);
        if (!restrictionsToSet.isEmpty()) {
            for (String restriction : restrictionsToSet) {
                admin.ensureUserRestrictions().putBoolean(restriction, true);
            }
            admin.defaultEnabledRestrictionsAlreadySet.addAll(restrictionsToSet);
            Slog.i(LOG_TAG, "Enabled the following restrictions by default: " + restrictionsToSet);
            this.saveUserRestrictionsLocked(userId);
        }
    }

    private void setDeviceOwnerSystemPropertyLocked() {
        boolean deviceProvisioned = this.mInjector.settingsGlobalGetInt("device_provisioned", 0) != 0;
        boolean hasDeviceOwner = this.mOwners.hasDeviceOwner();
        if (!hasDeviceOwner && !deviceProvisioned) {
            return;
        }
        if (StorageManager.inCryptKeeperBounce()) {
            return;
        }
        if (!this.mInjector.systemPropertiesGet(PROPERTY_DEVICE_OWNER_PRESENT, "").isEmpty()) {
            Slog.w(LOG_TAG, "Trying to set ro.device_owner, but it has already been set?");
        } else {
            String value = Boolean.toString(hasDeviceOwner);
            this.mInjector.systemPropertiesSet(PROPERTY_DEVICE_OWNER_PRESENT, value);
            Slog.i(LOG_TAG, "Set ro.device_owner property to " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartSecurityLogMonitorOnActivityManagerReady() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mInjector.securityLogIsLoggingEnabled()) {
                this.mSecurityLogMonitor.start();
                this.mInjector.runCryptoSelfTest();
                this.maybePauseDeviceWideLoggingLocked();
            }
        }
    }

    private void findOwnerComponentIfNecessaryLocked() {
        if (!this.mOwners.hasDeviceOwner()) {
            return;
        }
        ComponentName doComponentName = this.mOwners.getDeviceOwnerComponent();
        if (!TextUtils.isEmpty(doComponentName.getClassName())) {
            return;
        }
        ComponentName doComponent = this.findAdminComponentWithPackageLocked(doComponentName.getPackageName(), this.mOwners.getDeviceOwnerUserId());
        if (doComponent == null) {
            Slog.e(LOG_TAG, "Device-owner isn't registered as device-admin");
        } else {
            this.mOwners.setDeviceOwnerWithRestrictionsMigrated(doComponent, this.mOwners.getDeviceOwnerName(), this.mOwners.getDeviceOwnerUserId(), !this.mOwners.getDeviceOwnerUserRestrictionsNeedsMigration());
            this.mOwners.writeDeviceOwner();
        }
    }

    private void migrateUserRestrictionsIfNecessaryLocked() {
        boolean migrated = false;
        if (this.mOwners.getDeviceOwnerUserRestrictionsNeedsMigration()) {
            migrated = true;
            ActiveAdmin deviceOwnerAdmin = this.getDeviceOwnerAdminLocked();
            this.migrateUserRestrictionsForUser(UserHandle.SYSTEM, deviceOwnerAdmin, null, true);
            this.pushUserRestrictions(0);
            this.mOwners.setDeviceOwnerUserRestrictionsMigrated();
        }
        ArraySet<String> secondaryUserExceptionList = Sets.newArraySet("no_outgoing_calls", "no_sms");
        for (UserInfo ui : this.mUserManager.getUsers()) {
            int userId = ui.id;
            if (!this.mOwners.getProfileOwnerUserRestrictionsNeedsMigration(userId)) continue;
            migrated = true;
            ActiveAdmin profileOwnerAdmin = this.getProfileOwnerAdminLocked(userId);
            ArraySet<String> exceptionList = userId == 0 ? null : secondaryUserExceptionList;
            this.migrateUserRestrictionsForUser(ui.getUserHandle(), profileOwnerAdmin, exceptionList, false);
            this.pushUserRestrictions(userId);
            this.mOwners.setProfileOwnerUserRestrictionsMigrated(userId);
        }
    }

    private void migrateUserRestrictionsForUser(UserHandle user, ActiveAdmin admin, Set<String> exceptionList, boolean isDeviceOwner) {
        Bundle origRestrictions = this.mUserManagerInternal.getBaseUserRestrictions(user.getIdentifier());
        Bundle newBaseRestrictions = new Bundle();
        Bundle newOwnerRestrictions = new Bundle();
        for (String key : origRestrictions.keySet()) {
            boolean canOwnerChange;
            if (!origRestrictions.getBoolean(key)) continue;
            boolean bl = canOwnerChange = isDeviceOwner ? UserRestrictionsUtils.canDeviceOwnerChange(key) : UserRestrictionsUtils.canProfileOwnerChange(key, user.getIdentifier());
            if (!canOwnerChange || exceptionList != null && exceptionList.contains(key)) {
                newBaseRestrictions.putBoolean(key, true);
                continue;
            }
            newOwnerRestrictions.putBoolean(key, true);
        }
        this.mUserManagerInternal.setBaseUserRestrictionsByDpmsForMigration(user.getIdentifier(), newBaseRestrictions);
        if (admin != null) {
            admin.ensureUserRestrictions().clear();
            admin.ensureUserRestrictions().putAll(newOwnerRestrictions);
        } else {
            Slog.w(LOG_TAG, "ActiveAdmin for DO/PO not found. user=" + user.getIdentifier());
        }
        this.saveSettingsLocked(user.getIdentifier());
    }

    private ComponentName findAdminComponentWithPackageLocked(String packageName, int userId) {
        DevicePolicyData policy = this.getUserData(userId);
        int n = policy.mAdminList.size();
        ComponentName found = null;
        int nFound = 0;
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!packageName.equals(admin.info.getPackageName())) continue;
            if (nFound == 0) {
                found = admin.info.getComponent();
            }
            ++nFound;
        }
        if (nFound > 1) {
            Slog.w(LOG_TAG, "Multiple DA found; assume the first one is DO.");
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExpirationAlarmCheckLocked(Context context, int userHandle, boolean parent) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null, userHandle, parent);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + MS_PER_DAY;
        } else {
            long alarmInterval = timeToExpire % MS_PER_DAY;
            if (alarmInterval == 0L) {
                alarmInterval = MS_PER_DAY;
            }
            alarmTime = now + alarmInterval;
        }
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            int affectedUserHandle = parent ? this.getProfileParentId(userHandle) : userHandle;
            AlarmManager am = this.mInjector.getAlarmManager();
            PendingIntent pi = PendingIntent.getBroadcastAsUser(context, 5571, new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), 0x48000000, UserHandle.of(affectedUserHandle));
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle) {
        this.ensureLocked();
        ActiveAdmin admin = this.getUserData((int)userHandle).mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle, boolean parent) {
        ActiveAdmin admin;
        this.ensureLocked();
        if (parent) {
            this.enforceManagedProfile(userHandle, "call APIs on the parent profile");
        }
        if ((admin = this.getActiveAdminUncheckedLocked(who, userHandle)) != null && parent) {
            admin = admin.getParentActiveAdmin();
        }
        return admin;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        this.ensureLocked();
        int callingUid = this.mInjector.binderGetCallingUid();
        ActiveAdmin result = this.getActiveAdminWithPolicyForUidLocked(who, reqPolicy, callingUid);
        if (result != null) {
            return result;
        }
        if (who != null) {
            int userId = UserHandle.getUserId(callingUid);
            DevicePolicyData policy = this.getUserData(userId);
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (reqPolicy == -2) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the device");
            }
            if (reqPolicy == -1) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the profile");
            }
            throw new SecurityException("Admin " + admin.info.getComponent() + " did not specify uses-policy for: " + admin.info.getTagForPolicy(reqPolicy));
        }
        throw new SecurityException("No active admin owned by uid " + this.mInjector.binderGetCallingUid() + " for policy #" + reqPolicy);
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy, boolean parent) throws SecurityException {
        this.ensureLocked();
        if (parent) {
            this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "call APIs on the parent profile");
        }
        ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, reqPolicy);
        return parent ? admin.getParentActiveAdmin() : admin;
    }

    private ActiveAdmin getActiveAdminForUidLocked(ComponentName who, int uid) {
        this.ensureLocked();
        int userId = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userId);
        ActiveAdmin admin = policy.mAdminMap.get(who);
        if (admin == null) {
            throw new SecurityException("No active admin " + who);
        }
        if (admin.getUid() != uid) {
            throw new SecurityException("Admin " + who + " is not owned by uid " + uid);
        }
        return admin;
    }

    private ActiveAdmin getActiveAdminWithPolicyForUidLocked(ComponentName who, int reqPolicy, int uid) {
        this.ensureLocked();
        int userId = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userId);
        if (who != null) {
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != uid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + uid);
            }
            if (this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) {
                return admin;
            }
        } else {
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.getUid() != uid || !this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) continue;
                return admin;
            }
        }
        return null;
    }

    @VisibleForTesting
    boolean isActiveAdminWithPolicyForUserLocked(ActiveAdmin admin, int reqPolicy, int userId) {
        this.ensureLocked();
        boolean ownsDevice = this.isDeviceOwner(admin.info.getComponent(), userId);
        boolean ownsProfile = this.isProfileOwner(admin.info.getComponent(), userId);
        if (reqPolicy == -2) {
            return ownsDevice;
        }
        if (reqPolicy == -1) {
            return ownsDevice || ownsProfile;
        }
        return admin.info.usesPolicy(reqPolicy);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        this.sendAdminCommandLocked(admin, action, null, result);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, Bundle adminExtras, BroadcastReceiver result) {
        this.sendAdminCommandLocked(admin, action, adminExtras, result, false);
    }

    boolean sendAdminCommandLocked(ActiveAdmin admin, String action, Bundle adminExtras, BroadcastReceiver result, boolean inForeground) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (UserManager.isDeviceInDemoMode(this.mContext)) {
            intent.addFlags(0x10000000);
        }
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (inForeground) {
            intent.addFlags(0x10000000);
        }
        if (adminExtras != null) {
            intent.putExtras(adminExtras);
        }
        if (this.mInjector.getPackageManager().queryBroadcastReceiversAsUser(intent, 0x10000000, admin.getUserHandle()).isEmpty()) {
            return false;
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcastAsUser(intent, admin.getUserHandle(), null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcastAsUser(intent, admin.getUserHandle());
        }
        return true;
    }

    void sendAdminCommandLocked(String action, int reqPolicy, int userHandle, Bundle adminExtras) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int count = policy.mAdminList.size();
        for (int i = 0; i < count; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!admin.info.usesPolicy(reqPolicy)) continue;
            this.sendAdminCommandLocked(admin, action, adminExtras, null);
        }
    }

    private void sendAdminCommandToSelfAndProfilesLocked(String action, int reqPolicy, int userHandle, Bundle adminExtras) {
        int[] profileIds;
        for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userHandle)) {
            this.sendAdminCommandLocked(action, reqPolicy, profileId, adminExtras);
        }
    }

    private void sendAdminCommandForLockscreenPoliciesLocked(String action, int reqPolicy, int userHandle) {
        Bundle extras = new Bundle();
        extras.putParcelable("android.intent.extra.USER", UserHandle.of(userHandle));
        if (this.isSeparateProfileChallengeEnabled(userHandle)) {
            this.sendAdminCommandLocked(action, reqPolicy, userHandle, extras);
        } else {
            this.sendAdminCommandToSelfAndProfilesLocked(action, reqPolicy, userHandle, extras);
        }
    }

    void removeActiveAdminLocked(final ComponentName adminReceiver, final int userHandle) {
        ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        if (admin != null && !policy.mRemovingAdmins.contains(adminReceiver)) {
            policy.mRemovingAdmins.add(adminReceiver);
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    DevicePolicyManagerService.this.removeAdminArtifacts(adminReceiver, userHandle);
                    DevicePolicyManagerService.this.removePackageIfRequired(adminReceiver.getPackageName(), userHandle);
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName, int userHandle, boolean throwForMissingPermission) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        ActivityInfo ai = null;
        try {
            ai = this.mIPackageManager.getReceiverInfo(adminName, 819328, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (ai == null) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        if (!"android.permission.BIND_DEVICE_ADMIN".equals(ai.permission)) {
            String message = "DeviceAdminReceiver " + adminName + " must be protected with " + "android.permission.BIND_DEVICE_ADMIN";
            Slog.w(LOG_TAG, message);
            if (throwForMissingPermission && ai.applicationInfo.targetSdkVersion > 23) {
                throw new IllegalArgumentException(message);
            }
        }
        try {
            return new DeviceAdminInfo(this.mContext, ai);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
    }

    private File getPolicyFileDirectory(int userId) {
        return userId == 0 ? new File(this.mInjector.getDevicePolicyFilePathForSystemUser()) : this.mInjector.environmentGetUserSystemDirectory(userId);
    }

    private JournaledFile makeJournaledFile(int userId) {
        String base = new File(this.getPolicyFileDirectory(userId), DEVICE_POLICIES_XML).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        JournaledFile journal = this.makeJournaledFile(userHandle);
        FileOutputStream stream = null;
        try {
            int i;
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "policies");
            if (policy.mRestrictionsProvider != null) {
                out.attribute(null, ATTR_PERMISSION_PROVIDER, policy.mRestrictionsProvider.flattenToString());
            }
            if (policy.mUserSetupComplete) {
                out.attribute(null, ATTR_SETUP_COMPLETE, Boolean.toString(true));
            }
            if (policy.mPaired) {
                out.attribute(null, ATTR_DEVICE_PAIRED, Boolean.toString(true));
            }
            if (policy.mDeviceProvisioningConfigApplied) {
                out.attribute(null, ATTR_DEVICE_PROVISIONING_CONFIG_APPLIED, Boolean.toString(true));
            }
            if (policy.mUserProvisioningState != 0) {
                out.attribute(null, ATTR_PROVISIONING_STATE, Integer.toString(policy.mUserProvisioningState));
            }
            if (policy.mPermissionPolicy != 0) {
                out.attribute(null, ATTR_PERMISSION_POLICY, Integer.toString(policy.mPermissionPolicy));
            }
            for (int i2 = 0; i2 < policy.mDelegationMap.size(); ++i2) {
                String delegatePackage = policy.mDelegationMap.keyAt(i2);
                List<String> scopes = policy.mDelegationMap.valueAt(i2);
                for (String scope : scopes) {
                    out.startTag(null, "delegation");
                    out.attribute(null, "delegatePackage", delegatePackage);
                    out.attribute(null, "scope", scope);
                    out.endTag(null, "delegation");
                }
            }
            int N = policy.mAdminList.size();
            for (i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, ATTR_NAME, ap.info.getComponent().flattenToString());
                ap.writeToXml(out);
                out.endTag(null, "admin");
            }
            if (policy.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, ATTR_VALUE, Integer.toString(policy.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (policy.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, ATTR_VALUE, Integer.toString(policy.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (!this.mInjector.storageManagerIsFileBasedEncryptionEnabled()) {
                out.startTag(null, TAG_PASSWORD_VALIDITY);
                out.attribute(null, ATTR_VALUE, Boolean.toString(policy.mPasswordValidAtLastCheckpoint));
                out.endTag(null, TAG_PASSWORD_VALIDITY);
            }
            for (i = 0; i < policy.mAcceptedCaCertificates.size(); ++i) {
                out.startTag(null, TAG_ACCEPTED_CA_CERTIFICATES);
                out.attribute(null, ATTR_NAME, policy.mAcceptedCaCertificates.valueAt(i));
                out.endTag(null, TAG_ACCEPTED_CA_CERTIFICATES);
            }
            for (i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String component = policy.mLockTaskPackages.get(i);
                out.startTag(null, TAG_LOCK_TASK_COMPONENTS);
                out.attribute(null, ATTR_NAME, component);
                out.endTag(null, TAG_LOCK_TASK_COMPONENTS);
            }
            if (policy.mLockTaskFeatures != 0) {
                out.startTag(null, TAG_LOCK_TASK_FEATURES);
                out.attribute(null, ATTR_VALUE, Integer.toString(policy.mLockTaskFeatures));
                out.endTag(null, TAG_LOCK_TASK_FEATURES);
            }
            if (policy.mStatusBarDisabled) {
                out.startTag(null, TAG_STATUS_BAR);
                out.attribute(null, ATTR_DISABLED, Boolean.toString(policy.mStatusBarDisabled));
                out.endTag(null, TAG_STATUS_BAR);
            }
            if (policy.doNotAskCredentialsOnBoot) {
                out.startTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
                out.endTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
            }
            for (String id2 : policy.mAffiliationIds) {
                out.startTag(null, TAG_AFFILIATION_ID);
                out.attribute(null, ATTR_ID, id2);
                out.endTag(null, TAG_AFFILIATION_ID);
            }
            if (policy.mLastSecurityLogRetrievalTime >= 0L) {
                out.startTag(null, TAG_LAST_SECURITY_LOG_RETRIEVAL);
                out.attribute(null, ATTR_VALUE, Long.toString(policy.mLastSecurityLogRetrievalTime));
                out.endTag(null, TAG_LAST_SECURITY_LOG_RETRIEVAL);
            }
            if (policy.mLastBugReportRequestTime >= 0L) {
                out.startTag(null, TAG_LAST_BUG_REPORT_REQUEST);
                out.attribute(null, ATTR_VALUE, Long.toString(policy.mLastBugReportRequestTime));
                out.endTag(null, TAG_LAST_BUG_REPORT_REQUEST);
            }
            if (policy.mLastNetworkLogsRetrievalTime >= 0L) {
                out.startTag(null, TAG_LAST_NETWORK_LOG_RETRIEVAL);
                out.attribute(null, ATTR_VALUE, Long.toString(policy.mLastNetworkLogsRetrievalTime));
                out.endTag(null, TAG_LAST_NETWORK_LOG_RETRIEVAL);
            }
            if (policy.mAdminBroadcastPending) {
                out.startTag(null, TAG_ADMIN_BROADCAST_PENDING);
                out.attribute(null, ATTR_VALUE, Boolean.toString(policy.mAdminBroadcastPending));
                out.endTag(null, TAG_ADMIN_BROADCAST_PENDING);
            }
            if (policy.mInitBundle != null) {
                out.startTag(null, TAG_INITIALIZATION_BUNDLE);
                policy.mInitBundle.saveToXml(out);
                out.endTag(null, TAG_INITIALIZATION_BUNDLE);
            }
            if (policy.mPasswordTokenHandle != 0L) {
                out.startTag(null, TAG_PASSWORD_TOKEN_HANDLE);
                out.attribute(null, ATTR_VALUE, Long.toString(policy.mPasswordTokenHandle));
                out.endTag(null, TAG_PASSWORD_TOKEN_HANDLE);
            }
            if (policy.mCurrentInputMethodSet) {
                out.startTag(null, TAG_CURRENT_INPUT_METHOD_SET);
                out.endTag(null, TAG_CURRENT_INPUT_METHOD_SET);
            }
            for (String cert : policy.mOwnerInstalledCaCerts) {
                out.startTag(null, TAG_OWNER_INSTALLED_CA_CERT);
                out.attribute(null, ATTR_ALIAS, cert);
                out.endTag(null, TAG_OWNER_INSTALLED_CA_CERT);
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            journal.commit();
            this.sendChangedNotification(userHandle);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed writing file", e);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedNotification(int userHandle) {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userHandle));
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void loadSettingsLocked(DevicePolicyData policy, int userHandle) {
        JournaledFile journal = this.makeJournaledFile(userHandle);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        boolean needsRewrite = false;
        try {
            String appRestrictionsDelegate;
            String certDelegate;
            String permissionPolicy;
            String provisioningState;
            String deviceProvisioningConfigApplied;
            String paired;
            String userSetupComplete;
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            String permissionProvider = parser.getAttributeValue(null, ATTR_PERMISSION_PROVIDER);
            if (permissionProvider != null) {
                policy.mRestrictionsProvider = ComponentName.unflattenFromString(permissionProvider);
            }
            if ((userSetupComplete = parser.getAttributeValue(null, ATTR_SETUP_COMPLETE)) != null && Boolean.toString(true).equals(userSetupComplete)) {
                policy.mUserSetupComplete = true;
            }
            if ((paired = parser.getAttributeValue(null, ATTR_DEVICE_PAIRED)) != null && Boolean.toString(true).equals(paired)) {
                policy.mPaired = true;
            }
            if ((deviceProvisioningConfigApplied = parser.getAttributeValue(null, ATTR_DEVICE_PROVISIONING_CONFIG_APPLIED)) != null && Boolean.toString(true).equals(deviceProvisioningConfigApplied)) {
                policy.mDeviceProvisioningConfigApplied = true;
            }
            if (!TextUtils.isEmpty(provisioningState = parser.getAttributeValue(null, ATTR_PROVISIONING_STATE))) {
                policy.mUserProvisioningState = Integer.parseInt(provisioningState);
            }
            if (!TextUtils.isEmpty(permissionPolicy = parser.getAttributeValue(null, ATTR_PERMISSION_POLICY))) {
                policy.mPermissionPolicy = Integer.parseInt(permissionPolicy);
            }
            if ((certDelegate = parser.getAttributeValue(null, ATTR_DELEGATED_CERT_INSTALLER)) != null) {
                List<String> scopes = policy.mDelegationMap.get(certDelegate);
                if (scopes == null) {
                    scopes = new ArrayList<String>();
                    policy.mDelegationMap.put(certDelegate, scopes);
                }
                if (!scopes.contains("delegation-cert-install")) {
                    scopes.add("delegation-cert-install");
                    needsRewrite = true;
                }
            }
            if ((appRestrictionsDelegate = parser.getAttributeValue(null, ATTR_APPLICATION_RESTRICTIONS_MANAGER)) != null) {
                List<String> scopes = policy.mDelegationMap.get(appRestrictionsDelegate);
                if (scopes == null) {
                    scopes = new ArrayList<String>();
                    policy.mDelegationMap.put(appRestrictionsDelegate, scopes);
                }
                if (!scopes.contains("delegation-app-restrictions")) {
                    scopes.add("delegation-app-restrictions");
                    needsRewrite = true;
                }
            }
            type = parser.next();
            int outerDepth = parser.getDepth();
            policy.mLockTaskPackages.clear();
            policy.mAdminList.clear();
            policy.mAdminMap.clear();
            policy.mAffiliationIds.clear();
            policy.mOwnerInstalledCaCerts.clear();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString(name), userHandle, false);
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai, false);
                        ap.readFromXml(parser);
                        policy.mAdminMap.put(ap.info.getComponent(), ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w(LOG_TAG, "Failed loading admin " + name, e);
                    }
                    continue;
                }
                if ("delegation".equals(tag)) {
                    String delegatePackage = parser.getAttributeValue(null, "delegatePackage");
                    String scope = parser.getAttributeValue(null, "scope");
                    List<String> scopes = policy.mDelegationMap.get(delegatePackage);
                    if (scopes == null) {
                        scopes = new ArrayList<String>();
                        policy.mDelegationMap.put(delegatePackage, scopes);
                    }
                    if (scopes.contains(scope)) continue;
                    scopes.add(scope);
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    policy.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    policy.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_ACCEPTED_CA_CERTIFICATES.equals(tag)) {
                    policy.mAcceptedCaCertificates.add(parser.getAttributeValue(null, ATTR_NAME));
                    continue;
                }
                if (TAG_LOCK_TASK_COMPONENTS.equals(tag)) {
                    policy.mLockTaskPackages.add(parser.getAttributeValue(null, ATTR_NAME));
                    continue;
                }
                if (TAG_LOCK_TASK_FEATURES.equals(tag)) {
                    policy.mLockTaskFeatures = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_STATUS_BAR.equals(tag)) {
                    policy.mStatusBarDisabled = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_DISABLED));
                    continue;
                }
                if (DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML.equals(tag)) {
                    policy.doNotAskCredentialsOnBoot = true;
                    continue;
                }
                if (TAG_AFFILIATION_ID.equals(tag)) {
                    policy.mAffiliationIds.add(parser.getAttributeValue(null, ATTR_ID));
                    continue;
                }
                if (TAG_LAST_SECURITY_LOG_RETRIEVAL.equals(tag)) {
                    policy.mLastSecurityLogRetrievalTime = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_LAST_BUG_REPORT_REQUEST.equals(tag)) {
                    policy.mLastBugReportRequestTime = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_LAST_NETWORK_LOG_RETRIEVAL.equals(tag)) {
                    policy.mLastNetworkLogsRetrievalTime = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_ADMIN_BROADCAST_PENDING.equals(tag)) {
                    String pending = parser.getAttributeValue(null, ATTR_VALUE);
                    policy.mAdminBroadcastPending = Boolean.toString(true).equals(pending);
                    continue;
                }
                if (TAG_INITIALIZATION_BUNDLE.equals(tag)) {
                    policy.mInitBundle = PersistableBundle.restoreFromXml(parser);
                    continue;
                }
                if ("active-password".equals(tag)) {
                    needsRewrite = true;
                    continue;
                }
                if (TAG_PASSWORD_VALIDITY.equals(tag)) {
                    if (this.mInjector.storageManagerIsFileBasedEncryptionEnabled()) continue;
                    policy.mPasswordValidAtLastCheckpoint = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_PASSWORD_TOKEN_HANDLE.equals(tag)) {
                    policy.mPasswordTokenHandle = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_CURRENT_INPUT_METHOD_SET.equals(tag)) {
                    policy.mCurrentInputMethodSet = true;
                    continue;
                }
                if (TAG_OWNER_INSTALLED_CA_CERT.equals(tag)) {
                    policy.mOwnerInstalledCaCerts.add(parser.getAttributeValue(null, ATTR_ALIAS));
                    continue;
                }
                Slog.w(LOG_TAG, "Unknown tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (FileNotFoundException parser) {
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed parsing " + file, e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        policy.mAdminList.addAll(policy.mAdminMap.values());
        if (needsRewrite) {
            this.saveSettingsLocked(userHandle);
        }
        this.validatePasswordOwnerLocked(policy);
        this.updateMaximumTimeToLockLocked(userHandle);
        this.updateLockTaskPackagesLocked(policy.mLockTaskPackages, userHandle);
        this.updateLockTaskFeaturesLocked(policy.mLockTaskFeatures, userHandle);
        if (policy.mStatusBarDisabled) {
            this.setStatusBarDisabledInternal(policy.mStatusBarDisabled, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockTaskPackagesLocked(List<String> packages, int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            this.mInjector.getIActivityManager().updateLockTaskPackages(userId, packages.toArray(new String[packages.size()]));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockTaskFeaturesLocked(int flags, int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            this.mInjector.getIActivityManager().updateLockTaskFeatures(userId, flags);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceOwnerLocked() {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            ComponentName deviceOwnerComponent = this.mOwners.getDeviceOwnerComponent();
            if (deviceOwnerComponent != null) {
                this.mInjector.getIActivityManager().updateDeviceOwner(deviceOwnerComponent.getPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 196608: 
            case 262144: 
            case 327680: 
            case 393216: 
            case 524288: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked(DevicePolicyData policy) {
        if (policy.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                if (policy.mAdminList.get(i).getUid() != policy.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w(LOG_TAG, "Previous password owner " + policy.mPasswordOwner + " no longer active; disabling");
                policy.mPasswordOwner = -1;
            }
        }
    }

    @Override
    @VisibleForTesting
    void systemReady(int phase) {
        if (!this.mHasFeature) {
            return;
        }
        switch (phase) {
            case 480: {
                this.onLockSettingsReady();
                this.loadAdminDataAsync();
                this.mOwners.systemReady();
                break;
            }
            case 550: {
                this.maybeStartSecurityLogMonitorOnActivityManagerReady();
                break;
            }
            case 1000: {
                this.ensureDeviceOwnerUserStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLockSettingsReady() {
        List<String> packageList;
        this.getUserData(0);
        this.loadOwners();
        this.cleanUpOldUsers();
        this.maybeSetDefaultProfileOwnerUserRestrictions();
        this.handleStartUser(0);
        this.maybeLogStart();
        this.mSetupContentObserver.register();
        this.updateUserSetupCompleteAndPaired();
        Object object = this.getLockObject();
        synchronized (object) {
            packageList = this.getKeepUninstalledPackagesLocked();
        }
        if (packageList != null) {
            this.mInjector.getPackageManagerInternal().setKeepUninstalledPackages(packageList);
        }
        object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            if (deviceOwner != null) {
                this.mUserManagerInternal.setForceEphemeralUsers(deviceOwner.forceEphemeralUsers);
                ActivityManagerInternal activityManagerInternal = this.mInjector.getActivityManagerInternal();
                activityManagerInternal.setSwitchingFromSystemUserMessage(deviceOwner.startUserSessionMessage);
                activityManagerInternal.setSwitchingToSystemUserMessage(deviceOwner.endUserSessionMessage);
            }
            this.revertTransferOwnershipIfNecessaryLocked();
        }
    }

    private void revertTransferOwnershipIfNecessaryLocked() {
        if (!this.mTransferOwnershipMetadataManager.metadataFileExists()) {
            return;
        }
        Slog.e(LOG_TAG, "Owner transfer metadata file exists! Reverting transfer.");
        TransferOwnershipMetadataManager.Metadata metadata = this.mTransferOwnershipMetadataManager.loadMetadataFile();
        if (metadata.adminType.equals(LOG_TAG_PROFILE_OWNER)) {
            this.transferProfileOwnershipLocked(metadata.targetComponent, metadata.sourceComponent, metadata.userId);
            this.deleteTransferOwnershipMetadataFileLocked();
            this.deleteTransferOwnershipBundleLocked(metadata.userId);
        } else if (metadata.adminType.equals(LOG_TAG_DEVICE_OWNER)) {
            this.transferDeviceOwnershipLocked(metadata.targetComponent, metadata.sourceComponent, metadata.userId);
            this.deleteTransferOwnershipMetadataFileLocked();
            this.deleteTransferOwnershipBundleLocked(metadata.userId);
        }
        this.updateSystemUpdateFreezePeriodsRecord(true);
    }

    private void maybeLogStart() {
        if (!SecurityLog.isLoggingEnabled()) {
            return;
        }
        String verifiedBootState = this.mInjector.systemPropertiesGet("ro.boot.verifiedbootstate");
        String verityMode = this.mInjector.systemPropertiesGet("ro.boot.veritymode");
        SecurityLog.writeEvent(210009, verifiedBootState, verityMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDeviceOwnerUserStarted() {
        int userId;
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.mOwners.hasDeviceOwner()) {
                return;
            }
            userId = this.mOwners.getDeviceOwnerUserId();
        }
        if (userId != 0) {
            try {
                this.mInjector.getIActivityManager().startUserInBackground(userId);
            }
            catch (RemoteException e) {
                Slog.w(LOG_TAG, "Exception starting user", e);
            }
        }
    }

    @Override
    void handleStartUser(int userId) {
        this.updateScreenCaptureDisabled(userId, this.getScreenCaptureDisabled(null, userId));
        this.pushUserRestrictions(userId);
        this.startOwnerService(userId, "start-user");
    }

    @Override
    void handleUnlockUser(int userId) {
        this.startOwnerService(userId, "unlock-user");
    }

    @Override
    void handleStopUser(int userId) {
        this.stopOwnerService(userId, "stop-user");
    }

    private void startOwnerService(int userId, String actionForLog) {
        ComponentName owner = this.getOwnerComponent(userId);
        if (owner != null) {
            this.mDeviceAdminServiceController.startServiceForOwner(owner.getPackageName(), userId, actionForLog);
        }
    }

    private void stopOwnerService(int userId, String actionForLog) {
        this.mDeviceAdminServiceController.stopServiceForOwner(userId, actionForLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOldUsers() {
        ArraySet<Integer> usersWithData;
        Set<Integer> usersWithProfileOwners;
        Object object = this.getLockObject();
        synchronized (object) {
            usersWithProfileOwners = this.mOwners.getProfileOwnerKeys();
            usersWithData = new ArraySet<Integer>();
            for (int i = 0; i < this.mUserData.size(); ++i) {
                usersWithData.add(this.mUserData.keyAt(i));
            }
        }
        List<UserInfo> allUsers = this.mUserManager.getUsers();
        ArraySet<Integer> deletedUsers = new ArraySet<Integer>();
        deletedUsers.addAll(usersWithProfileOwners);
        deletedUsers.addAll((Collection<Integer>)usersWithData);
        for (UserInfo userInfo : allUsers) {
            deletedUsers.remove(userInfo.id);
        }
        for (Integer userId : deletedUsers) {
            this.removeUserData(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification(int userHandle) {
        Bundle adminExtras = new Bundle();
        adminExtras.putParcelable("android.intent.extra.USER", UserHandle.of(userHandle));
        Object object = this.getLockObject();
        synchronized (object) {
            long now = System.currentTimeMillis();
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, false);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || now < admin.passwordExpirationDate - EXPIRATION_GRACE_PERIOD_MS || admin.passwordExpirationDate <= 0L) continue;
                this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING", adminExtras, null);
            }
            this.setExpirationAlarmCheckLocked(this.mContext, userHandle, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInstalledCertificatesChanged(UserHandle userHandle, Collection<String> installedCertificates) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle.getIdentifier());
            boolean changed = false;
            changed |= policy.mAcceptedCaCertificates.retainAll(installedCertificates);
            if (changed |= policy.mOwnerInstalledCaCerts.retainAll(installedCertificates)) {
                this.saveSettingsLocked(userHandle.getIdentifier());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getAcceptedCaCertificates(UserHandle userHandle) {
        if (!this.mHasFeature) {
            return Collections.emptySet();
        }
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle.getIdentifier());
            return policy.mAcceptedCaCertificates;
        }
    }

    @Override
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.setActiveAdmin(adminReceiver, refreshing, userHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle, Bundle onEnableData) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        DeviceAdminInfo info = this.findAdmin(adminReceiver, userHandle, true);
        Object object = this.getLockObject();
        synchronized (object) {
            this.checkActiveAdminPrecondition(adminReceiver, info, policy);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                ActiveAdmin existingAdmin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
                if (!refreshing && existingAdmin != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info, false);
                newAdmin.testOnlyAdmin = existingAdmin != null ? existingAdmin.testOnlyAdmin : this.isPackageTestOnly(adminReceiver.getPackageName(), userHandle);
                policy.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin oldAdmin = policy.mAdminList.get(i);
                    if (!oldAdmin.info.getComponent().equals(adminReceiver)) continue;
                    replaceIndex = i;
                    break;
                }
                if (replaceIndex == -1) {
                    policy.mAdminList.add(newAdmin);
                    this.enableIfNecessary(info.getPackageName(), userHandle);
                    this.mUsageStatsManagerInternal.onActiveAdminAdded(adminReceiver.getPackageName(), userHandle);
                } else {
                    policy.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked(userHandle);
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED", onEnableData, null);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    private void loadAdminDataAsync() {
        this.mInjector.postOnSystemServerInitThreadPool(() -> {
            this.pushActiveAdminPackages();
            this.mUsageStatsManagerInternal.onAdminDataAvailable();
            this.pushAllMeteredRestrictedPackages();
            this.mInjector.getNetworkPolicyManagerInternal().onAdminDataAvailable();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushActiveAdminPackages() {
        Object object = this.getLockObject();
        synchronized (object) {
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int i = users.size() - 1; i >= 0; --i) {
                int userId = users.get((int)i).id;
                this.mUsageStatsManagerInternal.setActiveAdminApps(this.getActiveAdminPackagesLocked(userId), userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAllMeteredRestrictedPackages() {
        Object object = this.getLockObject();
        synchronized (object) {
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int i = users.size() - 1; i >= 0; --i) {
                int userId = users.get((int)i).id;
                this.mInjector.getNetworkPolicyManagerInternal().setMeteredRestrictedPackagesAsync(this.getMeteredDisabledPackagesLocked(userId), userId);
            }
        }
    }

    private void pushActiveAdminPackagesLocked(int userId) {
        this.mUsageStatsManagerInternal.setActiveAdminApps(this.getActiveAdminPackagesLocked(userId), userId);
    }

    private Set<String> getActiveAdminPackagesLocked(int userId) {
        DevicePolicyData policy = this.getUserData(userId);
        ArraySet<String> adminPkgs = null;
        for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
            String pkgName = policy.mAdminList.get((int)i).info.getPackageName();
            if (adminPkgs == null) {
                adminPkgs = new ArraySet<String>();
            }
            adminPkgs.add(pkgName);
        }
        return adminPkgs;
    }

    private void transferActiveAdminUncheckedLocked(ComponentName incomingReceiver, ComponentName outgoingReceiver, int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        if (!policy.mAdminMap.containsKey(outgoingReceiver) && policy.mAdminMap.containsKey(incomingReceiver)) {
            return;
        }
        DeviceAdminInfo incomingDeviceInfo = this.findAdmin(incomingReceiver, userHandle, true);
        ActiveAdmin adminToTransfer = policy.mAdminMap.get(outgoingReceiver);
        int oldAdminUid = adminToTransfer.getUid();
        adminToTransfer.transfer(incomingDeviceInfo);
        policy.mAdminMap.remove(outgoingReceiver);
        policy.mAdminMap.put(incomingReceiver, adminToTransfer);
        if (policy.mPasswordOwner == oldAdminUid) {
            policy.mPasswordOwner = adminToTransfer.getUid();
        }
        this.saveSettingsLocked(userHandle);
        this.sendAdminCommandLocked(adminToTransfer, "android.app.action.DEVICE_ADMIN_ENABLED", null, null);
    }

    private void checkActiveAdminPrecondition(ComponentName adminReceiver, DeviceAdminInfo info, DevicePolicyData policy) {
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        if (!info.getActivityInfo().applicationInfo.isInternal()) {
            throw new IllegalArgumentException("Only apps in internal storage can be active admin: " + adminReceiver);
        }
        if (info.getActivityInfo().applicationInfo.isInstantApp()) {
            throw new IllegalArgumentException("Instant apps cannot be device admins: " + adminReceiver);
        }
        if (policy.mRemovingAdmins.contains(adminReceiver)) {
            throw new IllegalArgumentException("Trying to set an admin which is being removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminActive(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            return this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRemovingAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policyData = this.getUserData(userHandle);
            return policyData.mRemovingAdmins.contains(adminReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentName> getActiveAdmins(int userHandle) {
        if (!this.mHasFeature) {
            return Collections.EMPTY_LIST;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(policy.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean packageHasActiveAdmins(String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemoveActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(adminReceiver, "ComponentName is null");
        this.enforceShell("forceRemoveActiveAdmin");
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.getLockObject();
            synchronized (object) {
                if (!this.isAdminTestOnlyLocked(adminReceiver, userHandle)) {
                    throw new SecurityException("Attempt to remove non-test admin " + adminReceiver + " " + userHandle);
                }
                if (this.isDeviceOwner(adminReceiver, userHandle)) {
                    this.clearDeviceOwnerLocked(this.getDeviceOwnerAdminLocked(), userHandle);
                }
                if (this.isProfileOwner(adminReceiver, userHandle)) {
                    ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle, false);
                    this.clearProfileOwnerLocked(admin, userHandle);
                }
            }
            this.removeAdminArtifacts(adminReceiver, userHandle);
            Slog.i(LOG_TAG, "Admin " + adminReceiver + " removed from user " + userHandle);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void clearDeviceOwnerUserRestrictionLocked(UserHandle userHandle) {
        if (this.mUserManager.hasUserRestriction("no_add_user", userHandle)) {
            this.mUserManager.setUserRestriction("no_add_user", false, userHandle);
        }
    }

    private boolean isPackageTestOnly(String packageName, int userHandle) {
        ApplicationInfo ai;
        try {
            ai = this.mInjector.getIPackageManager().getApplicationInfo(packageName, 786432, userHandle);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
        if (ai == null) {
            throw new IllegalStateException("Couldn't find package: " + packageName + " on user " + userHandle);
        }
        return (ai.flags & 0x100) != 0;
    }

    private boolean isAdminTestOnlyLocked(ComponentName who, int userHandle) {
        ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
        return admin != null && admin.testOnlyAdmin;
    }

    private void enforceShell(String method) {
        int callingUid = this.mInjector.binderGetCallingUid();
        if (callingUid != 2000 && callingUid != 0) {
            throw new SecurityException("Non-shell user attempted to call " + method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceUserUnlocked(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            if (this.isDeviceOwner(adminReceiver, userHandle) || this.isProfileOwner(adminReceiver, userHandle)) {
                Slog.e(LOG_TAG, "Device/profile owner cannot be removed: component=" + adminReceiver);
                return;
            }
            if (admin.getUid() != this.mInjector.binderGetCallingUid()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver, userHandle);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    @Override
    public boolean isSeparateProfileChallengeAllowed(int userHandle) {
        ComponentName profileOwner = this.getProfileOwner(userHandle);
        return profileOwner != null && this.getTargetSdk(profileOwner.getPackageName(), userHandle) > 23;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordQuality(ComponentName who, int quality, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService.validateQualityConstant(quality);
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.quality != quality) {
                metrics.quality = quality;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    private void updatePasswordValidityCheckpointLocked(int userHandle, boolean parent) {
        int credentialOwner = this.getCredentialOwner(userHandle, parent);
        DevicePolicyData policy = this.getUserData(credentialOwner);
        PasswordMetrics metrics = this.getUserPasswordMetricsLocked(credentialOwner);
        if (metrics == null) {
            metrics = new PasswordMetrics();
        }
        policy.mPasswordValidAtLastCheckpoint = this.isPasswordSufficientForUserWithoutCheckpointLocked(metrics, userHandle, parent);
        this.saveSettingsLocked(credentialOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            int mode = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordMetrics.quality : mode;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (mode >= admin.minimumPasswordMetrics.quality) continue;
                mode = admin.minimumPasswordMetrics.quality;
            }
            return mode;
        }
    }

    private List<ActiveAdmin> getActiveAdminsForLockscreenPoliciesLocked(int userHandle, boolean parent) {
        if (!parent && this.isSeparateProfileChallengeEnabled(userHandle)) {
            return this.getUserDataUnchecked((int)userHandle).mAdminList;
        }
        ArrayList<ActiveAdmin> admins = new ArrayList<ActiveAdmin>();
        for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
            DevicePolicyData policy = this.getUserData(userInfo.id);
            if (!userInfo.isManagedProfile()) {
                admins.addAll(policy.mAdminList);
                continue;
            }
            boolean hasSeparateChallenge = this.isSeparateProfileChallengeEnabled(userInfo.id);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (admin.hasParentActiveAdmin()) {
                    admins.add(admin.getParentActiveAdmin());
                }
                if (hasSeparateChallenge) continue;
                admins.add(admin);
            }
        }
        return admins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSeparateProfileChallengeEnabled(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userHandle);
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLength(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.length != length) {
                metrics.length = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumLength(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.length, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordHistoryLength(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
        }
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userId) : userId;
            SecurityLog.writeEvent(210018, who.getPackageName(), userId, affectedUserId, length);
        }
    }

    @Override
    public int getPasswordHistoryLength(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.passwordHistoryLength, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordExpirationTimeout(ComponentName who, long timeout, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkArgumentNonnegative(timeout, "Timeout must be >= 0 ms");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            long expiration;
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6, parent);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w(LOG_TAG, "setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration)));
            }
            this.saveSettingsLocked(userHandle);
            this.setExpirationAlarmCheckLocked(this.mContext, userHandle, parent);
        }
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userHandle) : userHandle;
            SecurityLog.writeEvent(210016, who.getPackageName(), userHandle, affectedUserId, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpirationTimeout(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            long timeout = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                long l = admin != null ? admin.passwordExpirationTimeout : timeout;
                return l;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                timeout = admin.passwordExpirationTimeout;
            }
            return timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        Object object = this.getLockObject();
        synchronized (object) {
            List<String> providers;
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                activeAdmin.crossProfileWidgetProviders = new ArrayList<String>();
            }
            if (!(providers = activeAdmin.crossProfileWidgetProviders).contains(packageName)) {
                providers.add(packageName);
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null || activeAdmin.crossProfileWidgetProviders.isEmpty()) {
                return false;
            }
            List<String> providers = activeAdmin.crossProfileWidgetProviders;
            if (providers.remove(packageName)) {
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCrossProfileWidgetProviders(ComponentName admin) {
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null || activeAdmin.crossProfileWidgetProviders.isEmpty()) {
                return null;
            }
            if (this.mInjector.binderIsCallingUidMyUid()) {
                return new ArrayList<String>(activeAdmin.crossProfileWidgetProviders);
            }
            return activeAdmin.crossProfileWidgetProviders;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who, int userHandle, boolean parent) {
        long timeout = 0L;
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
            return admin != null ? admin.passwordExpirationDate : timeout;
        }
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = admins.get(i);
            if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
            timeout = admin.passwordExpirationDate;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpiration(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            return this.getPasswordExpirationLocked(who, userHandle, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumUpperCase(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.upperCase != length) {
                metrics.upperCase = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumUpperCase(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.upperCase, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLowerCase(ComponentName who, int length, boolean parent) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.lowerCase != length) {
                metrics.lowerCase = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumLowerCase(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.lowerCase, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLetters(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.letters != length) {
                metrics.letters = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumLetters(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.letters, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNumeric(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.numeric != length) {
                metrics.numeric = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumNumeric(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.numeric, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumSymbols(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.symbols != length) {
                ap.minimumPasswordMetrics.symbols = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumSymbols(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.symbols, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNonLetter(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            PasswordMetrics metrics = ap.minimumPasswordMetrics;
            if (metrics.nonLetter != length) {
                ap.minimumPasswordMetrics.nonLetter = length;
                this.updatePasswordValidityCheckpointLocked(userId, parent);
                this.saveSettingsLocked(userId);
            }
            this.maybeLogPasswordComplexitySet(who, userId, parent, metrics);
        }
    }

    @Override
    public int getPasswordMinimumNonLetter(ComponentName who, int userHandle, boolean parent) {
        return this.getStrictestPasswordRequirement(who, userHandle, parent, admin -> admin.minimumPasswordMetrics.nonLetter, 393216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStrictestPasswordRequirement(ComponentName who, int userHandle, boolean parent, Function<ActiveAdmin, Integer> getter, int minimumPasswordQuality) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? getter.apply(admin) : 0;
                return n;
            }
            int maxValue = 0;
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                Integer adminValue;
                ActiveAdmin admin = admins.get(i);
                if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, minimumPasswordQuality) || (adminValue = getter.apply(admin)) <= maxValue) continue;
                maxValue = adminValue;
            }
            return maxValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivePasswordSufficient(int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceUserUnlocked(userHandle, parent);
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(null, 0, parent);
            int credentialOwner = this.getCredentialOwner(userHandle, parent);
            DevicePolicyData policy = this.getUserDataUnchecked(credentialOwner);
            PasswordMetrics metrics = this.getUserPasswordMetricsLocked(credentialOwner);
            return this.isActivePasswordSufficientForUserLocked(policy.mPasswordValidAtLastCheckpoint, metrics, userHandle, parent);
        }
    }

    @Override
    public boolean isUsingUnifiedPassword(ComponentName admin) {
        if (!this.mHasFeature) {
            return true;
        }
        int userId = this.mInjector.userHandleGetCallingUserId();
        this.enforceProfileOrDeviceOwner(admin);
        this.enforceManagedProfile(userId, "query unified challenge status");
        return !this.isSeparateProfileChallengeEnabled(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProfileActivePasswordSufficientForParent(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "call APIs refering to the parent profile");
        Object object = this.getLockObject();
        synchronized (object) {
            int targetUser = this.getProfileParentId(userHandle);
            this.enforceUserUnlocked(targetUser, false);
            int credentialOwner = this.getCredentialOwner(userHandle, false);
            DevicePolicyData policy = this.getUserDataUnchecked(credentialOwner);
            PasswordMetrics metrics = this.getUserPasswordMetricsLocked(credentialOwner);
            return this.isActivePasswordSufficientForUserLocked(policy.mPasswordValidAtLastCheckpoint, metrics, targetUser, false);
        }
    }

    private boolean isActivePasswordSufficientForUserLocked(boolean passwordValidAtLastCheckpoint, PasswordMetrics metrics, int userHandle, boolean parent) {
        if (!this.mInjector.storageManagerIsFileBasedEncryptionEnabled() && metrics == null) {
            return passwordValidAtLastCheckpoint;
        }
        if (metrics == null) {
            metrics = new PasswordMetrics();
        }
        return this.isPasswordSufficientForUserWithoutCheckpointLocked(metrics, userHandle, parent);
    }

    private boolean isPasswordSufficientForUserWithoutCheckpointLocked(PasswordMetrics passwordMetrics, int userHandle, boolean parent) {
        int requiredPasswordQuality = this.getPasswordQuality(null, userHandle, parent);
        if (passwordMetrics.quality < requiredPasswordQuality) {
            return false;
        }
        if (requiredPasswordQuality >= 131072 && passwordMetrics.length < this.getPasswordMinimumLength(null, userHandle, parent)) {
            return false;
        }
        if (requiredPasswordQuality != 393216) {
            return true;
        }
        return passwordMetrics.upperCase >= this.getPasswordMinimumUpperCase(null, userHandle, parent) && passwordMetrics.lowerCase >= this.getPasswordMinimumLowerCase(null, userHandle, parent) && passwordMetrics.letters >= this.getPasswordMinimumLetters(null, userHandle, parent) && passwordMetrics.numeric >= this.getPasswordMinimumNumeric(null, userHandle, parent) && passwordMetrics.symbols >= this.getPasswordMinimumSymbols(null, userHandle, parent) && passwordMetrics.nonLetter >= this.getPasswordMinimumNonLetter(null, userHandle, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFailedPasswordAttempts(int userHandle, boolean parent) {
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.isCallerWithSystemUid()) {
                this.getActiveAdminForCallerLocked(null, 1, parent);
            }
            DevicePolicyData policy = this.getUserDataUnchecked(this.getCredentialOwner(userHandle, parent));
            return policy.mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, 4, parent);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1, parent);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked(userId);
            }
        }
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userId) : userId;
            SecurityLog.writeEvent(210020, who.getPackageName(), userId, affectedUserId, num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumFailedPasswordsForWipe(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = who != null ? this.getActiveAdminUncheckedLocked(who, userHandle, parent) : this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, parent);
            return admin != null ? admin.maximumFailedPasswordsForWipe : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProfileWithMinimumFailedPasswordsForWipe(int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return -10000;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, parent);
            return admin != null ? admin.getUserHandle().getIdentifier() : -10000;
        }
    }

    private ActiveAdmin getAdminWithMinimumFailedPasswordsForWipeLocked(int userHandle, boolean parent) {
        int count = 0;
        ActiveAdmin strictestAdmin = null;
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = admins.get(i);
            if (admin.maximumFailedPasswordsForWipe == 0) continue;
            int userId = admin.getUserHandle().getIdentifier();
            if (count != 0 && count <= admin.maximumFailedPasswordsForWipe && (count != admin.maximumFailedPasswordsForWipe || !this.getUserInfo(userId).isPrimary())) continue;
            count = admin.maximumFailedPasswordsForWipe;
            strictestAdmin = admin;
        }
        return strictestAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getUserInfo(int userId) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo userInfo = this.mUserManager.getUserInfo(userId);
            return userInfo;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private boolean canPOorDOCallResetPassword(ActiveAdmin admin, int userId) {
        return this.getTargetSdk(admin.info.getPackageName(), userId) < 26;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canUserHaveUntrustedCredentialReset(int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (ActiveAdmin admin : this.getUserData((int)userId).mAdminList) {
                if (!this.isActiveAdminWithPolicyForUserLocked(admin, -1, userId) || !this.canPOorDOCallResetPassword(admin, userId)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPassword(String passwordOrNull, int flags) throws RemoteException {
        String password;
        int callingUid = this.mInjector.binderGetCallingUid();
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        String string2 = password = passwordOrNull != null ? passwordOrNull : "";
        if (TextUtils.isEmpty(password)) {
            this.enforceNotManagedProfile(userHandle, "clear the active password");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            boolean preN;
            ActiveAdmin admin = this.getActiveAdminWithPolicyForUidLocked(null, -1, callingUid);
            if (admin != null) {
                if (!this.canPOorDOCallResetPassword(admin, userHandle)) {
                    throw new SecurityException("resetPassword() is deprecated for DPC targeting O or later");
                }
                preN = this.getTargetSdk(admin.info.getPackageName(), userHandle) <= 23;
            } else {
                admin = this.getActiveAdminForCallerLocked(null, 2);
                boolean bl = preN = this.getTargetSdk(admin.info.getPackageName(), userHandle) <= 23;
                if (TextUtils.isEmpty(password)) {
                    if (!preN) {
                        throw new SecurityException("Cannot call with null password");
                    }
                    Slog.e(LOG_TAG, "Cannot call with null password");
                    return false;
                }
                if (this.isLockScreenSecureUnchecked(userHandle)) {
                    if (!preN) {
                        throw new SecurityException("Admin cannot change current password");
                    }
                    Slog.e(LOG_TAG, "Admin cannot change current password");
                    return false;
                }
            }
            if (!this.isManagedProfile(userHandle)) {
                for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
                    if (!userInfo.isManagedProfile()) continue;
                    if (!preN) {
                        throw new IllegalStateException("Cannot reset password on user has managed profile");
                    }
                    Slog.e(LOG_TAG, "Cannot reset password on user has managed profile");
                    return false;
                }
            }
            if (!this.mUserManager.isUserUnlocked(userHandle)) {
                if (!preN) {
                    throw new IllegalStateException("Cannot reset password when user is locked");
                }
                Slog.e(LOG_TAG, "Cannot reset password when user is locked");
                return false;
            }
        }
        return this.resetPasswordInternal(password, 0L, null, flags, callingUid, userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resetPasswordInternal(String password, long tokenHandle, byte[] token, int flags, int callingUid, int userHandle) {
        boolean result;
        boolean doNotAskCredentialsOnBoot;
        int quality;
        Object object = this.getLockObject();
        synchronized (object) {
            quality = this.getPasswordQuality(null, userHandle, false);
            if (quality == 524288) {
                quality = 0;
            }
            PasswordMetrics metrics = PasswordMetrics.computeForPassword(password);
            if (quality != 0) {
                int realQuality = metrics.quality;
                if (realQuality < quality && quality != 393216) {
                    Slog.w(LOG_TAG, "resetPassword: password quality 0x" + Integer.toHexString(realQuality) + " does not meet required quality 0x" + Integer.toHexString(quality));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null, userHandle, false);
            if (password.length() < length) {
                Slog.w(LOG_TAG, "resetPassword: password length " + password.length() + " does not meet required length " + length);
                return false;
            }
            if (quality == 393216) {
                int neededLetters = this.getPasswordMinimumLetters(null, userHandle, false);
                if (metrics.letters < neededLetters) {
                    Slog.w(LOG_TAG, "resetPassword: number of letters " + metrics.letters + " does not meet required number of letters " + neededLetters);
                    return false;
                }
                int neededNumeric = this.getPasswordMinimumNumeric(null, userHandle, false);
                if (metrics.numeric < neededNumeric) {
                    Slog.w(LOG_TAG, "resetPassword: number of numerical digits " + metrics.numeric + " does not meet required number of numerical digits " + neededNumeric);
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null, userHandle, false);
                if (metrics.lowerCase < neededLowerCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of lowercase letters " + metrics.lowerCase + " does not meet required number of lowercase letters " + neededLowerCase);
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null, userHandle, false);
                if (metrics.upperCase < neededUpperCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of uppercase letters " + metrics.upperCase + " does not meet required number of uppercase letters " + neededUpperCase);
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null, userHandle, false);
                if (metrics.symbols < neededSymbols) {
                    Slog.w(LOG_TAG, "resetPassword: number of special symbols " + metrics.symbols + " does not meet required number of special symbols " + neededSymbols);
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null, userHandle, false);
                if (metrics.nonLetter < neededNonLetter) {
                    Slog.w(LOG_TAG, "resetPassword: number of non-letter characters " + metrics.nonLetter + " does not meet required number of non-letter characters " + neededNonLetter);
                    return false;
                }
            }
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        if (policy.mPasswordOwner >= 0 && policy.mPasswordOwner != callingUid) {
            Slog.w(LOG_TAG, "resetPassword: already set by another uid and not entered by user");
            return false;
        }
        boolean callerIsDeviceOwnerAdmin = this.isCallerDeviceOwner(callingUid);
        boolean bl = doNotAskCredentialsOnBoot = (flags & 2) != 0;
        if (callerIsDeviceOwnerAdmin && doNotAskCredentialsOnBoot) {
            this.setDoNotAskCredentialsOnBoot();
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean requireEntry;
            if (token == null) {
                if (!TextUtils.isEmpty(password)) {
                    this.mLockPatternUtils.saveLockPassword(password, null, quality, userHandle);
                } else {
                    this.mLockPatternUtils.clearLock(null, userHandle);
                }
                result = true;
            } else {
                result = this.mLockPatternUtils.setLockCredentialWithToken(password, TextUtils.isEmpty(password) ? -1 : 2, quality, tokenHandle, token, userHandle);
            }
            boolean bl2 = requireEntry = (flags & 1) != 0;
            if (requireEntry) {
                this.mLockPatternUtils.requireStrongAuth(2, -1);
            }
            Object object2 = this.getLockObject();
            synchronized (object2) {
                int newOwner;
                int n = newOwner = requireEntry ? callingUid : -1;
                if (policy.mPasswordOwner != newOwner) {
                    policy.mPasswordOwner = newOwner;
                    this.saveSettingsLocked(userHandle);
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLockScreenSecureUnchecked(int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mLockPatternUtils.isSecure(userId);
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoNotAskCredentialsOnBoot() {
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policyData = this.getUserData(0);
            if (!policyData.doNotAskCredentialsOnBoot) {
                policyData.doNotAskCredentialsOnBoot = true;
                this.saveSettingsLocked(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDoNotAskCredentialsOnBoot() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.QUERY_DO_NOT_ASK_CREDENTIALS_ON_BOOT", null);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policyData = this.getUserData(0);
            return policyData.doNotAskCredentialsOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeToLock(ComponentName who, long timeMs, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3, parent);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                this.saveSettingsLocked(userHandle);
                this.updateMaximumTimeToLockLocked(userHandle);
            }
        }
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userHandle) : userHandle;
            SecurityLog.writeEvent(210019, who.getPackageName(), userHandle, affectedUserId, timeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaximumTimeToLockLocked(int userId) {
        long timeMs;
        if (this.isManagedProfile(userId)) {
            this.updateProfileLockTimeoutLocked(userId);
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            int parentId = this.getProfileParentId(userId);
            timeMs = this.getMaximumTimeToLockPolicyFromAdmins(this.getActiveAdminsForLockscreenPoliciesLocked(parentId, false));
            DevicePolicyData policy = this.getUserDataUnchecked(parentId);
            if (policy.mLastMaximumTimeToLock == timeMs) {
                return;
            }
            policy.mLastMaximumTimeToLock = timeMs;
            if (policy.mLastMaximumTimeToLock != Long.MAX_VALUE) {
                this.mInjector.settingsGlobalPutInt("stay_on_while_plugged_in", 0);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        this.mInjector.getPowerManagerInternal().setMaximumScreenOffTimeoutFromDeviceAdmin(0, timeMs);
    }

    private void updateProfileLockTimeoutLocked(int userId) {
        long timeMs = this.isSeparateProfileChallengeEnabled(userId) ? this.getMaximumTimeToLockPolicyFromAdmins(this.getActiveAdminsForLockscreenPoliciesLocked(userId, false)) : Long.MAX_VALUE;
        DevicePolicyData policy = this.getUserDataUnchecked(userId);
        if (policy.mLastMaximumTimeToLock == timeMs) {
            return;
        }
        policy.mLastMaximumTimeToLock = timeMs;
        this.mInjector.getPowerManagerInternal().setMaximumScreenOffTimeoutFromDeviceAdmin(userId, policy.mLastMaximumTimeToLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLock(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                long l = admin != null ? admin.maximumTimeToUnlock : 0L;
                return l;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            long timeMs = this.getMaximumTimeToLockPolicyFromAdmins(admins);
            long l = timeMs == Long.MAX_VALUE ? 0L : timeMs;
            return l;
        }
    }

    private long getMaximumTimeToLockPolicyFromAdmins(List<ActiveAdmin> admins) {
        long time = Long.MAX_VALUE;
        for (ActiveAdmin admin : admins) {
            if (admin.maximumTimeToUnlock <= 0L || admin.maximumTimeToUnlock >= time) continue;
            time = admin.maximumTimeToUnlock;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequiredStrongAuthTimeout(ComponentName who, long timeoutMs, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkArgument(timeoutMs >= 0L, "Timeout must not be a negative number.");
        long minimumStrongAuthTimeout = this.getMinimumStrongAuthTimeoutMs();
        if (timeoutMs != 0L && timeoutMs < minimumStrongAuthTimeout) {
            timeoutMs = minimumStrongAuthTimeout;
        }
        if (timeoutMs > 259200000L) {
            timeoutMs = 259200000L;
        }
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1, parent);
            if (ap.strongAuthUnlockTimeout != timeoutMs) {
                ap.strongAuthUnlockTimeout = timeoutMs;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequiredStrongAuthTimeout(ComponentName who, int userId, boolean parent) {
        if (!this.mHasFeature) {
            return 259200000L;
        }
        this.enforceFullCrossUsersPermission(userId);
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userId, parent);
                long l = admin != null ? admin.strongAuthUnlockTimeout : 0L;
                return l;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userId, parent);
            long strongAuthUnlockTimeout = 259200000L;
            for (int i = 0; i < admins.size(); ++i) {
                long timeout = admins.get((int)i).strongAuthUnlockTimeout;
                if (timeout == 0L) continue;
                strongAuthUnlockTimeout = Math.min(timeout, strongAuthUnlockTimeout);
            }
            return Math.max(strongAuthUnlockTimeout, this.getMinimumStrongAuthTimeoutMs());
        }
    }

    private long getMinimumStrongAuthTimeoutMs() {
        if (!this.mInjector.isBuildDebuggable()) {
            return MINIMUM_STRONG_AUTH_TIMEOUT_MS;
        }
        return Math.min(this.mInjector.systemPropertiesGetLong("persist.sys.min_str_auth_timeo", MINIMUM_STRONG_AUTH_TIMEOUT_MS), MINIMUM_STRONG_AUTH_TIMEOUT_MS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockNow(int flags, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(null, 3, parent);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                ComponentName adminComponent = admin.info.getComponent();
                if ((flags & 1) != 0) {
                    this.enforceManagedProfile(callingUserId, "set FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY");
                    if (!this.isProfileOwner(adminComponent, callingUserId)) {
                        throw new SecurityException("Only profile owner admins can set FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY");
                    }
                    if (parent) {
                        throw new IllegalArgumentException("Cannot set FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY for the parent");
                    }
                    if (!this.mInjector.storageManagerIsFileBasedEncryptionEnabled()) {
                        throw new UnsupportedOperationException("FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY only applies to FBE devices");
                    }
                    this.mUserManager.evictCredentialEncryptionKey(callingUserId);
                }
                int userToLock = parent || !this.isSeparateProfileChallengeEnabled(callingUserId) ? -1 : callingUserId;
                this.mLockPatternUtils.requireStrongAuth(2, userToLock);
                if (userToLock == -1) {
                    this.mInjector.powerManagerGoToSleep(SystemClock.uptimeMillis(), 1, 0);
                    this.mInjector.getIWindowManager().lockNow(null);
                } else {
                    this.mInjector.getTrustManager().setDeviceLockedForUser(userToLock, true);
                }
                if (SecurityLog.isLoggingEnabled()) {
                    int affectedUserId = parent ? this.getProfileParentId(callingUserId) : callingUserId;
                    SecurityLog.writeEvent(210022, adminComponent.getPackageName(), callingUserId, affectedUserId);
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    @Override
    public void enforceCanManageCaCerts(ComponentName who, String callerPackage) {
        if (who == null) {
            if (!this.isCallerDelegate(callerPackage, "delegation-cert-install")) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
            }
        } else {
            this.enforceProfileOrDeviceOwner(who);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceProfileOrDeviceOwner(ComponentName who) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean approveCaCert(String alias, int userId, boolean approval) {
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            boolean changed;
            ArraySet<String> certs = this.getUserData((int)userId).mAcceptedCaCertificates;
            boolean bl = changed = approval ? certs.add(alias) : certs.remove(alias);
            if (!changed) {
                return false;
            }
            this.saveSettingsLocked(userId);
        }
        this.mCertificateMonitor.onCertificateApprovalsChanged(userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCaCertApproved(String alias, int userId) {
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            return this.getUserData((int)userId).mAcceptedCaCertificates.contains(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCaApprovalsIfNeeded(int userId) {
        for (UserInfo userInfo : this.mUserManager.getProfiles(userId)) {
            boolean isSecure = this.mLockPatternUtils.isSecure(userInfo.id);
            if (userInfo.isManagedProfile()) {
                isSecure |= this.mLockPatternUtils.isSecure(this.getProfileParentId(userInfo.id));
            }
            if (isSecure) continue;
            Object object = this.getLockObject();
            synchronized (object) {
                this.getUserData((int)userInfo.id).mAcceptedCaCertificates.clear();
                this.saveSettingsLocked(userInfo.id);
            }
            this.mCertificateMonitor.onCertificateApprovalsChanged(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installCaCert(ComponentName admin, String callerPackage, byte[] certBuffer) throws RemoteException {
        String alias;
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCanManageCaCerts(admin, callerPackage);
        UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            alias = this.mCertificateMonitor.installCaCert(userHandle, certBuffer);
            if (alias == null) {
                Log.w(LOG_TAG, "Problem installing cert");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.getUserData((int)userHandle.getIdentifier()).mOwnerInstalledCaCerts.add(alias);
            this.saveSettingsLocked(userHandle.getIdentifier());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallCaCerts(ComponentName admin, String callerPackage, String[] aliases) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCanManageCaCerts(admin, callerPackage);
        int userId = this.mInjector.userHandleGetCallingUserId();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mCertificateMonitor.uninstallCaCerts(UserHandle.of(userId), aliases);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.getUserData((int)userId).mOwnerInstalledCaCerts.removeAll(Arrays.asList(aliases))) {
                this.saveSettingsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installKeyPair(ComponentName who, String callerPackage, byte[] privKey, byte[] cert, byte[] chain, String alias, boolean requestAccess, boolean isUserSelectable) {
        this.enforceCanManageScope(who, callerPackage, -1, "delegation-cert-install");
        int callingUid = this.mInjector.binderGetCallingUid();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            IKeyChainService keyChain;
            KeyChain.KeyChainConnection keyChainConnection;
            block14: {
                keyChainConnection = KeyChain.bindAsUser(this.mContext, UserHandle.getUserHandleForUid(callingUid));
                keyChain = keyChainConnection.getService();
                if (keyChain.installKeyPair(privKey, cert, chain, alias)) break block14;
                boolean bl = false;
                keyChainConnection.close();
                return bl;
            }
            try {
                if (requestAccess) {
                    keyChain.setGrant(callingUid, alias, true);
                }
                keyChain.setUserSelectable(alias, isUserSelectable);
                boolean bl = true;
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Installing certificate", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while installing certificate", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKeyPair(ComponentName who, String callerPackage, String alias) {
        this.enforceCanManageScope(who, callerPackage, -1, "delegation-cert-install");
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
            try {
                IKeyChainService keyChain = keyChainConnection.getService();
                boolean bl = keyChain.removeKeyPair(alias);
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Removing keypair", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while removing keypair", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceIsDeviceOwnerOrCertInstallerOfDeviceOwner(ComponentName who, String callerPackage, int callerUid) throws SecurityException {
        if (who == null) {
            if (!this.mOwners.hasDeviceOwner()) {
                throw new SecurityException("Not in Device Owner mode.");
            }
            if (UserHandle.getUserId(callerUid) != this.mOwners.getDeviceOwnerUserId()) {
                throw new SecurityException("Caller not from device owner user");
            }
            if (!this.isCallerDelegate(callerPackage, "delegation-cert-install")) {
                throw new SecurityException("Caller with uid " + this.mInjector.binderGetCallingUid() + "has no permission to generate keys.");
            }
        } else {
            Object object = this.getLockObject();
            synchronized (object) {
                this.getActiveAdminForCallerLocked(who, -2);
            }
        }
    }

    @VisibleForTesting
    public static int[] translateIdAttestationFlags(int idAttestationFlags) {
        HashMap<Integer, Integer> idTypeToAttestationFlag = new HashMap<Integer, Integer>();
        idTypeToAttestationFlag.put(2, 1);
        idTypeToAttestationFlag.put(4, 2);
        idTypeToAttestationFlag.put(8, 3);
        int numFlagsSet = Integer.bitCount(idAttestationFlags);
        if (numFlagsSet == 0) {
            return null;
        }
        if ((idAttestationFlags & 1) != 0) {
            --numFlagsSet;
            idAttestationFlags &= 0xFFFFFFFE;
        }
        int[] attestationUtilsFlags = new int[numFlagsSet];
        int i = 0;
        for (Integer idType : idTypeToAttestationFlag.keySet()) {
            if ((idType & idAttestationFlags) == 0) continue;
            attestationUtilsFlags[i++] = (Integer)idTypeToAttestationFlag.get(idType);
        }
        return attestationUtilsFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateKeyPair(ComponentName who, String callerPackage, String algorithm, ParcelableKeyGenParameterSpec parcelableKeySpec, int idAttestationFlags, KeymasterCertificateChain attestationChain) {
        block28: {
            int[] attestationUtilsFlags = DevicePolicyManagerService.translateIdAttestationFlags(idAttestationFlags);
            boolean deviceIdAttestationRequired = attestationUtilsFlags != null;
            int callingUid = this.mInjector.binderGetCallingUid();
            if (deviceIdAttestationRequired && attestationUtilsFlags.length > 0) {
                this.enforceIsDeviceOwnerOrCertInstallerOfDeviceOwner(who, callerPackage, callingUid);
            } else {
                this.enforceCanManageScope(who, callerPackage, -1, "delegation-cert-install");
            }
            KeyGenParameterSpec keySpec = parcelableKeySpec.getSpec();
            String alias = keySpec.getKeystoreAlias();
            if (TextUtils.isEmpty(alias)) {
                throw new IllegalArgumentException("Empty alias provided.");
            }
            if (keySpec.getUid() != -1) {
                Log.e(LOG_TAG, "Only the caller can be granted access to the generated keypair.");
                return false;
            }
            if (deviceIdAttestationRequired && keySpec.getAttestationChallenge() == null) {
                throw new IllegalArgumentException("Requested Device ID attestation but challenge is empty.");
            }
            UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl;
                block27: {
                    Throwable throwable;
                    KeyChain.KeyChainConnection keyChainConnection;
                    block25: {
                        boolean bl2;
                        block26: {
                            int attestationResult;
                            IKeyChainService keyChain;
                            block23: {
                                boolean bl3;
                                block24: {
                                    keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
                                    throwable = null;
                                    keyChain = keyChainConnection.getService();
                                    KeyGenParameterSpec noAttestationSpec = new KeyGenParameterSpec.Builder(keySpec).setAttestationChallenge(null).build();
                                    int generationResult = keyChain.generateKeyPair(algorithm, new ParcelableKeyGenParameterSpec(noAttestationSpec));
                                    if (generationResult == 0) break block23;
                                    Log.e(LOG_TAG, String.format("KeyChain failed to generate a keypair, error %d.", generationResult));
                                    bl3 = false;
                                    if (keyChainConnection == null) break block24;
                                    DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                                }
                                return bl3;
                            }
                            keyChain.setGrant(callingUid, alias, true);
                            byte[] attestationChallenge = keySpec.getAttestationChallenge();
                            if (attestationChallenge == null || (attestationResult = keyChain.attestKey(alias, attestationChallenge, attestationUtilsFlags, attestationChain)) == 0) break block25;
                            Log.e(LOG_TAG, String.format("Attestation for %s failed (rc=%d), deleting key.", alias, attestationResult));
                            keyChain.removeKeyPair(alias);
                            if (attestationResult == 3) {
                                throw new UnsupportedOperationException("Device does not support Device ID attestation.");
                            }
                            bl2 = false;
                            if (keyChainConnection == null) break block26;
                            DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                        }
                        return bl2;
                    }
                    try {
                        bl = true;
                        if (keyChainConnection == null) break block27;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (keyChainConnection != null) {
                                    DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                                }
                                throw throwable3;
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(LOG_TAG, "KeyChain error while generating a keypair", e);
                            break block28;
                        }
                        catch (InterruptedException e) {
                            Log.w(LOG_TAG, "Interrupted while generating keypair", e);
                            Thread.currentThread().interrupt();
                            break block28;
                        }
                    }
                    DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                }
                return bl;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setKeyPairCertificate(ComponentName who, String callerPackage, String alias, byte[] cert, byte[] chain, boolean isUserSelectable) {
        block18: {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-cert-install");
            int callingUid = this.mInjector.binderGetCallingUid();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl;
                block17: {
                    IKeyChainService keyChain;
                    Throwable throwable;
                    KeyChain.KeyChainConnection keyChainConnection;
                    block15: {
                        boolean bl2;
                        block16: {
                            keyChainConnection = KeyChain.bindAsUser(this.mContext, UserHandle.getUserHandleForUid(callingUid));
                            throwable = null;
                            keyChain = keyChainConnection.getService();
                            if (keyChain.setKeyPairCertificate(alias, cert, chain)) break block15;
                            bl2 = false;
                            if (keyChainConnection == null) break block16;
                            DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                        }
                        return bl2;
                    }
                    try {
                        keyChain.setUserSelectable(alias, isUserSelectable);
                        bl = true;
                        if (keyChainConnection == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (keyChainConnection != null) {
                                    DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                                }
                                throw throwable3;
                            }
                        }
                        catch (InterruptedException e) {
                            Log.w(LOG_TAG, "Interrupted while setting keypair certificate", e);
                            Thread.currentThread().interrupt();
                            break block18;
                        }
                        catch (RemoteException e) {
                            Log.e(LOG_TAG, "Failed setting keypair certificate", e);
                            break block18;
                        }
                    }
                    DevicePolicyManagerService.$closeResource(throwable, keyChainConnection);
                }
                return bl;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void choosePrivateKeyAlias(int uid, Uri uri, String alias, final IBinder response) {
        if (!this.isCallerWithSystemUid()) {
            return;
        }
        UserHandle caller = this.mInjector.binderGetCallingUserHandle();
        ComponentName aliasChooser = this.getProfileOwner(caller.getIdentifier());
        if (aliasChooser == null && caller.isSystem()) {
            Object object = this.getLockObject();
            synchronized (object) {
                ActiveAdmin deviceOwnerAdmin = this.getDeviceOwnerAdminLocked();
                if (deviceOwnerAdmin != null) {
                    aliasChooser = deviceOwnerAdmin.info.getComponent();
                }
            }
        }
        if (aliasChooser == null) {
            this.sendPrivateKeyAliasResponse(null, response);
            return;
        }
        Intent intent = new Intent("android.app.action.CHOOSE_PRIVATE_KEY_ALIAS");
        intent.setComponent(aliasChooser);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_SENDER_UID", uid);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_URI", uri);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_ALIAS", alias);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_RESPONSE", response);
        intent.addFlags(0x10000000);
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, caller, null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    String chosenAlias = this.getResultData();
                    DevicePolicyManagerService.this.sendPrivateKeyAliasResponse(chosenAlias, response);
                }
            }, null, -1, null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    private void sendPrivateKeyAliasResponse(String alias, IBinder responseBinder) {
        IKeyChainAliasCallback keyChainAliasResponse = IKeyChainAliasCallback.Stub.asInterface(responseBinder);
        try {
            keyChainAliasResponse.alias(alias);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "error while responding to callback", e);
        }
    }

    private static boolean shouldCheckIfDelegatePackageIsInstalled(String delegatePackage, int targetSdk, List<String> scopes) {
        if (targetSdk >= 24) {
            return true;
        }
        if (scopes.size() == 1 && scopes.get(0).equals("delegation-cert-install")) {
            return false;
        }
        return !scopes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDelegatedScopes(ComponentName who, String delegatePackage, List<String> scopes) throws SecurityException {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(delegatePackage, "Delegate package is null or empty");
        Preconditions.checkCollectionElementsNotNull(scopes, "Scopes");
        scopes = new ArrayList<String>(new ArraySet<String>(scopes));
        if (scopes.retainAll(Arrays.asList(DELEGATIONS))) {
            throw new IllegalArgumentException("Unexpected delegation scopes");
        }
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (DevicePolicyManagerService.shouldCheckIfDelegatePackageIsInstalled(delegatePackage, this.getTargetSdk(who.getPackageName(), userId), scopes) && !this.isPackageInstalledForUser(delegatePackage, userId)) {
                throw new IllegalArgumentException("Package " + delegatePackage + " is not installed on the current user");
            }
            DevicePolicyData policy = this.getUserData(userId);
            if (!scopes.isEmpty()) {
                policy.mDelegationMap.put(delegatePackage, new ArrayList<String>(scopes));
            } else {
                policy.mDelegationMap.remove(delegatePackage);
            }
            Intent intent = new Intent("android.app.action.APPLICATION_DELEGATION_SCOPES_CHANGED");
            intent.addFlags(0x40000000);
            intent.setPackage(delegatePackage);
            intent.putStringArrayListExtra("android.app.extra.DELEGATION_SCOPES", (ArrayList)scopes);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userId));
            this.saveSettingsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDelegatedScopes(ComponentName who, String delegatePackage) throws SecurityException {
        Preconditions.checkNotNull(delegatePackage, "Delegate package is null");
        int callingUid = this.mInjector.binderGetCallingUid();
        int userId = UserHandle.getUserId(callingUid);
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                this.getActiveAdminForCallerLocked(who, -1);
            } else {
                int uid = 0;
                try {
                    uid = this.mInjector.getPackageManager().getPackageUidAsUser(delegatePackage, userId);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (uid != callingUid) {
                    throw new SecurityException("Caller with uid " + callingUid + " is not " + delegatePackage);
                }
            }
            DevicePolicyData policy = this.getUserData(userId);
            List<String> scopes = policy.mDelegationMap.get(delegatePackage);
            return scopes == null ? Collections.EMPTY_LIST : scopes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDelegatePackages(ComponentName who, String scope) throws SecurityException {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(scope, "Scope is null");
        if (!Arrays.asList(DELEGATIONS).contains(scope)) {
            throw new IllegalArgumentException("Unexpected delegation scope: " + scope);
        }
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            DevicePolicyData policy = this.getUserData(userId);
            ArrayList<String> delegatePackagesWithScope = new ArrayList<String>();
            for (int i = 0; i < policy.mDelegationMap.size(); ++i) {
                if (!policy.mDelegationMap.valueAt(i).contains(scope)) continue;
                delegatePackagesWithScope.add(policy.mDelegationMap.keyAt(i));
            }
            return delegatePackagesWithScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallerDelegate(String callerPackage, String scope) {
        Preconditions.checkNotNull(callerPackage, "callerPackage is null");
        if (!Arrays.asList(DELEGATIONS).contains(scope)) {
            throw new IllegalArgumentException("Unexpected delegation scope: " + scope);
        }
        int callingUid = this.mInjector.binderGetCallingUid();
        int userId = UserHandle.getUserId(callingUid);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userId);
            List<String> scopes = policy.mDelegationMap.get(callerPackage);
            if (scopes != null && scopes.contains(scope)) {
                try {
                    int uid = this.mInjector.getPackageManager().getPackageUidAsUser(callerPackage, userId);
                    return uid == callingUid;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceCanManageScope(ComponentName who, String callerPackage, int reqPolicy, String scope) {
        if (who != null) {
            Object object = this.getLockObject();
            synchronized (object) {
                this.getActiveAdminForCallerLocked(who, reqPolicy);
            }
        } else if (!this.isCallerDelegate(callerPackage, scope)) {
            throw new SecurityException("Caller with uid " + this.mInjector.binderGetCallingUid() + " is not a delegate of scope " + scope + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDelegatedScopePreO(ComponentName who, String delegatePackage, String scope) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            DevicePolicyData policy = this.getUserData(userId);
            if (delegatePackage != null) {
                List<String> scopes = policy.mDelegationMap.get(delegatePackage);
                if (scopes == null) {
                    scopes = new ArrayList<String>();
                }
                if (!scopes.contains(scope)) {
                    scopes.add(scope);
                    this.setDelegatedScopes(who, delegatePackage, scopes);
                }
            }
            for (int i = 0; i < policy.mDelegationMap.size(); ++i) {
                String currentPackage = policy.mDelegationMap.keyAt(i);
                List<String> currentScopes = policy.mDelegationMap.valueAt(i);
                if (currentPackage.equals(delegatePackage) || !currentScopes.contains(scope)) continue;
                ArrayList<String> newScopes = new ArrayList<String>(currentScopes);
                newScopes.remove(scope);
                this.setDelegatedScopes(who, currentPackage, newScopes);
            }
        }
    }

    @Override
    public void setCertInstallerPackage(ComponentName who, String installerPackage) throws SecurityException {
        this.setDelegatedScopePreO(who, installerPackage, "delegation-cert-install");
    }

    @Override
    public String getCertInstallerPackage(ComponentName who) throws SecurityException {
        List<String> delegatePackages = this.getDelegatePackages(who, "delegation-cert-install");
        return delegatePackages.size() > 0 ? delegatePackages.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAlwaysOnVpnPackage(ComponentName admin, String vpnPackage, boolean lockdown) throws SecurityException {
        this.enforceProfileOrDeviceOwner(admin);
        int userId = this.mInjector.userHandleGetCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            if (vpnPackage != null && !this.isPackageInstalledForUser(vpnPackage, userId)) {
                boolean bl = false;
                return bl;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            if (!connectivityManager.setAlwaysOnVpnPackageForUser(userId, vpnPackage, lockdown)) {
                throw new UnsupportedOperationException();
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlwaysOnVpnPackage(ComponentName admin) throws SecurityException {
        this.enforceProfileOrDeviceOwner(admin);
        int userId = this.mInjector.userHandleGetCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            String string2 = connectivityManager.getAlwaysOnVpnPackageForUser(userId);
            return string2;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceWipeDeviceNoLock(boolean wipeExtRequested, String reason, boolean wipeEuicc) {
        this.wtfIfInLock();
        boolean success = false;
        try {
            if (wipeExtRequested) {
                StorageManager sm = (StorageManager)this.mContext.getSystemService("storage");
                sm.wipeAdoptableDisks();
            }
            this.mInjector.recoverySystemRebootWipeUserData(false, reason, true, wipeEuicc);
            success = true;
        }
        catch (IOException | SecurityException e) {
            Slog.w(LOG_TAG, "Failed requesting data wipe", e);
        }
        finally {
            if (!success) {
                SecurityLog.writeEvent(210023, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceWipeUser(int userId, String wipeReasonForUser) {
        boolean success = false;
        try {
            IActivityManager am = this.mInjector.getIActivityManager();
            if (am.getCurrentUser().id == userId) {
                am.switchUser(0);
            }
            if (!(success = this.mUserManagerInternal.removeUserEvenWhenDisallowed(userId))) {
                Slog.w(LOG_TAG, "Couldn't remove user " + userId);
            } else if (this.isManagedProfile(userId)) {
                this.sendWipeProfileNotification(wipeReasonForUser);
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            if (!success) {
                SecurityLog.writeEvent(210023, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeDataWithReason(int flags, String wipeReasonForUser) {
        ActiveAdmin admin;
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkStringNotEmpty(wipeReasonForUser, "wipeReasonForUser is null or empty");
        this.enforceFullCrossUsersPermission(this.mInjector.userHandleGetCallingUserId());
        Object object = this.getLockObject();
        synchronized (object) {
            admin = this.getActiveAdminForCallerLocked(null, 4);
        }
        String internalReason = "DevicePolicyManager.wipeDataWithReason() from " + admin.info.getComponent().flattenToShortString();
        this.wipeDataNoLock(admin.info.getComponent(), flags, internalReason, wipeReasonForUser, admin.getUserHandle().getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipeDataNoLock(ComponentName admin, int flags, String internalReason, String wipeReasonForUser, int userId) {
        this.wtfIfInLock();
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            String restriction = userId == 0 ? "no_factory_reset" : (this.isManagedProfile(userId) ? "no_remove_managed_profile" : "no_remove_user");
            if (this.isAdminAffectedByRestriction(admin, restriction, userId)) {
                throw new SecurityException("Cannot wipe data. " + restriction + " restriction is set for user " + userId);
            }
            if ((flags & 2) != 0) {
                if (!this.isDeviceOwner(admin, userId)) {
                    throw new SecurityException("Only device owner admins can set WIPE_RESET_PROTECTION_DATA");
                }
                PersistentDataBlockManager manager = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
                if (manager != null) {
                    manager.wipe();
                }
            }
            if (userId == 0) {
                this.forceWipeDeviceNoLock((flags & 1) != 0, internalReason, (flags & 4) != 0);
            } else {
                this.forceWipeUser(userId, wipeReasonForUser);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void sendWipeProfileNotification(String wipeReasonForUser) {
        Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.DEVICE_ADMIN).setSmallIcon(17301642).setContentTitle(this.mContext.getString(17041133)).setContentText(wipeReasonForUser).setColor(this.mContext.getColor(17170774)).setStyle(new Notification.BigTextStyle().bigText(wipeReasonForUser)).build();
        this.mInjector.getNotificationManager().notify(1001, notification);
    }

    private void clearWipeProfileNotification() {
        this.mInjector.getNotificationManager().cancel(1001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp, userHandle);
            if (admin == null) {
                result.sendResult(null);
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setFlags(0x10000000);
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcastAsUser(intent, new UserHandle(userHandle), null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    result.sendResult(this.getResultExtras(false));
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivePasswordState(PasswordMetrics metrics, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.isManagedProfile(userHandle) && !this.isSeparateProfileChallengeEnabled(userHandle)) {
            metrics = new PasswordMetrics();
        }
        DevicePolicyManagerService.validateQualityConstant(metrics.quality);
        Object object = this.getLockObject();
        synchronized (object) {
            this.mUserPasswordMetrics.put(userHandle, metrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportPasswordChanged(int userId) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userId);
        if (!this.isSeparateProfileChallengeEnabled(userId)) {
            this.enforceNotManagedProfile(userId, "set the active password");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyData policy = this.getUserData(userId);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.getLockObject();
            synchronized (object) {
                policy.mFailedPasswordAttempts = 0;
                this.updatePasswordValidityCheckpointLocked(userId, false);
                this.saveSettingsLocked(userId);
                this.updatePasswordExpirationsLocked(userId);
                this.setExpirationAlarmCheckLocked(this.mContext, userId, false);
                this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0, userId);
            }
            this.removeCaApprovalsIfNeeded(userId);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void updatePasswordExpirationsLocked(int userHandle) {
        ArraySet<Integer> affectedUserIds = new ArraySet<Integer>();
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, false);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            long expiration;
            ActiveAdmin admin = admins.get(i);
            if (!admin.info.usesPolicy(6)) continue;
            affectedUserIds.add(admin.getUserHandle().getIdentifier());
            long timeout = admin.passwordExpirationTimeout;
            admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
        }
        Iterator iterator = affectedUserIds.iterator();
        while (iterator.hasNext()) {
            int affectedUserId = (Integer)iterator.next();
            this.saveSettingsLocked(affectedUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedPasswordAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        if (!this.isSeparateProfileChallengeEnabled(userHandle)) {
            this.enforceNotManagedProfile(userHandle, "report failed password attempt if separate profile challenge is not in place");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        boolean wipeData = false;
        ActiveAdmin strictestAdmin = null;
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.getLockObject();
            synchronized (object) {
                DevicePolicyData policy = this.getUserData(userHandle);
                ++policy.mFailedPasswordAttempts;
                this.saveSettingsLocked(userHandle);
                if (this.mHasFeature) {
                    int max;
                    strictestAdmin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, false);
                    int n = max = strictestAdmin != null ? strictestAdmin.maximumFailedPasswordsForWipe : 0;
                    if (max > 0 && policy.mFailedPasswordAttempts >= max) {
                        wipeData = true;
                    }
                    this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_FAILED", 1, userHandle);
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        if (wipeData && strictestAdmin != null) {
            int userId = strictestAdmin.getUserHandle().getIdentifier();
            Slog.i(LOG_TAG, "Max failed password attempts policy reached for admin: " + strictestAdmin.info.getComponent().flattenToShortString() + ". Calling wipeData for user " + userId);
            try {
                String wipeReasonForUser = this.mContext.getString(17041136);
                this.wipeDataNoLock(strictestAdmin.info.getComponent(), 0, "reportFailedPasswordAttempt()", wipeReasonForUser, userId);
            }
            catch (SecurityException e) {
                Slog.w(LOG_TAG, "Failed to wipe user " + userId + " after max failed password attempts reached.", e);
            }
        }
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mFailedPasswordAttempts != 0 || policy.mPasswordOwner >= 0) {
                long ident = this.mInjector.binderClearCallingIdentity();
                try {
                    policy.mFailedPasswordAttempts = 0;
                    policy.mPasswordOwner = -1;
                    this.saveSettingsLocked(userHandle);
                    if (this.mHasFeature) {
                        this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1, userHandle);
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(ident);
                }
            }
        }
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 1, 1);
        }
    }

    @Override
    public void reportFailedFingerprintAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 0, 0);
        }
    }

    @Override
    public void reportSuccessfulFingerprintAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 1, 0);
        }
    }

    @Override
    public void reportKeyguardDismissed(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210006, new Object[0]);
        }
    }

    @Override
    public void reportKeyguardSecured(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210008, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList) {
        if (!this.mHasFeature) {
            return null;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            DevicePolicyData policy = this.getUserData(0);
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = policy.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = policy.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals(who)) continue;
                return component;
            }
            if (UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only the owner is allowed to set the global proxy. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return null;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = this.mInjector.binderClearCallingIdentity();
            try {
                this.resetGlobalProxyLocked(policy);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(origId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getGlobalProxyAdmin(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(0);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecommendedGlobalProxy(ComponentName who, ProxyInfo proxyInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            connectivityManager.setGlobalProxy(proxyInfo);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void resetGlobalProxyLocked(DevicePolicyData policy) {
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = policy.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxyLocked(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxyLocked(null, null);
    }

    private void saveGlobalProxyLocked(String proxySpec, String exclusionList) {
        ProxyInfo proxyProperties;
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!(proxyProperties = new ProxyInfo(data[0], proxyPort, exclusionList = exclusionList.trim())).isValid()) {
            Slog.e(LOG_TAG, "Invalid proxy properties, ignoring: " + proxyProperties.toString());
            return;
        }
        this.mInjector.settingsGlobalPutString("global_http_proxy_host", data[0]);
        this.mInjector.settingsGlobalPutInt("global_http_proxy_port", proxyPort);
        this.mInjector.settingsGlobalPutString("global_http_proxy_exclusion_list", exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStorageEncryption(ComponentName who, boolean encrypt) {
        if (!this.mHasFeature) {
            return 0;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            if (userHandle != 0) {
                Slog.w(LOG_TAG, "Only owner/system user is allowed to set storage encryption. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return 0;
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked(userHandle);
            }
            DevicePolicyData policy = this.getUserData(0);
            boolean newRequested = false;
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= policy.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStorageEncryption(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getStorageEncryptionStatus(String callerPackage, int userHandle) {
        int rawStatus;
        ApplicationInfo ai;
        if (!this.mHasFeature) {
            // empty if block
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.ensureCallerPackage(callerPackage);
        try {
            ai = this.mIPackageManager.getApplicationInfo(callerPackage, 0, userHandle);
        }
        catch (RemoteException e) {
            throw new SecurityException(e);
        }
        boolean legacyApp = false;
        if (ai.targetSdkVersion <= 23) {
            legacyApp = true;
        }
        if ((rawStatus = this.getEncryptionStatus()) == 5 && legacyApp) {
            return 3;
        }
        return rawStatus;
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    private int getEncryptionStatus() {
        if (this.mInjector.storageManagerIsFileBasedEncryptionEnabled()) {
            return 5;
        }
        if (this.mInjector.storageManagerIsNonDefaultBlockEncrypted()) {
            return 3;
        }
        if (this.mInjector.storageManagerIsEncrypted()) {
            return 4;
        }
        if (this.mInjector.storageManagerIsEncryptable()) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (ap.disableScreenCapture != disabled) {
                ap.disableScreenCapture = disabled;
                this.saveSettingsLocked(userHandle);
                this.updateScreenCaptureDisabled(userHandle, disabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getScreenCaptureDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableScreenCapture : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableScreenCapture) continue;
                return true;
            }
            return false;
        }
    }

    private void updateScreenCaptureDisabled(final int userHandle, boolean disabled) {
        this.mPolicyCache.setScreenCaptureDisabled(userHandle, disabled);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DevicePolicyManagerService.this.mInjector.getIWindowManager().refreshScreenCaptureDisabled(userHandle);
                }
                catch (RemoteException e) {
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Unable to notify WindowManager.", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoTimeRequired(ComponentName who, boolean required) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.requireAutoTime != required) {
                admin.requireAutoTime = required;
                this.saveSettingsLocked(userHandle);
            }
        }
        if (required) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.mInjector.settingsGlobalPutInt("auto_time", 1);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoTimeRequired() {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            if (deviceOwner != null && deviceOwner.requireAutoTime) {
                return true;
            }
            for (Integer userId : this.mOwners.getProfileOwnerKeys()) {
                ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userId);
                if (profileOwner == null || !profileOwner.requireAutoTime) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForceEphemeralUsers(ComponentName who, boolean forceEphemeralUsers) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (forceEphemeralUsers && !this.mInjector.userManagerIsSplitSystemUser()) {
            throw new UnsupportedOperationException("Cannot force ephemeral users on systems without split system user.");
        }
        boolean removeAllUsers = false;
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(who, -2);
            if (deviceOwner.forceEphemeralUsers != forceEphemeralUsers) {
                deviceOwner.forceEphemeralUsers = forceEphemeralUsers;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
                this.mUserManagerInternal.setForceEphemeralUsers(forceEphemeralUsers);
                removeAllUsers = forceEphemeralUsers;
            }
        }
        if (removeAllUsers) {
            long identitity = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManagerInternal.removeAllUsers();
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(identitity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getForceEphemeralUsers(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(who, -2);
            return deviceOwner.forceEphemeralUsers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDeviceOwnerAndAllUsersAffiliated(ComponentName who) throws SecurityException {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
            if (!this.areAllUsersAffiliatedWithDeviceLocked()) {
                throw new SecurityException("Not all users are affiliated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBugreport(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.ensureDeviceOwnerAndAllUsersAffiliated(who);
        if (this.mRemoteBugreportServiceIsActive.get() || this.getDeviceOwnerRemoteBugreportUri() != null) {
            Slog.d(LOG_TAG, "Remote bugreport wasn't started because there's already one running.");
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policyData = this.getUserData(0);
            if (currentTime > policyData.mLastBugReportRequestTime) {
                policyData.mLastBugReportRequestTime = currentTime;
                this.saveSettingsLocked(0);
            }
        }
        long callingIdentity = this.mInjector.binderClearCallingIdentity();
        try {
            this.mInjector.getIActivityManager().requestBugReport(2);
            this.mRemoteBugreportServiceIsActive.set(true);
            this.mRemoteBugreportSharingAccepted.set(false);
            this.registerRemoteBugreportReceivers();
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 1), UserHandle.ALL);
            this.mHandler.postDelayed(this.mRemoteBugreportTimeoutRunnable, 600000L);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Failed to make remote calls to start bugreportremote service", re);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(callingIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDeviceOwnerCommand(String action, Bundle extras) {
        ComponentName deviceOwnerComponent;
        int deviceOwnerUserId;
        Object object = this.getLockObject();
        synchronized (object) {
            deviceOwnerUserId = this.mOwners.getDeviceOwnerUserId();
            deviceOwnerComponent = this.mOwners.getDeviceOwnerComponent();
        }
        this.sendActiveAdminCommand(action, extras, deviceOwnerUserId, deviceOwnerComponent);
    }

    private void sendProfileOwnerCommand(String action, Bundle extras, int userHandle) {
        this.sendActiveAdminCommand(action, extras, userHandle, this.mOwners.getProfileOwnerComponent(userHandle));
    }

    private void sendActiveAdminCommand(String action, Bundle extras, int userHandle, ComponentName receiverComponent) {
        Intent intent = new Intent(action);
        intent.setComponent(receiverComponent);
        if (extras != null) {
            intent.putExtras(extras);
        }
        this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userHandle));
    }

    private void sendOwnerChangedBroadcast(String broadcast, int userId) {
        Intent intent = new Intent(broadcast).addFlags(0x1000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceOwnerRemoteBugreportUri() {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.getDeviceOwnerRemoteBugreportUri();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeviceOwnerRemoteBugreportUriAndHash(String bugreportUri, String bugreportHash) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mOwners.setDeviceOwnerRemoteBugreportUriAndHash(bugreportUri, bugreportHash);
        }
    }

    private void registerRemoteBugreportReceivers() {
        try {
            IntentFilter filterFinished = new IntentFilter("android.intent.action.REMOTE_BUGREPORT_DISPATCH", "application/vnd.android.bugreport");
            this.mContext.registerReceiver(this.mRemoteBugreportFinishedReceiver, filterFinished);
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            Slog.w(LOG_TAG, "Failed to set type application/vnd.android.bugreport", e);
        }
        IntentFilter filterConsent = new IntentFilter();
        filterConsent.addAction("com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED");
        filterConsent.addAction("com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED");
        this.mContext.registerReceiver(this.mRemoteBugreportConsentReceiver, filterConsent);
    }

    private void onBugreportFinished(Intent intent) {
        this.mHandler.removeCallbacks(this.mRemoteBugreportTimeoutRunnable);
        this.mRemoteBugreportServiceIsActive.set(false);
        Uri bugreportUri = intent.getData();
        String bugreportUriString = null;
        if (bugreportUri != null) {
            bugreportUriString = bugreportUri.toString();
        }
        String bugreportHash = intent.getStringExtra("android.intent.extra.REMOTE_BUGREPORT_HASH");
        if (this.mRemoteBugreportSharingAccepted.get()) {
            this.shareBugreportWithDeviceOwnerIfExists(bugreportUriString, bugreportHash);
            this.mInjector.getNotificationManager().cancel(LOG_TAG, 678432343);
        } else {
            this.setDeviceOwnerRemoteBugreportUriAndHash(bugreportUriString, bugreportHash);
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 3), UserHandle.ALL);
        }
        this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
    }

    private void onBugreportFailed() {
        this.mRemoteBugreportServiceIsActive.set(false);
        this.mInjector.systemPropertiesSet("ctl.stop", "bugreportremote");
        this.mRemoteBugreportSharingAccepted.set(false);
        this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        this.mInjector.getNotificationManager().cancel(LOG_TAG, 678432343);
        Bundle extras = new Bundle();
        extras.putInt("android.app.extra.BUGREPORT_FAILURE_REASON", 0);
        this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_FAILED", extras);
        this.mContext.unregisterReceiver(this.mRemoteBugreportConsentReceiver);
        this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBugreportSharingAccepted() {
        this.mRemoteBugreportSharingAccepted.set(true);
        String bugreportUriString = null;
        String bugreportHash = null;
        Object object = this.getLockObject();
        synchronized (object) {
            bugreportUriString = this.getDeviceOwnerRemoteBugreportUri();
            bugreportHash = this.mOwners.getDeviceOwnerRemoteBugreportHash();
        }
        if (bugreportUriString != null) {
            this.shareBugreportWithDeviceOwnerIfExists(bugreportUriString, bugreportHash);
        } else if (this.mRemoteBugreportServiceIsActive.get()) {
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 2), UserHandle.ALL);
        }
    }

    private void onBugreportSharingDeclined() {
        if (this.mRemoteBugreportServiceIsActive.get()) {
            this.mInjector.systemPropertiesSet("ctl.stop", "bugreportremote");
            this.mRemoteBugreportServiceIsActive.set(false);
            this.mHandler.removeCallbacks(this.mRemoteBugreportTimeoutRunnable);
            this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
        }
        this.mRemoteBugreportSharingAccepted.set(false);
        this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_SHARING_DECLINED", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shareBugreportWithDeviceOwnerIfExists(String bugreportUriString, String bugreportHash) {
        ParcelFileDescriptor pfd = null;
        try {
            if (bugreportUriString == null) {
                throw new FileNotFoundException();
            }
            Uri bugreportUri = Uri.parse(bugreportUriString);
            pfd = this.mContext.getContentResolver().openFileDescriptor(bugreportUri, "r");
            Object object = this.getLockObject();
            synchronized (object) {
                Intent intent = new Intent("android.app.action.BUGREPORT_SHARE");
                intent.setComponent(this.mOwners.getDeviceOwnerComponent());
                intent.setDataAndType(bugreportUri, "application/vnd.android.bugreport");
                intent.putExtra("android.app.extra.BUGREPORT_HASH", bugreportHash);
                intent.setFlags(1);
                LocalServices.getService(ActivityManagerInternal.class).grantUriPermissionFromIntent(2000, this.mOwners.getDeviceOwnerComponent().getPackageName(), intent, this.mOwners.getDeviceOwnerUserId());
                this.mContext.sendBroadcastAsUser(intent, UserHandle.of(this.mOwners.getDeviceOwnerUserId()));
            }
        }
        catch (FileNotFoundException e) {
            Bundle extras = new Bundle();
            extras.putInt("android.app.extra.BUGREPORT_FAILURE_REASON", 1);
            this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_FAILED", extras);
        }
        finally {
            try {
                if (pfd != null) {
                    pfd.close();
                }
            }
            catch (IOException iOException) {}
            this.mRemoteBugreportSharingAccepted.set(false);
            this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked(userHandle);
            }
        }
        this.pushUserRestrictions(userHandle);
    }

    @Override
    public boolean getCameraDisabled(ComponentName who, int userHandle) {
        return this.getCameraDisabled(who, userHandle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCameraDisabled(ComponentName who, int userHandle, boolean mergeDeviceOwnerRestriction) {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            if (mergeDeviceOwnerRestriction && (deviceOwner = this.getDeviceOwnerAdminLocked()) != null && deviceOwner.disableCamera) {
                return true;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyguardDisabledFeatures(ComponentName who, int which, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        if (this.isManagedProfile(userHandle)) {
            which = parent ? (which &= 0x1B0) : (which &= 0x1B8);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 9, parent);
            if (ap.disabledKeyguardFeatures != which) {
                ap.disabledKeyguardFeatures = which;
                this.saveSettingsLocked(userHandle);
            }
        }
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userHandle) : userHandle;
            SecurityLog.writeEvent(210021, who.getPackageName(), userHandle, affectedUserId, which);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getKeyguardDisabledFeatures(ComponentName who, int userHandle, boolean parent) {
        int i;
        int N;
        int which;
        List<ActiveAdmin> admins;
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.getLockObject();
            synchronized (object) {
                if (who != null) {
                    ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                    int n = admin != null ? admin.disabledKeyguardFeatures : 0;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var6_5
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    return n;
                }
                admins = !parent && this.isManagedProfile(userHandle) ? this.getUserDataUnchecked((int)userHandle).mAdminList : this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
                which = 0;
                N = admins.size();
                i = 0;
            }
        }
        catch (Throwable throwable) {
            this.mInjector.binderRestoreCallingIdentity(ident);
            throw throwable;
        }
        {
            while (true) {
                boolean isRequestedUser;
                if (i >= N) {
                    int n = which;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 7] lbl25 : MonitorExitStatement: MONITOREXIT : var6_5
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    return n;
                }
                ActiveAdmin admin = admins.get(i);
                int userId = admin.getUserHandle().getIdentifier();
                boolean bl = isRequestedUser = !parent && userId == userHandle;
                which = isRequestedUser || !this.isManagedProfile(userId) ? (which |= admin.disabledKeyguardFeatures) : (which |= admin.disabledKeyguardFeatures & 0x1B0);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeepUninstalledPackages(ComponentName who, String callerPackage, List<String> packageList) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(packageList, "packageList is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -2, "delegation-keep-uninstalled-packages");
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            deviceOwner.keepUninstalledPackages = packageList;
            this.saveSettingsLocked(userHandle);
            this.mInjector.getPackageManagerInternal().setKeepUninstalledPackages(packageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeepUninstalledPackages(ComponentName who, String callerPackage) {
        if (!this.mHasFeature) {
            return null;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -2, "delegation-keep-uninstalled-packages");
            return this.getKeepUninstalledPackagesLocked();
        }
    }

    private List<String> getKeepUninstalledPackagesLocked() {
        ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
        return deviceOwner != null ? deviceOwner.keepUninstalledPackages : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeviceOwner(ComponentName admin, String ownerName, int userId) {
        if (!this.mHasFeature) {
            return false;
        }
        if (admin == null || !this.isPackageInstalledForUser(admin.getPackageName(), userId)) {
            throw new IllegalArgumentException("Invalid component " + admin + " for device owner");
        }
        boolean hasIncompatibleAccountsOrNonAdb = this.hasIncompatibleAccountsOrNonAdbNoLock(userId, admin);
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanSetDeviceOwnerLocked(admin, userId, hasIncompatibleAccountsOrNonAdb);
            ActiveAdmin activeAdmin = this.getActiveAdminUncheckedLocked(admin, userId);
            if (activeAdmin == null || this.getUserData((int)userId).mRemovingAdmins.contains(admin)) {
                throw new IllegalArgumentException("Not active admin: " + admin);
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (this.mInjector.getIBackupManager() != null) {
                    this.mInjector.getIBackupManager().setBackupServiceActive(0, false);
                }
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Failed deactivating backup service.", e);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            if (this.isAdb()) {
                MetricsLogger.action(this.mContext, 617, LOG_TAG_DEVICE_OWNER);
            }
            this.mOwners.setDeviceOwner(admin, ownerName, userId);
            this.mOwners.writeDeviceOwner();
            this.updateDeviceOwnerLocked();
            this.setDeviceOwnerSystemPropertyLocked();
            Set<String> restrictions = UserRestrictionsUtils.getDefaultEnabledForDeviceOwner();
            if (!restrictions.isEmpty()) {
                for (String restriction : restrictions) {
                    activeAdmin.ensureUserRestrictions().putBoolean(restriction, true);
                }
                activeAdmin.defaultEnabledRestrictionsAlreadySet.addAll(restrictions);
                Slog.i(LOG_TAG, "Enabled the following restrictions by default: " + restrictions);
                this.saveUserRestrictionsLocked(userId);
            }
            ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.sendOwnerChangedBroadcast("android.app.action.DEVICE_OWNER_CHANGED", userId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            this.mDeviceAdminServiceController.startServiceForOwner(admin.getPackageName(), userId, "set-device-owner");
            Slog.i(LOG_TAG, "Device owner set: " + admin + " on user " + userId);
            return true;
        }
    }

    @Override
    public boolean hasDeviceOwner() {
        this.enforceDeviceOwnerOrManageUsers();
        return this.mOwners.hasDeviceOwner();
    }

    boolean isDeviceOwner(ActiveAdmin admin) {
        return this.isDeviceOwner(admin.info.getComponent(), admin.getUserHandle().getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceOwner(ComponentName who, int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.hasDeviceOwner() && this.mOwners.getDeviceOwnerUserId() == userId && this.mOwners.getDeviceOwnerComponent().equals(who);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeviceOwnerPackage(String packageName, int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.hasDeviceOwner() && this.mOwners.getDeviceOwnerUserId() == userId && this.mOwners.getDeviceOwnerPackageName().equals(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProfileOwnerPackage(String packageName, int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.hasProfileOwner(userId) && this.mOwners.getProfileOwnerPackage(userId).equals(packageName);
        }
    }

    public boolean isProfileOwner(ComponentName who, int userId) {
        ComponentName profileOwner = this.getProfileOwner(userId);
        return who != null && who.equals(profileOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getDeviceOwnerComponent(boolean callingUserOnly) {
        if (!this.mHasFeature) {
            return null;
        }
        if (!callingUserOnly) {
            this.enforceManageUsers();
        }
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.mOwners.hasDeviceOwner()) {
                return null;
            }
            if (callingUserOnly && this.mInjector.userHandleGetCallingUserId() != this.mOwners.getDeviceOwnerUserId()) {
                return null;
            }
            return this.mOwners.getDeviceOwnerComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDeviceOwnerUserId() {
        if (!this.mHasFeature) {
            return -10000;
        }
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.hasDeviceOwner() ? this.mOwners.getDeviceOwnerUserId() : -10000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwnerName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.mOwners.hasDeviceOwner()) {
                return null;
            }
            String deviceOwnerPackage = this.mOwners.getDeviceOwnerPackageName();
            return this.getApplicationLabel(deviceOwnerPackage, 0);
        }
    }

    @VisibleForTesting
    ActiveAdmin getDeviceOwnerAdminLocked() {
        this.ensureLocked();
        ComponentName component = this.mOwners.getDeviceOwnerComponent();
        if (component == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(this.mOwners.getDeviceOwnerUserId());
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!component.equals(admin.info.getComponent())) continue;
            return admin;
        }
        Slog.wtf(LOG_TAG, "Active admin for device owner not found. component=" + component);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceOwner(String packageName) {
        Preconditions.checkNotNull(packageName, "packageName is null");
        int callingUid = this.mInjector.binderGetCallingUid();
        try {
            int uid = this.mInjector.getPackageManager().getPackageUidAsUser(packageName, UserHandle.getUserId(callingUid));
            if (uid != callingUid) {
                throw new SecurityException("Invalid packageName");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException(e);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ComponentName deviceOwnerComponent = this.mOwners.getDeviceOwnerComponent();
            int deviceOwnerUserId = this.mOwners.getDeviceOwnerUserId();
            if (!this.mOwners.hasDeviceOwner() || !deviceOwnerComponent.getPackageName().equals(packageName) || deviceOwnerUserId != UserHandle.getUserId(callingUid)) {
                throw new SecurityException("clearDeviceOwner can only be called by the device owner");
            }
            this.enforceUserUnlocked(deviceOwnerUserId);
            ActiveAdmin admin = this.getDeviceOwnerAdminLocked();
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.clearDeviceOwnerLocked(admin, deviceOwnerUserId);
                this.removeActiveAdminLocked(deviceOwnerComponent, deviceOwnerUserId);
                this.sendOwnerChangedBroadcast("android.app.action.DEVICE_OWNER_CHANGED", deviceOwnerUserId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            Slog.i(LOG_TAG, "Device owner removed: " + deviceOwnerComponent);
        }
    }

    private void clearOverrideApnUnchecked() {
        this.setOverrideApnsEnabledUnchecked(false);
        List<ApnSetting> apns = this.getOverrideApnsUnchecked();
        for (int i = 0; i < apns.size(); ++i) {
            this.removeOverrideApnUnchecked(apns.get(i).getId());
        }
    }

    private void clearDeviceOwnerLocked(ActiveAdmin admin, int userId) {
        this.mDeviceAdminServiceController.stopServiceForOwner(userId, "clear-device-owner");
        if (admin != null) {
            admin.disableCamera = false;
            admin.userRestrictions = null;
            admin.defaultEnabledRestrictionsAlreadySet.clear();
            admin.forceEphemeralUsers = false;
            admin.isNetworkLoggingEnabled = false;
            this.mUserManagerInternal.setForceEphemeralUsers(admin.forceEphemeralUsers);
        }
        DevicePolicyData policyData = this.getUserData(userId);
        policyData.mCurrentInputMethodSet = false;
        this.saveSettingsLocked(userId);
        DevicePolicyData systemPolicyData = this.getUserData(0);
        systemPolicyData.mLastSecurityLogRetrievalTime = -1L;
        systemPolicyData.mLastBugReportRequestTime = -1L;
        systemPolicyData.mLastNetworkLogsRetrievalTime = -1L;
        this.saveSettingsLocked(0);
        this.clearUserPoliciesLocked(userId);
        this.clearOverrideApnUnchecked();
        this.mOwners.clearDeviceOwner();
        this.mOwners.writeDeviceOwner();
        this.updateDeviceOwnerLocked();
        this.clearDeviceOwnerUserRestrictionLocked(UserHandle.of(userId));
        this.mInjector.securityLogSetLoggingEnabledProperty(false);
        this.mSecurityLogMonitor.stop();
        this.setNetworkLoggingActiveInternal(false);
        this.deleteTransferOwnershipBundleLocked(userId);
        try {
            if (this.mInjector.getIBackupManager() != null) {
                this.mInjector.getIBackupManager().setBackupServiceActive(0, true);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed reactivating backup service.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProfileOwner(ComponentName who, String ownerName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        if (who == null || !this.isPackageInstalledForUser(who.getPackageName(), userHandle)) {
            throw new IllegalArgumentException("Component " + who + " not installed for userId:" + userHandle);
        }
        boolean hasIncompatibleAccountsOrNonAdb = this.hasIncompatibleAccountsOrNonAdbNoLock(userHandle, who);
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanSetProfileOwnerLocked(who, userHandle, hasIncompatibleAccountsOrNonAdb);
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin == null || this.getUserData((int)userHandle).mRemovingAdmins.contains(who)) {
                throw new IllegalArgumentException("Not active admin: " + who);
            }
            if (this.isAdb()) {
                MetricsLogger.action(this.mContext, 617, LOG_TAG_PROFILE_OWNER);
            }
            this.mOwners.setProfileOwner(who, ownerName, userHandle);
            this.mOwners.writeProfileOwner(userHandle);
            Slog.i(LOG_TAG, "Profile owner set: " + who + " on user " + userHandle);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                if (this.mUserManager.isManagedProfile(userHandle)) {
                    this.maybeSetDefaultRestrictionsForAdminLocked(userHandle, admin, UserRestrictionsUtils.getDefaultEnabledForManagedProfiles());
                    this.ensureUnknownSourcesRestrictionForProfileOwnerLocked(userHandle, admin, true);
                }
                this.sendOwnerChangedBroadcast("android.app.action.PROFILE_OWNER_CHANGED", userHandle);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            this.mDeviceAdminServiceController.startServiceForOwner(who.getPackageName(), userHandle, "set-profile-owner");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProfileOwner(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        this.enforceNotManagedProfile(userId, "clear profile owner");
        this.enforceUserUnlocked(userId);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.clearProfileOwnerLocked(admin, userId);
                this.removeActiveAdminLocked(who, userId);
                this.sendOwnerChangedBroadcast("android.app.action.PROFILE_OWNER_CHANGED", userId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            Slog.i(LOG_TAG, "Profile owner " + who + " removed from user " + userId);
        }
    }

    public void clearProfileOwnerLocked(ActiveAdmin admin, int userId) {
        this.mDeviceAdminServiceController.stopServiceForOwner(userId, "clear-profile-owner");
        if (admin != null) {
            admin.disableCamera = false;
            admin.userRestrictions = null;
            admin.defaultEnabledRestrictionsAlreadySet.clear();
        }
        DevicePolicyData policyData = this.getUserData(userId);
        policyData.mCurrentInputMethodSet = false;
        policyData.mOwnerInstalledCaCerts.clear();
        this.saveSettingsLocked(userId);
        this.clearUserPoliciesLocked(userId);
        this.mOwners.removeProfileOwner(userId);
        this.mOwners.writeProfileOwner(userId);
        this.deleteTransferOwnershipBundleLocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceOwnerLockScreenInfo(ComponentName who, CharSequence info) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.mHasFeature) {
            return;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
            long token = this.mInjector.binderClearCallingIdentity();
            try {
                this.mLockPatternUtils.setDeviceOwnerInfo(info != null ? info.toString() : null);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(token);
            }
        }
    }

    @Override
    public CharSequence getDeviceOwnerLockScreenInfo() {
        return this.mLockPatternUtils.getDeviceOwnerInfo();
    }

    private void clearUserPoliciesLocked(int userId) {
        DevicePolicyData policy = this.getUserData(userId);
        policy.mPermissionPolicy = 0;
        policy.mDelegationMap.clear();
        policy.mStatusBarDisabled = false;
        policy.mUserProvisioningState = 0;
        policy.mAffiliationIds.clear();
        policy.mLockTaskPackages.clear();
        this.updateLockTaskPackagesLocked(policy.mLockTaskPackages, userId);
        policy.mLockTaskFeatures = 0;
        this.saveSettingsLocked(userId);
        try {
            this.mIPackageManager.updatePermissionFlagsForAllApps(4, 0, userId);
            this.pushUserRestrictions(userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasUserSetupCompleted() {
        return this.hasUserSetupCompleted(UserHandle.getCallingUserId());
    }

    private boolean hasUserSetupCompleted(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        return this.getUserData((int)userHandle).mUserSetupComplete;
    }

    private boolean hasPaired(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        return this.getUserData((int)userHandle).mPaired;
    }

    @Override
    public int getUserProvisioningState() {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceManageUsers();
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        return this.getUserProvisioningState(userHandle);
    }

    private int getUserProvisioningState(int userHandle) {
        return this.getUserData((int)userHandle).mUserProvisioningState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserProvisioningState(int newState, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        if (userHandle != this.mOwners.getDeviceOwnerUserId() && !this.mOwners.hasProfileOwner(userHandle) && this.getManagedUserId(userHandle) == -1) {
            throw new IllegalStateException("Not allowed to change provisioning state unless a device or profile owner is set.");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            boolean transitionCheckNeeded = true;
            if (this.isAdb()) {
                if (this.getUserProvisioningState(userHandle) != 0 || newState != 3) {
                    throw new IllegalStateException("Not allowed to change provisioning state unless current provisioning state is unmanaged, and new state is finalized.");
                }
                transitionCheckNeeded = false;
            } else {
                this.enforceCanManageProfileAndDeviceOwners();
            }
            DevicePolicyData policyData = this.getUserData(userHandle);
            if (transitionCheckNeeded) {
                this.checkUserProvisioningStateTransition(policyData.mUserProvisioningState, newState);
            }
            policyData.mUserProvisioningState = newState;
            this.saveSettingsLocked(userHandle);
        }
    }

    private void checkUserProvisioningStateTransition(int currentState, int newState) {
        switch (currentState) {
            case 0: {
                if (newState == 0) break;
                return;
            }
            case 1: 
            case 2: {
                if (newState != 3) break;
                return;
            }
            case 4: {
                if (newState != 0) break;
                return;
            }
        }
        throw new IllegalStateException("Cannot move to user provisioning state [" + newState + "] from state [" + currentState + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileEnabled(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            this.enforceManagedProfile(userId, "enable the profile");
            UserInfo managedProfile = this.getUserInfo(userId);
            if (managedProfile.isEnabled()) {
                Slog.e(LOG_TAG, "setProfileEnabled is called when the profile is already enabled");
                return;
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManager.setUserEnabled(userId);
                UserInfo parent = this.mUserManager.getProfileParent(userId);
                Intent intent = new Intent("android.intent.action.MANAGED_PROFILE_ADDED");
                intent.putExtra("android.intent.extra.USER", new UserHandle(userId));
                intent.addFlags(0x50000000);
                this.mContext.sendBroadcastAsUser(intent, new UserHandle(parent.id));
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileName(ComponentName who, String profileName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = UserHandle.getCallingUserId();
        this.getActiveAdminForCallerLocked(who, -1);
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mUserManager.setUserName(userId, profileName);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getProfileOwner(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mOwners.getProfileOwnerComponent(userHandle);
        }
    }

    @VisibleForTesting
    ActiveAdmin getProfileOwnerAdminLocked(int userHandle) {
        ComponentName profileOwner = this.mOwners.getProfileOwnerComponent(userHandle);
        if (profileOwner == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!profileOwner.equals(admin.info.getComponent())) continue;
            return admin;
        }
        return null;
    }

    @Override
    public String getProfileOwnerName(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceManageUsers();
        ComponentName profileOwner = this.getProfileOwner(userHandle);
        if (profileOwner == null) {
            return null;
        }
        return this.getApplicationLabel(profileOwner.getPackageName(), userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getApplicationLabel(String packageName, int userHandle) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Context userContext;
            try {
                UserHandle handle = new UserHandle(userHandle);
                userContext = this.mContext.createPackageContextAsUser(packageName, 0, handle);
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Log.w(LOG_TAG, packageName + " is not installed for user " + userHandle, nnfe);
                String string2 = null;
                this.mInjector.binderRestoreCallingIdentity(token);
                return string2;
            }
            ApplicationInfo appInfo = userContext.getApplicationInfo();
            CharSequence result = null;
            if (appInfo != null) {
                result = appInfo.loadUnsafeLabel(userContext.getPackageManager());
            }
            String string3 = result != null ? result.toString() : null;
            return string3;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void wtfIfInLock() {
        if (Thread.holdsLock(this)) {
            Slog.wtfStack(LOG_TAG, "Shouldn't be called with DPMS lock held");
        }
    }

    private void enforceCanSetProfileOwnerLocked(ComponentName owner, int userHandle, boolean hasIncompatibleAccountsOrNonAdb) {
        UserInfo info = this.getUserInfo(userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Attempted to set profile owner for invalid userId: " + userHandle);
        }
        if (info.isGuest()) {
            throw new IllegalStateException("Cannot set a profile owner on a guest");
        }
        if (this.mOwners.hasProfileOwner(userHandle)) {
            throw new IllegalStateException("Trying to set the profile owner, but profile owner is already set.");
        }
        if (this.mOwners.hasDeviceOwner() && this.mOwners.getDeviceOwnerUserId() == userHandle) {
            throw new IllegalStateException("Trying to set the profile owner, but the user already has a device owner.");
        }
        if (this.isAdb()) {
            if ((this.mIsWatch || this.hasUserSetupCompleted(userHandle)) && hasIncompatibleAccountsOrNonAdb) {
                throw new IllegalStateException("Not allowed to set the profile owner because there are already some accounts on the profile");
            }
            return;
        }
        this.enforceCanManageProfileAndDeviceOwners();
        if ((this.mIsWatch || this.hasUserSetupCompleted(userHandle)) && !this.isCallerWithSystemUid()) {
            throw new IllegalStateException("Cannot set the profile owner on a user which is already set-up");
        }
    }

    private void enforceCanSetDeviceOwnerLocked(ComponentName owner, int userId, boolean hasIncompatibleAccountsOrNonAdb) {
        if (!this.isAdb()) {
            this.enforceCanManageProfileAndDeviceOwners();
        }
        int code = this.checkDeviceOwnerProvisioningPreConditionLocked(owner, userId, this.isAdb(), hasIncompatibleAccountsOrNonAdb);
        switch (code) {
            case 0: {
                return;
            }
            case 1: {
                throw new IllegalStateException("Trying to set the device owner, but device owner is already set.");
            }
            case 2: {
                throw new IllegalStateException("Trying to set the device owner, but the user already has a profile owner.");
            }
            case 3: {
                throw new IllegalStateException("User not running: " + userId);
            }
            case 7: {
                throw new IllegalStateException("User is not system user");
            }
            case 4: {
                throw new IllegalStateException("Cannot set the device owner if the device is already set-up");
            }
            case 5: {
                throw new IllegalStateException("Not allowed to set the device owner because there are already several users on the device");
            }
            case 6: {
                throw new IllegalStateException("Not allowed to set the device owner because there are already some accounts on the device");
            }
            case 8: {
                throw new IllegalStateException("Not allowed to set the device owner because this device has already paired");
            }
        }
        throw new IllegalStateException("Unexpected @ProvisioningPreCondition " + code);
    }

    private void enforceUserUnlocked(int userId) {
        Preconditions.checkState(this.mUserManager.isUserUnlocked(userId), "User must be running and unlocked");
    }

    private void enforceUserUnlocked(int userId, boolean parent) {
        if (parent) {
            this.enforceUserUnlocked(this.getProfileParentId(userId));
        } else {
            this.enforceUserUnlocked(userId);
        }
    }

    private void enforceManageUsers() {
        int callingUid = this.mInjector.binderGetCallingUid();
        if (!this.isCallerWithSystemUid() && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        }
    }

    private void enforceFullCrossUsersPermission(int userHandle) {
        this.enforceSystemUserOrPermissionIfCrossUser(userHandle, "android.permission.INTERACT_ACROSS_USERS_FULL");
    }

    private void enforceCrossUsersPermission(int userHandle) {
        this.enforceSystemUserOrPermissionIfCrossUser(userHandle, "android.permission.INTERACT_ACROSS_USERS");
    }

    private void enforceSystemUserOrPermission(String permission2) {
        if (!this.isCallerWithSystemUid() && this.mInjector.binderGetCallingUid() != 0) {
            this.mContext.enforceCallingOrSelfPermission(permission2, "Must be system or have " + permission2 + " permission");
        }
    }

    private void enforceSystemUserOrPermissionIfCrossUser(int userHandle, String permission2) {
        if (userHandle < 0) {
            throw new IllegalArgumentException("Invalid userId " + userHandle);
        }
        if (userHandle == this.mInjector.userHandleGetCallingUserId()) {
            return;
        }
        this.enforceSystemUserOrPermission(permission2);
    }

    private void enforceManagedProfile(int userHandle, String message) {
        if (!this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " outside a managed profile.");
        }
    }

    private void enforceNotManagedProfile(int userHandle, String message) {
        if (this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " for a managed profile.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceDeviceOwnerOrManageUsers() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.getActiveAdminWithPolicyForUidLocked(null, -2, this.mInjector.binderGetCallingUid()) != null) {
                return;
            }
        }
        this.enforceManageUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceProfileOwnerOrSystemUser() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.getActiveAdminWithPolicyForUidLocked(null, -1, this.mInjector.binderGetCallingUid()) != null) {
                return;
            }
        }
        Preconditions.checkState(this.isCallerWithSystemUid(), "Only profile owner, device owner and system may call this method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceProfileOwnerOrFullCrossUsersPermission(int userId) {
        if (userId == this.mInjector.userHandleGetCallingUserId()) {
            Object object = this.getLockObject();
            synchronized (object) {
                if (this.getActiveAdminWithPolicyForUidLocked(null, -1, this.mInjector.binderGetCallingUid()) != null) {
                    return;
                }
            }
        }
        this.enforceSystemUserOrPermission("android.permission.INTERACT_ACROSS_USERS_FULL");
    }

    private boolean canUserUseLockTaskLocked(int userId) {
        if (this.isUserAffiliatedWithDeviceLocked(userId)) {
            return true;
        }
        if (this.mOwners.hasDeviceOwner()) {
            return false;
        }
        ComponentName profileOwner = this.getProfileOwner(userId);
        if (profileOwner == null) {
            return false;
        }
        return !this.isManagedProfile(userId);
    }

    private void enforceCanCallLockTaskLocked(ComponentName who) {
        this.getActiveAdminForCallerLocked(who, -1);
        int userId = this.mInjector.userHandleGetCallingUserId();
        if (!this.canUserUseLockTaskLocked(userId)) {
            throw new SecurityException("User " + userId + " is not allowed to use lock task");
        }
    }

    private void ensureCallerPackage(String packageName) {
        if (packageName == null) {
            Preconditions.checkState(this.isCallerWithSystemUid(), "Only caller can omit package name");
        } else {
            int callingUid = this.mInjector.binderGetCallingUid();
            int userId = this.mInjector.userHandleGetCallingUserId();
            try {
                ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 0, userId);
                Preconditions.checkState(ai.uid == callingUid, "Unmatching package name");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private boolean isCallerWithSystemUid() {
        return UserHandle.isSameApp(this.mInjector.binderGetCallingUid(), 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getProfileParentId(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo parentUser = this.mUserManager.getProfileParent(userHandle);
            int n = parentUser != null ? parentUser.id : userHandle;
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCredentialOwner(int userHandle, boolean parent) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo parentProfile;
            if (parent && (parentProfile = this.mUserManager.getProfileParent(userHandle)) != null) {
                userHandle = parentProfile.id;
            }
            int n = this.mUserManager.getCredentialOwnerProfile(userHandle);
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private boolean isManagedProfile(int userHandle) {
        UserInfo user = this.getUserInfo(userHandle);
        return user != null && user.isManagedProfile();
    }

    private void enableIfNecessary(String packageName, int userId) {
        try {
            ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 32768, userId);
            if (ai.enabledSetting == 4) {
                this.mIPackageManager.setApplicationEnabledSetting(packageName, 0, 1, userId, LOG_TAG);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, LOG_TAG, pw)) {
            return;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            pw.println("Current Device Policy Manager state:");
            this.mOwners.dump("  ", pw);
            this.mDeviceAdminServiceController.dump("  ", pw);
            int userCount = this.mUserData.size();
            for (int u = 0; u < userCount; ++u) {
                DevicePolicyData policy = this.getUserData(this.mUserData.keyAt(u));
                pw.println();
                pw.println("  Enabled Device Admins (User " + policy.mUserHandle + ", provisioningState: " + policy.mUserProvisioningState + "):");
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if (ap == null) continue;
                    pw.print("    ");
                    pw.print(ap.info.getComponent().flattenToShortString());
                    pw.println(":");
                    ap.dump("      ", pw);
                }
                if (!policy.mRemovingAdmins.isEmpty()) {
                    pw.println("    Removing Device Admins (User " + policy.mUserHandle + "): " + policy.mRemovingAdmins);
                }
                pw.println(" ");
                pw.print("    mPasswordOwner=");
                pw.println(policy.mPasswordOwner);
            }
            pw.println();
            this.mConstants.dump("  ", pw);
            pw.println();
            this.mStatLogger.dump(pw, "  ");
            pw.println();
            pw.println("  Encryption Status: " + this.getEncryptionStatusName(this.getEncryptionStatus()));
        }
    }

    private String getEncryptionStatusName(int encryptionStatus) {
        switch (encryptionStatus) {
            case 1: {
                return "inactive";
            }
            case 4: {
                return "block default key";
            }
            case 3: {
                return "block";
            }
            case 5: {
                return "per-user";
            }
            case 0: {
                return "unsupported";
            }
            case 2: {
                return "activating";
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(ComponentName who, IntentFilter filter, ComponentName activity) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.addPersistentPreferredActivity(filter, activity, userHandle);
                this.mIPackageManager.flushPackageRestrictionsAsUser(userHandle);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.clearPackagePersistentPreferredActivities(packageName, userHandle);
                this.mIPackageManager.flushPackageRestrictionsAsUser(userHandle);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultSmsApplication(ComponentName admin, String packageName) {
        Preconditions.checkNotNull(admin, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        this.mInjector.binderWithCleanCallingIdentity(() -> SmsApplication.setDefaultApplication(packageName, this.mContext));
    }

    @Override
    public boolean setApplicationRestrictionsManagingPackage(ComponentName admin, String packageName) {
        try {
            this.setDelegatedScopePreO(admin, packageName, "delegation-app-restrictions");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getApplicationRestrictionsManagingPackage(ComponentName admin) {
        List<String> delegatePackages = this.getDelegatePackages(admin, "delegation-app-restrictions");
        return delegatePackages.size() > 0 ? delegatePackages.get(0) : null;
    }

    @Override
    public boolean isCallerApplicationRestrictionsManagingPackage(String callerPackage) {
        return this.isCallerDelegate(callerPackage, "delegation-app-restrictions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(ComponentName who, String callerPackage, String packageName, Bundle settings) {
        this.enforceCanManageScope(who, callerPackage, -1, "delegation-app-restrictions");
        UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mUserManager.setApplicationRestrictions(packageName, settings, userHandle);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrustAgentConfiguration(ComponentName admin, ComponentName agent, PersistableBundle args, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin, "admin is null");
        Preconditions.checkNotNull(agent, "agent is null");
        int userHandle = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(admin, 9, parent);
            ap.trustAgentInfos.put(agent.flattenToString(), new ActiveAdmin.TrustAgentInfo(args));
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName admin, ComponentName agent, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(agent, "agent null");
        this.enforceFullCrossUsersPermission(userHandle);
        Object object = this.getLockObject();
        synchronized (object) {
            String componentName = agent.flattenToString();
            if (admin != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(admin, userHandle, parent);
                if (ap == null) {
                    return null;
                }
                ActiveAdmin.TrustAgentInfo trustAgentInfo = ap.trustAgentInfos.get(componentName);
                if (trustAgentInfo == null || trustAgentInfo.options == null) {
                    return null;
                }
                ArrayList<PersistableBundle> result = new ArrayList<PersistableBundle>();
                result.add(trustAgentInfo.options);
                return result;
            }
            ArrayList<PersistableBundle> result = null;
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            boolean allAdminsHaveOptions = true;
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin active = admins.get(i);
                boolean disablesTrust = (active.disabledKeyguardFeatures & 0x10) != 0;
                ActiveAdmin.TrustAgentInfo info = active.trustAgentInfos.get(componentName);
                if (info != null && info.options != null && !info.options.isEmpty()) {
                    if (disablesTrust) {
                        if (result == null) {
                            result = new ArrayList<PersistableBundle>();
                        }
                        result.add(info.options);
                        continue;
                    }
                    Log.w(LOG_TAG, "Ignoring admin " + active.info + " because it has trust options but doesn't declare KEYGUARD_DISABLE_TRUST_AGENTS");
                    continue;
                }
                if (!disablesTrust) continue;
                allAdminsHaveOptions = false;
                break;
            }
            return allAdminsHaveOptions ? result : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictionsProvider(ComponentName who, ComponentName permissionProvider) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userHandle = UserHandle.getCallingUserId();
            DevicePolicyData userData = this.getUserData(userHandle);
            userData.mRestrictionsProvider = permissionProvider;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getRestrictionsProvider(int userHandle) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.isCallerWithSystemUid()) {
                throw new SecurityException("Only the system can query the permission provider");
            }
            DevicePolicyData userData = this.getUserData(userHandle);
            ComponentName componentName = userData != null ? userData.mRestrictionsProvider : null;
            return componentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(ComponentName who, IntentFilter filter, int flags) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo parent = this.mUserManager.getProfileParent(callingUserId);
                if (parent == null) {
                    Slog.e(LOG_TAG, "Cannot call addCrossProfileIntentFilter if there is no parent");
                    return;
                }
                if ((flags & 1) != 0) {
                    this.mIPackageManager.addCrossProfileIntentFilter(filter, who.getPackageName(), callingUserId, parent.id, 0);
                }
                if ((flags & 2) != 0) {
                    this.mIPackageManager.addCrossProfileIntentFilter(filter, who.getPackageName(), parent.id, callingUserId, 0);
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo parent = this.mUserManager.getProfileParent(callingUserId);
                if (parent == null) {
                    Slog.e(LOG_TAG, "Cannot call clearCrossProfileIntentFilter if there is no parent");
                    return;
                }
                this.mIPackageManager.clearCrossProfileIntentFilters(callingUserId, who.getPackageName());
                this.mIPackageManager.clearCrossProfileIntentFilters(parent.id, who.getPackageName());
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPackagesInPermittedListOrSystem(List<String> enabledPackages, List<String> permittedList, int userIdToCheck) {
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo user = this.getUserInfo(userIdToCheck);
            if (user.isManagedProfile()) {
                userIdToCheck = user.profileGroupId;
            }
            for (String enabledPackage : enabledPackages) {
                boolean systemService = false;
                try {
                    ApplicationInfo applicationInfo = this.mIPackageManager.getApplicationInfo(enabledPackage, 8192, userIdToCheck);
                    systemService = (applicationInfo.flags & 1) != 0;
                }
                catch (RemoteException e) {
                    Log.i(LOG_TAG, "Can't talk to package managed", e);
                }
                if (systemService || permittedList.contains(enabledPackage)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return true;
    }

    private AccessibilityManager getAccessibilityManagerForUser(int userId) {
        IBinder iBinder = ServiceManager.getService("accessibility");
        IAccessibilityManager service = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
        return new AccessibilityManager(this.mContext, service, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedAccessibilityServices(ComponentName who, List packageList) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (packageList != null) {
            int userId = UserHandle.getCallingUserId();
            List<AccessibilityServiceInfo> enabledServices = null;
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo user = this.getUserInfo(userId);
                if (user.isManagedProfile()) {
                    userId = user.profileGroupId;
                }
                AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                enabledServices = accessibilityManager.getEnabledAccessibilityServiceList(-1);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            if (enabledServices != null) {
                ArrayList<String> enabledPackages = new ArrayList<String>();
                for (AccessibilityServiceInfo service : enabledServices) {
                    enabledPackages.add(service.getResolveInfo().serviceInfo.packageName);
                }
                if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList, userId)) {
                    Slog.e(LOG_TAG, "Cannot set permitted accessibility services, because it contains already enabled accesibility services.");
                    return false;
                }
            }
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedAccessiblityServices = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServices(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedAccessiblityServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServicesForUser(int userId) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            int[] profileIds;
            ArrayList<String> result = null;
            for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userId)) {
                DevicePolicyData policy = this.getUserDataUnchecked(profileId);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedAccessiblityServices;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                long id2 = this.mInjector.binderClearCallingIdentity();
                try {
                    AccessibilityManager accessibilityManager;
                    List<AccessibilityServiceInfo> installedServices;
                    UserInfo user = this.getUserInfo(userId);
                    if (user.isManagedProfile()) {
                        userId = user.profileGroupId;
                    }
                    if ((installedServices = (accessibilityManager = this.getAccessibilityManagerForUser(userId)).getInstalledAccessibilityServiceList()) != null) {
                        for (AccessibilityServiceInfo service : installedServices) {
                            ServiceInfo serviceInfo = service.getResolveInfo().serviceInfo;
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccessibilityServicePermittedByAdmin(ComponentName who, String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(packageName, "packageName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query if an accessibility service is disabled by admin");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin == null) {
                return false;
            }
            if (admin.permittedAccessiblityServices == null) {
                return true;
            }
            return this.checkPackagesInPermittedListOrSystem(Collections.singletonList(packageName), admin.permittedAccessiblityServices, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCallerIsCurrentUserOrProfile() {
        int callingUserId = UserHandle.getCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo currentUser;
            UserInfo callingUser = this.getUserInfo(callingUserId);
            try {
                currentUser = this.mInjector.getIActivityManager().getCurrentUser();
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to talk to activity managed.", e);
                boolean bl = false;
                this.mInjector.binderRestoreCallingIdentity(token);
                return bl;
            }
            if (callingUser.isManagedProfile() && callingUser.profileGroupId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods for managed profile of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
            if (!callingUser.isManagedProfile() && callingUserId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedInputMethods(ComponentName who, List packageList) {
        InputMethodManager inputMethodManager;
        List<InputMethodInfo> enabledImes;
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.checkCallerIsCurrentUserOrProfile()) {
            return false;
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        if (packageList != null && (enabledImes = (inputMethodManager = this.mContext.getSystemService(InputMethodManager.class)).getEnabledInputMethodList()) != null) {
            ArrayList<String> enabledPackages = new ArrayList<String>();
            for (InputMethodInfo ime : enabledImes) {
                enabledPackages.add(ime.getPackageName());
            }
            if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList, callingUserId)) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods, because it contains already enabled input method.");
                return false;
            }
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedInputMethods = packageList;
            this.saveSettingsLocked(callingUserId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethods(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedInputMethods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethodsForCurrentUser() {
        UserInfo currentUser;
        this.enforceManageUsers();
        try {
            currentUser = this.mInjector.getIActivityManager().getCurrentUser();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to make remote calls to get current user", e);
            return null;
        }
        int userId = currentUser.id;
        Object object = this.getLockObject();
        synchronized (object) {
            int[] profileIds;
            ArrayList<String> result = null;
            for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userId)) {
                DevicePolicyData policy = this.getUserDataUnchecked(profileId);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedInputMethods;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                InputMethodManager inputMethodManager = this.mContext.getSystemService(InputMethodManager.class);
                List<InputMethodInfo> imes = inputMethodManager.getInputMethodList();
                long id2 = this.mInjector.binderClearCallingIdentity();
                try {
                    if (imes != null) {
                        for (InputMethodInfo ime : imes) {
                            ServiceInfo serviceInfo = ime.getServiceInfo();
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInputMethodPermittedByAdmin(ComponentName who, String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(packageName, "packageName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query if an input method is disabled by admin");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin == null) {
                return false;
            }
            if (admin.permittedInputMethods == null) {
                return true;
            }
            return this.checkPackagesInPermittedListOrSystem(Collections.singletonList(packageName), admin.permittedInputMethods, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedCrossProfileNotificationListeners(ComponentName who, List<String> packageList) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        if (!this.isManagedProfile(callingUserId)) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedNotificationListeners = packageList;
            this.saveSettingsLocked(callingUserId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPermittedCrossProfileNotificationListeners(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedNotificationListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotificationListenerServicePermitted(String packageName, int userId) {
        if (!this.mHasFeature) {
            return true;
        }
        Preconditions.checkStringNotEmpty(packageName, "packageName is null or empty");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query if a notification listener service is permitted");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userId);
            if (profileOwner == null || profileOwner.permittedNotificationListeners == null) {
                return true;
            }
            return this.checkPackagesInPermittedListOrSystem(Collections.singletonList(packageName), profileOwner.permittedNotificationListeners, userId);
        }
    }

    private void maybeSendAdminEnabledBroadcastLocked(int userHandle) {
        DevicePolicyData policyData = this.getUserData(userHandle);
        if (policyData.mAdminBroadcastPending) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userHandle);
            boolean clearInitBundle = true;
            if (admin != null) {
                PersistableBundle initBundle = policyData.mInitBundle;
                clearInitBundle = this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_ENABLED", initBundle == null ? null : new Bundle(initBundle), null, true);
            }
            if (clearInitBundle) {
                policyData.mInitBundle = null;
                policyData.mAdminBroadcastPending = false;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public UserHandle createAndManageUser(ComponentName admin, String name, ComponentName profileOwner, PersistableBundle adminExtras, int flags) {
        int targetSdkVersion;
        Preconditions.checkNotNull(admin, "admin is null");
        Preconditions.checkNotNull(profileOwner, "profileOwner is null");
        if (!admin.getPackageName().equals(profileOwner.getPackageName())) {
            throw new IllegalArgumentException("profileOwner " + profileOwner + " and admin " + admin + " are not in the same package");
        }
        if (!this.mInjector.binderGetCallingUserHandle().isSystem()) {
            throw new SecurityException("createAndManageUser was called from non-system user");
        }
        boolean ephemeral = (flags & 2) != 0;
        boolean demo = (flags & 4) != 0 && UserManager.isDeviceInDemoMode(this.mContext);
        boolean leaveAllSystemAppsEnabled = (flags & 0x10) != 0;
        UserHandle user = null;
        Object object = this.getLockObject();
        // MONITORENTER : object
        this.getActiveAdminForCallerLocked(admin, -2);
        int callingUid = this.mInjector.binderGetCallingUid();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo userInfo;
            targetSdkVersion = this.mInjector.getPackageManagerInternal().getUidTargetSdkVersion(callingUid);
            DeviceStorageMonitorInternal deviceStorageMonitorInternal = LocalServices.getService(DeviceStorageMonitorInternal.class);
            if (deviceStorageMonitorInternal.isMemoryLow()) {
                if (targetSdkVersion >= 28) {
                    throw new ServiceSpecificException(5, "low device storage");
                }
                UserHandle userHandle = null;
                return userHandle;
            }
            if (!this.mUserManager.canAddMoreUsers()) {
                if (targetSdkVersion >= 28) {
                    throw new ServiceSpecificException(6, "user limit reached");
                }
                UserHandle userHandle = null;
                return userHandle;
            }
            int userInfoFlags = 0;
            if (ephemeral) {
                userInfoFlags |= 0x100;
            }
            if (demo) {
                userInfoFlags |= 0x200;
            }
            String[] disallowedPackages = null;
            if (!leaveAllSystemAppsEnabled) {
                disallowedPackages = this.mOverlayPackagesProvider.getNonRequiredApps(admin, UserHandle.myUserId(), "android.app.action.PROVISION_MANAGED_USER").toArray(new String[0]);
            }
            if ((userInfo = this.mUserManagerInternal.createUserEvenWhenDisallowed(name, userInfoFlags, disallowedPackages)) != null) {
                user = userInfo.getUserHandle();
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        // MONITOREXIT : object
        if (user == null) {
            if (targetSdkVersion < 28) return null;
            throw new ServiceSpecificException(1, "failed to create user");
        }
        int userHandle = user.getIdentifier();
        Intent intent = new Intent("android.app.action.MANAGED_USER_CREATED").putExtra("android.intent.extra.user_handle", userHandle).putExtra("android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED", leaveAllSystemAppsEnabled).setPackage(DevicePolicyManagerService.getManagedProvisioningPackage(this.mContext)).addFlags(0x10000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
        id2 = this.mInjector.binderClearCallingIdentity();
        try {
            String adminPkg = admin.getPackageName();
            try {
                if (!this.mIPackageManager.isPackageAvailable(adminPkg, userHandle)) {
                    this.mIPackageManager.installExistingPackageAsUser(adminPkg, userHandle, 0, 1);
                }
            }
            catch (RemoteException userInfoFlags) {
                // empty catch block
            }
            this.setActiveAdmin(profileOwner, true, userHandle);
            String ownerName = this.getProfileOwnerName(Process.myUserHandle().getIdentifier());
            this.setProfileOwner(profileOwner, ownerName, userHandle);
            Object object2 = this.getLockObject();
            // MONITORENTER : object2
            DevicePolicyData policyData = this.getUserData(userHandle);
            policyData.mInitBundle = adminExtras;
            policyData.mAdminBroadcastPending = true;
            this.saveSettingsLocked(userHandle);
            // MONITOREXIT : object2
            if ((flags & 1) != 0) {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 1, userHandle);
            }
            object2 = user;
            return object2;
        }
        catch (Throwable re) {
            this.mUserManager.removeUser(userHandle);
            if (targetSdkVersion >= 28) {
                throw new ServiceSpecificException(1, re.getMessage());
            }
            UserHandle userHandle2 = null;
            return userHandle2;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(userHandle, "UserHandle is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            String restriction;
            String string2 = restriction = this.isManagedProfile(userHandle.getIdentifier()) ? "no_remove_managed_profile" : "no_remove_user";
            if (this.isAdminAffectedByRestriction(who, restriction, callingUserId)) {
                Log.w(LOG_TAG, "The device owner cannot remove a user because " + restriction + " is enabled, and was not set by the device owner");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mUserManagerInternal.removeUserEvenWhenDisallowed(userHandle.getIdentifier());
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    private boolean isAdminAffectedByRestriction(ComponentName admin, String userRestriction, int userId) {
        switch (this.mUserManager.getUserRestrictionSource(userRestriction, UserHandle.of(userId))) {
            case 0: {
                return false;
            }
            case 2: {
                return !this.isDeviceOwner(admin, userId);
            }
            case 4: {
                return !this.isProfileOwner(admin, userId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            boolean bl;
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int userId = 0;
                if (userHandle != null) {
                    userId = userHandle.getIdentifier();
                }
                bl = this.mInjector.getIActivityManager().switchUser(userId);
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (RemoteException e) {
                boolean bl2;
                try {
                    Log.e(LOG_TAG, "Couldn't switch user", e);
                    bl2 = false;
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startUserInBackground(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(userHandle, "UserHandle is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int userId = userHandle.getIdentifier();
        if (this.isManagedProfile(userId)) {
            Log.w(LOG_TAG, "Managed profile cannot be started in background");
            return 2;
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            if (!this.mInjector.getActivityManagerInternal().canStartMoreUsers()) {
                Log.w(LOG_TAG, "Cannot start more users in background");
                int n = 3;
                return n;
            }
            if (this.mInjector.getIActivityManager().startUserInBackground(userId)) {
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (RemoteException e) {
            int n = 1;
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(userHandle, "UserHandle is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int userId = userHandle.getIdentifier();
        if (this.isManagedProfile(userId)) {
            Log.w(LOG_TAG, "Managed profile cannot be stopped");
            return 2;
        }
        return this.stopUserUnchecked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logoutUser(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (!this.isUserAffiliatedWithDeviceLocked(callingUserId)) {
                throw new SecurityException("Admin " + who + " is neither the device owner or affiliated user's profile owner.");
            }
        }
        if (this.isManagedProfile(callingUserId)) {
            Log.w(LOG_TAG, "Managed profile cannot be logout");
            return 2;
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            if (!this.mInjector.getIActivityManager().switchUser(0)) {
                Log.w(LOG_TAG, "Failed to switch to primary user");
                int n = 1;
                return n;
            }
        }
        catch (RemoteException e) {
            int n = 1;
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return this.stopUserUnchecked(callingUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopUserUnchecked(int userId) {
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            switch (this.mInjector.getIActivityManager().stopUser(userId, true, null)) {
                case 0: {
                    int n = 0;
                    return n;
                }
                case -2: {
                    int n = 4;
                    return n;
                }
            }
            int n = 1;
            return n;
        }
        catch (RemoteException e) {
            int n = 1;
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserHandle> getSecondaryUsers(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            List<UserInfo> userInfos = this.mInjector.getUserManager().getUsers(true);
            ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
            for (UserInfo userInfo : userInfos) {
                UserHandle userHandle = userInfo.getUserHandle();
                if (userHandle.isSystem() || this.isManagedProfile(userHandle.getIdentifier())) continue;
                userHandles.add(userInfo.getUserHandle());
            }
            ArrayList<UserHandle> arrayList = userHandles;
            return arrayList;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEphemeralUser(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mInjector.getUserManager().isUserEphemeral(callingUserId);
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictions(ComponentName who, String callerPackage, String packageName) {
        this.enforceCanManageScope(who, callerPackage, -1, "delegation-app-restrictions");
        UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            Bundle bundle = this.mUserManager.getApplicationRestrictions(packageName, userHandle);
            Bundle bundle2 = bundle != null ? bundle : Bundle.EMPTY;
            return bundle2;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] setPackagesSuspended(ComponentName who, String callerPackage, String[] packageNames, boolean suspended) {
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-package-access");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                String[] stringArray = this.mIPackageManager.setPackagesSuspendedAsUser(packageNames, suspended, null, null, null, "android", callingUserId);
                return stringArray;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed talking to the package manager", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return packageNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPackageSuspended(ComponentName who, String callerPackage, String packageName) {
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-package-access");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.isPackageSuspendedForUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed talking to the package manager", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestriction(ComponentName who, String key, boolean enabledFromThisOwner) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!UserRestrictionsUtils.isValidRestriction(key)) {
            return;
        }
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            boolean isDeviceOwner = this.isDeviceOwner(who, userHandle);
            if (isDeviceOwner) {
                if (!UserRestrictionsUtils.canDeviceOwnerChange(key)) {
                    throw new SecurityException("Device owner cannot set user restriction " + key);
                }
            } else if (!UserRestrictionsUtils.canProfileOwnerChange(key, userHandle)) {
                throw new SecurityException("Profile owner cannot set user restriction " + key);
            }
            Bundle restrictions = activeAdmin.ensureUserRestrictions();
            if (enabledFromThisOwner) {
                restrictions.putBoolean(key, true);
            } else {
                restrictions.remove(key);
            }
            this.saveUserRestrictionsLocked(userHandle);
        }
        if (SecurityLog.isLoggingEnabled()) {
            int eventTag = enabledFromThisOwner ? 210027 : 210028;
            SecurityLog.writeEvent(eventTag, who.getPackageName(), userHandle, key);
        }
    }

    private void saveUserRestrictionsLocked(int userId) {
        this.saveSettingsLocked(userId);
        this.pushUserRestrictions(userId);
        this.sendChangedNotification(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushUserRestrictions(int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            Bundle userRestrictions;
            boolean isDeviceOwner = this.mOwners.isDeviceOwnerUserId(userId);
            boolean disallowCameraGlobally = false;
            if (isDeviceOwner) {
                ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
                if (deviceOwner == null) {
                    return;
                }
                userRestrictions = deviceOwner.userRestrictions;
                disallowCameraGlobally = deviceOwner.disableCamera;
            } else {
                ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userId);
                userRestrictions = profileOwner != null ? profileOwner.userRestrictions : null;
            }
            int cameraRestrictionScope = this.getCameraRestrictionScopeLocked(userId, disallowCameraGlobally);
            this.mUserManagerInternal.setDevicePolicyUserRestrictions(userId, userRestrictions, isDeviceOwner, cameraRestrictionScope);
        }
    }

    private int getCameraRestrictionScopeLocked(int userId, boolean disallowCameraGlobally) {
        if (disallowCameraGlobally) {
            return 2;
        }
        if (this.getCameraDisabled(null, userId, false)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getUserRestrictions(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            return activeAdmin.userRestrictions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setApplicationHidden(ComponentName who, String callerPackage, String packageName, boolean hidden) {
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-package-access");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.setApplicationHiddenSettingAsUser(packageName, hidden, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setApplicationHiddenSetting", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isApplicationHidden(ComponentName who, String callerPackage, String packageName) {
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-package-access");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.getApplicationHiddenSettingAsUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getApplicationHiddenSettingAsUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSystemApp(ComponentName who, String callerPackage, String packageName) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-enable-system-app");
            boolean isDemo = this.isCurrentUserDemo();
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int parentUserId = this.getProfileParentId(userId);
                if (!isDemo && !this.isSystemApp(this.mIPackageManager, packageName, parentUserId)) {
                    throw new IllegalArgumentException("Only system apps can be enabled this way.");
                }
                this.mIPackageManager.installExistingPackageAsUser(packageName, userId, 0, 1);
                if (isDemo) {
                    this.mIPackageManager.setApplicationEnabledSetting(packageName, 1, 1, userId, LOG_TAG);
                }
            }
            catch (RemoteException re) {
                Slog.wtf(LOG_TAG, "Failed to install " + packageName, re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableSystemAppWithIntent(ComponentName who, String callerPackage, Intent intent) {
        Object object = this.getLockObject();
        synchronized (object) {
            int n;
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-enable-system-app");
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int parentUserId = this.getProfileParentId(userId);
                List activitiesToEnable = this.mIPackageManager.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 786432, parentUserId).getList();
                int numberOfAppsInstalled = 0;
                if (activitiesToEnable != null) {
                    for (ResolveInfo info : activitiesToEnable) {
                        if (info.activityInfo == null) continue;
                        String packageName = info.activityInfo.packageName;
                        if (this.isSystemApp(this.mIPackageManager, packageName, parentUserId)) {
                            ++numberOfAppsInstalled;
                            this.mIPackageManager.installExistingPackageAsUser(packageName, userId, 0, 1);
                            continue;
                        }
                        Slog.d(LOG_TAG, "Not enabling " + packageName + " since is not a system app");
                    }
                }
                n = numberOfAppsInstalled;
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (RemoteException e) {
                int n2;
                try {
                    Slog.wtf(LOG_TAG, "Failed to resolve intent for: " + intent);
                    n2 = 0;
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                    throw throwable;
                }
                return n2;
            }
            return n;
        }
    }

    private boolean isSystemApp(IPackageManager pm, String packageName, int userId) throws RemoteException {
        ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 8192, userId);
        if (appInfo == null) {
            throw new IllegalArgumentException("The application " + packageName + " is not present on this device");
        }
        return (appInfo.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installExistingPackage(ComponentName who, String callerPackage, String packageName) {
        Object object = this.getLockObject();
        synchronized (object) {
            boolean bl;
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-install-existing-package");
            int callingUserId = this.mInjector.userHandleGetCallingUserId();
            if (!this.isUserAffiliatedWithDeviceLocked(callingUserId)) {
                throw new SecurityException("Admin " + who + " is neither the device owner or affiliated user's profile owner.");
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                bl = this.mIPackageManager.installExistingPackageAsUser(packageName, callingUserId, 0, 1) == 1;
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (RemoteException re) {
                boolean bl2;
                try {
                    bl2 = false;
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccountManagementDisabled(ComponentName who, String accountType, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (disabled) {
                ap.accountTypesWithManagementDisabled.add(accountType);
            } else {
                ap.accountTypesWithManagementDisabled.remove(accountType);
            }
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
    }

    @Override
    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAccountTypesWithManagementDisabledAsUser(int userId) {
        this.enforceFullCrossUsersPermission(userId);
        if (!this.mHasFeature) {
            return null;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userId);
            int N = policy.mAdminList.size();
            ArraySet<String> resultSet = new ArraySet<String>();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                resultSet.addAll(admin.accountTypesWithManagementDisabled);
            }
            return resultSet.toArray(new String[resultSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUninstallBlocked(ComponentName who, String callerPackage, String packageName, boolean uninstallBlocked) {
        int userId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(who, callerPackage, -1, "delegation-block-uninstall");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.setBlockUninstallForUser(packageName, uninstallBlocked, userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setBlockUninstallForUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUninstallBlocked(ComponentName who, String packageName) {
        int userId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            if (who != null) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.getBlockUninstallForUser(packageName, userId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getBlockUninstallForUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossProfileCallerIdDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableCallerId != disabled) {
                admin.disableCallerId = disabled;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableCallerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabledForUser(int userId) {
        this.enforceCrossUsersPermission(userId);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableCallerId : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossProfileContactsSearchDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableContactsSearch != disabled) {
                admin.disableContactsSearch = disabled;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileContactsSearchDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableContactsSearch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileContactsSearchDisabledForUser(int userId) {
        this.enforceCrossUsersPermission(userId);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableContactsSearch : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void startManagedQuickContact(String actualLookupKey, long actualContactId, boolean isContactIdIgnored, long actualDirectoryId, Intent originalIntent) {
        int managedUserId;
        long ident;
        Intent intent;
        block9: {
            intent = ContactsContract.QuickContact.rebuildManagedQuickContactsIntent(actualLookupKey, actualContactId, isContactIdIgnored, actualDirectoryId, originalIntent);
            int callingUserId = UserHandle.getCallingUserId();
            ident = this.mInjector.binderClearCallingIdentity();
            Object object = this.getLockObject();
            // MONITORENTER : object
            managedUserId = this.getManagedUserId(callingUserId);
            if (managedUserId < 0) {
                // MONITOREXIT : object
                this.mInjector.binderRestoreCallingIdentity(ident);
                return;
            }
            if (!this.isCrossProfileQuickContactDisabled(managedUserId)) break block9;
            this.mInjector.binderRestoreCallingIdentity(ident);
            return;
        }
        try {
            ContactsInternal.startQuickContactWithErrorToastForUser(this.mContext, intent, new UserHandle(managedUserId));
            // MONITOREXIT : object
            return;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private boolean isCrossProfileQuickContactDisabled(int userId) {
        return this.getCrossProfileCallerIdDisabledForUser(userId) && this.getCrossProfileContactsSearchDisabledForUser(userId);
    }

    public int getManagedUserId(int callingUserId) {
        for (UserInfo ui : this.mUserManager.getProfiles(callingUserId)) {
            if (ui.id == callingUserId || !ui.isManagedProfile()) continue;
            return ui.id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothContactSharingDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableBluetoothContactSharing != disabled) {
                admin.disableBluetoothContactSharing = disabled;
                this.saveSettingsLocked(UserHandle.getCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableBluetoothContactSharing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabledForUser(int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableBluetoothContactSharing : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockTaskPackages(ComponentName who, String[] packages) throws SecurityException {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(packages, "packages is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanCallLockTaskLocked(who);
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.setLockTaskPackagesLocked(userHandle, new ArrayList<String>(Arrays.asList(packages)));
        }
    }

    private void setLockTaskPackagesLocked(int userHandle, List<String> packages) {
        DevicePolicyData policy = this.getUserData(userHandle);
        policy.mLockTaskPackages = packages;
        this.saveSettingsLocked(userHandle);
        this.updateLockTaskPackagesLocked(packages, userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLockTaskPackages(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.binderGetCallingUserHandle().getIdentifier();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanCallLockTaskLocked(who);
            List<String> packages = this.getUserData((int)userHandle).mLockTaskPackages;
            return packages.toArray(new String[packages.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockTaskPermitted(String pkg) {
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            return this.getUserData((int)userHandle).mLockTaskPackages.contains(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockTaskFeatures(ComponentName who, int flags) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        boolean hasHome = (flags & 4) != 0;
        boolean hasOverview = (flags & 8) != 0;
        Preconditions.checkArgument(hasHome || !hasOverview, "Cannot use LOCK_TASK_FEATURE_OVERVIEW without LOCK_TASK_FEATURE_HOME");
        boolean hasNotification = (flags & 2) != 0;
        Preconditions.checkArgument(hasHome || !hasNotification, "Cannot use LOCK_TASK_FEATURE_NOTIFICATIONS without LOCK_TASK_FEATURE_HOME");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanCallLockTaskLocked(who);
            this.setLockTaskFeaturesLocked(userHandle, flags);
        }
    }

    private void setLockTaskFeaturesLocked(int userHandle, int flags) {
        DevicePolicyData policy = this.getUserData(userHandle);
        policy.mLockTaskFeatures = flags;
        this.saveSettingsLocked(userHandle);
        this.updateLockTaskFeaturesLocked(flags, userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLockTaskFeatures(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanCallLockTaskLocked(who);
            return this.getUserData((int)userHandle).mLockTaskFeatures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeClearLockTaskPolicyLocked() {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            List<UserInfo> userInfos = this.mUserManager.getUsers(true);
            for (int i = userInfos.size() - 1; i >= 0; --i) {
                int lockTaskFeatures;
                int userId = userInfos.get((int)i).id;
                if (this.canUserUseLockTaskLocked(userId)) continue;
                List<String> lockTaskPackages = this.getUserData((int)userId).mLockTaskPackages;
                if (!lockTaskPackages.isEmpty()) {
                    Slog.d(LOG_TAG, "User id " + userId + " not affiliated. Clearing lock task packages");
                    this.setLockTaskPackagesLocked(userId, Collections.emptyList());
                }
                if ((lockTaskFeatures = this.getUserData((int)userId).mLockTaskFeatures) == 0) continue;
                Slog.d(LOG_TAG, "User id " + userId + " not affiliated. Clearing lock task features");
                this.setLockTaskFeaturesLocked(userId, 0);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLockTaskModeChanged(boolean isEnabled, String pkg, int userHandle) {
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("notifyLockTaskModeChanged can only be called by system");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mStatusBarDisabled) {
                this.setStatusBarDisabledInternal(!isEnabled, userHandle);
            }
            Bundle adminExtras = new Bundle();
            adminExtras.putString("android.app.extra.LOCK_TASK_PACKAGE", pkg);
            for (ActiveAdmin admin : policy.mAdminList) {
                boolean ownsDevice = this.isDeviceOwner(admin.info.getComponent(), userHandle);
                boolean ownsProfile = this.isProfileOwner(admin.info.getComponent(), userHandle);
                if (!ownsDevice && !ownsProfile) continue;
                if (isEnabled) {
                    this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_ENTERING", adminExtras, null);
                    continue;
                }
                this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_EXITING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            long timeMs;
            this.getActiveAdminForCallerLocked(who, -2);
            if (GLOBAL_SETTINGS_DEPRECATED.contains(setting)) {
                Log.i(LOG_TAG, "Global setting no longer supported: " + setting);
                return;
            }
            if (!GLOBAL_SETTINGS_WHITELIST.contains(setting) && !UserManager.isDeviceInDemoMode(this.mContext)) {
                throw new SecurityException(String.format("Permission denial: device owners cannot update %1$s", setting));
            }
            if ("stay_on_while_plugged_in".equals(setting) && (timeMs = this.getMaximumTimeToLock(who, this.mInjector.userHandleGetCallingUserId(), false)) > 0L && timeMs < Long.MAX_VALUE) {
                return;
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mInjector.settingsGlobalPutString(setting, value);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(setting, "String setting is null or empty");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (!SYSTEM_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: device owners cannot update %1$s", setting));
            }
            int callingUserId = this.mInjector.userHandleGetCallingUserId();
            this.mInjector.binderWithCleanCallingIdentity(() -> this.mInjector.settingsSystemPutStringForUser(setting, value, callingUserId));
        }
    }

    @Override
    public boolean setTime(ComponentName who, long millis) {
        Preconditions.checkNotNull(who, "ComponentName is null in setTime");
        this.getActiveAdminForCallerLocked(who, -2);
        if (this.mInjector.settingsGlobalGetInt("auto_time", 0) == 1) {
            return false;
        }
        this.mInjector.binderWithCleanCallingIdentity(() -> this.mInjector.getAlarmManager().setTime(millis));
        return true;
    }

    @Override
    public boolean setTimeZone(ComponentName who, String timeZone) {
        Preconditions.checkNotNull(who, "ComponentName is null in setTimeZone");
        this.getActiveAdminForCallerLocked(who, -2);
        if (this.mInjector.settingsGlobalGetInt("auto_time_zone", 0) == 1) {
            return false;
        }
        this.mInjector.binderWithCleanCallingIdentity(() -> this.mInjector.getAlarmManager().setTimeZone(timeZone));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecureSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (this.isDeviceOwner(who, callingUserId)) {
                if (!SECURE_SETTINGS_DEVICEOWNER_WHITELIST.contains(setting) && !this.isCurrentUserDemo()) {
                    throw new SecurityException(String.format("Permission denial: Device owners cannot update %1$s", setting));
                }
            } else if (!SECURE_SETTINGS_WHITELIST.contains(setting) && !this.isCurrentUserDemo()) {
                throw new SecurityException(String.format("Permission denial: Profile owners cannot update %1$s", setting));
            }
            if (setting.equals("install_non_market_apps")) {
                if (this.getTargetSdk(who.getPackageName(), callingUserId) >= 26) {
                    throw new UnsupportedOperationException("install_non_market_apps is deprecated. Please use the user restriction no_install_unknown_sources instead.");
                }
                if (!this.mUserManager.isManagedProfile(callingUserId)) {
                    Slog.e(LOG_TAG, "Ignoring setSecureSetting request for " + setting + ". User restriction " + "no_install_unknown_sources" + " should be used instead.");
                } else {
                    try {
                        this.setUserRestriction(who, "no_install_unknown_sources", Integer.parseInt(value) == 0);
                    }
                    catch (NumberFormatException exc) {
                        Slog.e(LOG_TAG, "Invalid value: " + value + " for setting " + setting);
                    }
                }
                return;
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                if ("default_input_method".equals(setting)) {
                    String currentValue = this.mInjector.settingsSecureGetStringForUser("default_input_method", callingUserId);
                    if (!TextUtils.equals(currentValue, value)) {
                        this.mSetupContentObserver.addPendingChangeByOwnerLocked(callingUserId);
                    }
                    this.getUserData((int)callingUserId).mCurrentInputMethodSet = true;
                    this.saveSettingsLocked(callingUserId);
                }
                this.mInjector.settingsSecurePutStringForUser(setting, value, callingUserId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterVolumeMuted(ComponentName who, boolean on) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            this.setUserRestriction(who, "disallow_unmute_device", on);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMasterVolumeMuted(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            return audioManager.isMasterMute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(ComponentName who, Bitmap icon) {
        Object object = this.getLockObject();
        synchronized (object) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManagerInternal.setUserIcon(userId, icon);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setKeyguardDisabled(ComponentName who, boolean disabled) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (!this.isUserAffiliatedWithDeviceLocked(userId)) {
                throw new SecurityException("Admin " + who + " is neither the device owner or affiliated user's profile owner.");
            }
        }
        if (this.isManagedProfile(userId)) {
            throw new SecurityException("Managed profile cannot disable keyguard");
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            if (disabled && this.mLockPatternUtils.isSecure(userId)) {
                boolean bl = false;
                return bl;
            }
            this.mLockPatternUtils.setLockScreenDisabled(disabled, userId);
            this.mInjector.getIWindowManager().dismissKeyguard(null, null);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStatusBarDisabled(ComponentName who, boolean disabled) {
        int userId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (!this.isUserAffiliatedWithDeviceLocked(userId)) {
                throw new SecurityException("Admin " + who + " is neither the device owner or affiliated user's profile owner.");
            }
            if (this.isManagedProfile(userId)) {
                throw new SecurityException("Managed profile cannot disable status bar");
            }
            DevicePolicyData policy = this.getUserData(userId);
            if (policy.mStatusBarDisabled != disabled) {
                boolean isLockTaskMode = false;
                try {
                    isLockTaskMode = this.mInjector.getIActivityManager().getLockTaskModeState() != 0;
                }
                catch (RemoteException e) {
                    Slog.e(LOG_TAG, "Failed to get LockTask mode");
                }
                if (!isLockTaskMode && !this.setStatusBarDisabledInternal(disabled, userId)) {
                    return false;
                }
                policy.mStatusBarDisabled = disabled;
                this.saveSettingsLocked(userId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setStatusBarDisabledInternal(boolean disabled, int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            IStatusBarService statusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService(TAG_STATUS_BAR));
            if (statusBarService != null) {
                int flags1 = disabled ? 0x2070000 : 0;
                int flags2 = disabled ? 1 : 0;
                statusBarService.disableForUser(flags1, this.mToken, this.mContext.getPackageName(), userId);
                statusBarService.disable2ForUser(flags2, this.mToken, this.mContext.getPackageName(), userId);
                boolean bl = true;
                return bl;
            }
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to disable the status bar", e);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUserSetupCompleteAndPaired() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            Object object;
            DevicePolicyData policy;
            int userHandle = users.get((int)i).id;
            if (this.mInjector.settingsSecureGetIntForUser("user_setup_complete", 0, userHandle) != 0) {
                policy = this.getUserData(userHandle);
                if (!policy.mUserSetupComplete) {
                    policy.mUserSetupComplete = true;
                    object = this.getLockObject();
                    synchronized (object) {
                        this.saveSettingsLocked(userHandle);
                    }
                }
            }
            if (!this.mIsWatch || this.mInjector.settingsSecureGetIntForUser("device_paired", 0, userHandle) == 0) continue;
            policy = this.getUserData(userHandle);
            if (policy.mPaired) continue;
            policy.mPaired = true;
            object = this.getLockObject();
            synchronized (object) {
                this.saveSettingsLocked(userHandle);
                continue;
            }
        }
    }

    private Intent createShowAdminSupportIntent(ComponentName admin, int userId) {
        Intent intent = new Intent("android.settings.SHOW_ADMIN_SUPPORT_DETAILS");
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.putExtra("android.app.extra.DEVICE_ADMIN", admin);
        intent.setFlags(0x10000000);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent createAdminSupportIntent(String restriction) {
        Preconditions.checkNotNull(restriction);
        int uid = this.mInjector.binderGetCallingUid();
        int userId = UserHandle.getUserId(uid);
        Intent intent = null;
        if ("policy_disable_camera".equals(restriction) || "policy_disable_screen_capture".equals(restriction) || "policy_mandatory_backups".equals(restriction)) {
            Object object = this.getLockObject();
            synchronized (object) {
                ActiveAdmin admin;
                DevicePolicyData policy = this.getUserData(userId);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin2 = policy.mAdminList.get(i);
                    if (!(admin2.disableCamera && "policy_disable_camera".equals(restriction) || admin2.disableScreenCapture && "policy_disable_screen_capture".equals(restriction)) && (admin2.mandatoryBackupTransport == null || !"policy_mandatory_backups".equals(restriction))) continue;
                    intent = this.createShowAdminSupportIntent(admin2.info.getComponent(), userId);
                    break;
                }
                if (intent == null && "policy_disable_camera".equals(restriction) && (admin = this.getDeviceOwnerAdminLocked()) != null && admin.disableCamera) {
                    intent = this.createShowAdminSupportIntent(admin.info.getComponent(), this.mOwners.getDeviceOwnerUserId());
                }
            }
        } else {
            intent = this.mLocalService.createUserRestrictionSupportIntent(userId, restriction);
        }
        if (intent != null) {
            intent.putExtra("android.app.extra.RESTRICTION", restriction);
        }
        return intent;
    }

    private static boolean isLimitPasswordAllowed(ActiveAdmin admin, int minPasswordQuality) {
        if (admin.minimumPasswordMetrics.quality < minPasswordQuality) {
            return false;
        }
        return admin.info.usesPolicy(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemUpdatePolicy(ComponentName who, SystemUpdatePolicy policy) {
        if (policy != null) {
            policy.validateType();
            policy.validateFreezePeriods();
            Pair<LocalDate, LocalDate> record = this.mOwners.getSystemUpdateFreezePeriodRecord();
            policy.validateAgainstPreviousFreezePeriod((LocalDate)record.first, (LocalDate)record.second, LocalDate.now());
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
            if (policy == null) {
                this.mOwners.clearSystemUpdatePolicy();
            } else {
                this.mOwners.setSystemUpdatePolicy(policy);
                this.updateSystemUpdateFreezePeriodsRecord(false);
            }
            this.mOwners.writeDeviceOwner();
        }
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.SYSTEM_UPDATE_POLICY_CHANGED"), UserHandle.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemUpdatePolicy getSystemUpdatePolicy() {
        Object object = this.getLockObject();
        synchronized (object) {
            SystemUpdatePolicy policy = this.mOwners.getSystemUpdatePolicy();
            if (policy != null && !policy.isValid()) {
                Slog.w(LOG_TAG, "Stored system update policy is invalid, return null instead.");
                return null;
            }
            return policy;
        }
    }

    private static boolean withinRange(Pair<LocalDate, LocalDate> range, LocalDate date) {
        return !date.isBefore((ChronoLocalDate)range.first) && !date.isAfter((ChronoLocalDate)range.second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemUpdateFreezePeriodsRecord(boolean saveIfChanged) {
        Slog.d(LOG_TAG, "updateSystemUpdateFreezePeriodsRecord");
        Object object = this.getLockObject();
        synchronized (object) {
            SystemUpdatePolicy policy = this.mOwners.getSystemUpdatePolicy();
            if (policy == null) {
                return;
            }
            LocalDate now = LocalDate.now();
            Pair<LocalDate, LocalDate> currentPeriod = policy.getCurrentFreezePeriod(now);
            if (currentPeriod == null) {
                return;
            }
            Pair<LocalDate, LocalDate> record = this.mOwners.getSystemUpdateFreezePeriodRecord();
            LocalDate start = (LocalDate)record.first;
            LocalDate end = (LocalDate)record.second;
            boolean changed = end == null || start == null ? this.mOwners.setSystemUpdateFreezePeriodRecord(now, now) : (now.equals(end.plusDays(1L)) ? this.mOwners.setSystemUpdateFreezePeriodRecord(start, now) : (now.isAfter(end.plusDays(1L)) ? (DevicePolicyManagerService.withinRange(currentPeriod, start) && DevicePolicyManagerService.withinRange(currentPeriod, end) ? this.mOwners.setSystemUpdateFreezePeriodRecord(start, now) : this.mOwners.setSystemUpdateFreezePeriodRecord(now, now)) : (now.isBefore(start) ? this.mOwners.setSystemUpdateFreezePeriodRecord(now, now) : false)));
            if (changed && saveIfChanged) {
                this.mOwners.writeDeviceOwner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSystemUpdatePolicyFreezePeriodRecord() {
        this.enforceShell("clearSystemUpdatePolicyFreezePeriodRecord");
        Object object = this.getLockObject();
        synchronized (object) {
            Slog.i(LOG_TAG, "Clear freeze period record: " + this.mOwners.getSystemUpdateFreezePeriodRecordAsString());
            if (this.mOwners.setSystemUpdateFreezePeriodRecord(null, null)) {
                this.mOwners.writeDeviceOwner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isCallerDeviceOwner(int callerUid) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.mOwners.hasDeviceOwner()) {
                return false;
            }
            if (UserHandle.getUserId(callerUid) != this.mOwners.getDeviceOwnerUserId()) {
                return false;
            }
            String deviceOwnerPackageName = this.mOwners.getDeviceOwnerComponent().getPackageName();
            try {
                String[] pkgs;
                for (String pkg : pkgs = this.mInjector.getIPackageManager().getPackagesForUid(callerUid)) {
                    if (!deviceOwnerPackageName.equals(pkg)) continue;
                    return true;
                }
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingSystemUpdate(SystemUpdateInfo info) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NOTIFY_PENDING_SYSTEM_UPDATE", "Only the system update service can broadcast update information");
        if (UserHandle.getCallingUserId() != 0) {
            Slog.w(LOG_TAG, "Only the system update service in the system user can broadcast update information.");
            return;
        }
        if (!this.mOwners.saveSystemUpdateInfo(info)) {
            return;
        }
        Intent intent = new Intent("android.app.action.NOTIFY_PENDING_SYSTEM_UPDATE").putExtra("android.app.extra.SYSTEM_UPDATE_RECEIVED_TIME", info == null ? -1L : info.getReceivedTime());
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            int[] runningUserIds;
            Object object = this.getLockObject();
            synchronized (object) {
                if (this.mOwners.hasDeviceOwner()) {
                    UserHandle deviceOwnerUser = UserHandle.of(this.mOwners.getDeviceOwnerUserId());
                    intent.setComponent(this.mOwners.getDeviceOwnerComponent());
                    this.mContext.sendBroadcastAsUser(intent, deviceOwnerUser);
                }
            }
            try {
                runningUserIds = this.mInjector.getIActivityManager().getRunningUserIds();
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Could not retrieve the list of running users", e);
                this.mInjector.binderRestoreCallingIdentity(ident);
                return;
            }
            for (int userId : runningUserIds) {
                Object object2 = this.getLockObject();
                synchronized (object2) {
                    ComponentName profileOwnerPackage = this.mOwners.getProfileOwnerComponent(userId);
                    if (profileOwnerPackage != null) {
                        intent.setComponent(profileOwnerPackage);
                        this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userId));
                    }
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    @Override
    public SystemUpdateInfo getPendingSystemUpdate(ComponentName admin) {
        Preconditions.checkNotNull(admin, "ComponentName is null");
        this.enforceProfileOrDeviceOwner(admin);
        return this.mOwners.getSystemUpdateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionPolicy(ComponentName admin, String callerPackage, int policy) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(admin, callerPackage, -1, "delegation-permission-grant");
            DevicePolicyData userPolicy = this.getUserData(userId);
            if (userPolicy.mPermissionPolicy != policy) {
                userPolicy.mPermissionPolicy = policy;
                this.saveSettingsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPermissionPolicy(ComponentName admin) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData userPolicy = this.getUserData(userId);
            return userPolicy.mPermissionPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPermissionGrantState(ComponentName admin, String callerPackage, String packageName, String permission2, int grantState) throws RemoteException {
        UserHandle user = this.mInjector.binderGetCallingUserHandle();
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceCanManageScope(admin, callerPackage, -1, "delegation-permission-grant");
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (this.getTargetSdk(packageName, user.getIdentifier()) < 23) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.isRuntimePermission(permission2)) {
                    boolean bl = false;
                    return bl;
                }
                PackageManager packageManager = this.mInjector.getPackageManager();
                switch (grantState) {
                    case 1: {
                        this.mInjector.getPackageManagerInternal().grantRuntimePermission(packageName, permission2, user.getIdentifier(), true);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 2: {
                        this.mInjector.getPackageManagerInternal().revokeRuntimePermission(packageName, permission2, user.getIdentifier(), true);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 0: {
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 0, user);
                        break;
                    }
                }
                boolean bl = true;
                return bl;
            }
            catch (SecurityException se) {
                boolean bl = false;
                return bl;
            }
            catch (PackageManager.NameNotFoundException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getPermissionGrantState(ComponentName admin, String callerPackage, String packageName, String permission2) throws RemoteException {
        PackageManager packageManager = this.mInjector.getPackageManager();
        UserHandle user = this.mInjector.binderGetCallingUserHandle();
        if (!this.isCallerWithSystemUid()) {
            this.enforceCanManageScope(admin, callerPackage, -1, "delegation-permission-grant");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                int granted = this.mIPackageManager.checkPermission(permission2, packageName, user.getIdentifier());
                int permFlags = packageManager.getPermissionFlags(permission2, packageName, user);
                if ((permFlags & 4) != 4) {
                    int n = 0;
                    return n;
                }
                int n = granted == 0 ? 1 : 2;
                return n;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    boolean isPackageInstalledForUser(String packageName, int userHandle) {
        try {
            PackageInfo pi = this.mInjector.getIPackageManager().getPackageInfo(packageName, 0, userHandle);
            return pi != null && pi.applicationInfo.flags != 0;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Package manager has died", re);
        }
    }

    public boolean isRuntimePermission(String permissionName) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = this.mInjector.getPackageManager();
        PermissionInfo permissionInfo = packageManager.getPermissionInfo(permissionName, 0);
        return (permissionInfo.protectionLevel & 0xF) == 1;
    }

    @Override
    public boolean isProvisioningAllowed(String action, String packageName) {
        Preconditions.checkNotNull(packageName);
        int callingUid = this.mInjector.binderGetCallingUid();
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            int uidForPackage = this.mInjector.getPackageManager().getPackageUidAsUser(packageName, UserHandle.getUserId(callingUid));
            Preconditions.checkArgument(callingUid == uidForPackage, "Caller uid doesn't match the one for the provided package.");
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Invalid package provided " + packageName, e);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return this.checkProvisioningPreConditionSkipPermission(action, packageName) == 0;
    }

    @Override
    public int checkProvisioningPreCondition(String action, String packageName) {
        Preconditions.checkNotNull(packageName);
        this.enforceCanManageProfileAndDeviceOwners();
        return this.checkProvisioningPreConditionSkipPermission(action, packageName);
    }

    private int checkProvisioningPreConditionSkipPermission(String action, String packageName) {
        if (!this.mHasFeature) {
            return 13;
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        if (action != null) {
            switch (action) {
                case "android.app.action.PROVISION_MANAGED_PROFILE": {
                    return this.checkManagedProfileProvisioningPreCondition(packageName, callingUserId);
                }
                case "android.app.action.PROVISION_MANAGED_DEVICE": {
                    return this.checkDeviceOwnerProvisioningPreCondition(callingUserId);
                }
                case "android.app.action.PROVISION_MANAGED_USER": {
                    return this.checkManagedUserProvisioningPreCondition(callingUserId);
                }
                case "android.app.action.PROVISION_MANAGED_SHAREABLE_DEVICE": {
                    return this.checkManagedShareableDeviceProvisioningPreCondition(callingUserId);
                }
            }
        }
        throw new IllegalArgumentException("Unknown provisioning action " + action);
    }

    private int checkDeviceOwnerProvisioningPreConditionLocked(ComponentName owner, int deviceOwnerUserId, boolean isAdb, boolean hasIncompatibleAccountsOrNonAdb) {
        if (this.mOwners.hasDeviceOwner()) {
            return 1;
        }
        if (this.mOwners.hasProfileOwner(deviceOwnerUserId)) {
            return 2;
        }
        if (!this.mUserManager.isUserRunning(new UserHandle(deviceOwnerUserId))) {
            return 3;
        }
        if (this.mIsWatch && this.hasPaired(0)) {
            return 8;
        }
        if (isAdb) {
            if ((this.mIsWatch || this.hasUserSetupCompleted(0)) && !this.mInjector.userManagerIsSplitSystemUser()) {
                if (this.mUserManager.getUserCount() > 1) {
                    return 5;
                }
                if (hasIncompatibleAccountsOrNonAdb) {
                    return 6;
                }
            }
            return 0;
        }
        if (!this.mInjector.userManagerIsSplitSystemUser()) {
            if (deviceOwnerUserId != 0) {
                return 7;
            }
            if (this.hasUserSetupCompleted(0)) {
                return 4;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkDeviceOwnerProvisioningPreCondition(int deviceOwnerUserId) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.checkDeviceOwnerProvisioningPreConditionLocked(null, deviceOwnerUserId, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkManagedProfileProvisioningPreCondition(String packageName, int callingUserId) {
        if (!this.hasFeatureManagedUsers()) {
            return 9;
        }
        if (callingUserId == 0 && this.mInjector.userManagerIsSplitSystemUser()) {
            return 14;
        }
        if (this.getProfileOwner(callingUserId) != null) {
            return 2;
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            UserHandle callingUserHandle = UserHandle.of(callingUserId);
            ComponentName ownerAdmin = this.getOwnerComponent(packageName, callingUserId);
            if (this.mUserManager.hasUserRestriction("no_add_managed_profile", callingUserHandle) && (ownerAdmin == null || this.isAdminAffectedByRestriction(ownerAdmin, "no_add_managed_profile", callingUserId))) {
                int n = 15;
                return n;
            }
            boolean canRemoveProfile = true;
            if (this.mUserManager.hasUserRestriction("no_remove_managed_profile", callingUserHandle) && (ownerAdmin == null || this.isAdminAffectedByRestriction(ownerAdmin, "no_remove_managed_profile", callingUserId))) {
                canRemoveProfile = false;
            }
            if (!this.mUserManager.canAddMoreManagedProfiles(callingUserId, canRemoveProfile)) {
                int n = 11;
                return n;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return 0;
    }

    private ComponentName getOwnerComponent(String packageName, int userId) {
        if (this.isDeviceOwnerPackage(packageName, userId)) {
            return this.mOwners.getDeviceOwnerComponent();
        }
        if (this.isProfileOwnerPackage(packageName, userId)) {
            return this.mOwners.getProfileOwnerComponent(userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentName getOwnerComponent(int userId) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mOwners.getDeviceOwnerUserId() == userId) {
                return this.mOwners.getDeviceOwnerComponent();
            }
            if (this.mOwners.hasProfileOwner(userId)) {
                return this.mOwners.getProfileOwnerComponent(userId);
            }
        }
        return null;
    }

    private int checkManagedUserProvisioningPreCondition(int callingUserId) {
        if (!this.hasFeatureManagedUsers()) {
            return 9;
        }
        if (!this.mInjector.userManagerIsSplitSystemUser()) {
            return 12;
        }
        if (callingUserId == 0) {
            return 10;
        }
        if (this.hasUserSetupCompleted(callingUserId)) {
            return 4;
        }
        if (this.mIsWatch && this.hasPaired(0)) {
            return 8;
        }
        return 0;
    }

    private int checkManagedShareableDeviceProvisioningPreCondition(int callingUserId) {
        if (!this.mInjector.userManagerIsSplitSystemUser()) {
            return 12;
        }
        return this.checkDeviceOwnerProvisioningPreCondition(callingUserId);
    }

    private boolean hasFeatureManagedUsers() {
        try {
            return this.mIPackageManager.hasSystemFeature("android.software.managed_users", 0);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWifiMacAddress(ComponentName admin) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            WifiInfo wifiInfo = this.mInjector.getWifiManager().getConnectionInfo();
            if (wifiInfo == null) {
                String string2 = null;
                return string2;
            }
            String string3 = wifiInfo.hasRealMacAddress() ? wifiInfo.getMacAddress() : null;
            return string3;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private int getTargetSdk(String packageName, int userId) {
        try {
            ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 0, userId);
            int targetSdkVersion = ai == null ? 0 : ai.targetSdkVersion;
            return targetSdkVersion;
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public boolean isManagedProfile(ComponentName admin) {
        this.enforceProfileOrDeviceOwner(admin);
        return this.isManagedProfile(this.mInjector.userHandleGetCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSystemOnlyUser(ComponentName admin) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        return UserManager.isSplitSystemUser() && callingUserId == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reboot(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            if (this.mTelephonyManager.getCallState() != 0) {
                throw new IllegalStateException("Cannot be called with ongoing call on the device");
            }
            this.mInjector.powerManagerReboot("deviceowner");
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShortSupportMessage(ComponentName who, CharSequence message) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            if (!TextUtils.equals(admin.shortSupportMessage, message)) {
                admin.shortSupportMessage = message;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getShortSupportMessage(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            return admin.shortSupportMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLongSupportMessage(ComponentName who, CharSequence message) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            if (!TextUtils.equals(admin.longSupportMessage, message)) {
                admin.longSupportMessage = message;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getLongSupportMessage(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            return admin.longSupportMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getShortSupportMessageForUser(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query support message for user");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin != null) {
                return admin.shortSupportMessage;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getLongSupportMessageForUser(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query support message for user");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin != null) {
                return admin.longSupportMessage;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationColor(ComponentName who, int color2) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        this.enforceManagedProfile(userHandle, "set organization color");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.organizationColor = color2;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationColorForUser(int color2, int userId) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userId);
        this.enforceManageUsers();
        this.enforceManagedProfile(userId, "set organization color");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            admin.organizationColor = color2;
            this.saveSettingsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrganizationColor(ComponentName who) {
        if (!this.mHasFeature) {
            return ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "get organization color");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.organizationColor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrganizationColorForUser(int userHandle) {
        if (!this.mHasFeature) {
            return ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "get organization color");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userHandle);
            return profileOwner != null ? profileOwner.organizationColor : ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationName(ComponentName who, CharSequence text) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (!TextUtils.equals(admin.organizationName, text)) {
                admin.organizationName = text == null || text.length() == 0 ? null : text.toString();
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getOrganizationName(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "get organization name");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.organizationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getDeviceOwnerOrganizationName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceDeviceOwnerOrManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwnerAdmin = this.getDeviceOwnerAdminLocked();
            return deviceOwnerAdmin == null ? null : deviceOwnerAdmin.organizationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getOrganizationNameForUser(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "get organization name");
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userHandle);
            return profileOwner != null ? profileOwner.organizationName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> setMeteredDataDisabledPackages(ComponentName who, List<String> packageNames) {
        Preconditions.checkNotNull(who);
        Preconditions.checkNotNull(packageNames);
        if (!this.mHasFeature) {
            return packageNames;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            List<String> list;
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            int callingUserId = this.mInjector.userHandleGetCallingUserId();
            long identity = this.mInjector.binderClearCallingIdentity();
            try {
                List<String> excludedPkgs = this.removeInvalidPkgsForMeteredDataRestriction(callingUserId, packageNames);
                admin.meteredDisabledPackages = packageNames;
                this.pushMeteredDisabledPackagesLocked(callingUserId);
                this.saveSettingsLocked(callingUserId);
                list = excludedPkgs;
                this.mInjector.binderRestoreCallingIdentity(identity);
            }
            catch (Throwable throwable) {
                this.mInjector.binderRestoreCallingIdentity(identity);
                throw throwable;
            }
            return list;
        }
    }

    private List<String> removeInvalidPkgsForMeteredDataRestriction(int userId, List<String> pkgNames) {
        Set<String> activeAdmins = this.getActiveAdminPackagesLocked(userId);
        ArrayList<String> excludedPkgs = new ArrayList<String>();
        for (int i = pkgNames.size() - 1; i >= 0; --i) {
            String pkgName = pkgNames.get(i);
            if (activeAdmins.contains(pkgName)) {
                excludedPkgs.add(pkgName);
                continue;
            }
            try {
                if (this.mInjector.getIPackageManager().isPackageAvailable(pkgName, userId)) continue;
                excludedPkgs.add(pkgName);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        pkgNames.removeAll(excludedPkgs);
        return excludedPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMeteredDataDisabledPackages(ComponentName who) {
        Preconditions.checkNotNull(who);
        if (!this.mHasFeature) {
            return new ArrayList<String>();
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.meteredDisabledPackages == null ? new ArrayList() : admin.meteredDisabledPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMeteredDataDisabledPackageForUser(ComponentName who, String packageName, int userId) {
        Preconditions.checkNotNull(who);
        if (!this.mHasFeature) {
            return false;
        }
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query restricted pkgs for a specific user");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userId);
            if (admin != null && admin.meteredDisabledPackages != null) {
                return admin.meteredDisabledPackages.contains(packageName);
            }
        }
        return false;
    }

    private void pushMeteredDisabledPackagesLocked(int userId) {
        this.mInjector.getNetworkPolicyManagerInternal().setMeteredRestrictedPackages(this.getMeteredDisabledPackagesLocked(userId), userId);
    }

    private Set<String> getMeteredDisabledPackagesLocked(int userId) {
        ActiveAdmin admin;
        ComponentName who = this.getOwnerComponent(userId);
        ArraySet<String> restrictedPkgs = new ArraySet<String>();
        if (who != null && (admin = this.getActiveAdminUncheckedLocked(who, userId)) != null && admin.meteredDisabledPackages != null) {
            restrictedPkgs.addAll(admin.meteredDisabledPackages);
        }
        return restrictedPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAffiliationIds(ComponentName admin, List<String> ids) {
        if (!this.mHasFeature) {
            return;
        }
        if (ids == null) {
            throw new IllegalArgumentException("ids must not be null");
        }
        for (String id2 : ids) {
            if (!TextUtils.isEmpty(id2)) continue;
            throw new IllegalArgumentException("ids must not contain empty string");
        }
        ArraySet<String> affiliationIds = new ArraySet<String>(ids);
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -1);
            this.getUserData((int)callingUserId).mAffiliationIds = affiliationIds;
            this.saveSettingsLocked(callingUserId);
            if (callingUserId != 0 && this.isDeviceOwner(admin, callingUserId)) {
                this.getUserData((int)0).mAffiliationIds = affiliationIds;
                this.saveSettingsLocked(0);
            }
            this.maybePauseDeviceWideLoggingLocked();
            this.maybeResumeDeviceWideLoggingLocked();
            this.maybeClearLockTaskPolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAffiliationIds(ComponentName admin) {
        if (!this.mHasFeature) {
            return Collections.emptyList();
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -1);
            return new ArrayList<String>(this.getUserData((int)this.mInjector.userHandleGetCallingUserId()).mAffiliationIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAffiliatedUser() {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            return this.isUserAffiliatedWithDeviceLocked(this.mInjector.userHandleGetCallingUserId());
        }
    }

    private boolean isUserAffiliatedWithDeviceLocked(int userId) {
        if (!this.mOwners.hasDeviceOwner()) {
            return false;
        }
        if (userId == this.mOwners.getDeviceOwnerUserId()) {
            return true;
        }
        if (userId == 0) {
            return true;
        }
        ComponentName profileOwner = this.getProfileOwner(userId);
        if (profileOwner == null) {
            return false;
        }
        Set<String> userAffiliationIds = this.getUserData((int)userId).mAffiliationIds;
        Set<String> deviceAffiliationIds = this.getUserData((int)0).mAffiliationIds;
        for (String id2 : userAffiliationIds) {
            if (!deviceAffiliationIds.contains(id2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areAllUsersAffiliatedWithDeviceLocked() {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            List<UserInfo> userInfos = this.mUserManager.getUsers(true);
            for (int i = 0; i < userInfos.size(); ++i) {
                int userId = userInfos.get((int)i).id;
                if (this.isUserAffiliatedWithDeviceLocked(userId)) continue;
                Slog.d(LOG_TAG, "User id " + userId + " not affiliated.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecurityLoggingEnabled(ComponentName admin, boolean enabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
            if (enabled == this.mInjector.securityLogGetLoggingEnabledProperty()) {
                return;
            }
            this.mInjector.securityLogSetLoggingEnabledProperty(enabled);
            if (enabled) {
                this.mSecurityLogMonitor.start();
                this.maybePauseDeviceWideLoggingLocked();
            } else {
                this.mSecurityLogMonitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecurityLoggingEnabled(ComponentName admin) {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.isCallerWithSystemUid()) {
                Preconditions.checkNotNull(admin);
                this.getActiveAdminForCallerLocked(admin, -2);
            }
            return this.mInjector.securityLogGetLoggingEnabledProperty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSecurityLogRetrievalTime() {
        Object object = this.getLockObject();
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            DevicePolicyData policyData = this.getUserData(0);
            if (currentTime > policyData.mLastSecurityLogRetrievalTime) {
                policyData.mLastSecurityLogRetrievalTime = currentTime;
                this.saveSettingsLocked(0);
            }
        }
    }

    @Override
    public ParceledListSlice<SecurityLog.SecurityEvent> retrievePreRebootSecurityLogs(ComponentName admin) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerAndAllUsersAffiliated(admin);
        if (!this.mContext.getResources().getBoolean(17957041) || !this.mInjector.securityLogGetLoggingEnabledProperty()) {
            return null;
        }
        this.recordSecurityLogRetrievalTime();
        ArrayList<SecurityLog.SecurityEvent> output = new ArrayList<SecurityLog.SecurityEvent>();
        try {
            SecurityLog.readPreviousEvents(output);
            return new ParceledListSlice<SecurityLog.SecurityEvent>(output);
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "Fail to read previous events", e);
            return new ParceledListSlice<SecurityLog.SecurityEvent>(Collections.emptyList());
        }
    }

    @Override
    public ParceledListSlice<SecurityLog.SecurityEvent> retrieveSecurityLogs(ComponentName admin) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerAndAllUsersAffiliated(admin);
        if (!this.mInjector.securityLogGetLoggingEnabledProperty()) {
            return null;
        }
        this.recordSecurityLogRetrievalTime();
        List<SecurityLog.SecurityEvent> logs = this.mSecurityLogMonitor.retrieveLogs();
        return logs != null ? new ParceledListSlice<SecurityLog.SecurityEvent>(logs) : null;
    }

    @Override
    public long forceSecurityLogs() {
        this.enforceShell("forceSecurityLogs");
        if (!this.mInjector.securityLogGetLoggingEnabledProperty()) {
            throw new IllegalStateException("logging is not available");
        }
        return this.mSecurityLogMonitor.forceLogs();
    }

    private void enforceCanManageDeviceAdmin() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
    }

    private void enforceCanManageProfileAndDeviceOwners() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS", null);
    }

    private void enforceCallerSystemUserHandle() {
        int callingUid = this.mInjector.binderGetCallingUid();
        int userId = UserHandle.getUserId(callingUid);
        if (userId != 0) {
            throw new SecurityException("Caller has to be in user 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUninstallInQueue(String packageName) {
        this.enforceCanManageDeviceAdmin();
        int userId = this.mInjector.userHandleGetCallingUserId();
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        Object object = this.getLockObject();
        synchronized (object) {
            return this.mPackagesToRemove.contains(packageUserPair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallPackageWithActiveAdmins(final String packageName) {
        this.enforceCanManageDeviceAdmin();
        Preconditions.checkArgument(!TextUtils.isEmpty(packageName));
        final int userId = this.mInjector.userHandleGetCallingUserId();
        this.enforceUserUnlocked(userId);
        ComponentName profileOwner = this.getProfileOwner(userId);
        if (profileOwner != null && packageName.equals(profileOwner.getPackageName())) {
            throw new IllegalArgumentException("Cannot uninstall a package with a profile owner");
        }
        ComponentName deviceOwner = this.getDeviceOwnerComponent(false);
        if (this.getDeviceOwnerUserId() == userId && deviceOwner != null && packageName.equals(deviceOwner.getPackageName())) {
            throw new IllegalArgumentException("Cannot uninstall a package with a device owner");
        }
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPackagesToRemove.add(packageUserPair);
        }
        List<ComponentName> allActiveAdmins = this.getActiveAdmins(userId);
        final ArrayList<ComponentName> packageActiveAdmins = new ArrayList<ComponentName>();
        if (allActiveAdmins != null) {
            for (ComponentName activeAdmin : allActiveAdmins) {
                if (!packageName.equals(activeAdmin.getPackageName())) continue;
                packageActiveAdmins.add(activeAdmin);
                this.removeActiveAdmin(activeAdmin, userId);
            }
        }
        if (packageActiveAdmins.size() == 0) {
            this.startUninstallIntent(packageName, userId);
        } else {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    for (ComponentName activeAdmin : packageActiveAdmins) {
                        DevicePolicyManagerService.this.removeAdminArtifacts(activeAdmin, userId);
                    }
                    DevicePolicyManagerService.this.startUninstallIntent(packageName, userId);
                }
            }, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceProvisioned() {
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            return this.getUserDataUnchecked((int)0).mUserSetupComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentUserDemo() {
        if (UserManager.isDeviceInDemoMode(this.mContext)) {
            int userId = this.mInjector.userHandleGetCallingUserId();
            long callingIdentity = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mUserManager.getUserInfo(userId).isDemo();
                return bl;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(callingIdentity);
            }
        }
        return false;
    }

    private void removePackageIfRequired(String packageName, int userId) {
        if (!this.packageHasActiveAdmins(packageName, userId)) {
            this.startUninstallIntent(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUninstallIntent(String packageName, int userId) {
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        Object object = this.getLockObject();
        synchronized (object) {
            if (!this.mPackagesToRemove.contains(packageUserPair)) {
                return;
            }
            this.mPackagesToRemove.remove(packageUserPair);
        }
        try {
            if (this.mInjector.getIPackageManager().getPackageInfo(packageName, 0, userId) == null) {
                return;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Failure talking to PackageManager while getting package info");
        }
        try {
            this.mInjector.getIActivityManager().forceStopPackage(packageName, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Failure talking to ActivityManager while force stopping package");
        }
        Uri packageURI = Uri.parse("package:" + packageName);
        Intent uninstallIntent = new Intent("android.intent.action.UNINSTALL_PACKAGE", packageURI);
        uninstallIntent.setFlags(0x10000000);
        this.mContext.startActivityAsUser(uninstallIntent, UserHandle.of(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAdminArtifacts(ComponentName adminReceiver, int userHandle) {
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            boolean doProxyCleanup = admin.info.usesPolicy(5);
            policy.mAdminList.remove(admin);
            policy.mAdminMap.remove(adminReceiver);
            this.validatePasswordOwnerLocked(policy);
            if (doProxyCleanup) {
                this.resetGlobalProxyLocked(policy);
            }
            this.pushActiveAdminPackagesLocked(userHandle);
            this.pushMeteredDisabledPackagesLocked(userHandle);
            this.saveSettingsLocked(userHandle);
            this.updateMaximumTimeToLockLocked(userHandle);
            policy.mRemovingAdmins.remove(adminReceiver);
            Slog.i(LOG_TAG, "Device admin " + adminReceiver + " removed from user " + userHandle);
        }
        this.pushUserRestrictions(userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceProvisioningConfigApplied() {
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(0);
            policy.mDeviceProvisioningConfigApplied = true;
            this.saveSettingsLocked(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceProvisioningConfigApplied() {
        this.enforceManageUsers();
        Object object = this.getLockObject();
        synchronized (object) {
            DevicePolicyData policy = this.getUserData(0);
            return policy.mDeviceProvisioningConfigApplied;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateUserSetupComplete() {
        this.enforceCanManageProfileAndDeviceOwners();
        this.enforceCallerSystemUserHandle();
        if (!this.mInjector.isBuildDebuggable()) {
            return;
        }
        boolean userId = false;
        boolean isUserCompleted = this.mInjector.settingsSecureGetIntForUser("user_setup_complete", 0, 0) != 0;
        DevicePolicyData policy = this.getUserData(0);
        policy.mUserSetupComplete = isUserCompleted;
        Object object = this.getLockObject();
        synchronized (object) {
            this.saveSettingsLocked(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupServiceEnabled(ComponentName admin, boolean enabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -2);
            if (!enabled) {
                activeAdmin.mandatoryBackupTransport = null;
                this.saveSettingsLocked(0);
            }
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            IBackupManager ibm = this.mInjector.getIBackupManager();
            if (ibm != null) {
                ibm.setBackupServiceActive(0, enabled);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed " + (enabled ? "" : "de") + "activating backup service.", e);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean isBackupServiceEnabled(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        if (!this.mHasFeature) {
            return true;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.getActiveAdminForCallerLocked(admin, -2);
                IBackupManager ibm = this.mInjector.getIBackupManager();
                return ibm != null && ibm.isBackupServiceActive(0);
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Failed requesting backup service state.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMandatoryBackupTransport(final ComponentName admin, final ComponentName backupTransportComponent) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        final int callingUid = this.mInjector.binderGetCallingUid();
        final AtomicBoolean success = new AtomicBoolean(false);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ISelectBackupTransportCallback.Stub selectBackupTransportCallbackInternal = new ISelectBackupTransportCallback.Stub(){

            @Override
            public void onSuccess(String transportName) {
                DevicePolicyManagerService.this.saveMandatoryBackupTransport(admin, callingUid, backupTransportComponent);
                success.set(true);
                countDownLatch.countDown();
            }

            @Override
            public void onFailure(int reason) {
                countDownLatch.countDown();
            }
        };
        long identity = this.mInjector.binderClearCallingIdentity();
        try {
            IBackupManager ibm = this.mInjector.getIBackupManager();
            if (ibm != null && backupTransportComponent != null) {
                if (!ibm.isBackupServiceActive(0)) {
                    ibm.setBackupServiceActive(0, true);
                }
                ibm.selectBackupTransportAsync(backupTransportComponent, selectBackupTransportCallbackInternal);
                countDownLatch.await();
                if (success.get()) {
                    ibm.setBackupEnabled(true);
                }
            } else if (backupTransportComponent == null) {
                this.saveMandatoryBackupTransport(admin, callingUid, backupTransportComponent);
                success.set(true);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to set mandatory backup transport.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to set mandatory backup transport.", e);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(identity);
        }
        return success.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMandatoryBackupTransport(ComponentName admin, int callingUid, ComponentName backupTransportComponent) {
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getActiveAdminWithPolicyForUidLocked(admin, -2, callingUid);
            if (!Objects.equals(backupTransportComponent, activeAdmin.mandatoryBackupTransport)) {
                activeAdmin.mandatoryBackupTransport = backupTransportComponent;
                this.saveSettingsLocked(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getMandatoryBackupTransport() {
        if (!this.mHasFeature) {
            return null;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin activeAdmin = this.getDeviceOwnerAdminLocked();
            return activeAdmin == null ? null : activeAdmin.mandatoryBackupTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindDeviceAdminServiceAsUser(ComponentName admin, IApplicationThread caller, IBinder activtiyToken, Intent serviceIntent, IServiceConnection connection, int flags, int targetUserId) {
        String targetPackage;
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(admin);
        Preconditions.checkNotNull(caller);
        Preconditions.checkNotNull(serviceIntent);
        Preconditions.checkArgument(serviceIntent.getComponent() != null || serviceIntent.getPackage() != null, "Service intent must be explicit (with a package name or component): " + serviceIntent);
        Preconditions.checkNotNull(connection);
        Preconditions.checkArgument(this.mInjector.userHandleGetCallingUserId() != targetUserId, "target user id must be different from the calling user id");
        if (!this.getBindDeviceAdminTargetUsers(admin).contains(UserHandle.of(targetUserId))) {
            throw new SecurityException("Not allowed to bind to target user id");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            targetPackage = this.getOwnerPackageNameForUserLocked(targetUserId);
        }
        long callingIdentity = this.mInjector.binderClearCallingIdentity();
        try {
            Intent sanitizedIntent = this.createCrossUserServiceIntent(serviceIntent, targetPackage, targetUserId);
            if (sanitizedIntent == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mInjector.getIActivityManager().bindService(caller, activtiyToken, serviceIntent, serviceIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), connection, flags, this.mContext.getOpPackageName(), targetUserId) != 0;
            return bl;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(callingIdentity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserHandle> getBindDeviceAdminTargetUsers(ComponentName admin) {
        if (!this.mHasFeature) {
            return Collections.emptyList();
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            ArrayList<UserHandle> arrayList;
            this.getActiveAdminForCallerLocked(admin, -1);
            int callingUserId = this.mInjector.userHandleGetCallingUserId();
            long callingIdentity = this.mInjector.binderClearCallingIdentity();
            try {
                ArrayList<UserHandle> targetUsers = new ArrayList<UserHandle>();
                if (!this.isDeviceOwner(admin, callingUserId)) {
                    if (this.canUserBindToDeviceOwnerLocked(callingUserId)) {
                        targetUsers.add(UserHandle.of(this.mOwners.getDeviceOwnerUserId()));
                    }
                } else {
                    List<UserInfo> userInfos = this.mUserManager.getUsers(true);
                    for (int i = 0; i < userInfos.size(); ++i) {
                        int userId = userInfos.get((int)i).id;
                        if (userId == callingUserId || !this.canUserBindToDeviceOwnerLocked(userId)) continue;
                        targetUsers.add(UserHandle.of(userId));
                    }
                }
                arrayList = targetUsers;
                this.mInjector.binderRestoreCallingIdentity(callingIdentity);
            }
            catch (Throwable throwable) {
                this.mInjector.binderRestoreCallingIdentity(callingIdentity);
                throw throwable;
            }
            return arrayList;
        }
    }

    private boolean canUserBindToDeviceOwnerLocked(int userId) {
        if (!this.mOwners.hasDeviceOwner() || userId == this.mOwners.getDeviceOwnerUserId()) {
            return false;
        }
        if (!this.mOwners.hasProfileOwner(userId) || !TextUtils.equals(this.mOwners.getDeviceOwnerPackageName(), this.mOwners.getProfileOwnerPackage(userId))) {
            return false;
        }
        return this.isUserAffiliatedWithDeviceLocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasIncompatibleAccountsOrNonAdbNoLock(int userId, ComponentName owner) {
        if (!this.isAdb()) {
            return true;
        }
        this.wtfIfInLock();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            AccountManager am = AccountManager.get(this.mContext);
            Account[] accounts = am.getAccountsAsUser(userId);
            if (accounts.length == 0) {
                boolean bl = false;
                return bl;
            }
            Object object = this.getLockObject();
            synchronized (object) {
                if (owner == null || !this.isAdminTestOnlyLocked(owner, userId)) {
                    Log.w(LOG_TAG, "Non test-only owner can't be installed with existing accounts.");
                    boolean bl = true;
                    return bl;
                }
            }
            String[] feature_allow = new String[]{"android.account.DEVICE_OR_PROFILE_OWNER_ALLOWED"};
            String[] feature_disallow = new String[]{"android.account.DEVICE_OR_PROFILE_OWNER_DISALLOWED"};
            boolean compatible = true;
            for (Account account : accounts) {
                if (this.hasAccountFeatures(am, account, feature_disallow)) {
                    Log.e(LOG_TAG, account + " has " + feature_disallow[0]);
                    compatible = false;
                    break;
                }
                if (this.hasAccountFeatures(am, account, feature_allow)) continue;
                Log.e(LOG_TAG, account + " doesn't have " + feature_allow[0]);
                compatible = false;
                break;
            }
            if (compatible) {
                Log.w(LOG_TAG, "All accounts are compatible");
            } else {
                Log.e(LOG_TAG, "Found incompatible accounts");
            }
            boolean bl = !compatible;
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private boolean hasAccountFeatures(AccountManager am, Account account, String[] features) {
        try {
            return am.hasFeatures(account, features, null, null).getResult();
        }
        catch (Exception e) {
            Log.w(LOG_TAG, "Failed to get account feature", e);
            return false;
        }
    }

    private boolean isAdb() {
        int callingUid = this.mInjector.binderGetCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkLoggingEnabled(ComponentName admin, boolean enabled) {
        if (!this.mHasFeature) {
            return;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            Preconditions.checkNotNull(admin);
            this.getActiveAdminForCallerLocked(admin, -2);
            if (enabled == this.isNetworkLoggingEnabledInternalLocked()) {
                return;
            }
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            deviceOwner.isNetworkLoggingEnabled = enabled;
            if (!enabled) {
                deviceOwner.numNetworkLoggingNotifications = 0;
                deviceOwner.lastNetworkLoggingNotificationTimeMs = 0L;
            }
            this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            this.setNetworkLoggingActiveInternal(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNetworkLoggingActiveInternal(boolean active) {
        Object object = this.getLockObject();
        synchronized (object) {
            long callingIdentity = this.mInjector.binderClearCallingIdentity();
            try {
                if (active) {
                    this.mNetworkLogger = new NetworkLogger(this, this.mInjector.getPackageManagerInternal());
                    if (!this.mNetworkLogger.startNetworkLogging()) {
                        this.mNetworkLogger = null;
                        Slog.wtf(LOG_TAG, "Network logging could not be started due to the logging service not being available yet.");
                    }
                    this.maybePauseDeviceWideLoggingLocked();
                    this.sendNetworkLoggingNotificationLocked();
                } else {
                    if (this.mNetworkLogger != null && !this.mNetworkLogger.stopNetworkLogging()) {
                        Slog.wtf(LOG_TAG, "Network logging could not be stopped due to the logging service not being available yet.");
                    }
                    this.mNetworkLogger = null;
                    this.mInjector.getNotificationManager().cancel(1002);
                }
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(callingIdentity);
            }
        }
    }

    private void maybePauseDeviceWideLoggingLocked() {
        if (!this.areAllUsersAffiliatedWithDeviceLocked()) {
            Slog.i(LOG_TAG, "There are unaffiliated users, security and network logging will be paused if enabled.");
            this.mSecurityLogMonitor.pause();
            if (this.mNetworkLogger != null) {
                this.mNetworkLogger.pause();
            }
        }
    }

    private void maybeResumeDeviceWideLoggingLocked() {
        if (this.areAllUsersAffiliatedWithDeviceLocked()) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.mSecurityLogMonitor.resume();
                if (this.mNetworkLogger != null) {
                    this.mNetworkLogger.resume();
                }
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    private void discardDeviceWideLogsLocked() {
        this.mSecurityLogMonitor.discardLogs();
        if (this.mNetworkLogger != null) {
            this.mNetworkLogger.discardLogs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNetworkLoggingEnabled(ComponentName admin) {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.enforceDeviceOwnerOrManageUsers();
            return this.isNetworkLoggingEnabledInternalLocked();
        }
    }

    private boolean isNetworkLoggingEnabledInternalLocked() {
        ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
        return deviceOwner != null && deviceOwner.isNetworkLoggingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkEvent> retrieveNetworkLogs(ComponentName admin, long batchToken) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerAndAllUsersAffiliated(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mNetworkLogger == null || !this.isNetworkLoggingEnabledInternalLocked()) {
                return null;
            }
            long currentTime = System.currentTimeMillis();
            DevicePolicyData policyData = this.getUserData(0);
            if (currentTime > policyData.mLastNetworkLogsRetrievalTime) {
                policyData.mLastNetworkLogsRetrievalTime = currentTime;
                this.saveSettingsLocked(0);
            }
            return this.mNetworkLogger.retrieveLogs(batchToken);
        }
    }

    private void sendNetworkLoggingNotificationLocked() {
        ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
        if (deviceOwner == null || !deviceOwner.isNetworkLoggingEnabled) {
            return;
        }
        if (deviceOwner.numNetworkLoggingNotifications >= 2) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - deviceOwner.lastNetworkLoggingNotificationTimeMs < MS_PER_DAY) {
            return;
        }
        ++deviceOwner.numNetworkLoggingNotifications;
        deviceOwner.lastNetworkLoggingNotificationTimeMs = deviceOwner.numNetworkLoggingNotifications >= 2 ? 0L : now;
        Intent intent = new Intent("android.app.action.SHOW_DEVICE_MONITORING_DIALOG");
        intent.setPackage("com.android.systemui");
        PendingIntent pendingIntent = PendingIntent.getBroadcastAsUser(this.mContext, 0, intent, 0, UserHandle.CURRENT);
        Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.DEVICE_ADMIN).setSmallIcon(17302386).setContentTitle(this.mContext.getString(17040335)).setContentText(this.mContext.getString(17040334)).setTicker(this.mContext.getString(17040335)).setShowWhen(true).setContentIntent(pendingIntent).setStyle(new Notification.BigTextStyle().bigText(this.mContext.getString(17040334))).build();
        this.mInjector.getNotificationManager().notify(1002, notification);
        this.saveSettingsLocked(this.mOwners.getDeviceOwnerUserId());
    }

    private String getOwnerPackageNameForUserLocked(int userId) {
        return this.mOwners.getDeviceOwnerUserId() == userId ? this.mOwners.getDeviceOwnerPackageName() : this.mOwners.getProfileOwnerPackage(userId);
    }

    private Intent createCrossUserServiceIntent(Intent rawIntent, String expectedPackageName, int targetUserId) throws RemoteException, SecurityException {
        ResolveInfo info = this.mIPackageManager.resolveService(rawIntent, rawIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 0, targetUserId);
        if (info == null || info.serviceInfo == null) {
            Log.e(LOG_TAG, "Fail to look up the service: " + rawIntent + " or user " + targetUserId + " is not running");
            return null;
        }
        if (!expectedPackageName.equals(info.serviceInfo.packageName)) {
            throw new SecurityException("Only allow to bind service in " + expectedPackageName);
        }
        if (info.serviceInfo.exported && !"android.permission.BIND_DEVICE_ADMIN".equals(info.serviceInfo.permission)) {
            throw new SecurityException("Service must be protected by BIND_DEVICE_ADMIN permission");
        }
        rawIntent.setComponent(info.serviceInfo.getComponentName());
        return rawIntent;
    }

    @Override
    public long getLastSecurityLogRetrievalTime() {
        this.enforceDeviceOwnerOrManageUsers();
        return this.getUserData((int)0).mLastSecurityLogRetrievalTime;
    }

    @Override
    public long getLastBugReportRequestTime() {
        this.enforceDeviceOwnerOrManageUsers();
        return this.getUserData((int)0).mLastBugReportRequestTime;
    }

    @Override
    public long getLastNetworkLogRetrievalTime() {
        this.enforceDeviceOwnerOrManageUsers();
        return this.getUserData((int)0).mLastNetworkLogsRetrievalTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setResetPasswordToken(ComponentName admin, byte[] token) {
        if (!this.mHasFeature) {
            return false;
        }
        if (token == null || token.length < 32) {
            throw new IllegalArgumentException("token must be at least 32-byte long");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            boolean bl;
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (policy.mPasswordTokenHandle != 0L) {
                    this.mLockPatternUtils.removeEscrowToken(policy.mPasswordTokenHandle, userHandle);
                }
                policy.mPasswordTokenHandle = this.mLockPatternUtils.addEscrowToken(token, userHandle);
                this.saveSettingsLocked(userHandle);
                bl = policy.mPasswordTokenHandle != 0L;
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            catch (Throwable throwable) {
                this.mInjector.binderRestoreCallingIdentity(ident);
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearResetPasswordToken(ComponentName admin) {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mPasswordTokenHandle != 0L) {
                boolean bl;
                long ident = this.mInjector.binderClearCallingIdentity();
                try {
                    boolean result = this.mLockPatternUtils.removeEscrowToken(policy.mPasswordTokenHandle, userHandle);
                    policy.mPasswordTokenHandle = 0L;
                    this.saveSettingsLocked(userHandle);
                    bl = result;
                    this.mInjector.binderRestoreCallingIdentity(ident);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    throw throwable;
                }
                return bl;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResetPasswordTokenActive(ComponentName admin) {
        Object object = this.getLockObject();
        synchronized (object) {
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mPasswordTokenHandle != 0L) {
                boolean bl;
                long ident = this.mInjector.binderClearCallingIdentity();
                try {
                    bl = this.mLockPatternUtils.isEscrowTokenActive(policy.mPasswordTokenHandle, userHandle);
                    this.mInjector.binderRestoreCallingIdentity(ident);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    throw throwable;
                }
                return bl;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPasswordWithToken(ComponentName admin, String passwordOrNull, byte[] token, int flags) {
        Preconditions.checkNotNull(token);
        Object object = this.getLockObject();
        synchronized (object) {
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mPasswordTokenHandle != 0L) {
                String password = passwordOrNull != null ? passwordOrNull : "";
                return this.resetPasswordInternal(password, policy.mPasswordTokenHandle, token, flags, this.mInjector.binderGetCallingUid(), userHandle);
            }
            Slog.w(LOG_TAG, "No saved token handle");
        }
        return false;
    }

    @Override
    public boolean isCurrentInputMethodSetByOwner() {
        this.enforceProfileOwnerOrSystemUser();
        return this.getUserData((int)this.mInjector.userHandleGetCallingUserId()).mCurrentInputMethodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringParceledListSlice getOwnerInstalledCaCerts(UserHandle user) {
        int userId = user.getIdentifier();
        this.enforceProfileOwnerOrFullCrossUsersPermission(userId);
        Object object = this.getLockObject();
        synchronized (object) {
            return new StringParceledListSlice((List<String>)new ArrayList<String>(this.getUserData((int)userId).mOwnerInstalledCaCerts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearApplicationUserData(ComponentName admin, String packageName, IPackageDataObserver callback) {
        Preconditions.checkNotNull(admin, "ComponentName is null");
        Preconditions.checkNotNull(packageName, "packageName is null");
        Preconditions.checkNotNull(callback, "callback is null");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(admin, -1);
        }
        int userId = UserHandle.getCallingUserId();
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            ActivityManager.getService().clearApplicationUserData(packageName, false, callback, userId);
        }
        catch (RemoteException remoteException) {
        }
        catch (SecurityException se) {
            Slog.w(LOG_TAG, "Not allowed to clear application user data for package " + packageName, se);
            try {
                callback.onRemoveCompleted(packageName, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogoutEnabled(ComponentName admin, boolean enabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(admin, -2);
            if (deviceOwner.isLogoutEnabled == enabled) {
                return;
            }
            deviceOwner.isLogoutEnabled = enabled;
            this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLogoutEnabled() {
        if (!this.mHasFeature) {
            return false;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            return deviceOwner != null && deviceOwner.isLogoutEnabled;
        }
    }

    @Override
    public List<String> getDisallowedSystemApps(ComponentName admin, int userId, String provisioningAction) throws RemoteException {
        this.enforceCanManageProfileAndDeviceOwners();
        return new ArrayList<String>(this.mOverlayPackagesProvider.getNonRequiredApps(admin, userId, provisioningAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferOwnership(ComponentName admin, ComponentName target, PersistableBundle bundle) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin, "Admin cannot be null.");
        Preconditions.checkNotNull(target, "Target cannot be null.");
        this.enforceProfileOrDeviceOwner(admin);
        if (admin.equals(target)) {
            throw new IllegalArgumentException("Provided administrator and target are the same object.");
        }
        if (admin.getPackageName().equals(target.getPackageName())) {
            throw new IllegalArgumentException("Provided administrator and target have the same package name.");
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyData policy = this.getUserData(callingUserId);
        DeviceAdminInfo incomingDeviceInfo = this.findAdmin(target, callingUserId, true);
        this.checkActiveAdminPrecondition(target, incomingDeviceInfo, policy);
        if (!incomingDeviceInfo.supportsTransferOwnership()) {
            throw new IllegalArgumentException("Provided target does not support ownership transfer.");
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.getLockObject();
            synchronized (object) {
                if (bundle == null) {
                    bundle = new PersistableBundle();
                }
                if (this.isProfileOwner(admin, callingUserId)) {
                    this.prepareTransfer(admin, target, bundle, callingUserId, LOG_TAG_PROFILE_OWNER);
                    this.transferProfileOwnershipLocked(admin, target, callingUserId);
                    this.sendProfileOwnerCommand("android.app.action.TRANSFER_OWNERSHIP_COMPLETE", this.getTransferOwnershipAdminExtras(bundle), callingUserId);
                    this.postTransfer("android.app.action.PROFILE_OWNER_CHANGED", callingUserId);
                    if (this.isUserAffiliatedWithDeviceLocked(callingUserId)) {
                        this.notifyAffiliatedProfileTransferOwnershipComplete(callingUserId);
                    }
                } else if (this.isDeviceOwner(admin, callingUserId)) {
                    this.prepareTransfer(admin, target, bundle, callingUserId, LOG_TAG_DEVICE_OWNER);
                    this.transferDeviceOwnershipLocked(admin, target, callingUserId);
                    this.sendDeviceOwnerCommand("android.app.action.TRANSFER_OWNERSHIP_COMPLETE", this.getTransferOwnershipAdminExtras(bundle));
                    this.postTransfer("android.app.action.DEVICE_OWNER_CHANGED", callingUserId);
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    private void prepareTransfer(ComponentName admin, ComponentName target, PersistableBundle bundle, int callingUserId, String adminType) {
        this.saveTransferOwnershipBundleLocked(bundle, callingUserId);
        this.mTransferOwnershipMetadataManager.saveMetadataFile(new TransferOwnershipMetadataManager.Metadata(admin, target, callingUserId, adminType));
    }

    private void postTransfer(String broadcast, int callingUserId) {
        this.deleteTransferOwnershipMetadataFileLocked();
        this.sendOwnerChangedBroadcast(broadcast, callingUserId);
    }

    private void notifyAffiliatedProfileTransferOwnershipComplete(int callingUserId) {
        Bundle extras = new Bundle();
        extras.putParcelable("android.intent.extra.USER", UserHandle.of(callingUserId));
        this.sendDeviceOwnerCommand("android.app.action.AFFILIATED_PROFILE_TRANSFER_OWNERSHIP_COMPLETE", extras);
    }

    private void transferProfileOwnershipLocked(ComponentName admin, ComponentName target, int profileOwnerUserId) {
        this.transferActiveAdminUncheckedLocked(target, admin, profileOwnerUserId);
        this.mOwners.transferProfileOwner(target, profileOwnerUserId);
        Slog.i(LOG_TAG, "Profile owner set: " + target + " on user " + profileOwnerUserId);
        this.mOwners.writeProfileOwner(profileOwnerUserId);
        this.mDeviceAdminServiceController.startServiceForOwner(target.getPackageName(), profileOwnerUserId, "transfer-profile-owner");
    }

    private void transferDeviceOwnershipLocked(ComponentName admin, ComponentName target, int userId) {
        this.transferActiveAdminUncheckedLocked(target, admin, userId);
        this.mOwners.transferDeviceOwnership(target);
        Slog.i(LOG_TAG, "Device owner set: " + target + " on user " + userId);
        this.mOwners.writeDeviceOwner();
        this.mDeviceAdminServiceController.startServiceForOwner(target.getPackageName(), userId, "transfer-device-owner");
    }

    private Bundle getTransferOwnershipAdminExtras(PersistableBundle bundle) {
        Bundle extras = new Bundle();
        if (bundle != null) {
            extras.putParcelable("android.app.extra.TRANSFER_OWNERSHIP_ADMIN_EXTRAS_BUNDLE", bundle);
        }
        return extras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartUserSessionMessage(ComponentName admin, CharSequence startUserSessionMessage) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin);
        String startUserSessionMessageString = startUserSessionMessage != null ? startUserSessionMessage.toString() : null;
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(admin, -2);
            if (TextUtils.equals(deviceOwner.startUserSessionMessage, startUserSessionMessage)) {
                return;
            }
            deviceOwner.startUserSessionMessage = startUserSessionMessageString;
            this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
        }
        this.mInjector.getActivityManagerInternal().setSwitchingFromSystemUserMessage(startUserSessionMessageString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndUserSessionMessage(ComponentName admin, CharSequence endUserSessionMessage) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin);
        String endUserSessionMessageString = endUserSessionMessage != null ? endUserSessionMessage.toString() : null;
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(admin, -2);
            if (TextUtils.equals(deviceOwner.endUserSessionMessage, endUserSessionMessage)) {
                return;
            }
            deviceOwner.endUserSessionMessage = endUserSessionMessageString;
            this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
        }
        this.mInjector.getActivityManagerInternal().setSwitchingToSystemUserMessage(endUserSessionMessageString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStartUserSessionMessage(ComponentName admin) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(admin, -2);
            return deviceOwner.startUserSessionMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEndUserSessionMessage(ComponentName admin) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(admin);
        Object object = this.getLockObject();
        synchronized (object) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(admin, -2);
            return deviceOwner.endUserSessionMessage;
        }
    }

    private void deleteTransferOwnershipMetadataFileLocked() {
        this.mTransferOwnershipMetadataManager.deleteMetadataFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistableBundle getTransferOwnershipBundle() {
        Object object = this.getLockObject();
        synchronized (object) {
            PersistableBundle persistableBundle;
            int callingUserId = this.mInjector.userHandleGetCallingUserId();
            this.getActiveAdminForCallerLocked(null, -1);
            File bundleFile = new File(this.mInjector.environmentGetUserSystemDirectory(callingUserId), TRANSFER_OWNERSHIP_PARAMETERS_XML);
            if (!bundleFile.exists()) {
                return null;
            }
            FileInputStream stream = new FileInputStream(bundleFile);
            Throwable throwable = null;
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, null);
                parser.next();
                persistableBundle = PersistableBundle.restoreFromXml(parser);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        DevicePolicyManagerService.$closeResource(throwable, stream);
                        throw throwable3;
                    }
                }
                catch (IOException | IllegalArgumentException | XmlPullParserException e) {
                    Slog.e(LOG_TAG, "Caught exception while trying to load the owner transfer parameters from file " + bundleFile, e);
                    return null;
                }
            }
            DevicePolicyManagerService.$closeResource(throwable, stream);
            return persistableBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addOverrideApn(ComponentName who, ApnSetting apnSetting) {
        Uri resultUri;
        if (!this.mHasFeature) {
            return -1;
        }
        Preconditions.checkNotNull(who, "ComponentName is null in addOverrideApn");
        Preconditions.checkNotNull(apnSetting, "ApnSetting is null in addOverrideApn");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int operatedId = -1;
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            resultUri = this.mContext.getContentResolver().insert(Telephony.Carriers.DPC_URI, apnSetting.toContentValues());
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        if (resultUri != null) {
            try {
                operatedId = Integer.parseInt(resultUri.getLastPathSegment());
            }
            catch (NumberFormatException e) {
                Slog.e(LOG_TAG, "Failed to parse inserted override APN id.", e);
            }
        }
        return operatedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateOverrideApn(ComponentName who, int apnId, ApnSetting apnSetting) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null in updateOverrideApn");
        Preconditions.checkNotNull(apnSetting, "ApnSetting is null in updateOverrideApn");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        if (apnId < 0) {
            return false;
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mContext.getContentResolver().update(Uri.withAppendedPath(Telephony.Carriers.DPC_URI, Integer.toString(apnId)), apnSetting.toContentValues(), null, null) > 0;
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOverrideApn(ComponentName who, int apnId) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null in removeOverrideApn");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        return this.removeOverrideApnUnchecked(apnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeOverrideApnUnchecked(int apnId) {
        if (apnId < 0) {
            return false;
        }
        int numDeleted = 0;
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            numDeleted = this.mContext.getContentResolver().delete(Uri.withAppendedPath(Telephony.Carriers.DPC_URI, Integer.toString(apnId)), null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return numDeleted > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApnSetting> getOverrideApns(ComponentName who) {
        if (!this.mHasFeature) {
            return Collections.emptyList();
        }
        Preconditions.checkNotNull(who, "ComponentName is null in getOverrideApns");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        return this.getOverrideApnsUnchecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApnSetting> getOverrideApnsUnchecked() {
        Cursor cursor;
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            cursor = this.mContext.getContentResolver().query(Telephony.Carriers.DPC_URI, null, null, null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        if (cursor == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                ApnSetting apn = ApnSetting.makeApnSetting(cursor);
                apnList.add(apn);
            }
            ArrayList<ApnSetting> arrayList = apnList;
            return arrayList;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverrideApnsEnabled(ComponentName who, boolean enabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null in setOverrideApnEnabled");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        this.setOverrideApnsEnabledUnchecked(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOverrideApnsEnabledUnchecked(boolean enabled) {
        ContentValues value = new ContentValues();
        value.put("enforced", enabled);
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mContext.getContentResolver().update(Telephony.Carriers.ENFORCE_MANAGED_URI, value, null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOverrideApnEnabled(ComponentName who) {
        Cursor enforceCursor;
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null in isOverrideApnEnabled");
        Object object = this.getLockObject();
        synchronized (object) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            enforceCursor = this.mContext.getContentResolver().query(Telephony.Carriers.ENFORCE_MANAGED_URI, null, null, null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        if (enforceCursor == null) {
            return false;
        }
        try {
            if (enforceCursor.moveToFirst()) {
                boolean bl = enforceCursor.getInt(enforceCursor.getColumnIndex("enforced")) == 1;
                return bl;
            }
        }
        catch (IllegalArgumentException e) {
            Slog.e(LOG_TAG, "Cursor returned from ENFORCE_MANAGED_URI doesn't contain correct info.", e);
        }
        finally {
            enforceCursor.close();
        }
        return false;
    }

    @VisibleForTesting
    void saveTransferOwnershipBundleLocked(PersistableBundle bundle, int userId) {
        File parametersFile = new File(this.mInjector.environmentGetUserSystemDirectory(userId), TRANSFER_OWNERSHIP_PARAMETERS_XML);
        AtomicFile atomicFile = new AtomicFile(parametersFile);
        FileOutputStream stream = null;
        try {
            stream = atomicFile.startWrite();
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(stream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_TRANSFER_OWNERSHIP_BUNDLE);
            bundle.saveToXml(serializer);
            serializer.endTag(null, TAG_TRANSFER_OWNERSHIP_BUNDLE);
            serializer.endDocument();
            atomicFile.finishWrite(stream);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(LOG_TAG, "Caught exception while trying to save the owner transfer parameters to file " + parametersFile, e);
            parametersFile.delete();
            atomicFile.failWrite(stream);
        }
    }

    void deleteTransferOwnershipBundleLocked(int userId) {
        File parametersFile = new File(this.mInjector.environmentGetUserSystemDirectory(userId), TRANSFER_OWNERSHIP_PARAMETERS_XML);
        parametersFile.delete();
    }

    private void maybeLogPasswordComplexitySet(ComponentName who, int userId, boolean parent, PasswordMetrics metrics) {
        if (SecurityLog.isLoggingEnabled()) {
            int affectedUserId = parent ? this.getProfileParentId(userId) : userId;
            SecurityLog.writeEvent(210017, who.getPackageName(), userId, affectedUserId, metrics.length, metrics.quality, metrics.letters, metrics.nonLetter, metrics.numeric, metrics.upperCase, metrics.lowerCase, metrics.symbols);
        }
    }

    private static String getManagedProvisioningPackage(Context context) {
        return context.getResources().getString(17039695);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        SECURE_SETTINGS_WHITELIST.add("default_input_method");
        SECURE_SETTINGS_WHITELIST.add("skip_first_use_hints");
        SECURE_SETTINGS_WHITELIST.add("install_non_market_apps");
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST = new ArraySet<String>();
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.addAll(SECURE_SETTINGS_WHITELIST);
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.add("location_mode");
        GLOBAL_SETTINGS_WHITELIST = new ArraySet<String>();
        GLOBAL_SETTINGS_WHITELIST.add("adb_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time_zone");
        GLOBAL_SETTINGS_WHITELIST.add("data_roaming");
        GLOBAL_SETTINGS_WHITELIST.add("usb_mass_storage_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_sleep_policy");
        GLOBAL_SETTINGS_WHITELIST.add("stay_on_while_plugged_in");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_device_owner_configs_lockdown");
        GLOBAL_SETTINGS_DEPRECATED = new ArraySet<String>();
        GLOBAL_SETTINGS_DEPRECATED.add("bluetooth_on");
        GLOBAL_SETTINGS_DEPRECATED.add("development_settings_enabled");
        GLOBAL_SETTINGS_DEPRECATED.add("mode_ringer");
        GLOBAL_SETTINGS_DEPRECATED.add("network_preference");
        GLOBAL_SETTINGS_DEPRECATED.add("wifi_on");
        SYSTEM_SETTINGS_WHITELIST = new ArraySet<String>();
        SYSTEM_SETTINGS_WHITELIST.add("screen_brightness");
        SYSTEM_SETTINGS_WHITELIST.add("screen_brightness_mode");
        SYSTEM_SETTINGS_WHITELIST.add("screen_off_timeout");
        MINIMUM_STRONG_AUTH_TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
        ENABLE_LOCK_GUARD = Build.IS_ENG || SystemProperties.getInt("debug.dpm.lock_guard", 0) == 1;
    }

    @VisibleForTesting
    final class LocalService
    extends DevicePolicyManagerInternal {
        private List<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> mWidgetProviderListeners;

        LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getCrossProfileWidgetProviders(int profileId) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                if (DevicePolicyManagerService.this.mOwners == null) {
                    return Collections.emptyList();
                }
                ComponentName ownerComponent = DevicePolicyManagerService.this.mOwners.getProfileOwnerComponent(profileId);
                if (ownerComponent == null) {
                    return Collections.emptyList();
                }
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserDataUnchecked(profileId);
                ActiveAdmin admin = policy.mAdminMap.get(ownerComponent);
                if (admin == null || admin.crossProfileWidgetProviders == null || admin.crossProfileWidgetProviders.isEmpty()) {
                    return Collections.emptyList();
                }
                return admin.crossProfileWidgetProviders;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOnCrossProfileWidgetProvidersChangeListener(DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                if (this.mWidgetProviderListeners == null) {
                    this.mWidgetProviderListeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>();
                }
                if (!this.mWidgetProviderListeners.contains(listener)) {
                    this.mWidgetProviderListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActiveAdminWithPolicy(int uid, int reqPolicy) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                return DevicePolicyManagerService.this.getActiveAdminWithPolicyForUidLocked(null, reqPolicy, uid) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCrossProfileProvidersChanged(int userId, List<String> packages) {
            ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> listeners;
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                listeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>(this.mWidgetProviderListeners);
            }
            int listenerCount = listeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener = (DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener)listeners.get(i);
                listener.onCrossProfileWidgetProvidersChanged(userId, packages);
            }
        }

        @Override
        public Intent createShowAdminSupportIntent(int userId, boolean useDefaultIfNoAdmin) {
            ComponentName profileOwner = DevicePolicyManagerService.this.mOwners.getProfileOwnerComponent(userId);
            if (profileOwner != null) {
                return DevicePolicyManagerService.this.createShowAdminSupportIntent(profileOwner, userId);
            }
            Pair<Integer, ComponentName> deviceOwner = DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserIdAndComponent();
            if (deviceOwner != null && (Integer)deviceOwner.first == userId) {
                return DevicePolicyManagerService.this.createShowAdminSupportIntent((ComponentName)deviceOwner.second, userId);
            }
            if (useDefaultIfNoAdmin) {
                return DevicePolicyManagerService.this.createShowAdminSupportIntent(null, userId);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Intent createUserRestrictionSupportIntent(int userId, String userRestriction) {
            boolean enforcedByPo;
            int source;
            long ident = DevicePolicyManagerService.this.mInjector.binderClearCallingIdentity();
            try {
                source = DevicePolicyManagerService.this.mUserManager.getUserRestrictionSource(userRestriction, UserHandle.of(userId));
            }
            finally {
                DevicePolicyManagerService.this.mInjector.binderRestoreCallingIdentity(ident);
            }
            if ((source & 1) != 0) {
                return null;
            }
            boolean enforcedByDo = (source & 2) != 0;
            boolean bl = enforcedByPo = (source & 4) != 0;
            if (enforcedByDo && enforcedByPo) {
                return DevicePolicyManagerService.this.createShowAdminSupportIntent(null, userId);
            }
            if (enforcedByPo) {
                ComponentName profileOwner = DevicePolicyManagerService.this.mOwners.getProfileOwnerComponent(userId);
                if (profileOwner != null) {
                    return DevicePolicyManagerService.this.createShowAdminSupportIntent(profileOwner, userId);
                }
                return null;
            }
            if (enforcedByDo) {
                Pair<Integer, ComponentName> deviceOwner = DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserIdAndComponent();
                if (deviceOwner != null) {
                    return DevicePolicyManagerService.this.createShowAdminSupportIntent((ComponentName)deviceOwner.second, (Integer)deviceOwner.first);
                }
                return null;
            }
            return null;
        }

        @Override
        public boolean isUserAffiliatedWithDevice(int userId) {
            return DevicePolicyManagerService.this.isUserAffiliatedWithDeviceLocked(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportSeparateProfileChallengeChanged(int userId) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                DevicePolicyManagerService.this.updateMaximumTimeToLockLocked(userId);
            }
        }

        @Override
        public boolean canUserHaveUntrustedCredentialReset(int userId) {
            return DevicePolicyManagerService.this.canUserHaveUntrustedCredentialReset(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getPrintingDisabledReasonForUser(int userId) {
            Object object = DevicePolicyManagerService.this.getLockObject();
            synchronized (object) {
                PackageInfo packageInfo;
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(userId);
                if (!DevicePolicyManagerService.this.mUserManager.hasUserRestriction("no_printing", UserHandle.of(userId))) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "printing is enabled");
                    return null;
                }
                String ownerPackage = DevicePolicyManagerService.this.mOwners.getProfileOwnerPackage(userId);
                if (ownerPackage == null) {
                    ownerPackage = DevicePolicyManagerService.this.mOwners.getDeviceOwnerPackageName();
                }
                PackageManager pm = DevicePolicyManagerService.this.mInjector.getPackageManager();
                try {
                    packageInfo = pm.getPackageInfo(ownerPackage, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "getPackageInfo error", e);
                    return null;
                }
                if (packageInfo == null) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "packageInfo is inexplicably null");
                    return null;
                }
                ApplicationInfo appInfo = packageInfo.applicationInfo;
                if (appInfo == null) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "appInfo is inexplicably null");
                    return null;
                }
                CharSequence appLabel = pm.getApplicationLabel(appInfo);
                if (appLabel == null) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "appLabel is inexplicably null");
                    return null;
                }
                return ((Context)ActivityThread.currentActivityThread().getSystemUiContext()).getResources().getString(17040731, appLabel);
            }
        }

        @Override
        protected DevicePolicyCache getDevicePolicyCache() {
            return DevicePolicyManagerService.this.mPolicyCache;
        }
    }

    private class SetupContentObserver
    extends ContentObserver {
        private final Uri mUserSetupComplete;
        private final Uri mDeviceProvisioned;
        private final Uri mPaired;
        private final Uri mDefaultImeChanged;
        @GuardedBy(value="getLockObject()")
        private Set<Integer> mUserIdsWithPendingChangesByOwner;

        public SetupContentObserver(Handler handler) {
            super(handler);
            this.mUserSetupComplete = Settings.Secure.getUriFor("user_setup_complete");
            this.mDeviceProvisioned = Settings.Global.getUriFor("device_provisioned");
            this.mPaired = Settings.Secure.getUriFor("device_paired");
            this.mDefaultImeChanged = Settings.Secure.getUriFor("default_input_method");
            this.mUserIdsWithPendingChangesByOwner = new ArraySet<Integer>();
        }

        void register() {
            DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mUserSetupComplete, false, this, -1);
            DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mDeviceProvisioned, false, this, -1);
            if (DevicePolicyManagerService.this.mIsWatch) {
                DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mPaired, false, this, -1);
            }
            DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mDefaultImeChanged, false, this, -1);
        }

        @GuardedBy(value="getLockObject()")
        private void addPendingChangeByOwnerLocked(int userId) {
            this.mUserIdsWithPendingChangesByOwner.add(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mUserSetupComplete.equals(uri) || DevicePolicyManagerService.this.mIsWatch && this.mPaired.equals(uri)) {
                DevicePolicyManagerService.this.updateUserSetupCompleteAndPaired();
            } else {
                if (this.mDeviceProvisioned.equals(uri)) {
                    Object object = DevicePolicyManagerService.this.getLockObject();
                    synchronized (object) {
                        DevicePolicyManagerService.this.setDeviceOwnerSystemPropertyLocked();
                    }
                }
                if (this.mDefaultImeChanged.equals(uri)) {
                    Object object = DevicePolicyManagerService.this.getLockObject();
                    synchronized (object) {
                        if (this.mUserIdsWithPendingChangesByOwner.contains(userId)) {
                            this.mUserIdsWithPendingChangesByOwner.remove(userId);
                        } else {
                            DevicePolicyManagerService.this.getUserData((int)userId).mCurrentInputMethodSet = false;
                            DevicePolicyManagerService.this.saveSettingsLocked(userId);
                        }
                    }
                }
            }
        }
    }

    @VisibleForTesting
    static class Injector {
        public final Context mContext;

        Injector(Context context) {
            this.mContext = context;
        }

        public boolean hasFeature() {
            return this.getPackageManager().hasSystemFeature("android.software.device_admin");
        }

        Context createContextAsUser(UserHandle user) throws PackageManager.NameNotFoundException {
            String packageName = this.mContext.getPackageName();
            return this.mContext.createPackageContextAsUser(packageName, 0, user);
        }

        Resources getResources() {
            return this.mContext.getResources();
        }

        Owners newOwners() {
            return new Owners(this.getUserManager(), this.getUserManagerInternal(), this.getPackageManagerInternal());
        }

        UserManager getUserManager() {
            return UserManager.get(this.mContext);
        }

        UserManagerInternal getUserManagerInternal() {
            return LocalServices.getService(UserManagerInternal.class);
        }

        PackageManagerInternal getPackageManagerInternal() {
            return LocalServices.getService(PackageManagerInternal.class);
        }

        UsageStatsManagerInternal getUsageStatsManagerInternal() {
            return LocalServices.getService(UsageStatsManagerInternal.class);
        }

        NetworkPolicyManagerInternal getNetworkPolicyManagerInternal() {
            return LocalServices.getService(NetworkPolicyManagerInternal.class);
        }

        NotificationManager getNotificationManager() {
            return this.mContext.getSystemService(NotificationManager.class);
        }

        IIpConnectivityMetrics getIIpConnectivityMetrics() {
            return IIpConnectivityMetrics.Stub.asInterface(ServiceManager.getService("connmetrics"));
        }

        PackageManager getPackageManager() {
            return this.mContext.getPackageManager();
        }

        PowerManagerInternal getPowerManagerInternal() {
            return LocalServices.getService(PowerManagerInternal.class);
        }

        TelephonyManager getTelephonyManager() {
            return TelephonyManager.from(this.mContext);
        }

        TrustManager getTrustManager() {
            return (TrustManager)this.mContext.getSystemService("trust");
        }

        AlarmManager getAlarmManager() {
            return this.mContext.getSystemService(AlarmManager.class);
        }

        IWindowManager getIWindowManager() {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        }

        IActivityManager getIActivityManager() {
            return ActivityManager.getService();
        }

        ActivityManagerInternal getActivityManagerInternal() {
            return LocalServices.getService(ActivityManagerInternal.class);
        }

        IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        IBackupManager getIBackupManager() {
            return IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }

        IAudioService getIAudioService() {
            return IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        }

        boolean isBuildDebuggable() {
            return Build.IS_DEBUGGABLE;
        }

        LockPatternUtils newLockPatternUtils() {
            return new LockPatternUtils(this.mContext);
        }

        boolean storageManagerIsFileBasedEncryptionEnabled() {
            return StorageManager.isFileEncryptedNativeOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean storageManagerIsNonDefaultBlockEncrypted() {
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = StorageManager.isNonDefaultBlockEncrypted();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        boolean storageManagerIsEncrypted() {
            return StorageManager.isEncrypted();
        }

        boolean storageManagerIsEncryptable() {
            return StorageManager.isEncryptable();
        }

        Looper getMyLooper() {
            return Looper.myLooper();
        }

        WifiManager getWifiManager() {
            return this.mContext.getSystemService(WifiManager.class);
        }

        long binderClearCallingIdentity() {
            return Binder.clearCallingIdentity();
        }

        void binderRestoreCallingIdentity(long token) {
            Binder.restoreCallingIdentity(token);
        }

        int binderGetCallingUid() {
            return Binder.getCallingUid();
        }

        int binderGetCallingPid() {
            return Binder.getCallingPid();
        }

        UserHandle binderGetCallingUserHandle() {
            return Binder.getCallingUserHandle();
        }

        boolean binderIsCallingUidMyUid() {
            return Binder.getCallingUid() == Process.myUid();
        }

        void binderWithCleanCallingIdentity(FunctionalUtils.ThrowingRunnable action) {
            Binder.withCleanCallingIdentity(action);
        }

        final int userHandleGetCallingUserId() {
            return UserHandle.getUserId(this.binderGetCallingUid());
        }

        File environmentGetUserSystemDirectory(int userId) {
            return Environment.getUserSystemDirectory(userId);
        }

        void powerManagerGoToSleep(long time, int reason, int flags) {
            this.mContext.getSystemService(PowerManager.class).goToSleep(time, reason, flags);
        }

        void powerManagerReboot(String reason) {
            this.mContext.getSystemService(PowerManager.class).reboot(reason);
        }

        void recoverySystemRebootWipeUserData(boolean shutdown, String reason, boolean force, boolean wipeEuicc) throws IOException {
            RecoverySystem.rebootWipeUserData(this.mContext, shutdown, reason, force, wipeEuicc);
        }

        boolean systemPropertiesGetBoolean(String key, boolean def) {
            return SystemProperties.getBoolean(key, def);
        }

        long systemPropertiesGetLong(String key, long def) {
            return SystemProperties.getLong(key, def);
        }

        String systemPropertiesGet(String key, String def) {
            return SystemProperties.get(key, def);
        }

        String systemPropertiesGet(String key) {
            return SystemProperties.get(key);
        }

        void systemPropertiesSet(String key, String value) {
            SystemProperties.set(key, value);
        }

        boolean userManagerIsSplitSystemUser() {
            return UserManager.isSplitSystemUser();
        }

        String getDevicePolicyFilePathForSystemUser() {
            return "/data/system/";
        }

        PendingIntent pendingIntentGetActivityAsUser(Context context, int requestCode, Intent intent, int flags, Bundle options, UserHandle user) {
            return PendingIntent.getActivityAsUser(context, requestCode, intent, flags, options, user);
        }

        void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
            this.mContext.getContentResolver().registerContentObserver(uri, notifyForDescendents, observer, userHandle);
        }

        int settingsSecureGetIntForUser(String name, int def, int userHandle) {
            return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, userHandle);
        }

        String settingsSecureGetStringForUser(String name, int userHandle) {
            return Settings.Secure.getStringForUser(this.mContext.getContentResolver(), name, userHandle);
        }

        void settingsSecurePutIntForUser(String name, int value, int userHandle) {
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsSecurePutStringForUser(String name, String value, int userHandle) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsGlobalPutStringForUser(String name, String value, int userHandle) {
            Settings.Global.putStringForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsSecurePutInt(String name, int value) {
            Settings.Secure.putInt(this.mContext.getContentResolver(), name, value);
        }

        int settingsGlobalGetInt(String name, int def) {
            return Settings.Global.getInt(this.mContext.getContentResolver(), name, def);
        }

        String settingsGlobalGetString(String name) {
            return Settings.Global.getString(this.mContext.getContentResolver(), name);
        }

        void settingsGlobalPutInt(String name, int value) {
            Settings.Global.putInt(this.mContext.getContentResolver(), name, value);
        }

        void settingsSecurePutString(String name, String value) {
            Settings.Secure.putString(this.mContext.getContentResolver(), name, value);
        }

        void settingsGlobalPutString(String name, String value) {
            Settings.Global.putString(this.mContext.getContentResolver(), name, value);
        }

        void settingsSystemPutStringForUser(String name, String value, int userId) {
            Settings.System.putStringForUser(this.mContext.getContentResolver(), name, value, userId);
        }

        void securityLogSetLoggingEnabledProperty(boolean enabled) {
            SecurityLog.setLoggingEnabledProperty(enabled);
        }

        boolean securityLogGetLoggingEnabledProperty() {
            return SecurityLog.getLoggingEnabledProperty();
        }

        boolean securityLogIsLoggingEnabled() {
            return SecurityLog.isLoggingEnabled();
        }

        KeyChain.KeyChainConnection keyChainBindAsUser(UserHandle user) throws InterruptedException {
            return KeyChain.bindAsUser(this.mContext, user);
        }

        void postOnSystemServerInitThreadPool(Runnable runnable) {
            SystemServerInitThreadPool.get().submit(runnable, DevicePolicyManagerService.LOG_TAG);
        }

        public TransferOwnershipMetadataManager newTransferOwnershipMetadataManager() {
            return new TransferOwnershipMetadataManager();
        }

        public void runCryptoSelfTest() {
            CryptoTestHelper.runAndLogSelfTest();
        }
    }

    static class ActiveAdmin {
        private static final String TAG_DISABLE_KEYGUARD_FEATURES = "disable-keyguard-features";
        private static final String TAG_TEST_ONLY_ADMIN = "test-only-admin";
        private static final String TAG_DISABLE_CAMERA = "disable-camera";
        private static final String TAG_DISABLE_CALLER_ID = "disable-caller-id";
        private static final String TAG_DISABLE_CONTACTS_SEARCH = "disable-contacts-search";
        private static final String TAG_DISABLE_BLUETOOTH_CONTACT_SHARING = "disable-bt-contacts-sharing";
        private static final String TAG_DISABLE_SCREEN_CAPTURE = "disable-screen-capture";
        private static final String TAG_DISABLE_ACCOUNT_MANAGEMENT = "disable-account-management";
        private static final String TAG_REQUIRE_AUTO_TIME = "require_auto_time";
        private static final String TAG_FORCE_EPHEMERAL_USERS = "force_ephemeral_users";
        private static final String TAG_IS_NETWORK_LOGGING_ENABLED = "is_network_logging_enabled";
        private static final String TAG_ACCOUNT_TYPE = "account-type";
        private static final String TAG_PERMITTED_ACCESSIBILITY_SERVICES = "permitted-accessiblity-services";
        private static final String TAG_ENCRYPTION_REQUESTED = "encryption-requested";
        private static final String TAG_MANAGE_TRUST_AGENT_FEATURES = "manage-trust-agent-features";
        private static final String TAG_TRUST_AGENT_COMPONENT_OPTIONS = "trust-agent-component-options";
        private static final String TAG_TRUST_AGENT_COMPONENT = "component";
        private static final String TAG_PASSWORD_EXPIRATION_DATE = "password-expiration-date";
        private static final String TAG_PASSWORD_EXPIRATION_TIMEOUT = "password-expiration-timeout";
        private static final String TAG_GLOBAL_PROXY_EXCLUSION_LIST = "global-proxy-exclusion-list";
        private static final String TAG_GLOBAL_PROXY_SPEC = "global-proxy-spec";
        private static final String TAG_SPECIFIES_GLOBAL_PROXY = "specifies-global-proxy";
        private static final String TAG_PERMITTED_IMES = "permitted-imes";
        private static final String TAG_PERMITTED_NOTIFICATION_LISTENERS = "permitted-notification-listeners";
        private static final String TAG_MAX_FAILED_PASSWORD_WIPE = "max-failed-password-wipe";
        private static final String TAG_MAX_TIME_TO_UNLOCK = "max-time-to-unlock";
        private static final String TAG_STRONG_AUTH_UNLOCK_TIMEOUT = "strong-auth-unlock-timeout";
        private static final String TAG_MIN_PASSWORD_NONLETTER = "min-password-nonletter";
        private static final String TAG_MIN_PASSWORD_SYMBOLS = "min-password-symbols";
        private static final String TAG_MIN_PASSWORD_NUMERIC = "min-password-numeric";
        private static final String TAG_MIN_PASSWORD_LETTERS = "min-password-letters";
        private static final String TAG_MIN_PASSWORD_LOWERCASE = "min-password-lowercase";
        private static final String TAG_MIN_PASSWORD_UPPERCASE = "min-password-uppercase";
        private static final String TAG_PASSWORD_HISTORY_LENGTH = "password-history-length";
        private static final String TAG_MIN_PASSWORD_LENGTH = "min-password-length";
        private static final String ATTR_VALUE = "value";
        private static final String TAG_PASSWORD_QUALITY = "password-quality";
        private static final String TAG_POLICIES = "policies";
        private static final String TAG_CROSS_PROFILE_WIDGET_PROVIDERS = "cross-profile-widget-providers";
        private static final String TAG_PROVIDER = "provider";
        private static final String TAG_PACKAGE_LIST_ITEM = "item";
        private static final String TAG_KEEP_UNINSTALLED_PACKAGES = "keep-uninstalled-packages";
        private static final String TAG_USER_RESTRICTIONS = "user-restrictions";
        private static final String TAG_DEFAULT_ENABLED_USER_RESTRICTIONS = "default-enabled-user-restrictions";
        private static final String TAG_RESTRICTION = "restriction";
        private static final String TAG_SHORT_SUPPORT_MESSAGE = "short-support-message";
        private static final String TAG_LONG_SUPPORT_MESSAGE = "long-support-message";
        private static final String TAG_PARENT_ADMIN = "parent-admin";
        private static final String TAG_ORGANIZATION_COLOR = "organization-color";
        private static final String TAG_ORGANIZATION_NAME = "organization-name";
        private static final String ATTR_LAST_NETWORK_LOGGING_NOTIFICATION = "last-notification";
        private static final String ATTR_NUM_NETWORK_LOGGING_NOTIFICATIONS = "num-notifications";
        private static final String TAG_IS_LOGOUT_ENABLED = "is_logout_enabled";
        private static final String TAG_MANDATORY_BACKUP_TRANSPORT = "mandatory_backup_transport";
        private static final String TAG_START_USER_SESSION_MESSAGE = "start_user_session_message";
        private static final String TAG_END_USER_SESSION_MESSAGE = "end_user_session_message";
        private static final String TAG_METERED_DATA_DISABLED_PACKAGES = "metered_data_disabled_packages";
        DeviceAdminInfo info;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        PasswordMetrics minimumPasswordMetrics = new PasswordMetrics(0, 0, 1, 0, 0, 1, 1, 0);
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        long strongAuthUnlockTimeout = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        static final int DEF_KEYGUARD_FEATURES_DISABLED = 0;
        int disabledKeyguardFeatures = 0;
        boolean encryptionRequested = false;
        boolean testOnlyAdmin = false;
        boolean disableCamera = false;
        boolean disableCallerId = false;
        boolean disableContactsSearch = false;
        boolean disableBluetoothContactSharing = true;
        boolean disableScreenCapture = false;
        boolean requireAutoTime = false;
        boolean forceEphemeralUsers = false;
        boolean isNetworkLoggingEnabled = false;
        boolean isLogoutEnabled = false;
        static final int DEF_MAXIMUM_NETWORK_LOGGING_NOTIFICATIONS_SHOWN = 2;
        int numNetworkLoggingNotifications = 0;
        long lastNetworkLoggingNotificationTimeMs = 0L;
        ActiveAdmin parentAdmin;
        final boolean isParent;
        List<String> meteredDisabledPackages;
        final Set<String> accountTypesWithManagementDisabled = new ArraySet<String>();
        List<String> permittedAccessiblityServices;
        List<String> permittedInputMethods;
        List<String> permittedNotificationListeners;
        List<String> keepUninstalledPackages;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;
        ArrayMap<String, TrustAgentInfo> trustAgentInfos = new ArrayMap();
        List<String> crossProfileWidgetProviders;
        Bundle userRestrictions;
        final Set<String> defaultEnabledRestrictionsAlreadySet = new ArraySet<String>();
        CharSequence shortSupportMessage = null;
        CharSequence longSupportMessage = null;
        static final int DEF_ORGANIZATION_COLOR = Color.parseColor("#00796B");
        int organizationColor = DEF_ORGANIZATION_COLOR;
        String organizationName = null;
        ComponentName mandatoryBackupTransport = null;
        String startUserSessionMessage = null;
        String endUserSessionMessage = null;

        ActiveAdmin(DeviceAdminInfo _info, boolean parent) {
            this.info = _info;
            this.isParent = parent;
        }

        ActiveAdmin getParentActiveAdmin() {
            Preconditions.checkState(!this.isParent);
            if (this.parentAdmin == null) {
                this.parentAdmin = new ActiveAdmin(this.info, true);
            }
            return this.parentAdmin;
        }

        boolean hasParentActiveAdmin() {
            return this.parentAdmin != null;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        public UserHandle getUserHandle() {
            return UserHandle.of(UserHandle.getUserId(this.info.getActivityInfo().applicationInfo.uid));
        }

        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, TAG_POLICIES);
            this.info.writePoliciesToXml(out);
            out.endTag(null, TAG_POLICIES);
            if (this.minimumPasswordMetrics.quality != 0) {
                out.startTag(null, TAG_PASSWORD_QUALITY);
                out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.quality));
                out.endTag(null, TAG_PASSWORD_QUALITY);
                if (this.minimumPasswordMetrics.length != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LENGTH);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.length));
                    out.endTag(null, TAG_MIN_PASSWORD_LENGTH);
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                    out.attribute(null, "value", Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                }
                if (this.minimumPasswordMetrics.upperCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.upperCase));
                    out.endTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                }
                if (this.minimumPasswordMetrics.lowerCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.lowerCase));
                    out.endTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                }
                if (this.minimumPasswordMetrics.letters != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_LETTERS);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.letters));
                    out.endTag(null, TAG_MIN_PASSWORD_LETTERS);
                }
                if (this.minimumPasswordMetrics.numeric != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_NUMERIC);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.numeric));
                    out.endTag(null, TAG_MIN_PASSWORD_NUMERIC);
                }
                if (this.minimumPasswordMetrics.symbols != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.symbols));
                    out.endTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                }
                if (this.minimumPasswordMetrics.nonLetter > 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_NONLETTER);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordMetrics.nonLetter));
                    out.endTag(null, TAG_MIN_PASSWORD_NONLETTER);
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, TAG_MAX_TIME_TO_UNLOCK);
                out.attribute(null, "value", Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, TAG_MAX_TIME_TO_UNLOCK);
            }
            if (this.strongAuthUnlockTimeout != 259200000L) {
                out.startTag(null, TAG_STRONG_AUTH_UNLOCK_TIMEOUT);
                out.attribute(null, "value", Long.toString(this.strongAuthUnlockTimeout));
                out.endTag(null, TAG_STRONG_AUTH_UNLOCK_TIMEOUT);
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
                out.attribute(null, "value", Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                out.attribute(null, "value", Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                if (this.globalProxySpec != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_SPEC);
                    out.attribute(null, "value", this.globalProxySpec);
                    out.endTag(null, TAG_GLOBAL_PROXY_SPEC);
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                    out.attribute(null, "value", this.globalProxyExclusionList);
                    out.endTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
                out.attribute(null, "value", Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_DATE);
                out.attribute(null, "value", Long.toString(this.passwordExpirationDate));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_DATE);
            }
            if (this.encryptionRequested) {
                out.startTag(null, TAG_ENCRYPTION_REQUESTED);
                out.attribute(null, "value", Boolean.toString(this.encryptionRequested));
                out.endTag(null, TAG_ENCRYPTION_REQUESTED);
            }
            if (this.testOnlyAdmin) {
                out.startTag(null, TAG_TEST_ONLY_ADMIN);
                out.attribute(null, "value", Boolean.toString(this.testOnlyAdmin));
                out.endTag(null, TAG_TEST_ONLY_ADMIN);
            }
            if (this.disableCamera) {
                out.startTag(null, TAG_DISABLE_CAMERA);
                out.attribute(null, "value", Boolean.toString(this.disableCamera));
                out.endTag(null, TAG_DISABLE_CAMERA);
            }
            if (this.disableCallerId) {
                out.startTag(null, TAG_DISABLE_CALLER_ID);
                out.attribute(null, "value", Boolean.toString(this.disableCallerId));
                out.endTag(null, TAG_DISABLE_CALLER_ID);
            }
            if (this.disableContactsSearch) {
                out.startTag(null, TAG_DISABLE_CONTACTS_SEARCH);
                out.attribute(null, "value", Boolean.toString(this.disableContactsSearch));
                out.endTag(null, TAG_DISABLE_CONTACTS_SEARCH);
            }
            if (!this.disableBluetoothContactSharing) {
                out.startTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
                out.attribute(null, "value", Boolean.toString(this.disableBluetoothContactSharing));
                out.endTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
            }
            if (this.disableScreenCapture) {
                out.startTag(null, TAG_DISABLE_SCREEN_CAPTURE);
                out.attribute(null, "value", Boolean.toString(this.disableScreenCapture));
                out.endTag(null, TAG_DISABLE_SCREEN_CAPTURE);
            }
            if (this.requireAutoTime) {
                out.startTag(null, TAG_REQUIRE_AUTO_TIME);
                out.attribute(null, "value", Boolean.toString(this.requireAutoTime));
                out.endTag(null, TAG_REQUIRE_AUTO_TIME);
            }
            if (this.forceEphemeralUsers) {
                out.startTag(null, TAG_FORCE_EPHEMERAL_USERS);
                out.attribute(null, "value", Boolean.toString(this.forceEphemeralUsers));
                out.endTag(null, TAG_FORCE_EPHEMERAL_USERS);
            }
            if (this.isNetworkLoggingEnabled) {
                out.startTag(null, TAG_IS_NETWORK_LOGGING_ENABLED);
                out.attribute(null, "value", Boolean.toString(this.isNetworkLoggingEnabled));
                out.attribute(null, ATTR_NUM_NETWORK_LOGGING_NOTIFICATIONS, Integer.toString(this.numNetworkLoggingNotifications));
                out.attribute(null, ATTR_LAST_NETWORK_LOGGING_NOTIFICATION, Long.toString(this.lastNetworkLoggingNotificationTimeMs));
                out.endTag(null, TAG_IS_NETWORK_LOGGING_ENABLED);
            }
            if (this.disabledKeyguardFeatures != 0) {
                out.startTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
                out.attribute(null, "value", Integer.toString(this.disabledKeyguardFeatures));
                out.endTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
            }
            if (!this.accountTypesWithManagementDisabled.isEmpty()) {
                out.startTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
                this.writeAttributeValuesToXml(out, TAG_ACCOUNT_TYPE, this.accountTypesWithManagementDisabled);
                out.endTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
            }
            if (!this.trustAgentInfos.isEmpty()) {
                Set<Map.Entry<String, TrustAgentInfo>> set = this.trustAgentInfos.entrySet();
                out.startTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
                for (Map.Entry<String, TrustAgentInfo> entry : set) {
                    TrustAgentInfo trustAgentInfo = entry.getValue();
                    out.startTag(null, TAG_TRUST_AGENT_COMPONENT);
                    out.attribute(null, "value", entry.getKey());
                    if (trustAgentInfo.options != null) {
                        out.startTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                        try {
                            trustAgentInfo.options.saveToXml(out);
                        }
                        catch (XmlPullParserException e) {
                            Log.e(DevicePolicyManagerService.LOG_TAG, "Failed to save TrustAgent options", e);
                        }
                        out.endTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                    }
                    out.endTag(null, TAG_TRUST_AGENT_COMPONENT);
                }
                out.endTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
            }
            if (this.crossProfileWidgetProviders != null && !this.crossProfileWidgetProviders.isEmpty()) {
                out.startTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
                this.writeAttributeValuesToXml(out, TAG_PROVIDER, this.crossProfileWidgetProviders);
                out.endTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
            }
            this.writePackageListToXml(out, TAG_PERMITTED_ACCESSIBILITY_SERVICES, this.permittedAccessiblityServices);
            this.writePackageListToXml(out, TAG_PERMITTED_IMES, this.permittedInputMethods);
            this.writePackageListToXml(out, TAG_PERMITTED_NOTIFICATION_LISTENERS, this.permittedNotificationListeners);
            this.writePackageListToXml(out, TAG_KEEP_UNINSTALLED_PACKAGES, this.keepUninstalledPackages);
            this.writePackageListToXml(out, TAG_METERED_DATA_DISABLED_PACKAGES, this.meteredDisabledPackages);
            if (this.hasUserRestrictions()) {
                UserRestrictionsUtils.writeRestrictions(out, this.userRestrictions, TAG_USER_RESTRICTIONS);
            }
            if (!this.defaultEnabledRestrictionsAlreadySet.isEmpty()) {
                out.startTag(null, TAG_DEFAULT_ENABLED_USER_RESTRICTIONS);
                this.writeAttributeValuesToXml(out, TAG_RESTRICTION, this.defaultEnabledRestrictionsAlreadySet);
                out.endTag(null, TAG_DEFAULT_ENABLED_USER_RESTRICTIONS);
            }
            if (!TextUtils.isEmpty(this.shortSupportMessage)) {
                out.startTag(null, TAG_SHORT_SUPPORT_MESSAGE);
                out.text(this.shortSupportMessage.toString());
                out.endTag(null, TAG_SHORT_SUPPORT_MESSAGE);
            }
            if (!TextUtils.isEmpty(this.longSupportMessage)) {
                out.startTag(null, TAG_LONG_SUPPORT_MESSAGE);
                out.text(this.longSupportMessage.toString());
                out.endTag(null, TAG_LONG_SUPPORT_MESSAGE);
            }
            if (this.parentAdmin != null) {
                out.startTag(null, TAG_PARENT_ADMIN);
                this.parentAdmin.writeToXml(out);
                out.endTag(null, TAG_PARENT_ADMIN);
            }
            if (this.organizationColor != DEF_ORGANIZATION_COLOR) {
                out.startTag(null, TAG_ORGANIZATION_COLOR);
                out.attribute(null, "value", Integer.toString(this.organizationColor));
                out.endTag(null, TAG_ORGANIZATION_COLOR);
            }
            if (this.organizationName != null) {
                out.startTag(null, TAG_ORGANIZATION_NAME);
                out.text(this.organizationName);
                out.endTag(null, TAG_ORGANIZATION_NAME);
            }
            if (this.isLogoutEnabled) {
                out.startTag(null, TAG_IS_LOGOUT_ENABLED);
                out.attribute(null, "value", Boolean.toString(this.isLogoutEnabled));
                out.endTag(null, TAG_IS_LOGOUT_ENABLED);
            }
            if (this.mandatoryBackupTransport != null) {
                out.startTag(null, TAG_MANDATORY_BACKUP_TRANSPORT);
                out.attribute(null, "value", this.mandatoryBackupTransport.flattenToString());
                out.endTag(null, TAG_MANDATORY_BACKUP_TRANSPORT);
            }
            if (this.startUserSessionMessage != null) {
                out.startTag(null, TAG_START_USER_SESSION_MESSAGE);
                out.text(this.startUserSessionMessage);
                out.endTag(null, TAG_START_USER_SESSION_MESSAGE);
            }
            if (this.endUserSessionMessage != null) {
                out.startTag(null, TAG_END_USER_SESSION_MESSAGE);
                out.text(this.endUserSessionMessage);
                out.endTag(null, TAG_END_USER_SESSION_MESSAGE);
            }
        }

        void writePackageListToXml(XmlSerializer out, String outerTag, List<String> packageList) throws IllegalArgumentException, IllegalStateException, IOException {
            if (packageList == null) {
                return;
            }
            out.startTag(null, outerTag);
            this.writeAttributeValuesToXml(out, TAG_PACKAGE_LIST_ITEM, packageList);
            out.endTag(null, outerTag);
        }

        void writeAttributeValuesToXml(XmlSerializer out, String tag, Collection<String> values) throws IOException {
            for (String value : values) {
                out.startTag(null, tag);
                out.attribute(null, "value", value);
                out.endTag(null, tag);
            }
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if (TAG_POLICIES.equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                    continue;
                }
                if (TAG_PASSWORD_QUALITY.equals(tag)) {
                    this.minimumPasswordMetrics.quality = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LENGTH.equals(tag)) {
                    this.minimumPasswordMetrics.length = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_PASSWORD_HISTORY_LENGTH.equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_UPPERCASE.equals(tag)) {
                    this.minimumPasswordMetrics.upperCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LOWERCASE.equals(tag)) {
                    this.minimumPasswordMetrics.lowerCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LETTERS.equals(tag)) {
                    this.minimumPasswordMetrics.letters = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NUMERIC.equals(tag)) {
                    this.minimumPasswordMetrics.numeric = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_SYMBOLS.equals(tag)) {
                    this.minimumPasswordMetrics.symbols = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NONLETTER.equals(tag)) {
                    this.minimumPasswordMetrics.nonLetter = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MAX_TIME_TO_UNLOCK.equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_STRONG_AUTH_UNLOCK_TIMEOUT.equals(tag)) {
                    this.strongAuthUnlockTimeout = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MAX_FAILED_PASSWORD_WIPE.equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_SPECIFIES_GLOBAL_PROXY.equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_GLOBAL_PROXY_SPEC.equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (TAG_GLOBAL_PROXY_EXCLUSION_LIST.equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_TIMEOUT.equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_DATE.equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_ENCRYPTION_REQUESTED.equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_TEST_ONLY_ADMIN.equals(tag)) {
                    this.testOnlyAdmin = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CAMERA.equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CALLER_ID.equals(tag)) {
                    this.disableCallerId = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CONTACTS_SEARCH.equals(tag)) {
                    this.disableContactsSearch = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_BLUETOOTH_CONTACT_SHARING.equals(tag)) {
                    this.disableBluetoothContactSharing = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_SCREEN_CAPTURE.equals(tag)) {
                    this.disableScreenCapture = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_REQUIRE_AUTO_TIME.equals(tag)) {
                    this.requireAutoTime = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_FORCE_EPHEMERAL_USERS.equals(tag)) {
                    this.forceEphemeralUsers = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_IS_NETWORK_LOGGING_ENABLED.equals(tag)) {
                    this.isNetworkLoggingEnabled = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    this.lastNetworkLoggingNotificationTimeMs = Long.parseLong(parser.getAttributeValue(null, ATTR_LAST_NETWORK_LOGGING_NOTIFICATION));
                    this.numNetworkLoggingNotifications = Integer.parseInt(parser.getAttributeValue(null, ATTR_NUM_NETWORK_LOGGING_NOTIFICATIONS));
                    continue;
                }
                if (TAG_DISABLE_KEYGUARD_FEATURES.equals(tag)) {
                    this.disabledKeyguardFeatures = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_ACCOUNT_MANAGEMENT.equals(tag)) {
                    this.readAttributeValues(parser, TAG_ACCOUNT_TYPE, this.accountTypesWithManagementDisabled);
                    continue;
                }
                if (TAG_MANAGE_TRUST_AGENT_FEATURES.equals(tag)) {
                    this.trustAgentInfos = this.getAllTrustAgentInfos(parser, tag);
                    continue;
                }
                if (TAG_CROSS_PROFILE_WIDGET_PROVIDERS.equals(tag)) {
                    this.crossProfileWidgetProviders = new ArrayList<String>();
                    this.readAttributeValues(parser, TAG_PROVIDER, this.crossProfileWidgetProviders);
                    continue;
                }
                if (TAG_PERMITTED_ACCESSIBILITY_SERVICES.equals(tag)) {
                    this.permittedAccessiblityServices = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_IMES.equals(tag)) {
                    this.permittedInputMethods = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_NOTIFICATION_LISTENERS.equals(tag)) {
                    this.permittedNotificationListeners = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_KEEP_UNINSTALLED_PACKAGES.equals(tag)) {
                    this.keepUninstalledPackages = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_METERED_DATA_DISABLED_PACKAGES.equals(tag)) {
                    this.meteredDisabledPackages = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_USER_RESTRICTIONS.equals(tag)) {
                    this.userRestrictions = UserRestrictionsUtils.readRestrictions(parser);
                    continue;
                }
                if (TAG_DEFAULT_ENABLED_USER_RESTRICTIONS.equals(tag)) {
                    this.readAttributeValues(parser, TAG_RESTRICTION, this.defaultEnabledRestrictionsAlreadySet);
                    continue;
                }
                if (TAG_SHORT_SUPPORT_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.shortSupportMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading short support message");
                    continue;
                }
                if (TAG_LONG_SUPPORT_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.longSupportMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading long support message");
                    continue;
                }
                if (TAG_PARENT_ADMIN.equals(tag)) {
                    Preconditions.checkState(!this.isParent);
                    this.parentAdmin = new ActiveAdmin(this.info, true);
                    this.parentAdmin.readFromXml(parser);
                    continue;
                }
                if (TAG_ORGANIZATION_COLOR.equals(tag)) {
                    this.organizationColor = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_ORGANIZATION_NAME.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.organizationName = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading organization name");
                    continue;
                }
                if (TAG_IS_LOGOUT_ENABLED.equals(tag)) {
                    this.isLogoutEnabled = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MANDATORY_BACKUP_TRANSPORT.equals(tag)) {
                    this.mandatoryBackupTransport = ComponentName.unflattenFromString(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_START_USER_SESSION_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.startUserSessionMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading start session message");
                    continue;
                }
                if (TAG_END_USER_SESSION_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.endUserSessionMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading end session message");
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown admin tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }

        private List<String> readPackageList(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int outerType;
            ArrayList<String> result = new ArrayList<String>();
            int outerDepth = parser.getDepth();
            while ((outerType = parser.next()) != 1 && (outerType != 3 || parser.getDepth() > outerDepth)) {
                if (outerType == 3 || outerType == 4) continue;
                String outerTag = parser.getName();
                if (TAG_PACKAGE_LIST_ITEM.equals(outerTag)) {
                    String packageName = parser.getAttributeValue(null, "value");
                    if (packageName != null) {
                        result.add(packageName);
                        continue;
                    }
                    Slog.w(DevicePolicyManagerService.LOG_TAG, "Package name missing under " + outerTag);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + outerTag);
            }
            return result;
        }

        private void readAttributeValues(XmlPullParser parser, String tag, Collection<String> result) throws XmlPullParserException, IOException {
            int typeDAM;
            result.clear();
            int outerDepthDAM = parser.getDepth();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (tag.equals(tagDAM)) {
                    result.add(parser.getAttributeValue(null, "value"));
                    continue;
                }
                Slog.e(DevicePolicyManagerService.LOG_TAG, "Expected tag " + tag + " but found " + tagDAM);
            }
        }

        private ArrayMap<String, TrustAgentInfo> getAllTrustAgentInfos(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayMap<String, TrustAgentInfo> result = new ArrayMap<String, TrustAgentInfo>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT.equals(tagDAM)) {
                    String component = parser.getAttributeValue(null, "value");
                    TrustAgentInfo trustAgentInfo = this.getTrustAgentInfo(parser, tag);
                    result.put(component, trustAgentInfo);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private TrustAgentInfo getTrustAgentInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            TrustAgentInfo result = new TrustAgentInfo(null);
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT_OPTIONS.equals(tagDAM)) {
                    result.options = PersistableBundle.restoreFromXml(parser);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        boolean hasUserRestrictions() {
            return this.userRestrictions != null && this.userRestrictions.size() > 0;
        }

        Bundle ensureUserRestrictions() {
            if (this.userRestrictions == null) {
                this.userRestrictions = new Bundle();
            }
            return this.userRestrictions;
        }

        public void transfer(DeviceAdminInfo deviceAdminInfo) {
            if (this.hasParentActiveAdmin()) {
                this.parentAdmin.info = deviceAdminInfo;
            }
            this.info = deviceAdminInfo;
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.print("testOnlyAdmin=");
            pw.println(this.testOnlyAdmin);
            pw.print(prefix);
            pw.println("policies:");
            ArrayList<DeviceAdminInfo.PolicyInfo> pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(pols.get((int)i).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.minimumPasswordMetrics.quality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordMetrics.length);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordMetrics.upperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordMetrics.lowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordMetrics.letters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordMetrics.numeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordMetrics.symbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordMetrics.nonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("strongAuthUnlockTimeout=");
            pw.println(this.strongAuthUnlockTimeout);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
            pw.print(prefix);
            pw.print("disableCallerId=");
            pw.println(this.disableCallerId);
            pw.print(prefix);
            pw.print("disableContactsSearch=");
            pw.println(this.disableContactsSearch);
            pw.print(prefix);
            pw.print("disableBluetoothContactSharing=");
            pw.println(this.disableBluetoothContactSharing);
            pw.print(prefix);
            pw.print("disableScreenCapture=");
            pw.println(this.disableScreenCapture);
            pw.print(prefix);
            pw.print("requireAutoTime=");
            pw.println(this.requireAutoTime);
            pw.print(prefix);
            pw.print("forceEphemeralUsers=");
            pw.println(this.forceEphemeralUsers);
            pw.print(prefix);
            pw.print("isNetworkLoggingEnabled=");
            pw.println(this.isNetworkLoggingEnabled);
            pw.print(prefix);
            pw.print("disabledKeyguardFeatures=");
            pw.println(this.disabledKeyguardFeatures);
            pw.print(prefix);
            pw.print("crossProfileWidgetProviders=");
            pw.println(this.crossProfileWidgetProviders);
            if (this.permittedAccessiblityServices != null) {
                pw.print(prefix);
                pw.print("permittedAccessibilityServices=");
                pw.println(this.permittedAccessiblityServices);
            }
            if (this.permittedInputMethods != null) {
                pw.print(prefix);
                pw.print("permittedInputMethods=");
                pw.println(this.permittedInputMethods);
            }
            if (this.permittedNotificationListeners != null) {
                pw.print(prefix);
                pw.print("permittedNotificationListeners=");
                pw.println(this.permittedNotificationListeners);
            }
            if (this.keepUninstalledPackages != null) {
                pw.print(prefix);
                pw.print("keepUninstalledPackages=");
                pw.println(this.keepUninstalledPackages);
            }
            pw.print(prefix);
            pw.print("organizationColor=");
            pw.println(this.organizationColor);
            if (this.organizationName != null) {
                pw.print(prefix);
                pw.print("organizationName=");
                pw.println(this.organizationName);
            }
            pw.print(prefix);
            pw.println("userRestrictions:");
            UserRestrictionsUtils.dumpRestrictions(pw, prefix + "  ", this.userRestrictions);
            pw.print(prefix);
            pw.print("defaultEnabledRestrictionsAlreadySet=");
            pw.println(this.defaultEnabledRestrictionsAlreadySet);
            pw.print(prefix);
            pw.print("isParent=");
            pw.println(this.isParent);
            if (this.parentAdmin != null) {
                pw.print(prefix);
                pw.println("parentAdmin:");
                this.parentAdmin.dump(prefix + "  ", pw);
            }
        }

        static class TrustAgentInfo {
            public PersistableBundle options;

            TrustAgentInfo(PersistableBundle bundle) {
                this.options = bundle;
            }
        }
    }

    protected static class RestrictionsListener
    implements UserManagerInternal.UserRestrictionsListener {
        private Context mContext;

        public RestrictionsListener(Context context) {
            this.mContext = context;
        }

        @Override
        public void onUserRestrictionsChanged(int userId, Bundle newRestrictions, Bundle prevRestrictions) {
            boolean previouslyDisallowed;
            boolean restrictionChanged;
            boolean newlyDisallowed = newRestrictions.getBoolean("no_sharing_into_profile");
            boolean bl = restrictionChanged = newlyDisallowed != (previouslyDisallowed = prevRestrictions.getBoolean("no_sharing_into_profile"));
            if (restrictionChanged) {
                Intent intent = new Intent("android.app.action.DATA_SHARING_RESTRICTION_CHANGED");
                intent.setPackage(DevicePolicyManagerService.getManagedProvisioningPackage(this.mContext));
                intent.putExtra("android.intent.extra.USER_ID", userId);
                intent.addFlags(0x10000000);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
            }
        }
    }

    public static class DevicePolicyData {
        int mFailedPasswordAttempts = 0;
        boolean mPasswordValidAtLastCheckpoint = true;
        int mUserHandle;
        int mPasswordOwner = -1;
        long mLastMaximumTimeToLock = -1L;
        boolean mUserSetupComplete = false;
        boolean mPaired = false;
        int mUserProvisioningState;
        int mPermissionPolicy;
        boolean mDeviceProvisioningConfigApplied = false;
        final ArrayMap<ComponentName, ActiveAdmin> mAdminMap = new ArrayMap();
        final ArrayList<ActiveAdmin> mAdminList = new ArrayList();
        final ArrayList<ComponentName> mRemovingAdmins = new ArrayList();
        final ArraySet<String> mAcceptedCaCertificates = new ArraySet();
        List<String> mLockTaskPackages = new ArrayList<String>();
        int mLockTaskFeatures = 16;
        boolean mStatusBarDisabled = false;
        ComponentName mRestrictionsProvider;
        final ArrayMap<String, List<String>> mDelegationMap = new ArrayMap();
        boolean doNotAskCredentialsOnBoot = false;
        Set<String> mAffiliationIds = new ArraySet<String>();
        long mLastSecurityLogRetrievalTime = -1L;
        long mLastBugReportRequestTime = -1L;
        long mLastNetworkLogsRetrievalTime = -1L;
        boolean mCurrentInputMethodSet = false;
        Set<String> mOwnerInstalledCaCerts = new ArraySet<String>();
        boolean mAdminBroadcastPending = false;
        PersistableBundle mInitBundle = null;
        long mPasswordTokenHandle = 0L;

        public DevicePolicyData(int userHandle) {
            this.mUserHandle = userHandle;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private BaseIDevicePolicyManager mService;

        public Lifecycle(Context context) {
            super(context);
            String dpmsClassName = context.getResources().getString(17039663);
            if (TextUtils.isEmpty(dpmsClassName)) {
                dpmsClassName = DevicePolicyManagerService.class.getName();
            }
            try {
                Class<?> serviceClass = Class.forName(dpmsClassName);
                Constructor<?> constructor = serviceClass.getConstructor(Context.class);
                this.mService = (BaseIDevicePolicyManager)constructor.newInstance(context);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate DevicePolicyManagerService with class name: " + dpmsClassName, e);
            }
        }

        @Override
        public void onStart() {
            this.publishBinderService("device_policy", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.systemReady(phase);
        }

        @Override
        public void onStartUser(int userHandle) {
            this.mService.handleStartUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.handleUnlockUser(userHandle);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.handleStopUser(userHandle);
        }
    }

    static interface Stats {
        public static final int LOCK_GUARD_GUARD = 0;
        public static final int COUNT = 1;
    }
}

