/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.app.job.JobParameters;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.content.SyncJobService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public class SyncLogger {
    private static final String TAG = "SyncLogger";
    private static SyncLogger sInstance;
    public static final int CALLING_UID_SELF = -1;

    SyncLogger() {
    }

    public static synchronized SyncLogger getInstance() {
        if (sInstance == null) {
            boolean enable = Build.IS_DEBUGGABLE || "1".equals(SystemProperties.get("debug.synclog")) || Log.isLoggable(TAG, 2);
            sInstance = enable ? new RotatingFileLogger() : new SyncLogger();
        }
        return sInstance;
    }

    public void log(Object ... message) {
    }

    public void purgeOldLogs() {
    }

    public String jobParametersToString(JobParameters params) {
        return "";
    }

    public void dumpAll(PrintWriter pw) {
    }

    public boolean enabled() {
        return false;
    }

    private static class RotatingFileLogger
    extends SyncLogger {
        private final Object mLock = new Object();
        private final long mKeepAgeMs = TimeUnit.DAYS.toMillis(7L);
        private static final SimpleDateFormat sTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private static final SimpleDateFormat sFilenameDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        @GuardedBy(value="mLock")
        private final Date mCachedDate = new Date();
        @GuardedBy(value="mLock")
        private final StringBuilder mStringBuilder = new StringBuilder();
        private final File mLogPath = new File(Environment.getDataSystemDirectory(), "syncmanager-log");
        @GuardedBy(value="mLock")
        private long mCurrentLogFileDayTimestamp;
        @GuardedBy(value="mLock")
        private Writer mLogWriter;
        @GuardedBy(value="mLock")
        private boolean mErrorShown;
        private static final boolean DO_LOGCAT = Log.isLoggable("SyncLogger", 3);

        RotatingFileLogger() {
        }

        @Override
        public boolean enabled() {
            return true;
        }

        private void handleException(String message, Exception e) {
            if (!this.mErrorShown) {
                Slog.e(SyncLogger.TAG, message, e);
                this.mErrorShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(Object ... message) {
            if (message == null) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                this.openLogLocked(now);
                if (this.mLogWriter == null) {
                    return;
                }
                this.mStringBuilder.setLength(0);
                this.mCachedDate.setTime(now);
                this.mStringBuilder.append(sTimestampFormat.format(this.mCachedDate));
                this.mStringBuilder.append(' ');
                this.mStringBuilder.append(Process.myTid());
                this.mStringBuilder.append(' ');
                int messageStart = this.mStringBuilder.length();
                for (Object o : message) {
                    this.mStringBuilder.append(o);
                }
                this.mStringBuilder.append('\n');
                try {
                    this.mLogWriter.append(this.mStringBuilder);
                    this.mLogWriter.flush();
                    if (DO_LOGCAT) {
                        Log.d(SyncLogger.TAG, this.mStringBuilder.substring(messageStart));
                    }
                }
                catch (IOException e) {
                    this.handleException("Failed to write log", e);
                }
            }
        }

        @GuardedBy(value="mLock")
        private void openLogLocked(long now) {
            long day = now % 86400000L;
            if (this.mLogWriter != null && day == this.mCurrentLogFileDayTimestamp) {
                return;
            }
            this.closeCurrentLogLocked();
            this.mCurrentLogFileDayTimestamp = day;
            this.mCachedDate.setTime(now);
            String filename = "synclog-" + sFilenameDateFormat.format(this.mCachedDate) + ".log";
            File file = new File(this.mLogPath, filename);
            file.getParentFile().mkdirs();
            try {
                this.mLogWriter = new FileWriter(file, true);
            }
            catch (IOException e) {
                this.handleException("Failed to open log file: " + file, e);
            }
        }

        @GuardedBy(value="mLock")
        private void closeCurrentLogLocked() {
            IoUtils.closeQuietly(this.mLogWriter);
            this.mLogWriter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purgeOldLogs() {
            Object object = this.mLock;
            synchronized (object) {
                FileUtils.deleteOlderFiles(this.mLogPath, 1, this.mKeepAgeMs);
            }
        }

        @Override
        public String jobParametersToString(JobParameters params) {
            return SyncJobService.jobParametersToString(params);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpAll(PrintWriter pw) {
            Object object = this.mLock;
            synchronized (object) {
                Object[] files = this.mLogPath.list();
                if (files == null || files.length == 0) {
                    return;
                }
                Arrays.sort(files);
                for (Object file : files) {
                    this.dumpFile(pw, new File(this.mLogPath, (String)file));
                }
            }
        }

        private void dumpFile(PrintWriter pw, File file) {
            Slog.w(SyncLogger.TAG, "Dumping " + file);
            char[] buffer = new char[32768];
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                int read;
                while ((read = in.read(buffer)) >= 0) {
                    if (read <= 0) continue;
                    pw.write(buffer, 0, read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

