/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.util.SharedLog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;

public class TetheringConfiguration {
    private static final String TAG = TetheringConfiguration.class.getSimpleName();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @VisibleForTesting
    public static final int DUN_NOT_REQUIRED = 0;
    public static final int DUN_REQUIRED = 1;
    public static final int DUN_UNSPECIFIED = 2;
    private static final String[] DHCP_DEFAULT_RANGE = new String[]{"192.168.42.2", "192.168.42.254", "192.168.43.2", "192.168.43.254", "192.168.44.2", "192.168.44.254", "192.168.45.2", "192.168.45.254", "192.168.46.2", "192.168.46.254", "192.168.47.2", "192.168.47.254", "192.168.48.2", "192.168.48.254", "192.168.49.2", "192.168.49.254"};
    private final String[] DEFAULT_IPV4_DNS = new String[]{"8.8.4.4", "8.8.8.8"};
    public final String[] tetherableUsbRegexs;
    public final String[] tetherableWifiRegexs;
    public final String[] tetherableBluetoothRegexs;
    public final int dunCheck;
    public final boolean isDunRequired;
    public final boolean chooseUpstreamAutomatically;
    public final Collection<Integer> preferredUpstreamIfaceTypes;
    public final String[] dhcpRanges;
    public final String[] defaultIPv4DNS;
    public final String[] provisioningApp;
    public final String provisioningAppNoUi;

    public TetheringConfiguration(Context ctx, SharedLog log) {
        SharedLog configLog = log.forSubComponent("config");
        this.tetherableUsbRegexs = TetheringConfiguration.getResourceStringArray(ctx, 17236048);
        this.tetherableWifiRegexs = TetheringConfiguration.getResourceStringArray(ctx, 17236049);
        this.tetherableBluetoothRegexs = TetheringConfiguration.getResourceStringArray(ctx, 17236045);
        this.dunCheck = TetheringConfiguration.checkDunRequired(ctx);
        configLog.log("DUN check returned: " + TetheringConfiguration.dunCheckString(this.dunCheck));
        this.chooseUpstreamAutomatically = TetheringConfiguration.getResourceBoolean(ctx, 17957054);
        this.preferredUpstreamIfaceTypes = TetheringConfiguration.getUpstreamIfaceTypes(ctx, this.dunCheck);
        this.isDunRequired = this.preferredUpstreamIfaceTypes.contains(4);
        this.dhcpRanges = TetheringConfiguration.getDhcpRanges(ctx);
        this.defaultIPv4DNS = TetheringConfiguration.copy(this.DEFAULT_IPV4_DNS);
        this.provisioningApp = TetheringConfiguration.getResourceStringArray(ctx, 17236021);
        this.provisioningAppNoUi = TetheringConfiguration.getProvisioningAppNoUi(ctx);
        configLog.log(this.toString());
    }

    public boolean isUsb(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableUsbRegexs);
    }

    public boolean isWifi(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableWifiRegexs);
    }

    public boolean isBluetooth(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableBluetoothRegexs);
    }

    public boolean hasMobileHotspotProvisionApp() {
        return !TextUtils.isEmpty(this.provisioningAppNoUi);
    }

    public void dump(PrintWriter pw) {
        TetheringConfiguration.dumpStringArray(pw, "tetherableUsbRegexs", this.tetherableUsbRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableWifiRegexs", this.tetherableWifiRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableBluetoothRegexs", this.tetherableBluetoothRegexs);
        pw.print("isDunRequired: ");
        pw.println(this.isDunRequired);
        pw.print("chooseUpstreamAutomatically: ");
        pw.println(this.chooseUpstreamAutomatically);
        TetheringConfiguration.dumpStringArray(pw, "preferredUpstreamIfaceTypes", TetheringConfiguration.preferredUpstreamNames(this.preferredUpstreamIfaceTypes));
        TetheringConfiguration.dumpStringArray(pw, "dhcpRanges", this.dhcpRanges);
        TetheringConfiguration.dumpStringArray(pw, "defaultIPv4DNS", this.defaultIPv4DNS);
        TetheringConfiguration.dumpStringArray(pw, "provisioningApp", this.provisioningApp);
        pw.print("provisioningAppNoUi: ");
        pw.println(this.provisioningAppNoUi);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ");
        sj.add(String.format("tetherableUsbRegexs:%s", TetheringConfiguration.makeString(this.tetherableUsbRegexs)));
        sj.add(String.format("tetherableWifiRegexs:%s", TetheringConfiguration.makeString(this.tetherableWifiRegexs)));
        sj.add(String.format("tetherableBluetoothRegexs:%s", TetheringConfiguration.makeString(this.tetherableBluetoothRegexs)));
        sj.add(String.format("isDunRequired:%s", this.isDunRequired));
        sj.add(String.format("chooseUpstreamAutomatically:%s", this.chooseUpstreamAutomatically));
        sj.add(String.format("preferredUpstreamIfaceTypes:%s", TetheringConfiguration.makeString(TetheringConfiguration.preferredUpstreamNames(this.preferredUpstreamIfaceTypes))));
        sj.add(String.format("provisioningApp:%s", TetheringConfiguration.makeString(this.provisioningApp)));
        sj.add(String.format("provisioningAppNoUi:%s", this.provisioningAppNoUi));
        return String.format("TetheringConfiguration{%s}", sj.toString());
    }

    private static void dumpStringArray(PrintWriter pw, String label, String[] values) {
        pw.print(label);
        pw.print(": ");
        if (values != null) {
            StringJoiner sj = new StringJoiner(", ", "[", "]");
            for (String value : values) {
                sj.add(value);
            }
            pw.print(sj.toString());
        } else {
            pw.print("null");
        }
        pw.println();
    }

    private static String makeString(String[] strings) {
        if (strings == null) {
            return "null";
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        for (String s : strings) {
            sj.add(s);
        }
        return sj.toString();
    }

    private static String[] preferredUpstreamNames(Collection<Integer> upstreamTypes) {
        String[] upstreamNames = null;
        if (upstreamTypes != null) {
            upstreamNames = new String[upstreamTypes.size()];
            int i = 0;
            for (Integer netType : upstreamTypes) {
                upstreamNames[i] = ConnectivityManager.getNetworkTypeName(netType);
                ++i;
            }
        }
        return upstreamNames;
    }

    public static int checkDunRequired(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        return tm != null ? tm.getTetherApnRequired() : 2;
    }

    private static String dunCheckString(int dunCheck) {
        switch (dunCheck) {
            case 0: {
                return "DUN_NOT_REQUIRED";
            }
            case 1: {
                return "DUN_REQUIRED";
            }
            case 2: {
                return "DUN_UNSPECIFIED";
            }
        }
        return String.format("UNKNOWN (%s)", dunCheck);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Collection<Integer> getUpstreamIfaceTypes(Context ctx, int dunCheck) {
        int[] ifaceTypes = ctx.getResources().getIntArray(17236047);
        ArrayList<Integer> upstreamIfaceTypes = new ArrayList<Integer>(ifaceTypes.length);
        block4: for (int i : ifaceTypes) {
            switch (i) {
                case 0: 
                case 5: {
                    if (dunCheck != 1) break;
                    continue block4;
                }
                case 4: {
                    if (dunCheck == 0) continue block4;
                }
            }
            upstreamIfaceTypes.add(i);
        }
        if (dunCheck == 1) {
            TetheringConfiguration.appendIfNotPresent(upstreamIfaceTypes, 4);
        } else if (dunCheck == 0) {
            TetheringConfiguration.appendIfNotPresent(upstreamIfaceTypes, 0);
            TetheringConfiguration.appendIfNotPresent(upstreamIfaceTypes, 5);
        } else if (!TetheringConfiguration.containsOneOf(upstreamIfaceTypes, 4, 0, 5)) {
            upstreamIfaceTypes.add(0);
            upstreamIfaceTypes.add(5);
        }
        TetheringConfiguration.prependIfNotPresent(upstreamIfaceTypes, 9);
        return upstreamIfaceTypes;
    }

    private static boolean matchesDownstreamRegexs(String iface, String[] regexs) {
        for (String regex : regexs) {
            if (!iface.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private static String[] getDhcpRanges(Context ctx) {
        String[] fromResource = TetheringConfiguration.getResourceStringArray(ctx, 17236046);
        if (fromResource.length > 0 && fromResource.length % 2 == 0) {
            return fromResource;
        }
        return TetheringConfiguration.copy(DHCP_DEFAULT_RANGE);
    }

    private static String getProvisioningAppNoUi(Context ctx) {
        try {
            return ctx.getResources().getString(17039699);
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    private static boolean getResourceBoolean(Context ctx, int resId) {
        try {
            return ctx.getResources().getBoolean(resId);
        }
        catch (Resources.NotFoundException e404) {
            return false;
        }
    }

    private static String[] getResourceStringArray(Context ctx, int resId) {
        try {
            String[] strArray = ctx.getResources().getStringArray(resId);
            return strArray != null ? strArray : EMPTY_STRING_ARRAY;
        }
        catch (Resources.NotFoundException e404) {
            return EMPTY_STRING_ARRAY;
        }
    }

    private static String[] copy(String[] strarray) {
        return Arrays.copyOf(strarray, strarray.length);
    }

    private static void prependIfNotPresent(ArrayList<Integer> list, int value) {
        if (list.contains(value)) {
            return;
        }
        list.add(0, value);
    }

    private static void appendIfNotPresent(ArrayList<Integer> list, int value) {
        if (list.contains(value)) {
            return;
        }
        list.add(value);
    }

    private static boolean containsOneOf(ArrayList<Integer> list, Integer ... values) {
        for (Integer value : values) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }
}

