/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.hardware.tetheroffload.control.V1_0.IOffloadControl;
import android.hardware.tetheroffload.control.V1_0.ITetheringOffloadCallback;
import android.hardware.tetheroffload.control.V1_0.NatTimeoutUpdate;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.RemoteException;
import android.system.OsConstants;
import com.android.internal.util.BitUtils;
import java.util.ArrayList;

public class OffloadHardwareInterface {
    private static final String TAG = OffloadHardwareInterface.class.getSimpleName();
    private static final String YIELDS = " -> ";
    private static final int DEFAULT_TETHER_OFFLOAD_DISABLED = 0;
    private static final String NO_INTERFACE_NAME = "";
    private static final String NO_IPV4_ADDRESS = "";
    private static final String NO_IPV4_GATEWAY = "";
    private final Handler mHandler;
    private final SharedLog mLog;
    private IOffloadControl mOffloadControl;
    private TetheringOffloadCallback mTetheringOffloadCallback;
    private ControlCallback mControlCallback;

    private static native boolean configOffload();

    public OffloadHardwareInterface(Handler h, SharedLog log) {
        this.mHandler = h;
        this.mLog = log.forSubComponent(TAG);
    }

    public int getDefaultTetherOffloadDisabled() {
        return 0;
    }

    public boolean initOffloadConfig() {
        return OffloadHardwareInterface.configOffload();
    }

    public boolean initOffloadControl(ControlCallback controlCb) {
        this.mControlCallback = controlCb;
        if (this.mOffloadControl == null) {
            try {
                this.mOffloadControl = IOffloadControl.getService();
            }
            catch (RemoteException e) {
                this.mLog.e("tethering offload control not supported: " + e);
                return false;
            }
            if (this.mOffloadControl == null) {
                this.mLog.e("tethering IOffloadControl.getService() returned null");
                return false;
            }
        }
        String logmsg = String.format("initOffloadControl(%s)", controlCb == null ? "null" : "0x" + Integer.toHexString(System.identityHashCode(controlCb)));
        this.mTetheringOffloadCallback = new TetheringOffloadCallback(this.mHandler, this.mControlCallback, this.mLog);
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.initOffload(this.mTetheringOffloadCallback, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    public void stopOffloadControl() {
        if (this.mOffloadControl != null) {
            try {
                this.mOffloadControl.stopOffload((success, errMsg) -> {
                    if (!success) {
                        this.mLog.e("stopOffload failed: " + errMsg);
                    }
                });
            }
            catch (RemoteException e) {
                this.mLog.e("failed to stopOffload: " + e);
            }
        }
        this.mOffloadControl = null;
        this.mTetheringOffloadCallback = null;
        this.mControlCallback = null;
        this.mLog.log("stopOffloadControl()");
    }

    public ForwardedStats getForwardedStats(String upstream) {
        String logmsg = String.format("getForwardedStats(%s)", upstream);
        ForwardedStats stats = new ForwardedStats();
        try {
            this.mOffloadControl.getForwardedStats(upstream, (rxBytes, txBytes) -> {
                stats.rxBytes = rxBytes > 0L ? rxBytes : 0L;
                stats.txBytes = txBytes > 0L ? txBytes : 0L;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return stats;
        }
        this.mLog.log(logmsg + YIELDS + stats);
        return stats;
    }

    public boolean setLocalPrefixes(ArrayList<String> localPrefixes) {
        String logmsg = String.format("setLocalPrefixes([%s])", String.join((CharSequence)",", localPrefixes));
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.setLocalPrefixes(localPrefixes, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    public boolean setDataLimit(String iface, long limit) {
        String logmsg = String.format("setDataLimit(%s, %d)", iface, limit);
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.setDataLimit(iface, limit, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    public boolean setUpstreamParameters(String iface, String v4addr, String v4gateway, ArrayList<String> v6gws) {
        iface = iface != null ? iface : "";
        v4addr = v4addr != null ? v4addr : "";
        v4gateway = v4gateway != null ? v4gateway : "";
        v6gws = v6gws != null ? v6gws : new ArrayList<String>();
        String logmsg = String.format("setUpstreamParameters(%s, %s, %s, [%s])", iface, v4addr, v4gateway, String.join((CharSequence)",", v6gws));
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.setUpstreamParameters(iface, v4addr, v4gateway, v6gws, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    public boolean addDownstreamPrefix(String ifname, String prefix) {
        String logmsg = String.format("addDownstreamPrefix(%s, %s)", ifname, prefix);
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.addDownstream(ifname, prefix, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    public boolean removeDownstreamPrefix(String ifname, String prefix) {
        String logmsg = String.format("removeDownstreamPrefix(%s, %s)", ifname, prefix);
        CbResults results = new CbResults();
        try {
            this.mOffloadControl.removeDownstream(ifname, prefix, (success, errMsg) -> {
                results.success = success;
                results.errMsg = errMsg;
            });
        }
        catch (RemoteException e) {
            this.record(logmsg, e);
            return false;
        }
        this.record(logmsg, results);
        return results.success;
    }

    private void record(String msg, Throwable t) {
        this.mLog.e(msg + YIELDS + "exception: " + t);
    }

    private void record(String msg, CbResults results) {
        String logmsg = msg + YIELDS + results;
        if (!results.success) {
            this.mLog.e(logmsg);
        } else {
            this.mLog.log(logmsg);
        }
    }

    private static int networkProtocolToOsConstant(int proto) {
        switch (proto) {
            case 6: {
                return OsConstants.IPPROTO_TCP;
            }
            case 17: {
                return OsConstants.IPPROTO_UDP;
            }
        }
        return -Math.abs(proto);
    }

    private static class CbResults {
        boolean success;
        String errMsg;

        private CbResults() {
        }

        public String toString() {
            if (this.success) {
                return "ok";
            }
            return "fail: " + this.errMsg;
        }
    }

    private static class TetheringOffloadCallback
    extends ITetheringOffloadCallback.Stub {
        public final Handler handler;
        public final ControlCallback controlCb;
        public final SharedLog log;

        public TetheringOffloadCallback(Handler h, ControlCallback cb, SharedLog sharedLog) {
            this.handler = h;
            this.controlCb = cb;
            this.log = sharedLog;
        }

        @Override
        public void onEvent(int event) {
            this.handler.post(() -> {
                switch (event) {
                    case 1: {
                        this.controlCb.onStarted();
                        break;
                    }
                    case 2: {
                        this.controlCb.onStoppedError();
                        break;
                    }
                    case 3: {
                        this.controlCb.onStoppedUnsupported();
                        break;
                    }
                    case 4: {
                        this.controlCb.onSupportAvailable();
                        break;
                    }
                    case 5: {
                        this.controlCb.onStoppedLimitReached();
                        break;
                    }
                    default: {
                        this.log.e("Unsupported OffloadCallbackEvent: " + event);
                    }
                }
            });
        }

        @Override
        public void updateTimeout(NatTimeoutUpdate params) {
            this.handler.post(() -> this.controlCb.onNatTimeoutUpdate(OffloadHardwareInterface.networkProtocolToOsConstant(params.proto), params.src.addr, BitUtils.uint16(params.src.port), params.dst.addr, BitUtils.uint16(params.dst.port)));
        }
    }

    public static class ForwardedStats {
        public long rxBytes = 0L;
        public long txBytes = 0L;

        public void add(ForwardedStats other) {
            this.rxBytes += other.rxBytes;
            this.txBytes += other.txBytes;
        }

        public String toString() {
            return String.format("rx:%s tx:%s", this.rxBytes, this.txBytes);
        }
    }

    public static class ControlCallback {
        public void onStarted() {
        }

        public void onStoppedError() {
        }

        public void onStoppedUnsupported() {
        }

        public void onSupportAvailable() {
        }

        public void onStoppedLimitReached() {
        }

        public void onNatTimeoutUpdate(int proto, String srcAddr, int srcPort, String dstAddr, int dstPort) {
        }
    }
}

