/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.ContentResolver;
import android.net.ITetheringStatsProvider;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkStats;
import android.net.RouteInfo;
import android.net.netlink.ConntrackMessage;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkSocket;
import android.net.util.IpUtils;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.text.TextUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.connectivity.tethering.OffloadHardwareInterface;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OffloadController {
    private static final String TAG = OffloadController.class.getSimpleName();
    private static final boolean DBG = false;
    private static final String ANYIP = "0.0.0.0";
    private static final OffloadHardwareInterface.ForwardedStats EMPTY_STATS = new OffloadHardwareInterface.ForwardedStats();
    private final Handler mHandler;
    private final OffloadHardwareInterface mHwInterface;
    private final ContentResolver mContentResolver;
    private final INetworkManagementService mNms;
    private final ITetheringStatsProvider mStatsProvider;
    private final SharedLog mLog;
    private final HashMap<String, LinkProperties> mDownstreams;
    private boolean mConfigInitialized;
    private boolean mControlInitialized;
    private LinkProperties mUpstreamLinkProperties;
    private Set<IpPrefix> mExemptPrefixes;
    private Set<String> mLastLocalPrefixStrs;
    private ConcurrentHashMap<String, OffloadHardwareInterface.ForwardedStats> mForwardedStats = new ConcurrentHashMap(16, 0.75f, 1);
    private HashMap<String, Long> mInterfaceQuotas = new HashMap();
    private int mNatUpdateCallbacksReceived;
    private int mNatUpdateNetlinkErrors;

    public OffloadController(Handler h, OffloadHardwareInterface hwi, ContentResolver contentResolver, INetworkManagementService nms, SharedLog log) {
        this.mHandler = h;
        this.mHwInterface = hwi;
        this.mContentResolver = contentResolver;
        this.mNms = nms;
        this.mStatsProvider = new OffloadTetheringStatsProvider();
        this.mLog = log.forSubComponent(TAG);
        this.mDownstreams = new HashMap();
        this.mExemptPrefixes = new HashSet<IpPrefix>();
        this.mLastLocalPrefixStrs = new HashSet<String>();
        try {
            this.mNms.registerTetheringStatsProvider(this.mStatsProvider, this.getClass().getSimpleName());
        }
        catch (RemoteException e) {
            this.mLog.e("Cannot register offload stats provider: " + e);
        }
    }

    public boolean start() {
        if (this.started()) {
            return true;
        }
        if (this.isOffloadDisabled()) {
            this.mLog.i("tethering offload disabled");
            return false;
        }
        if (!this.mConfigInitialized) {
            this.mConfigInitialized = this.mHwInterface.initOffloadConfig();
            if (!this.mConfigInitialized) {
                this.mLog.i("tethering offload config not supported");
                this.stop();
                return false;
            }
        }
        this.mControlInitialized = this.mHwInterface.initOffloadControl(new OffloadHardwareInterface.ControlCallback(){

            @Override
            public void onStarted() {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.mLog.log("onStarted");
            }

            @Override
            public void onStoppedError() {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.mLog.log("onStoppedError");
            }

            @Override
            public void onStoppedUnsupported() {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.mLog.log("onStoppedUnsupported");
                OffloadController.this.updateStatsForAllUpstreams();
                OffloadController.this.forceTetherStatsPoll();
            }

            @Override
            public void onSupportAvailable() {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.mLog.log("onSupportAvailable");
                OffloadController.this.updateStatsForAllUpstreams();
                OffloadController.this.forceTetherStatsPoll();
                OffloadController.this.computeAndPushLocalPrefixes(UpdateType.FORCE);
                OffloadController.this.pushAllDownstreamState();
                OffloadController.this.pushUpstreamParameters(null);
            }

            @Override
            public void onStoppedLimitReached() {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.mLog.log("onStoppedLimitReached");
                OffloadController.this.updateStatsForCurrentUpstream();
                OffloadController.this.forceTetherStatsPoll();
            }

            @Override
            public void onNatTimeoutUpdate(int proto, String srcAddr, int srcPort, String dstAddr, int dstPort) {
                if (!OffloadController.this.started()) {
                    return;
                }
                OffloadController.this.updateNatTimeout(proto, srcAddr, srcPort, dstAddr, dstPort);
            }
        });
        boolean isStarted = this.started();
        if (!isStarted) {
            this.mLog.i("tethering offload control not supported");
            this.stop();
        } else {
            this.mLog.log("tethering offload started");
            this.mNatUpdateCallbacksReceived = 0;
            this.mNatUpdateNetlinkErrors = 0;
        }
        return isStarted;
    }

    public void stop() {
        boolean wasStarted = this.started();
        this.updateStatsForCurrentUpstream();
        this.mUpstreamLinkProperties = null;
        this.mHwInterface.stopOffloadControl();
        this.mControlInitialized = false;
        this.mConfigInitialized = false;
        if (wasStarted) {
            this.mLog.log("tethering offload stopped");
        }
    }

    private boolean started() {
        return this.mConfigInitialized && this.mControlInitialized;
    }

    private String currentUpstreamInterface() {
        return this.mUpstreamLinkProperties != null ? this.mUpstreamLinkProperties.getInterfaceName() : null;
    }

    private void maybeUpdateStats(String iface) {
        if (TextUtils.isEmpty(iface)) {
            return;
        }
        OffloadHardwareInterface.ForwardedStats diff = this.mHwInterface.getForwardedStats(iface);
        OffloadHardwareInterface.ForwardedStats base = this.mForwardedStats.get(iface);
        if (base != null) {
            diff.add(base);
        }
        this.mForwardedStats.put(iface, diff);
    }

    private boolean maybeUpdateDataLimit(String iface) {
        if (!this.started() || !TextUtils.equals(iface, this.currentUpstreamInterface())) {
            return true;
        }
        Long limit = this.mInterfaceQuotas.get(iface);
        if (limit == null) {
            limit = Long.MAX_VALUE;
        }
        return this.mHwInterface.setDataLimit(iface, limit);
    }

    private void updateStatsForCurrentUpstream() {
        this.maybeUpdateStats(this.currentUpstreamInterface());
    }

    private void updateStatsForAllUpstreams() {
        for (Map.Entry<String, OffloadHardwareInterface.ForwardedStats> kv : this.mForwardedStats.entrySet()) {
            this.maybeUpdateStats(kv.getKey());
        }
    }

    private void forceTetherStatsPoll() {
        try {
            this.mNms.tetherLimitReached(this.mStatsProvider);
        }
        catch (RemoteException e) {
            this.mLog.e("Cannot report data limit reached: " + e);
        }
    }

    public void setUpstreamLinkProperties(LinkProperties lp) {
        if (!this.started() || Objects.equals(this.mUpstreamLinkProperties, lp)) {
            return;
        }
        String prevUpstream = this.currentUpstreamInterface();
        this.mUpstreamLinkProperties = lp != null ? new LinkProperties(lp) : null;
        String iface = this.currentUpstreamInterface();
        if (!TextUtils.isEmpty(iface)) {
            this.mForwardedStats.putIfAbsent(iface, EMPTY_STATS);
        }
        this.computeAndPushLocalPrefixes(UpdateType.IF_NEEDED);
        this.pushUpstreamParameters(prevUpstream);
    }

    public void setLocalPrefixes(Set<IpPrefix> localPrefixes) {
        this.mExemptPrefixes = localPrefixes;
        if (!this.started()) {
            return;
        }
        this.computeAndPushLocalPrefixes(UpdateType.IF_NEEDED);
    }

    public void notifyDownstreamLinkProperties(LinkProperties lp) {
        String ifname = lp.getInterfaceName();
        LinkProperties oldLp = this.mDownstreams.put(ifname, new LinkProperties(lp));
        if (Objects.equals(oldLp, lp)) {
            return;
        }
        if (!this.started()) {
            return;
        }
        this.pushDownstreamState(oldLp, lp);
    }

    private void pushDownstreamState(LinkProperties oldLp, LinkProperties newLp) {
        String ifname = newLp.getInterfaceName();
        List<RouteInfo> oldRoutes = oldLp != null ? oldLp.getRoutes() : Collections.EMPTY_LIST;
        List<RouteInfo> newRoutes = newLp.getRoutes();
        for (RouteInfo ri : oldRoutes) {
            if (OffloadController.shouldIgnoreDownstreamRoute(ri) || newRoutes.contains(ri)) continue;
            this.mHwInterface.removeDownstreamPrefix(ifname, ri.getDestination().toString());
        }
        for (RouteInfo ri : newRoutes) {
            if (OffloadController.shouldIgnoreDownstreamRoute(ri) || oldRoutes.contains(ri)) continue;
            this.mHwInterface.addDownstreamPrefix(ifname, ri.getDestination().toString());
        }
    }

    private void pushAllDownstreamState() {
        for (LinkProperties lp : this.mDownstreams.values()) {
            this.pushDownstreamState(null, lp);
        }
    }

    public void removeDownstreamInterface(String ifname) {
        LinkProperties lp = this.mDownstreams.remove(ifname);
        if (lp == null) {
            return;
        }
        if (!this.started()) {
            return;
        }
        for (RouteInfo route : lp.getRoutes()) {
            if (OffloadController.shouldIgnoreDownstreamRoute(route)) continue;
            this.mHwInterface.removeDownstreamPrefix(ifname, route.getDestination().toString());
        }
    }

    private boolean isOffloadDisabled() {
        int defaultDisposition = this.mHwInterface.getDefaultTetherOffloadDisabled();
        return Settings.Global.getInt(this.mContentResolver, "tether_offload_disabled", defaultDisposition) != 0;
    }

    private boolean pushUpstreamParameters(String prevUpstream) {
        String iface = this.currentUpstreamInterface();
        if (TextUtils.isEmpty(iface)) {
            boolean rval = this.mHwInterface.setUpstreamParameters("", ANYIP, ANYIP, null);
            this.maybeUpdateStats(prevUpstream);
            return rval;
        }
        ArrayList<String> v6gateways = new ArrayList<String>();
        String v4addr = null;
        String v4gateway = null;
        for (InetAddress ip : this.mUpstreamLinkProperties.getAddresses()) {
            if (!(ip instanceof Inet4Address)) continue;
            v4addr = ip.getHostAddress();
            break;
        }
        for (RouteInfo ri : this.mUpstreamLinkProperties.getRoutes()) {
            if (!ri.hasGateway()) continue;
            String gateway = ri.getGateway().getHostAddress();
            if (ri.isIPv4Default()) {
                v4gateway = gateway;
                continue;
            }
            if (!ri.isIPv6Default()) continue;
            v6gateways.add(gateway);
        }
        boolean success = this.mHwInterface.setUpstreamParameters(iface, v4addr, v4gateway, v6gateways.isEmpty() ? null : v6gateways);
        if (!success) {
            return success;
        }
        this.maybeUpdateStats(prevUpstream);
        success = this.maybeUpdateDataLimit(iface);
        if (!success) {
            this.mLog.log("Setting data limit for " + iface + " failed, disabling offload.");
            this.stop();
        }
        return success;
    }

    private boolean computeAndPushLocalPrefixes(UpdateType how) {
        boolean force = how == UpdateType.FORCE;
        Set<String> localPrefixStrs = OffloadController.computeLocalPrefixStrings(this.mExemptPrefixes, this.mUpstreamLinkProperties);
        if (!force && this.mLastLocalPrefixStrs.equals(localPrefixStrs)) {
            return true;
        }
        this.mLastLocalPrefixStrs = localPrefixStrs;
        return this.mHwInterface.setLocalPrefixes(new ArrayList<String>(localPrefixStrs));
    }

    private static Set<String> computeLocalPrefixStrings(Set<IpPrefix> localPrefixes, LinkProperties upstreamLinkProperties) {
        HashSet<IpPrefix> prefixSet = new HashSet<IpPrefix>(localPrefixes);
        if (upstreamLinkProperties != null) {
            for (LinkAddress linkAddr : upstreamLinkProperties.getLinkAddresses()) {
                InetAddress ip;
                if (!linkAddr.isGlobalPreferred() || !((ip = linkAddr.getAddress()) instanceof Inet6Address)) continue;
                prefixSet.add(new IpPrefix(ip, 128));
            }
        }
        HashSet<String> localPrefixStrs = new HashSet<String>();
        for (IpPrefix pfx : prefixSet) {
            localPrefixStrs.add(pfx.toString());
        }
        return localPrefixStrs;
    }

    private static boolean shouldIgnoreDownstreamRoute(RouteInfo route) {
        return !route.getDestinationLinkAddress().isGlobalPreferred();
    }

    public void dump(IndentingPrintWriter pw) {
        if (this.isOffloadDisabled()) {
            pw.println("Offload disabled");
            return;
        }
        boolean isStarted = this.started();
        pw.println("Offload HALs " + (isStarted ? "started" : "not started"));
        LinkProperties lp = this.mUpstreamLinkProperties;
        String upstream = lp != null ? lp.getInterfaceName() : null;
        pw.println("Current upstream: " + upstream);
        pw.println("Exempt prefixes: " + this.mLastLocalPrefixStrs);
        pw.println("NAT timeout update callbacks received during the " + (isStarted ? "current" : "last") + " offload session: " + this.mNatUpdateCallbacksReceived);
        pw.println("NAT timeout update netlink errors during the " + (isStarted ? "current" : "last") + " offload session: " + this.mNatUpdateNetlinkErrors);
    }

    private void updateNatTimeout(int proto, String srcAddr, int srcPort, String dstAddr, int dstPort) {
        String protoName = OffloadController.protoNameFor(proto);
        if (protoName == null) {
            this.mLog.e("Unknown NAT update callback protocol: " + proto);
            return;
        }
        Inet4Address src = OffloadController.parseIPv4Address(srcAddr);
        if (src == null) {
            this.mLog.e("Failed to parse IPv4 address: " + srcAddr);
            return;
        }
        if (!IpUtils.isValidUdpOrTcpPort(srcPort)) {
            this.mLog.e("Invalid src port: " + srcPort);
            return;
        }
        Inet4Address dst = OffloadController.parseIPv4Address(dstAddr);
        if (dst == null) {
            this.mLog.e("Failed to parse IPv4 address: " + dstAddr);
            return;
        }
        if (!IpUtils.isValidUdpOrTcpPort(dstPort)) {
            this.mLog.e("Invalid dst port: " + dstPort);
            return;
        }
        ++this.mNatUpdateCallbacksReceived;
        String natDescription = String.format("%s (%s, %s) -> (%s, %s)", protoName, srcAddr, srcPort, dstAddr, dstPort);
        int timeoutSec = OffloadController.connectionTimeoutUpdateSecondsFor(proto);
        byte[] msg = ConntrackMessage.newIPv4TimeoutUpdateRequest(proto, src, srcPort, dst, dstPort, timeoutSec);
        try {
            NetlinkSocket.sendOneShotKernelMessage(OsConstants.NETLINK_NETFILTER, msg);
        }
        catch (ErrnoException e) {
            ++this.mNatUpdateNetlinkErrors;
            this.mLog.e("Error updating NAT conntrack entry >" + natDescription + "<: " + e + ", msg: " + NetlinkConstants.hexify(msg));
            this.mLog.log("NAT timeout update callbacks received: " + this.mNatUpdateCallbacksReceived);
            this.mLog.log("NAT timeout update netlink errors: " + this.mNatUpdateNetlinkErrors);
        }
    }

    private static Inet4Address parseIPv4Address(String addrString) {
        try {
            InetAddress ip = InetAddress.parseNumericAddress((String)addrString);
            if (ip instanceof Inet4Address) {
                return (Inet4Address)ip;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static String protoNameFor(int proto) {
        if (proto == OsConstants.IPPROTO_UDP) {
            return "UDP";
        }
        if (proto == OsConstants.IPPROTO_TCP) {
            return "TCP";
        }
        return null;
    }

    private static int connectionTimeoutUpdateSecondsFor(int proto) {
        if (proto == OsConstants.IPPROTO_TCP) {
            return 432000;
        }
        return 180;
    }

    private class OffloadTetheringStatsProvider
    extends ITetheringStatsProvider.Stub {
        private OffloadTetheringStatsProvider() {
        }

        @Override
        public NetworkStats getTetherStats(int how) {
            Runnable updateStats = () -> OffloadController.this.updateStatsForCurrentUpstream();
            if (Looper.myLooper() == OffloadController.this.mHandler.getLooper()) {
                updateStats.run();
            } else {
                OffloadController.this.mHandler.post(updateStats);
            }
            NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 0);
            NetworkStats.Entry entry = new NetworkStats.Entry();
            entry.set = 0;
            entry.tag = 0;
            entry.uid = how == 1 ? -5 : -1;
            for (Map.Entry kv : OffloadController.this.mForwardedStats.entrySet()) {
                OffloadHardwareInterface.ForwardedStats value = (OffloadHardwareInterface.ForwardedStats)kv.getValue();
                entry.iface = (String)kv.getKey();
                entry.rxBytes = value.rxBytes;
                entry.txBytes = value.txBytes;
                stats.addValues(entry);
            }
            return stats;
        }

        @Override
        public void setInterfaceQuota(String iface, long quotaBytes) {
            OffloadController.this.mHandler.post(() -> {
                if (quotaBytes == -1L) {
                    OffloadController.this.mInterfaceQuotas.remove(iface);
                } else {
                    OffloadController.this.mInterfaceQuotas.put(iface, quotaBytes);
                }
                OffloadController.this.maybeUpdateDataLimit(iface);
            });
        }
    }

    private static enum UpdateType {
        IF_NEEDED,
        FORCE;

    }
}

