/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionMonitor {
    private static final String TAG = "PermissionMonitor";
    private static final boolean DBG = true;
    private static final Boolean SYSTEM = Boolean.TRUE;
    private static final Boolean NETWORK = Boolean.FALSE;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final UserManager mUserManager;
    private final INetworkManagementService mNetd;
    private final BroadcastReceiver mIntentReceiver;
    private final Set<Integer> mUsers = new HashSet<Integer>();
    private final Map<Integer, Boolean> mApps = new HashMap<Integer, Boolean>();

    public PermissionMonitor(Context context, INetworkManagementService netd) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mUserManager = UserManager.get(context);
        this.mNetd = netd;
        this.mIntentReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String appName;
                String action = intent.getAction();
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                int appUid = intent.getIntExtra("android.intent.extra.UID", -1);
                Uri appData = intent.getData();
                String string2 = appName = appData != null ? appData.getSchemeSpecificPart() : null;
                if ("android.intent.action.USER_ADDED".equals(action)) {
                    PermissionMonitor.this.onUserAdded(user);
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    PermissionMonitor.this.onUserRemoved(user);
                } else if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    PermissionMonitor.this.onAppAdded(appName, appUid);
                } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
                    PermissionMonitor.this.onAppRemoved(appUid);
                }
            }
        };
    }

    public synchronized void startMonitoring() {
        PermissionMonitor.log("Monitoring");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_ADDED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        List<PackageInfo> apps = this.mPackageManager.getInstalledPackages(4096);
        if (apps == null) {
            PermissionMonitor.loge("No apps");
            return;
        }
        for (PackageInfo app : apps) {
            Boolean permission2;
            int uid;
            int n = uid = app.applicationInfo != null ? app.applicationInfo.uid : -1;
            if (uid < 0) continue;
            boolean isNetwork = this.hasNetworkPermission(app);
            boolean hasRestrictedPermission = this.hasRestrictedNetworkPermission(app);
            if (!isNetwork && !hasRestrictedPermission || (permission2 = this.mApps.get(uid)) != null && permission2 != NETWORK) continue;
            this.mApps.put(uid, hasRestrictedPermission);
        }
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users != null) {
            for (UserInfo user : users) {
                this.mUsers.add(user.id);
            }
        }
        PermissionMonitor.log("Users: " + this.mUsers.size() + ", Apps: " + this.mApps.size());
        this.update(this.mUsers, this.mApps, true);
    }

    @VisibleForTesting
    boolean isPreinstalledSystemApp(PackageInfo app) {
        int flags = app.applicationInfo != null ? app.applicationInfo.flags : 0;
        return (flags & 0x81) != 0;
    }

    @VisibleForTesting
    boolean hasPermission(PackageInfo app, String permission2) {
        if (app.requestedPermissions != null) {
            for (String p : app.requestedPermissions) {
                if (!permission2.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNetworkPermission(PackageInfo app) {
        return this.hasPermission(app, "android.permission.CHANGE_NETWORK_STATE");
    }

    private boolean hasRestrictedNetworkPermission(PackageInfo app) {
        if (this.isPreinstalledSystemApp(app)) {
            return true;
        }
        return this.hasPermission(app, "android.permission.CONNECTIVITY_INTERNAL") || this.hasPermission(app, "android.permission.CONNECTIVITY_USE_RESTRICTED_NETWORKS");
    }

    private boolean hasUseBackgroundNetworksPermission(PackageInfo app) {
        return this.hasPermission(app, "android.permission.CHANGE_NETWORK_STATE") || this.hasPermission(app, "android.permission.CONNECTIVITY_USE_RESTRICTED_NETWORKS") || this.hasPermission(app, "android.permission.CONNECTIVITY_INTERNAL") || this.hasPermission(app, "android.permission.NETWORK_STACK") || this.isPreinstalledSystemApp(app);
    }

    public boolean hasUseBackgroundNetworksPermission(int uid) {
        String[] names = this.mPackageManager.getPackagesForUid(uid);
        if (null == names || names.length == 0) {
            return false;
        }
        try {
            int userId = UserHandle.getUserId(uid);
            PackageInfo app = this.mPackageManager.getPackageInfoAsUser(names[0], 4096, userId);
            return this.hasUseBackgroundNetworksPermission(app);
        }
        catch (PackageManager.NameNotFoundException e) {
            PermissionMonitor.loge("NameNotFoundException " + names[0], e);
            return false;
        }
    }

    private int[] toIntArray(List<Integer> list) {
        int[] array2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    private void update(Set<Integer> users, Map<Integer, Boolean> apps, boolean add) {
        ArrayList<Integer> network = new ArrayList<Integer>();
        ArrayList<Integer> system = new ArrayList<Integer>();
        for (Map.Entry<Integer, Boolean> app : apps.entrySet()) {
            ArrayList<Integer> list = app.getValue() != false ? system : network;
            for (int user : users) {
                list.add(UserHandle.getUid(user, app.getKey()));
            }
        }
        try {
            if (add) {
                this.mNetd.setPermission("NETWORK", this.toIntArray(network));
                this.mNetd.setPermission("SYSTEM", this.toIntArray(system));
            } else {
                this.mNetd.clearPermission(this.toIntArray(network));
                this.mNetd.clearPermission(this.toIntArray(system));
            }
        }
        catch (RemoteException e) {
            PermissionMonitor.loge("Exception when updating permissions: " + e);
        }
    }

    private synchronized void onUserAdded(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserAdded: " + user);
            return;
        }
        this.mUsers.add(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, true);
    }

    private synchronized void onUserRemoved(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserRemoved: " + user);
            return;
        }
        this.mUsers.remove(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, false);
    }

    private Boolean highestPermissionForUid(Boolean currentPermission, String name) {
        if (currentPermission == SYSTEM) {
            return currentPermission;
        }
        try {
            PackageInfo app = this.mPackageManager.getPackageInfo(name, 4096);
            boolean isNetwork = this.hasNetworkPermission(app);
            boolean hasRestrictedPermission = this.hasRestrictedNetworkPermission(app);
            if (isNetwork || hasRestrictedPermission) {
                currentPermission = hasRestrictedPermission;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            PermissionMonitor.loge("NameNotFoundException " + name);
        }
        return currentPermission;
    }

    private synchronized void onAppAdded(String appName, int appUid) {
        if (TextUtils.isEmpty(appName) || appUid < 0) {
            PermissionMonitor.loge("Invalid app in onAppAdded: " + appName + " | " + appUid);
            return;
        }
        Boolean permission2 = this.highestPermissionForUid(this.mApps.get(appUid), appName);
        if (permission2 != this.mApps.get(appUid)) {
            this.mApps.put(appUid, permission2);
            HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
            apps.put(appUid, permission2);
            this.update(this.mUsers, apps, true);
        }
    }

    private synchronized void onAppRemoved(int appUid) {
        if (appUid < 0) {
            PermissionMonitor.loge("Invalid app in onAppRemoved: " + appUid);
            return;
        }
        HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
        Boolean permission2 = null;
        String[] packages = this.mPackageManager.getPackagesForUid(appUid);
        if (packages != null && packages.length > 0) {
            for (String name : packages) {
                if ((permission2 = this.highestPermissionForUid(permission2, name)) != SYSTEM) continue;
                return;
            }
        }
        if (permission2 == this.mApps.get(appUid)) {
            return;
        }
        if (permission2 != null) {
            this.mApps.put(appUid, permission2);
            apps.put(appUid, permission2);
            this.update(this.mUsers, apps, true);
        } else {
            this.mApps.remove(appUid);
            apps.put(appUid, NETWORK);
            this.update(this.mUsers, apps, false);
        }
    }

    private static void log(String s) {
        Log.d(TAG, s);
    }

    private static void loge(String s) {
        Log.e(TAG, s);
    }

    private static void loge(String s, Throwable e) {
        Log.e(TAG, s, e);
    }
}

