/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.clipboard;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.KeyguardManager;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.Parcel;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.SystemService;
import com.android.server.clipboard.HostClipboardMonitor;
import java.util.HashSet;
import java.util.List;

public class ClipboardService
extends SystemService {
    private static final String TAG = "ClipboardService";
    private static final boolean IS_EMULATOR = SystemProperties.getBoolean("ro.kernel.qemu", false);
    private final IActivityManager mAm;
    private final IUserManager mUm;
    private final PackageManager mPm;
    private final AppOpsManager mAppOps;
    private final IBinder mPermissionOwner;
    private HostClipboardMonitor mHostClipboardMonitor = null;
    private Thread mHostMonitorThread = null;
    private final SparseArray<PerUserClipboard> mClipboards = new SparseArray();

    public ClipboardService(Context context) {
        super(context);
        this.mAm = ActivityManager.getService();
        this.mPm = this.getContext().getPackageManager();
        this.mUm = (IUserManager)((Object)ServiceManager.getService("user"));
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        IBinder permOwner = null;
        try {
            permOwner = this.mAm.newUriPermissionOwner("clipboard");
        }
        catch (RemoteException e) {
            Slog.w("clipboard", "AM dead", e);
        }
        this.mPermissionOwner = permOwner;
        if (IS_EMULATOR) {
            this.mHostClipboardMonitor = new HostClipboardMonitor(new HostClipboardMonitor.HostClipboardCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onHostClipboardUpdated(String contents) {
                    ClipData clip = new ClipData("host clipboard", new String[]{"text/plain"}, new ClipData.Item(contents));
                    SparseArray sparseArray = ClipboardService.this.mClipboards;
                    synchronized (sparseArray) {
                        ClipboardService.this.setPrimaryClipInternal(ClipboardService.this.getClipboard(0), clip, 1000);
                    }
                }
            });
            this.mHostMonitorThread = new Thread(this.mHostClipboardMonitor);
            this.mHostMonitorThread.start();
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("clipboard", new ClipboardImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            this.mClipboards.remove(userId);
        }
    }

    private PerUserClipboard getClipboard() {
        return this.getClipboard(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerUserClipboard getClipboard(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            PerUserClipboard puc = this.mClipboards.get(userId);
            if (puc == null) {
                puc = new PerUserClipboard(userId);
                this.mClipboards.put(userId, puc);
            }
            return puc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserInfo> getRelatedProfiles(int userId) {
        List<UserInfo> related;
        long origId = Binder.clearCallingIdentity();
        try {
            related = this.mUm.getProfiles(userId, true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote Exception calling UserManager: " + e);
            List<UserInfo> list = null;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return related;
    }

    private boolean hasRestriction(String restriction, int userId) {
        try {
            return this.mUm.hasUserRestriction(restriction, userId);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote Exception calling UserManager.getUserRestrictions: ", e);
            return true;
        }
    }

    void setPrimaryClipInternal(ClipData clip, int callingUid) {
        int size;
        if (this.mHostClipboardMonitor != null) {
            CharSequence text;
            if (clip == null) {
                this.mHostClipboardMonitor.setHostClipboard("");
            } else if (clip.getItemCount() > 0 && (text = clip.getItemAt(0).getText()) != null) {
                this.mHostClipboardMonitor.setHostClipboard(text.toString());
            }
        }
        int userId = UserHandle.getUserId(callingUid);
        this.setPrimaryClipInternal(this.getClipboard(userId), clip, callingUid);
        List<UserInfo> related = this.getRelatedProfiles(userId);
        if (related != null && (size = related.size()) > 1) {
            int i;
            boolean canCopy;
            boolean bl = canCopy = !this.hasRestriction("no_cross_profile_copy_paste", userId);
            if (!canCopy) {
                clip = null;
            } else {
                clip = new ClipData(clip);
                for (i = clip.getItemCount() - 1; i >= 0; --i) {
                    clip.setItemAt(i, new ClipData.Item(clip.getItemAt(i)));
                }
                clip.fixUrisLight(userId);
            }
            for (i = 0; i < size; ++i) {
                boolean canCopyIntoProfile;
                int id2 = related.get((int)i).id;
                if (id2 == userId) continue;
                boolean bl2 = canCopyIntoProfile = !this.hasRestriction("no_sharing_into_profile", id2);
                if (!canCopyIntoProfile) continue;
                this.setPrimaryClipInternal(this.getClipboard(id2), clip, callingUid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrimaryClipInternal(PerUserClipboard clipboard, ClipData clip, int callingUid) {
        ClipDescription description;
        this.revokeUris(clipboard);
        clipboard.activePermissionOwners.clear();
        if (clip == null && clipboard.primaryClip == null) {
            return;
        }
        clipboard.primaryClip = clip;
        clipboard.primaryClipUid = clip != null ? callingUid : 9999;
        if (clip != null && (description = clip.getDescription()) != null) {
            description.setTimestamp(System.currentTimeMillis());
        }
        long ident = Binder.clearCallingIdentity();
        int n = clipboard.primaryClipListeners.beginBroadcast();
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    ListenerInfo li = (ListenerInfo)clipboard.primaryClipListeners.getBroadcastCookie(i);
                    if (!this.clipboardAccessAllowed(29, li.mPackageName, li.mUid)) continue;
                    clipboard.primaryClipListeners.getBroadcastItem(i).dispatchPrimaryClipChanged();
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clipboard.primaryClipListeners.finishBroadcast();
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeviceLocked() {
        int callingUserId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            KeyguardManager keyguardManager = this.getContext().getSystemService(KeyguardManager.class);
            boolean bl = keyguardManager != null && keyguardManager.isDeviceLocked(callingUserId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkUriOwnerLocked(Uri uri, int sourceUid) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.checkGrantUriPermission(sourceUid, null, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void checkItemOwnerLocked(ClipData.Item item, int uid) {
        Intent intent;
        if (item.getUri() != null) {
            this.checkUriOwnerLocked(item.getUri(), uid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.checkUriOwnerLocked(intent.getData(), uid);
        }
    }

    private final void checkDataOwnerLocked(ClipData data, int uid) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.checkItemOwnerLocked(data.getItemAt(i), uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void grantUriLocked(Uri uri, int sourceUid, String targetPkg, int targetUserId) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.grantUriPermissionFromOwner(this.mPermissionOwner, sourceUid, targetPkg, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)), targetUserId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void grantItemLocked(ClipData.Item item, int sourceUid, String targetPkg, int targetUserId) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriLocked(item.getUri(), sourceUid, targetPkg, targetUserId);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriLocked(intent.getData(), sourceUid, targetPkg, targetUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addActiveOwnerLocked(int uid, String pkg) {
        IPackageManager pm = AppGlobals.getPackageManager();
        int targetUserHandle = UserHandle.getCallingUserId();
        long oldIdentity = Binder.clearCallingIdentity();
        try {
            PackageInfo pi = pm.getPackageInfo(pkg, 0, targetUserHandle);
            if (pi == null) {
                throw new IllegalArgumentException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(pi.applicationInfo.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " does not own package " + pkg);
            }
        }
        catch (RemoteException pi) {
        }
        finally {
            Binder.restoreCallingIdentity(oldIdentity);
        }
        PerUserClipboard clipboard = this.getClipboard();
        if (clipboard.primaryClip != null && !clipboard.activePermissionOwners.contains(pkg)) {
            int N = clipboard.primaryClip.getItemCount();
            for (int i = 0; i < N; ++i) {
                this.grantItemLocked(clipboard.primaryClip.getItemAt(i), clipboard.primaryClipUid, pkg, UserHandle.getUserId(uid));
            }
            clipboard.activePermissionOwners.add(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void revokeUriLocked(Uri uri, int sourceUid) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.revokeUriPermissionFromOwner(this.mPermissionOwner, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void revokeItemLocked(ClipData.Item item, int sourceUid) {
        Intent intent;
        if (item.getUri() != null) {
            this.revokeUriLocked(item.getUri(), sourceUid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.revokeUriLocked(intent.getData(), sourceUid);
        }
    }

    private final void revokeUris(PerUserClipboard clipboard) {
        if (clipboard.primaryClip == null) {
            return;
        }
        int N = clipboard.primaryClip.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.revokeItemLocked(clipboard.primaryClip.getItemAt(i), clipboard.primaryClipUid);
        }
    }

    private boolean clipboardAccessAllowed(int op, String callingPackage, int callingUid) {
        if (this.mAppOps.noteOp(op, callingUid, callingPackage) != 0) {
            return false;
        }
        try {
            if (!AppGlobals.getPackageManager().isInstantApp(callingPackage, UserHandle.getUserId(callingUid))) {
                return true;
            }
            return this.mAm.isAppForeground(callingUid);
        }
        catch (RemoteException e) {
            Slog.e("clipboard", "Failed to get Instant App status for package " + callingPackage, e);
            return false;
        }
    }

    private class ClipboardImpl
    extends IClipboard.Stub {
        private ClipboardImpl() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf("clipboard", "Exception: ", e);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPrimaryClip(ClipData clip, String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                if (clip == null || clip.getItemCount() <= 0) {
                    throw new IllegalArgumentException("No items");
                }
                int callingUid = Binder.getCallingUid();
                if (!ClipboardService.this.clipboardAccessAllowed(30, callingPackage, callingUid)) {
                    return;
                }
                ClipboardService.this.checkDataOwnerLocked(clip, callingUid);
                ClipboardService.this.setPrimaryClipInternal(clip, callingUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearPrimaryClip(String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int callingUid = Binder.getCallingUid();
                if (!ClipboardService.this.clipboardAccessAllowed(30, callingPackage, callingUid)) {
                    return;
                }
                ClipboardService.this.setPrimaryClipInternal(null, callingUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClipData getPrimaryClip(String pkg) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                if (!ClipboardService.this.clipboardAccessAllowed(29, pkg, Binder.getCallingUid()) || ClipboardService.this.isDeviceLocked()) {
                    return null;
                }
                ClipboardService.this.addActiveOwnerLocked(Binder.getCallingUid(), pkg);
                return ((ClipboardService)ClipboardService.this).getClipboard().primaryClip;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClipDescription getPrimaryClipDescription(String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, Binder.getCallingUid()) || ClipboardService.this.isDeviceLocked()) {
                    return null;
                }
                PerUserClipboard clipboard = ClipboardService.this.getClipboard();
                return clipboard.primaryClip != null ? clipboard.primaryClip.getDescription() : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrimaryClip(String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, Binder.getCallingUid()) || ClipboardService.this.isDeviceLocked()) {
                    return false;
                }
                return ((ClipboardService)ClipboardService.this).getClipboard().primaryClip != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                ((ClipboardService)ClipboardService.this).getClipboard().primaryClipListeners.register(listener, new ListenerInfo(Binder.getCallingUid(), callingPackage));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                ((ClipboardService)ClipboardService.this).getClipboard().primaryClipListeners.unregister(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasClipboardText(String callingPackage) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, Binder.getCallingUid()) || ClipboardService.this.isDeviceLocked()) {
                    return false;
                }
                PerUserClipboard clipboard = ClipboardService.this.getClipboard();
                if (clipboard.primaryClip != null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    CharSequence text = clipboard.primaryClip.getItemAt(0).getText();
                    return text != null && text.length() > 0;
                }
                return false;
            }
        }
    }

    private class PerUserClipboard {
        final int userId;
        final RemoteCallbackList<IOnPrimaryClipChangedListener> primaryClipListeners = new RemoteCallbackList();
        ClipData primaryClip;
        int primaryClipUid = 9999;
        final HashSet<String> activePermissionOwners = new HashSet();

        PerUserClipboard(int userId) {
            this.userId = userId;
        }
    }

    private class ListenerInfo {
        final int mUid;
        final String mPackageName;

        ListenerInfo(int uid, String packageName) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }
    }
}

