/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.camera;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceProxy;
import android.metrics.LogMaker;
import android.nfc.INfcAdapter;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.camera.CameraStatsJobService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CameraServiceProxy
extends SystemService
implements Handler.Callback,
IBinder.DeathRecipient {
    private static final String TAG = "CameraService_proxy";
    private static final boolean DEBUG = false;
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    public static final String CAMERA_SERVICE_PROXY_BINDER_NAME = "media.camera.proxy";
    public static final int DISABLE_POLLING_FLAGS = 4096;
    public static final int ENABLE_POLLING_FLAGS = 0;
    private static final int MSG_SWITCH_USER = 1;
    private static final int RETRY_DELAY_TIME = 20;
    private static final int MAX_USAGE_HISTORY = 100;
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    private final Handler mHandler;
    private UserManager mUserManager;
    private final Object mLock = new Object();
    private Set<Integer> mEnabledCameraUsers;
    private int mLastUser;
    private ICameraService mCameraServiceRaw;
    private final ArrayMap<String, CameraUsageEvent> mActiveCameraUsage = new ArrayMap();
    private final List<CameraUsageEvent> mCameraUsageHistory = new ArrayList<CameraUsageEvent>();
    private final MetricsLogger mLogger = new MetricsLogger();
    private static final String NFC_NOTIFICATION_PROP = "ro.camera.notify_nfc";
    private static final String NFC_SERVICE_BINDER_NAME = "nfc";
    private static final IBinder nfcInterfaceToken = new Binder();
    private final boolean mNotifyNfc;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_ADDED": 
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_INFO_CHANGED": 
                case "android.intent.action.MANAGED_PROFILE_ADDED": 
                case "android.intent.action.MANAGED_PROFILE_REMOVED": {
                    Object object = CameraServiceProxy.this.mLock;
                    synchronized (object) {
                        if (CameraServiceProxy.this.mEnabledCameraUsers == null) {
                            return;
                        }
                        CameraServiceProxy.this.switchUserLocked(CameraServiceProxy.this.mLastUser);
                        break;
                    }
                }
            }
        }
    };
    private final ICameraServiceProxy.Stub mCameraServiceProxy = new ICameraServiceProxy.Stub(){

        @Override
        public void pingForUserUpdate() {
            if (Binder.getCallingUid() != 1047) {
                Slog.e(CameraServiceProxy.TAG, "Calling UID: " + Binder.getCallingUid() + " doesn't match expected  camera service UID!");
                return;
            }
            CameraServiceProxy.this.notifySwitchWithRetries(30);
        }

        @Override
        public void notifyCameraState(String cameraId, int newCameraState, int facing, String clientName, int apiLevel) {
            if (Binder.getCallingUid() != 1047) {
                Slog.e(CameraServiceProxy.TAG, "Calling UID: " + Binder.getCallingUid() + " doesn't match expected  camera service UID!");
                return;
            }
            String state = CameraServiceProxy.cameraStateToString(newCameraState);
            String facingStr = CameraServiceProxy.cameraFacingToString(facing);
            CameraServiceProxy.this.updateActivityCount(cameraId, newCameraState, facing, clientName, apiLevel);
        }
    };

    public CameraServiceProxy(Context context) {
        super(context);
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), this);
        this.mNotifyNfc = SystemProperties.getInt(NFC_NOTIFICATION_PROP, 0) > 0;
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.notifySwitchWithRetries(msg.arg1);
                break;
            }
            default: {
                Slog.e(TAG, "CameraServiceProxy error, invalid message: " + msg.what);
            }
        }
        return true;
    }

    @Override
    public void onStart() {
        this.mUserManager = UserManager.get(this.mContext);
        if (this.mUserManager == null) {
            throw new IllegalStateException("UserManagerService must start before CameraServiceProxy!");
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_INFO_CHANGED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        this.mContext.registerReceiver(this.mIntentReceiver, filter);
        this.publishBinderService(CAMERA_SERVICE_PROXY_BINDER_NAME, this.mCameraServiceProxy);
        this.publishLocalService(CameraServiceProxy.class, this);
        CameraStatsJobService.schedule(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                this.switchUserLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.switchUserLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraServiceRaw = null;
            boolean wasEmpty = this.mActiveCameraUsage.isEmpty();
            this.mActiveCameraUsage.clear();
            if (this.mNotifyNfc && !wasEmpty) {
                this.notifyNfcService(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpUsageEvents() {
        Object object = this.mLock;
        synchronized (object) {
            Collections.shuffle(this.mCameraUsageHistory);
            block11: for (CameraUsageEvent e : this.mCameraUsageHistory) {
                int subtype = 0;
                switch (e.mCameraFacing) {
                    case 0: {
                        subtype = 0;
                        break;
                    }
                    case 1: {
                        subtype = 1;
                        break;
                    }
                    case 2: {
                        subtype = 2;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                LogMaker l = new LogMaker(1032).setType(4).setSubtype(subtype).setLatency(e.getDuration()).addTaggedData(1322, e.mAPILevel).setPackageName(e.mClientName);
                this.mLogger.write(l);
            }
            this.mCameraUsageHistory.clear();
        }
        long ident = Binder.clearCallingIdentity();
        try {
            CameraStatsJobService.schedule(this.mContext);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void switchUserLocked(int userHandle) {
        Set<Integer> currentUserHandles = this.getEnabledUserHandles(userHandle);
        this.mLastUser = userHandle;
        if (this.mEnabledCameraUsers == null || !this.mEnabledCameraUsers.equals(currentUserHandles)) {
            this.mEnabledCameraUsers = currentUserHandles;
            this.notifyMediaserverLocked(1, currentUserHandles);
        }
    }

    private Set<Integer> getEnabledUserHandles(int currentUserHandle) {
        int[] userProfiles = this.mUserManager.getEnabledProfileIds(currentUserHandle);
        ArraySet<Integer> handles = new ArraySet<Integer>(userProfiles.length);
        for (int id2 : userProfiles) {
            handles.add(id2);
        }
        return handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySwitchWithRetries(int retries) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                return;
            }
            if (this.notifyMediaserverLocked(1, this.mEnabledCameraUsers)) {
                retries = 0;
            }
        }
        if (retries <= 0) {
            return;
        }
        Slog.i(TAG, "Could not notify camera service of user switch, retrying...");
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, retries - 1, 0, null), 20L);
    }

    private boolean notifyMediaserverLocked(int eventType, Set<Integer> updatedUserHandles) {
        if (this.mCameraServiceRaw == null) {
            IBinder cameraServiceBinder = this.getBinderService(CAMERA_SERVICE_BINDER_NAME);
            if (cameraServiceBinder == null) {
                Slog.w(TAG, "Could not notify mediaserver, camera service not available.");
                return false;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Could not link to death of native camera service");
                return false;
            }
            this.mCameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        }
        try {
            this.mCameraServiceRaw.notifySystemEvent(eventType, CameraServiceProxy.toArray(updatedUserHandles));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not notify mediaserver, remote exception: " + e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivityCount(String cameraId, int newCameraState, int facing, String clientName, int apiLevel) {
        Object object = this.mLock;
        synchronized (object) {
            boolean wasEmpty = this.mActiveCameraUsage.isEmpty();
            switch (newCameraState) {
                case 0: {
                    break;
                }
                case 1: {
                    CameraUsageEvent newEvent = new CameraUsageEvent(facing, clientName, apiLevel);
                    CameraUsageEvent oldEvent = this.mActiveCameraUsage.put(cameraId, newEvent);
                    if (oldEvent == null) break;
                    Slog.w(TAG, "Camera " + cameraId + " was already marked as active");
                    oldEvent.markCompleted();
                    this.mCameraUsageHistory.add(oldEvent);
                    break;
                }
                case 2: 
                case 3: {
                    CameraUsageEvent doneEvent = this.mActiveCameraUsage.remove(cameraId);
                    if (doneEvent == null) break;
                    doneEvent.markCompleted();
                    this.mCameraUsageHistory.add(doneEvent);
                    if (this.mCameraUsageHistory.size() <= 100) break;
                    this.dumpUsageEvents();
                }
            }
            boolean isEmpty = this.mActiveCameraUsage.isEmpty();
            if (this.mNotifyNfc && wasEmpty != isEmpty) {
                this.notifyNfcService(isEmpty);
            }
        }
    }

    private void notifyNfcService(boolean enablePolling) {
        IBinder nfcServiceBinder = this.getBinderService(NFC_SERVICE_BINDER_NAME);
        if (nfcServiceBinder == null) {
            Slog.w(TAG, "Could not connect to NFC service to notify it of camera state");
            return;
        }
        INfcAdapter nfcAdapterRaw = INfcAdapter.Stub.asInterface(nfcServiceBinder);
        int flags = enablePolling ? 0 : 4096;
        try {
            nfcAdapterRaw.setReaderMode(nfcInterfaceToken, null, flags, null);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not notify NFC service, remote exception: " + e);
        }
    }

    private static int[] toArray(Collection<Integer> c) {
        int len = c.size();
        int[] ret = new int[len];
        int idx = 0;
        for (Integer i : c) {
            ret[idx++] = i;
        }
        return ret;
    }

    private static String cameraStateToString(int newCameraState) {
        switch (newCameraState) {
            case 0: {
                return "CAMERA_STATE_OPEN";
            }
            case 1: {
                return "CAMERA_STATE_ACTIVE";
            }
            case 2: {
                return "CAMERA_STATE_IDLE";
            }
            case 3: {
                return "CAMERA_STATE_CLOSED";
            }
        }
        return "CAMERA_STATE_UNKNOWN";
    }

    private static String cameraFacingToString(int cameraFacing) {
        switch (cameraFacing) {
            case 0: {
                return "CAMERA_FACING_BACK";
            }
            case 1: {
                return "CAMERA_FACING_FRONT";
            }
            case 2: {
                return "CAMERA_FACING_EXTERNAL";
            }
        }
        return "CAMERA_FACING_UNKNOWN";
    }

    private static class CameraUsageEvent {
        public final int mCameraFacing;
        public final String mClientName;
        public final int mAPILevel;
        private boolean mCompleted;
        private long mDurationOrStartTimeMs;

        public CameraUsageEvent(int facing, String clientName, int apiLevel) {
            this.mCameraFacing = facing;
            this.mClientName = clientName;
            this.mAPILevel = apiLevel;
            this.mDurationOrStartTimeMs = SystemClock.elapsedRealtime();
            this.mCompleted = false;
        }

        public void markCompleted() {
            if (this.mCompleted) {
                return;
            }
            this.mCompleted = true;
            this.mDurationOrStartTimeMs = SystemClock.elapsedRealtime() - this.mDurationOrStartTimeMs;
        }

        public long getDuration() {
            return this.mCompleted ? this.mDurationOrStartTimeMs : 0L;
        }
    }
}

