/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.broadcastradio.V2_0.AmFmRegionConfig;
import android.hardware.broadcastradio.V2_0.Announcement;
import android.hardware.broadcastradio.V2_0.IAnnouncementListener;
import android.hardware.broadcastradio.V2_0.IBroadcastRadio;
import android.hardware.broadcastradio.V2_0.ITunerSession;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.os.RemoteException;
import android.util.MutableInt;
import android.util.Slog;
import com.android.server.broadcastradio.hal2.Convert;
import com.android.server.broadcastradio.hal2.Mutable;
import com.android.server.broadcastradio.hal2.TunerCallback;
import com.android.server.broadcastradio.hal2.TunerSession;
import com.android.server.broadcastradio.hal2.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class RadioModule {
    private static final String TAG = "BcRadio2Srv.module";
    private final IBroadcastRadio mService;
    public final RadioManager.ModuleProperties mProperties;

    private RadioModule(IBroadcastRadio service, RadioManager.ModuleProperties properties) {
        this.mProperties = Objects.requireNonNull(properties);
        this.mService = Objects.requireNonNull(service);
    }

    public static RadioModule tryLoadingModule(int idx, String fqName) {
        try {
            IBroadcastRadio service = IBroadcastRadio.getService(fqName);
            if (service == null) {
                return null;
            }
            Mutable amfmConfig = new Mutable();
            service.getAmFmRegionConfig(false, (result, config) -> {
                if (result == 0) {
                    amfmConfig.value = config;
                }
            });
            Mutable dabConfig = new Mutable();
            service.getDabRegionConfig((result, config) -> {
                if (result == 0) {
                    dabConfig.value = config;
                }
            });
            RadioManager.ModuleProperties prop = Convert.propertiesFromHal(idx, fqName, service.getProperties(), (AmFmRegionConfig)amfmConfig.value, (List)dabConfig.value);
            return new RadioModule(service, prop);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "failed to load module " + fqName, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunerSession openSession(ITunerCallback userCb) throws RemoteException {
        TunerCallback cb = new TunerCallback(Objects.requireNonNull(userCb));
        Mutable hwSession = new Mutable();
        MutableInt halResult = new MutableInt(1);
        IBroadcastRadio iBroadcastRadio = this.mService;
        synchronized (iBroadcastRadio) {
            this.mService.openSession(cb, (result, session) -> {
                hwSession.value = session;
                halResult.value = result;
            });
        }
        Convert.throwOnError("openSession", halResult.value);
        Objects.requireNonNull((ITunerSession)hwSession.value);
        return new TunerSession(this, (ITunerSession)hwSession.value, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseHandle addAnnouncementListener(int[] enabledTypes, final IAnnouncementListener listener) throws RemoteException {
        ArrayList<Byte> enabledList = new ArrayList<Byte>();
        for (int type : enabledTypes) {
            enabledList.add((byte)type);
        }
        MutableInt halResult = new MutableInt(1);
        final Mutable hwCloseHandle = new Mutable();
        IAnnouncementListener.Stub hwListener = new IAnnouncementListener.Stub(){

            @Override
            public void onListUpdated(ArrayList<Announcement> hwAnnouncements) throws RemoteException {
                listener.onListUpdated(hwAnnouncements.stream().map(a -> Convert.announcementFromHal(a)).collect(Collectors.toList()));
            }
        };
        IBroadcastRadio iBroadcastRadio = this.mService;
        synchronized (iBroadcastRadio) {
            this.mService.registerAnnouncementListener(enabledList, hwListener, (result, closeHnd) -> {
                halResult.value = result;
                hwCloseHandle.value = closeHnd;
            });
        }
        Convert.throwOnError("addAnnouncementListener", halResult.value);
        return new ICloseHandle.Stub(){

            @Override
            public void close() {
                try {
                    ((android.hardware.broadcastradio.V2_0.ICloseHandle)hwCloseHandle.value).close();
                }
                catch (RemoteException ex) {
                    Slog.e(RadioModule.TAG, "Failed closing announcement listener", ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap getImage(int id2) {
        byte[] rawImage;
        if (id2 == 0) {
            throw new IllegalArgumentException("Image ID is missing");
        }
        IBroadcastRadio iBroadcastRadio = this.mService;
        synchronized (iBroadcastRadio) {
            List rawList = Utils.maybeRethrow(() -> this.mService.getImage(id2));
            rawImage = new byte[rawList.size()];
            for (int i = 0; i < rawList.size(); ++i) {
                rawImage[i] = (Byte)rawList.get(i);
            }
        }
        if (rawImage == null || rawImage.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray(rawImage, 0, rawImage.length);
    }
}

