/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.LocalServices;
import com.android.server.backup.FileMetadata;
import com.android.server.backup.restore.RestoreDeleteObserver;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BytesReadListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class RestoreUtils {
    public static boolean installApk(InputStream instream, Context context, RestoreDeleteObserver deleteObserver, HashMap<String, Signature[]> manifestSignatures, HashMap<String, RestorePolicy> packagePolicies, FileMetadata info, String installerPackageName, BytesReadListener bytesReadListener) {
        boolean okay;
        block32: {
            okay = true;
            Slog.d("BackupManagerService", "Installing from backup: " + info.packageName);
            try {
                LocalIntentReceiver receiver = new LocalIntentReceiver();
                PackageManager packageManager = context.getPackageManager();
                PackageInstaller installer = packageManager.getPackageInstaller();
                PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(1);
                params.setInstallerPackageName(installerPackageName);
                int sessionId = installer.createSession(params);
                try (PackageInstaller.Session session = installer.openSession(sessionId);){
                    try (OutputStream apkStream = session.openWrite(info.packageName, 0L, info.size);){
                        int didRead;
                        byte[] buffer = new byte[32768];
                        for (long size = info.size; size > 0L; size -= (long)didRead) {
                            long toRead = (long)buffer.length < size ? (long)buffer.length : size;
                            didRead = instream.read(buffer, 0, (int)toRead);
                            if (didRead >= 0) {
                                bytesReadListener.onBytesRead(didRead);
                            }
                            apkStream.write(buffer, 0, didRead);
                        }
                    }
                    session.abandon();
                }
                catch (Exception t) {
                    installer.abandonSession(sessionId);
                    throw t;
                }
                Intent result = null;
                boolean status = true;
                if (status) {
                    if (packagePolicies.get(info.packageName) != RestorePolicy.ACCEPT) {
                        okay = false;
                    }
                    break block32;
                }
                boolean uninstall = false;
                String installedPackageName = result.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
                if (!installedPackageName.equals(info.packageName)) {
                    Slog.w("BackupManagerService", "Restore stream claimed to include apk for " + info.packageName + " but apk was really " + installedPackageName);
                    okay = false;
                    uninstall = true;
                } else {
                    try {
                        PackageInfo pkg = packageManager.getPackageInfo(info.packageName, 0x8000000);
                        if ((pkg.applicationInfo.flags & 0x8000) == 0) {
                            Slog.w("BackupManagerService", "Restore stream contains apk of package " + info.packageName + " but it disallows backup/restore");
                            okay = false;
                        } else {
                            PackageManagerInternal pmi;
                            Signature[] sigs = manifestSignatures.get(info.packageName);
                            if (AppBackupUtils.signaturesMatch(sigs, pkg, pmi = LocalServices.getService(PackageManagerInternal.class))) {
                                if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                    Slog.w("BackupManagerService", "Installed app " + info.packageName + " has restricted uid and no agent");
                                    okay = false;
                                }
                            } else {
                                Slog.w("BackupManagerService", "Installed app " + info.packageName + " signatures do not match restore manifest");
                                okay = false;
                                uninstall = true;
                            }
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w("BackupManagerService", "Install of package " + info.packageName + " succeeded but now not found");
                        okay = false;
                    }
                }
                if (uninstall) {
                    deleteObserver.reset();
                    packageManager.deletePackage(installedPackageName, deleteObserver, 0);
                    deleteObserver.waitForCompletion();
                }
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Unable to transcribe restored apk for install");
                okay = false;
            }
        }
        return okay;
    }

    private static class LocalIntentReceiver {
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private Intent mResult = null;
        private IIntentSender.Stub mLocalSender = new IIntentSender.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void send(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
                Object object = mLock;
                synchronized (object) {
                    mResult = intent;
                    mLock.notifyAll();
                }
            }
        };

        private LocalIntentReceiver() {
        }

        public IntentSender getIntentSender() {
            return new IntentSender(this.mLocalSender);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Intent getResult() {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mResult == null) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.mResult;
            }
        }
    }
}

