/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.transport;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.EventLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.backup.transport.TransportConnectionListener;
import com.android.server.backup.transport.TransportNotAvailableException;
import com.android.server.backup.transport.TransportStats;
import com.android.server.backup.transport.TransportUtils;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class TransportClient {
    @VisibleForTesting
    static final String TAG = "TransportClient";
    private static final int LOG_BUFFER_SIZE = 5;
    private final Context mContext;
    private final TransportStats mTransportStats;
    private final Intent mBindIntent;
    private final ServiceConnection mConnection;
    private final String mIdentifier;
    private final String mCreatorLogString;
    private final ComponentName mTransportComponent;
    private final Handler mListenerHandler;
    private final String mPrefixForLog;
    private final Object mStateLock = new Object();
    private final Object mLogBufferLock = new Object();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    @GuardedBy(value="mLogBufferLock")
    private final List<String> mLogBuffer = new LinkedList<String>();
    @GuardedBy(value="mStateLock")
    private final Map<TransportConnectionListener, String> mListeners = new ArrayMap<TransportConnectionListener, String>();
    @GuardedBy(value="mStateLock")
    private int mState = 1;
    @GuardedBy(value="mStateLock")
    private volatile IBackupTransport mTransport;

    TransportClient(Context context, TransportStats transportStats, Intent bindIntent, ComponentName transportComponent, String identifier, String caller) {
        this(context, transportStats, bindIntent, transportComponent, identifier, caller, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    TransportClient(Context context, TransportStats transportStats, Intent bindIntent, ComponentName transportComponent, String identifier, String caller, Handler listenerHandler) {
        this.mContext = context;
        this.mTransportStats = transportStats;
        this.mTransportComponent = transportComponent;
        this.mBindIntent = bindIntent;
        this.mIdentifier = identifier;
        this.mCreatorLogString = caller;
        this.mListenerHandler = listenerHandler;
        this.mConnection = new TransportConnection(context, this);
        String classNameForLog = this.mTransportComponent.getShortClassName().replaceFirst(".*\\.", "");
        this.mPrefixForLog = classNameForLog + "#" + this.mIdentifier + ":";
        this.mCloseGuard.open("markAsDisposed");
    }

    public ComponentName getTransportComponent() {
        return this.mTransportComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectAsync(TransportConnectionListener listener, String caller) {
        Object object = this.mStateLock;
        synchronized (object) {
            this.checkStateIntegrityLocked();
            switch (this.mState) {
                case 0: {
                    this.log(5, caller, "Async connect: UNUSABLE client");
                    this.notifyListener(listener, null, caller);
                    break;
                }
                case 1: {
                    boolean hasBound = this.mContext.bindServiceAsUser(this.mBindIntent, this.mConnection, 1, UserHandle.SYSTEM);
                    if (hasBound) {
                        this.log(3, caller, "Async connect: service bound, connecting");
                        this.setStateLocked(2, null);
                        this.mListeners.put(listener, caller);
                        break;
                    }
                    this.log(6, "Async connect: bindService returned false");
                    this.mContext.unbindService(this.mConnection);
                    this.notifyListener(listener, null, caller);
                    break;
                }
                case 2: {
                    this.log(3, caller, "Async connect: already connecting, adding listener");
                    this.mListeners.put(listener, caller);
                    break;
                }
                case 3: {
                    this.log(3, caller, "Async connect: reusing transport");
                    this.notifyListener(listener, this.mTransport, caller);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String caller) {
        Object object = this.mStateLock;
        synchronized (object) {
            this.checkStateIntegrityLocked();
            this.log(3, caller, "Unbind requested (was " + this.stateToString(this.mState) + ")");
            switch (this.mState) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    this.setStateLocked(1, null);
                    this.mContext.unbindService(this.mConnection);
                    this.notifyListenersAndClearLocked(null);
                    break;
                }
                case 3: {
                    this.setStateLocked(1, null);
                    this.mContext.unbindService(this.mConnection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDisposed() {
        Object object = this.mStateLock;
        synchronized (object) {
            Preconditions.checkState(this.mState < 2, "Can't mark as disposed if still bound");
            this.mCloseGuard.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBackupTransport connect(String caller) {
        Preconditions.checkState(!Looper.getMainLooper().isCurrentThread(), "Can't call connect() on main thread");
        IBackupTransport transport = this.mTransport;
        if (transport != null) {
            this.log(3, caller, "Sync connect: reusing transport");
            return transport;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                this.log(5, caller, "Sync connect: UNUSABLE client");
                return null;
            }
        }
        CompletableFuture transportFuture = new CompletableFuture();
        TransportConnectionListener requestListener = (requestedTransport, transportClient) -> transportFuture.complete(requestedTransport);
        long requestTime = SystemClock.elapsedRealtime();
        this.log(3, caller, "Sync connect: calling async");
        this.connectAsync(requestListener, caller);
        try {
            transport = (IBackupTransport)transportFuture.get();
            long time = SystemClock.elapsedRealtime() - requestTime;
            this.mTransportStats.registerConnectionTime(this.mTransportComponent, time);
            this.log(3, caller, String.format(Locale.US, "Connect took %d ms", time));
            return transport;
        }
        catch (InterruptedException | ExecutionException e) {
            String error = e.getClass().getSimpleName();
            this.log(6, caller, error + " while waiting for transport: " + e.getMessage());
            return null;
        }
    }

    public IBackupTransport connectOrThrow(String caller) throws TransportNotAvailableException {
        IBackupTransport transport = this.connect(caller);
        if (transport == null) {
            this.log(6, caller, "Transport connection failed");
            throw new TransportNotAvailableException();
        }
        return transport;
    }

    public IBackupTransport getConnectedTransport(String caller) throws TransportNotAvailableException {
        IBackupTransport transport = this.mTransport;
        if (transport == null) {
            this.log(6, caller, "Transport not connected");
            throw new TransportNotAvailableException();
        }
        return transport;
    }

    public String toString() {
        return "TransportClient{" + this.mTransportComponent.flattenToShortString() + "#" + this.mIdentifier + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.mStateLock;
        synchronized (object) {
            this.mCloseGuard.warnIfOpen();
            if (this.mState >= 2) {
                String callerLogString = "TransportClient.finalize()";
                this.log(6, callerLogString, "Dangling TransportClient created in [" + this.mCreatorLogString + "] being GC'ed. Left bound, unbinding...");
                try {
                    this.unbind(callerLogString);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceConnected(IBinder binder) {
        IBackupTransport transport = IBackupTransport.Stub.asInterface(binder);
        Object object = this.mStateLock;
        synchronized (object) {
            this.checkStateIntegrityLocked();
            if (this.mState != 0) {
                this.log(3, "Transport connected");
                this.setStateLocked(3, transport);
                this.notifyListenersAndClearLocked(transport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceDisconnected() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.log(6, "Service disconnected: client UNUSABLE");
            this.setStateLocked(0, null);
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalArgumentException e) {
                this.log(5, "Exception trying to unbind onServiceDisconnected(): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBindingDied() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.checkStateIntegrityLocked();
            this.log(6, "Binding died: client UNUSABLE");
            switch (this.mState) {
                case 0: {
                    break;
                }
                case 1: {
                    this.log(6, "Unexpected state transition IDLE => UNUSABLE");
                    this.setStateLocked(0, null);
                    break;
                }
                case 2: {
                    this.setStateLocked(0, null);
                    this.mContext.unbindService(this.mConnection);
                    this.notifyListenersAndClearLocked(null);
                    break;
                }
                case 3: {
                    this.setStateLocked(0, null);
                    this.mContext.unbindService(this.mConnection);
                }
            }
        }
    }

    private void notifyListener(TransportConnectionListener listener, IBackupTransport transport, String caller) {
        String transportString = transport != null ? "IBackupTransport" : "null";
        this.log(4, "Notifying [" + caller + "] transport = " + transportString);
        this.mListenerHandler.post(() -> listener.onTransportConnectionResult(transport, this));
    }

    @GuardedBy(value="mStateLock")
    private void notifyListenersAndClearLocked(IBackupTransport transport) {
        for (Map.Entry<TransportConnectionListener, String> entry : this.mListeners.entrySet()) {
            TransportConnectionListener listener = entry.getKey();
            String caller = entry.getValue();
            this.notifyListener(listener, transport, caller);
        }
        this.mListeners.clear();
    }

    @GuardedBy(value="mStateLock")
    private void setStateLocked(int state, IBackupTransport transport) {
        this.log(2, "State: " + this.stateToString(this.mState) + " => " + this.stateToString(state));
        this.onStateTransition(this.mState, state);
        this.mState = state;
        this.mTransport = transport;
    }

    private void onStateTransition(int oldState, int newState) {
        int value;
        String transport = this.mTransportComponent.flattenToShortString();
        int bound = this.transitionThroughState(oldState, newState, 2);
        int connected = this.transitionThroughState(oldState, newState, 3);
        if (bound != 0) {
            value = bound == 1 ? 1 : 0;
            EventLog.writeEvent(2850, transport, value);
        }
        if (connected != 0) {
            value = connected == 1 ? 1 : 0;
            EventLog.writeEvent(2851, transport, value);
        }
    }

    private int transitionThroughState(int oldState, int newState, int stateReference) {
        if (oldState < stateReference && stateReference <= newState) {
            return 1;
        }
        if (oldState >= stateReference && stateReference > newState) {
            return -1;
        }
        return 0;
    }

    @GuardedBy(value="mStateLock")
    private void checkStateIntegrityLocked() {
        switch (this.mState) {
            case 0: {
                this.checkState(this.mListeners.isEmpty(), "Unexpected listeners when state = UNUSABLE");
                this.checkState(this.mTransport == null, "Transport expected to be null when state = UNUSABLE");
            }
            case 1: {
                this.checkState(this.mListeners.isEmpty(), "Unexpected listeners when state = IDLE");
                this.checkState(this.mTransport == null, "Transport expected to be null when state = IDLE");
                break;
            }
            case 2: {
                this.checkState(this.mTransport == null, "Transport expected to be null when state = BOUND_AND_CONNECTING");
                break;
            }
            case 3: {
                this.checkState(this.mListeners.isEmpty(), "Unexpected listeners when state = CONNECTED");
                this.checkState(this.mTransport != null, "Transport expected to be non-null when state = CONNECTED");
                break;
            }
            default: {
                this.checkState(false, "Unexpected state = " + this.stateToString(this.mState));
            }
        }
    }

    private void checkState(boolean assertion, String message) {
        if (!assertion) {
            this.log(6, message);
        }
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNUSABLE";
            }
            case 1: {
                return "IDLE";
            }
            case 2: {
                return "BOUND_AND_CONNECTING";
            }
            case 3: {
                return "CONNECTED";
            }
        }
        return "<UNKNOWN = " + state + ">";
    }

    private void log(int priority, String message) {
        TransportUtils.log(priority, TAG, TransportUtils.formatMessage(this.mPrefixForLog, null, message));
        this.saveLogEntry(TransportUtils.formatMessage(null, null, message));
    }

    private void log(int priority, String caller, String message) {
        TransportUtils.log(priority, TAG, TransportUtils.formatMessage(this.mPrefixForLog, caller, message));
        this.saveLogEntry(TransportUtils.formatMessage(null, caller, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogEntry(String message) {
        CharSequence time = DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", System.currentTimeMillis());
        message = time + " " + message;
        Object object = this.mLogBufferLock;
        synchronized (object) {
            if (this.mLogBuffer.size() == 5) {
                this.mLogBuffer.remove(this.mLogBuffer.size() - 1);
            }
            this.mLogBuffer.add(0, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getLogBuffer() {
        Object object = this.mLogBufferLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mLogBuffer);
        }
    }

    private static class TransportConnection
    implements ServiceConnection {
        private final Context mContext;
        private final WeakReference<TransportClient> mTransportClientRef;

        private TransportConnection(Context context, TransportClient transportClient) {
            this.mContext = context;
            this.mTransportClientRef = new WeakReference<TransportClient>(transportClient);
        }

        @Override
        public void onServiceConnected(ComponentName transportComponent, IBinder binder) {
            TransportClient transportClient = (TransportClient)this.mTransportClientRef.get();
            if (transportClient == null) {
                this.referenceLost("TransportConnection.onServiceConnected()");
                return;
            }
            transportClient.onServiceConnected(binder);
        }

        @Override
        public void onServiceDisconnected(ComponentName transportComponent) {
            TransportClient transportClient = (TransportClient)this.mTransportClientRef.get();
            if (transportClient == null) {
                this.referenceLost("TransportConnection.onServiceDisconnected()");
                return;
            }
            transportClient.onServiceDisconnected();
        }

        @Override
        public void onBindingDied(ComponentName transportComponent) {
            TransportClient transportClient = (TransportClient)this.mTransportClientRef.get();
            if (transportClient == null) {
                this.referenceLost("TransportConnection.onBindingDied()");
                return;
            }
            transportClient.onBindingDied();
        }

        private void referenceLost(String caller) {
            this.mContext.unbindService(this);
            TransportUtils.log(4, TransportClient.TAG, caller + " called but TransportClient reference has been GC'ed");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
        public static final int UNUSABLE = 0;
        public static final int IDLE = 1;
        public static final int BOUND_AND_CONNECTING = 2;
        public static final int CONNECTED = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Transition {
        public static final int DOWN = -1;
        public static final int NO_TRANSITION = 0;
        public static final int UP = 1;
    }
}

