/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupRestoreTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdbRestoreFinishedLatch
implements BackupRestoreTask {
    private static final String TAG = "AdbRestoreFinishedLatch";
    private BackupManagerService backupManagerService;
    final CountDownLatch mLatch;
    private final int mCurrentOpToken;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;

    public AdbRestoreFinishedLatch(BackupManagerService backupManagerService, int currentOpToken) {
        this.backupManagerService = backupManagerService;
        this.mLatch = new CountDownLatch(1);
        this.mCurrentOpToken = currentOpToken;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
    }

    void await() {
        boolean latched = false;
        long fullBackupAgentTimeoutMillis = this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
        try {
            latched = this.mLatch.await(fullBackupAgentTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Slog.w(TAG, "Interrupted!");
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void operationComplete(long result) {
        this.mLatch.countDown();
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }

    @Override
    public void handleCancel(boolean cancelAll) {
        Slog.w(TAG, "adb onRestoreFinished() timed out");
        this.mLatch.countDown();
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }
}

