/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.content.pm.PackageInfo;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.TransportManager;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.transport.TransportClient;
import java.io.File;

public class PerformClearTask
implements Runnable {
    private final BackupManagerService mBackupManagerService;
    private final TransportManager mTransportManager;
    private final TransportClient mTransportClient;
    private final PackageInfo mPackage;
    private final OnTaskFinishedListener mListener;

    PerformClearTask(BackupManagerService backupManagerService, TransportClient transportClient, PackageInfo packageInfo, OnTaskFinishedListener listener) {
        this.mBackupManagerService = backupManagerService;
        this.mTransportManager = backupManagerService.getTransportManager();
        this.mTransportClient = transportClient;
        this.mPackage = packageInfo;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String callerLogString = "PerformClearTask.run()";
        IBackupTransport transport = null;
        try {
            String transportDirName = this.mTransportManager.getTransportDirName(this.mTransportClient.getTransportComponent());
            File stateDir = new File(this.mBackupManagerService.getBaseStateDir(), transportDirName);
            File stateFile = new File(stateDir, this.mPackage.packageName);
            stateFile.delete();
            transport = this.mTransportClient.connectOrThrow(callerLogString);
            transport.clearBackupData(this.mPackage);
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Transport threw clearing data for " + this.mPackage + ": " + e.getMessage());
        }
        finally {
            if (transport != null) {
                try {
                    transport.finishBackup();
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Unable to mark clear operation finished: " + e.getMessage());
                }
            }
            this.mListener.onFinished(callerLogString);
            this.mBackupManagerService.getWakelock().release();
        }
    }
}

