/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.backup.transport.OnTransportRegisteredListener;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.transport.TransportClientManager;
import com.android.server.backup.transport.TransportNotAvailableException;
import com.android.server.backup.transport.TransportNotRegisteredException;
import com.android.server.backup.transport.TransportStats;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TransportManager {
    private static final String TAG = "BackupTransportManager";
    @VisibleForTesting
    public static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private final Intent mTransportServiceIntent = new Intent("android.backup.TRANSPORT_HOST");
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final Set<ComponentName> mTransportWhitelist;
    private final TransportClientManager mTransportClientManager;
    private final TransportStats mTransportStats;
    private OnTransportRegisteredListener mOnTransportRegisteredListener;
    private final Object mTransportLock;
    @GuardedBy(value="mTransportLock")
    private final Map<ComponentName, TransportDescription> mRegisteredTransportsDescriptionMap;
    @GuardedBy(value="mTransportLock")
    private volatile String mCurrentTransportName;

    TransportManager(Context context, Set<ComponentName> whitelist, String selectedTransport) {
        this.mOnTransportRegisteredListener = (c, n) -> {};
        this.mTransportLock = new Object();
        this.mRegisteredTransportsDescriptionMap = new ArrayMap<ComponentName, TransportDescription>();
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mTransportWhitelist = Preconditions.checkNotNull(whitelist);
        this.mCurrentTransportName = selectedTransport;
        this.mTransportStats = new TransportStats();
        this.mTransportClientManager = new TransportClientManager(context, this.mTransportStats);
    }

    @VisibleForTesting
    TransportManager(Context context, Set<ComponentName> whitelist, String selectedTransport, TransportClientManager transportClientManager) {
        this.mOnTransportRegisteredListener = (c, n) -> {};
        this.mTransportLock = new Object();
        this.mRegisteredTransportsDescriptionMap = new ArrayMap<ComponentName, TransportDescription>();
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mTransportWhitelist = Preconditions.checkNotNull(whitelist);
        this.mCurrentTransportName = selectedTransport;
        this.mTransportStats = new TransportStats();
        this.mTransportClientManager = transportClientManager;
    }

    public void setOnTransportRegisteredListener(OnTransportRegisteredListener listener) {
        this.mOnTransportRegisteredListener = listener;
    }

    void onPackageAdded(String packageName) {
        this.registerTransportsFromPackage(packageName, transportComponent -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageRemoved(String packageName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            this.mRegisteredTransportsDescriptionMap.keySet().removeIf(TransportManager.fromPackageFilter(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageChanged(String packageName, String ... components) {
        ArraySet<ComponentName> transportComponents = new ArraySet<ComponentName>(components.length);
        for (String componentName : components) {
            transportComponents.add(new ComponentName(packageName, componentName));
        }
        Object object = this.mTransportLock;
        synchronized (object) {
            this.mRegisteredTransportsDescriptionMap.keySet().removeIf(transportComponents::contains);
        }
        this.registerTransportsFromPackage(packageName, transportComponents::contains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName[] getRegisteredTransportComponents() {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.mRegisteredTransportsDescriptionMap.keySet().toArray(new ComponentName[this.mRegisteredTransportsDescriptionMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getRegisteredTransportNames() {
        Object object = this.mTransportLock;
        synchronized (object) {
            String[] transportNames = new String[this.mRegisteredTransportsDescriptionMap.size()];
            int i = 0;
            for (TransportDescription description : this.mRegisteredTransportsDescriptionMap.values()) {
                transportNames[i] = description.name;
                ++i;
            }
            return transportNames;
        }
    }

    Set<ComponentName> getTransportWhitelist() {
        return this.mTransportWhitelist;
    }

    String getCurrentTransportName() {
        return this.mCurrentTransportName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportName(ComponentName transportComponent) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportComponent).name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportDirName(ComponentName transportComponent) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportComponent).transportDirName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportDirName(String transportName) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportName).transportDirName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getTransportConfigurationIntent(String transportName) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportName).configurationIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportCurrentDestinationString(String transportName) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportName).currentDestinationString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getTransportDataManagementIntent(String transportName) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportName).dataManagementIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportDataManagementLabel(String transportName) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportDescriptionOrThrowLocked(transportName).dataManagementLabel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportRegistered(String transportName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getRegisteredTransportEntryLocked(transportName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachRegisteredTransport(Consumer<String> transportConsumer) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (TransportDescription transportDescription : this.mRegisteredTransportsDescriptionMap.values()) {
                transportConsumer.accept(transportDescription.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransportAttributes(ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, String dataManagementLabel) {
        Object object = this.mTransportLock;
        synchronized (object) {
            TransportDescription description = this.mRegisteredTransportsDescriptionMap.get(transportComponent);
            if (description == null) {
                Slog.e(TAG, "Transport " + name + " not registered tried to change description");
                return;
            }
            description.name = name;
            description.configurationIntent = configurationIntent;
            description.currentDestinationString = currentDestinationString;
            description.dataManagementIntent = dataManagementIntent;
            description.dataManagementLabel = dataManagementLabel;
            Slog.d(TAG, "Transport " + name + " updated its attributes");
        }
    }

    @GuardedBy(value="mTransportLock")
    private TransportDescription getRegisteredTransportDescriptionOrThrowLocked(ComponentName transportComponent) throws TransportNotRegisteredException {
        TransportDescription description = this.mRegisteredTransportsDescriptionMap.get(transportComponent);
        if (description == null) {
            throw new TransportNotRegisteredException(transportComponent);
        }
        return description;
    }

    @GuardedBy(value="mTransportLock")
    private TransportDescription getRegisteredTransportDescriptionOrThrowLocked(String transportName) throws TransportNotRegisteredException {
        TransportDescription description = this.getRegisteredTransportDescriptionLocked(transportName);
        if (description == null) {
            throw new TransportNotRegisteredException(transportName);
        }
        return description;
    }

    @GuardedBy(value="mTransportLock")
    private ComponentName getRegisteredTransportComponentLocked(String transportName) {
        Map.Entry<ComponentName, TransportDescription> entry = this.getRegisteredTransportEntryLocked(transportName);
        return entry == null ? null : entry.getKey();
    }

    @GuardedBy(value="mTransportLock")
    private TransportDescription getRegisteredTransportDescriptionLocked(String transportName) {
        Map.Entry<ComponentName, TransportDescription> entry = this.getRegisteredTransportEntryLocked(transportName);
        return entry == null ? null : entry.getValue();
    }

    @GuardedBy(value="mTransportLock")
    private Map.Entry<ComponentName, TransportDescription> getRegisteredTransportEntryLocked(String transportName) {
        for (Map.Entry<ComponentName, TransportDescription> entry : this.mRegisteredTransportsDescriptionMap.entrySet()) {
            TransportDescription description = entry.getValue();
            if (!transportName.equals(description.name)) continue;
            return entry;
        }
        return null;
    }

    public TransportClient getTransportClient(String transportName, String caller) {
        try {
            return this.getTransportClientOrThrow(transportName, caller);
        }
        catch (TransportNotRegisteredException e) {
            Slog.w(TAG, "Transport " + transportName + " not registered");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient getTransportClientOrThrow(String transportName, String caller) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            ComponentName component = this.getRegisteredTransportComponentLocked(transportName);
            if (component == null) {
                throw new TransportNotRegisteredException(transportName);
            }
            return this.mTransportClientManager.getTransportClient(component, caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient getCurrentTransportClient(String caller) {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getTransportClient(this.mCurrentTransportName, caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient getCurrentTransportClientOrThrow(String caller) throws TransportNotRegisteredException {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.getTransportClientOrThrow(this.mCurrentTransportName, caller);
        }
    }

    public void disposeOfTransportClient(TransportClient transportClient, String caller) {
        this.mTransportClientManager.disposeOfTransportClient(transportClient, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    String selectTransport(String transportName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            String prevTransport = this.mCurrentTransportName;
            this.mCurrentTransportName = transportName;
            return prevTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerAndSelectTransport(ComponentName transportComponent) {
        Object object = this.mTransportLock;
        synchronized (object) {
            try {
                this.selectTransport(this.getTransportName(transportComponent));
                return 0;
            }
            catch (TransportNotRegisteredException transportNotRegisteredException) {
            }
        }
        int result = this.registerTransport(transportComponent);
        if (result != 0) {
            return result;
        }
        Object object2 = this.mTransportLock;
        synchronized (object2) {
            try {
                this.selectTransport(this.getTransportName(transportComponent));
                return 0;
            }
            catch (TransportNotRegisteredException e) {
                Slog.wtf(TAG, "Transport got unregistered");
                return -1;
            }
        }
    }

    public void registerTransports() {
        this.registerTransportsForIntent(this.mTransportServiceIntent, transportComponent -> true);
    }

    private void registerTransportsFromPackage(String packageName, Predicate<ComponentName> transportComponentFilter) {
        try {
            this.mPackageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Trying to register transports from package not found " + packageName);
            return;
        }
        this.registerTransportsForIntent(new Intent(this.mTransportServiceIntent).setPackage(packageName), transportComponentFilter.and(TransportManager.fromPackageFilter(packageName)));
    }

    private void registerTransportsForIntent(Intent intent, Predicate<ComponentName> transportComponentFilter) {
        List<ResolveInfo> hosts = this.mPackageManager.queryIntentServicesAsUser(intent, 0, 0);
        if (hosts == null) {
            return;
        }
        for (ResolveInfo host : hosts) {
            ComponentName transportComponent = host.serviceInfo.getComponentName();
            if (!transportComponentFilter.test(transportComponent) || !this.isTransportTrusted(transportComponent)) continue;
            this.registerTransport(transportComponent);
        }
    }

    private boolean isTransportTrusted(ComponentName transport) {
        if (!this.mTransportWhitelist.contains(transport)) {
            Slog.w(TAG, "BackupTransport " + transport.flattenToShortString() + " not whitelisted.");
            return false;
        }
        try {
            PackageInfo packInfo = this.mPackageManager.getPackageInfo(transport.getPackageName(), 0);
            if ((packInfo.applicationInfo.privateFlags & 8) == 0) {
                Slog.w(TAG, "Transport package " + transport.getPackageName() + " not privileged");
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Package not found.", e);
            return false;
        }
        return true;
    }

    private int registerTransport(ComponentName transportComponent) {
        int result;
        IBackupTransport transport;
        this.checkCanUseTransport();
        if (!this.isTransportTrusted(transportComponent)) {
            return -2;
        }
        String transportString = transportComponent.flattenToShortString();
        String callerLogString = "TransportManager.registerTransport()";
        Bundle extras = new Bundle();
        extras.putBoolean("android.app.backup.extra.TRANSPORT_REGISTRATION", true);
        TransportClient transportClient = this.mTransportClientManager.getTransportClient(transportComponent, extras, callerLogString);
        try {
            transport = transportClient.connectOrThrow(callerLogString);
        }
        catch (TransportNotAvailableException e) {
            Slog.e(TAG, "Couldn't connect to transport " + transportString + " for registration");
            this.mTransportClientManager.disposeOfTransportClient(transportClient, callerLogString);
            return -1;
        }
        try {
            String transportName = transport.name();
            String transportDirName = transport.transportDirName();
            this.registerTransport(transportComponent, transport);
            Slog.d(TAG, "Transport " + transportString + " registered");
            this.mOnTransportRegisteredListener.onTransportRegistered(transportName, transportDirName);
            result = 0;
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Transport " + transportString + " died while registering");
            result = -1;
        }
        this.mTransportClientManager.disposeOfTransportClient(transportClient, callerLogString);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTransport(ComponentName transportComponent, IBackupTransport transport) throws RemoteException {
        this.checkCanUseTransport();
        TransportDescription description = new TransportDescription(transport.name(), transport.transportDirName(), transport.configurationIntent(), transport.currentDestinationString(), transport.dataManagementIntent(), transport.dataManagementLabel());
        Object object = this.mTransportLock;
        synchronized (object) {
            this.mRegisteredTransportsDescriptionMap.put(transportComponent, description);
        }
    }

    private void checkCanUseTransport() {
        Preconditions.checkState(!Thread.holdsLock(this.mTransportLock), "Can't call transport with transport lock held");
    }

    public void dumpTransportClients(PrintWriter pw) {
        this.mTransportClientManager.dump(pw);
    }

    public void dumpTransportStats(PrintWriter pw) {
        this.mTransportStats.dump(pw);
    }

    private static Predicate<ComponentName> fromPackageFilter(String packageName) {
        return transportComponent -> packageName.equals(transportComponent.getPackageName());
    }

    private static class TransportDescription {
        private String name;
        private final String transportDirName;
        private Intent configurationIntent;
        private String currentDestinationString;
        private Intent dataManagementIntent;
        private String dataManagementLabel;

        private TransportDescription(String name, String transportDirName, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, String dataManagementLabel) {
            this.name = name;
            this.transportDirName = transportDirName;
            this.configurationIntent = configurationIntent;
            this.currentDestinationString = currentDestinationString;
            this.dataManagementIntent = dataManagementIntent;
            this.dataManagementLabel = dataManagementLabel;
        }
    }
}

