/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;

final class ProcessedPackagesJournal {
    private static final String TAG = "ProcessedPackagesJournal";
    private static final String JOURNAL_FILE_NAME = "processed";
    private static final boolean DEBUG = true;
    @GuardedBy(value="mProcessedPackages")
    private final Set<String> mProcessedPackages = new HashSet<String>();
    private final File mStateDirectory;

    ProcessedPackagesJournal(File stateDirectory) {
        this.mStateDirectory = stateDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        Set<String> set = this.mProcessedPackages;
        synchronized (set) {
            this.loadFromDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasBeenProcessed(String packageName) {
        Set<String> set = this.mProcessedPackages;
        synchronized (set) {
            return this.mProcessedPackages.contains(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPackage(String packageName) {
        Set<String> set = this.mProcessedPackages;
        synchronized (set) {
            if (!this.mProcessedPackages.add(packageName)) {
                return;
            }
            File journalFile = new File(this.mStateDirectory, JOURNAL_FILE_NAME);
            try (RandomAccessFile out = new RandomAccessFile(journalFile, "rws");){
                out.seek(out.length());
                out.writeUTF(packageName);
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't log backup of " + packageName + " to " + journalFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getPackagesCopy() {
        Set<String> set = this.mProcessedPackages;
        synchronized (set) {
            return new HashSet<String>(this.mProcessedPackages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Set<String> set = this.mProcessedPackages;
        synchronized (set) {
            this.mProcessedPackages.clear();
            File journalFile = new File(this.mStateDirectory, JOURNAL_FILE_NAME);
            journalFile.delete();
        }
    }

    private void loadFromDisk() {
        File journalFile = new File(this.mStateDirectory, JOURNAL_FILE_NAME);
        if (!journalFile.exists()) {
            return;
        }
        try {
            DataInputStream oldJournal = new DataInputStream(new BufferedInputStream(new FileInputStream(journalFile)));
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        String packageName = oldJournal.readUTF();
                        Slog.v(TAG, "   + " + packageName);
                        this.mProcessedPackages.add(packageName);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                ProcessedPackagesJournal.$closeResource(throwable, oldJournal);
                throw throwable3;
            }
        }
        catch (EOFException oldJournal) {
        }
        catch (IOException e) {
            Slog.e(TAG, "Error reading processed packages journal", e);
        }
    }
}

