/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.service.autofill.SaveInfo;
import android.service.autofill.ValueFinder;
import android.text.TextUtils;
import android.util.Slog;
import android.view.KeyEvent;
import android.view.autofill.AutofillId;
import android.view.autofill.IAutofillWindowPresenter;
import android.widget.Toast;
import com.android.internal.logging.MetricsLogger;
import com.android.server.UiThread;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.FillUi;
import com.android.server.autofill.ui.OverlayControl;
import com.android.server.autofill.ui.PendingUi;
import com.android.server.autofill.ui.SaveUi;
import java.io.PrintWriter;

public final class AutoFillUI {
    private static final String TAG = "AutofillUI";
    private final Handler mHandler = UiThread.getHandler();
    private final Context mContext;
    private FillUi mFillUi;
    private SaveUi mSaveUi;
    private AutoFillUiCallback mCallback;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private final OverlayControl mOverlayControl;

    public AutoFillUI(Context context) {
        this.mContext = context;
        this.mOverlayControl = new OverlayControl(context);
    }

    public void setCallback(AutoFillUiCallback callback) {
        this.mHandler.post(() -> {
            if (this.mCallback != callback) {
                if (this.mCallback != null) {
                    this.hideAllUiThread(this.mCallback);
                }
                this.mCallback = callback;
            }
        });
    }

    public void clearCallback(AutoFillUiCallback callback) {
        this.mHandler.post(() -> {
            if (this.mCallback == callback) {
                this.hideAllUiThread(callback);
                this.mCallback = null;
            }
        });
    }

    public void showError(int resId, AutoFillUiCallback callback) {
        this.showError(this.mContext.getString(resId), callback);
    }

    public void showError(CharSequence message, AutoFillUiCallback callback) {
        Slog.w(TAG, "showError(): " + message);
        this.mHandler.post(() -> {
            if (this.mCallback != callback) {
                return;
            }
            this.hideAllUiThread(callback);
            if (!TextUtils.isEmpty(message)) {
                Toast.makeText(this.mContext, message, 1).show();
            }
        });
    }

    public void hideFillUi(AutoFillUiCallback callback) {
        this.mHandler.post(() -> this.hideFillUiUiThread(callback, true));
    }

    public void filterFillUi(String filterText, AutoFillUiCallback callback) {
        this.mHandler.post(() -> {
            if (callback != this.mCallback) {
                return;
            }
            if (this.mFillUi != null) {
                this.mFillUi.setFilterText(filterText);
            }
        });
    }

    public void showFillUi(final AutofillId focusedId, final FillResponse response, String filterText, String servicePackageName, ComponentName componentName, CharSequence serviceLabel, Drawable serviceIcon, final AutoFillUiCallback callback, int sessionId, boolean compatMode) {
        if (Helper.sDebug) {
            int size = filterText == null ? 0 : filterText.length();
            Slog.d(TAG, "showFillUi(): id=" + focusedId + ", filter=" + size + " chars");
        }
        final LogMaker log = Helper.newLogMaker(910, componentName, servicePackageName, sessionId, compatMode).addTaggedData(911, filterText == null ? 0 : filterText.length()).addTaggedData(909, response.getDatasets() == null ? 0 : response.getDatasets().size());
        this.mHandler.post(() -> {
            if (callback != this.mCallback) {
                return;
            }
            this.hideAllUiThread(callback);
            this.mFillUi = new FillUi(this.mContext, response, focusedId, filterText, this.mOverlayControl, serviceLabel, serviceIcon, new FillUi.Callback(){

                @Override
                public void onResponsePicked(FillResponse response2) {
                    log.setType(3);
                    AutoFillUI.this.hideFillUiUiThread(callback, true);
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.authenticate(response2.getRequestId(), 65535, response2.getAuthentication(), response2.getClientState());
                    }
                }

                @Override
                public void onDatasetPicked(Dataset dataset) {
                    log.setType(4);
                    AutoFillUI.this.hideFillUiUiThread(callback, true);
                    if (AutoFillUI.this.mCallback != null) {
                        int datasetIndex = response.getDatasets().indexOf(dataset);
                        AutoFillUI.this.mCallback.fill(response.getRequestId(), datasetIndex, dataset);
                    }
                }

                @Override
                public void onCanceled() {
                    log.setType(5);
                    AutoFillUI.this.hideFillUiUiThread(callback, true);
                }

                @Override
                public void onDestroy() {
                    if (log.getType() == 0) {
                        log.setType(2);
                    }
                    AutoFillUI.this.mMetricsLogger.write(log);
                }

                @Override
                public void requestShowFillUi(int width, int height, IAutofillWindowPresenter windowPresenter) {
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.requestShowFillUi(focusedId, width, height, windowPresenter);
                    }
                }

                @Override
                public void requestHideFillUi() {
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.requestHideFillUi(focusedId);
                    }
                }

                @Override
                public void startIntentSender(IntentSender intentSender) {
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.startIntentSender(intentSender);
                    }
                }

                @Override
                public void dispatchUnhandledKey(KeyEvent keyEvent) {
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.dispatchUnhandledKey(focusedId, keyEvent);
                    }
                }
            });
        });
    }

    public void showSaveUi(CharSequence serviceLabel, Drawable serviceIcon, String servicePackageName, SaveInfo info, ValueFinder valueFinder, ComponentName componentName, AutoFillUiCallback callback, final PendingUi pendingSaveUi, boolean compatMode) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "showSaveUi() for " + componentName.toShortString() + ": " + info);
        }
        int numIds = 0;
        numIds += info.getRequiredIds() == null ? 0 : info.getRequiredIds().length;
        final LogMaker log = Helper.newLogMaker(916, componentName, servicePackageName, pendingSaveUi.sessionId, compatMode).addTaggedData(917, numIds += info.getOptionalIds() == null ? 0 : info.getOptionalIds().length);
        this.mHandler.post(() -> {
            if (callback != this.mCallback) {
                return;
            }
            this.hideAllUiThread(callback);
            this.mSaveUi = new SaveUi(this.mContext, pendingSaveUi, serviceLabel, serviceIcon, servicePackageName, componentName, info, valueFinder, this.mOverlayControl, new SaveUi.OnSaveListener(){

                @Override
                public void onSave() {
                    log.setType(4);
                    AutoFillUI.this.hideSaveUiUiThread(AutoFillUI.this.mCallback);
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.save();
                    }
                    AutoFillUI.this.destroySaveUiUiThread(pendingSaveUi, true);
                }

                @Override
                public void onCancel(IntentSender listener) {
                    log.setType(5);
                    AutoFillUI.this.hideSaveUiUiThread(AutoFillUI.this.mCallback);
                    if (listener != null) {
                        try {
                            listener.sendIntent(AutoFillUI.this.mContext, 0, null, null, null);
                        }
                        catch (IntentSender.SendIntentException e) {
                            Slog.e(AutoFillUI.TAG, "Error starting negative action listener: " + listener, e);
                        }
                    }
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.cancelSave();
                    }
                    AutoFillUI.this.destroySaveUiUiThread(pendingSaveUi, true);
                }

                @Override
                public void onDestroy() {
                    if (log.getType() == 0) {
                        log.setType(2);
                        if (AutoFillUI.this.mCallback != null) {
                            AutoFillUI.this.mCallback.cancelSave();
                        }
                    }
                    AutoFillUI.this.mMetricsLogger.write(log);
                }
            }, compatMode);
        });
    }

    public void onPendingSaveUi(int operation, IBinder token) {
        this.mHandler.post(() -> {
            if (this.mSaveUi != null) {
                this.mSaveUi.onPendingUi(operation, token);
            } else {
                Slog.w(TAG, "onPendingSaveUi(" + operation + "): no save ui");
            }
        });
    }

    public void hideAll(AutoFillUiCallback callback) {
        this.mHandler.post(() -> this.hideAllUiThread(callback));
    }

    public void destroyAll(PendingUi pendingSaveUi, AutoFillUiCallback callback, boolean notifyClient) {
        this.mHandler.post(() -> this.destroyAllUiThread(pendingSaveUi, callback, notifyClient));
    }

    public void dump(PrintWriter pw) {
        pw.println("Autofill UI");
        String prefix = "  ";
        String prefix2 = "    ";
        if (this.mFillUi != null) {
            pw.print("  ");
            pw.println("showsFillUi: true");
            this.mFillUi.dump(pw, "    ");
        } else {
            pw.print("  ");
            pw.println("showsFillUi: false");
        }
        if (this.mSaveUi != null) {
            pw.print("  ");
            pw.println("showsSaveUi: true");
            this.mSaveUi.dump(pw, "    ");
        } else {
            pw.print("  ");
            pw.println("showsSaveUi: false");
        }
    }

    private void hideFillUiUiThread(AutoFillUiCallback callback, boolean notifyClient) {
        if (this.mFillUi != null && (callback == null || callback == this.mCallback)) {
            this.mFillUi.destroy(notifyClient);
            this.mFillUi = null;
        }
    }

    private PendingUi hideSaveUiUiThread(AutoFillUiCallback callback) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "hideSaveUiUiThread(): mSaveUi=" + this.mSaveUi + ", callback=" + callback + ", mCallback=" + this.mCallback);
        }
        if (this.mSaveUi != null && (callback == null || callback == this.mCallback)) {
            return this.mSaveUi.hide();
        }
        return null;
    }

    private void destroySaveUiUiThread(PendingUi pendingSaveUi, boolean notifyClient) {
        if (this.mSaveUi == null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "destroySaveUiUiThread(): already destroyed");
            }
            return;
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "destroySaveUiUiThread(): " + pendingSaveUi);
        }
        this.mSaveUi.destroy();
        this.mSaveUi = null;
        if (pendingSaveUi != null && notifyClient) {
            try {
                if (Helper.sDebug) {
                    Slog.d(TAG, "destroySaveUiUiThread(): notifying client");
                }
                pendingSaveUi.client.setSaveUiState(pendingSaveUi.sessionId, false);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error notifying client to set save UI state to hidden: " + e);
            }
        }
    }

    private void destroyAllUiThread(PendingUi pendingSaveUi, AutoFillUiCallback callback, boolean notifyClient) {
        this.hideFillUiUiThread(callback, notifyClient);
        this.destroySaveUiUiThread(pendingSaveUi, notifyClient);
    }

    private void hideAllUiThread(AutoFillUiCallback callback) {
        this.hideFillUiUiThread(callback, true);
        PendingUi pendingSaveUi = this.hideSaveUiUiThread(callback);
        if (pendingSaveUi != null && pendingSaveUi.getState() == 4) {
            if (Helper.sDebug) {
                Slog.d(TAG, "hideAllUiThread(): destroying Save UI because pending restoration is finished");
            }
            this.destroySaveUiUiThread(pendingSaveUi, true);
        }
    }

    public static interface AutoFillUiCallback {
        public void authenticate(int var1, int var2, IntentSender var3, Bundle var4);

        public void fill(int var1, int var2, Dataset var3);

        public void save();

        public void cancelSave();

        public void requestShowFillUi(AutofillId var1, int var2, int var3, IAutofillWindowPresenter var4);

        public void requestHideFillUi(AutofillId var1);

        public void startIntentSender(IntentSender var1);

        public void dispatchUnhandledKey(AutofillId var1, KeyEvent var2);
    }
}

