/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.os.Bundle;
import android.os.RemoteCallback;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.service.autofill.AutofillFieldClassificationService;
import com.android.internal.os.IResultReceiver;
import com.android.server.autofill.AutofillManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class AutofillManagerServiceShellCommand
extends ShellCommand {
    private final AutofillManagerService mService;

    public AutofillManagerServiceShellCommand(AutofillManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        switch (cmd) {
            case "list": {
                return this.requestList(pw);
            }
            case "destroy": {
                return this.requestDestroy(pw);
            }
            case "reset": {
                return this.requestReset();
            }
            case "get": {
                return this.requestGet(pw);
            }
            case "set": {
                return this.requestSet(pw);
            }
        }
        return this.handleDefaultCommands(cmd);
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("AutoFill Service (autofill) commands:");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  get log_level ");
            pw.println("    Gets the Autofill log level (off | debug | verbose).");
            pw.println("");
            pw.println("  get max_partitions");
            pw.println("    Gets the maximum number of partitions per session.");
            pw.println("");
            pw.println("  get max_visible_datasets");
            pw.println("    Gets the maximum number of visible datasets in the UI.");
            pw.println("");
            pw.println("  get full_screen_mode");
            pw.println("    Gets the Fill UI full screen mode");
            pw.println("");
            pw.println("  get fc_score [--algorithm ALGORITHM] value1 value2");
            pw.println("    Gets the field classification score for 2 fields.");
            pw.println("");
            pw.println("  get bind-instant-service-allowed");
            pw.println("    Gets whether binding to services provided by instant apps is allowed");
            pw.println("");
            pw.println("  set log_level [off | debug | verbose]");
            pw.println("    Sets the Autofill log level.");
            pw.println("");
            pw.println("  set max_partitions number");
            pw.println("    Sets the maximum number of partitions per session.");
            pw.println("");
            pw.println("  set max_visible_datasets number");
            pw.println("    Sets the maximum number of visible datasets in the UI.");
            pw.println("");
            pw.println("  set full_screen_mode [true | false | default]");
            pw.println("    Sets the Fill UI full screen mode");
            pw.println("");
            pw.println("  set bind-instant-service-allowed [true | false]");
            pw.println("    Sets whether binding to services provided by instant apps is allowed");
            pw.println("");
            pw.println("  list sessions [--user USER_ID]");
            pw.println("    Lists all pending sessions.");
            pw.println("");
            pw.println("  destroy sessions [--user USER_ID]");
            pw.println("    Destroys all pending sessions.");
            pw.println("");
            pw.println("  reset");
            pw.println("    Resets all pending sessions and cached service connections.");
            pw.println("");
        }
    }

    private int requestGet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "log_level": {
                return this.getLogLevel(pw);
            }
            case "max_partitions": {
                return this.getMaxPartitions(pw);
            }
            case "max_visible_datasets": {
                return this.getMaxVisibileDatasets(pw);
            }
            case "fc_score": {
                return this.getFieldClassificationScore(pw);
            }
            case "full_screen_mode": {
                return this.getFullScreenMode(pw);
            }
            case "bind-instant-service-allowed": {
                return this.getBindInstantService(pw);
            }
        }
        pw.println("Invalid set: " + what);
        return -1;
    }

    private int requestSet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "log_level": {
                return this.setLogLevel(pw);
            }
            case "max_partitions": {
                return this.setMaxPartitions();
            }
            case "max_visible_datasets": {
                return this.setMaxVisibileDatasets();
            }
            case "full_screen_mode": {
                return this.setFullScreenMode(pw);
            }
            case "bind-instant-service-allowed": {
                return this.setBindInstantService(pw);
            }
        }
        pw.println("Invalid set: " + what);
        return -1;
    }

    private int getLogLevel(PrintWriter pw) {
        int logLevel = this.mService.getLogLevel();
        switch (logLevel) {
            case 4: {
                pw.println("verbose");
                return 0;
            }
            case 2: {
                pw.println("debug");
                return 0;
            }
            case 0: {
                pw.println("off");
                return 0;
            }
        }
        pw.println("unknow (" + logLevel + ")");
        return 0;
    }

    private int setLogLevel(PrintWriter pw) {
        String logLevel = this.getNextArgRequired();
        switch (logLevel.toLowerCase()) {
            case "verbose": {
                this.mService.setLogLevel(4);
                return 0;
            }
            case "debug": {
                this.mService.setLogLevel(2);
                return 0;
            }
            case "off": {
                this.mService.setLogLevel(0);
                return 0;
            }
        }
        pw.println("Invalid level: " + logLevel);
        return -1;
    }

    private int getMaxPartitions(PrintWriter pw) {
        pw.println(this.mService.getMaxPartitions());
        return 0;
    }

    private int setMaxPartitions() {
        this.mService.setMaxPartitions(Integer.parseInt(this.getNextArgRequired()));
        return 0;
    }

    private int getMaxVisibileDatasets(PrintWriter pw) {
        pw.println(this.mService.getMaxVisibleDatasets());
        return 0;
    }

    private int setMaxVisibileDatasets() {
        this.mService.setMaxVisibleDatasets(Integer.parseInt(this.getNextArgRequired()));
        return 0;
    }

    private int getFieldClassificationScore(PrintWriter pw) {
        String value1;
        String algorithm;
        String nextArg = this.getNextArgRequired();
        if ("--algorithm".equals(nextArg)) {
            algorithm = this.getNextArgRequired();
            value1 = this.getNextArgRequired();
        } else {
            algorithm = null;
            value1 = nextArg;
        }
        String value2 = this.getNextArgRequired();
        CountDownLatch latch = new CountDownLatch(1);
        this.mService.getScore(algorithm, value1, value2, new RemoteCallback(result -> {
            AutofillFieldClassificationService.Scores scores = (AutofillFieldClassificationService.Scores)result.getParcelable("scores");
            if (scores == null) {
                pw.println("no score");
            } else {
                pw.println(scores.scores[0][0]);
            }
            latch.countDown();
        }));
        return this.waitForLatch(pw, latch);
    }

    private int getFullScreenMode(PrintWriter pw) {
        Boolean mode = this.mService.getFullScreenMode();
        if (mode == null) {
            pw.println("default");
        } else if (mode.booleanValue()) {
            pw.println("true");
        } else {
            pw.println("false");
        }
        return 0;
    }

    private int setFullScreenMode(PrintWriter pw) {
        String mode = this.getNextArgRequired();
        switch (mode.toLowerCase()) {
            case "true": {
                this.mService.setFullScreenMode(Boolean.TRUE);
                return 0;
            }
            case "false": {
                this.mService.setFullScreenMode(Boolean.FALSE);
                return 0;
            }
            case "default": {
                this.mService.setFullScreenMode(null);
                return 0;
            }
        }
        pw.println("Invalid mode: " + mode);
        return -1;
    }

    private int getBindInstantService(PrintWriter pw) {
        if (this.mService.getAllowInstantService()) {
            pw.println("true");
        } else {
            pw.println("false");
        }
        return 0;
    }

    private int setBindInstantService(PrintWriter pw) {
        String mode = this.getNextArgRequired();
        switch (mode.toLowerCase()) {
            case "true": {
                this.mService.setAllowInstantService(true);
                return 0;
            }
            case "false": {
                this.mService.setAllowInstantService(false);
                return 0;
            }
        }
        pw.println("Invalid mode: " + mode);
        return -1;
    }

    private int requestDestroy(PrintWriter pw) {
        if (!this.isNextArgSessions(pw)) {
            return -1;
        }
        int userId = this.getUserIdFromArgsOrAllUsers();
        final CountDownLatch latch = new CountDownLatch(1);
        IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) {
                latch.countDown();
            }
        };
        return this.requestSessionCommon(pw, latch, () -> this.mService.destroySessions(userId, receiver));
    }

    private int requestList(final PrintWriter pw) {
        if (!this.isNextArgSessions(pw)) {
            return -1;
        }
        int userId = this.getUserIdFromArgsOrAllUsers();
        final CountDownLatch latch = new CountDownLatch(1);
        IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) {
                ArrayList<String> sessions = resultData.getStringArrayList("sessions");
                for (String session : sessions) {
                    pw.println(session);
                }
                latch.countDown();
            }
        };
        return this.requestSessionCommon(pw, latch, () -> this.mService.listSessions(userId, receiver));
    }

    private boolean isNextArgSessions(PrintWriter pw) {
        String type = this.getNextArgRequired();
        if (!type.equals("sessions")) {
            pw.println("Error: invalid list type");
            return false;
        }
        return true;
    }

    private int requestSessionCommon(PrintWriter pw, CountDownLatch latch, Runnable command) {
        command.run();
        return this.waitForLatch(pw, latch);
    }

    private int waitForLatch(PrintWriter pw, CountDownLatch latch) {
        try {
            boolean received = latch.await(5L, TimeUnit.SECONDS);
            if (!received) {
                pw.println("Timed out after 5 seconds");
                return -1;
            }
        }
        catch (InterruptedException e) {
            pw.println("System call interrupted");
            Thread.currentThread().interrupt();
            return -1;
        }
        return 0;
    }

    private int requestReset() {
        this.mService.reset();
        return 0;
    }

    private int getUserIdFromArgsOrAllUsers() {
        if ("--user".equals(this.getNextArg())) {
            return UserHandle.parseUserArg(this.getNextArgRequired());
        }
        return -1;
    }
}

