/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.os.Process;
import android.service.vr.IPersistentVrStateCallbacks;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.vr.VrManagerInternal;

final class VrController {
    private static final String TAG = "VrController";
    private static final int FLAG_NON_VR_MODE = 0;
    private static final int FLAG_VR_MODE = 1;
    private static final int FLAG_PERSISTENT_VR_MODE = 2;
    private static int[] ORIG_ENUMS = new int[]{0, 1, 2};
    private static int[] PROTO_ENUMS = new int[]{0, 1, 2};
    private int mVrState = 0;
    private int mVrRenderThreadTid = 0;
    private final Object mGlobalAmLock;
    private final IPersistentVrStateCallbacks mPersistentVrModeListener = new IPersistentVrStateCallbacks.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPersistentVrStateChanged(boolean enabled) {
            Object object = VrController.this.mGlobalAmLock;
            synchronized (object) {
                if (enabled) {
                    VrController.this.setVrRenderThreadLocked(0, 3, true);
                    VrController.this.mVrState |= 2;
                } else {
                    VrController.this.setPersistentVrRenderThreadLocked(0, true);
                    VrController.this.mVrState &= -3;
                }
            }
        }
    };

    public VrController(Object globalAmLock) {
        this.mGlobalAmLock = globalAmLock;
    }

    public void onSystemReady() {
        VrManagerInternal vrManagerInternal = LocalServices.getService(VrManagerInternal.class);
        if (vrManagerInternal != null) {
            vrManagerInternal.addPersistentVrModeStateListener(this.mPersistentVrModeListener);
        }
    }

    public void onTopProcChangedLocked(ProcessRecord proc) {
        if (proc.curSchedGroup == 3) {
            this.setVrRenderThreadLocked(proc.vrThreadTid, proc.curSchedGroup, true);
        } else if (proc.vrThreadTid == this.mVrRenderThreadTid) {
            this.clearVrRenderThreadLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onVrModeChanged(ActivityRecord record) {
        ComponentName callingPackage;
        int userId;
        ComponentName requestedPackage;
        boolean vrMode;
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        if (vrService == null) {
            return false;
        }
        int processId = -1;
        boolean changed = false;
        Object object = this.mGlobalAmLock;
        synchronized (object) {
            vrMode = record.requestedVrComponent != null;
            requestedPackage = record.requestedVrComponent;
            userId = record.userId;
            callingPackage = record.info.getComponentName();
            changed = this.changeVrModeLocked(vrMode, record.app);
            if (record.app != null) {
                processId = record.app.pid;
            }
        }
        vrService.setVrMode(vrMode, requestedPackage, userId, processId, callingPackage);
        return changed;
    }

    public void setVrThreadLocked(int tid, int pid, ProcessRecord proc) {
        if (this.hasPersistentVrFlagSet()) {
            Slog.w(TAG, "VR thread cannot be set in persistent VR mode!");
            return;
        }
        if (proc == null) {
            Slog.w(TAG, "Persistent VR thread not set, calling process doesn't exist!");
            return;
        }
        if (tid != 0) {
            this.enforceThreadInProcess(tid, pid);
        }
        if (!this.inVrMode()) {
            Slog.w(TAG, "VR thread cannot be set when not in VR mode!");
        } else {
            this.setVrRenderThreadLocked(tid, proc.curSchedGroup, false);
        }
        proc.vrThreadTid = tid > 0 ? tid : 0;
    }

    public void setPersistentVrThreadLocked(int tid, int pid, ProcessRecord proc) {
        if (!this.hasPersistentVrFlagSet()) {
            Slog.w(TAG, "Persistent VR thread may only be set in persistent VR mode!");
            return;
        }
        if (proc == null) {
            Slog.w(TAG, "Persistent VR thread not set, calling process doesn't exist!");
            return;
        }
        if (tid != 0) {
            this.enforceThreadInProcess(tid, pid);
        }
        this.setPersistentVrRenderThreadLocked(tid, false);
    }

    public boolean shouldDisableNonVrUiLocked() {
        return this.mVrState != 0;
    }

    private boolean changeVrModeLocked(boolean vrMode, ProcessRecord proc) {
        boolean changed;
        int oldVrState = this.mVrState;
        this.mVrState = vrMode ? (this.mVrState |= 1) : (this.mVrState &= 0xFFFFFFFE);
        boolean bl = changed = oldVrState != this.mVrState;
        if (changed) {
            if (proc != null) {
                if (proc.vrThreadTid > 0) {
                    this.setVrRenderThreadLocked(proc.vrThreadTid, proc.curSchedGroup, false);
                }
            } else {
                this.clearVrRenderThreadLocked(false);
            }
        }
        return changed;
    }

    private int updateVrRenderThreadLocked(int newTid, boolean suppressLogs) {
        if (this.mVrRenderThreadTid == newTid) {
            return this.mVrRenderThreadTid;
        }
        if (this.mVrRenderThreadTid > 0) {
            ActivityManagerService.scheduleAsRegularPriority(this.mVrRenderThreadTid, suppressLogs);
            this.mVrRenderThreadTid = 0;
        }
        if (newTid > 0) {
            this.mVrRenderThreadTid = newTid;
            ActivityManagerService.scheduleAsFifoPriority(this.mVrRenderThreadTid, suppressLogs);
        }
        return this.mVrRenderThreadTid;
    }

    private int setPersistentVrRenderThreadLocked(int newTid, boolean suppressLogs) {
        if (!this.hasPersistentVrFlagSet()) {
            if (!suppressLogs) {
                Slog.w(TAG, "Failed to set persistent VR thread, system not in persistent VR mode.");
            }
            return this.mVrRenderThreadTid;
        }
        return this.updateVrRenderThreadLocked(newTid, suppressLogs);
    }

    private int setVrRenderThreadLocked(int newTid, int schedGroup, boolean suppressLogs) {
        boolean inVr = this.inVrMode();
        boolean inPersistentVr = this.hasPersistentVrFlagSet();
        if (!inVr || inPersistentVr || schedGroup != 3) {
            if (!suppressLogs) {
                String reason = "caller is not the current top application.";
                if (!inVr) {
                    reason = "system not in VR mode.";
                } else if (inPersistentVr) {
                    reason = "system in persistent VR mode.";
                }
                Slog.w(TAG, "Failed to set VR thread, " + reason);
            }
            return this.mVrRenderThreadTid;
        }
        return this.updateVrRenderThreadLocked(newTid, suppressLogs);
    }

    private void clearVrRenderThreadLocked(boolean suppressLogs) {
        this.updateVrRenderThreadLocked(0, suppressLogs);
    }

    private void enforceThreadInProcess(int tid, int pid) {
        if (!Process.isThreadInProcess(pid, tid)) {
            throw new IllegalArgumentException("VR thread does not belong to process");
        }
    }

    private boolean inVrMode() {
        return (this.mVrState & 1) != 0;
    }

    private boolean hasPersistentVrFlagSet() {
        return (this.mVrState & 2) != 0;
    }

    public String toString() {
        return String.format("[VrState=0x%x,VrRenderThreadTid=%d]", this.mVrState, this.mVrRenderThreadTid);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        ProtoUtils.writeBitWiseFlagsToProtoEnum(proto, 2259152797697L, this.mVrState, ORIG_ENUMS, PROTO_ENUMS);
        proto.write(1120986464258L, this.mVrRenderThreadTid);
        proto.end(token);
    }
}

