/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTaskImpl;
import com.android.server.am.TaskPersister;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserController;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class RecentTasks {
    private static final String TAG = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final boolean TRIMMED = true;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    private static final boolean MOVE_AFFILIATED_TASKS_TO_FRONT = false;
    private static final Comparator<TaskRecord> TASK_ID_COMPARATOR = (lhs, rhs) -> rhs.taskId - lhs.taskId;
    private static final ActivityInfo NO_ACTIVITY_INFO_TOKEN = new ActivityInfo();
    private static final ApplicationInfo NO_APPLICATION_INFO_TOKEN = new ApplicationInfo();
    private final TaskPersister mTaskPersister;
    private final ActivityManagerService mService;
    private final UserController mUserController;
    private int mRecentsUid = -1;
    private ComponentName mRecentsComponent = null;
    private final SparseBooleanArray mUsersWithRecentsLoaded = new SparseBooleanArray(5);
    private final SparseArray<SparseBooleanArray> mPersistedTaskIds = new SparseArray(5);
    private final ArrayList<TaskRecord> mTasks = new ArrayList();
    private final ArrayList<Callbacks> mCallbacks = new ArrayList();
    private boolean mHasVisibleRecentTasks;
    private int mGlobalMaxNumTasks;
    private int mMinNumVisibleTasks;
    private int mMaxNumVisibleTasks;
    private long mActiveTasksSessionDurationMs;
    private final ArrayList<TaskRecord> mTmpRecents = new ArrayList();
    private final HashMap<ComponentName, ActivityInfo> mTmpAvailActCache = new HashMap();
    private final HashMap<String, ApplicationInfo> mTmpAvailAppCache = new HashMap();
    private final SparseBooleanArray mTmpQuietProfileUserIds = new SparseBooleanArray();
    private final TaskRecord.TaskActivitiesReport mTmpReport = new TaskRecord.TaskActivitiesReport();

    @VisibleForTesting
    RecentTasks(ActivityManagerService service, TaskPersister taskPersister, UserController userController) {
        this.mService = service;
        this.mUserController = userController;
        this.mTaskPersister = taskPersister;
        this.mGlobalMaxNumTasks = ActivityManager.getMaxRecentTasksStatic();
        this.mHasVisibleRecentTasks = true;
    }

    RecentTasks(ActivityManagerService service, ActivityStackSupervisor stackSupervisor) {
        File systemDir = Environment.getDataSystemDirectory();
        Resources res = service.mContext.getResources();
        this.mService = service;
        this.mUserController = service.mUserController;
        this.mTaskPersister = new TaskPersister(systemDir, stackSupervisor, service, this);
        this.mGlobalMaxNumTasks = ActivityManager.getMaxRecentTasksStatic();
        this.mHasVisibleRecentTasks = res.getBoolean(17956984);
        this.loadParametersFromResources(res);
    }

    @VisibleForTesting
    void setParameters(int minNumVisibleTasks, int maxNumVisibleTasks, long activeSessionDurationMs) {
        this.mMinNumVisibleTasks = minNumVisibleTasks;
        this.mMaxNumVisibleTasks = maxNumVisibleTasks;
        this.mActiveTasksSessionDurationMs = activeSessionDurationMs;
    }

    @VisibleForTesting
    void setGlobalMaxNumTasks(int globalMaxNumTasks) {
        this.mGlobalMaxNumTasks = globalMaxNumTasks;
    }

    @VisibleForTesting
    void loadParametersFromResources(Resources res) {
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mMinNumVisibleTasks = res.getInteger(17694818);
            this.mMaxNumVisibleTasks = res.getInteger(17694810);
        } else if (SystemProperties.getBoolean("ro.recents.grid", false)) {
            this.mMinNumVisibleTasks = res.getInteger(17694817);
            this.mMaxNumVisibleTasks = res.getInteger(17694809);
        } else {
            this.mMinNumVisibleTasks = res.getInteger(17694816);
            this.mMaxNumVisibleTasks = res.getInteger(17694808);
        }
        int sessionDurationHrs = res.getInteger(17694728);
        this.mActiveTasksSessionDurationMs = sessionDurationHrs > 0 ? TimeUnit.HOURS.toMillis(sessionDurationHrs) : -1L;
    }

    void loadRecentsComponent(Resources res) {
        String rawRecentsComponent = res.getString(17039708);
        if (TextUtils.isEmpty(rawRecentsComponent)) {
            return;
        }
        ComponentName cn = ComponentName.unflattenFromString(rawRecentsComponent);
        if (cn != null) {
            try {
                ApplicationInfo appInfo = AppGlobals.getPackageManager().getApplicationInfo(cn.getPackageName(), 0, this.mService.mContext.getUserId());
                if (appInfo != null) {
                    this.mRecentsUid = appInfo.uid;
                    this.mRecentsComponent = cn;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Could not load application info for recents component: " + cn);
            }
        }
    }

    boolean isCallerRecents(int callingUid) {
        return UserHandle.isSameApp(callingUid, this.mRecentsUid);
    }

    boolean isRecentsComponent(ComponentName cn, int uid) {
        return cn.equals(this.mRecentsComponent) && UserHandle.isSameApp(uid, this.mRecentsUid);
    }

    boolean isRecentsComponentHomeActivity(int userId) {
        ComponentName defaultHomeActivity = this.mService.getPackageManagerInternalLocked().getDefaultHomeActivity(userId);
        return defaultHomeActivity != null && this.mRecentsComponent != null && defaultHomeActivity.getPackageName().equals(this.mRecentsComponent.getPackageName());
    }

    ComponentName getRecentsComponent() {
        return this.mRecentsComponent;
    }

    int getRecentsComponentUid() {
        return this.mRecentsUid;
    }

    void registerCallback(Callbacks callback) {
        this.mCallbacks.add(callback);
    }

    void unregisterCallback(Callbacks callback) {
        this.mCallbacks.remove(callback);
    }

    private void notifyTaskAdded(TaskRecord task) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            this.mCallbacks.get(i).onRecentTaskAdded(task);
        }
    }

    private void notifyTaskRemoved(TaskRecord task, boolean wasTrimmed) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            this.mCallbacks.get(i).onRecentTaskRemoved(task, wasTrimmed);
        }
    }

    void loadUserRecentsLocked(int userId) {
        if (this.mUsersWithRecentsLoaded.get(userId)) {
            return;
        }
        this.loadPersistedTaskIdsForUserLocked(userId);
        SparseBooleanArray preaddedTasks = new SparseBooleanArray();
        for (TaskRecord task : this.mTasks) {
            if (task.userId != userId || !RecentTasks.shouldPersistTaskLocked(task)) continue;
            preaddedTasks.put(task.taskId, true);
        }
        Slog.i("ActivityManager", "Loading recents for user " + userId + " into memory.");
        this.mTasks.addAll(this.mTaskPersister.restoreTasksForUserLocked(userId, preaddedTasks));
        this.cleanupLocked(userId);
        this.mUsersWithRecentsLoaded.put(userId, true);
        if (preaddedTasks.size() > 0) {
            this.syncPersistentTaskIdsLocked();
        }
    }

    private void loadPersistedTaskIdsForUserLocked(int userId) {
        if (this.mPersistedTaskIds.get(userId) == null) {
            this.mPersistedTaskIds.put(userId, this.mTaskPersister.loadPersistedTaskIdsForUser(userId));
            Slog.i("ActivityManager", "Loaded persisted task ids for user " + userId);
        }
    }

    boolean containsTaskId(int taskId, int userId) {
        this.loadPersistedTaskIdsForUserLocked(userId);
        return this.mPersistedTaskIds.get(userId).get(taskId);
    }

    SparseBooleanArray getTaskIdsForUser(int userId) {
        this.loadPersistedTaskIdsForUserLocked(userId);
        return this.mPersistedTaskIds.get(userId);
    }

    void notifyTaskPersisterLocked(TaskRecord task, boolean flush) {
        ActivityStack stack;
        ActivityStack activityStack = stack = task != null ? (ActivityStack)task.getStack() : null;
        if (stack != null && stack.isHomeOrRecentsStack()) {
            return;
        }
        this.syncPersistentTaskIdsLocked();
        this.mTaskPersister.wakeup(task, flush);
    }

    private void syncPersistentTaskIdsLocked() {
        int i;
        for (i = this.mPersistedTaskIds.size() - 1; i >= 0; --i) {
            int userId = this.mPersistedTaskIds.keyAt(i);
            if (!this.mUsersWithRecentsLoaded.get(userId)) continue;
            this.mPersistedTaskIds.valueAt(i).clear();
        }
        for (i = this.mTasks.size() - 1; i >= 0; --i) {
            TaskRecord task = this.mTasks.get(i);
            if (!RecentTasks.shouldPersistTaskLocked(task)) continue;
            if (this.mPersistedTaskIds.get(task.userId) == null) {
                Slog.wtf("ActivityManager", "No task ids found for userId " + task.userId + ". task=" + task + " mPersistedTaskIds=" + this.mPersistedTaskIds);
                this.mPersistedTaskIds.put(task.userId, new SparseBooleanArray());
            }
            this.mPersistedTaskIds.get(task.userId).put(task.taskId, true);
        }
    }

    private static boolean shouldPersistTaskLocked(TaskRecord task) {
        Object stack = task.getStack();
        return task.isPersistable && (stack == null || !((ActivityStack)stack).isHomeOrRecentsStack());
    }

    void onSystemReadyLocked() {
        this.loadRecentsComponent(this.mService.mContext.getResources());
        this.mTasks.clear();
        this.mTaskPersister.startPersisting();
    }

    Bitmap getTaskDescriptionIcon(String path) {
        return this.mTaskPersister.getTaskDescriptionIcon(path);
    }

    void saveImage(Bitmap image, String path) {
        this.mTaskPersister.saveImage(image, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.syncPersistentTaskIdsLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        this.mTaskPersister.flush();
    }

    int[] usersWithRecentsLoadedLocked() {
        int[] usersWithRecentsLoaded = new int[this.mUsersWithRecentsLoaded.size()];
        int len = 0;
        for (int i = 0; i < usersWithRecentsLoaded.length; ++i) {
            int userId = this.mUsersWithRecentsLoaded.keyAt(i);
            if (!this.mUsersWithRecentsLoaded.valueAt(i)) continue;
            usersWithRecentsLoaded[len++] = userId;
        }
        if (len < usersWithRecentsLoaded.length) {
            return Arrays.copyOf(usersWithRecentsLoaded, len);
        }
        return usersWithRecentsLoaded;
    }

    void unloadUserDataFromMemoryLocked(int userId) {
        if (this.mUsersWithRecentsLoaded.get(userId)) {
            Slog.i("ActivityManager", "Unloading recents for user " + userId + " from memory.");
            this.mUsersWithRecentsLoaded.delete(userId);
            this.removeTasksForUserLocked(userId);
        }
        this.mPersistedTaskIds.delete(userId);
        this.mTaskPersister.unloadUserDataFromMemory(userId);
    }

    private void removeTasksForUserLocked(int userId) {
        if (userId <= 0) {
            Slog.i("ActivityManager", "Can't remove recent task on user " + userId);
            return;
        }
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            TaskRecord tr = this.mTasks.get(i);
            if (tr.userId != userId) continue;
            this.remove(this.mTasks.get(i));
        }
    }

    void onPackagesSuspendedChanged(String[] packages, boolean suspended, int userId) {
        HashSet<String> packageNames = Sets.newHashSet(packages);
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            TaskRecord tr = this.mTasks.get(i);
            if (tr.realActivity == null || !packageNames.contains(tr.realActivity.getPackageName()) || tr.userId != userId || tr.realActivitySuspended == suspended) continue;
            tr.realActivitySuspended = suspended;
            if (suspended) {
                this.mService.mStackSupervisor.removeTaskByIdLocked(tr.taskId, false, true, "suspended-package");
            }
            this.notifyTaskPersisterLocked(tr, false);
        }
    }

    void onLockTaskModeStateChanged(int lockTaskModeState, int userId) {
        if (lockTaskModeState != 1) {
            return;
        }
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            TaskRecord tr = this.mTasks.get(i);
            if (tr.userId != userId || this.mService.getLockTaskController().isTaskWhitelisted(tr)) continue;
            this.remove(tr);
        }
    }

    void removeTasksByPackageName(String packageName, int userId) {
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            TaskRecord tr = this.mTasks.get(i);
            String taskPackageName = tr.getBaseIntent().getComponent().getPackageName();
            if (tr.userId != userId || !taskPackageName.equals(packageName)) continue;
            this.mService.mStackSupervisor.removeTaskByIdLocked(tr.taskId, true, true, "remove-package-task");
        }
    }

    void cleanupDisabledPackageTasksLocked(String packageName, Set<String> filterByClasses, int userId) {
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            boolean sameComponent;
            TaskRecord tr = this.mTasks.get(i);
            if (userId != -1 && tr.userId != userId) continue;
            ComponentName cn = tr.intent != null ? tr.intent.getComponent() : null;
            boolean bl = sameComponent = cn != null && cn.getPackageName().equals(packageName) && (filterByClasses == null || filterByClasses.contains(cn.getClassName()));
            if (!sameComponent) continue;
            this.mService.mStackSupervisor.removeTaskByIdLocked(tr.taskId, false, true, "disabled-package");
        }
    }

    void cleanupLocked(int userId) {
        int i;
        int recentsCount = this.mTasks.size();
        if (recentsCount == 0) {
            return;
        }
        this.mTmpAvailActCache.clear();
        this.mTmpAvailAppCache.clear();
        IPackageManager pm = AppGlobals.getPackageManager();
        for (i = recentsCount - 1; i >= 0; --i) {
            TaskRecord task = this.mTasks.get(i);
            if (userId != -1 && task.userId != userId) continue;
            if (task.autoRemoveRecents && task.getTopActivity() == null) {
                this.mTasks.remove(i);
                this.notifyTaskRemoved(task, false);
                Slog.w("ActivityManager", "Removing auto-remove without activity: " + task);
                continue;
            }
            if (task.realActivity == null) continue;
            ActivityInfo ai = this.mTmpAvailActCache.get(task.realActivity);
            if (ai == null) {
                try {
                    ai = pm.getActivityInfo(task.realActivity, 0x10000400, userId);
                }
                catch (RemoteException e) {
                    continue;
                }
                if (ai == null) {
                    ai = NO_ACTIVITY_INFO_TOKEN;
                }
                this.mTmpAvailActCache.put(task.realActivity, ai);
            }
            if (ai == NO_ACTIVITY_INFO_TOKEN) {
                ApplicationInfo app = this.mTmpAvailAppCache.get(task.realActivity.getPackageName());
                if (app == null) {
                    try {
                        app = pm.getApplicationInfo(task.realActivity.getPackageName(), 8192, userId);
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    if (app == null) {
                        app = NO_APPLICATION_INFO_TOKEN;
                    }
                    this.mTmpAvailAppCache.put(task.realActivity.getPackageName(), app);
                }
                if (app == NO_APPLICATION_INFO_TOKEN || (app.flags & 0x800000) == 0) {
                    this.mTasks.remove(i);
                    this.notifyTaskRemoved(task, false);
                    Slog.w("ActivityManager", "Removing no longer valid recent: " + task);
                    continue;
                }
                task.isAvailable = false;
                continue;
            }
            task.isAvailable = ai.enabled && ai.applicationInfo.enabled && (ai.applicationInfo.flags & 0x800000) != 0;
        }
        i = 0;
        recentsCount = this.mTasks.size();
        while (i < recentsCount) {
            i = this.processNextAffiliateChainLocked(i);
        }
    }

    private boolean canAddTaskWithoutTrim(TaskRecord task) {
        return this.findRemoveIndexForAddTask(task) == -1;
    }

    ArrayList<IBinder> getAppTasksList(int callingUid, String callingPackage) {
        ArrayList<IBinder> list = new ArrayList<IBinder>();
        int size = this.mTasks.size();
        for (int i = 0; i < size; ++i) {
            Intent intent;
            TaskRecord tr = this.mTasks.get(i);
            if (tr.effectiveUid != callingUid || (intent = tr.getBaseIntent()) == null || !callingPackage.equals(intent.getComponent().getPackageName())) continue;
            ActivityManager.RecentTaskInfo taskInfo = this.createRecentTaskInfo(tr);
            AppTaskImpl taskImpl = new AppTaskImpl(this.mService, taskInfo.persistentId, callingUid);
            list.add(taskImpl.asBinder());
        }
        return list;
    }

    ParceledListSlice<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, boolean getTasksAllowed, boolean getDetailedTasks, int userId, int callingUid) {
        boolean withExcluded;
        boolean bl = withExcluded = (flags & 1) != 0;
        if (!this.mService.isUserRunning(userId, 4)) {
            Slog.i("ActivityManager", "user " + userId + " is still locked. Cannot load recents");
            return ParceledListSlice.emptyList();
        }
        this.loadUserRecentsLocked(userId);
        Set<Integer> includedUsers = this.mUserController.getProfileIds(userId);
        includedUsers.add(userId);
        ArrayList<ActivityManager.RecentTaskInfo> res = new ArrayList<ActivityManager.RecentTaskInfo>();
        int size = this.mTasks.size();
        int numVisibleTasks = 0;
        for (int i = 0; i < size; ++i) {
            TaskRecord tr = this.mTasks.get(i);
            if (!this.isVisibleRecentTask(tr) || !this.isInVisibleRange(tr, ++numVisibleTasks) || res.size() >= maxNum || !includedUsers.contains(tr.userId) || tr.realActivitySuspended || i != 0 && !withExcluded && tr.intent != null && (tr.intent.getFlags() & 0x800000) != 0 || !getTasksAllowed && !tr.isActivityTypeHome() && tr.effectiveUid != callingUid || tr.autoRemoveRecents && tr.getTopActivity() == null || (flags & 2) != 0 && !tr.isAvailable || !tr.mUserSetupComplete) continue;
            ActivityManager.RecentTaskInfo rti = this.createRecentTaskInfo(tr);
            if (!getDetailedTasks) {
                rti.baseIntent.replaceExtras((Bundle)null);
            }
            res.add(rti);
        }
        return new ParceledListSlice<ActivityManager.RecentTaskInfo>(res);
    }

    void getPersistableTaskIds(ArraySet<Integer> persistentTaskIds) {
        int size = this.mTasks.size();
        for (int i = 0; i < size; ++i) {
            TaskRecord task = this.mTasks.get(i);
            Object stack = task.getStack();
            if (!task.isPersistable && !task.inRecents || stack != null && ((ActivityStack)stack).isHomeOrRecentsStack()) continue;
            persistentTaskIds.add(task.taskId);
        }
    }

    @VisibleForTesting
    ArrayList<TaskRecord> getRawTasks() {
        return this.mTasks;
    }

    SparseBooleanArray getRecentTaskIds() {
        SparseBooleanArray res = new SparseBooleanArray();
        int size = this.mTasks.size();
        int numVisibleTasks = 0;
        for (int i = 0; i < size; ++i) {
            TaskRecord tr = this.mTasks.get(i);
            if (!this.isVisibleRecentTask(tr) || !this.isInVisibleRange(tr, ++numVisibleTasks)) continue;
            res.put(tr.taskId, true);
        }
        return res;
    }

    TaskRecord getTask(int id2) {
        int recentsCount = this.mTasks.size();
        for (int i = 0; i < recentsCount; ++i) {
            TaskRecord tr = this.mTasks.get(i);
            if (tr.taskId != id2) continue;
            return tr;
        }
        return null;
    }

    void add(TaskRecord task) {
        boolean isAffiliated = task.mAffiliatedTaskId != task.taskId || task.mNextAffiliateTaskId != -1 || task.mPrevAffiliateTaskId != -1;
        int recentsCount = this.mTasks.size();
        if (task.voiceSession != null) {
            return;
        }
        if (!isAffiliated && recentsCount > 0 && this.mTasks.get(0) == task) {
            return;
        }
        if (isAffiliated && recentsCount > 0 && task.inRecents && task.mAffiliatedTaskId == this.mTasks.get((int)0).mAffiliatedTaskId) {
            return;
        }
        boolean needAffiliationFix = false;
        if (task.inRecents) {
            int taskIndex = this.mTasks.indexOf(task);
            if (taskIndex >= 0) {
                if (isAffiliated) {
                    // empty if block
                }
                this.mTasks.remove(taskIndex);
                this.mTasks.add(0, task);
                this.notifyTaskPersisterLocked(task, false);
                return;
            }
            Slog.wtf("ActivityManager", "Task with inRecent not in recents: " + task);
            needAffiliationFix = true;
        }
        this.removeForAddTask(task);
        task.inRecents = true;
        if (!isAffiliated || needAffiliationFix) {
            this.mTasks.add(0, task);
            this.notifyTaskAdded(task);
        } else if (isAffiliated) {
            TaskRecord other = task.mNextAffiliate;
            if (other == null) {
                other = task.mPrevAffiliate;
            }
            if (other != null) {
                int otherIndex = this.mTasks.indexOf(other);
                if (otherIndex >= 0) {
                    int taskIndex = other == task.mNextAffiliate ? otherIndex + 1 : otherIndex;
                    this.mTasks.add(taskIndex, task);
                    this.notifyTaskAdded(task);
                    if (this.moveAffiliatedTasksToFront(task, taskIndex)) {
                        return;
                    }
                    needAffiliationFix = true;
                } else {
                    needAffiliationFix = true;
                }
            } else {
                needAffiliationFix = true;
            }
        }
        if (needAffiliationFix) {
            this.cleanupLocked(task.userId);
        }
        this.trimInactiveRecentTasks();
    }

    boolean addToBottom(TaskRecord task) {
        if (!this.canAddTaskWithoutTrim(task)) {
            return false;
        }
        this.add(task);
        return true;
    }

    void remove(TaskRecord task) {
        this.mTasks.remove(task);
        this.notifyTaskRemoved(task, false);
    }

    private void trimInactiveRecentTasks() {
        for (int recentsCount = this.mTasks.size(); recentsCount > this.mGlobalMaxNumTasks; --recentsCount) {
            TaskRecord tr = this.mTasks.remove(recentsCount - 1);
            this.notifyTaskRemoved(tr, true);
        }
        int[] profileUserIds = this.mUserController.getCurrentProfileIds();
        this.mTmpQuietProfileUserIds.clear();
        for (int userId : profileUserIds) {
            UserInfo userInfo = this.mUserController.getUserInfo(userId);
            if (userInfo == null || !userInfo.isManagedProfile() || !userInfo.isQuietModeEnabled()) continue;
            this.mTmpQuietProfileUserIds.put(userId, true);
        }
        int numVisibleTasks = 0;
        int i = 0;
        while (i < this.mTasks.size()) {
            TaskRecord task = this.mTasks.get(i);
            if (this.isActiveRecentTask(task, this.mTmpQuietProfileUserIds)) {
                if (!this.mHasVisibleRecentTasks) {
                    ++i;
                    continue;
                }
                if (!this.isVisibleRecentTask(task)) {
                    ++i;
                    continue;
                }
                if (this.isInVisibleRange(task, ++numVisibleTasks) || !this.isTrimmable(task)) {
                    ++i;
                    continue;
                }
            }
            this.mTasks.remove(task);
            this.notifyTaskRemoved(task, true);
            this.notifyTaskPersisterLocked(task, false);
        }
    }

    private boolean isActiveRecentTask(TaskRecord task, SparseBooleanArray quietProfileUserIds) {
        TaskRecord affiliatedTask;
        if (quietProfileUserIds.get(task.userId)) {
            return false;
        }
        return task.mAffiliatedTaskId == -1 || task.mAffiliatedTaskId == task.taskId || (affiliatedTask = this.getTask(task.mAffiliatedTaskId)) == null || this.isActiveRecentTask(affiliatedTask, quietProfileUserIds);
    }

    private boolean isVisibleRecentTask(TaskRecord task) {
        switch (task.getActivityType()) {
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                if ((task.getBaseIntent().getFlags() & 0x800000) != 0x800000) break;
                return false;
            }
        }
        switch (task.getWindowingMode()) {
            case 2: {
                return false;
            }
            case 3: {
                Object stack = task.getStack();
                if (stack == null || ((ActivityStack)stack).topTask() != task) break;
                return false;
            }
        }
        return task != this.mService.getLockTaskController().getRootTask();
    }

    private boolean isInVisibleRange(TaskRecord task, int numVisibleTasks) {
        boolean isExcludeFromRecents;
        boolean bl = isExcludeFromRecents = (task.getBaseIntent().getFlags() & 0x800000) == 0x800000;
        if (isExcludeFromRecents) {
            return numVisibleTasks == 1;
        }
        if (this.mMinNumVisibleTasks >= 0 && numVisibleTasks <= this.mMinNumVisibleTasks) {
            return true;
        }
        if (this.mMaxNumVisibleTasks >= 0) {
            return numVisibleTasks <= this.mMaxNumVisibleTasks;
        }
        return this.mActiveTasksSessionDurationMs > 0L && task.getInactiveDuration() <= this.mActiveTasksSessionDurationMs;
    }

    protected boolean isTrimmable(TaskRecord task) {
        Object stack = task.getStack();
        ActivityStack homeStack = this.mService.mStackSupervisor.mHomeStack;
        if (stack == null) {
            return true;
        }
        if (((ActivityStack)stack).getDisplay() != homeStack.getDisplay()) {
            return false;
        }
        ActivityDisplay display = ((ActivityStack)stack).getDisplay();
        return display.getIndexOf((ActivityStack)stack) < display.getIndexOf(homeStack);
    }

    private void removeForAddTask(TaskRecord task) {
        int removeIndex = this.findRemoveIndexForAddTask(task);
        if (removeIndex == -1) {
            return;
        }
        TaskRecord removedTask = this.mTasks.remove(removeIndex);
        if (removedTask != task) {
            this.notifyTaskRemoved(removedTask, false);
        }
        this.notifyTaskPersisterLocked(removedTask, false);
    }

    private int findRemoveIndexForAddTask(TaskRecord task) {
        int recentsCount = this.mTasks.size();
        Intent intent = task.intent;
        boolean document = intent != null && intent.isDocument();
        int maxRecents = task.maxRecents - 1;
        for (int i = 0; i < recentsCount; ++i) {
            TaskRecord tr = this.mTasks.get(i);
            if (task != tr) {
                boolean bothDocuments;
                if (!this.hasCompatibleActivityTypeAndWindowingMode(task, tr) || task.userId != tr.userId) continue;
                Intent trIntent = tr.intent;
                boolean sameAffinity = task.affinity != null && task.affinity.equals(tr.affinity);
                boolean sameIntent = intent != null && intent.filterEquals(trIntent);
                boolean multiTasksAllowed = false;
                int flags = intent.getFlags();
                if ((flags & 0x10080000) != 0 && (flags & 0x8000000) != 0) {
                    multiTasksAllowed = true;
                }
                boolean trIsDocument = trIntent != null && trIntent.isDocument();
                boolean bl = bothDocuments = document && trIsDocument;
                if (!sameAffinity && !sameIntent && !bothDocuments) continue;
                if (bothDocuments) {
                    boolean sameActivity;
                    boolean bl2 = sameActivity = task.realActivity != null && tr.realActivity != null && task.realActivity.equals(tr.realActivity);
                    if (!sameActivity) continue;
                    if (maxRecents > 0) {
                        --maxRecents;
                        if (!sameIntent || multiTasksAllowed) {
                            continue;
                        }
                    }
                } else if (document || trIsDocument) continue;
            }
            return i;
        }
        return -1;
    }

    private int processNextAffiliateChainLocked(int start) {
        TaskRecord startTask = this.mTasks.get(start);
        int affiliateId = startTask.mAffiliatedTaskId;
        if (startTask.taskId == affiliateId && startTask.mPrevAffiliate == null && startTask.mNextAffiliate == null) {
            startTask.inRecents = true;
            return start + 1;
        }
        this.mTmpRecents.clear();
        for (int i = this.mTasks.size() - 1; i >= start; --i) {
            TaskRecord task = this.mTasks.get(i);
            if (task.mAffiliatedTaskId != affiliateId) continue;
            this.mTasks.remove(i);
            this.mTmpRecents.add(task);
        }
        Collections.sort(this.mTmpRecents, TASK_ID_COMPARATOR);
        TaskRecord first = this.mTmpRecents.get(0);
        first.inRecents = true;
        if (first.mNextAffiliate != null) {
            Slog.w("ActivityManager", "Link error 1 first.next=" + first.mNextAffiliate);
            first.setNextAffiliate(null);
            this.notifyTaskPersisterLocked(first, false);
        }
        int tmpSize = this.mTmpRecents.size();
        for (int i = 0; i < tmpSize - 1; ++i) {
            TaskRecord next = this.mTmpRecents.get(i);
            TaskRecord prev = this.mTmpRecents.get(i + 1);
            if (next.mPrevAffiliate != prev) {
                Slog.w("ActivityManager", "Link error 2 next=" + next + " prev=" + next.mPrevAffiliate + " setting prev=" + prev);
                next.setPrevAffiliate(prev);
                this.notifyTaskPersisterLocked(next, false);
            }
            if (prev.mNextAffiliate != next) {
                Slog.w("ActivityManager", "Link error 3 prev=" + prev + " next=" + prev.mNextAffiliate + " setting next=" + next);
                prev.setNextAffiliate(next);
                this.notifyTaskPersisterLocked(prev, false);
            }
            prev.inRecents = true;
        }
        TaskRecord last = this.mTmpRecents.get(tmpSize - 1);
        if (last.mPrevAffiliate != null) {
            Slog.w("ActivityManager", "Link error 4 last.prev=" + last.mPrevAffiliate);
            last.setPrevAffiliate(null);
            this.notifyTaskPersisterLocked(last, false);
        }
        this.mTasks.addAll(start, this.mTmpRecents);
        this.mTmpRecents.clear();
        return start + tmpSize;
    }

    private boolean moveAffiliatedTasksToFront(TaskRecord task, int taskIndex) {
        int topIndex;
        int recentsCount = this.mTasks.size();
        TaskRecord top = task;
        for (topIndex = taskIndex; top.mNextAffiliate != null && topIndex > 0; --topIndex) {
            top = top.mNextAffiliate;
        }
        boolean sane = top.mAffiliatedTaskId == task.mAffiliatedTaskId;
        int endIndex = topIndex;
        TaskRecord prev = top;
        while (endIndex < recentsCount) {
            TaskRecord cur = this.mTasks.get(endIndex);
            if (cur == top) {
                if (cur.mNextAffiliate != null || cur.mNextAffiliateTaskId != -1) {
                    Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": first task has next affiliate: " + prev);
                    sane = false;
                    break;
                }
            } else if (cur.mNextAffiliate != prev || cur.mNextAffiliateTaskId != prev.taskId) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": middle task " + cur + " @" + endIndex + " has bad next affiliate " + cur.mNextAffiliate + " id " + cur.mNextAffiliateTaskId + ", expected " + prev);
                sane = false;
                break;
            }
            if (cur.mPrevAffiliateTaskId == -1) {
                if (cur.mPrevAffiliate == null) break;
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": last task " + cur + " has previous affiliate " + cur.mPrevAffiliate);
                sane = false;
                break;
            }
            if (cur.mPrevAffiliate == null) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": task " + cur + " has previous affiliate " + cur.mPrevAffiliate + " but should be id " + cur.mPrevAffiliate);
                sane = false;
                break;
            }
            if (cur.mAffiliatedTaskId != task.mAffiliatedTaskId) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": task " + cur + " has affiliated id " + cur.mAffiliatedTaskId + " but should be " + task.mAffiliatedTaskId);
                sane = false;
                break;
            }
            prev = cur;
            if (++endIndex < recentsCount) continue;
            Slog.wtf("ActivityManager", "Bad chain ran off index " + endIndex + ": last task " + prev);
            sane = false;
            break;
        }
        if (sane && endIndex < taskIndex) {
            Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": did not extend to task " + task + " @" + taskIndex);
            sane = false;
        }
        if (sane) {
            for (int i = topIndex; i <= endIndex; ++i) {
                TaskRecord cur = this.mTasks.remove(i);
                this.mTasks.add(i - topIndex, cur);
            }
            return true;
        }
        return false;
    }

    void dump(PrintWriter pw, boolean dumpAll, String dumpPackage) {
        pw.println("ACTIVITY MANAGER RECENT TASKS (dumpsys activity recents)");
        pw.println("mRecentsUid=" + this.mRecentsUid);
        pw.println("mRecentsComponent=" + this.mRecentsComponent);
        if (this.mTasks.isEmpty()) {
            return;
        }
        boolean printedAnything = false;
        boolean printedHeader = false;
        int size = this.mTasks.size();
        for (int i = 0; i < size; ++i) {
            TaskRecord tr = this.mTasks.get(i);
            if (dumpPackage != null && (tr.realActivity == null || !dumpPackage.equals(tr.realActivity.getPackageName()))) continue;
            if (!printedHeader) {
                pw.println("  Recent tasks:");
                printedHeader = true;
                printedAnything = true;
            }
            pw.print("  * Recent #");
            pw.print(i);
            pw.print(": ");
            pw.println(tr);
            if (!dumpAll) continue;
            tr.dump(pw, "    ");
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    ActivityManager.RecentTaskInfo createRecentTaskInfo(TaskRecord tr) {
        ActivityManager.RecentTaskInfo rti = new ActivityManager.RecentTaskInfo();
        rti.id = tr.getTopActivity() == null ? -1 : tr.taskId;
        rti.persistentId = tr.taskId;
        rti.baseIntent = new Intent(tr.getBaseIntent());
        rti.origActivity = tr.origActivity;
        rti.realActivity = tr.realActivity;
        rti.description = tr.lastDescription;
        rti.stackId = tr.getStackId();
        rti.userId = tr.userId;
        rti.taskDescription = new ActivityManager.TaskDescription(tr.lastTaskDescription);
        rti.lastActiveTime = tr.lastActiveTime;
        rti.affiliatedTaskId = tr.mAffiliatedTaskId;
        rti.affiliatedTaskColor = tr.mAffiliatedTaskColor;
        rti.numActivities = 0;
        if (!tr.matchParentBounds()) {
            rti.bounds = new Rect(tr.getOverrideBounds());
        }
        rti.supportsSplitScreenMultiWindow = tr.supportsSplitScreenWindowingMode();
        rti.resizeMode = tr.mResizeMode;
        rti.configuration.setTo(tr.getConfiguration());
        tr.getNumRunningActivities(this.mTmpReport);
        rti.numActivities = this.mTmpReport.numActivities;
        rti.baseActivity = this.mTmpReport.base != null ? this.mTmpReport.base.intent.getComponent() : null;
        rti.topActivity = this.mTmpReport.top != null ? this.mTmpReport.top.intent.getComponent() : null;
        return rti;
    }

    private boolean hasCompatibleActivityTypeAndWindowingMode(TaskRecord t1, TaskRecord t2) {
        int activityType = t1.getActivityType();
        int windowingMode = t1.getWindowingMode();
        boolean isUndefinedType = activityType == 0;
        boolean isUndefinedMode = windowingMode == 0;
        int otherActivityType = t2.getActivityType();
        int otherWindowingMode = t2.getWindowingMode();
        boolean isOtherUndefinedType = otherActivityType == 0;
        boolean isOtherUndefinedMode = otherWindowingMode == 0;
        boolean isCompatibleType = activityType == otherActivityType || isUndefinedType || isOtherUndefinedType;
        boolean isCompatibleMode = windowingMode == otherWindowingMode || isUndefinedMode || isOtherUndefinedMode;
        return isCompatibleType && isCompatibleMode;
    }

    static interface Callbacks {
        public void onRecentTaskAdded(TaskRecord var1);

        public void onRecentTaskRemoved(TaskRecord var1, boolean var2);
    }
}

