/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.FileUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MemoryStatUtil {
    private static final String TAG = "ActivityManager";
    private static final String MEMCG_TEST_PATH = "/dev/memcg/apps/memory.stat";
    private static final String MEMORY_STAT_FILE_FMT = "/dev/memcg/apps/uid_%d/pid_%d/memory.stat";
    private static final String PROC_STAT_FILE_FMT = "/proc/%d/stat";
    private static final Pattern PGFAULT = Pattern.compile("total_pgfault (\\d+)");
    private static final Pattern PGMAJFAULT = Pattern.compile("total_pgmajfault (\\d+)");
    private static final Pattern RSS_IN_BYTES = Pattern.compile("total_rss (\\d+)");
    private static final Pattern CACHE_IN_BYTES = Pattern.compile("total_cache (\\d+)");
    private static final Pattern SWAP_IN_BYTES = Pattern.compile("total_swap (\\d+)");
    private static final int PGFAULT_INDEX = 9;
    private static final int PGMAJFAULT_INDEX = 11;
    private static final int RSS_IN_BYTES_INDEX = 23;
    private static volatile Boolean sDeviceHasMemCg;

    private MemoryStatUtil() {
    }

    static MemoryStat readMemoryStatFromFilesystem(int uid, int pid) {
        return MemoryStatUtil.hasMemcg() ? MemoryStatUtil.readMemoryStatFromMemcg(uid, pid) : MemoryStatUtil.readMemoryStatFromProcfs(pid);
    }

    static MemoryStat readMemoryStatFromMemcg(int uid, int pid) {
        String path = String.format(Locale.US, MEMORY_STAT_FILE_FMT, uid, pid);
        return MemoryStatUtil.parseMemoryStatFromMemcg(MemoryStatUtil.readFileContents(path));
    }

    static MemoryStat readMemoryStatFromProcfs(int pid) {
        String path = String.format(Locale.US, PROC_STAT_FILE_FMT, pid);
        return MemoryStatUtil.parseMemoryStatFromProcfs(MemoryStatUtil.readFileContents(path));
    }

    private static String readFileContents(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        try {
            return FileUtils.readTextFile(file, 0, null);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read file:", e);
            return null;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    static MemoryStat parseMemoryStatFromMemcg(String memoryStatContents) {
        if (memoryStatContents == null || memoryStatContents.isEmpty()) {
            return null;
        }
        MemoryStat memoryStat = new MemoryStat();
        Matcher m = PGFAULT.matcher(memoryStatContents);
        memoryStat.pgfault = m.find() ? Long.valueOf(m.group(1)) : 0L;
        m = PGMAJFAULT.matcher(memoryStatContents);
        memoryStat.pgmajfault = m.find() ? Long.valueOf(m.group(1)) : 0L;
        m = RSS_IN_BYTES.matcher(memoryStatContents);
        memoryStat.rssInBytes = m.find() ? Long.valueOf(m.group(1)) : 0L;
        m = CACHE_IN_BYTES.matcher(memoryStatContents);
        memoryStat.cacheInBytes = m.find() ? Long.valueOf(m.group(1)) : 0L;
        m = SWAP_IN_BYTES.matcher(memoryStatContents);
        memoryStat.swapInBytes = m.find() ? Long.valueOf(m.group(1)) : 0L;
        return memoryStat;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    static MemoryStat parseMemoryStatFromProcfs(String procStatContents) {
        if (procStatContents == null || procStatContents.isEmpty()) {
            return null;
        }
        String[] splits = procStatContents.split(" ");
        if (splits.length < 24) {
            return null;
        }
        MemoryStat memoryStat = new MemoryStat();
        memoryStat.pgfault = Long.valueOf(splits[9]);
        memoryStat.pgmajfault = Long.valueOf(splits[11]);
        memoryStat.rssInBytes = Long.valueOf(splits[23]);
        return memoryStat;
    }

    static boolean hasMemcg() {
        if (sDeviceHasMemCg == null) {
            sDeviceHasMemCg = new File(MEMCG_TEST_PATH).exists();
        }
        return sDeviceHasMemCg;
    }

    static final class MemoryStat {
        long pgfault;
        long pgmajfault;
        long rssInBytes;
        long cacheInBytes;
        long swapInBytes;

        MemoryStat() {
        }
    }
}

