/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.SystemClock;
import android.os.Trace;
import android.util.SparseArray;
import com.android.server.am.ActivityRecord;

class LaunchTimeTracker {
    private final SparseArray<Entry> mWindowingModeLaunchTime = new SparseArray();

    LaunchTimeTracker() {
    }

    void setLaunchTime(ActivityRecord r) {
        Entry entry = this.mWindowingModeLaunchTime.get(r.getWindowingMode());
        if (entry == null) {
            entry = new Entry();
            this.mWindowingModeLaunchTime.append(r.getWindowingMode(), entry);
        }
        entry.setLaunchTime(r);
    }

    void stopFullyDrawnTraceIfNeeded(int windowingMode) {
        Entry entry = this.mWindowingModeLaunchTime.get(windowingMode);
        if (entry == null) {
            return;
        }
        entry.stopFullyDrawnTraceIfNeeded();
    }

    Entry getEntry(int windowingMode) {
        return this.mWindowingModeLaunchTime.get(windowingMode);
    }

    static class Entry {
        long mLaunchStartTime;
        long mFullyDrawnStartTime;

        Entry() {
        }

        void setLaunchTime(ActivityRecord r) {
            if (r.displayStartTime == 0L) {
                r.fullyDrawnStartTime = r.displayStartTime = SystemClock.uptimeMillis();
                if (this.mLaunchStartTime == 0L) {
                    this.startLaunchTraces(r.packageName);
                    this.mLaunchStartTime = this.mFullyDrawnStartTime = r.displayStartTime;
                }
            } else if (this.mLaunchStartTime == 0L) {
                this.startLaunchTraces(r.packageName);
                this.mLaunchStartTime = this.mFullyDrawnStartTime = SystemClock.uptimeMillis();
            }
        }

        private void startLaunchTraces(String packageName) {
            if (this.mFullyDrawnStartTime != 0L) {
                Trace.asyncTraceEnd(64L, "drawing", 0);
            }
            Trace.asyncTraceBegin(64L, "launching: " + packageName, 0);
            Trace.asyncTraceBegin(64L, "drawing", 0);
        }

        private void stopFullyDrawnTraceIfNeeded() {
            if (this.mFullyDrawnStartTime != 0L && this.mLaunchStartTime == 0L) {
                Trace.asyncTraceEnd(64L, "drawing", 0);
                this.mFullyDrawnStartTime = 0L;
            }
        }
    }
}

