/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IInstrumentationWatcher;
import android.content.ComponentName;
import android.os.Bundle;
import android.os.Process;
import android.os.RemoteException;
import android.util.Slog;
import java.util.ArrayList;

public class InstrumentationReporter {
    static final boolean DEBUG = false;
    static final String TAG = "ActivityManager";
    static final int REPORT_TYPE_STATUS = 0;
    static final int REPORT_TYPE_FINISHED = 1;
    final Object mLock = new Object();
    ArrayList<Report> mPendingReports;
    Thread mThread;

    public void reportStatus(IInstrumentationWatcher watcher, ComponentName name, int resultCode, Bundle results) {
        this.report(new Report(0, watcher, name, resultCode, results));
    }

    public void reportFinished(IInstrumentationWatcher watcher, ComponentName name, int resultCode, Bundle results) {
        this.report(new Report(1, watcher, name, resultCode, results));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(Report report) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mThread == null) {
                this.mThread = new MyThread();
                this.mThread.start();
            }
            if (this.mPendingReports == null) {
                this.mPendingReports = new ArrayList();
            }
            this.mPendingReports.add(report);
            this.mLock.notifyAll();
        }
    }

    final class Report {
        final int mType;
        final IInstrumentationWatcher mWatcher;
        final ComponentName mName;
        final int mResultCode;
        final Bundle mResults;

        Report(int type, IInstrumentationWatcher watcher, ComponentName name, int resultCode, Bundle results) {
            this.mType = type;
            this.mWatcher = watcher;
            this.mName = name;
            this.mResultCode = resultCode;
            this.mResults = results;
        }
    }

    final class MyThread
    extends Thread {
        public MyThread() {
            super("InstrumentationReporter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            Process.setThreadPriority(0);
            waited = false;
            block8: while (true) {
                var3_3 = InstrumentationReporter.this.mLock;
                synchronized (var3_3) {
                    reports = InstrumentationReporter.this.mPendingReports;
                    InstrumentationReporter.this.mPendingReports = null;
                    if (reports == null || reports.isEmpty()) {
                        if (!waited) {
                            try {
                                InstrumentationReporter.this.mLock.wait(10000L);
                            }
                            catch (InterruptedException var4_6) {
                                // empty catch block
                            }
                            waited = true;
                            continue;
                        }
                        InstrumentationReporter.this.mThread = null;
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                    waited = false;
                    i = 0;
                }
                while (true) {
                    if (i < reports.size()) ** break;
                    continue block8;
                    rep = reports.get(i);
                    try {
                        if (rep.mType == 0) {
                            rep.mWatcher.instrumentationStatus(rep.mName, rep.mResultCode, rep.mResults);
                        } else {
                            rep.mWatcher.instrumentationFinished(rep.mName, rep.mResultCode, rep.mResults);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.i("ActivityManager", "Failure reporting to instrumentation watcher: comp=" + rep.mName + " results=" + rep.mResults);
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

