/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IServiceConnection;
import android.app.PendingIntent;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.server.am.ActivityRecord;
import com.android.server.am.AppBindRecord;
import java.io.PrintWriter;

final class ConnectionRecord {
    final AppBindRecord binding;
    final ActivityRecord activity;
    final IServiceConnection conn;
    final int flags;
    final int clientLabel;
    final PendingIntent clientIntent;
    String stringName;
    boolean serviceDead;
    private static int[] BIND_ORIG_ENUMS = new int[]{1, 2, 4, 0x800000, 8, 16, 32, 64, 128, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
    private static int[] BIND_PROTO_ENUMS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "binding=" + this.binding);
        if (this.activity != null) {
            pw.println(prefix + "activity=" + this.activity);
        }
        pw.println(prefix + "conn=" + this.conn.asBinder() + " flags=0x" + Integer.toHexString(this.flags));
    }

    ConnectionRecord(AppBindRecord _binding, ActivityRecord _activity, IServiceConnection _conn, int _flags, int _clientLabel, PendingIntent _clientIntent) {
        this.binding = _binding;
        this.activity = _activity;
        this.conn = _conn;
        this.flags = _flags;
        this.clientLabel = _clientLabel;
        this.clientIntent = _clientIntent;
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConnectionRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(this.binding.client.userId);
        sb.append(' ');
        if ((this.flags & 1) != 0) {
            sb.append("CR ");
        }
        if ((this.flags & 2) != 0) {
            sb.append("DBG ");
        }
        if ((this.flags & 4) != 0) {
            sb.append("!FG ");
        }
        if ((this.flags & 0x800000) != 0) {
            sb.append("IMPB ");
        }
        if ((this.flags & 8) != 0) {
            sb.append("ABCLT ");
        }
        if ((this.flags & 0x10) != 0) {
            sb.append("OOM ");
        }
        if ((this.flags & 0x20) != 0) {
            sb.append("WPRI ");
        }
        if ((this.flags & 0x40) != 0) {
            sb.append("IMP ");
        }
        if ((this.flags & 0x80) != 0) {
            sb.append("WACT ");
        }
        if ((this.flags & 0x2000000) != 0) {
            sb.append("FGSA ");
        }
        if ((this.flags & 0x4000000) != 0) {
            sb.append("FGS ");
        }
        if ((this.flags & 0x8000000) != 0) {
            sb.append("LACT ");
        }
        if ((this.flags & 0x10000000) != 0) {
            sb.append("VIS ");
        }
        if ((this.flags & 0x20000000) != 0) {
            sb.append("UI ");
        }
        if ((this.flags & 0x40000000) != 0) {
            sb.append("!VIS ");
        }
        if (this.serviceDead) {
            sb.append("DEAD ");
        }
        sb.append(this.binding.service.shortName);
        sb.append(":@");
        sb.append(Integer.toHexString(System.identityHashCode(this.conn.asBinder())));
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        if (this.binding == null) {
            return;
        }
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, Integer.toHexString(System.identityHashCode(this)));
        if (this.binding.client != null) {
            proto.write(1120986464258L, this.binding.client.userId);
        }
        ProtoUtils.writeBitWiseFlagsToProtoEnum(proto, 2259152797699L, this.flags, BIND_ORIG_ENUMS, BIND_PROTO_ENUMS);
        if (this.serviceDead) {
            proto.write(2259152797699L, 15);
        }
        if (this.binding.service != null) {
            proto.write(1138166333444L, this.binding.service.shortName);
        }
        proto.end(token);
    }
}

