/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityController;
import android.app.ResultInfo;
import android.app.WindowConfiguration;
import android.app.servertransaction.ActivityResultItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.DestroyActivityItem;
import android.app.servertransaction.NewIntentItem;
import android.app.servertransaction.PauseActivityItem;
import android.app.servertransaction.ResumeActivityItem;
import android.app.servertransaction.StopActivityItem;
import android.app.servertransaction.WindowVisibilityItem;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.IntArray;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.Watchdog;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.EventLogTags;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.StackWindowListener;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class ActivityStack<T extends StackWindowController>
extends ConfigurationContainer
implements StackWindowListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_ADD_REMOVE = "ActivityManager";
    private static final String TAG_APP = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONTAINERS = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_SAVED_STATE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final String TAG_TRANSITION = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    static final int LAUNCH_TICK = 500;
    private static final int PAUSE_TIMEOUT = 500;
    private static final int STOP_TIMEOUT = 11000;
    private static final int DESTROY_TIMEOUT = 10000;
    private static final boolean SHOW_APP_STARTING_PREVIEW = true;
    private static final long TRANSLUCENT_CONVERSION_TIMEOUT = 2000L;
    private static final int MAX_STOPPING_TO_FORCE = 3;
    @VisibleForTesting
    protected static final int REMOVE_TASK_MODE_DESTROYING = 0;
    static final int REMOVE_TASK_MODE_MOVING = 1;
    static final int REMOVE_TASK_MODE_MOVING_TO_TOP = 2;
    private static final int FIT_WITHIN_BOUNDS_DIVIDER = 3;
    final ActivityManagerService mService;
    private final WindowManagerService mWindowManager;
    T mWindowContainerController;
    private final ArrayList<TaskRecord> mTaskHistory = new ArrayList();
    final ArrayList<ActivityRecord> mLRUActivities = new ArrayList();
    ActivityRecord mPausingActivity = null;
    ActivityRecord mLastPausedActivity = null;
    ActivityRecord mLastNoHistoryActivity = null;
    ActivityRecord mResumedActivity = null;
    ActivityRecord mTranslucentActivityWaiting = null;
    ArrayList<ActivityRecord> mUndrawnActivitiesBelowTopTranslucent = new ArrayList();
    boolean mConfigWillChange;
    boolean mForceHidden = false;
    private boolean mUpdateBoundsDeferred;
    private boolean mUpdateBoundsDeferredCalled;
    private final Rect mDeferredBounds = new Rect();
    private final Rect mDeferredTaskBounds = new Rect();
    private final Rect mDeferredTaskInsetBounds = new Rect();
    int mCurrentUser;
    final int mStackId;
    int mDisplayId;
    private final SparseArray<Rect> mTmpBounds = new SparseArray();
    private final SparseArray<Rect> mTmpInsetBounds = new SparseArray();
    private final Rect mTmpRect2 = new Rect();
    private final ActivityOptions mTmpOptions = ActivityOptions.makeBasic();
    private final ArrayList<ActivityRecord> mTmpActivities = new ArrayList();
    protected final ActivityStackSupervisor mStackSupervisor;
    private boolean mTopActivityOccludesKeyguard;
    private ActivityRecord mTopDismissingKeyguardActivity;
    static final int PAUSE_TIMEOUT_MSG = 101;
    static final int DESTROY_TIMEOUT_MSG = 102;
    static final int LAUNCH_TICK_MSG = 103;
    static final int STOP_TIMEOUT_MSG = 104;
    static final int DESTROY_ACTIVITIES_MSG = 105;
    static final int TRANSLUCENT_TIMEOUT_MSG = 106;
    final Handler mHandler;
    static final int FINISH_IMMEDIATELY = 0;
    static final int FINISH_AFTER_PAUSE = 1;
    static final int FINISH_AFTER_VISIBLE = 2;

    @Override
    protected int getChildCount() {
        return this.mTaskHistory.size();
    }

    protected ConfigurationContainer getChildAt(int index) {
        return this.mTaskHistory.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.getDisplay();
    }

    @Override
    protected void onParentChanged() {
        super.onParentChanged();
        this.mStackSupervisor.updateUIDsPresentOnDisplay();
    }

    int numActivities() {
        int count = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            count += this.mTaskHistory.get((int)taskNdx).mActivities.size();
        }
        return count;
    }

    ActivityStack(ActivityDisplay display, int stackId, ActivityStackSupervisor supervisor, int windowingMode, int activityType, boolean onTop) {
        this.mStackSupervisor = supervisor;
        this.mService = supervisor.mService;
        this.mHandler = new ActivityStackHandler(this.mService.mHandler.getLooper());
        this.mWindowManager = this.mService.mWindowManager;
        this.mStackId = stackId;
        this.mCurrentUser = this.mService.mUserController.getCurrentUserId();
        this.mTmpRect2.setEmpty();
        this.mDisplayId = display.mDisplayId;
        this.setActivityType(activityType);
        this.setWindowingMode(windowingMode);
        this.mWindowContainerController = this.createStackWindowController(display.mDisplayId, onTop, this.mTmpRect2);
        this.postAddToDisplay(display, this.mTmpRect2.isEmpty() ? null : this.mTmpRect2, onTop);
    }

    T createStackWindowController(int displayId, boolean onTop, Rect outBounds) {
        return (T)new StackWindowController(this.mStackId, this, displayId, onTop, outBounds, this.mStackSupervisor.mWindowManager);
    }

    T getWindowContainerController() {
        return this.mWindowContainerController;
    }

    void onActivityStateChanged(ActivityRecord record, ActivityState state, String reason) {
        if (record == this.mResumedActivity && state != ActivityState.RESUMED) {
            this.setResumedActivity(null, reason + " - onActivityStateChanged");
        }
        if (state == ActivityState.RESUMED) {
            this.setResumedActivity(record, reason + " - onActivityStateChanged");
            this.mService.setResumedActivityUncheckLocked(record, reason);
            this.mStackSupervisor.mRecentTasks.add(record.getTask());
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        int prevWindowingMode = this.getWindowingMode();
        super.onConfigurationChanged(newParentConfig);
        ActivityDisplay display = this.getDisplay();
        if (display != null && prevWindowingMode != this.getWindowingMode()) {
            display.onStackWindowingModeChanged(this);
        }
    }

    @Override
    public void setWindowingMode(int windowingMode) {
        this.setWindowingMode(windowingMode, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWindowingMode(int preferredWindowingMode, boolean animate, boolean showRecents, boolean enteringSplitScreenMode, boolean deferEnsuringVisibility) {
        boolean sendNonResizeableNotification;
        int windowingMode;
        boolean creating = this.mWindowContainerController == null;
        int currentMode = this.getWindowingMode();
        ActivityDisplay display = this.getDisplay();
        TaskRecord topTask = this.topTask();
        ActivityStack splitScreenStack = display.getSplitScreenPrimaryStack();
        this.mTmpOptions.setLaunchWindowingMode(preferredWindowingMode);
        int n = windowingMode = creating ? preferredWindowingMode : display.resolveWindowingMode(null, this.mTmpOptions, topTask, this.getActivityType());
        if (splitScreenStack == this && windowingMode == 4) {
            windowingMode = 1;
        }
        boolean alreadyInSplitScreenMode = display.hasSplitScreenPrimaryStack();
        boolean bl = sendNonResizeableNotification = !enteringSplitScreenMode;
        if (alreadyInSplitScreenMode && windowingMode == 1 && sendNonResizeableNotification && this.isActivityTypeStandardOrUndefined()) {
            boolean preferredSplitScreen;
            boolean bl2 = preferredSplitScreen = preferredWindowingMode == 3 || preferredWindowingMode == 4;
            if (preferredSplitScreen || creating) {
                this.mService.mTaskChangeNotificationController.notifyActivityDismissingDockedStack();
                display.getSplitScreenPrimaryStack().setWindowingMode(1, false, false, false, true);
            }
        }
        if (currentMode == windowingMode) {
            return;
        }
        WindowManagerService wm = this.mService.mWindowManager;
        ActivityRecord topActivity = this.getTopActivity();
        if (sendNonResizeableNotification && windowingMode != 1 && topActivity != null && topActivity.isNonResizableOrForcedResizable() && !topActivity.noDisplay) {
            String packageName = topActivity.appInfo.packageName;
            this.mService.mTaskChangeNotificationController.notifyActivityForcedResizable(topTask.taskId, 1, packageName);
        }
        wm.deferSurfaceLayout();
        try {
            if (!animate && topActivity != null) {
                this.mStackSupervisor.mNoAnimActivities.add(topActivity);
            }
            super.setWindowingMode(windowingMode);
            if (creating) {
                return;
            }
            if (windowingMode == 2 || currentMode == 2) {
                throw new IllegalArgumentException("Changing pinned windowing mode not currently supported");
            }
            if (windowingMode == 3 && splitScreenStack != null) {
                throw new IllegalArgumentException("Setting primary split-screen windowing mode while there is already one isn't currently supported");
            }
            this.mTmpRect2.setEmpty();
            if (windowingMode != 1) {
                Rect bounds;
                ((StackWindowController)this.mWindowContainerController).getRawBounds(this.mTmpRect2);
                if (windowingMode == 5 && topTask != null && (bounds = this.topTask().getLaunchBounds()) != null) {
                    this.mTmpRect2.set(bounds);
                }
            }
            if (!Objects.equals(this.getOverrideBounds(), this.mTmpRect2)) {
                this.resize(this.mTmpRect2, null, null);
            }
        }
        finally {
            if (showRecents && !alreadyInSplitScreenMode && this.mDisplayId == 0 && windowingMode == 3) {
                Object recentStack = display.getOrCreateStack(4, 3, true);
                ((ActivityStack)recentStack).moveToFront("setWindowingMode");
                this.mService.mWindowManager.showRecentApps();
            }
            wm.continueSurfaceLayout();
        }
        if (!deferEnsuringVisibility) {
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, true);
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    @Override
    public boolean isCompatible(int windowingMode, int activityType) {
        ActivityDisplay display;
        if (activityType == 0) {
            activityType = 1;
        }
        if ((display = this.getDisplay()) != null && activityType == 1 && windowingMode == 0) {
            windowingMode = display.getWindowingMode();
        }
        return super.isCompatible(windowingMode, activityType);
    }

    void reparent(ActivityDisplay activityDisplay, boolean onTop) {
        this.removeFromDisplay();
        this.mTmpRect2.setEmpty();
        ((StackWindowController)this.mWindowContainerController).reparent(activityDisplay.mDisplayId, this.mTmpRect2, onTop);
        this.postAddToDisplay(activityDisplay, this.mTmpRect2.isEmpty() ? null : this.mTmpRect2, onTop);
        this.adjustFocusToNextFocusableStack("reparent", true);
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
    }

    private void postAddToDisplay(ActivityDisplay activityDisplay, Rect bounds, boolean onTop) {
        this.mDisplayId = activityDisplay.mDisplayId;
        this.setBounds(bounds);
        this.onParentChanged();
        activityDisplay.addChild(this, onTop ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        if (this.inSplitScreenPrimaryWindowingMode()) {
            this.mStackSupervisor.resizeDockedStackLocked(this.getOverrideBounds(), null, null, null, null, true);
        }
    }

    private void removeFromDisplay() {
        ActivityDisplay display = this.getDisplay();
        if (display != null) {
            display.removeChild(this);
        }
        this.mDisplayId = -1;
    }

    void remove() {
        this.removeFromDisplay();
        ((StackWindowController)this.mWindowContainerController).removeContainer();
        this.mWindowContainerController = null;
        this.onParentChanged();
    }

    ActivityDisplay getDisplay() {
        return this.mStackSupervisor.getActivityDisplay(this.mDisplayId);
    }

    void getStackDockedModeBounds(Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds, boolean ignoreVisibility) {
        ((StackWindowController)this.mWindowContainerController).getStackDockedModeBounds(currentTempTaskBounds, outStackBounds, outTempTaskBounds, ignoreVisibility);
    }

    void prepareFreezingTaskBounds() {
        ((StackWindowController)this.mWindowContainerController).prepareFreezingTaskBounds();
    }

    void getWindowContainerBounds(Rect outBounds) {
        if (this.mWindowContainerController != null) {
            ((StackWindowController)this.mWindowContainerController).getBounds(outBounds);
            return;
        }
        outBounds.setEmpty();
    }

    void getBoundsForNewConfiguration(Rect outBounds) {
        ((StackWindowController)this.mWindowContainerController).getBoundsForNewConfiguration(outBounds);
    }

    void positionChildWindowContainerAtTop(TaskRecord child) {
        ((StackWindowController)this.mWindowContainerController).positionChildAtTop(child.getWindowContainerController(), true);
    }

    boolean deferScheduleMultiWindowModeChanged() {
        return false;
    }

    void deferUpdateBounds() {
        if (!this.mUpdateBoundsDeferred) {
            this.mUpdateBoundsDeferred = true;
            this.mUpdateBoundsDeferredCalled = false;
        }
    }

    void continueUpdateBounds() {
        boolean wasDeferred = this.mUpdateBoundsDeferred;
        this.mUpdateBoundsDeferred = false;
        if (wasDeferred && this.mUpdateBoundsDeferredCalled) {
            this.resize(this.mDeferredBounds.isEmpty() ? null : this.mDeferredBounds, this.mDeferredTaskBounds.isEmpty() ? null : this.mDeferredTaskBounds, this.mDeferredTaskInsetBounds.isEmpty() ? null : this.mDeferredTaskInsetBounds);
        }
    }

    boolean updateBoundsAllowed(Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds) {
        if (!this.mUpdateBoundsDeferred) {
            return true;
        }
        if (bounds != null) {
            this.mDeferredBounds.set(bounds);
        } else {
            this.mDeferredBounds.setEmpty();
        }
        if (tempTaskBounds != null) {
            this.mDeferredTaskBounds.set(tempTaskBounds);
        } else {
            this.mDeferredTaskBounds.setEmpty();
        }
        if (tempTaskInsetBounds != null) {
            this.mDeferredTaskInsetBounds.set(tempTaskInsetBounds);
        } else {
            this.mDeferredTaskInsetBounds.setEmpty();
        }
        this.mUpdateBoundsDeferredCalled = true;
        return false;
    }

    @Override
    public int setBounds(Rect bounds) {
        return super.setBounds(!this.inMultiWindowMode() ? null : bounds);
    }

    ActivityRecord topRunningActivityLocked() {
        return this.topRunningActivityLocked(false);
    }

    void getAllRunningVisibleActivitiesLocked(ArrayList<ActivityRecord> outActivities) {
        outActivities.clear();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).getAllRunningVisibleActivitiesLocked(outActivities);
        }
    }

    private ActivityRecord topRunningActivityLocked(boolean focusableOnly) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r = this.mTaskHistory.get(taskNdx).topRunningActivityLocked();
            if (r == null || focusableOnly && !r.isFocusable()) continue;
            return r;
        }
        return null;
    }

    ActivityRecord topRunningNonOverlayTaskActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.mTaskOverlay) continue;
                return r;
            }
        }
        return null;
    }

    ActivityRecord topRunningNonDelayedActivityLocked(ActivityRecord notTop) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.delayedResume || r == notTop || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topRunningActivityLocked(IBinder token, int taskId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId == taskId) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int i = activities.size() - 1; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || token == r.appToken || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    ActivityRecord getTopActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r = this.mTaskHistory.get(taskNdx).getTopActivity();
            if (r == null) continue;
            return r;
        }
        return null;
    }

    final TaskRecord topTask() {
        int size = this.mTaskHistory.size();
        if (size > 0) {
            return this.mTaskHistory.get(size - 1);
        }
        return null;
    }

    private TaskRecord bottomTask() {
        if (this.mTaskHistory.isEmpty()) {
            return null;
        }
        return this.mTaskHistory.get(0);
    }

    TaskRecord taskForIdLocked(int id2) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId != id2) continue;
            return task;
        }
        return null;
    }

    ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return this.isInStackLocked(r);
    }

    ActivityRecord isInStackLocked(ActivityRecord r) {
        if (r == null) {
            return null;
        }
        TaskRecord task = r.getTask();
        Object stack = r.getStack();
        if (stack != null && task.mActivities.contains(r) && this.mTaskHistory.contains(task)) {
            if (stack != this) {
                Slog.w("ActivityManager", "Illegal state! task does not point to stack it is in.");
            }
            return r;
        }
        return null;
    }

    boolean isInStackLocked(TaskRecord task) {
        return this.mTaskHistory.contains(task);
    }

    boolean isUidPresent(int uid) {
        for (TaskRecord task : this.mTaskHistory) {
            for (ActivityRecord r : task.mActivities) {
                if (r.getUid() != uid) continue;
                return true;
            }
        }
        return false;
    }

    void getPresentUIDs(IntArray presentUIDs) {
        for (TaskRecord task : this.mTaskHistory) {
            for (ActivityRecord r : task.mActivities) {
                presentUIDs.add(r.getUid());
            }
        }
    }

    final void removeActivitiesFromLRUListLocked(TaskRecord task) {
        for (ActivityRecord r : task.mActivities) {
            this.mLRUActivities.remove(r);
        }
    }

    final boolean updateLRUListLocked(ActivityRecord r) {
        boolean hadit = this.mLRUActivities.remove(r);
        this.mLRUActivities.add(r);
        return hadit;
    }

    final boolean isHomeOrRecentsStack() {
        return this.isActivityTypeHome() || this.isActivityTypeRecents();
    }

    final boolean isOnHomeDisplay() {
        return this.mDisplayId == 0;
    }

    private boolean returnsToHomeStack() {
        return !this.inMultiWindowMode() && !this.mTaskHistory.isEmpty() && this.mTaskHistory.get(0).returnsToHomeStack();
    }

    void moveToFront(String reason) {
        this.moveToFront(reason, null);
    }

    void moveToFront(String reason, TaskRecord task) {
        ActivityStack topFullScreenStack;
        if (!this.isAttached()) {
            return;
        }
        ActivityDisplay display = this.getDisplay();
        if (this.inSplitScreenSecondaryWindowingMode() && (topFullScreenStack = display.getTopStackInWindowingMode(1)) != null) {
            ActivityStack primarySplitScreenStack = display.getSplitScreenPrimaryStack();
            if (display.getIndexOf(topFullScreenStack) > display.getIndexOf(primarySplitScreenStack)) {
                primarySplitScreenStack.moveToFront(reason + " splitScreenToTop");
            }
        }
        if (!this.isActivityTypeHome() && this.returnsToHomeStack()) {
            this.mStackSupervisor.moveHomeStackToFront(reason + " returnToHome");
        }
        display.positionChildAtTop(this);
        this.mStackSupervisor.setFocusStackUnchecked(reason, this);
        if (task != null) {
            this.insertTaskAtTop(task, null);
            return;
        }
    }

    void moveToBack(String reason, TaskRecord task) {
        if (!this.isAttached()) {
            return;
        }
        if (this.getWindowingMode() == 3) {
            this.setWindowingMode(1);
        }
        this.getDisplay().positionChildAtBottom(this);
        this.mStackSupervisor.setFocusStackUnchecked(reason, this.getDisplay().getTopStack());
        if (task != null) {
            this.insertTaskAtBottom(task);
            return;
        }
    }

    boolean isFocusable() {
        ActivityRecord r = this.topRunningActivityLocked();
        return this.mStackSupervisor.isFocusable(this, r != null && r.isFocusable());
    }

    final boolean isAttached() {
        return this.getParent() != null;
    }

    void findTaskLocked(ActivityRecord target, ActivityStackSupervisor.FindTaskResult result) {
        Intent intent = target.intent;
        ActivityInfo info = target.info;
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        boolean isDocument = intent != null & intent.isDocument();
        Uri documentData = isDocument ? intent.getData() : null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            Uri taskDocumentData;
            boolean taskIsDocument;
            ActivityRecord r;
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.voiceSession != null || task.userId != userId || (r = task.getTopActivity(false)) == null || r.finishing || r.userId != userId || r.launchMode == 3 || !r.hasCompatibleActivityType(target)) continue;
            Intent taskIntent = task.intent;
            Intent affinityIntent = task.affinityIntent;
            if (taskIntent != null && taskIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = taskIntent.getData();
            } else if (affinityIntent != null && affinityIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = affinityIntent.getData();
            } else {
                taskIsDocument = false;
                taskDocumentData = null;
            }
            if (taskIntent != null && taskIntent.getComponent() != null && taskIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (affinityIntent != null && affinityIntent.getComponent() != null && affinityIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (isDocument || taskIsDocument || result.r != null || task.rootAffinity == null || !task.rootAffinity.equals(target.taskAffinity)) continue;
            result.r = r;
            result.matchedByRootAffinity = true;
        }
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.okToShowLocked() || r.finishing || r.userId != userId || !(compareIntentFilters ? r.intent.filterEquals(intent) : r.intent.getComponent().equals(cls))) continue;
                return r;
            }
        }
        return null;
    }

    final void switchUserLocked(int userId) {
        if (this.mCurrentUser == userId) {
            return;
        }
        this.mCurrentUser = userId;
        int index = this.mTaskHistory.size();
        int i = 0;
        while (i < index) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (task.okToShowLocked()) {
                this.mTaskHistory.remove(i);
                this.mTaskHistory.add(task);
                --index;
                continue;
            }
            ++i;
        }
    }

    void minimalResumeActivityLocked(ActivityRecord r) {
        r.setState(ActivityState.RESUMED, "minimalResumeActivityLocked");
        r.completeResumeLocked();
        this.mStackSupervisor.getLaunchTimeTracker().setLaunchTime(r);
    }

    private void clearLaunchTime(ActivityRecord r) {
        if (this.mStackSupervisor.mWaitingActivityLaunched.isEmpty()) {
            r.fullyDrawnStartTime = 0L;
            r.displayStartTime = 0L;
        } else {
            this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
            this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
        }
    }

    void awakeFromSleepingLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                activities.get(activityNdx).setSleeping(false);
            }
        }
        if (this.mPausingActivity != null) {
            Slog.d("ActivityManager", "awakeFromSleepingLocked: previously pausing activity didn't pause");
            this.activityPausedLocked(this.mPausingActivity.appToken, true);
        }
    }

    void updateActivityApplicationInfoLocked(ApplicationInfo aInfo) {
        String packageName = aInfo.packageName;
        int userId = UserHandle.getUserId(aInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord ar = (ActivityRecord)activities.get(activityNdx);
                if (userId != ar.userId || !packageName.equals(ar.packageName)) continue;
                ar.updateApplicationInfo(aInfo);
            }
        }
    }

    void checkReadyForSleep() {
        if (this.shouldSleepActivities() && this.goToSleepIfPossible(false)) {
            this.mStackSupervisor.checkReadyForSleepLocked(true);
        }
    }

    boolean goToSleepIfPossible(boolean shuttingDown) {
        boolean shouldSleep = true;
        if (this.mResumedActivity != null) {
            this.startPausingLocked(false, true, null, false);
            shouldSleep = false;
        } else if (this.mPausingActivity != null) {
            shouldSleep = false;
        }
        if (!shuttingDown) {
            if (this.containsActivityFromStack(this.mStackSupervisor.mStoppingActivities)) {
                this.mStackSupervisor.scheduleIdleLocked();
                shouldSleep = false;
            }
            if (this.containsActivityFromStack(this.mStackSupervisor.mGoingToSleepActivities)) {
                shouldSleep = false;
            }
        }
        if (shouldSleep) {
            this.goToSleep();
        }
        return shouldSleep;
    }

    void goToSleep() {
        this.ensureActivitiesVisibleLocked(null, 0, false);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isState(ActivityState.STOPPING, ActivityState.STOPPED, ActivityState.PAUSED, ActivityState.PAUSING)) continue;
                r.setSleeping(true);
            }
        }
    }

    private boolean containsActivityFromStack(List<ActivityRecord> rs) {
        for (ActivityRecord r : rs) {
            if (r.getStack() != this) continue;
            return true;
        }
        return false;
    }

    private void schedulePauseTimeout(ActivityRecord r) {
        Message msg = this.mHandler.obtainMessage(101);
        msg.obj = r;
        r.pauseTime = SystemClock.uptimeMillis();
        this.mHandler.sendMessageDelayed(msg, 500L);
    }

    final boolean startPausingLocked(boolean userLeaving, boolean uiSleeping, ActivityRecord resuming, boolean pauseImmediately) {
        ActivityRecord prev;
        if (this.mPausingActivity != null) {
            Slog.wtf("ActivityManager", "Going to pause when pause is already pending for " + this.mPausingActivity + " state=" + (Object)((Object)this.mPausingActivity.getState()));
            if (!this.shouldSleepActivities()) {
                this.completePauseLocked(false, resuming);
            }
        }
        if ((prev = this.mResumedActivity) == null) {
            if (resuming == null) {
                Slog.wtf("ActivityManager", "Trying to pause when nothing is resumed");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return false;
        }
        if (prev == resuming) {
            Slog.wtf("ActivityManager", "Trying to pause activity that is in process of being resumed");
            return false;
        }
        this.mPausingActivity = prev;
        this.mLastPausedActivity = prev;
        this.mLastNoHistoryActivity = (prev.intent.getFlags() & 0x40000000) != 0 || (prev.info.flags & 0x80) != 0 ? prev : null;
        prev.setState(ActivityState.PAUSING, "startPausingLocked");
        prev.getTask().touchActiveTime();
        this.clearLaunchTime(prev);
        this.mStackSupervisor.getLaunchTimeTracker().stopFullyDrawnTraceIfNeeded(this.getWindowingMode());
        this.mService.updateCpuStats();
        if (prev.app != null && prev.app.thread != null) {
            try {
                EventLogTags.writeAmPauseActivity(prev.userId, System.identityHashCode(prev), prev.shortComponentName, "userLeaving=" + userLeaving);
                this.mService.updateUsageStats(prev, false);
                this.mService.getLifecycleManager().scheduleTransaction(prev.app.thread, (IBinder)prev.appToken, PauseActivityItem.obtain(prev.finishing, userLeaving, prev.configChangeFlags, pauseImmediately));
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during pause", e);
                this.mPausingActivity = null;
                this.mLastPausedActivity = null;
                this.mLastNoHistoryActivity = null;
            }
        } else {
            this.mPausingActivity = null;
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        if (!uiSleeping && !this.mService.isSleepingOrShuttingDownLocked()) {
            this.mStackSupervisor.acquireLaunchWakelock();
        }
        if (this.mPausingActivity != null) {
            if (!uiSleeping) {
                prev.pauseKeyDispatchingLocked();
            }
            if (pauseImmediately) {
                this.completePauseLocked(false, resuming);
                return false;
            }
            this.schedulePauseTimeout(prev);
            return true;
        }
        if (resuming == null) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityPausedLocked(IBinder token, boolean timeout) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(101, r);
            if (this.mPausingActivity == r) {
                this.mService.mWindowManager.deferSurfaceLayout();
                try {
                    this.completePauseLocked(true, null);
                }
                finally {
                    this.mService.mWindowManager.continueSurfaceLayout();
                }
                return;
            }
            EventLog.writeEvent(30012, r.userId, System.identityHashCode(r), r.shortComponentName, this.mPausingActivity != null ? this.mPausingActivity.shortComponentName : "(none)");
            if (r.isState(ActivityState.PAUSING)) {
                r.setState(ActivityState.PAUSED, "activityPausedLocked");
                if (r.finishing) {
                    this.finishCurrentActivityLocked(r, 2, false, "activityPausedLocked");
                }
            }
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePauseLocked(boolean resumeNext, ActivityRecord resuming) {
        ActivityRecord prev = this.mPausingActivity;
        if (prev != null) {
            prev.setWillCloseOrEnterPip(false);
            boolean wasStopping = prev.isState(ActivityState.STOPPING);
            prev.setState(ActivityState.PAUSED, "completePausedLocked");
            if (prev.finishing) {
                prev = this.finishCurrentActivityLocked(prev, 2, false, "completedPausedLocked");
            } else if (prev.app != null) {
                if (this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(prev)) {
                    // empty if block
                }
                if (prev.deferRelaunchUntilPaused) {
                    prev.relaunchActivityLocked(false, prev.preserveWindowOnDeferredRelaunch);
                } else if (wasStopping) {
                    prev.setState(ActivityState.STOPPING, "completePausedLocked");
                } else if (!prev.visible || this.shouldSleepOrShutDownActivities()) {
                    prev.setDeferHidingClient(false);
                    this.addToStopping(prev, true, false);
                }
            } else {
                prev = null;
            }
            if (prev != null) {
                prev.stopFreezingScreenLocked(true);
            }
            this.mPausingActivity = null;
        }
        if (resumeNext) {
            ActivityStack topStack = this.mStackSupervisor.getFocusedStack();
            if (!topStack.shouldSleepOrShutDownActivities()) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked(topStack, prev, null);
            } else {
                this.checkReadyForSleep();
                ActivityRecord top = topStack.topRunningActivityLocked();
                if (top == null || prev != null && top != prev) {
                    this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
            }
        }
        if (prev != null) {
            long diff;
            prev.resumeKeyDispatchingLocked();
            if (prev.app != null && prev.cpuTimeAtResume > 0L && this.mService.mBatteryStatsService.isOnBattery() && (diff = this.mService.mProcessCpuTracker.getCpuTimeForPid(prev.app.pid) - prev.cpuTimeAtResume) > 0L) {
                BatteryStatsImpl bsi;
                BatteryStatsImpl batteryStatsImpl = bsi = this.mService.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(prev.info.applicationInfo.uid, prev.info.packageName);
                    if (ps != null) {
                        ps.addForegroundTimeLocked(diff);
                    }
                }
            }
            prev.cpuTimeAtResume = 0L;
        }
        if (this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause || this.getDisplay().hasPinnedStack()) {
            this.mService.mTaskChangeNotificationController.notifyTaskStackChanged();
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = false;
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(resuming, 0, false);
    }

    void addToStopping(ActivityRecord r, boolean scheduleIdle, boolean idleDelayed) {
        boolean forceIdle;
        if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
            this.mStackSupervisor.mStoppingActivities.add(r);
            if (!this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.isEmpty() && !this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(r)) {
                this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.add(r);
            }
        }
        boolean bl = forceIdle = this.mStackSupervisor.mStoppingActivities.size() > 3 || r.frontOfTask && this.mTaskHistory.size() <= 1;
        if (scheduleIdle || forceIdle) {
            if (!idleDelayed) {
                this.mStackSupervisor.scheduleIdleLocked();
            } else {
                this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
            }
        } else {
            this.checkReadyForSleep();
        }
    }

    @VisibleForTesting
    boolean isStackTranslucent(ActivityRecord starting) {
        if (!this.isAttached() || this.mForceHidden) {
            return true;
        }
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || !r.visibleIgnoringKeyguard && r != starting || !r.fullscreen && !r.hasWallpaper) continue;
                return false;
            }
        }
        return true;
    }

    boolean isTopStackOnDisplay() {
        return this.getDisplay().isTopStack(this);
    }

    boolean isTopActivityVisible() {
        ActivityRecord topActivity = this.getTopActivity();
        return topActivity != null && topActivity.visible;
    }

    boolean shouldBeVisible(ActivityRecord starting) {
        if (!this.isAttached() || this.mForceHidden) {
            return false;
        }
        if (this.mStackSupervisor.isFocusedStack(this)) {
            return true;
        }
        ActivityRecord top = this.topRunningActivityLocked();
        if (top == null && this.isInStackLocked(starting) == null && !this.isTopStackOnDisplay()) {
            return false;
        }
        ActivityDisplay display = this.getDisplay();
        boolean gotSplitScreenStack = false;
        boolean gotOpaqueSplitScreenPrimary = false;
        boolean gotOpaqueSplitScreenSecondary = false;
        int windowingMode = this.getWindowingMode();
        boolean isAssistantType = this.isActivityTypeAssistant();
        for (int i = display.getChildCount() - 1; i >= 0; --i) {
            ActivityStack other = display.getChildAt(i);
            if (other == this) {
                return true;
            }
            int otherWindowingMode = other.getWindowingMode();
            if (otherWindowingMode == 1) {
                int activityType = other.getActivityType();
                if (windowingMode == 3 && (activityType == 2 || activityType == 4 && this.mWindowManager.getRecentsAnimationController() != null)) {
                    return true;
                }
                if (other.isStackTranslucent(starting)) continue;
                return false;
            }
            if (otherWindowingMode == 3 && !gotOpaqueSplitScreenPrimary) {
                gotSplitScreenStack = true;
                boolean bl = gotOpaqueSplitScreenPrimary = !other.isStackTranslucent(starting);
                if (windowingMode == 3 && gotOpaqueSplitScreenPrimary) {
                    return false;
                }
            } else if (otherWindowingMode == 4 && !gotOpaqueSplitScreenSecondary) {
                gotSplitScreenStack = true;
                boolean bl = gotOpaqueSplitScreenSecondary = !other.isStackTranslucent(starting);
                if (windowingMode == 4 && gotOpaqueSplitScreenSecondary) {
                    return false;
                }
            }
            if (gotOpaqueSplitScreenPrimary && gotOpaqueSplitScreenSecondary) {
                return false;
            }
            if (!isAssistantType || !gotSplitScreenStack) continue;
            return false;
        }
        return true;
    }

    final int rankTaskLayers(int baseLayer) {
        int layer = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ActivityRecord r = task.topRunningActivityLocked();
            task.mLayerRank = r == null || r.finishing || !r.visible ? -1 : baseLayer + layer++;
        }
        return layer;
    }

    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        this.ensureActivitiesVisibleLocked(starting, configChanges, preserveWindows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows, boolean notifyClients) {
        this.mTopActivityOccludesKeyguard = false;
        this.mTopDismissingKeyguardActivity = null;
        this.mStackSupervisor.getKeyguardController().beginActivityVisibilityUpdate();
        try {
            ActivityRecord top = this.topRunningActivityLocked();
            if (top != null) {
                this.checkTranslucentActivityWaiting(top);
            }
            boolean aboveTop = top != null;
            boolean stackShouldBeVisible = this.shouldBeVisible(starting);
            boolean behindFullscreenActivity = !stackShouldBeVisible;
            boolean resumeNextActivity = this.mStackSupervisor.isFocusedStack(this) && this.isInStackLocked(starting) == null;
            boolean isTopNotPinnedStack = this.isAttached() && this.getDisplay().isTopNotPinnedStack(this);
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                TaskRecord task = this.mTaskHistory.get(taskNdx);
                ArrayList<ActivityRecord> activities = task.mActivities;
                for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                    boolean visibleIgnoringKeyguard;
                    boolean isTop;
                    ActivityRecord r = activities.get(activityNdx);
                    if (r.finishing) continue;
                    boolean bl = isTop = r == top;
                    if (aboveTop && !isTop) continue;
                    aboveTop = false;
                    r.visibleIgnoringKeyguard = visibleIgnoringKeyguard = r.shouldBeVisibleIgnoringKeyguard(behindFullscreenActivity);
                    boolean reallyVisible = this.checkKeyguardVisibility(r, visibleIgnoringKeyguard, isTop && isTopNotPinnedStack);
                    if (visibleIgnoringKeyguard) {
                        behindFullscreenActivity = this.updateBehindFullscreen(!stackShouldBeVisible, behindFullscreenActivity, r);
                    }
                    if (reallyVisible) {
                        if (r != starting && notifyClients) {
                            r.ensureActivityConfiguration(0, preserveWindows, true);
                        }
                        if (r.app == null || r.app.thread == null) {
                            if (this.makeVisibleAndRestartIfNeeded(starting, configChanges, isTop, resumeNextActivity, r)) {
                                if (activityNdx >= activities.size()) {
                                    activityNdx = activities.size() - 1;
                                } else {
                                    resumeNextActivity = false;
                                }
                            }
                        } else if (r.visible) {
                            if (r.mClientVisibilityDeferred && notifyClients) {
                                r.makeClientVisible();
                            }
                            if (r.handleAlreadyVisible()) {
                                resumeNextActivity = false;
                            }
                        } else {
                            r.makeVisibleIfNeeded(starting, notifyClients);
                        }
                        configChanges |= r.configChangeFlags;
                        continue;
                    }
                    this.makeInvisible(r);
                }
                int windowingMode = this.getWindowingMode();
                if (windowingMode == 5) {
                    behindFullscreenActivity = !stackShouldBeVisible;
                    continue;
                }
                if (!this.isActivityTypeHome()) continue;
                behindFullscreenActivity = true;
            }
            if (this.mTranslucentActivityWaiting != null && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
                this.notifyActivityDrawnLocked(null);
            }
        }
        finally {
            this.mStackSupervisor.getKeyguardController().endActivityVisibilityUpdate();
        }
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).addStartingWindowsForVisibleActivities(taskSwitch);
        }
    }

    boolean topActivityOccludesKeyguard() {
        return this.mTopActivityOccludesKeyguard;
    }

    boolean resizeStackWithLaunchBounds() {
        return this.inPinnedWindowingMode();
    }

    @Override
    public boolean supportsSplitScreenWindowingMode() {
        TaskRecord topTask = this.topTask();
        return super.supportsSplitScreenWindowingMode() && (topTask == null || topTask.supportsSplitScreenWindowingMode());
    }

    boolean affectedBySplitScreenResize() {
        if (!this.supportsSplitScreenWindowingMode()) {
            return false;
        }
        int windowingMode = this.getWindowingMode();
        return windowingMode != 5 && windowingMode != 2;
    }

    ActivityRecord getTopDismissingKeyguardActivity() {
        return this.mTopDismissingKeyguardActivity;
    }

    boolean checkKeyguardVisibility(ActivityRecord r, boolean shouldBeVisible, boolean isTop) {
        int displayId = this.mDisplayId != -1 ? this.mDisplayId : 0;
        boolean keyguardOrAodShowing = this.mStackSupervisor.getKeyguardController().isKeyguardOrAodShowing(displayId);
        boolean keyguardLocked = this.mStackSupervisor.getKeyguardController().isKeyguardLocked();
        boolean showWhenLocked = r.canShowWhenLocked();
        boolean dismissKeyguard = r.hasDismissKeyguardWindows();
        if (shouldBeVisible) {
            boolean canShowWithKeyguard;
            if (dismissKeyguard && this.mTopDismissingKeyguardActivity == null) {
                this.mTopDismissingKeyguardActivity = r;
            }
            if (isTop) {
                this.mTopActivityOccludesKeyguard |= showWhenLocked;
            }
            boolean bl = canShowWithKeyguard = this.canShowWithInsecureKeyguard() && this.mStackSupervisor.getKeyguardController().canDismissKeyguard();
            if (canShowWithKeyguard) {
                return true;
            }
        }
        if (keyguardOrAodShowing) {
            return shouldBeVisible && this.mStackSupervisor.getKeyguardController().canShowActivityWhileKeyguardShowing(r, dismissKeyguard);
        }
        if (keyguardLocked) {
            return shouldBeVisible && this.mStackSupervisor.getKeyguardController().canShowWhileOccluded(dismissKeyguard, showWhenLocked);
        }
        return shouldBeVisible;
    }

    private boolean canShowWithInsecureKeyguard() {
        ActivityDisplay activityDisplay = this.getDisplay();
        if (activityDisplay == null) {
            throw new IllegalStateException("Stack is not attached to any display, stackId=" + this.mStackId);
        }
        int flags = activityDisplay.mDisplay.getFlags();
        return (flags & 0x20) != 0;
    }

    private void checkTranslucentActivityWaiting(ActivityRecord top) {
        if (this.mTranslucentActivityWaiting != top) {
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            if (this.mTranslucentActivityWaiting != null) {
                this.notifyActivityDrawnLocked(null);
                this.mTranslucentActivityWaiting = null;
            }
            this.mHandler.removeMessages(106);
        }
    }

    private boolean makeVisibleAndRestartIfNeeded(ActivityRecord starting, int configChanges, boolean isTop, boolean andResume, ActivityRecord r) {
        if (isTop || !r.visible) {
            if (r != starting) {
                r.startFreezingScreenLocked(r.app, configChanges);
            }
            if (!r.visible || r.mLaunchTaskBehind) {
                r.setVisible(true);
            }
            if (r != starting) {
                this.mStackSupervisor.startSpecificActivityLocked(r, andResume, false);
                return true;
            }
        }
        return false;
    }

    private void makeInvisible(ActivityRecord r) {
        if (!r.visible) {
            return;
        }
        try {
            boolean canEnterPictureInPicture = r.checkEnterPictureInPictureState("makeInvisible", true);
            boolean deferHidingClient = canEnterPictureInPicture && !r.isState(ActivityState.STOPPING, ActivityState.STOPPED, ActivityState.PAUSED);
            r.setDeferHidingClient(deferHidingClient);
            r.setVisible(false);
            switch (r.getState()) {
                case STOPPING: 
                case STOPPED: {
                    if (r.app != null && r.app.thread != null) {
                        this.mService.getLifecycleManager().scheduleTransaction(r.app.thread, (IBinder)r.appToken, WindowVisibilityItem.obtain(false));
                    }
                    r.supportsEnterPipOnTaskSwitch = false;
                    break;
                }
                case INITIALIZING: 
                case RESUMED: 
                case PAUSING: 
                case PAUSED: {
                    this.addToStopping(r, true, canEnterPictureInPicture);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making hidden: " + r.intent.getComponent(), e);
        }
    }

    private boolean updateBehindFullscreen(boolean stackInvisible, boolean behindFullscreenActivity, ActivityRecord r) {
        if (r.fullscreen) {
            behindFullscreenActivity = true;
        }
        return behindFullscreenActivity;
    }

    void convertActivityToTranslucent(ActivityRecord r) {
        this.mTranslucentActivityWaiting = r;
        this.mUndrawnActivitiesBelowTopTranslucent.clear();
        this.mHandler.sendEmptyMessageDelayed(106, 2000L);
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appTimeTracker == except) continue;
                r.appTimeTracker = null;
            }
        }
    }

    void notifyActivityDrawnLocked(ActivityRecord r) {
        if (r == null || this.mUndrawnActivitiesBelowTopTranslucent.remove(r) && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            ActivityRecord waitingActivity = this.mTranslucentActivityWaiting;
            this.mTranslucentActivityWaiting = null;
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            this.mHandler.removeMessages(106);
            if (waitingActivity != null) {
                this.mWindowManager.setWindowOpaque(waitingActivity.appToken, false);
                if (waitingActivity.app != null && waitingActivity.app.thread != null) {
                    try {
                        waitingActivity.app.thread.scheduleTranslucentConversionComplete(waitingActivity.appToken, r != null);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void cancelInitializingActivities() {
        ActivityRecord topActivity = this.topRunningActivityLocked();
        boolean aboveTop = true;
        boolean behindFullscreenActivity = false;
        if (!this.shouldBeVisible(null)) {
            aboveTop = false;
            behindFullscreenActivity = true;
        }
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (aboveTop) {
                    if (r == topActivity) {
                        aboveTop = false;
                    }
                    behindFullscreenActivity |= r.fullscreen;
                    continue;
                }
                r.removeOrphanedStartingWindow(behindFullscreenActivity);
                behindFullscreenActivity |= r.fullscreen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mService")
    boolean resumeTopActivityUncheckedLocked(ActivityRecord prev, ActivityOptions options) {
        if (this.mStackSupervisor.inResumeTopActivity) {
            return false;
        }
        boolean result = false;
        try {
            this.mStackSupervisor.inResumeTopActivity = true;
            result = this.resumeTopActivityInnerLocked(prev, options);
            ActivityRecord next = this.topRunningActivityLocked(true);
            if (next == null || !next.canTurnScreenOn()) {
                this.checkReadyForSleep();
            }
        }
        finally {
            this.mStackSupervisor.inResumeTopActivity = false;
        }
        return result;
    }

    protected ActivityRecord getResumedActivity() {
        return this.mResumedActivity;
    }

    private void setResumedActivity(ActivityRecord r, String reason) {
        if (this.mResumedActivity == r) {
            return;
        }
        this.mResumedActivity = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mService")
    private boolean resumeTopActivityInnerLocked(ActivityRecord prev, ActivityOptions options) {
        boolean hasRunningActivity;
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        ActivityRecord next = this.topRunningActivityLocked(true);
        boolean bl = hasRunningActivity = next != null;
        if (hasRunningActivity && !this.isAttached()) {
            return false;
        }
        this.mStackSupervisor.cancelInitializingActivities();
        boolean userLeaving = this.mStackSupervisor.mUserLeaving;
        this.mStackSupervisor.mUserLeaving = false;
        if (!hasRunningActivity) {
            return this.resumeTopActivityInNextFocusableStack(prev, options, "noMoreActivities");
        }
        next.delayedResume = false;
        if (this.mResumedActivity == next && next.isState(ActivityState.RESUMED) && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.executeAppTransition(options);
            return false;
        }
        if (this.shouldSleepOrShutDownActivities() && this.mLastPausedActivity == next && this.mStackSupervisor.allPausedActivitiesComplete()) {
            this.executeAppTransition(options);
            return false;
        }
        if (!this.mService.mUserController.hasStartedUserState(next.userId)) {
            Slog.w("ActivityManager", "Skipping resume of top activity " + next + ": user " + next.userId + " is stopped");
            return false;
        }
        this.mStackSupervisor.mStoppingActivities.remove(next);
        this.mStackSupervisor.mGoingToSleepActivities.remove(next);
        next.sleeping = false;
        this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(next);
        if (!this.mStackSupervisor.allPausedActivitiesComplete()) {
            return false;
        }
        this.mStackSupervisor.setLaunchSource(next.info.applicationInfo.uid);
        boolean lastResumedCanPip = false;
        ActivityRecord lastResumed = null;
        ActivityStack lastFocusedStack = this.mStackSupervisor.getLastStack();
        if (lastFocusedStack != null && lastFocusedStack != this) {
            lastResumed = lastFocusedStack.mResumedActivity;
            if (userLeaving && this.inMultiWindowMode() && lastFocusedStack.shouldBeVisible(next)) {
                userLeaving = false;
            }
            lastResumedCanPip = lastResumed != null && lastResumed.checkEnterPictureInPictureState("resumeTopActivity", userLeaving);
        }
        boolean resumeWhilePausing = (next.info.flags & 0x4000) != 0 && !lastResumedCanPip;
        boolean pausing = this.mStackSupervisor.pauseBackStacks(userLeaving, next, false);
        if (this.mResumedActivity != null) {
            pausing |= this.startPausingLocked(userLeaving, false, next, false);
        }
        if (pausing && !resumeWhilePausing) {
            if (next.app != null && next.app.thread != null) {
                this.mService.updateLruProcessLocked(next.app, true, null);
            }
            if (lastResumed != null) {
                lastResumed.setWillCloseOrEnterPip(true);
            }
            return true;
        }
        if (this.mResumedActivity == next && next.isState(ActivityState.RESUMED) && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.executeAppTransition(options);
            return true;
        }
        if (this.shouldSleepActivities() && this.mLastNoHistoryActivity != null && !this.mLastNoHistoryActivity.finishing) {
            this.requestFinishActivityLocked(this.mLastNoHistoryActivity.appToken, 0, null, "resume-no-history", false);
            this.mLastNoHistoryActivity = null;
        }
        if (prev != null && prev != next) {
            if (!this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(prev) && next != null && !next.nowVisible) {
                this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.add(prev);
            } else if (prev.finishing) {
                prev.setVisibility(false);
            }
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(next.packageName, false, next.userId);
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + next.packageName + ": " + e);
        }
        boolean anim2 = true;
        if (prev != null) {
            if (prev.finishing) {
                if (this.mStackSupervisor.mNoAnimActivities.contains(prev)) {
                    anim2 = false;
                    this.mWindowManager.prepareAppTransition(0, false);
                } else {
                    this.mWindowManager.prepareAppTransition(prev.getTask() == next.getTask() ? 7 : 9, false);
                }
                prev.setVisibility(false);
            } else if (this.mStackSupervisor.mNoAnimActivities.contains(next)) {
                anim2 = false;
                this.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mWindowManager.prepareAppTransition(prev.getTask() == next.getTask() ? 6 : (next.mLaunchTaskBehind ? 16 : 8), false);
            }
        } else if (this.mStackSupervisor.mNoAnimActivities.contains(next)) {
            anim2 = false;
            this.mWindowManager.prepareAppTransition(0, false);
        } else {
            this.mWindowManager.prepareAppTransition(6, false);
        }
        if (anim2) {
            next.applyOptionsLocked();
        } else {
            next.clearOptionsLocked();
        }
        this.mStackSupervisor.mNoAnimActivities.clear();
        ActivityStack lastStack = this.mStackSupervisor.getLastStack();
        if (next.app != null && next.app.thread != null) {
            boolean lastActivityTranslucent = lastStack != null && (lastStack.inMultiWindowMode() || lastStack.mLastPausedActivity != null && !lastStack.mLastPausedActivity.fullscreen);
            Object object = this.mWindowManager.getWindowManagerLock();
            synchronized (object) {
                if (!next.visible || next.stopped || lastActivityTranslucent) {
                    next.setVisibility(true);
                }
                next.startLaunchTickingLocked();
                ActivityRecord lastResumedActivity = lastStack == null ? null : lastStack.mResumedActivity;
                ActivityState lastState = next.getState();
                this.mService.updateCpuStats();
                next.setState(ActivityState.RESUMED, "resumeTopActivityInnerLocked");
                this.mService.updateLruProcessLocked(next.app, true, null);
                this.updateLRUListLocked(next);
                this.mService.updateOomAdjLocked();
                boolean notUpdated = true;
                if (this.mStackSupervisor.isFocusedStack(this)) {
                    boolean bl2 = notUpdated = !this.mStackSupervisor.ensureVisibilityAndConfig(next, this.mDisplayId, true, false);
                }
                if (notUpdated) {
                    ActivityRecord nextNext = this.topRunningActivityLocked();
                    if (nextNext != next) {
                        this.mStackSupervisor.scheduleResumeTopActivities();
                    }
                    if (!next.visible || next.stopped) {
                        next.setVisibility(true);
                    }
                    next.completeResumeLocked();
                    return true;
                }
                try {
                    ClientTransaction transaction = ClientTransaction.obtain(next.app.thread, next.appToken);
                    ArrayList<ResultInfo> a = next.results;
                    if (a != null) {
                        int N = a.size();
                        if (!next.finishing && N > 0) {
                            transaction.addCallback(ActivityResultItem.obtain(a));
                        }
                    }
                    if (next.newIntents != null) {
                        transaction.addCallback(NewIntentItem.obtain(next.newIntents, false));
                    }
                    next.notifyAppResumed(next.stopped);
                    EventLog.writeEvent(30007, next.userId, System.identityHashCode(next), next.getTask().taskId, next.shortComponentName);
                    next.sleeping = false;
                    this.mService.getAppWarningsLocked().onResumeActivity(next);
                    this.mService.showAskCompatModeDialogLocked(next);
                    next.app.pendingUiClean = true;
                    next.app.forceProcessStateUpTo(this.mService.mTopProcessState);
                    next.clearOptionsLocked();
                    transaction.setLifecycleStateRequest(ResumeActivityItem.obtain(next.app.repProcState, this.mService.isNextTransitionForward()));
                    this.mService.getLifecycleManager().scheduleTransaction(transaction);
                }
                catch (Exception e) {
                    next.setState(lastState, "resumeTopActivityInnerLocked");
                    if (lastResumedActivity != null) {
                        lastResumedActivity.setState(ActivityState.RESUMED, "resumeTopActivityInnerLocked");
                    }
                    Slog.i("ActivityManager", "Restarting because process died: " + next);
                    if (!next.hasBeenLaunched) {
                        next.hasBeenLaunched = true;
                    } else if (lastStack != null && lastStack.isTopStackOnDisplay()) {
                        next.showStartingWindow(null, false, false);
                    }
                    this.mStackSupervisor.startSpecificActivityLocked(next, true, false);
                    return true;
                }
            }
            try {
                next.completeResumeLocked();
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during resume of " + next, e);
                this.requestFinishActivityLocked(next.appToken, 0, null, "resume-exception", true);
                return true;
            }
        }
        if (!next.hasBeenLaunched) {
            next.hasBeenLaunched = true;
        } else {
            next.showStartingWindow(null, false, false);
        }
        this.mStackSupervisor.startSpecificActivityLocked(next, true, true);
        return true;
    }

    private boolean resumeTopActivityInNextFocusableStack(ActivityRecord prev, ActivityOptions options, String reason) {
        if (this.adjustFocusToNextFocusableStack(reason)) {
            return this.mStackSupervisor.resumeFocusedStackTopActivityLocked(this.mStackSupervisor.getFocusedStack(), prev, null);
        }
        ActivityOptions.abort(options);
        return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(prev, reason);
    }

    private TaskRecord getNextTask(TaskRecord targetTask) {
        int index = this.mTaskHistory.indexOf(targetTask);
        if (index >= 0) {
            int numTasks = this.mTaskHistory.size();
            for (int i = index + 1; i < numTasks; ++i) {
                TaskRecord task = this.mTaskHistory.get(i);
                if (task.userId != targetTask.userId) continue;
                return task;
            }
        }
        return null;
    }

    int getAdjustedPositionForTask(TaskRecord task, int suggestedPosition, ActivityRecord starting) {
        int maxPosition;
        if (starting != null && starting.okToShowLocked() || starting == null && task.okToShowLocked()) {
            return Math.min(suggestedPosition, maxPosition);
        }
        for (maxPosition = this.mTaskHistory.size(); maxPosition > 0; --maxPosition) {
            TaskRecord tmpTask = this.mTaskHistory.get(maxPosition - 1);
            if (!this.mStackSupervisor.isCurrentProfileLocked(tmpTask.userId) || tmpTask.topRunningActivityLocked() == null) break;
        }
        return Math.min(suggestedPosition, maxPosition);
    }

    private void insertTaskAtPosition(TaskRecord task, int position) {
        if (position >= this.mTaskHistory.size()) {
            this.insertTaskAtTop(task, null);
            return;
        }
        if (position <= 0) {
            this.insertTaskAtBottom(task);
            return;
        }
        position = this.getAdjustedPositionForTask(task, position, null);
        this.mTaskHistory.remove(task);
        this.mTaskHistory.add(position, task);
        ((StackWindowController)this.mWindowContainerController).positionChildAt(task.getWindowContainerController(), position);
        this.updateTaskMovement(task, true);
    }

    private void insertTaskAtTop(TaskRecord task, ActivityRecord starting) {
        this.mTaskHistory.remove(task);
        int position = this.getAdjustedPositionForTask(task, this.mTaskHistory.size(), starting);
        this.mTaskHistory.add(position, task);
        this.updateTaskMovement(task, true);
        ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
    }

    private void insertTaskAtBottom(TaskRecord task) {
        this.mTaskHistory.remove(task);
        int position = this.getAdjustedPositionForTask(task, 0, null);
        this.mTaskHistory.add(position, task);
        this.updateTaskMovement(task, true);
        ((StackWindowController)this.mWindowContainerController).positionChildAtBottom(task.getWindowContainerController(), true);
    }

    void startActivityLocked(ActivityRecord r, ActivityRecord focusedTopActivity, boolean newTask, boolean keepCurTransition, ActivityOptions options) {
        TaskRecord activityTask;
        TaskRecord rTask = r.getTask();
        int taskId = rTask.taskId;
        if (!r.mLaunchTaskBehind && (this.taskForIdLocked(taskId) == null || newTask)) {
            this.insertTaskAtTop(rTask, r);
        }
        TaskRecord task = null;
        if (!newTask) {
            boolean startIt = true;
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                task = this.mTaskHistory.get(taskNdx);
                if (task.getTopActivity() == null) continue;
                if (task == rTask) {
                    if (startIt) break;
                    r.createWindowContainer();
                    ActivityOptions.abort(options);
                    return;
                }
                if (task.numFullscreen <= 0) continue;
                startIt = false;
            }
        }
        if (task == (activityTask = r.getTask()) && this.mTaskHistory.indexOf(task) != this.mTaskHistory.size() - 1) {
            this.mStackSupervisor.mUserLeaving = false;
        }
        task = activityTask;
        if (r.getWindowContainerController() == null) {
            r.createWindowContainer();
        }
        task.setFrontOfTask();
        if (!this.isHomeOrRecentsStack() || this.numActivities() > 0) {
            if ((r.intent.getFlags() & 0x10000) != 0) {
                this.mWindowManager.prepareAppTransition(0, keepCurTransition);
                this.mStackSupervisor.mNoAnimActivities.add(r);
            } else {
                int transit = 6;
                if (newTask) {
                    if (r.mLaunchTaskBehind) {
                        transit = 16;
                    } else {
                        if (this.canEnterPipOnTaskSwitch(focusedTopActivity, null, r, options)) {
                            focusedTopActivity.supportsEnterPipOnTaskSwitch = true;
                        }
                        transit = 8;
                    }
                }
                this.mWindowManager.prepareAppTransition(transit, keepCurTransition);
                this.mStackSupervisor.mNoAnimActivities.remove(r);
            }
            boolean doShow = true;
            if (newTask) {
                if ((r.intent.getFlags() & 0x200000) != 0) {
                    this.resetTaskIfNeededLocked(r, r);
                    doShow = this.topRunningNonDelayedActivityLocked(null) == r;
                }
            } else if (options != null && options.getAnimationType() == 5) {
                doShow = false;
            }
            if (r.mLaunchTaskBehind) {
                r.setVisibility(true);
                this.ensureActivitiesVisibleLocked(null, 0, false);
            } else if (doShow) {
                TaskRecord prevTask = r.getTask();
                ActivityRecord prev = prevTask.topRunningActivityWithStartingWindowLocked();
                if (prev != null) {
                    if (prev.getTask() != prevTask) {
                        prev = null;
                    } else if (prev.nowVisible) {
                        prev = null;
                    }
                }
                r.showStartingWindow(prev, newTask, this.isTaskSwitch(r, focusedTopActivity));
            }
        } else {
            ActivityOptions.abort(options);
        }
    }

    private boolean canEnterPipOnTaskSwitch(ActivityRecord pipCandidate, TaskRecord toFrontTask, ActivityRecord toFrontActivity, ActivityOptions opts) {
        Object targetStack;
        if (opts != null && opts.disallowEnterPictureInPictureWhileLaunching()) {
            return false;
        }
        if (pipCandidate == null || pipCandidate.inPinnedWindowingMode()) {
            return false;
        }
        Object t = targetStack = toFrontTask != null ? toFrontTask.getStack() : toFrontActivity.getStack();
        return targetStack == null || !((ConfigurationContainer)targetStack).isActivityTypeAssistant();
    }

    private boolean isTaskSwitch(ActivityRecord r, ActivityRecord topFocusedActivity) {
        return topFocusedActivity != null && r.getTask() != topFocusedActivity.getTask();
    }

    private ActivityOptions resetTargetTaskIfNeededLocked(TaskRecord task, boolean forceReset) {
        ActivityOptions topOptions = null;
        int replyChainEnd = -1;
        boolean canMoveOptions = true;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = task.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            boolean clearWhenTaskReset;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean allowTaskReparenting = (flags & 0x40) != 0;
            boolean bl = clearWhenTaskReset = (target.intent.getFlags() & 0x80000) != 0;
            if (!finishOnTaskLaunch && !clearWhenTaskReset && target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!finishOnTaskLaunch && !clearWhenTaskReset && allowTaskReparenting && target.taskAffinity != null && !target.taskAffinity.equals(task.affinity)) {
                int start;
                TaskRecord targetTask;
                ActivityRecord bottom;
                ActivityRecord activityRecord = bottom = !this.mTaskHistory.isEmpty() && !this.mTaskHistory.get((int)0).mActivities.isEmpty() ? this.mTaskHistory.get((int)0).mActivities.get(0) : null;
                if (bottom != null && target.taskAffinity != null && target.taskAffinity.equals(bottom.getTask().affinity)) {
                    targetTask = bottom.getTask();
                } else {
                    targetTask = this.createTaskRecord(this.mStackSupervisor.getNextTaskIdForUserLocked(target.userId), target.info, null, null, null, false);
                    targetTask.affinityIntent = target.intent;
                }
                boolean noOptions = canMoveOptions;
                for (int srcPos = start = replyChainEnd < 0 ? i : replyChainEnd; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    p.reparent(targetTask, 0, "resetTargetTaskIfNeeded");
                }
                ((StackWindowController)this.mWindowContainerController).positionChildAtBottom(targetTask.getWindowContainerController(), false);
                replyChainEnd = -1;
                continue;
            }
            if (forceReset || finishOnTaskLaunch || clearWhenTaskReset) {
                int end = clearWhenTaskReset ? activities.size() - 1 : (replyChainEnd < 0 ? i : replyChainEnd);
                boolean noOptions = canMoveOptions;
                for (int srcPos = i; srcPos <= end; ++srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    if (!this.finishActivityLocked(p, 0, null, "reset-task", false)) continue;
                    --end;
                    --srcPos;
                }
                replyChainEnd = -1;
                continue;
            }
            replyChainEnd = -1;
        }
        return topOptions;
    }

    private int resetAffinityTaskIfNeededLocked(TaskRecord affinityTask, TaskRecord task, boolean topTaskIsHigher, boolean forceReset, int taskInsertionPoint) {
        int replyChainEnd = -1;
        int taskId = task.taskId;
        String taskAffinity = task.affinity;
        ArrayList<ActivityRecord> activities = affinityTask.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = affinityTask.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            int start;
            boolean allowTaskReparenting;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean bl = allowTaskReparenting = (flags & 0x40) != 0;
            if (target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!topTaskIsHigher || !allowTaskReparenting || taskAffinity == null || !taskAffinity.equals(target.taskAffinity)) continue;
            if (forceReset || finishOnTaskLaunch) {
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    this.finishActivityLocked(p, 0, null, "move-affinity", false);
                }
            } else {
                ArrayList<ActivityRecord> taskActivities;
                int targetNdx;
                if (taskInsertionPoint < 0) {
                    taskInsertionPoint = task.mActivities.size();
                }
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    p.reparent(task, taskInsertionPoint, "resetAffinityTaskIfNeededLocked");
                }
                ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
                if (target.info.launchMode == 1 && (targetNdx = (taskActivities = task.mActivities).indexOf(target)) > 0) {
                    ActivityRecord p = taskActivities.get(targetNdx - 1);
                    if (p.intent.getComponent().equals(target.intent.getComponent())) {
                        this.finishActivityLocked(p, 0, null, "replace", false);
                    }
                }
            }
            replyChainEnd = -1;
        }
        return taskInsertionPoint;
    }

    final ActivityRecord resetTaskIfNeededLocked(ActivityRecord taskTop, ActivityRecord newActivity) {
        boolean forceReset = (newActivity.info.flags & 4) != 0;
        TaskRecord task = taskTop.getTask();
        boolean taskFound = false;
        ActivityOptions topOptions = null;
        int reparentInsertionPoint = -1;
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord targetTask = this.mTaskHistory.get(i);
            if (targetTask == task) {
                topOptions = this.resetTargetTaskIfNeededLocked(task, forceReset);
                taskFound = true;
                continue;
            }
            reparentInsertionPoint = this.resetAffinityTaskIfNeededLocked(targetTask, task, taskFound, forceReset, reparentInsertionPoint);
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        if (taskNdx >= 0) {
            while ((taskTop = this.mTaskHistory.get(taskNdx--).getTopActivity()) == null && taskNdx >= 0) {
            }
        }
        if (topOptions != null) {
            if (taskTop != null) {
                taskTop.updateOptionsLocked(topOptions);
            } else {
                topOptions.abort();
            }
        }
        return taskTop;
    }

    void sendActivityResultLocked(int callingUid, ActivityRecord r, String resultWho, int requestCode, int resultCode, Intent data) {
        if (callingUid > 0) {
            this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, data, r.getUriPermissionsLocked(), r.userId);
        }
        if (this.mResumedActivity == r && r.app != null && r.app.thread != null) {
            try {
                ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
                list.add(new ResultInfo(resultWho, requestCode, resultCode, data));
                this.mService.getLifecycleManager().scheduleTransaction(r.app.thread, (IBinder)r.appToken, ActivityResultItem.obtain(list));
                return;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown sending result to " + r, e);
            }
        }
        r.addResultLocked(null, resultWho, requestCode, resultCode, data);
    }

    private boolean isATopFinishingTask(TaskRecord task) {
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord current = this.mTaskHistory.get(i);
            ActivityRecord r = current.topRunningActivityLocked();
            if (r != null) {
                return false;
            }
            if (current != task) continue;
            return true;
        }
        return false;
    }

    private void adjustFocusedActivityStack(ActivityRecord r, String reason) {
        if (!this.mStackSupervisor.isFocusedStack(this) || this.mResumedActivity != r && this.mResumedActivity != null) {
            return;
        }
        ActivityRecord next = this.topRunningActivityLocked();
        String myReason = reason + " adjustFocus";
        if (next == r) {
            this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(this.mStackSupervisor.topRunningActivityLocked(), myReason);
            return;
        }
        if (next != null && this.isFocusable()) {
            return;
        }
        TaskRecord task = r.getTask();
        if (task == null) {
            throw new IllegalStateException("activity no longer associated with task:" + r);
        }
        if (this.adjustFocusToNextFocusableStack(myReason)) {
            return;
        }
        this.mStackSupervisor.moveHomeStackTaskToTop(myReason);
    }

    boolean adjustFocusToNextFocusableStack(String reason) {
        return this.adjustFocusToNextFocusableStack(reason, false);
    }

    private boolean adjustFocusToNextFocusableStack(String reason, boolean allowFocusSelf) {
        ActivityStack stack = this.mStackSupervisor.getNextFocusableStackLocked(this, !allowFocusSelf);
        String myReason = reason + " adjustFocusToNextFocusableStack";
        if (stack == null) {
            return false;
        }
        ActivityRecord top = stack.topRunningActivityLocked();
        if (stack.isActivityTypeHome() && (top == null || !top.visible)) {
            return this.mStackSupervisor.moveHomeStackTaskToTop(reason);
        }
        stack.moveToFront(myReason);
        return true;
    }

    final void stopActivityLocked(ActivityRecord r) {
        block6: {
            if (!((r.intent.getFlags() & 0x40000000) == 0 && (r.info.flags & 0x80) == 0 || r.finishing || this.shouldSleepActivities() || !this.requestFinishActivityLocked(r.appToken, 0, null, "stop-no-history", false))) {
                r.resumeKeyDispatchingLocked();
                return;
            }
            if (r.app != null && r.app.thread != null) {
                this.adjustFocusedActivityStack(r, "stopActivity");
                r.resumeKeyDispatchingLocked();
                try {
                    r.stopped = false;
                    r.setState(ActivityState.STOPPING, "stopActivityLocked");
                    if (!r.visible) {
                        r.setVisible(false);
                    }
                    EventLogTags.writeAmStopActivity(r.userId, System.identityHashCode(r), r.shortComponentName);
                    this.mService.getLifecycleManager().scheduleTransaction(r.app.thread, (IBinder)r.appToken, StopActivityItem.obtain(r.visible, r.configChangeFlags));
                    if (this.shouldSleepOrShutDownActivities()) {
                        r.setSleeping(true);
                    }
                    Message msg = this.mHandler.obtainMessage(104, r);
                    this.mHandler.sendMessageDelayed(msg, 11000L);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception thrown during pause", e);
                    r.stopped = true;
                    r.setState(ActivityState.STOPPED, "stopActivityLocked");
                    if (!r.deferRelaunchUntilPaused) break block6;
                    this.destroyActivityLocked(r, true, "stop-except");
                }
            }
        }
    }

    final boolean requestFinishActivityLocked(IBinder token, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r == null) {
            return false;
        }
        this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj);
        return true;
    }

    final void finishSubActivityLocked(ActivityRecord self, String resultWho, int requestCode) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.resultTo != self || r.requestCode != requestCode || (r.resultWho != null || resultWho != null) && (r.resultWho == null || !r.resultWho.equals(resultWho))) continue;
                this.finishActivityLocked(r, 0, null, "request-sub", false);
            }
        }
        this.mService.updateOomAdjLocked();
    }

    final TaskRecord finishTopCrashedActivityLocked(ProcessRecord app, String reason) {
        ActivityRecord r = this.topRunningActivityLocked();
        TaskRecord finishedTask = null;
        if (r == null || r.app != app) {
            return null;
        }
        Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
        finishedTask = r.getTask();
        int taskNdx = this.mTaskHistory.indexOf(finishedTask);
        TaskRecord task = finishedTask;
        int activityNdx = task.mActivities.indexOf(r);
        this.mWindowManager.prepareAppTransition(26, false);
        this.finishActivityLocked(r, 0, null, reason, false);
        finishedTask = task;
        if (--activityNdx < 0) {
            while (--taskNdx >= 0 && (activityNdx = this.mTaskHistory.get((int)taskNdx).mActivities.size() - 1) < 0) {
            }
        }
        if (activityNdx >= 0 && (r = this.mTaskHistory.get((int)taskNdx).mActivities.get(activityNdx)).isState(ActivityState.RESUMED, ActivityState.PAUSING, ActivityState.PAUSED) && (!r.isActivityTypeHome() || this.mService.mHomeProcess != r.app)) {
            Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
            this.finishActivityLocked(r, 0, null, reason, false);
        }
        return finishedTask;
    }

    final void finishVoiceTask(IVoiceInteractionSession session) {
        IBinder sessionBinder = session.asBinder();
        boolean didOne = false;
        block2: for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r;
            int activityNdx;
            TaskRecord tr = this.mTaskHistory.get(taskNdx);
            if (tr.voiceSession != null && tr.voiceSession.asBinder() == sessionBinder) {
                for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                    r = tr.mActivities.get(activityNdx);
                    if (r.finishing) continue;
                    this.finishActivityLocked(r, 0, null, "finish-voice", false);
                    didOne = true;
                }
                continue;
            }
            for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                r = tr.mActivities.get(activityNdx);
                if (r.voiceSession == null || r.voiceSession.asBinder() != sessionBinder) continue;
                r.clearVoiceSessionLocked();
                try {
                    r.app.thread.scheduleLocalVoiceInteractionStarted(r.appToken, null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mService.finishRunningVoiceLocked();
                continue block2;
            }
        }
        if (didOne) {
            this.mService.updateOomAdjLocked();
        }
    }

    final boolean finishActivityAffinityLocked(ActivityRecord r) {
        ArrayList<ActivityRecord> activities = r.getTask().mActivities;
        for (int index = activities.indexOf(r); index >= 0; --index) {
            ActivityRecord cur = activities.get(index);
            if (!Objects.equals(cur.taskAffinity, r.taskAffinity)) break;
            this.finishActivityLocked(cur, 0, null, "request-affinity", true);
        }
        return true;
    }

    private void finishActivityResultsLocked(ActivityRecord r, int resultCode, Intent resultData) {
        ActivityRecord resultTo = r.resultTo;
        if (resultTo != null) {
            if (resultTo.userId != r.userId && resultData != null) {
                resultData.prepareToLeaveUser(r.userId);
            }
            if (r.info.applicationInfo.uid > 0) {
                this.mService.grantUriPermissionFromIntentLocked(r.info.applicationInfo.uid, resultTo.packageName, resultData, resultTo.getUriPermissionsLocked(), resultTo.userId);
            }
            resultTo.addResultLocked(r, r.resultWho, r.requestCode, resultCode, resultData);
            r.resultTo = null;
        }
        r.results = null;
        r.pendingResults = null;
        r.newIntents = null;
        r.icicle = null;
    }

    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        return this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj, boolean pauseImmediately) {
        if (r.finishing) {
            Slog.w("ActivityManager", "Duplicate finish request for " + r);
            return false;
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            int transit;
            r.makeFinishingLocked();
            TaskRecord task = r.getTask();
            EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, reason);
            ArrayList<ActivityRecord> activities = task.mActivities;
            int index = activities.indexOf(r);
            if (index < activities.size() - 1) {
                task.setFrontOfTask();
                if ((r.intent.getFlags() & 0x80000) != 0) {
                    ActivityRecord next = activities.get(index + 1);
                    next.intent.addFlags(524288);
                }
            }
            r.pauseKeyDispatchingLocked();
            this.adjustFocusedActivityStack(r, "finishActivity");
            this.finishActivityResultsLocked(r, resultCode, resultData);
            boolean endTask = index <= 0 && !task.isClearingToReuseTask();
            int n = transit = endTask ? 9 : 7;
            if (this.mResumedActivity == r) {
                if (endTask) {
                    this.mService.mTaskChangeNotificationController.notifyTaskRemovalStarted(task.taskId);
                }
                this.mWindowManager.prepareAppTransition(transit, false);
                r.setVisibility(false);
                if (this.mPausingActivity == null) {
                    this.startPausingLocked(false, false, null, pauseImmediately);
                }
                if (endTask) {
                    this.mService.getLockTaskController().clearLockedTask(task);
                }
            } else if (!r.isState(ActivityState.PAUSING)) {
                boolean removedActivity;
                if (r.visible) {
                    this.prepareActivityHideTransitionAnimation(r, transit);
                }
                int finishMode = r.visible || r.nowVisible ? 2 : 1;
                boolean bl = removedActivity = this.finishCurrentActivityLocked(r, finishMode, oomAdj, "finishActivityLocked") == null;
                if (task.onlyHasTaskOverlayActivities(true)) {
                    for (ActivityRecord taskOverlay : task.mActivities) {
                        if (!taskOverlay.mTaskOverlay) continue;
                        this.prepareActivityHideTransitionAnimation(taskOverlay, transit);
                    }
                }
                boolean bl2 = removedActivity;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    private void prepareActivityHideTransitionAnimation(ActivityRecord r, int transit) {
        this.mWindowManager.prepareAppTransition(transit, false);
        r.setVisibility(false);
        this.mWindowManager.executeAppTransition();
        if (!this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(r)) {
            this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.add(r);
        }
    }

    final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int mode, boolean oomAdj, String reason) {
        boolean finishingActivityInNonFocusedStack;
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked(true);
        if (mode == 2 && (r.visible || r.nowVisible) && next != null && !next.nowVisible) {
            if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
                this.addToStopping(r, false, false);
            }
            r.setState(ActivityState.STOPPING, "finishCurrentActivityLocked");
            if (oomAdj) {
                this.mService.updateOomAdjLocked();
            }
            return r;
        }
        this.mStackSupervisor.mStoppingActivities.remove(r);
        this.mStackSupervisor.mGoingToSleepActivities.remove(r);
        this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(r);
        ActivityState prevState = r.getState();
        r.setState(ActivityState.FINISHING, "finishCurrentActivityLocked");
        boolean bl = finishingActivityInNonFocusedStack = r.getStack() != this.mStackSupervisor.getFocusedStack() && prevState == ActivityState.PAUSED && mode == 2;
        if (mode == 0 || prevState == ActivityState.PAUSED && (mode == 1 || this.inPinnedWindowingMode()) || finishingActivityInNonFocusedStack || prevState == ActivityState.STOPPING || prevState == ActivityState.STOPPED || prevState == ActivityState.INITIALIZING) {
            r.makeFinishingLocked();
            boolean activityRemoved = this.destroyActivityLocked(r, true, "finish-imm:" + reason);
            if (finishingActivityInNonFocusedStack) {
                this.mStackSupervisor.ensureVisibilityAndConfig(next, this.mDisplayId, false, true);
            }
            if (activityRemoved) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return activityRemoved ? null : r;
        }
        this.mStackSupervisor.mFinishingActivities.add(r);
        r.resumeKeyDispatchingLocked();
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return r;
    }

    void finishAllActivitiesLocked(boolean immediately) {
        boolean noActivitiesInStack = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                noActivitiesInStack = false;
                if (r.finishing && !immediately) continue;
                Slog.d("ActivityManager", "finishAllActivitiesLocked: finishing " + r + " immediately");
                this.finishCurrentActivityLocked(r, 0, false, "finishAllActivitiesLocked");
            }
        }
        if (noActivitiesInStack) {
            this.remove();
        }
    }

    boolean inFrontOfStandardStack() {
        ActivityDisplay display = this.getDisplay();
        if (display == null) {
            return false;
        }
        int index = display.getIndexOf(this);
        if (index == 0) {
            return false;
        }
        ActivityStack stackBehind = display.getChildAt(index - 1);
        return stackBehind.isActivityTypeStandard();
    }

    boolean shouldUpRecreateTaskLocked(ActivityRecord srec, String destAffinity) {
        if (srec == null || srec.getTask().affinity == null || !srec.getTask().affinity.equals(destAffinity)) {
            return true;
        }
        TaskRecord task = srec.getTask();
        if (srec.frontOfTask && task.getBaseIntent() != null && task.getBaseIntent().isDocument()) {
            if (!this.inFrontOfStandardStack()) {
                return true;
            }
            int taskIdx = this.mTaskHistory.indexOf(task);
            if (taskIdx <= 0) {
                Slog.w("ActivityManager", "shouldUpRecreateTask: task not in history for " + srec);
                return false;
            }
            TaskRecord prevTask = this.mTaskHistory.get(taskIdx);
            if (!task.affinity.equals(prevTask.affinity)) {
                return true;
            }
        }
        return false;
    }

    final boolean navigateUpToLocked(ActivityRecord srec, Intent destIntent, int resultCode, Intent resultData) {
        ActivityRecord next;
        IActivityController controller;
        TaskRecord task = srec.getTask();
        ArrayList<ActivityRecord> activities = task.mActivities;
        int start = activities.indexOf(srec);
        if (!this.mTaskHistory.contains(task) || start < 0) {
            return false;
        }
        int finishTo = start - 1;
        ActivityRecord parent = finishTo < 0 ? null : activities.get(finishTo);
        boolean foundParentInTask = false;
        ComponentName dest = destIntent.getComponent();
        if (start > 0 && dest != null) {
            for (int i = finishTo; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (!r.info.packageName.equals(dest.getPackageName()) || !r.info.name.equals(dest.getClassName())) continue;
                finishTo = i;
                parent = r;
                foundParentInTask = true;
                break;
            }
        }
        if ((controller = this.mService.mController) != null && (next = this.topRunningActivityLocked(srec.appToken, 0)) != null) {
            boolean resumeOK = true;
            try {
                resumeOK = controller.activityResuming(next.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
                Watchdog.getInstance().setActivityController(null);
            }
            if (!resumeOK) {
                return false;
            }
        }
        long origId = Binder.clearCallingIdentity();
        for (int i = start; i > finishTo; --i) {
            ActivityRecord r = activities.get(i);
            this.requestFinishActivityLocked(r.appToken, resultCode, resultData, "navigate-up", true);
            resultCode = 0;
            resultData = null;
        }
        if (parent != null && foundParentInTask) {
            int parentLaunchMode = parent.info.launchMode;
            int destIntentFlags = destIntent.getFlags();
            if (parentLaunchMode == 3 || parentLaunchMode == 2 || parentLaunchMode == 1 || (destIntentFlags & 0x4000000) != 0) {
                parent.deliverNewIntentLocked(srec.info.applicationInfo.uid, destIntent, srec.packageName);
            } else {
                try {
                    ActivityInfo aInfo = AppGlobals.getPackageManager().getActivityInfo(destIntent.getComponent(), 1024, srec.userId);
                    int res = this.mService.getActivityStartController().obtainStarter(destIntent, "navigateUpTo").setCaller(srec.app.thread).setActivityInfo(aInfo).setResultTo(parent.appToken).setCallingPid(-1).setCallingUid(parent.launchedFromUid).setCallingPackage(parent.launchedFromPackage).setRealCallingPid(-1).setRealCallingUid(parent.launchedFromUid).setComponentSpecified(true).execute();
                    foundParentInTask = res == 0;
                }
                catch (RemoteException e) {
                    foundParentInTask = false;
                }
                this.requestFinishActivityLocked(parent.appToken, resultCode, resultData, "navigate-top", true);
            }
        }
        Binder.restoreCallingIdentity(origId);
        return foundParentInTask;
    }

    void onActivityRemovedFromStack(ActivityRecord r) {
        this.removeTimeoutsForActivityLocked(r);
        if (this.mResumedActivity != null && this.mResumedActivity == r) {
            this.setResumedActivity(null, "onActivityRemovedFromStack");
        }
        if (this.mPausingActivity != null && this.mPausingActivity == r) {
            this.mPausingActivity = null;
        }
    }

    void onActivityAddedToStack(ActivityRecord r) {
        if (r.getState() == ActivityState.RESUMED) {
            this.setResumedActivity(r, "onActivityAddedToStack");
        }
    }

    private void cleanUpActivityLocked(ActivityRecord r, boolean cleanServices, boolean setState) {
        this.onActivityRemovedFromStack(r);
        r.deferRelaunchUntilPaused = false;
        r.frozenBeforeDestroy = false;
        if (setState) {
            r.setState(ActivityState.DESTROYED, "cleanupActivityLocked");
            r.app = null;
        }
        this.mStackSupervisor.cleanupActivity(r);
        if (r.finishing && r.pendingResults != null) {
            for (WeakReference<PendingIntentRecord> apr : r.pendingResults) {
                PendingIntentRecord rec = (PendingIntentRecord)apr.get();
                if (rec == null) continue;
                this.mService.cancelIntentSenderLocked(rec, false);
            }
            r.pendingResults = null;
        }
        if (cleanServices) {
            this.cleanUpActivityServicesLocked(r);
        }
        this.removeTimeoutsForActivityLocked(r);
        this.mWindowManager.notifyAppRelaunchesCleared(r.appToken);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
        this.mHandler.removeMessages(101, r);
        this.mHandler.removeMessages(104, r);
        this.mHandler.removeMessages(102, r);
        r.finishLaunchTickingLocked();
    }

    private void removeActivityFromHistoryLocked(ActivityRecord r, String reason) {
        boolean onlyHasTaskOverlays;
        this.finishActivityResultsLocked(r, 0, null);
        r.makeFinishingLocked();
        r.takeFromHistory();
        this.removeTimeoutsForActivityLocked(r);
        r.setState(ActivityState.DESTROYED, "removeActivityFromHistoryLocked");
        r.app = null;
        r.removeWindowContainer();
        TaskRecord task = r.getTask();
        boolean lastActivity = task != null ? task.removeActivity(r) : false;
        boolean bl = onlyHasTaskOverlays = task != null ? task.onlyHasTaskOverlayActivities(false) : false;
        if (lastActivity || onlyHasTaskOverlays) {
            if (onlyHasTaskOverlays) {
                this.mStackSupervisor.removeTaskByIdLocked(task.taskId, false, false, true, reason);
            }
            if (lastActivity) {
                this.removeTask(task, reason, 0);
            }
        }
        this.cleanUpActivityServicesLocked(r);
        r.removeUriPermissionsLocked();
    }

    private void cleanUpActivityServicesLocked(ActivityRecord r) {
        if (r.connections != null) {
            for (ConnectionRecord c : r.connections) {
                this.mService.mServices.removeConnectionLocked(c, null, r);
            }
            r.connections = null;
        }
    }

    final void scheduleDestroyActivities(ProcessRecord owner, String reason) {
        Message msg = this.mHandler.obtainMessage(105);
        msg.obj = new ScheduleDestroyArgs(owner, reason);
        this.mHandler.sendMessage(msg);
    }

    private void destroyActivitiesLocked(ProcessRecord owner, String reason) {
        boolean lastIsOpaque = false;
        boolean activityRemoved = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                if (r.fullscreen) {
                    lastIsOpaque = true;
                }
                if (owner != null && r.app != owner || !lastIsOpaque || !r.isDestroyable() || !this.destroyActivityLocked(r, true, reason)) continue;
                activityRemoved = true;
            }
        }
        if (activityRemoved) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    final boolean safelyDestroyActivityLocked(ActivityRecord r, String reason) {
        if (r.isDestroyable()) {
            return this.destroyActivityLocked(r, true, reason);
        }
        return false;
    }

    final int releaseSomeActivitiesLocked(ProcessRecord app, ArraySet<TaskRecord> tasks, String reason) {
        int maxTasks = tasks.size() / 4;
        if (maxTasks < 1) {
            maxTasks = 1;
        }
        int numReleased = 0;
        for (int taskNdx = 0; taskNdx < this.mTaskHistory.size() && maxTasks > 0; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!tasks.contains(task)) continue;
            int curNum = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int actNdx = 0; actNdx < activities.size(); ++actNdx) {
                ActivityRecord activity = activities.get(actNdx);
                if (activity.app != app || !activity.isDestroyable()) continue;
                this.destroyActivityLocked(activity, true, reason);
                if (activities.get(actNdx) != activity) {
                    --actNdx;
                }
                ++curNum;
            }
            if (curNum <= 0) continue;
            numReleased += curNum;
            --maxTasks;
            if (this.mTaskHistory.get(taskNdx) == task) continue;
            --taskNdx;
        }
        return numReleased;
    }

    final boolean destroyActivityLocked(ActivityRecord r, boolean removeFromApp, String reason) {
        boolean hadApp;
        if (r.isState(ActivityState.DESTROYING, ActivityState.DESTROYED)) {
            return false;
        }
        EventLog.writeEvent(30018, r.userId, System.identityHashCode(r), r.getTask().taskId, r.shortComponentName, reason);
        boolean removedFromHistory = false;
        this.cleanUpActivityLocked(r, false, false);
        boolean bl = hadApp = r.app != null;
        if (hadApp) {
            boolean skipDestroy;
            block13: {
                if (removeFromApp) {
                    r.app.activities.remove(r);
                    if (this.mService.mHeavyWeightProcess == r.app && r.app.activities.size() <= 0) {
                        this.mService.mHeavyWeightProcess = null;
                        this.mService.mHandler.sendEmptyMessage(25);
                    }
                    if (r.app.activities.isEmpty()) {
                        this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
                        this.mService.updateLruProcessLocked(r.app, false, null);
                        this.mService.updateOomAdjLocked();
                    }
                }
                skipDestroy = false;
                try {
                    this.mService.getLifecycleManager().scheduleTransaction(r.app.thread, (IBinder)r.appToken, DestroyActivityItem.obtain(r.finishing, r.configChangeFlags));
                }
                catch (Exception e) {
                    if (!r.finishing) break block13;
                    this.removeActivityFromHistoryLocked(r, reason + " exceptionInScheduleDestroy");
                    removedFromHistory = true;
                    skipDestroy = true;
                }
            }
            r.nowVisible = false;
            if (r.finishing && !skipDestroy) {
                r.setState(ActivityState.DESTROYING, "destroyActivityLocked. finishing and not skipping destroy");
                Message msg = this.mHandler.obtainMessage(102, r);
                this.mHandler.sendMessageDelayed(msg, 10000L);
            } else {
                r.setState(ActivityState.DESTROYED, "destroyActivityLocked. not finishing or skipping destroy");
                r.app = null;
            }
        } else if (r.finishing) {
            this.removeActivityFromHistoryLocked(r, reason + " hadNoApp");
            removedFromHistory = true;
        } else {
            r.setState(ActivityState.DESTROYED, "destroyActivityLocked. not finishing and had no app");
            r.app = null;
        }
        r.configChangeFlags = 0;
        if (!this.mLRUActivities.remove(r) && hadApp) {
            Slog.w("ActivityManager", "Activity " + r + " being finished, but not in LRU list");
        }
        return removedFromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityDestroyedLocked(IBinder token, String reason) {
        long origId = Binder.clearCallingIdentity();
        try {
            this.activityDestroyedLocked(ActivityRecord.forTokenLocked(token), reason);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    final void activityDestroyedLocked(ActivityRecord record, String reason) {
        if (record != null) {
            this.mHandler.removeMessages(102, record);
        }
        if (this.isInStackLocked(record) != null && record.isState(ActivityState.DESTROYING, ActivityState.DESTROYED)) {
            this.cleanUpActivityLocked(record, true, false);
            this.removeActivityFromHistoryLocked(record, reason);
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
    }

    private void removeHistoryRecordsForAppLocked(ArrayList<ActivityRecord> list, ProcessRecord app, String listName) {
        int i = list.size();
        while (i > 0) {
            ActivityRecord r = list.get(--i);
            if (r.app != app) continue;
            list.remove(i);
            this.removeTimeoutsForActivityLocked(r);
        }
    }

    private boolean removeHistoryRecordsForAppLocked(ProcessRecord app) {
        this.removeHistoryRecordsForAppLocked(this.mLRUActivities, app, "mLRUActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mStoppingActivities, app, "mStoppingActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mGoingToSleepActivities, app, "mGoingToSleepActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mActivitiesWaitingForVisibleActivity, app, "mActivitiesWaitingForVisibleActivity");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mFinishingActivities, app, "mFinishingActivities");
        boolean hasVisibleActivities = false;
        int i = this.numActivities();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            this.mTmpActivities.clear();
            this.mTmpActivities.addAll(activities);
            while (!this.mTmpActivities.isEmpty()) {
                boolean remove;
                int targetIndex = this.mTmpActivities.size() - 1;
                ActivityRecord r = this.mTmpActivities.remove(targetIndex);
                if (r.app != app) continue;
                if (r.visible) {
                    hasVisibleActivities = true;
                }
                if (remove = !r.haveState && !r.stateNotNeeded || r.finishing ? true : !r.visible && r.launchCount > 2 && r.lastLaunchTime > SystemClock.uptimeMillis() - 60000L) {
                    if (!r.finishing) {
                        Slog.w("ActivityManager", "Force removing " + r + ": app died, no saved state");
                        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), r.getTask().taskId, r.shortComponentName, "proc died without state saved");
                        if (r.getState() == ActivityState.RESUMED) {
                            this.mService.updateUsageStats(r, false);
                        }
                    }
                } else {
                    r.app = null;
                    r.nowVisible = r.visible;
                    if (!r.haveState) {
                        r.icicle = null;
                    }
                }
                this.cleanUpActivityLocked(r, true, true);
                if (!remove) continue;
                this.removeActivityFromHistoryLocked(r, "appDied");
            }
        }
        return hasVisibleActivities;
    }

    private void updateTransitLocked(int transit, ActivityOptions options) {
        if (options != null) {
            ActivityRecord r = this.topRunningActivityLocked();
            if (r != null && !r.isState(ActivityState.RESUMED)) {
                r.updateOptionsLocked(options);
            } else {
                ActivityOptions.abort(options);
            }
        }
        this.mWindowManager.prepareAppTransition(transit, false);
    }

    private void updateTaskMovement(TaskRecord task, boolean toFront) {
        if (task.isPersistable) {
            task.mLastTimeMoved = System.currentTimeMillis();
            if (!toFront) {
                task.mLastTimeMoved *= -1L;
            }
        }
        this.mStackSupervisor.invalidateTaskLayers();
    }

    void moveHomeStackTaskToTop() {
        if (!this.isActivityTypeHome()) {
            throw new IllegalStateException("Calling moveHomeStackTaskToTop() on non-home stack: " + this);
        }
        int top = this.mTaskHistory.size() - 1;
        if (top >= 0) {
            TaskRecord task = this.mTaskHistory.get(top);
            this.mTaskHistory.remove(top);
            this.mTaskHistory.add(top, task);
            this.updateTaskMovement(task, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void moveTaskToFrontLocked(TaskRecord tr, boolean noAnimation, ActivityOptions options, AppTimeTracker timeTracker, String reason) {
        ActivityStack topStack = this.getDisplay().getTopStack();
        ActivityRecord topActivity = topStack != null ? topStack.getTopActivity() : null;
        int numTasks = this.mTaskHistory.size();
        int index = this.mTaskHistory.indexOf(tr);
        if (numTasks == 0 || index < 0) {
            if (noAnimation) {
                ActivityOptions.abort(options);
            } else {
                this.updateTransitLocked(10, options);
            }
            return;
        }
        if (timeTracker != null) {
            for (int i = tr.mActivities.size() - 1; i >= 0; --i) {
                tr.mActivities.get((int)i).appTimeTracker = timeTracker;
            }
        }
        try {
            this.getDisplay().deferUpdateImeTarget();
            this.insertTaskAtTop(tr, null);
            ActivityRecord top = tr.getTopActivity();
            if (top == null || !top.okToShowLocked()) {
                if (top != null) {
                    this.mStackSupervisor.mRecentTasks.add(top.getTask());
                }
                ActivityOptions.abort(options);
                return;
            }
            ActivityRecord r = this.topRunningActivityLocked();
            this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(r, reason);
            if (noAnimation) {
                this.mWindowManager.prepareAppTransition(0, false);
                if (r != null) {
                    this.mStackSupervisor.mNoAnimActivities.add(r);
                }
                ActivityOptions.abort(options);
            } else {
                this.updateTransitLocked(10, options);
            }
            if (this.canEnterPipOnTaskSwitch(topActivity, tr, null, options)) {
                topActivity.supportsEnterPipOnTaskSwitch = true;
            }
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            EventLog.writeEvent(30002, tr.userId, tr.taskId);
            this.mService.mTaskChangeNotificationController.notifyTaskMovedToFront(tr.taskId);
        }
        finally {
            this.getDisplay().continueUpdateImeTarget();
        }
    }

    final boolean moveTaskToBackLocked(int taskId) {
        TaskRecord tr = this.taskForIdLocked(taskId);
        if (tr == null) {
            Slog.i("ActivityManager", "moveTaskToBack: bad taskId=" + taskId);
            return false;
        }
        Slog.i("ActivityManager", "moveTaskToBack: " + tr);
        if (!this.mService.getLockTaskController().canMoveTaskToBack(tr)) {
            return false;
        }
        if (this.isTopStackOnDisplay() && this.mService.mController != null) {
            ActivityRecord next = this.topRunningActivityLocked(null, taskId);
            if (next == null) {
                next = this.topRunningActivityLocked(null, 0);
            }
            if (next != null) {
                boolean moveOK = true;
                try {
                    moveOK = this.mService.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!moveOK) {
                    return false;
                }
            }
        }
        this.mTaskHistory.remove(tr);
        this.mTaskHistory.add(0, tr);
        this.updateTaskMovement(tr, false);
        this.mWindowManager.prepareAppTransition(11, false);
        this.moveToBack("moveTaskToBackLocked", tr);
        if (this.inPinnedWindowingMode()) {
            this.mStackSupervisor.removeStack(this);
            return true;
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return true;
    }

    static void logStartActivity(int tag, ActivityRecord r, TaskRecord task) {
        Uri data = r.intent.getData();
        String strData = data != null ? data.toSafeString() : null;
        EventLog.writeEvent(tag, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, r.intent.getAction(), r.intent.getType(), strData, r.intent.getFlags());
    }

    void ensureVisibleActivitiesConfigurationLocked(ActivityRecord start, boolean preserveWindow) {
        if (start == null || !start.visible) {
            return;
        }
        TaskRecord startTask = start.getTask();
        boolean behindFullscreen = false;
        boolean updatedConfig = false;
        for (int taskIndex = this.mTaskHistory.indexOf(startTask); taskIndex >= 0; --taskIndex) {
            int activityIndex;
            TaskRecord task = this.mTaskHistory.get(taskIndex);
            ArrayList<ActivityRecord> activities = task.mActivities;
            int n = activityIndex = start.getTask() == task ? activities.indexOf(start) : activities.size() - 1;
            while (activityIndex >= 0) {
                ActivityRecord r = activities.get(activityIndex);
                updatedConfig |= r.ensureActivityConfiguration(0, preserveWindow);
                if (r.fullscreen) {
                    behindFullscreen = true;
                    break;
                }
                --activityIndex;
            }
            if (behindFullscreen) break;
        }
        if (updatedConfig) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    @Override
    public void requestResize(Rect bounds) {
        this.mService.resizeStack(this.mStackId, bounds, true, false, false, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resize(Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds) {
        if (!this.updateBoundsAllowed(bounds, tempTaskBounds, tempTaskInsetBounds)) {
            return;
        }
        Rect taskBounds = tempTaskBounds != null ? tempTaskBounds : bounds;
        Rect insetBounds = tempTaskInsetBounds != null ? tempTaskInsetBounds : taskBounds;
        this.mTmpBounds.clear();
        this.mTmpInsetBounds.clear();
        Object object = this.mWindowManager.getWindowManagerLock();
        synchronized (object) {
            for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
                TaskRecord task = this.mTaskHistory.get(i);
                if (task.isResizeable()) {
                    if (this.inFreeformWindowingMode()) {
                        this.mTmpRect2.set(task.getOverrideBounds());
                        ActivityStack.fitWithinBounds(this.mTmpRect2, bounds);
                        task.updateOverrideConfiguration(this.mTmpRect2);
                    } else {
                        task.updateOverrideConfiguration(taskBounds, insetBounds);
                    }
                }
                this.mTmpBounds.put(task.taskId, task.getOverrideBounds());
                if (tempTaskInsetBounds == null) continue;
                this.mTmpInsetBounds.put(task.taskId, tempTaskInsetBounds);
            }
            ((StackWindowController)this.mWindowContainerController).resize(bounds, this.mTmpBounds, this.mTmpInsetBounds);
            this.setBounds(bounds);
        }
    }

    void onPipAnimationEndResize() {
        ((StackWindowController)this.mWindowContainerController).onPipAnimationEndResize();
    }

    private static void fitWithinBounds(Rect bounds, Rect stackBounds) {
        if (stackBounds == null || stackBounds.isEmpty() || stackBounds.contains(bounds)) {
            return;
        }
        if (bounds.left < stackBounds.left || bounds.right > stackBounds.right) {
            int maxRight = stackBounds.right - stackBounds.width() / 3;
            int horizontalDiff = stackBounds.left - bounds.left;
            if (horizontalDiff < 0 && bounds.left >= maxRight || bounds.left + horizontalDiff >= maxRight) {
                horizontalDiff = maxRight - bounds.left;
            }
            bounds.left += horizontalDiff;
            bounds.right += horizontalDiff;
        }
        if (bounds.top < stackBounds.top || bounds.bottom > stackBounds.bottom) {
            int maxBottom = stackBounds.bottom - stackBounds.height() / 3;
            int verticalDiff = stackBounds.top - bounds.top;
            if (verticalDiff < 0 && bounds.top >= maxBottom || bounds.top + verticalDiff >= maxBottom) {
                verticalDiff = maxBottom - bounds.top;
            }
            bounds.top += verticalDiff;
            bounds.bottom += verticalDiff;
        }
    }

    boolean willActivityBeVisibleLocked(IBinder token) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appToken == token) {
                    return true;
                }
                if (!r.fullscreen || r.finishing) continue;
                return false;
            }
        }
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return false;
        }
        if (r.finishing) {
            Slog.e("ActivityManager", "willActivityBeVisibleLocked: Returning false, would have returned true for r=" + r);
        }
        return !r.finishing;
    }

    void closeSystemDialogsLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if ((r.info.flags & 0x100) == 0) continue;
                this.finishActivityLocked(r, 0, null, "close-sys", true);
            }
        }
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        TaskRecord lastTask = null;
        ComponentName homeActivity = null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            this.mTmpActivities.clear();
            this.mTmpActivities.addAll(activities);
            while (!this.mTmpActivities.isEmpty()) {
                boolean sameComponent;
                ActivityRecord r = this.mTmpActivities.remove(0);
                boolean bl = sameComponent = r.packageName.equals(packageName) && (filterByClasses == null || filterByClasses.contains(r.realActivity.getClassName())) || packageName == null && r.userId == userId;
                if (userId != -1 && r.userId != userId || !sameComponent && r.getTask() != lastTask || r.app != null && !evenPersistent && r.app.persistent) continue;
                if (!doit) {
                    if (r.finishing) continue;
                    return true;
                }
                if (r.isActivityTypeHome()) {
                    if (homeActivity != null && homeActivity.equals(r.realActivity)) {
                        Slog.i("ActivityManager", "Skip force-stop again " + r);
                        continue;
                    }
                    homeActivity = r.realActivity;
                }
                didSomething = true;
                Slog.i("ActivityManager", "  Force finishing activity " + r);
                if (sameComponent) {
                    if (r.app != null) {
                        r.app.removed = true;
                    }
                    r.app = null;
                }
                lastTask = r.getTask();
                this.finishActivityLocked(r, 0, null, "force-stop", true);
            }
        }
        return didSomething;
    }

    void getRunningTasks(List<TaskRecord> tasksOut, @WindowConfiguration.ActivityType int ignoreActivityType, @WindowConfiguration.WindowingMode int ignoreWindowingMode, int callingUid, boolean allowed) {
        boolean focusedStack = this.mStackSupervisor.getFocusedStack() == this;
        boolean topTask = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.getTopActivity() == null || !allowed && !task.isActivityTypeHome() && task.effectiveUid != callingUid || ignoreActivityType != 0 && task.getActivityType() == ignoreActivityType || ignoreWindowingMode != 0 && task.getWindowingMode() == ignoreWindowingMode) continue;
            if (focusedStack && topTask) {
                task.lastActiveTime = SystemClock.elapsedRealtime();
                topTask = false;
            }
            tasksOut.add(task);
        }
    }

    void unhandledBackLocked() {
        ArrayList<ActivityRecord> activities;
        int activityTop;
        int top = this.mTaskHistory.size() - 1;
        if (top >= 0 && (activityTop = (activities = this.mTaskHistory.get((int)top).mActivities).size() - 1) >= 0) {
            this.finishActivityLocked(activities.get(activityTop), 0, null, "unhandled-back", true);
        }
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        if (this.mPausingActivity != null && this.mPausingActivity.app == app) {
            this.mPausingActivity = null;
        }
        if (this.mLastPausedActivity != null && this.mLastPausedActivity.app == app) {
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        return this.removeHistoryRecordsForAppLocked(app);
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.app != app) continue;
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                r.app = null;
                this.mWindowManager.prepareAppTransition(26, false);
                this.finishCurrentActivityLocked(r, 0, false, "handleAppCrashedLocked");
            }
        }
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage, boolean needSep) {
        if (this.mTaskHistory.isEmpty()) {
            return false;
        }
        String prefix = "    ";
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (needSep) {
                pw.println("");
            }
            pw.println("    Task id #" + task.taskId);
            pw.println("    mBounds=" + task.getOverrideBounds());
            pw.println("    mMinWidth=" + task.mMinWidth);
            pw.println("    mMinHeight=" + task.mMinHeight);
            pw.println("    mLastNonFullscreenBounds=" + task.mLastNonFullscreenBounds);
            pw.println("    * " + task);
            task.dump(pw, "      ");
            ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mTaskHistory.get((int)taskNdx).mActivities, "    ", "Hist", true, !dumpAll, dumpClient, dumpPackage, false, null, task);
        }
        return true;
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        ArrayList<ActivityRecord> activities;
        block4: {
            block5: {
                ArrayList<ActivityRecord> list;
                int listTop;
                block3: {
                    activities = new ArrayList<ActivityRecord>();
                    if (!"all".equals(name)) break block3;
                    for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                        activities.addAll(this.mTaskHistory.get((int)taskNdx).mActivities);
                    }
                    break block4;
                }
                if (!"top".equals(name)) break block5;
                int top = this.mTaskHistory.size() - 1;
                if (top < 0 || (listTop = (list = this.mTaskHistory.get((int)top).mActivities).size() - 1) < 0) break block4;
                activities.add(list.get(listTop));
                break block4;
            }
            ActivityManagerService.ItemMatcher matcher = new ActivityManagerService.ItemMatcher();
            matcher.build(name);
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                for (ActivityRecord r1 : this.mTaskHistory.get((int)taskNdx).mActivities) {
                    if (!matcher.match(r1, r1.intent.getComponent())) continue;
                    activities.add(r1);
                }
            }
        }
        return activities;
    }

    ActivityRecord restartPackage(String packageName) {
        ActivityRecord starting = this.topRunningActivityLocked();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord a = activities.get(activityNdx);
                if (!a.info.packageName.equals(packageName)) continue;
                a.forceNewConfig = true;
                if (starting == null || a != starting || !a.visible) continue;
                a.startFreezingScreenLocked(starting.app, 256);
            }
        }
        return starting;
    }

    void removeTask(TaskRecord task, String reason, int mode) {
        for (ActivityRecord record : task.mActivities) {
            this.onActivityRemovedFromStack(record);
        }
        boolean removed = this.mTaskHistory.remove(task);
        if (removed) {
            EventLog.writeEvent(30061, task.taskId, this.getStackId());
        }
        this.removeActivitiesFromLRUListLocked(task);
        this.updateTaskMovement(task, true);
        if (mode == 0 && task.mActivities.isEmpty()) {
            boolean isVoiceSession;
            boolean bl = isVoiceSession = task.voiceSession != null;
            if (isVoiceSession) {
                try {
                    task.voiceSession.taskFinished(task.intent, task.taskId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (task.autoRemoveFromRecents() || isVoiceSession) {
                this.mStackSupervisor.mRecentTasks.remove(task);
            }
            task.removeWindowContainer();
        }
        if (this.mTaskHistory.isEmpty()) {
            if (this.isOnHomeDisplay() && mode != 2 && this.mStackSupervisor.isFocusedStack(this)) {
                String myReason = reason + " leftTaskHistoryEmpty";
                if (!this.inMultiWindowMode() || !this.adjustFocusToNextFocusableStack(myReason)) {
                    this.mStackSupervisor.moveHomeStackToFront(myReason);
                }
            }
            if (this.isAttached()) {
                this.getDisplay().positionChildAtBottom(this);
            }
            if (!this.isActivityTypeHome()) {
                this.remove();
            }
        }
        task.setStack(null);
        if (this.inPinnedWindowingMode()) {
            this.mService.mTaskChangeNotificationController.notifyActivityUnpinned();
        }
    }

    TaskRecord createTaskRecord(int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean toTop) {
        return this.createTaskRecord(taskId, info, intent, voiceSession, voiceInteractor, toTop, null, null, null);
    }

    TaskRecord createTaskRecord(int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean toTop, ActivityRecord activity, ActivityRecord source, ActivityOptions options) {
        TaskRecord task = TaskRecord.create(this.mService, taskId, info, intent, voiceSession, voiceInteractor);
        this.addTask(task, toTop, "createTaskRecord");
        int displayId = this.mDisplayId != -1 ? this.mDisplayId : 0;
        boolean isLockscreenShown = this.mService.mStackSupervisor.getKeyguardController().isKeyguardOrAodShowing(displayId);
        if (!this.mStackSupervisor.getLaunchParamsController().layoutTask(task, info.windowLayout, activity, source, options) && !this.matchParentBounds() && task.isResizeable() && !isLockscreenShown) {
            task.updateOverrideConfiguration(this.getOverrideBounds());
        }
        task.createWindowContainer(toTop, (info.flags & 0x400) != 0);
        return task;
    }

    ArrayList<TaskRecord> getAllTasks() {
        return new ArrayList<TaskRecord>(this.mTaskHistory);
    }

    void addTask(TaskRecord task, boolean toTop, String reason) {
        this.addTask(task, toTop ? Integer.MAX_VALUE : 0, true, reason);
        if (toTop) {
            ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
        }
    }

    void addTask(TaskRecord task, int position, boolean schedulePictureInPictureModeChange, String reason) {
        this.mTaskHistory.remove(task);
        position = this.getAdjustedPositionForTask(task, position, null);
        boolean toTop = position >= this.mTaskHistory.size();
        ActivityStack prevStack = this.preAddTask(task, reason, toTop);
        this.mTaskHistory.add(position, task);
        task.setStack(this);
        this.updateTaskMovement(task, toTop);
        this.postAddTask(task, prevStack, schedulePictureInPictureModeChange);
    }

    void positionChildAt(TaskRecord task, int index) {
        if (task.getStack() != this) {
            throw new IllegalArgumentException("AS.positionChildAt: task=" + task + " is not a child of stack=" + this + " current parent=" + task.getStack());
        }
        task.updateOverrideConfigurationForStack(this);
        ActivityRecord topRunningActivity = task.topRunningActivityLocked();
        boolean wasResumed = topRunningActivity == ((ActivityStack)task.getStack()).mResumedActivity;
        this.insertTaskAtPosition(task, index);
        task.setStack(this);
        this.postAddTask(task, null, true);
        if (wasResumed) {
            if (this.mResumedActivity != null) {
                Log.wtf("ActivityManager", "mResumedActivity was already set when moving mResumedActivity from other stack to this stack mResumedActivity=" + this.mResumedActivity + " other mResumedActivity=" + topRunningActivity);
            }
            topRunningActivity.setState(ActivityState.RESUMED, "positionChildAt");
        }
        this.ensureActivitiesVisibleLocked(null, 0, false);
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
    }

    private ActivityStack preAddTask(TaskRecord task, String reason, boolean toTop) {
        Object prevStack = task.getStack();
        if (prevStack != null && prevStack != this) {
            ((ActivityStack)prevStack).removeTask(task, reason, toTop ? 2 : 1);
        }
        return prevStack;
    }

    private void postAddTask(TaskRecord task, ActivityStack prevStack, boolean schedulePictureInPictureModeChange) {
        if (schedulePictureInPictureModeChange && prevStack != null) {
            this.mStackSupervisor.scheduleUpdatePictureInPictureModeIfNeeded(task, prevStack);
        } else if (task.voiceSession != null) {
            try {
                task.voiceSession.taskStarted(task.intent, task.taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void moveToFrontAndResumeStateIfNeeded(ActivityRecord r, boolean moveToFront, boolean setResume, boolean setPause, String reason) {
        if (!moveToFront) {
            return;
        }
        if (setResume) {
            r.setState(ActivityState.RESUMED, "moveToFrontAndResumeStateIfNeeded");
            this.updateLRUListLocked(r);
        }
        if (setPause) {
            this.mPausingActivity = r;
            this.schedulePauseTimeout(r);
        }
        this.moveToFront(reason);
    }

    public int getStackId() {
        return this.mStackId;
    }

    public String toString() {
        return "ActivityStack{" + Integer.toHexString(System.identityHashCode(this)) + " stackId=" + this.mStackId + " type=" + WindowConfiguration.activityTypeToString(this.getActivityType()) + " mode=" + WindowConfiguration.windowingModeToString(this.getWindowingMode()) + " visible=" + this.shouldBeVisible(null) + " translucent=" + this.isStackTranslucent(null) + ", " + this.mTaskHistory.size() + " tasks}";
    }

    void onLockTaskPackagesUpdated() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).setLockTaskAuth();
        }
    }

    void executeAppTransition(ActivityOptions options) {
        this.mWindowManager.executeAppTransition();
        ActivityOptions.abort(options);
    }

    boolean shouldSleepActivities() {
        ActivityDisplay display = this.getDisplay();
        if (this.mStackSupervisor.getFocusedStack() == this && this.mStackSupervisor.getKeyguardController().isKeyguardGoingAway()) {
            return false;
        }
        return display != null ? display.isSleeping() : this.mService.isSleepingLocked();
    }

    boolean shouldSleepOrShutDownActivities() {
        return this.shouldSleepActivities() || this.mService.isShuttingDownLocked();
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, false);
        proto.write(1120986464258L, this.mStackId);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            task.writeToProto(proto, 2246267895811L);
        }
        if (this.mResumedActivity != null) {
            this.mResumedActivity.writeIdentifierToProto(proto, 1146756268036L);
        }
        proto.write(0x10500000005L, this.mDisplayId);
        if (!this.matchParentBounds()) {
            Rect bounds = this.getOverrideBounds();
            bounds.writeToProto(proto, 1146756268039L);
        }
        proto.write(1133871366150L, this.matchParentBounds());
        proto.end(token);
    }

    private class ActivityStackHandler
    extends Handler {
        ActivityStackHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity pause timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.app != null) {
                                ActivityStack.this.mService.logAppTooSlow(r.app, r.pauseTime, "pausing " + r);
                            }
                            ActivityStack.this.activityPausedLocked(r.appToken, true);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[20, 9, 12, 13] lbl16 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 103: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.continueLaunchTickingLocked()) {
                                ActivityStack.this.mService.logAppTooSlow(r.app, r.launchTickTime, "launching " + r);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[21, 7, 12, 14] lbl32 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 102: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity destroy timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.activityDestroyedLocked(r != null ? r.appToken : null, "destroyTimeout");
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[22, 10, 12, 15] lbl49 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 104: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity stop timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.isInHistory()) {
                                r.activityStoppedLocked(null, null, null);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[16, 23, 11, 12] lbl67 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 105: {
                    ScheduleDestroyArgs args = (ScheduleDestroyArgs)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.destroyActivitiesLocked(args.mOwner, args.mReason);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[17, 24, 8, 12] lbl82 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 106: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.notifyActivityDrawnLocked(null);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 6, 25, 12] lbl96 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
            }
        }
    }

    private static class ScheduleDestroyArgs {
        final ProcessRecord mOwner;
        final String mReason;

        ScheduleDestroyArgs(ProcessRecord owner, String reason) {
            this.mOwner = owner;
            this.mReason = reason;
        }
    }

    static enum ActivityState {
        INITIALIZING,
        RESUMED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED,
        FINISHING,
        DESTROYING,
        DESTROYED;

    }
}

