/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.dex.ArtManagerInternal;
import android.content.pm.dex.PackageOptimizationInfo;
import android.metrics.LogMaker;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.MemoryStatUtil;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import java.util.ArrayList;

class ActivityMetricsLogger {
    private static final String TAG = "ActivityManager";
    private static final int WINDOW_STATE_STANDARD = 0;
    private static final int WINDOW_STATE_SIDE_BY_SIDE = 1;
    private static final int WINDOW_STATE_FREEFORM = 2;
    private static final int WINDOW_STATE_ASSISTANT = 3;
    private static final int WINDOW_STATE_INVALID = -1;
    private static final long INVALID_START_TIME = -1L;
    private static final int MSG_CHECK_VISIBILITY = 0;
    private static final String[] TRON_WINDOW_STATE_VARZ_STRINGS = new String[]{"window_time_0", "window_time_1", "window_time_2", "window_time_3"};
    private int mWindowState = 0;
    private long mLastLogTimeSecs;
    private final ActivityStackSupervisor mSupervisor;
    private final Context mContext;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private long mCurrentTransitionStartTime = -1L;
    private long mLastTransitionStartTime = -1L;
    private int mCurrentTransitionDeviceUptime;
    private int mCurrentTransitionDelayMs;
    private boolean mLoggedTransitionStarting;
    private final SparseArray<WindowingModeTransitionInfo> mWindowingModeTransitionInfo = new SparseArray();
    private final SparseArray<WindowingModeTransitionInfo> mLastWindowingModeTransitionInfo = new SparseArray();
    private final H mHandler;
    private ArtManagerInternal mArtManagerInternal;

    ActivityMetricsLogger(ActivityStackSupervisor supervisor, Context context, Looper looper) {
        this.mLastLogTimeSecs = SystemClock.elapsedRealtime() / 1000L;
        this.mSupervisor = supervisor;
        this.mContext = context;
        this.mHandler = new H(looper);
    }

    void logWindowState() {
        long now = SystemClock.elapsedRealtime() / 1000L;
        if (this.mWindowState != -1) {
            MetricsLogger.count(this.mContext, TRON_WINDOW_STATE_VARZ_STRINGS[this.mWindowState], (int)(now - this.mLastLogTimeSecs));
        }
        this.mLastLogTimeSecs = now;
        this.mWindowState = -1;
        ActivityStack stack = this.mSupervisor.getFocusedStack();
        if (stack.isActivityTypeAssistant()) {
            this.mWindowState = 3;
            return;
        }
        int windowingMode = stack.getWindowingMode();
        if (windowingMode == 2) {
            stack = this.mSupervisor.findStackBehind(stack);
            windowingMode = stack.getWindowingMode();
        }
        switch (windowingMode) {
            case 1: {
                this.mWindowState = 0;
                break;
            }
            case 3: 
            case 4: {
                this.mWindowState = 1;
                break;
            }
            case 5: {
                this.mWindowState = 2;
                break;
            }
            default: {
                if (windowingMode == 0) break;
                throw new IllegalStateException("Unknown windowing mode for stack=" + stack + " windowingMode=" + windowingMode);
            }
        }
    }

    void notifyActivityLaunching() {
        if (!this.isAnyTransitionActive()) {
            this.mLastTransitionStartTime = this.mCurrentTransitionStartTime = SystemClock.uptimeMillis();
        }
    }

    void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity) {
        ProcessRecord processRecord = this.findProcessForActivity(launchedActivity);
        boolean processRunning = processRecord != null;
        boolean processSwitch = processRecord == null || !this.hasStartedActivity(processRecord, launchedActivity);
        this.notifyActivityLaunched(resultCode, launchedActivity, processRunning, processSwitch);
    }

    private boolean hasStartedActivity(ProcessRecord record, ActivityRecord launchedActivity) {
        ArrayList<ActivityRecord> activities = record.activities;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord activity = activities.get(i);
            if (launchedActivity == activity || activity.stopped) continue;
            return true;
        }
        return false;
    }

    private void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity, boolean processRunning, boolean processSwitch) {
        boolean otherWindowModesLaunching;
        int windowingMode;
        int n = windowingMode = launchedActivity != null ? launchedActivity.getWindowingMode() : 0;
        if (this.mCurrentTransitionStartTime == -1L) {
            return;
        }
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (launchedActivity != null && info != null) {
            info.launchedActivity = launchedActivity;
            return;
        }
        boolean bl = otherWindowModesLaunching = this.mWindowingModeTransitionInfo.size() > 0 && info == null;
        if (!(this.isLoggableResultCode(resultCode) && launchedActivity != null && processSwitch && windowingMode != 0 || otherWindowModesLaunching)) {
            this.reset(true);
            return;
        }
        if (otherWindowModesLaunching) {
            return;
        }
        WindowingModeTransitionInfo newInfo = new WindowingModeTransitionInfo();
        newInfo.launchedActivity = launchedActivity;
        newInfo.currentTransitionProcessRunning = processRunning;
        newInfo.startResult = resultCode;
        this.mWindowingModeTransitionInfo.put(windowingMode, newInfo);
        this.mLastWindowingModeTransitionInfo.put(windowingMode, newInfo);
        this.mCurrentTransitionDeviceUptime = (int)(SystemClock.uptimeMillis() / 1000L);
    }

    private boolean isLoggableResultCode(int resultCode) {
        return resultCode == 0 || resultCode == 2;
    }

    void notifyWindowsDrawn(int windowingMode, long timestamp) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (info == null || info.loggedWindowsDrawn) {
            return;
        }
        info.windowsDrawnDelayMs = this.calculateDelay(timestamp);
        info.loggedWindowsDrawn = true;
        if (this.allWindowsDrawn() && this.mLoggedTransitionStarting) {
            this.reset(false);
        }
    }

    void notifyStartingWindowDrawn(int windowingMode, long timestamp) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (info == null || info.loggedStartingWindowDrawn) {
            return;
        }
        info.loggedStartingWindowDrawn = true;
        info.startingWindowDelayMs = this.calculateDelay(timestamp);
    }

    void notifyTransitionStarting(SparseIntArray windowingModeToReason, long timestamp) {
        if (!this.isAnyTransitionActive() || this.mLoggedTransitionStarting) {
            return;
        }
        this.mCurrentTransitionDelayMs = this.calculateDelay(timestamp);
        this.mLoggedTransitionStarting = true;
        for (int index = windowingModeToReason.size() - 1; index >= 0; --index) {
            int windowingMode = windowingModeToReason.keyAt(index);
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
            if (info == null) continue;
            info.reason = windowingModeToReason.valueAt(index);
        }
        if (this.allWindowsDrawn()) {
            this.reset(false);
        }
    }

    void notifyVisibilityChanged(ActivityRecord activityRecord) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(activityRecord.getWindowingMode());
        if (info == null) {
            return;
        }
        if (info.launchedActivity != activityRecord) {
            return;
        }
        TaskRecord t = activityRecord.getTask();
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = t;
        args.arg2 = activityRecord;
        this.mHandler.obtainMessage(0, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVisibility(TaskRecord t, ActivityRecord r) {
        ActivityManagerService activityManagerService = this.mSupervisor.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(r.getWindowingMode());
                if (info != null && !t.isVisible()) {
                    this.logAppTransitionCancel(info);
                    this.mWindowingModeTransitionInfo.remove(r.getWindowingMode());
                    if (this.mWindowingModeTransitionInfo.size() == 0) {
                        this.reset(true);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void notifyBindApplication(ProcessRecord app) {
        for (int i = this.mWindowingModeTransitionInfo.size() - 1; i >= 0; --i) {
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.valueAt(i);
            if (((WindowingModeTransitionInfo)info).launchedActivity.appInfo != app.info) continue;
            info.bindApplicationDelayMs = this.calculateCurrentDelay();
        }
    }

    private boolean allWindowsDrawn() {
        for (int index = this.mWindowingModeTransitionInfo.size() - 1; index >= 0; --index) {
            if (this.mWindowingModeTransitionInfo.valueAt(index).loggedWindowsDrawn) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyTransitionActive() {
        return this.mCurrentTransitionStartTime != -1L && this.mWindowingModeTransitionInfo.size() > 0;
    }

    private void reset(boolean abort) {
        if (!abort && this.isAnyTransitionActive()) {
            this.logAppTransitionMultiEvents();
        }
        this.mCurrentTransitionStartTime = -1L;
        this.mCurrentTransitionDelayMs = -1;
        this.mLoggedTransitionStarting = false;
        this.mWindowingModeTransitionInfo.clear();
    }

    private int calculateCurrentDelay() {
        return (int)(SystemClock.uptimeMillis() - this.mCurrentTransitionStartTime);
    }

    private int calculateDelay(long timestamp) {
        return (int)(timestamp - this.mCurrentTransitionStartTime);
    }

    private void logAppTransitionCancel(WindowingModeTransitionInfo info) {
        int type = this.getTransitionType(info);
        if (type == -1) {
            return;
        }
        LogMaker builder = new LogMaker(1144);
        builder.setPackageName(((WindowingModeTransitionInfo)info).launchedActivity.packageName);
        builder.setType(type);
        builder.addTaggedData(871, ((WindowingModeTransitionInfo)info).launchedActivity.info.name);
        this.mMetricsLogger.write(builder);
        StatsLog.write(49, ((WindowingModeTransitionInfo)info).launchedActivity.appInfo.uid, ((WindowingModeTransitionInfo)info).launchedActivity.packageName, this.convertAppStartTransitionType(type), ((WindowingModeTransitionInfo)info).launchedActivity.info.name);
    }

    private void logAppTransitionMultiEvents() {
        for (int index = this.mWindowingModeTransitionInfo.size() - 1; index >= 0; --index) {
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.valueAt(index);
            int type = this.getTransitionType(info);
            if (type == -1) {
                return;
            }
            WindowingModeTransitionInfoSnapshot infoSnapshot = new WindowingModeTransitionInfoSnapshot(info);
            int currentTransitionDeviceUptime = this.mCurrentTransitionDeviceUptime;
            int currentTransitionDelayMs = this.mCurrentTransitionDelayMs;
            BackgroundThread.getHandler().post(() -> this.logAppTransition(currentTransitionDeviceUptime, currentTransitionDelayMs, infoSnapshot));
            ((WindowingModeTransitionInfo)info).launchedActivity.info.launchToken = null;
        }
    }

    private void logAppTransition(int currentTransitionDeviceUptime, int currentTransitionDelayMs, WindowingModeTransitionInfoSnapshot info) {
        String launchToken;
        LogMaker builder = new LogMaker(761);
        builder.setPackageName(info.packageName);
        builder.setType(info.type);
        builder.addTaggedData(871, info.launchedActivityName);
        boolean isInstantApp = info.applicationInfo.isInstantApp();
        if (info.launchedActivityLaunchedFromPackage != null) {
            builder.addTaggedData(904, info.launchedActivityLaunchedFromPackage);
        }
        if ((launchToken = info.launchedActivityLaunchToken) != null) {
            builder.addTaggedData(903, launchToken);
        }
        builder.addTaggedData(905, isInstantApp ? 1 : 0);
        builder.addTaggedData(325, currentTransitionDeviceUptime);
        builder.addTaggedData(319, currentTransitionDelayMs);
        builder.setSubtype(info.reason);
        if (info.startingWindowDelayMs != -1) {
            builder.addTaggedData(321, info.startingWindowDelayMs);
        }
        if (info.bindApplicationDelayMs != -1) {
            builder.addTaggedData(945, info.bindApplicationDelayMs);
        }
        builder.addTaggedData(322, info.windowsDrawnDelayMs);
        ArtManagerInternal artManagerInternal = this.getArtManagerInternal();
        PackageOptimizationInfo packageOptimizationInfo = artManagerInternal == null || info.launchedActivityAppRecordRequiredAbi == null ? PackageOptimizationInfo.createWithNoInfo() : artManagerInternal.getPackageOptimizationInfo(info.applicationInfo, info.launchedActivityAppRecordRequiredAbi);
        builder.addTaggedData(1321, packageOptimizationInfo.getCompilationReason());
        builder.addTaggedData(1320, packageOptimizationInfo.getCompilationFilter());
        this.mMetricsLogger.write(builder);
        StatsLog.write(48, ((WindowingModeTransitionInfoSnapshot)info).applicationInfo.uid, info.packageName, this.convertAppStartTransitionType(info.type), info.launchedActivityName, info.launchedActivityLaunchedFromPackage, isInstantApp, currentTransitionDeviceUptime * 1000, info.reason, currentTransitionDelayMs, info.startingWindowDelayMs, info.bindApplicationDelayMs, info.windowsDrawnDelayMs, launchToken, packageOptimizationInfo.getCompilationReason(), packageOptimizationInfo.getCompilationFilter());
        this.logAppStartMemoryStateCapture(info);
    }

    private int convertAppStartTransitionType(int tronType) {
        if (tronType == 7) {
            return 3;
        }
        if (tronType == 8) {
            return 1;
        }
        if (tronType == 9) {
            return 2;
        }
        return 0;
    }

    void logAppTransitionReportedDrawn(ActivityRecord r, boolean restoredFromBundle) {
        WindowingModeTransitionInfo info = this.mLastWindowingModeTransitionInfo.get(r.getWindowingMode());
        if (info == null) {
            return;
        }
        LogMaker builder = new LogMaker(1090);
        builder.setPackageName(r.packageName);
        builder.addTaggedData(871, r.info.name);
        long startupTimeMs = SystemClock.uptimeMillis() - this.mLastTransitionStartTime;
        builder.addTaggedData(1091, startupTimeMs);
        builder.setType(restoredFromBundle ? 13 : 12);
        builder.addTaggedData(324, info.currentTransitionProcessRunning ? 1 : 0);
        this.mMetricsLogger.write(builder);
        StatsLog.write(50, ((WindowingModeTransitionInfo)info).launchedActivity.appInfo.uid, ((WindowingModeTransitionInfo)info).launchedActivity.packageName, restoredFromBundle ? 1 : 2, ((WindowingModeTransitionInfo)info).launchedActivity.info.name, info.currentTransitionProcessRunning, startupTimeMs);
    }

    private int getTransitionType(WindowingModeTransitionInfo info) {
        if (info.currentTransitionProcessRunning) {
            if (info.startResult == 0) {
                return 8;
            }
            if (info.startResult == 2) {
                return 9;
            }
        } else if (info.startResult == 0) {
            return 7;
        }
        return -1;
    }

    private void logAppStartMemoryStateCapture(WindowingModeTransitionInfoSnapshot info) {
        if (info.processRecord == null) {
            return;
        }
        int uid = ((WindowingModeTransitionInfoSnapshot)info).applicationInfo.uid;
        int pid = ((WindowingModeTransitionInfoSnapshot)info).processRecord.pid;
        MemoryStatUtil.MemoryStat memoryStat = MemoryStatUtil.readMemoryStatFromFilesystem(uid, pid);
        if (memoryStat == null) {
            return;
        }
        StatsLog.write(55, uid, info.processName, info.launchedActivityName, memoryStat.pgfault, memoryStat.pgmajfault, memoryStat.rssInBytes, memoryStat.cacheInBytes, memoryStat.swapInBytes);
    }

    private ProcessRecord findProcessForActivity(ActivityRecord launchedActivity) {
        return launchedActivity != null ? this.mSupervisor.mService.mProcessNames.get(launchedActivity.processName, launchedActivity.appInfo.uid) : null;
    }

    private ArtManagerInternal getArtManagerInternal() {
        if (this.mArtManagerInternal == null) {
            this.mArtManagerInternal = LocalServices.getService(ArtManagerInternal.class);
        }
        return this.mArtManagerInternal;
    }

    private final class WindowingModeTransitionInfoSnapshot {
        private final ApplicationInfo applicationInfo;
        private final ProcessRecord processRecord;
        private final String packageName;
        private final String launchedActivityName;
        private final String launchedActivityLaunchedFromPackage;
        private final String launchedActivityLaunchToken;
        private final String launchedActivityAppRecordRequiredAbi;
        private final String processName;
        private final int reason;
        private final int startingWindowDelayMs;
        private final int bindApplicationDelayMs;
        private final int windowsDrawnDelayMs;
        private final int type;

        private WindowingModeTransitionInfoSnapshot(WindowingModeTransitionInfo info) {
            this.applicationInfo = ((WindowingModeTransitionInfo)info).launchedActivity.appInfo;
            this.packageName = ((WindowingModeTransitionInfo)info).launchedActivity.packageName;
            this.launchedActivityName = ((WindowingModeTransitionInfo)info).launchedActivity.info.name;
            this.launchedActivityLaunchedFromPackage = ((WindowingModeTransitionInfo)info).launchedActivity.launchedFromPackage;
            this.launchedActivityLaunchToken = ((WindowingModeTransitionInfo)info).launchedActivity.info.launchToken;
            this.launchedActivityAppRecordRequiredAbi = ((WindowingModeTransitionInfo)info).launchedActivity.app == null ? null : ((WindowingModeTransitionInfo)info).launchedActivity.app.requiredAbi;
            this.reason = info.reason;
            this.startingWindowDelayMs = info.startingWindowDelayMs;
            this.bindApplicationDelayMs = info.bindApplicationDelayMs;
            this.windowsDrawnDelayMs = info.windowsDrawnDelayMs;
            this.type = ActivityMetricsLogger.this.getTransitionType(info);
            this.processRecord = ActivityMetricsLogger.this.findProcessForActivity(info.launchedActivity);
            this.processName = ((WindowingModeTransitionInfo)info).launchedActivity.processName;
        }
    }

    private final class WindowingModeTransitionInfo {
        private ActivityRecord launchedActivity;
        private int startResult;
        private boolean currentTransitionProcessRunning;
        private int windowsDrawnDelayMs;
        private int startingWindowDelayMs = -1;
        private int bindApplicationDelayMs = -1;
        private int reason = 3;
        private boolean loggedWindowsDrawn;
        private boolean loggedStartingWindowDrawn;

        private WindowingModeTransitionInfo() {
        }
    }

    private final class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityMetricsLogger.this.checkVisibility((TaskRecord)args.arg1, (ActivityRecord)args.arg2);
                }
            }
        }
    }
}

