/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.GestureDescription;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import com.android.internal.os.SomeArgs;
import com.android.server.accessibility.BaseEventStreamTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MotionEventInjector
extends BaseEventStreamTransformation
implements Handler.Callback {
    private static final String LOG_TAG = "MotionEventInjector";
    private static final int MESSAGE_SEND_MOTION_EVENT = 1;
    private static final int MESSAGE_INJECT_EVENTS = 2;
    private static final int EVENT_META_STATE = 0;
    private static final int EVENT_BUTTON_STATE = 0;
    private static final int EVENT_DEVICE_ID = 0;
    private static final int EVENT_EDGE_FLAGS = 0;
    private static final int EVENT_SOURCE = 4098;
    private static final int EVENT_FLAGS = 0;
    private static final float EVENT_X_PRECISION = 1.0f;
    private static final float EVENT_Y_PRECISION = 1.0f;
    private static MotionEvent.PointerCoords[] sPointerCoords;
    private static MotionEvent.PointerProperties[] sPointerProps;
    private final Handler mHandler;
    private final SparseArray<Boolean> mOpenGesturesInProgress = new SparseArray();
    private IAccessibilityServiceClient mServiceInterfaceForCurrentGesture;
    private IntArray mSequencesInProgress = new IntArray(5);
    private boolean mIsDestroyed = false;
    private GestureDescription.TouchPoint[] mLastTouchPoints;
    private int mNumLastTouchPoints;
    private long mDownTime;
    private long mLastScheduledEventTime;
    private SparseIntArray mStrokeIdToPointerId = new SparseIntArray(5);

    public MotionEventInjector(Looper looper) {
        this.mHandler = new Handler(looper, this);
    }

    public MotionEventInjector(Handler handler) {
        this.mHandler = handler;
    }

    public void injectEvents(List<GestureDescription.GestureStep> gestureSteps, IAccessibilityServiceClient serviceInterface, int sequence) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = gestureSteps;
        args.arg2 = serviceInterface;
        args.argi1 = sequence;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, args));
    }

    @Override
    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        this.cancelAnyPendingInjectedEvents();
        this.sendMotionEventToNext(event, rawEvent, policyFlags);
    }

    @Override
    public void clearEvents(int inputSource) {
        if (!this.mHandler.hasMessages(1)) {
            this.mOpenGesturesInProgress.put(inputSource, false);
        }
    }

    @Override
    public void onDestroy() {
        this.cancelAnyPendingInjectedEvents();
        this.mIsDestroyed = true;
    }

    @Override
    public boolean handleMessage(Message message) {
        boolean isEndOfSequence;
        if (message.what == 2) {
            SomeArgs args = (SomeArgs)message.obj;
            this.injectEventsMainThread((List)args.arg1, (IAccessibilityServiceClient)args.arg2, args.argi1);
            args.recycle();
            return true;
        }
        if (message.what != 1) {
            Slog.e(LOG_TAG, "Unknown message: " + message.what);
            return false;
        }
        MotionEvent motionEvent = (MotionEvent)message.obj;
        this.sendMotionEventToNext(motionEvent, motionEvent, 0x40000000);
        boolean bl = isEndOfSequence = message.arg1 != 0;
        if (isEndOfSequence) {
            this.notifyService(this.mServiceInterfaceForCurrentGesture, this.mSequencesInProgress.get(0), true);
            this.mSequencesInProgress.remove(0);
        }
        return true;
    }

    private void injectEventsMainThread(List<GestureDescription.GestureStep> gestureSteps, IAccessibilityServiceClient serviceInterface, int sequence) {
        if (this.mIsDestroyed) {
            try {
                serviceInterface.onPerformGestureResult(sequence, false);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending status with mIsDestroyed to " + serviceInterface, re);
            }
            return;
        }
        if (this.getNext() == null) {
            this.notifyService(serviceInterface, sequence, false);
            return;
        }
        boolean continuingGesture = this.newGestureTriesToContinueOldOne(gestureSteps);
        if (continuingGesture && (serviceInterface != this.mServiceInterfaceForCurrentGesture || !this.prepareToContinueOldGesture(gestureSteps))) {
            this.cancelAnyPendingInjectedEvents();
            this.notifyService(serviceInterface, sequence, false);
            return;
        }
        if (!continuingGesture) {
            this.cancelAnyPendingInjectedEvents();
            this.cancelAnyGestureInProgress(4098);
        }
        this.mServiceInterfaceForCurrentGesture = serviceInterface;
        long currentTime = SystemClock.uptimeMillis();
        List<MotionEvent> events = this.getMotionEventsFromGestureSteps(gestureSteps, this.mSequencesInProgress.size() == 0 ? currentTime : this.mLastScheduledEventTime);
        if (events.isEmpty()) {
            this.notifyService(serviceInterface, sequence, false);
            return;
        }
        this.mSequencesInProgress.add(sequence);
        for (int i = 0; i < events.size(); ++i) {
            MotionEvent event = events.get(i);
            int isEndOfSequence = i == events.size() - 1 ? 1 : 0;
            Message message = this.mHandler.obtainMessage(1, isEndOfSequence, 0, event);
            this.mLastScheduledEventTime = event.getEventTime();
            this.mHandler.sendMessageDelayed(message, Math.max(0L, event.getEventTime() - currentTime));
        }
    }

    private boolean newGestureTriesToContinueOldOne(List<GestureDescription.GestureStep> gestureSteps) {
        if (gestureSteps.isEmpty()) {
            return false;
        }
        GestureDescription.GestureStep firstStep = gestureSteps.get(0);
        for (int i = 0; i < firstStep.numTouchPoints; ++i) {
            if (firstStep.touchPoints[i].mIsStartOfPath) continue;
            return true;
        }
        return false;
    }

    private boolean prepareToContinueOldGesture(List<GestureDescription.GestureStep> gestureSteps) {
        int i;
        if (gestureSteps.isEmpty() || this.mLastTouchPoints == null || this.mNumLastTouchPoints == 0) {
            return false;
        }
        GestureDescription.GestureStep firstStep = gestureSteps.get(0);
        int numContinuedStrokes = 0;
        for (i = 0; i < firstStep.numTouchPoints; ++i) {
            GestureDescription.TouchPoint touchPoint = firstStep.touchPoints[i];
            if (!touchPoint.mIsStartOfPath) {
                int continuedPointerId = this.mStrokeIdToPointerId.get(touchPoint.mContinuedStrokeId, -1);
                if (continuedPointerId == -1) {
                    Slog.w(LOG_TAG, "Can't continue gesture due to unknown continued stroke id in " + touchPoint);
                    return false;
                }
                this.mStrokeIdToPointerId.put(touchPoint.mStrokeId, continuedPointerId);
                int lastPointIndex = MotionEventInjector.findPointByStrokeId(this.mLastTouchPoints, this.mNumLastTouchPoints, touchPoint.mContinuedStrokeId);
                if (lastPointIndex < 0) {
                    Slog.w(LOG_TAG, "Can't continue gesture due continued gesture id of " + touchPoint + " not matching any previous strokes in " + Arrays.asList(this.mLastTouchPoints));
                    return false;
                }
                if (this.mLastTouchPoints[lastPointIndex].mIsEndOfPath || this.mLastTouchPoints[lastPointIndex].mX != touchPoint.mX || this.mLastTouchPoints[lastPointIndex].mY != touchPoint.mY) {
                    Slog.w(LOG_TAG, "Can't continue gesture due to points mismatch between " + this.mLastTouchPoints[lastPointIndex] + " and " + touchPoint);
                    return false;
                }
                this.mLastTouchPoints[lastPointIndex].mStrokeId = touchPoint.mStrokeId;
            }
            ++numContinuedStrokes;
        }
        for (i = 0; i < this.mNumLastTouchPoints; ++i) {
            if (this.mLastTouchPoints[i].mIsEndOfPath) continue;
            --numContinuedStrokes;
        }
        return numContinuedStrokes == 0;
    }

    private void sendMotionEventToNext(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        if (this.getNext() != null) {
            super.onMotionEvent(event, rawEvent, policyFlags);
            if (event.getActionMasked() == 0) {
                this.mOpenGesturesInProgress.put(event.getSource(), true);
            }
            if (event.getActionMasked() == 1 || event.getActionMasked() == 3) {
                this.mOpenGesturesInProgress.put(event.getSource(), false);
            }
        }
    }

    private void cancelAnyGestureInProgress(int source) {
        if (this.getNext() != null && this.mOpenGesturesInProgress.get(source, false).booleanValue()) {
            long now = SystemClock.uptimeMillis();
            MotionEvent cancelEvent = this.obtainMotionEvent(now, now, 3, this.getLastTouchPoints(), 1);
            this.sendMotionEventToNext(cancelEvent, cancelEvent, 0x40000000);
            this.mOpenGesturesInProgress.put(source, false);
        }
    }

    private void cancelAnyPendingInjectedEvents() {
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
            this.cancelAnyGestureInProgress(4098);
            for (int i = this.mSequencesInProgress.size() - 1; i >= 0; --i) {
                this.notifyService(this.mServiceInterfaceForCurrentGesture, this.mSequencesInProgress.get(i), false);
                this.mSequencesInProgress.remove(i);
            }
        } else if (this.mNumLastTouchPoints != 0) {
            this.cancelAnyGestureInProgress(4098);
        }
        this.mNumLastTouchPoints = 0;
        this.mStrokeIdToPointerId.clear();
    }

    private void notifyService(IAccessibilityServiceClient service, int sequence, boolean success) {
        try {
            service.onPerformGestureResult(sequence, success);
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error sending motion event injection status to " + this.mServiceInterfaceForCurrentGesture, re);
        }
    }

    private List<MotionEvent> getMotionEventsFromGestureSteps(List<GestureDescription.GestureStep> steps, long startTime) {
        ArrayList<MotionEvent> motionEvents = new ArrayList<MotionEvent>();
        GestureDescription.TouchPoint[] lastTouchPoints = this.getLastTouchPoints();
        for (int i = 0; i < steps.size(); ++i) {
            GestureDescription.GestureStep step = steps.get(i);
            int currentTouchPointSize = step.numTouchPoints;
            if (currentTouchPointSize > lastTouchPoints.length) {
                this.mNumLastTouchPoints = 0;
                motionEvents.clear();
                return motionEvents;
            }
            this.appendMoveEventIfNeeded(motionEvents, step.touchPoints, currentTouchPointSize, startTime + step.timeSinceGestureStart);
            this.appendUpEvents(motionEvents, step.touchPoints, currentTouchPointSize, startTime + step.timeSinceGestureStart);
            this.appendDownEvents(motionEvents, step.touchPoints, currentTouchPointSize, startTime + step.timeSinceGestureStart);
        }
        return motionEvents;
    }

    private GestureDescription.TouchPoint[] getLastTouchPoints() {
        if (this.mLastTouchPoints == null) {
            int capacity = GestureDescription.getMaxStrokeCount();
            this.mLastTouchPoints = new GestureDescription.TouchPoint[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.mLastTouchPoints[i] = new GestureDescription.TouchPoint();
            }
        }
        return this.mLastTouchPoints;
    }

    private void appendMoveEventIfNeeded(List<MotionEvent> motionEvents, GestureDescription.TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
        boolean moveFound = false;
        GestureDescription.TouchPoint[] lastTouchPoints = this.getLastTouchPoints();
        for (int i = 0; i < currentTouchPointsSize; ++i) {
            int lastPointsIndex = MotionEventInjector.findPointByStrokeId(lastTouchPoints, this.mNumLastTouchPoints, currentTouchPoints[i].mStrokeId);
            if (lastPointsIndex < 0) continue;
            moveFound |= lastTouchPoints[lastPointsIndex].mX != currentTouchPoints[i].mX || lastTouchPoints[lastPointsIndex].mY != currentTouchPoints[i].mY;
            lastTouchPoints[lastPointsIndex].copyFrom(currentTouchPoints[i]);
        }
        if (moveFound) {
            motionEvents.add(this.obtainMotionEvent(this.mDownTime, currentTime, 2, lastTouchPoints, this.mNumLastTouchPoints));
        }
    }

    private void appendUpEvents(List<MotionEvent> motionEvents, GestureDescription.TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
        GestureDescription.TouchPoint[] lastTouchPoints = this.getLastTouchPoints();
        for (int i = 0; i < currentTouchPointsSize; ++i) {
            int indexOfUpEvent;
            if (!currentTouchPoints[i].mIsEndOfPath || (indexOfUpEvent = MotionEventInjector.findPointByStrokeId(lastTouchPoints, this.mNumLastTouchPoints, currentTouchPoints[i].mStrokeId)) < 0) continue;
            int action = this.mNumLastTouchPoints == 1 ? 1 : 6;
            motionEvents.add(this.obtainMotionEvent(this.mDownTime, currentTime, action |= indexOfUpEvent << 8, lastTouchPoints, this.mNumLastTouchPoints));
            for (int j = indexOfUpEvent; j < this.mNumLastTouchPoints - 1; ++j) {
                lastTouchPoints[j].copyFrom(this.mLastTouchPoints[j + 1]);
            }
            --this.mNumLastTouchPoints;
            if (this.mNumLastTouchPoints != 0) continue;
            this.mStrokeIdToPointerId.clear();
        }
    }

    private void appendDownEvents(List<MotionEvent> motionEvents, GestureDescription.TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
        GestureDescription.TouchPoint[] lastTouchPoints = this.getLastTouchPoints();
        for (int i = 0; i < currentTouchPointsSize; ++i) {
            int action;
            if (!currentTouchPoints[i].mIsStartOfPath) continue;
            lastTouchPoints[this.mNumLastTouchPoints++].copyFrom(currentTouchPoints[i]);
            int n = action = this.mNumLastTouchPoints == 1 ? 0 : 5;
            if (action == 0) {
                this.mDownTime = currentTime;
            }
            motionEvents.add(this.obtainMotionEvent(this.mDownTime, currentTime, action |= i << 8, lastTouchPoints, this.mNumLastTouchPoints));
        }
    }

    private MotionEvent obtainMotionEvent(long downTime, long eventTime, int action, GestureDescription.TouchPoint[] touchPoints, int touchPointsSize) {
        int i;
        if (sPointerCoords == null || sPointerCoords.length < touchPointsSize) {
            sPointerCoords = new MotionEvent.PointerCoords[touchPointsSize];
            for (i = 0; i < touchPointsSize; ++i) {
                MotionEventInjector.sPointerCoords[i] = new MotionEvent.PointerCoords();
            }
        }
        if (sPointerProps == null || sPointerProps.length < touchPointsSize) {
            sPointerProps = new MotionEvent.PointerProperties[touchPointsSize];
            for (i = 0; i < touchPointsSize; ++i) {
                MotionEventInjector.sPointerProps[i] = new MotionEvent.PointerProperties();
            }
        }
        for (i = 0; i < touchPointsSize; ++i) {
            int pointerId = this.mStrokeIdToPointerId.get(touchPoints[i].mStrokeId, -1);
            if (pointerId == -1) {
                pointerId = this.getUnusedPointerId();
                this.mStrokeIdToPointerId.put(touchPoints[i].mStrokeId, pointerId);
            }
            MotionEventInjector.sPointerProps[i].id = pointerId;
            MotionEventInjector.sPointerProps[i].toolType = 0;
            sPointerCoords[i].clear();
            MotionEventInjector.sPointerCoords[i].pressure = 1.0f;
            MotionEventInjector.sPointerCoords[i].size = 1.0f;
            MotionEventInjector.sPointerCoords[i].x = touchPoints[i].mX;
            MotionEventInjector.sPointerCoords[i].y = touchPoints[i].mY;
        }
        return MotionEvent.obtain(downTime, eventTime, action, touchPointsSize, sPointerProps, sPointerCoords, 0, 0, 1.0f, 1.0f, 0, 0, 4098, 0);
    }

    private static int findPointByStrokeId(GestureDescription.TouchPoint[] touchPoints, int touchPointsSize, int strokeId) {
        for (int i = 0; i < touchPointsSize; ++i) {
            if (touchPoints[i].mStrokeId != strokeId) continue;
            return i;
        }
        return -1;
    }

    private int getUnusedPointerId() {
        int MAX_POINTER_ID = 10;
        int pointerId = 0;
        while (this.mStrokeIdToPointerId.indexOfValue(pointerId) >= 0) {
            if (++pointerId < MAX_POINTER_ID) continue;
            return MAX_POINTER_ID;
        }
        return pointerId;
    }
}

