/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.app.StatusBarManager;
import android.content.Context;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.KeyEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ScreenshotHelper;
import com.android.server.LocalServices;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerInternal;
import java.util.function.Supplier;

public class GlobalActionPerformer {
    private final WindowManagerInternal mWindowManagerService;
    private final Context mContext;
    private Supplier<ScreenshotHelper> mScreenshotHelperSupplier;

    public GlobalActionPerformer(Context context, WindowManagerInternal windowManagerInternal) {
        this.mContext = context;
        this.mWindowManagerService = windowManagerInternal;
        this.mScreenshotHelperSupplier = null;
    }

    @VisibleForTesting
    public GlobalActionPerformer(Context context, WindowManagerInternal windowManagerInternal, Supplier<ScreenshotHelper> screenshotHelperSupplier) {
        this(context, windowManagerInternal);
        this.mScreenshotHelperSupplier = screenshotHelperSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGlobalAction(int action) {
        long identity = Binder.clearCallingIdentity();
        try {
            switch (action) {
                case 1: {
                    this.sendDownAndUpKeyEvents(4);
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    this.sendDownAndUpKeyEvents(3);
                    boolean bl = true;
                    return bl;
                }
                case 3: {
                    boolean bl = this.openRecents();
                    return bl;
                }
                case 4: {
                    this.expandNotifications();
                    boolean bl = true;
                    return bl;
                }
                case 5: {
                    this.expandQuickSettings();
                    boolean bl = true;
                    return bl;
                }
                case 6: {
                    this.showGlobalActions();
                    boolean bl = true;
                    return bl;
                }
                case 7: {
                    boolean bl = this.toggleSplitScreen();
                    return bl;
                }
                case 8: {
                    boolean bl = this.lockScreen();
                    return bl;
                }
                case 9: {
                    boolean bl = this.takeScreenshot();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void sendDownAndUpKeyEvents(int keyCode) {
        long token = Binder.clearCallingIdentity();
        long downTime = SystemClock.uptimeMillis();
        this.sendKeyEventIdentityCleared(keyCode, 0, downTime, downTime);
        this.sendKeyEventIdentityCleared(keyCode, 1, downTime, SystemClock.uptimeMillis());
        Binder.restoreCallingIdentity(token);
    }

    private void sendKeyEventIdentityCleared(int keyCode, int action, long downTime, long time) {
        KeyEvent event = KeyEvent.obtain(downTime, time, action, keyCode, 0, 0, -1, 0, 8, 257, null);
        InputManager.getInstance().injectInputEvent(event, 0);
        event.recycle();
    }

    private void expandNotifications() {
        long token = Binder.clearCallingIdentity();
        StatusBarManager statusBarManager = (StatusBarManager)this.mContext.getSystemService("statusbar");
        statusBarManager.expandNotificationsPanel();
        Binder.restoreCallingIdentity(token);
    }

    private void expandQuickSettings() {
        long token = Binder.clearCallingIdentity();
        StatusBarManager statusBarManager = (StatusBarManager)this.mContext.getSystemService("statusbar");
        statusBarManager.expandSettingsPanel();
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openRecents() {
        long token = Binder.clearCallingIdentity();
        try {
            StatusBarManagerInternal statusBarService = LocalServices.getService(StatusBarManagerInternal.class);
            if (statusBarService == null) {
                boolean bl = false;
                return bl;
            }
            statusBarService.toggleRecentApps();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return true;
    }

    private void showGlobalActions() {
        this.mWindowManagerService.showGlobalActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean toggleSplitScreen() {
        long token = Binder.clearCallingIdentity();
        try {
            StatusBarManagerInternal statusBarService = LocalServices.getService(StatusBarManagerInternal.class);
            if (statusBarService == null) {
                boolean bl = false;
                return bl;
            }
            statusBarService.toggleSplitScreen();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return true;
    }

    private boolean lockScreen() {
        this.mContext.getSystemService(PowerManager.class).goToSleep(SystemClock.uptimeMillis(), 7, 0);
        this.mWindowManagerService.lockNow();
        return true;
    }

    private boolean takeScreenshot() {
        ScreenshotHelper screenshotHelper = this.mScreenshotHelperSupplier != null ? this.mScreenshotHelperSupplier.get() : new ScreenshotHelper(this.mContext);
        screenshotHelper.takeScreenshot(1, true, true, new Handler(Looper.getMainLooper()));
        return true;
    }
}

