/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;

interface EventStreamTransformation {
    default public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        EventStreamTransformation next = this.getNext();
        if (next != null) {
            next.onMotionEvent(event, rawEvent, policyFlags);
        }
    }

    default public void onKeyEvent(KeyEvent event, int policyFlags) {
        EventStreamTransformation next = this.getNext();
        if (next != null) {
            next.onKeyEvent(event, policyFlags);
        }
    }

    default public void onAccessibilityEvent(AccessibilityEvent event) {
        EventStreamTransformation next = this.getNext();
        if (next != null) {
            next.onAccessibilityEvent(event);
        }
    }

    public void setNext(EventStreamTransformation var1);

    public EventStreamTransformation getNext();

    default public void clearEvents(int inputSource) {
        EventStreamTransformation next = this.getNext();
        if (next != null) {
            next.clearEvents(inputSource);
        }
    }

    default public void onDestroy() {
    }
}

