/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.IActivityManager;
import android.app.IUidObserver;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.ResolverActivity;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class PinnerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "PinnerService";
    private static final String PIN_META_FILENAME = "pinlist.meta";
    private static final int PAGE_SIZE = (int)Os.sysconf(OsConstants._SC_PAGESIZE);
    private static final int MATCH_FLAGS = 851968;
    private static final int KEY_CAMERA = 0;
    private static final int KEY_HOME = 1;
    private static final int MAX_CAMERA_PIN_SIZE = 0x5000000;
    private static final int MAX_HOME_PIN_SIZE = 0x600000;
    private final Context mContext;
    private final ActivityManagerInternal mAmInternal;
    private final IActivityManager mAm;
    @GuardedBy(value="this")
    private final ArrayList<PinnedFile> mPinnedFiles = new ArrayList();
    @GuardedBy(value="this")
    private final ArrayMap<Integer, PinnedApp> mPinnedApps = new ArrayMap();
    @GuardedBy(value="this")
    private final ArrayMap<Integer, Integer> mPendingRepin = new ArrayMap();
    private final ArraySet<Integer> mPinKeys = new ArraySet();
    private BinderService mBinderService;
    private PinnerHandler mPinnerHandler = null;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.PACKAGE_REPLACED".equals(intent.getAction())) {
                Uri packageUri = intent.getData();
                String packageName = packageUri.getSchemeSpecificPart();
                ArraySet<String> updatedPackages = new ArraySet<String>();
                updatedPackages.add(packageName);
                PinnerService.this.update(updatedPackages, true);
            }
        }
    };

    public PinnerService(Context context) {
        super(context);
        this.mContext = context;
        boolean shouldPinCamera = context.getResources().getBoolean(17957003);
        boolean shouldPinHome = context.getResources().getBoolean(17957004);
        if (shouldPinCamera) {
            this.mPinKeys.add(0);
        }
        if (shouldPinHome) {
            this.mPinKeys.add(1);
        }
        this.mPinnerHandler = new PinnerHandler(BackgroundThread.get().getLooper());
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAm = ActivityManager.getService();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.registerUidListener();
        this.registerUserSetupCompleteListener();
    }

    @Override
    public void onStart() {
        this.mBinderService = new BinderService();
        this.publishBinderService("pinner", this.mBinderService);
        this.publishLocalService(PinnerService.class, this);
        this.mPinnerHandler.obtainMessage(4001).sendToTarget();
        this.sendPinAppsMessage(0);
    }

    @Override
    public void onSwitchUser(int userHandle) {
        this.sendPinAppsMessage(userHandle);
    }

    @Override
    public void onUnlockUser(int userHandle) {
        this.sendPinAppsMessage(userHandle);
    }

    public void update(ArraySet<String> updatedPackages, boolean force) {
        int currentUser = ActivityManager.getCurrentUser();
        for (int i = this.mPinKeys.size() - 1; i >= 0; --i) {
            int key = this.mPinKeys.valueAt(i);
            ApplicationInfo info = this.getInfoForKey(key, currentUser);
            if (info == null || !updatedPackages.contains(info.packageName)) continue;
            Slog.i(TAG, "Updating pinned files for " + info.packageName + " force=" + force);
            this.sendPinAppMessage(key, currentUser, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePinOnStart() {
        String[] filesToPin;
        for (String fileToPin : filesToPin = this.mContext.getResources().getStringArray(17236000)) {
            PinnedFile pf = PinnerService.pinFile(fileToPin, Integer.MAX_VALUE, false);
            if (pf == null) {
                Slog.e(TAG, "Failed to pin file = " + fileToPin);
                continue;
            }
            PinnerService pinnerService = this;
            synchronized (pinnerService) {
                this.mPinnedFiles.add(pf);
            }
        }
    }

    private void registerUserSetupCompleteListener() {
        final Uri userSetupCompleteUri = Settings.Secure.getUriFor("user_setup_complete");
        this.mContext.getContentResolver().registerContentObserver(userSetupCompleteUri, false, new ContentObserver(null){

            @Override
            public void onChange(boolean selfChange, Uri uri) {
                if (userSetupCompleteUri.equals(uri)) {
                    PinnerService.this.sendPinAppMessage(1, ActivityManager.getCurrentUser(), true);
                }
            }
        }, -1);
    }

    private void registerUidListener() {
        try {
            this.mAm.registerUidObserver(new IUidObserver.Stub(){

                @Override
                public void onUidGone(int uid, boolean disabled) throws RemoteException {
                    PinnerService.this.mPinnerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((PinnerService)rec$).handleUidGone(x$0), PinnerService.this, uid));
                }

                @Override
                public void onUidActive(int uid) throws RemoteException {
                    PinnerService.this.mPinnerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((PinnerService)rec$).handleUidActive(x$0), PinnerService.this, uid));
                }

                @Override
                public void onUidIdle(int uid, boolean disabled) throws RemoteException {
                }

                @Override
                public void onUidStateChanged(int uid, int procState, long procStateSeq) throws RemoteException {
                }

                @Override
                public void onUidCachedChanged(int uid, boolean cached) throws RemoteException {
                }
            }, 10, 0, "system");
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to register uid observer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUidGone(int uid) {
        int key;
        this.updateActiveState(uid, false);
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            key = this.mPendingRepin.getOrDefault(uid, -1);
            if (key == -1) {
                return;
            }
            this.mPendingRepin.remove(uid);
        }
        this.pinApp(key, ActivityManager.getCurrentUser(), false);
    }

    private void handleUidActive(int uid) {
        this.updateActiveState(uid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveState(int uid, boolean active) {
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            for (int i = this.mPinnedApps.size() - 1; i >= 0; --i) {
                PinnedApp app = this.mPinnedApps.valueAt(i);
                if (app.uid != uid) continue;
                app.active = active;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpinApp(int key) {
        ArrayList<PinnedFile> pinnedAppFiles;
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            PinnedApp app = this.mPinnedApps.get(key);
            if (app == null) {
                return;
            }
            this.mPinnedApps.remove(key);
            pinnedAppFiles = new ArrayList<PinnedFile>(app.mFiles);
        }
        for (PinnedFile pinnedFile : pinnedAppFiles) {
            pinnedFile.close();
        }
    }

    private boolean isResolverActivity(ActivityInfo info) {
        return ResolverActivity.class.getName().equals(info.name);
    }

    private ApplicationInfo getCameraInfo(int userHandle) {
        Intent cameraIntent = new Intent("android.media.action.STILL_IMAGE_CAMERA");
        ApplicationInfo info = this.getApplicationInfoForIntent(cameraIntent, userHandle, false);
        if (info == null) {
            cameraIntent = new Intent("android.media.action.STILL_IMAGE_CAMERA_SECURE");
            info = this.getApplicationInfoForIntent(cameraIntent, userHandle, false);
        }
        if (info == null) {
            cameraIntent = new Intent("android.media.action.STILL_IMAGE_CAMERA");
            info = this.getApplicationInfoForIntent(cameraIntent, userHandle, true);
        }
        return info;
    }

    private ApplicationInfo getHomeInfo(int userHandle) {
        Intent intent = this.mAmInternal.getHomeIntent();
        return this.getApplicationInfoForIntent(intent, userHandle, false);
    }

    private ApplicationInfo getApplicationInfoForIntent(Intent intent, int userHandle, boolean defaultToSystemApp) {
        if (intent == null) {
            return null;
        }
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivityAsUser(intent, 851968, userHandle);
        if (resolveInfo == null) {
            return null;
        }
        if (!this.isResolverActivity(resolveInfo.activityInfo)) {
            return resolveInfo.activityInfo.applicationInfo;
        }
        if (defaultToSystemApp) {
            List<ResolveInfo> infoList = this.mContext.getPackageManager().queryIntentActivitiesAsUser(intent, 851968, userHandle);
            ApplicationInfo systemAppInfo = null;
            for (ResolveInfo info : infoList) {
                if ((info.activityInfo.applicationInfo.flags & 1) == 0) continue;
                if (systemAppInfo == null) {
                    systemAppInfo = info.activityInfo.applicationInfo;
                    continue;
                }
                return null;
            }
            return systemAppInfo;
        }
        return null;
    }

    private void sendPinAppsMessage(int userHandle) {
        this.mPinnerHandler.sendMessage(PooledLambda.obtainMessage(PinnerService::pinApps, this, userHandle));
    }

    private void pinApps(int userHandle) {
        for (int i = this.mPinKeys.size() - 1; i >= 0; --i) {
            int key = this.mPinKeys.valueAt(i);
            this.pinApp(key, userHandle, true);
        }
    }

    private void sendPinAppMessage(int key, int userHandle, boolean force) {
        this.mPinnerHandler.sendMessage(PooledLambda.obtainMessage(PinnerService::pinApp, this, key, userHandle, force));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinApp(int key, int userHandle, boolean force) {
        int uid = this.getUidForKey(key);
        if (!force && uid != -1) {
            PinnerService pinnerService = this;
            synchronized (pinnerService) {
                this.mPendingRepin.put(uid, key);
            }
            return;
        }
        this.unpinApp(key);
        ApplicationInfo info = this.getInfoForKey(key, userHandle);
        if (info != null) {
            this.pinApp(key, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForKey(int key) {
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            PinnedApp existing = this.mPinnedApps.get(key);
            return existing != null && existing.active ? existing.uid : -1;
        }
    }

    private ApplicationInfo getInfoForKey(int key, int userHandle) {
        switch (key) {
            case 0: {
                return this.getCameraInfo(userHandle);
            }
            case 1: {
                return this.getHomeInfo(userHandle);
            }
        }
        return null;
    }

    private String getNameForKey(int key) {
        switch (key) {
            case 0: {
                return "Camera";
            }
            case 1: {
                return "Home";
            }
        }
        return null;
    }

    private int getSizeLimitForKey(int key) {
        switch (key) {
            case 0: {
                return 0x5000000;
            }
            case 1: {
                return 0x600000;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinApp(int key, ApplicationInfo appInfo) {
        if (appInfo == null) {
            return;
        }
        PinnedApp pinnedApp = new PinnedApp(appInfo);
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            this.mPinnedApps.put(key, pinnedApp);
        }
        int pinSizeLimit = this.getSizeLimitForKey(key);
        String apk = appInfo.sourceDir;
        PinnedFile pf = PinnerService.pinFile(apk, pinSizeLimit, true);
        if (pf == null) {
            Slog.e(TAG, "Failed to pin " + apk);
            return;
        }
        PinnerService pinnerService2 = this;
        synchronized (pinnerService2) {
            pinnedApp.mFiles.add(pf);
        }
        String arch = "arm";
        if (appInfo.primaryCpuAbi != null) {
            if (VMRuntime.is64BitAbi(appInfo.primaryCpuAbi)) {
                arch = arch + "64";
            }
        } else if (VMRuntime.is64BitAbi(Build.SUPPORTED_ABIS[0])) {
            arch = arch + "64";
        }
        String baseCodePath = appInfo.getBaseCodePath();
        String[] files = null;
        try {
            files = DexFile.getDexFileOutputPaths(baseCodePath, arch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (files == null) {
            return;
        }
        for (String file : files) {
            pf = PinnerService.pinFile(file, pinSizeLimit, false);
            if (pf == null) continue;
            PinnerService pinnerService3 = this;
            synchronized (pinnerService3) {
                pinnedApp.mFiles.add(pf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PinnedFile pinFile(String fileToPin, int maxBytesToPin, boolean attemptPinIntrospection) {
        PinnedFile pinnedFile;
        ZipFile fileAsZip = null;
        InputStream pinRangeStream = null;
        try {
            if (attemptPinIntrospection) {
                fileAsZip = PinnerService.maybeOpenZip(fileToPin);
            }
            if (fileAsZip != null) {
                pinRangeStream = PinnerService.maybeOpenPinMetaInZip(fileAsZip, fileToPin);
            }
            Slog.d(TAG, "pinRangeStream: " + pinRangeStream);
            PinRangeSource pinRangeSource = pinRangeStream != null ? new PinRangeSourceStream(pinRangeStream) : new PinRangeSourceStatic(0, Integer.MAX_VALUE);
            pinnedFile = PinnerService.pinFileRanges(fileToPin, maxBytesToPin, pinRangeSource);
        }
        catch (Throwable throwable) {
            PinnerService.safeClose(pinRangeStream);
            PinnerService.safeClose(fileAsZip);
            throw throwable;
        }
        PinnerService.safeClose(pinRangeStream);
        PinnerService.safeClose(fileAsZip);
        return pinnedFile;
    }

    private static ZipFile maybeOpenZip(String fileName) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(fileName);
        }
        catch (IOException ex) {
            Slog.w(TAG, String.format("could not open \"%s\" as zip: pinning as blob", fileName), ex);
        }
        return zip;
    }

    private static InputStream maybeOpenPinMetaInZip(ZipFile zipFile, String fileName) {
        ZipEntry pinMetaEntry = zipFile.getEntry(PIN_META_FILENAME);
        InputStream pinMetaStream = null;
        if (pinMetaEntry != null) {
            try {
                pinMetaStream = zipFile.getInputStream(pinMetaEntry);
            }
            catch (IOException ex) {
                Slog.w(TAG, String.format("error reading pin metadata \"%s\": pinning as blob", fileName), ex);
            }
        }
        return pinMetaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PinnedFile pinFileRanges(String fileToPin, int maxBytesToPin, PinRangeSource pinRangeSource) {
        FileDescriptor fd = new FileDescriptor();
        long address = -1L;
        int mapSize = 0;
        try {
            int openFlags = OsConstants.O_RDONLY | OsConstants.O_CLOEXEC | OsConstants.O_NOFOLLOW;
            fd = Os.open(fileToPin, openFlags, 0);
            mapSize = (int)Math.min(Os.fstat((FileDescriptor)fd).st_size, Integer.MAX_VALUE);
            address = Os.mmap(0L, mapSize, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
            PinRange pinRange = new PinRange();
            int bytesPinned = 0;
            if (maxBytesToPin % PAGE_SIZE != 0) {
                maxBytesToPin -= maxBytesToPin % PAGE_SIZE;
            }
            while (bytesPinned < maxBytesToPin && pinRangeSource.read(pinRange)) {
                int pinStart = pinRange.start;
                int pinLength = pinRange.length;
                pinStart = PinnerService.clamp(0, pinStart, mapSize);
                pinLength = PinnerService.clamp(0, pinLength, mapSize - pinStart);
                pinLength = Math.min(maxBytesToPin - bytesPinned, pinLength);
                pinLength += pinStart % PAGE_SIZE;
                pinStart -= pinStart % PAGE_SIZE;
                if (pinLength % PAGE_SIZE != 0) {
                    pinLength += PAGE_SIZE - pinLength % PAGE_SIZE;
                }
                if ((pinLength = PinnerService.clamp(0, pinLength, maxBytesToPin - bytesPinned)) > 0) {
                    Os.mlock(address + (long)pinStart, pinLength);
                }
                bytesPinned += pinLength;
            }
            PinnedFile pinnedFile = new PinnedFile(address, mapSize, fileToPin, bytesPinned);
            address = -1L;
            PinnedFile pinnedFile2 = pinnedFile;
            return pinnedFile2;
        }
        catch (ErrnoException ex) {
            Slog.e(TAG, "Could not pin file " + fileToPin, ex);
            PinnedFile pinnedFile = null;
            return pinnedFile;
        }
        finally {
            PinnerService.safeClose(fd);
            if (address >= 0L) {
                PinnerService.safeMunmap(address, mapSize);
            }
        }
    }

    private static int clamp(int min, int value, int max) {
        return Math.max(min, Math.min(value, max));
    }

    private static void safeMunmap(long address, long mapSize) {
        try {
            Os.munmap(address, mapSize);
        }
        catch (ErrnoException ex) {
            Slog.w(TAG, "ignoring error in unmap", ex);
        }
    }

    private static void safeClose(FileDescriptor fd) {
        block3: {
            if (fd != null && fd.valid()) {
                try {
                    Os.close(fd);
                }
                catch (ErrnoException ex) {
                    if (ex.errno != OsConstants.EBADF) break block3;
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    private static void safeClose(Closeable thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (IOException ex) {
                Slog.w(TAG, "ignoring error closing resource: " + thing, ex);
            }
        }
    }

    final class PinnerHandler
    extends Handler {
        static final int PIN_ONSTART_MSG = 4001;

        public PinnerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4001: {
                    PinnerService.this.handlePinOnStart();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private final class PinnedApp {
        final int uid;
        boolean active;
        final ArrayList<PinnedFile> mFiles = new ArrayList();

        private PinnedApp(ApplicationInfo appInfo) {
            this.uid = appInfo.uid;
            this.active = PinnerService.this.mAmInternal.isUidActive(this.uid);
        }
    }

    static final class PinRange {
        int start;
        int length;

        PinRange() {
        }
    }

    private static final class PinnedFile
    implements AutoCloseable {
        private long mAddress;
        final int mapSize;
        final String fileName;
        final int bytesPinned;

        PinnedFile(long address, int mapSize, String fileName, int bytesPinned) {
            this.mAddress = address;
            this.mapSize = mapSize;
            this.fileName = fileName;
            this.bytesPinned = bytesPinned;
        }

        @Override
        public void close() {
            if (this.mAddress >= 0L) {
                PinnerService.safeMunmap(this.mAddress, this.mapSize);
                this.mAddress = -1L;
            }
        }

        public void finalize() {
            this.close();
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(PinnerService.this.mContext, PinnerService.TAG, pw)) {
                return;
            }
            PinnerService pinnerService = PinnerService.this;
            synchronized (pinnerService) {
                long totalSize = 0L;
                for (PinnedFile pinnedFile : PinnerService.this.mPinnedFiles) {
                    pw.format("%s %s\n", pinnedFile.fileName, pinnedFile.bytesPinned);
                    totalSize += (long)pinnedFile.bytesPinned;
                }
                pw.println();
                Iterator<Object> iterator = PinnerService.this.mPinnedApps.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    PinnedApp app = (PinnedApp)PinnerService.this.mPinnedApps.get(key);
                    pw.print(PinnerService.this.getNameForKey(key));
                    pw.print(" uid=");
                    pw.print(app.uid);
                    pw.print(" active=");
                    pw.print(app.active);
                    pw.println();
                    for (PinnedFile pf : ((PinnedApp)((PinnerService)PinnerService.this).mPinnedApps.get((Object)Integer.valueOf((int)key))).mFiles) {
                        pw.print("  ");
                        pw.format("%s %s\n", pf.fileName, pf.bytesPinned);
                        totalSize += (long)pf.bytesPinned;
                    }
                }
                pw.format("Total size: %s\n", totalSize);
                pw.println();
                if (!PinnerService.this.mPendingRepin.isEmpty()) {
                    pw.print("Pending repin: ");
                    iterator = PinnerService.this.mPendingRepin.values().iterator();
                    while (iterator.hasNext()) {
                        int key = (Integer)iterator.next();
                        pw.print(PinnerService.this.getNameForKey(key));
                        pw.print(' ');
                    }
                    pw.println();
                }
            }
        }
    }

    private static final class PinRangeSourceStream
    extends PinRangeSource {
        private final DataInputStream mStream;
        private boolean mDone = false;

        PinRangeSourceStream(InputStream stream) {
            this.mStream = new DataInputStream(stream);
        }

        @Override
        boolean read(PinRange outPinRange) {
            if (!this.mDone) {
                try {
                    outPinRange.start = this.mStream.readInt();
                    outPinRange.length = this.mStream.readInt();
                }
                catch (IOException ex) {
                    this.mDone = true;
                }
            }
            return !this.mDone;
        }
    }

    private static final class PinRangeSourceStatic
    extends PinRangeSource {
        private final int mPinStart;
        private final int mPinLength;
        private boolean mDone = false;

        PinRangeSourceStatic(int pinStart, int pinLength) {
            this.mPinStart = pinStart;
            this.mPinLength = pinLength;
        }

        @Override
        boolean read(PinRange outPinRange) {
            outPinRange.start = this.mPinStart;
            outPinRange.length = this.mPinLength;
            boolean done = this.mDone;
            this.mDone = true;
            return !done;
        }
    }

    private static abstract class PinRangeSource {
        private PinRangeSource() {
        }

        abstract boolean read(PinRange var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppKey {
    }
}

