/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.MemoryFile;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.util.Log;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import com.android.internal.util.DumpUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;

public class GraphicsStatsService
extends IGraphicsStats.Stub {
    public static final String GRAPHICS_STATS_SERVICE = "graphicsstats";
    private static final String TAG = "GraphicsStatsService";
    private static final int SAVE_BUFFER = 1;
    private static final int DELETE_OLD = 2;
    private final int ASHMEM_SIZE = GraphicsStatsService.nGetAshmemSize();
    private final byte[] ZERO_DATA = new byte[this.ASHMEM_SIZE];
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final AlarmManager mAlarmManager;
    private final Object mLock = new Object();
    private ArrayList<ActiveBuffer> mActive = new ArrayList();
    private File mGraphicsStatsDir;
    private final Object mFileAccessLock = new Object();
    private Handler mWriteOutHandler;
    private boolean mRotateIsScheduled = false;

    public GraphicsStatsService(Context context) {
        this.mContext = context;
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mAlarmManager = context.getSystemService(AlarmManager.class);
        File systemDataDir = new File(Environment.getDataDirectory(), "system");
        this.mGraphicsStatsDir = new File(systemDataDir, GRAPHICS_STATS_SERVICE);
        this.mGraphicsStatsDir.mkdirs();
        if (!this.mGraphicsStatsDir.exists()) {
            throw new IllegalStateException("Graphics stats directory does not exist: " + this.mGraphicsStatsDir.getAbsolutePath());
        }
        HandlerThread bgthread = new HandlerThread("GraphicsStats-disk", 10);
        bgthread.start();
        this.mWriteOutHandler = new Handler(bgthread.getLooper(), new Handler.Callback(){

            @Override
            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        GraphicsStatsService.this.saveBuffer((HistoricalBuffer)msg.obj);
                        break;
                    }
                    case 2: {
                        GraphicsStatsService.this.deleteOldBuffers();
                    }
                }
                return true;
            }
        });
    }

    private void scheduleRotateLocked() {
        if (this.mRotateIsScheduled) {
            return;
        }
        this.mRotateIsScheduled = true;
        Calendar calendar = this.normalizeDate(System.currentTimeMillis());
        calendar.add(5, 1);
        this.mAlarmManager.setExact(1, calendar.getTimeInMillis(), TAG, this::onAlarm, this.mWriteOutHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAlarm() {
        ActiveBuffer[] activeBufferArray = this.mLock;
        synchronized (this.mLock) {
            this.mRotateIsScheduled = false;
            this.scheduleRotateLocked();
            ActiveBuffer[] activeCopy = this.mActive.toArray(new ActiveBuffer[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ActiveBuffer active : activeCopy) {
                try {
                    active.mCallback.onRotateGraphicsStatsBuffer();
                }
                catch (RemoteException e) {
                    Log.w(TAG, String.format("Failed to notify '%s' (pid=%d) to rotate buffers", active.mInfo.packageName, active.mPid), e);
                }
            }
            this.mWriteOutHandler.sendEmptyMessageDelayed(2, 10000L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor requestBufferForProcess(String packageName, IGraphicsStatsCallback token) throws RemoteException {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        ParcelFileDescriptor pfd = null;
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            this.mAppOps.checkPackage(uid, packageName);
            PackageInfo info = this.mContext.getPackageManager().getPackageInfoAsUser(packageName, 0, UserHandle.getUserId(uid));
            Object object = this.mLock;
            synchronized (object) {
                pfd = this.requestBufferForProcessLocked(token, uid, pid, packageName, info.getLongVersionCode());
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new RemoteException("Unable to find package: '" + packageName + "'");
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return pfd;
    }

    private ParcelFileDescriptor getPfd(MemoryFile file) {
        try {
            if (!file.getFileDescriptor().valid()) {
                throw new IllegalStateException("Invalid file descriptor");
            }
            return new ParcelFileDescriptor(file.getFileDescriptor());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to get PFD from memory file", ex);
        }
    }

    private ParcelFileDescriptor requestBufferForProcessLocked(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException {
        ActiveBuffer buffer = this.fetchActiveBuffersLocked(token, uid, pid, packageName, versionCode);
        this.scheduleRotateLocked();
        return this.getPfd(buffer.mProcessBuffer);
    }

    private Calendar normalizeDate(long timestamp) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(timestamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private File pathForApp(BufferInfo info) {
        String subPath = String.format("%d/%s/%d/total", this.normalizeDate(info.startTime).getTimeInMillis(), info.packageName, info.versionCode);
        return new File(this.mGraphicsStatsDir, subPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(HistoricalBuffer buffer) {
        if (Trace.isTagEnabled(524288L)) {
            Trace.traceBegin(524288L, "saving graphicsstats for " + buffer.mInfo.packageName);
        }
        Object object = this.mFileAccessLock;
        synchronized (object) {
            File path = this.pathForApp(buffer.mInfo);
            File parent = path.getParentFile();
            parent.mkdirs();
            if (!parent.exists()) {
                Log.w(TAG, "Unable to create path: '" + parent.getAbsolutePath() + "'");
                return;
            }
            GraphicsStatsService.nSaveBuffer(path.getAbsolutePath(), buffer.mInfo.packageName, buffer.mInfo.versionCode, buffer.mInfo.startTime, buffer.mInfo.endTime, buffer.mData);
        }
        Trace.traceEnd(524288L);
    }

    private void deleteRecursiveLocked(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.deleteRecursiveLocked(child);
            }
        }
        if (!file.delete()) {
            Log.w(TAG, "Failed to delete '" + file.getAbsolutePath() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldBuffers() {
        Trace.traceBegin(524288L, "deleting old graphicsstats buffers");
        Object object = this.mFileAccessLock;
        synchronized (object) {
            int i;
            File[] files = this.mGraphicsStatsDir.listFiles();
            if (files == null || files.length <= 3) {
                return;
            }
            long[] sortedDates = new long[files.length];
            for (i = 0; i < files.length; ++i) {
                try {
                    sortedDates[i] = Long.parseLong(files[i].getName());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (sortedDates.length <= 3) {
                return;
            }
            Arrays.sort(sortedDates);
            for (i = 0; i < sortedDates.length - 3; ++i) {
                this.deleteRecursiveLocked(new File(this.mGraphicsStatsDir, Long.toString(sortedDates[i])));
            }
        }
        Trace.traceEnd(524288L);
    }

    private void addToSaveQueue(ActiveBuffer buffer) {
        try {
            HistoricalBuffer data = new HistoricalBuffer(buffer);
            Message.obtain(this.mWriteOutHandler, 1, data).sendToTarget();
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to copy graphicsstats from " + buffer.mInfo.packageName, e);
        }
        buffer.closeAllBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDied(ActiveBuffer buffer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActive.remove(buffer);
        }
        this.addToSaveQueue(buffer);
    }

    private ActiveBuffer fetchActiveBuffersLocked(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException {
        int size = this.mActive.size();
        long today = this.normalizeDate(System.currentTimeMillis()).getTimeInMillis();
        for (int i = 0; i < size; ++i) {
            ActiveBuffer buffer = this.mActive.get(i);
            if (buffer.mPid != pid || buffer.mUid != uid) continue;
            if (buffer.mInfo.startTime < today) {
                buffer.binderDied();
                break;
            }
            return buffer;
        }
        try {
            ActiveBuffer buffers = new ActiveBuffer(token, uid, pid, packageName, versionCode);
            this.mActive.add(buffers);
            return buffers;
        }
        catch (IOException ex) {
            throw new RemoteException("Failed to allocate space");
        }
    }

    private HashSet<File> dumpActiveLocked(long dump, ArrayList<HistoricalBuffer> buffers) {
        HashSet<File> skipFiles = new HashSet<File>(buffers.size());
        for (int i = 0; i < buffers.size(); ++i) {
            HistoricalBuffer buffer = buffers.get(i);
            File path = this.pathForApp(buffer.mInfo);
            skipFiles.add(path);
            GraphicsStatsService.nAddToDump(dump, path.getAbsolutePath(), buffer.mInfo.packageName, buffer.mInfo.versionCode, buffer.mInfo.startTime, buffer.mInfo.endTime, buffer.mData);
        }
        return skipFiles;
    }

    private void dumpHistoricalLocked(long dump, HashSet<File> skipFiles) {
        for (File date : this.mGraphicsStatsDir.listFiles()) {
            for (File pkg : date.listFiles()) {
                for (File version : pkg.listFiles()) {
                    File data = new File(version, "total");
                    if (skipFiles.contains(data)) continue;
                    GraphicsStatsService.nAddToDump(dump, data.getAbsolutePath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        ArrayList<HistoricalBuffer> buffers;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, fout)) {
            return;
        }
        boolean dumpProto = false;
        for (String str : args) {
            if (!"--proto".equals(str)) continue;
            dumpProto = true;
            break;
        }
        Object object = this.mLock;
        synchronized (object) {
            buffers = new ArrayList<HistoricalBuffer>(this.mActive.size());
            for (int i = 0; i < this.mActive.size(); ++i) {
                try {
                    buffers.add(new HistoricalBuffer(this.mActive.get(i)));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        long dump = GraphicsStatsService.nCreateDump(fd.getInt$(), dumpProto);
        try {
            Object object2 = this.mFileAccessLock;
            synchronized (object2) {
                HashSet<File> skipList = this.dumpActiveLocked(dump, buffers);
                buffers.clear();
                this.dumpHistoricalLocked(dump, skipList);
            }
        }
        finally {
            GraphicsStatsService.nFinishDump(dump);
        }
    }

    private static native int nGetAshmemSize();

    private static native long nCreateDump(int var0, boolean var1);

    private static native void nAddToDump(long var0, String var2, String var3, long var4, long var6, long var8, byte[] var10);

    private static native void nAddToDump(long var0, String var2);

    private static native void nFinishDump(long var0);

    private static native void nSaveBuffer(String var0, String var1, long var2, long var4, long var6, byte[] var8);

    private final class HistoricalBuffer {
        final BufferInfo mInfo;
        final byte[] mData;

        HistoricalBuffer(ActiveBuffer active) throws IOException {
            this.mData = new byte[GraphicsStatsService.this.ASHMEM_SIZE];
            this.mInfo = active.mInfo;
            this.mInfo.endTime = System.currentTimeMillis();
            active.mProcessBuffer.readBytes(this.mData, 0, 0, GraphicsStatsService.this.ASHMEM_SIZE);
        }
    }

    private final class ActiveBuffer
    implements IBinder.DeathRecipient {
        final BufferInfo mInfo;
        final int mUid;
        final int mPid;
        final IGraphicsStatsCallback mCallback;
        final IBinder mToken;
        MemoryFile mProcessBuffer;

        ActiveBuffer(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException, IOException {
            this.mInfo = new BufferInfo(packageName, versionCode, System.currentTimeMillis());
            this.mUid = uid;
            this.mPid = pid;
            this.mCallback = token;
            this.mToken = this.mCallback.asBinder();
            this.mToken.linkToDeath(this, 0);
            this.mProcessBuffer = new MemoryFile("GFXStats-" + pid, GraphicsStatsService.this.ASHMEM_SIZE);
            this.mProcessBuffer.writeBytes(GraphicsStatsService.this.ZERO_DATA, 0, 0, GraphicsStatsService.this.ASHMEM_SIZE);
        }

        @Override
        public void binderDied() {
            this.mToken.unlinkToDeath(this, 0);
            GraphicsStatsService.this.processDied(this);
        }

        void closeAllBuffers() {
            if (this.mProcessBuffer != null) {
                this.mProcessBuffer.close();
                this.mProcessBuffer = null;
            }
        }
    }

    private final class BufferInfo {
        final String packageName;
        final long versionCode;
        long startTime;
        long endTime;

        BufferInfo(String packageName, long versionCode, long startTime) {
            this.packageName = packageName;
            this.versionCode = versionCode;
            this.startTime = startTime;
        }
    }
}

