/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.BroadcastOptions;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.IIpConnectivityMetrics;
import android.net.INetdEventCallback;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.MatchAllNetworkSpecifier;
import android.net.Network;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.NetworkWatchlistManager;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.UidRange;
import android.net.Uri;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.NetworkEvent;
import android.net.util.MultinetworkPolicyTracker;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnInfo;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.WakeupMessage;
import com.android.internal.util.XmlUtils;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.DataConnectionStats;
import com.android.server.connectivity.DnsManager;
import com.android.server.connectivity.IpConnectivityMetrics;
import com.android.server.connectivity.KeepaliveTracker;
import com.android.server.connectivity.LingerMonitor;
import com.android.server.connectivity.MockableSystemProperties;
import com.android.server.connectivity.MultipathPolicyTracker;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.NetworkDiagnostics;
import com.android.server.connectivity.NetworkMonitor;
import com.android.server.connectivity.NetworkNotificationManager;
import com.android.server.connectivity.PacManager;
import com.android.server.connectivity.PermissionMonitor;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.android.server.connectivity.tethering.TetheringDependencies;
import com.android.server.net.BaseNetdEventCallback;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.LockdownVpnTracker;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.utils.PriorityDump;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConnectivityService
extends IConnectivityManager.Stub
implements PendingIntent.OnFinished {
    private static final String TAG = ConnectivityService.class.getSimpleName();
    public static final String DIAG_ARG = "--diag";
    public static final String SHORT_ARG = "--short";
    public static final String TETHERING_ARG = "tethering";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean LOGD_RULES = false;
    private static final boolean LOGD_BLOCKED_NETWORKINFO = true;
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int PROMPT_UNVALIDATED_DELAY_MS = 8000;
    private static final String LINGER_DELAY_PROPERTY = "persist.netmon.linger";
    private static final int DEFAULT_LINGER_DELAY_MS = 30000;
    @VisibleForTesting
    protected int mLingerDelayMs;
    private final int mReleasePendingIntentDelayMs;
    private MockableSystemProperties mSystemProperties;
    private Tethering mTethering;
    private final PermissionMonitor mPermissionMonitor;
    private KeyStore mKeyStore;
    @VisibleForTesting
    @GuardedBy(value="mVpns")
    protected final SparseArray<Vpn> mVpns = new SparseArray();
    @GuardedBy(value="mVpns")
    private boolean mLockdownEnabled;
    @GuardedBy(value="mVpns")
    private LockdownVpnTracker mLockdownTracker;
    private final Context mContext;
    private int mNetworkPreference;
    private int mDefaultInetConditionPublished = 0;
    private boolean mTestMode;
    private static ConnectivityService sServiceInstance;
    private INetworkManagementService mNetd;
    private INetworkStatsService mStatsService;
    private INetworkPolicyManager mPolicyManager;
    private NetworkPolicyManagerInternal mPolicyManagerInternal;
    private IIpConnectivityMetrics mIpConnectivityMetrics;
    private String mCurrentTcpBufferSizes;
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    private static final SparseArray<String> sMagicDecoderRing;
    private static final int EVENT_CHANGE_MOBILE_DATA_ENABLED = 2;
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 8;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 9;
    private static final int EVENT_PROXY_HAS_CHANGED = 16;
    private static final int EVENT_REGISTER_NETWORK_FACTORY = 17;
    private static final int EVENT_REGISTER_NETWORK_AGENT = 18;
    private static final int EVENT_REGISTER_NETWORK_REQUEST = 19;
    private static final int EVENT_TIMEOUT_NETWORK_REQUEST = 20;
    private static final int EVENT_REGISTER_NETWORK_LISTENER = 21;
    private static final int EVENT_RELEASE_NETWORK_REQUEST = 22;
    private static final int EVENT_UNREGISTER_NETWORK_FACTORY = 23;
    private static final int EVENT_EXPIRE_NET_TRANSITION_WAKELOCK = 24;
    private static final int EVENT_SYSTEM_READY = 25;
    private static final int EVENT_REGISTER_NETWORK_REQUEST_WITH_INTENT = 26;
    private static final int EVENT_RELEASE_NETWORK_REQUEST_WITH_INTENT = 27;
    private static final int EVENT_SET_ACCEPT_UNVALIDATED = 28;
    private static final int EVENT_PROMPT_UNVALIDATED = 29;
    private static final int EVENT_CONFIGURE_MOBILE_DATA_ALWAYS_ON = 30;
    private static final int EVENT_REGISTER_NETWORK_LISTENER_WITH_INTENT = 31;
    private static final int EVENT_SET_AVOID_UNVALIDATED = 35;
    private static final int EVENT_REVALIDATE_NETWORK = 36;
    private static final int EVENT_PRIVATE_DNS_SETTINGS_CHANGED = 37;
    private static final int EVENT_PRIVATE_DNS_VALIDATION_UPDATE = 38;
    @VisibleForTesting
    protected final HandlerThread mHandlerThread;
    private final InternalHandler mHandler;
    private final NetworkStateTrackerHandler mTrackerHandler;
    private final DnsManager mDnsManager;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private int mNetTransitionWakeLockTimeout;
    private final PowerManager.WakeLock mPendingIntentWakeLock;
    private volatile ProxyInfo mDefaultProxy = null;
    private Object mProxyLock = new Object();
    private boolean mDefaultProxyDisabled = false;
    private ProxyInfo mGlobalProxy = null;
    private PacManager mPacManager = null;
    private final SettingsObserver mSettingsObserver;
    private UserManager mUserManager;
    NetworkConfig[] mNetConfigs;
    int mNetworksDefined;
    List mProtectedNetworks;
    private DataConnectionStats mDataConnectionStats;
    TelephonyManager mTelephonyManager;
    private KeepaliveTracker mKeepaliveTracker;
    private NetworkNotificationManager mNotifier;
    private LingerMonitor mLingerMonitor;
    private static final int MIN_NET_ID = 100;
    private static final int MAX_NET_ID = 64511;
    private int mNextNetId = 100;
    private int mNextNetworkRequestId = 1;
    private static final int MAX_NETWORK_REQUEST_LOGS = 20;
    private final LocalLog mNetworkRequestInfoLogs = new LocalLog(20);
    private static final int MAX_NETWORK_INFO_LOGS = 40;
    private final LocalLog mNetworkInfoBlockingLogs = new LocalLog(40);
    private static final int MAX_WAKELOCK_LOGS = 20;
    private final LocalLog mWakelockLogs = new LocalLog(20);
    private int mTotalWakelockAcquisitions = 0;
    private int mTotalWakelockReleases = 0;
    private long mTotalWakelockDurationMs = 0L;
    private long mMaxWakelockDurationMs = 0L;
    private long mLastWakeLockAcquireTimestamp = 0L;
    private static final int MAX_VALIDATION_LOGS = 10;
    private final ArrayDeque<ValidationLog> mValidationLogs = new ArrayDeque(10);
    private final IpConnectivityLog mMetricsLog;
    @VisibleForTesting
    final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    @VisibleForTesting
    final MultipathPolicyTracker mMultipathPolicyTracker;
    private LegacyTypeTracker mLegacyTypeTracker = new LegacyTypeTracker();
    private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

        @Override
        public void dumpHigh(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, new String[]{ConnectivityService.DIAG_ARG}, asProto);
            ConnectivityService.this.doDump(fd, pw, new String[]{ConnectivityService.SHORT_ARG}, asProto);
        }

        @Override
        public void dumpNormal(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, args, asProto);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, args, asProto);
        }
    };
    private INetworkManagementEventObserver mDataActivityObserver = new BaseNetworkObserver(){

        @Override
        public void interfaceClassDataActivityChanged(String label, boolean active, long tsNanos) {
            int deviceType = Integer.parseInt(label);
            ConnectivityService.this.sendDataActivityBroadcast(deviceType, active, tsNanos);
        }
    };
    @VisibleForTesting
    protected final INetdEventCallback mNetdEventCallback = new BaseNetdEventCallback(){

        @Override
        public void onPrivateDnsValidationEvent(int netId, String ipAddress, String hostname, boolean validated) {
            try {
                ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(38, new DnsManager.PrivateDnsValidationUpdate(netId, InetAddress.parseNumericAddress((String)ipAddress), hostname, validated)));
            }
            catch (IllegalArgumentException e) {
                ConnectivityService.loge("Error parsing ip address in validation event");
            }
        }
    };
    private final INetworkPolicyListener mPolicyListener = new NetworkPolicyManager.Listener(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            if (restrictBackground) {
                ConnectivityService.log("onRestrictBackgroundChanged(true): disabling tethering");
                ConnectivityService.this.mTethering.untetherAll();
            }
        }
    };
    private static final String DEFAULT_TCP_BUFFER_SIZES = "4096,87380,110208,4096,16384,110208";
    private static final String DEFAULT_TCP_RWND_KEY = "net.tcp.default_init_rwnd";
    private static final String PROVISIONING_URL_PATH = "/data/misc/radio/provisioning_urls.xml";
    private final File mProvisioningUrlFile = new File("/data/misc/radio/provisioning_urls.xml");
    private static final String TAG_PROVISIONING_URLS = "provisioningUrls";
    private static final String TAG_PROVISIONING_URL = "provisioningUrl";
    private static final String ATTR_MCC = "mcc";
    private static final String ATTR_MNC = "mnc";
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_STARTED".equals(action)) {
                ConnectivityService.this.onUserStart(userId);
            } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                ConnectivityService.this.onUserStop(userId);
            } else if ("android.intent.action.USER_ADDED".equals(action)) {
                ConnectivityService.this.onUserAdded(userId);
            } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                ConnectivityService.this.onUserRemoved(userId);
            } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                ConnectivityService.this.onUserUnlocked(userId);
            }
        }
    };
    private BroadcastReceiver mUserPresentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            ConnectivityService.this.updateLockdownVpn();
            ConnectivityService.this.mContext.unregisterReceiver(this);
        }
    };
    private final HashMap<Messenger, NetworkFactoryInfo> mNetworkFactoryInfos = new HashMap();
    private final HashMap<NetworkRequest, NetworkRequestInfo> mNetworkRequests = new HashMap();
    private static final int MAX_NETWORK_REQUESTS_PER_UID = 100;
    @GuardedBy(value="mUidToNetworkRequestCount")
    private final SparseIntArray mUidToNetworkRequestCount = new SparseIntArray();
    @GuardedBy(value="mNetworkForRequestId")
    private final SparseArray<NetworkAgentInfo> mNetworkForRequestId = new SparseArray();
    @GuardedBy(value="mNetworkForNetId")
    private final SparseArray<NetworkAgentInfo> mNetworkForNetId = new SparseArray();
    @GuardedBy(value="mNetworkForNetId")
    private final SparseBooleanArray mNetIdInUse = new SparseBooleanArray();
    private final HashMap<Messenger, NetworkAgentInfo> mNetworkAgentInfos = new HashMap();
    @GuardedBy(value="mBlockedAppUids")
    private final HashSet<Integer> mBlockedAppUids = new HashSet();
    private final NetworkRequest mDefaultRequest;
    private final NetworkRequest mDefaultMobileDataRequest;

    private static String eventName(int what) {
        return sMagicDecoderRing.get(what, Integer.toString(what));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidationLogs(LocalLog.ReadOnlyLocalLog log, Network network, String name) {
        ArrayDeque<ValidationLog> arrayDeque = this.mValidationLogs;
        synchronized (arrayDeque) {
            while (this.mValidationLogs.size() >= 10) {
                this.mValidationLogs.removeLast();
            }
            this.mValidationLogs.addFirst(new ValidationLog(network, name, log));
        }
    }

    public ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        this(context, netManager, statsService, policyManager, new IpConnectivityLog());
    }

    @VisibleForTesting
    protected ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager, IpConnectivityLog logger) {
        int[] protectedNetworks;
        String[] naStrings;
        ConnectivityService.log("ConnectivityService starting up");
        this.mSystemProperties = this.getSystemProperties();
        this.mMetricsLog = logger;
        this.mDefaultRequest = this.createDefaultInternetRequestForTransport(-1, NetworkRequest.Type.REQUEST);
        NetworkRequestInfo defaultNRI = new NetworkRequestInfo(null, this.mDefaultRequest, new Binder());
        this.mNetworkRequests.put(this.mDefaultRequest, defaultNRI);
        this.mNetworkRequestInfoLogs.log("REGISTER " + defaultNRI);
        this.mDefaultMobileDataRequest = this.createDefaultInternetRequestForTransport(0, NetworkRequest.Type.BACKGROUND_REQUEST);
        this.mHandlerThread = new HandlerThread("ConnectivityServiceThread");
        this.mHandlerThread.start();
        this.mHandler = new InternalHandler(this.mHandlerThread.getLooper());
        this.mTrackerHandler = new NetworkStateTrackerHandler(this.mHandlerThread.getLooper());
        this.mReleasePendingIntentDelayMs = Settings.Secure.getInt(context.getContentResolver(), "connectivity_release_pending_intent_delay_ms", 5000);
        this.mLingerDelayMs = this.mSystemProperties.getInt(LINGER_DELAY_PROPERTY, 30000);
        this.mContext = Preconditions.checkNotNull(context, "missing Context");
        this.mNetd = Preconditions.checkNotNull(netManager, "missing INetworkManagementService");
        this.mStatsService = Preconditions.checkNotNull(statsService, "missing INetworkStatsService");
        this.mPolicyManager = Preconditions.checkNotNull(policyManager, "missing INetworkPolicyManager");
        this.mPolicyManagerInternal = Preconditions.checkNotNull(LocalServices.getService(NetworkPolicyManagerInternal.class), "missing NetworkPolicyManagerInternal");
        this.mKeyStore = KeyStore.getInstance();
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("unable to register INetworkPolicyListener" + e);
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694830);
        this.mPendingIntentWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetConfigs = new NetworkConfig[18];
        boolean wifiOnly = this.mSystemProperties.getBoolean("ro.radio.noril", false);
        ConnectivityService.log("wifiOnly=" + wifiOnly);
        for (String naString : naStrings = context.getResources().getStringArray(17236065)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (n.type > 17) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (wifiOnly && ConnectivityManager.isNetworkTypeMobile(n.type)) {
                    ConnectivityService.log("networkAttributes - ignoring mobile as this dev is wifiOnly " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                this.mLegacyTypeTracker.addSupportedType(n.type);
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception n) {
                // empty catch block
            }
        }
        if (this.mNetConfigs[17] == null) {
            this.mLegacyTypeTracker.addSupportedType(17);
            ++this.mNetworksDefined;
        }
        if (this.mNetConfigs[9] == null && this.hasService("ethernet")) {
            this.mLegacyTypeTracker.addSupportedType(9);
            ++this.mNetworksDefined;
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17236030)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            ConnectivityService.loge("Ignoring protectedNetwork " + p);
        }
        this.mTestMode = this.mSystemProperties.get("cm.test.mode").equals("true") && this.mSystemProperties.get("ro.build.type").equals("eng");
        this.mTethering = this.makeTethering();
        this.mPermissionMonitor = new PermissionMonitor(this.mContext, this.mNetd);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_STARTED");
        intentFilter.addAction("android.intent.action.USER_STOPPED");
        intentFilter.addAction("android.intent.action.USER_ADDED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        this.mContext.registerReceiverAsUser(this.mUserPresentReceiver, UserHandle.SYSTEM, new IntentFilter("android.intent.action.USER_PRESENT"), null, null);
        try {
            this.mNetd.registerObserver(this.mTethering);
            this.mNetd.registerObserver(this.mDataActivityObserver);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("Error registering observer :" + e);
        }
        this.mSettingsObserver = new SettingsObserver(this.mContext, this.mHandler);
        this.registerSettingsCallbacks();
        this.mDataConnectionStats = new DataConnectionStats(this.mContext);
        this.mDataConnectionStats.startMonitoring();
        this.mPacManager = new PacManager(this.mContext, this.mHandler, 16);
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mKeepaliveTracker = new KeepaliveTracker(this.mHandler);
        this.mNotifier = new NetworkNotificationManager(this.mContext, this.mTelephonyManager, this.mContext.getSystemService(NotificationManager.class));
        int dailyLimit = Settings.Global.getInt(this.mContext.getContentResolver(), "network_switch_notification_daily_limit", 3);
        long rateLimit = Settings.Global.getLong(this.mContext.getContentResolver(), "network_switch_notification_rate_limit_millis", 60000L);
        this.mLingerMonitor = new LingerMonitor(this.mContext, this.mNotifier, dailyLimit, rateLimit);
        this.mMultinetworkPolicyTracker = this.createMultinetworkPolicyTracker(this.mContext, this.mHandler, () -> this.rematchForAvoidBadWifiUpdate());
        this.mMultinetworkPolicyTracker.start();
        this.mMultipathPolicyTracker = new MultipathPolicyTracker(this.mContext, this.mHandler);
        this.mDnsManager = new DnsManager(this.mContext, this.mNetd, this.mSystemProperties);
        this.registerPrivateDnsSettingsCallbacks();
    }

    private Tethering makeTethering() {
        TetheringDependencies deps = new TetheringDependencies(){

            @Override
            public boolean isTetheringSupported() {
                return ConnectivityService.this.isTetheringSupported();
            }

            @Override
            public NetworkRequest getDefaultNetworkRequest() {
                return ConnectivityService.this.mDefaultRequest;
            }
        };
        return new Tethering(this.mContext, this.mNetd, this.mStatsService, this.mPolicyManager, IoThread.get().getLooper(), new MockableSystemProperties(), deps);
    }

    private static NetworkCapabilities createDefaultNetworkCapabilitiesForUid(int uid) {
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        netCap.removeCapability(15);
        netCap.setSingleUid(uid);
        return netCap;
    }

    private NetworkRequest createDefaultInternetRequestForTransport(int transportType, NetworkRequest.Type type) {
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        if (transportType > -1) {
            netCap.addTransportType(transportType);
        }
        return new NetworkRequest(netCap, -1, this.nextNetworkRequestId(), type);
    }

    @VisibleForTesting
    void updateMobileDataAlwaysOn() {
        this.mHandler.sendEmptyMessage(30);
    }

    @VisibleForTesting
    void updatePrivateDnsSettings() {
        this.mHandler.sendEmptyMessage(37);
    }

    private void handleMobileDataAlwaysOn() {
        boolean isEnabled;
        boolean enable = ConnectivityService.toBool(Settings.Global.getInt(this.mContext.getContentResolver(), "mobile_data_always_on", 1));
        boolean bl = isEnabled = this.mNetworkRequests.get(this.mDefaultMobileDataRequest) != null;
        if (enable == isEnabled) {
            return;
        }
        if (enable) {
            this.handleRegisterNetworkRequest(new NetworkRequestInfo(null, this.mDefaultMobileDataRequest, new Binder()));
        } else {
            this.handleReleaseNetworkRequest(this.mDefaultMobileDataRequest, 1000);
        }
    }

    private void registerSettingsCallbacks() {
        this.mSettingsObserver.observe(Settings.Global.getUriFor("http_proxy"), 9);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("mobile_data_always_on"), 30);
    }

    private void registerPrivateDnsSettingsCallbacks() {
        for (Uri uri : DnsManager.getPrivateDnsSettingsUris()) {
            this.mSettingsObserver.observe(uri, 37);
        }
    }

    private synchronized int nextNetworkRequestId() {
        return this.mNextNetworkRequestId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected int reserveNetId() {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 100; i <= 64511; ++i) {
                int netId = this.mNextNetId++;
                if (this.mNextNetId > 64511) {
                    this.mNextNetId = 100;
                }
                if (this.mNetIdInUse.get(netId)) continue;
                this.mNetIdInUse.put(netId, true);
                return netId;
            }
        }
        throw new IllegalStateException("No free netIds");
    }

    private NetworkState getFilteredNetworkState(int networkType, int uid, boolean ignoreBlocked) {
        if (this.mLegacyTypeTracker.isTypeSupported(networkType)) {
            NetworkState state;
            NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
            if (nai != null) {
                state = nai.getNetworkState();
                state.networkInfo.setType(networkType);
            } else {
                NetworkInfo info = new NetworkInfo(networkType, 0, ConnectivityManager.getNetworkTypeName(networkType), "");
                info.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                info.setIsAvailable(true);
                NetworkCapabilities capabilities = new NetworkCapabilities();
                capabilities.setCapability(18, !info.isRoaming());
                state = new NetworkState(info, new LinkProperties(), capabilities, null, null, null);
            }
            this.filterNetworkStateForUid(state, uid, ignoreBlocked);
            return state;
        }
        return NetworkState.EMPTY;
    }

    private NetworkAgentInfo getNetworkAgentInfoForNetwork(Network network) {
        if (network == null) {
            return null;
        }
        return this.getNetworkAgentInfoForNetId(network.netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkAgentInfo getNetworkAgentInfoForNetId(int netId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            return this.mNetworkForNetId.get(netId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network[] getVpnUnderlyingNetworks(int uid) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int user;
            Vpn vpn;
            if (!this.mLockdownEnabled && (vpn = this.mVpns.get(user = UserHandle.getUserId(uid))) != null && vpn.appliesToUid(uid)) {
                return vpn.getUnderlyingNetworks();
            }
            return null;
        }
    }

    private NetworkState getUnfilteredActiveNetworkState(int uid) {
        NetworkAgentInfo nai = this.getDefaultNetwork();
        Network[] networks = this.getVpnUnderlyingNetworks(uid);
        if (networks != null) {
            nai = networks.length > 0 ? this.getNetworkAgentInfoForNetwork(networks[0]) : null;
        }
        if (nai != null) {
            return nai.getNetworkState();
        }
        return NetworkState.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkWithLinkPropertiesBlocked(LinkProperties lp, int uid, boolean ignoreBlocked) {
        String iface;
        if (ignoreBlocked) {
            return false;
        }
        if (this.isSystem(uid)) {
            return false;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(UserHandle.getUserId(uid));
            if (vpn != null && vpn.isBlockingUid(uid)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
            iface = lp == null ? "" : lp.getInterfaceName();
        }
        return this.mPolicyManagerInternal.isUidNetworkingBlocked(uid, iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogBlockedNetworkInfo(NetworkInfo ni, int uid) {
        String action;
        if (ni == null) {
            return;
        }
        HashSet<Integer> hashSet = this.mBlockedAppUids;
        synchronized (hashSet) {
            boolean blocked;
            if (ni.getDetailedState() == NetworkInfo.DetailedState.BLOCKED && this.mBlockedAppUids.add(uid)) {
                blocked = true;
            } else if (ni.isConnected() && this.mBlockedAppUids.remove(uid)) {
                blocked = false;
            } else {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var4_3
            action = blocked ? "BLOCKED" : "UNBLOCKED";
        }
        ConnectivityService.log(String.format("Returning %s NetworkInfo to uid=%d", action, uid));
        this.mNetworkInfoBlockingLogs.log(action + " " + uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterNetworkStateForUid(NetworkState state, int uid, boolean ignoreBlocked) {
        if (state == null || state.networkInfo == null || state.linkProperties == null) {
            return;
        }
        if (this.isNetworkWithLinkPropertiesBlocked(state.linkProperties, uid, ignoreBlocked)) {
            state.networkInfo.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                this.mLockdownTracker.augmentNetworkInfo(state.networkInfo);
            }
        }
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        this.filterNetworkStateForUid(state, uid, false);
        this.maybeLogBlockedNetworkInfo(state.networkInfo, uid);
        return state.networkInfo;
    }

    @Override
    public Network getActiveNetwork() {
        this.enforceAccessPermission();
        return this.getActiveNetworkForUidInternal(Binder.getCallingUid(), false);
    }

    @Override
    public Network getActiveNetworkForUid(int uid, boolean ignoreBlocked) {
        this.enforceConnectivityInternalPermission();
        return this.getActiveNetworkForUidInternal(uid, ignoreBlocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network getActiveNetworkForUidInternal(int uid, boolean ignoreBlocked) {
        NetworkCapabilities requiredCaps;
        NetworkAgentInfo nai;
        int user = UserHandle.getUserId(uid);
        int vpnNetId = 0;
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(user);
            if (vpn != null && vpn.appliesToUid(uid)) {
                vpnNetId = vpn.getNetId();
            }
        }
        if (vpnNetId != 0 && (nai = this.getNetworkAgentInfoForNetId(vpnNetId)) != null && (requiredCaps = ConnectivityService.createDefaultNetworkCapabilitiesForUid(uid)).satisfiedByNetworkCapabilities(nai.networkCapabilities)) {
            return nai.network;
        }
        nai = this.getDefaultNetwork();
        if (nai != null && this.isNetworkWithLinkPropertiesBlocked(nai.linkProperties, uid, ignoreBlocked)) {
            nai = null;
        }
        return nai != null ? nai.network : null;
    }

    public NetworkInfo getActiveNetworkInfoUnfiltered() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getActiveNetworkInfoForUid(int uid, boolean ignoreBlocked) {
        this.enforceConnectivityInternalPermission();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        this.filterNetworkStateForUid(state, uid, ignoreBlocked);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getNetworkInfo(int networkType) {
        NetworkState state;
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        if (this.getVpnUnderlyingNetworks(uid) != null) {
            state = this.getUnfilteredActiveNetworkState(uid);
            if (state.networkInfo != null && state.networkInfo.getType() == networkType) {
                this.filterNetworkStateForUid(state, uid, false);
                return state.networkInfo;
            }
        }
        state = this.getFilteredNetworkState(networkType, uid, false);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getNetworkInfoForUid(Network network, int uid, boolean ignoreBlocked) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null) {
            NetworkState state = nai.getNetworkState();
            this.filterNetworkStateForUid(state, uid, ignoreBlocked);
            return state.networkInfo;
        }
        return null;
    }

    @Override
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        ArrayList<NetworkInfo> result = Lists.newArrayList();
        for (int networkType = 0; networkType <= 17; ++networkType) {
            NetworkInfo info = this.getNetworkInfo(networkType);
            if (info == null) continue;
            result.add(info);
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    @Override
    public Network getNetworkForType(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getFilteredNetworkState(networkType, uid, false);
        if (!this.isNetworkWithLinkPropertiesBlocked(state.linkProperties, uid, false)) {
            return state.network;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network[] getAllNetworks() {
        this.enforceAccessPermission();
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            Network[] result = new Network[this.mNetworkForNetId.size()];
            for (int i = 0; i < this.mNetworkForNetId.size(); ++i) {
                result[i] = this.mNetworkForNetId.valueAt((int)i).network;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId) {
        this.enforceAccessPermission();
        HashMap<Network, NetworkCapabilities> result = new HashMap<Network, NetworkCapabilities>();
        NetworkAgentInfo nai = this.getDefaultNetwork();
        NetworkCapabilities nc = this.getNetworkCapabilitiesInternal(nai);
        if (nc != null) {
            result.put(nai.network, nc);
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Network[] networks;
            Vpn vpn;
            if (!this.mLockdownEnabled && (vpn = this.mVpns.get(userId)) != null && (networks = vpn.getUnderlyingNetworks()) != null) {
                for (Network network : networks) {
                    nai = this.getNetworkAgentInfoForNetwork(network);
                    nc = this.getNetworkCapabilitiesInternal(nai);
                    if (nc == null) continue;
                    result.put(network, nc);
                }
            }
        }
        NetworkCapabilities[] out = new NetworkCapabilities[result.size()];
        out = result.values().toArray(out);
        return out;
    }

    @Override
    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return this.mLegacyTypeTracker.isTypeSupported(networkType);
    }

    @Override
    public LinkProperties getActiveLinkProperties() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.linkProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkProperties getLinkPropertiesForType(int networkType) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return null;
    }

    @Override
    public LinkProperties getLinkProperties(Network network) {
        this.enforceAccessPermission();
        return this.getLinkProperties(this.getNetworkAgentInfoForNetwork(network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkProperties getLinkProperties(NetworkAgentInfo nai) {
        if (nai == null) {
            return null;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            return new LinkProperties(nai.linkProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkCapabilities getNetworkCapabilitiesInternal(NetworkAgentInfo nai) {
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                if (nai.networkCapabilities != null) {
                    return this.networkCapabilitiesRestrictedForCallerPermissions(nai.networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
                }
            }
        }
        return null;
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(Network network) {
        this.enforceAccessPermission();
        return this.getNetworkCapabilitiesInternal(this.getNetworkAgentInfoForNetwork(network));
    }

    private NetworkCapabilities networkCapabilitiesRestrictedForCallerPermissions(NetworkCapabilities nc, int callerPid, int callerUid) {
        NetworkCapabilities newNc = new NetworkCapabilities(nc);
        if (!this.checkSettingsPermission(callerPid, callerUid)) {
            newNc.setUids(null);
            newNc.setSSID(null);
        }
        return newNc;
    }

    private void restrictRequestUidsForCaller(NetworkCapabilities nc) {
        if (!this.checkSettingsPermission()) {
            nc.setSingleUid(Binder.getCallingUid());
        }
    }

    private void restrictBackgroundRequestForCaller(NetworkCapabilities nc) {
        if (!this.mPermissionMonitor.hasUseBackgroundNetworksPermission(Binder.getCallingUid())) {
            nc.addCapability(19);
        }
    }

    @Override
    public NetworkState[] getAllNetworkState() {
        this.enforceConnectivityInternalPermission();
        ArrayList<NetworkState> result = Lists.newArrayList();
        for (Network network : this.getAllNetworks()) {
            NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
            if (nai == null) continue;
            result.add(nai.getNetworkState());
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    @Override
    @Deprecated
    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        Log.w(TAG, "Shame on UID " + Binder.getCallingUid() + " for calling the hidden API getNetworkQuotaInfo(). Shame!");
        return new NetworkQuotaInfo();
    }

    @Override
    public boolean isActiveNetworkMetered() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkCapabilities caps = this.getUnfilteredActiveNetworkState((int)uid).networkCapabilities;
        if (caps != null) {
            return !caps.hasCapability(11);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        NetworkInfo.DetailedState netState;
        InetAddress addr;
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        try {
            addr = InetAddress.getByAddress(hostAddress);
        }
        catch (UnknownHostException e) {
            ConnectivityService.log("requestRouteToHostAddress got " + e.toString());
            return false;
        }
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("requestRouteToHostAddress on invalid network: " + networkType);
            return false;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            if (!this.mLegacyTypeTracker.isTypeSupported(networkType)) {
                ConnectivityService.log("requestRouteToHostAddress on unsupported network: " + networkType);
            } else {
                ConnectivityService.log("requestRouteToHostAddress on down network: " + networkType);
            }
            return false;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            netState = nai.networkInfo.getDetailedState();
        }
        if (netState != NetworkInfo.DetailedState.CONNECTED && netState != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
            return false;
        }
        int uid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            int netId;
            LinkProperties lp;
            NetworkAgentInfo networkAgentInfo2 = nai;
            synchronized (networkAgentInfo2) {
                lp = nai.linkProperties;
                netId = nai.network.netId;
            }
            boolean ok = this.addLegacyRouteToHost(lp, addr, netId, uid);
            ConnectivityService.log("requestRouteToHostAddress ok=" + ok);
            boolean bl = ok;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean addLegacyRouteToHost(LinkProperties lp, InetAddress addr, int netId, int uid) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), addr);
        if (bestRoute == null) {
            bestRoute = RouteInfo.makeHostRoute(addr, lp.getInterfaceName());
        } else {
            String iface = bestRoute.getInterface();
            bestRoute = bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute(addr, iface) : RouteInfo.makeHostRoute(addr, bestRoute.getGateway(), iface);
        }
        ConnectivityService.log("Adding legacy route " + bestRoute + " for UID/PID " + uid + "/" + Binder.getCallingPid());
        try {
            this.mNetd.addLegacyRouteForNetId(netId, bestRoute, uid);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception trying to add a route: " + e);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected void registerNetdEventCallback() {
        this.mIpConnectivityMetrics = IIpConnectivityMetrics.Stub.asInterface(ServiceManager.getService("connmetrics"));
        if (this.mIpConnectivityMetrics == null) {
            Slog.wtf(TAG, "Missing IIpConnectivityMetrics");
        }
        try {
            this.mIpConnectivityMetrics.addNetdEventCallback(0, this.mNetdEventCallback);
        }
        catch (Exception e) {
            ConnectivityService.loge("Error registering netd callback: " + e);
        }
    }

    private void enforceCrossUserPermission(int userId) {
        if (userId == UserHandle.getCallingUserId()) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "ConnectivityService");
    }

    private void enforceInternetPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", "ConnectivityService");
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", "ConnectivityService");
    }

    private void enforceChangePermission() {
        ConnectivityManager.enforceChangePermission(this.mContext);
    }

    private void enforceSettingsPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_SETTINGS", "ConnectivityService");
    }

    private boolean checkSettingsPermission() {
        return 0 == this.mContext.checkCallingOrSelfPermission("android.permission.NETWORK_SETTINGS");
    }

    private boolean checkSettingsPermission(int pid, int uid) {
        return 0 == this.mContext.checkPermission("android.permission.NETWORK_SETTINGS", pid, uid);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", "ConnectivityService");
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "ConnectivityService");
    }

    private void enforceConnectivityRestrictedNetworksPermission() {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_USE_RESTRICTED_NETWORKS", "ConnectivityService");
            return;
        }
        catch (SecurityException securityException) {
            this.enforceConnectivityInternalPermission();
            return;
        }
    }

    private void enforceKeepalivePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKET_KEEPALIVE_OFFLOAD", "ConnectivityService");
    }

    public void sendConnectedBroadcast(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                info = new NetworkInfo(info);
                this.mLockdownTracker.augmentNetworkInfo(info);
            }
        }
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataActivityBroadcast(int deviceType, boolean active, long tsNanos) {
        Intent intent = new Intent("android.net.conn.DATA_ACTIVITY_CHANGE");
        intent.putExtra("deviceType", deviceType);
        intent.putExtra("isActive", active);
        intent.putExtra("tsNanos", tsNanos);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, "android.permission.RECEIVE_DATA_ACTIVITY_CHANGE", null, null, 0, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x4000000);
            Bundle options = null;
            long ident = Binder.clearCallingIdentity();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                NetworkInfo ni = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                if (ni.getType() == 3) {
                    intent.setAction("android.net.conn.CONNECTIVITY_CHANGE_SUPL");
                    intent.addFlags(0x40000000);
                } else {
                    BroadcastOptions opts = BroadcastOptions.makeBasic();
                    opts.setMaxManifestReceiverApiLevel(23);
                    options = opts.toBundle();
                }
                IBatteryStats bs = BatteryStatsService.getService();
                try {
                    bs.noteConnectivityChanged(intent.getIntExtra("networkType", -1), ni != null ? ni.getState().toString() : "?");
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                intent.addFlags(0x200000);
            }
            try {
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL, options);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.loadGlobalProxy();
        this.registerNetdEventCallback();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcastAsUser(this.mInitialBroadcast, UserHandle.ALL);
                this.mInitialBroadcast = null;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(9));
        this.updateLockdownVpn();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(30));
        this.mHandler.sendMessage(this.mHandler.obtainMessage(25));
        this.mPermissionMonitor.startMonitoring();
    }

    private void setupDataActivityTracking(NetworkAgentInfo networkAgent) {
        int timeout;
        String iface = networkAgent.linkProperties.getInterfaceName();
        int type = -1;
        if (networkAgent.networkCapabilities.hasTransport(0)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_mobile", 10);
            type = 0;
        } else if (networkAgent.networkCapabilities.hasTransport(1)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_wifi", 15);
            type = 1;
        } else {
            timeout = 0;
        }
        if (timeout > 0 && iface != null && type != -1) {
            try {
                this.mNetd.addIdleTimer(iface, timeout, type);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setupDataActivityTracking " + e);
            }
        }
    }

    private void removeDataActivityTracking(NetworkAgentInfo networkAgent) {
        String iface = networkAgent.linkProperties.getInterfaceName();
        NetworkCapabilities caps = networkAgent.networkCapabilities;
        if (iface != null && (caps.hasTransport(0) || caps.hasTransport(1))) {
            try {
                this.mNetd.removeIdleTimer(iface);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeDataActivityTracking " + e);
            }
        }
    }

    private void updateMtu(LinkProperties newLp, LinkProperties oldLp) {
        String iface = newLp.getInterfaceName();
        int mtu = newLp.getMtu();
        if (oldLp == null && mtu == 0) {
            return;
        }
        if (oldLp != null && newLp.isIdenticalMtu(oldLp)) {
            return;
        }
        if (!LinkProperties.isValidMtu(mtu, newLp.hasGlobalIPv6Address())) {
            if (mtu != 0) {
                ConnectivityService.loge("Unexpected mtu value: " + mtu + ", " + iface);
            }
            return;
        }
        if (TextUtils.isEmpty(iface)) {
            ConnectivityService.loge("Setting MTU size with null iface.");
            return;
        }
        try {
            this.mNetd.setMtu(iface, mtu);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception in setMtu()" + e);
        }
    }

    @VisibleForTesting
    protected MockableSystemProperties getSystemProperties() {
        return new MockableSystemProperties();
    }

    private void updateTcpBufferSizes(NetworkAgentInfo nai) {
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        String tcpBufferSizes = nai.linkProperties.getTcpBufferSizes();
        String[] values = null;
        if (tcpBufferSizes != null) {
            values = tcpBufferSizes.split(",");
        }
        if (values == null || values.length != 6) {
            ConnectivityService.log("Invalid tcpBufferSizes string: " + tcpBufferSizes + ", using defaults");
            tcpBufferSizes = DEFAULT_TCP_BUFFER_SIZES;
            values = tcpBufferSizes.split(",");
        }
        if (tcpBufferSizes.equals(this.mCurrentTcpBufferSizes)) {
            return;
        }
        try {
            String prefix = "/sys/kernel/ipv4/tcp_";
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", values[0]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", values[1]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", values[2]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", values[3]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", values[4]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", values[5]);
            this.mCurrentTcpBufferSizes = tcpBufferSizes;
        }
        catch (IOException e) {
            ConnectivityService.loge("Can't set TCP buffer sizes:" + e);
        }
        Integer rwndValue = Settings.Global.getInt(this.mContext.getContentResolver(), "tcp_default_init_rwnd", this.mSystemProperties.getInt(DEFAULT_TCP_RWND_KEY, 0));
        String sysctlKey = "sys.sysctl.tcp_def_init_rwnd";
        if (rwndValue != 0) {
            this.mSystemProperties.set("sys.sysctl.tcp_def_init_rwnd", rwndValue.toString());
        }
    }

    @Override
    public int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = this.mSystemProperties.get(NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.parseInt(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 17 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    private void dumpNetworkDiagnostics(IndentingPrintWriter pw) {
        ArrayList<NetworkDiagnostics> netDiags = new ArrayList<NetworkDiagnostics>();
        long DIAG_TIME_MS = 5000L;
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            netDiags.add(new NetworkDiagnostics(nai.network, new LinkProperties(nai.linkProperties), 5000L));
        }
        for (NetworkDiagnostics netDiag : netDiags) {
            pw.println();
            netDiag.waitForMeasurements();
            netDiag.dump(pw);
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        PriorityDump.dump(this.mPriorityDumper, fd, writer, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(FileDescriptor fd, PrintWriter writer, String[] args, boolean asProto) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        if (asProto) {
            return;
        }
        if (ArrayUtils.contains(args, DIAG_ARG)) {
            this.dumpNetworkDiagnostics(pw);
            return;
        }
        if (ArrayUtils.contains(args, TETHERING_ARG)) {
            this.mTethering.dump(fd, pw, args);
            return;
        }
        pw.print("NetworkFactories for:");
        for (NetworkFactoryInfo networkFactoryInfo : this.mNetworkFactoryInfos.values()) {
            pw.print(" " + networkFactoryInfo.name);
        }
        pw.println();
        pw.println();
        NetworkAgentInfo defaultNai = this.getDefaultNetwork();
        pw.print("Active default network: ");
        if (defaultNai == null) {
            pw.println("none");
        } else {
            pw.println(defaultNai.network.netId);
        }
        pw.println();
        pw.println("Current Networks:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            pw.println(nai.toString());
            pw.increaseIndent();
            pw.println(String.format("Requests: REQUEST:%d LISTEN:%d BACKGROUND_REQUEST:%d total:%d", nai.numForegroundNetworkRequests(), nai.numNetworkRequests() - nai.numRequestNetworkRequests(), nai.numBackgroundNetworkRequests(), nai.numNetworkRequests()));
            pw.increaseIndent();
            for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                pw.println(nai.requestAt(i).toString());
            }
            pw.decreaseIndent();
            pw.println("Lingered:");
            pw.increaseIndent();
            nai.dumpLingerTimers(pw);
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println();
        pw.println("Network Requests:");
        pw.increaseIndent();
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            pw.println(nri.toString());
        }
        pw.println();
        pw.decreaseIndent();
        this.mLegacyTypeTracker.dump(pw);
        pw.println();
        this.mTethering.dump(fd, pw, args);
        pw.println();
        this.mKeepaliveTracker.dump(pw);
        pw.println();
        this.dumpAvoidBadWifiSettings(pw);
        pw.println();
        this.mMultipathPolicyTracker.dump(pw);
        if (!ArrayUtils.contains(args, SHORT_ARG)) {
            pw.println();
            ArrayDeque<ValidationLog> arrayDeque = this.mValidationLogs;
            synchronized (arrayDeque) {
                pw.println("mValidationLogs (most recent first):");
                for (ValidationLog p : this.mValidationLogs) {
                    pw.println(p.mNetwork + " - " + p.mName);
                    pw.increaseIndent();
                    p.mLog.dump(fd, pw, args);
                    pw.decreaseIndent();
                }
            }
            pw.println();
            pw.println("mNetworkRequestInfoLogs (most recent first):");
            pw.increaseIndent();
            this.mNetworkRequestInfoLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
            pw.println();
            pw.println("mNetworkInfoBlockingLogs (most recent first):");
            pw.increaseIndent();
            this.mNetworkInfoBlockingLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
            pw.println();
            pw.println("NetTransition WakeLock activity (most recent first):");
            pw.increaseIndent();
            pw.println("total acquisitions: " + this.mTotalWakelockAcquisitions);
            pw.println("total releases: " + this.mTotalWakelockReleases);
            pw.println("cumulative duration: " + this.mTotalWakelockDurationMs / 1000L + "s");
            pw.println("longest duration: " + this.mMaxWakelockDurationMs / 1000L + "s");
            if (this.mTotalWakelockAcquisitions > this.mTotalWakelockReleases) {
                long l = SystemClock.elapsedRealtime() - this.mLastWakeLockAcquireTimestamp;
                pw.println("currently holding WakeLock for: " + l / 1000L + "s");
            }
            this.mWakelockLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
        }
    }

    private boolean isLiveNetworkAgent(NetworkAgentInfo nai, int what) {
        if (nai.network == null) {
            return false;
        }
        NetworkAgentInfo officialNai = this.getNetworkAgentInfoForNetwork(nai.network);
        if (officialNai != null && officialNai.equals(nai)) {
            return true;
        }
        if (officialNai != null) {
            ConnectivityService.loge(ConnectivityService.eventName(what) + " - isLiveNetworkAgent found mismatched netId: " + officialNai + " - " + nai);
        }
        return false;
    }

    private boolean networkRequiresValidation(NetworkAgentInfo nai) {
        return NetworkMonitor.isValidationRequired(this.mDefaultRequest.networkCapabilities, nai.networkCapabilities);
    }

    private void handleFreshlyValidatedNetwork(NetworkAgentInfo nai) {
        if (nai == null) {
            return;
        }
        DnsManager.PrivateDnsConfig cfg = this.mDnsManager.getPrivateDnsConfig();
        if (cfg.useTls && TextUtils.isEmpty(cfg.hostname)) {
            this.updateDnses(nai.linkProperties, null, nai.network.netId);
        }
    }

    private void handlePrivateDnsSettingsChanged() {
        DnsManager.PrivateDnsConfig cfg = this.mDnsManager.getPrivateDnsConfig();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            this.handlePerNetworkPrivateDnsConfig(nai, cfg);
            if (!this.networkRequiresValidation(nai)) continue;
            this.handleUpdateLinkProperties(nai, new LinkProperties(nai.linkProperties));
        }
    }

    private void handlePerNetworkPrivateDnsConfig(NetworkAgentInfo nai, DnsManager.PrivateDnsConfig cfg) {
        if (!this.networkRequiresValidation(nai)) {
            return;
        }
        nai.networkMonitor.notifyPrivateDnsSettingsChanged(cfg);
        this.updatePrivateDns(nai, cfg);
    }

    private void updatePrivateDns(NetworkAgentInfo nai, DnsManager.PrivateDnsConfig newCfg) {
        this.mDnsManager.updatePrivateDns(nai.network, newCfg);
        this.updateDnses(nai.linkProperties, null, nai.network.netId);
    }

    private void handlePrivateDnsValidationUpdate(DnsManager.PrivateDnsValidationUpdate update) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetId(update.netId);
        if (nai == null) {
            return;
        }
        this.mDnsManager.updatePrivateDnsValidation(update);
        this.handleUpdateLinkProperties(nai, new LinkProperties(nai.linkProperties));
    }

    private void updateLingerState(NetworkAgentInfo nai, long now) {
        nai.updateLingerTimer();
        if (nai.isLingering() && nai.numForegroundNetworkRequests() > 0) {
            ConnectivityService.log("Unlingering " + nai.name());
            nai.unlinger();
            this.logNetworkEvent(nai, 6);
        } else if (this.unneeded(nai, UnneededFor.LINGER) && nai.getLingerExpiry() > 0L) {
            int lingerTime = (int)(nai.getLingerExpiry() - now);
            ConnectivityService.log("Lingering " + nai.name() + " for " + lingerTime + "ms");
            nai.linger();
            this.logNetworkEvent(nai, 5);
            this.notifyNetworkCallbacks(nai, 524291, lingerTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelHalfConnect(Message msg) {
        AsyncChannel ac = (AsyncChannel)msg.obj;
        if (this.mNetworkFactoryInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                    if (nri.request.isListen()) continue;
                    NetworkAgentInfo nai = this.getNetworkForRequest(nri.request.requestId);
                    ac.sendMessage(536576, nai != null ? nai.getCurrentScore() : 0, 0, nri.request);
                }
            } else {
                ConnectivityService.loge("Error connecting NetworkFactory");
                this.mNetworkFactoryInfos.remove(msg.obj);
            }
        } else if (this.mNetworkAgentInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                this.mNetworkAgentInfos.get((Object)msg.replyTo).asyncChannel.sendMessage(69633);
            } else {
                ConnectivityService.loge("Error connecting NetworkAgent");
                NetworkAgentInfo nai = this.mNetworkAgentInfos.remove(msg.replyTo);
                if (nai != null) {
                    boolean wasDefault = this.isDefaultNetwork(nai);
                    SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
                    synchronized (sparseArray) {
                        this.mNetworkForNetId.remove(nai.network.netId);
                        this.mNetIdInUse.delete(nai.network.netId);
                    }
                    this.mLegacyTypeTracker.remove(nai, wasDefault);
                }
            }
        }
    }

    private void handleAsyncChannelDisconnected(Message msg) {
        NetworkAgentInfo nai = this.mNetworkAgentInfos.get(msg.replyTo);
        if (nai != null) {
            this.disconnectAndDestroyNetwork(nai);
        } else {
            NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(msg.replyTo);
            if (nfi != null) {
                ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAndDestroyNetwork(NetworkAgentInfo nai) {
        boolean wasDefault;
        ConnectivityService.log(nai.name() + " got DISCONNECTED, was satisfying " + nai.numNetworkRequests());
        if (nai.networkInfo.isConnected()) {
            nai.networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        }
        if (wasDefault = this.isDefaultNetwork(nai)) {
            this.mDefaultInetConditionPublished = 0;
            long now = SystemClock.elapsedRealtime();
            this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkEvent(now, null, nai);
        }
        this.notifyIfacesChangedForNetworkStats();
        this.notifyNetworkCallbacks(nai, 524292);
        this.mKeepaliveTracker.handleStopAllKeepalives(nai, -20);
        for (String iface : nai.linkProperties.getAllInterfaceNames()) {
            this.wakeupModifyInterface(iface, nai.networkCapabilities, false);
        }
        nai.networkMonitor.sendMessage(532487);
        this.mNetworkAgentInfos.remove(nai.messenger);
        nai.maybeStopClat();
        SparseArray<NetworkAgentInfo> now = this.mNetworkForNetId;
        synchronized (now) {
            this.mNetworkForNetId.remove(nai.network.netId);
        }
        for (int i = 0; i < nai.numNetworkRequests(); ++i) {
            NetworkRequest request = nai.requestAt(i);
            NetworkAgentInfo currentNetwork = this.getNetworkForRequest(request.requestId);
            if (currentNetwork == null || currentNetwork.network.netId != nai.network.netId) continue;
            this.clearNetworkForRequest(request.requestId);
            this.sendUpdatedScoreToFactories(request, 0);
        }
        nai.clearLingerState();
        if (nai.isSatisfyingRequest(this.mDefaultRequest.requestId)) {
            this.removeDataActivityTracking(nai);
            this.notifyLockdownVpn(nai);
            this.ensureNetworkTransitionWakelock(nai.name());
        }
        this.mLegacyTypeTracker.remove(nai, wasDefault);
        if (!nai.networkCapabilities.hasTransport(4)) {
            this.updateAllVpnsCapabilities();
        }
        this.rematchAllNetworksAndRequests(null, 0);
        this.mLingerMonitor.noteDisconnect(nai);
        if (nai.created) {
            try {
                this.mNetd.removeNetwork(nai.network.netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception removing network: " + e);
            }
            this.mDnsManager.removeNetwork(nai.network);
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            this.mNetIdInUse.delete(nai.network.netId);
        }
    }

    private NetworkRequestInfo findExistingNetworkRequestInfo(PendingIntent pendingIntent) {
        Intent intent = pendingIntent.getIntent();
        for (Map.Entry<NetworkRequest, NetworkRequestInfo> entry : this.mNetworkRequests.entrySet()) {
            PendingIntent existingPendingIntent = entry.getValue().mPendingIntent;
            if (existingPendingIntent == null || !existingPendingIntent.getIntent().filterEquals(intent)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void handleRegisterNetworkRequestWithIntent(Message msg) {
        NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
        NetworkRequestInfo existingRequest = this.findExistingNetworkRequestInfo(nri.mPendingIntent);
        if (existingRequest != null) {
            ConnectivityService.log("Replacing " + existingRequest.request + " with " + nri.request + " because their intents matched.");
            this.handleReleaseNetworkRequest(existingRequest.request, ConnectivityService.getCallingUid());
        }
        this.handleRegisterNetworkRequest(nri);
    }

    private void handleRegisterNetworkRequest(NetworkRequestInfo nri) {
        this.mNetworkRequests.put(nri.request, nri);
        this.mNetworkRequestInfoLogs.log("REGISTER " + nri);
        if (nri.request.isListen()) {
            for (NetworkAgentInfo network : this.mNetworkAgentInfos.values()) {
                if (!nri.request.networkCapabilities.hasSignalStrength() || !network.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                this.updateSignalStrengthThresholds(network, "REGISTER", nri.request);
            }
        }
        this.rematchAllNetworksAndRequests(null, 0);
        if (nri.request.isRequest() && this.getNetworkForRequest(nri.request.requestId) == null) {
            this.sendUpdatedScoreToFactories(nri.request, 0);
        }
    }

    private void handleReleaseNetworkRequestWithIntent(PendingIntent pendingIntent, int callingUid) {
        NetworkRequestInfo nri = this.findExistingNetworkRequestInfo(pendingIntent);
        if (nri != null) {
            this.handleReleaseNetworkRequest(nri.request, callingUid);
        }
    }

    private boolean unneeded(NetworkAgentInfo nai, UnneededFor reason) {
        int numRequests;
        switch (reason) {
            case TEARDOWN: {
                numRequests = nai.numRequestNetworkRequests();
                break;
            }
            case LINGER: {
                numRequests = nai.numForegroundNetworkRequests();
                break;
            }
            default: {
                Slog.wtf(TAG, "Invalid reason. Cannot happen.");
                return true;
            }
        }
        if (!nai.everConnected || nai.isVPN() || nai.isLingering() || numRequests > 0) {
            return false;
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            if (reason == UnneededFor.LINGER && nri.request.isBackgroundRequest() || !nri.request.isRequest() || !nai.satisfies(nri.request) || !nai.isSatisfyingRequest(nri.request.requestId) && this.getNetworkForRequest(nri.request.requestId).getCurrentScore() >= nai.getCurrentScoreAsValidated()) continue;
            return false;
        }
        return true;
    }

    private NetworkRequestInfo getNriForAppRequest(NetworkRequest request, int callingUid, String requestedOperation) {
        NetworkRequestInfo nri = this.mNetworkRequests.get(request);
        if (nri != null && 1000 != callingUid && nri.mUid != callingUid) {
            ConnectivityService.log(String.format("UID %d attempted to %s for unowned request %s", callingUid, requestedOperation, nri));
            return null;
        }
        return nri;
    }

    private void handleTimedOutNetworkRequest(NetworkRequestInfo nri) {
        if (this.mNetworkRequests.get(nri.request) == null) {
            return;
        }
        if (this.getNetworkForRequest(nri.request.requestId) != null) {
            return;
        }
        if (nri.request.isRequest()) {
            ConnectivityService.log("releasing " + nri.request + " (timeout)");
        }
        this.handleRemoveNetworkRequest(nri);
        this.callCallbackForRequest(nri, null, 524293, 0);
    }

    private void handleReleaseNetworkRequest(NetworkRequest request, int callingUid) {
        NetworkRequestInfo nri = this.getNriForAppRequest(request, callingUid, "release NetworkRequest");
        if (nri == null) {
            return;
        }
        if (nri.request.isRequest()) {
            ConnectivityService.log("releasing " + nri.request + " (release request)");
        }
        this.handleRemoveNetworkRequest(nri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveNetworkRequest(NetworkRequestInfo nri) {
        nri.unlinkDeathRecipient();
        this.mNetworkRequests.remove(nri.request);
        SparseIntArray sparseIntArray = this.mUidToNetworkRequestCount;
        synchronized (sparseIntArray) {
            int requests = this.mUidToNetworkRequestCount.get(nri.mUid, 0);
            if (requests < 1) {
                Slog.wtf(TAG, "BUG: too small request count " + requests + " for UID " + nri.mUid);
            } else if (requests == 1) {
                this.mUidToNetworkRequestCount.removeAt(this.mUidToNetworkRequestCount.indexOfKey(nri.mUid));
            } else {
                this.mUidToNetworkRequestCount.put(nri.mUid, requests - 1);
            }
        }
        this.mNetworkRequestInfoLogs.log("RELEASE " + nri);
        if (nri.request.isRequest()) {
            boolean wasKept = false;
            NetworkAgentInfo nai = this.getNetworkForRequest(nri.request.requestId);
            if (nai != null) {
                boolean wasBackgroundNetwork = nai.isBackgroundNetwork();
                nai.removeRequest(nri.request.requestId);
                this.updateLingerState(nai, SystemClock.elapsedRealtime());
                if (this.unneeded(nai, UnneededFor.TEARDOWN)) {
                    ConnectivityService.log("no live requests for " + nai.name() + "; disconnecting");
                    this.teardownUnneededNetwork(nai);
                } else {
                    wasKept = true;
                }
                this.clearNetworkForRequest(nri.request.requestId);
                if (!wasBackgroundNetwork && nai.isBackgroundNetwork()) {
                    this.updateCapabilities(nai.getCurrentScore(), nai, nai.networkCapabilities);
                }
            }
            for (NetworkAgentInfo otherNai : this.mNetworkAgentInfos.values()) {
                if (!otherNai.isSatisfyingRequest(nri.request.requestId) || otherNai == nai) continue;
                Slog.wtf(TAG, "Request " + nri.request + " satisfied by " + otherNai.name() + ", but mNetworkAgentInfos says " + (nai != null ? nai.name() : "null"));
            }
            if (nri.request.legacyType != -1 && nai != null) {
                boolean doRemove = true;
                if (wasKept) {
                    for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                        NetworkRequest otherRequest = nai.requestAt(i);
                        if (otherRequest.legacyType != nri.request.legacyType || !otherRequest.isRequest()) continue;
                        ConnectivityService.log(" still have other legacy request - leaving");
                        doRemove = false;
                    }
                }
                if (doRemove) {
                    this.mLegacyTypeTracker.remove(nri.request.legacyType, nai, false);
                }
            }
            for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
                nfi.asyncChannel.sendMessage(536577, nri.request);
            }
        } else {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                nai.removeRequest(nri.request.requestId);
                if (!nri.request.networkCapabilities.hasSignalStrength() || !nai.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                this.updateSignalStrengthThresholds(nai, "RELEASE", nri.request);
            }
        }
    }

    @Override
    public void setAcceptUnvalidated(Network network, boolean accept, boolean always) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(28, ConnectivityService.encodeBool(accept), ConnectivityService.encodeBool(always), network));
    }

    @Override
    public void setAvoidUnvalidated(Network network) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, network));
    }

    private void handleSetAcceptUnvalidated(Network network, boolean accept, boolean always) {
        ConnectivityService.log("handleSetAcceptUnvalidated network=" + network + " accept=" + accept + " always=" + always);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return;
        }
        if (nai.everValidated) {
            return;
        }
        if (!nai.networkMisc.explicitlySelected) {
            Slog.wtf(TAG, "BUG: setAcceptUnvalidated non non-explicitly selected network");
        }
        if (accept != nai.networkMisc.acceptUnvalidated) {
            int oldScore = nai.getCurrentScore();
            nai.networkMisc.acceptUnvalidated = accept;
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.sendUpdatedScoreToFactories(nai);
        }
        if (always) {
            nai.asyncChannel.sendMessage(528393, ConnectivityService.encodeBool(accept));
        }
        if (!accept) {
            nai.asyncChannel.sendMessage(528399);
            this.teardownUnneededNetwork(nai);
        }
    }

    private void handleSetAvoidUnvalidated(Network network) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.lastValidated) {
            return;
        }
        if (!nai.avoidUnvalidated) {
            int oldScore = nai.getCurrentScore();
            nai.avoidUnvalidated = true;
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.sendUpdatedScoreToFactories(nai);
        }
    }

    private void scheduleUnvalidatedPrompt(NetworkAgentInfo nai) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(29, nai.network), 8000L);
    }

    @Override
    public void startCaptivePortalApp(Network network) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.post(() -> {
            NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
            if (nai == null) {
                return;
            }
            if (!nai.networkCapabilities.hasCapability(17)) {
                return;
            }
            nai.networkMonitor.sendMessage(532491);
        });
    }

    public boolean avoidBadWifi() {
        return this.mMultinetworkPolicyTracker.getAvoidBadWifi();
    }

    private void rematchForAvoidBadWifiUpdate() {
        this.rematchAllNetworksAndRequests(null, 0);
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            if (!nai.networkCapabilities.hasTransport(1)) continue;
            this.sendUpdatedScoreToFactories(nai);
        }
    }

    private void dumpAvoidBadWifiSettings(IndentingPrintWriter pw) {
        boolean configRestrict = this.mMultinetworkPolicyTracker.configRestrictsAvoidBadWifi();
        if (!configRestrict) {
            pw.println("Bad Wi-Fi avoidance: unrestricted");
            return;
        }
        pw.println("Bad Wi-Fi avoidance: " + this.avoidBadWifi());
        pw.increaseIndent();
        pw.println("Config restrict:   " + configRestrict);
        String value = this.mMultinetworkPolicyTracker.getAvoidBadWifiSetting();
        String description = "0".equals(value) ? "get stuck" : (value == null ? "prompt" : ("1".equals(value) ? "avoid" : value + " (?)"));
        pw.println("User setting:      " + description);
        pw.println("Network overrides:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            if (!nai.avoidUnvalidated) continue;
            pw.println(nai.name());
        }
        pw.decreaseIndent();
        pw.decreaseIndent();
    }

    private void showValidationNotification(NetworkAgentInfo nai, NetworkNotificationManager.NotificationType type) {
        String action;
        switch (type) {
            case NO_INTERNET: {
                action = "android.net.conn.PROMPT_UNVALIDATED";
                break;
            }
            case LOST_INTERNET: {
                action = "android.net.conn.PROMPT_LOST_VALIDATION";
                break;
            }
            default: {
                Slog.wtf(TAG, "Unknown notification type " + (Object)((Object)type));
                return;
            }
        }
        Intent intent = new Intent(action);
        intent.setData(Uri.fromParts("netId", Integer.toString(nai.network.netId), null));
        intent.addFlags(0x10000000);
        intent.setClassName("com.android.settings", "com.android.settings.wifi.WifiNoInternetDialog");
        PendingIntent pendingIntent = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, UserHandle.CURRENT);
        this.mNotifier.showNotification(nai.network.netId, type, nai, null, pendingIntent, true);
    }

    private void handlePromptUnvalidated(Network network) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.everValidated || nai.everCaptivePortalDetected || !nai.networkMisc.explicitlySelected || nai.networkMisc.acceptUnvalidated) {
            return;
        }
        this.showValidationNotification(nai, NetworkNotificationManager.NotificationType.NO_INTERNET);
    }

    private void handleNetworkUnvalidated(NetworkAgentInfo nai) {
        NetworkCapabilities nc = nai.networkCapabilities;
        ConnectivityService.log("handleNetworkUnvalidated " + nai.name() + " cap=" + nc);
        if (nc.hasTransport(1) && this.mMultinetworkPolicyTracker.shouldNotifyWifiUnvalidated()) {
            this.showValidationNotification(nai, NetworkNotificationManager.NotificationType.LOST_INTERNET);
        }
    }

    @Override
    public int getMultipathPreference(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null && nai.networkCapabilities.hasCapability(11)) {
            return 7;
        }
        Integer networkPreference = this.mMultipathPolicyTracker.getMultipathPreference(network);
        if (networkPreference != null) {
            return networkPreference;
        }
        return this.mMultinetworkPolicyTracker.getMeteredMultipathPreference();
    }

    @Override
    public int tether(String iface, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            int status = this.mTethering.tether(iface);
            return status;
        }
        return 3;
    }

    @Override
    public int untether(String iface, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            int status = this.mTethering.untether(iface);
            return status;
        }
        return 3;
    }

    @Override
    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    @Override
    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    @Override
    public int setUsbTethering(boolean enable, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    @Override
    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    @Override
    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    @Override
    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    @Override
    public String[] getTetheredDhcpRanges() {
        this.enforceConnectivityInternalPermission();
        return this.mTethering.getTetheredDhcpRanges();
    }

    @Override
    public boolean isTetheringSupported(String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        return this.isTetheringSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTetheringSupported() {
        int defaultVal = ConnectivityService.encodeBool(!this.mSystemProperties.get("ro.tether.denied").equals("true"));
        boolean tetherSupported = ConnectivityService.toBool(Settings.Global.getInt(this.mContext.getContentResolver(), "tether_supported", defaultVal));
        boolean tetherEnabledInSettings = tetherSupported && !this.mUserManager.hasUserRestriction("no_config_tethering");
        boolean adminUser = false;
        long token = Binder.clearCallingIdentity();
        try {
            adminUser = this.mUserManager.isAdminUser();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return tetherEnabledInSettings && adminUser && this.mTethering.hasTetherableConfiguration();
    }

    @Override
    public void startTethering(int type, ResultReceiver receiver, boolean showProvisioningUi, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (!this.isTetheringSupported()) {
            receiver.send(3, null);
            return;
        }
        this.mTethering.startTethering(type, receiver, showProvisioningUi);
    }

    @Override
    public void stopTethering(int type, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        this.mTethering.stopTethering(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNetworkTransitionWakelock(String forWhom) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            this.mNetTransitionWakeLock.acquire();
            this.mLastWakeLockAcquireTimestamp = SystemClock.elapsedRealtime();
            ++this.mTotalWakelockAcquisitions;
        }
        this.mWakelockLogs.log("ACQUIRE for " + forWhom);
        Message msg = this.mHandler.obtainMessage(24);
        this.mHandler.sendMessageDelayed(msg, this.mNetTransitionWakeLockTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReleaseNetworkTransitionWakelock() {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
        }
        this.mHandler.removeMessages(24);
        Message msg = this.mHandler.obtainMessage(8);
        this.mHandler.sendMessageDelayed(msg, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReleaseNetworkTransitionWakelock(int eventId) {
        String event = ConnectivityService.eventName(eventId);
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mNetTransitionWakeLock.isHeld()) {
                this.mWakelockLogs.log(String.format("RELEASE: already released (%s)", event));
                Slog.w(TAG, "expected Net Transition WakeLock to be held");
                return;
            }
            this.mNetTransitionWakeLock.release();
            long lockDuration = SystemClock.elapsedRealtime() - this.mLastWakeLockAcquireTimestamp;
            this.mTotalWakelockDurationMs += lockDuration;
            this.mMaxWakelockDurationMs = Math.max(this.mMaxWakelockDurationMs, lockDuration);
            ++this.mTotalWakelockReleases;
        }
        this.mWakelockLogs.log(String.format("RELEASE (%s)", event));
    }

    @Override
    public void reportInetCondition(int networkType, int percentage) {
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            return;
        }
        this.reportNetworkConnectivity(nai.network, percentage > 50);
    }

    @Override
    public void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        this.enforceAccessPermission();
        this.enforceInternetPermission();
        int uid = Binder.getCallingUid();
        int connectivityInfo = ConnectivityService.encodeBool(hasConnectivity);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(36, uid, connectivityInfo, network));
    }

    private void handleReportNetworkConnectivity(Network network, int uid, boolean hasConnectivity) {
        NetworkAgentInfo nai = network == null ? this.getDefaultNetwork() : this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTING || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTED) {
            return;
        }
        if (hasConnectivity == nai.lastValidated) {
            return;
        }
        int netid = nai.network.netId;
        ConnectivityService.log("reportNetworkConnectivity(" + netid + ", " + hasConnectivity + ") by " + uid);
        if (!nai.everConnected) {
            return;
        }
        LinkProperties lp = this.getLinkProperties(nai);
        if (this.isNetworkWithLinkPropertiesBlocked(lp, uid, false)) {
            return;
        }
        nai.networkMonitor.forceReevaluation(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyInfo getDefaultProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            ProxyInfo ret = this.mGlobalProxy;
            if (ret == null && !this.mDefaultProxyDisabled) {
                ret = this.mDefaultProxy;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getProxyForNetwork(Network network) {
        if (network == null) {
            return this.getDefaultProxy();
        }
        ProxyInfo globalProxy = this.getGlobalProxy();
        if (globalProxy != null) {
            return globalProxy;
        }
        if (!NetworkUtils.queryUserAccess(Binder.getCallingUid(), network.netId)) {
            return null;
        }
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return null;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            ProxyInfo proxyInfo = nai.linkProperties.getHttpProxy();
            if (proxyInfo == null) {
                return null;
            }
            return new ProxyInfo(proxyInfo);
        }
    }

    private ProxyInfo canonicalizeProxyInfo(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && (proxy.getPacFileUrl() == null || Uri.EMPTY.equals(proxy.getPacFileUrl()))) {
            proxy = null;
        }
        return proxy;
    }

    private boolean proxyInfoEqual(ProxyInfo a, ProxyInfo b) {
        return Objects.equals(a = this.canonicalizeProxyInfo(a), b = this.canonicalizeProxyInfo(b)) && (a == null || Objects.equals(a.getHost(), b.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalProxy(ProxyInfo proxyProperties) {
        this.enforceConnectivityInternalPermission();
        Object object = this.mProxyLock;
        synchronized (object) {
            if (proxyProperties == this.mGlobalProxy) {
                return;
            }
            if (proxyProperties != null && proxyProperties.equals(this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals(proxyProperties)) {
                return;
            }
            String host = "";
            int port = 0;
            String exclList = "";
            String pacFileUrl = "";
            if (!(proxyProperties == null || TextUtils.isEmpty(proxyProperties.getHost()) && Uri.EMPTY.equals(proxyProperties.getPacFileUrl()))) {
                if (!proxyProperties.isValid()) {
                    ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                    return;
                }
                this.mGlobalProxy = new ProxyInfo(proxyProperties);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionListAsString();
                if (!Uri.EMPTY.equals(proxyProperties.getPacFileUrl())) {
                    pacFileUrl = proxyProperties.getPacFileUrl().toString();
                }
            } else {
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(res, "global_http_proxy_host", host);
                Settings.Global.putInt(res, "global_http_proxy_port", port);
                Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclList);
                Settings.Global.putString(res, "global_proxy_pac_url", pacFileUrl);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (this.mGlobalProxy == null) {
                proxyProperties = this.mDefaultProxy;
            }
            this.sendProxyBroadcast(proxyProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Global.getString(res, "global_http_proxy_host");
        int port = Settings.Global.getInt(res, "global_http_proxy_port", 0);
        String exclList = Settings.Global.getString(res, "global_http_proxy_exclusion_list");
        String pacFileUrl = Settings.Global.getString(res, "global_proxy_pac_url");
        if (!TextUtils.isEmpty(host) || !TextUtils.isEmpty(pacFileUrl)) {
            ProxyInfo proxyProperties = !TextUtils.isEmpty(pacFileUrl) ? new ProxyInfo(pacFileUrl) : new ProxyInfo(host, port, exclList);
            if (!proxyProperties.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                return;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getGlobalProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyDefaultProxy(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && Uri.EMPTY.equals(proxy.getPacFileUrl())) {
            proxy = null;
        }
        Object object = this.mProxyLock;
        synchronized (object) {
            if (this.mDefaultProxy != null && this.mDefaultProxy.equals(proxy)) {
                return;
            }
            if (this.mDefaultProxy == proxy) {
                return;
            }
            if (proxy != null && !proxy.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxy.toString());
                return;
            }
            if (this.mGlobalProxy != null && proxy != null && !Uri.EMPTY.equals(proxy.getPacFileUrl()) && proxy.getPacFileUrl().equals(this.mGlobalProxy.getPacFileUrl())) {
                this.mGlobalProxy = proxy;
                this.sendProxyBroadcast(this.mGlobalProxy);
                return;
            }
            this.mDefaultProxy = proxy;
            if (this.mGlobalProxy != null) {
                return;
            }
            if (!this.mDefaultProxyDisabled) {
                this.sendProxyBroadcast(proxy);
            }
        }
    }

    private void updateProxy(LinkProperties newLp, LinkProperties oldLp, NetworkAgentInfo nai) {
        ProxyInfo oldProxyInfo;
        ProxyInfo newProxyInfo = newLp == null ? null : newLp.getHttpProxy();
        ProxyInfo proxyInfo = oldProxyInfo = oldLp == null ? null : oldLp.getHttpProxy();
        if (!this.proxyInfoEqual(newProxyInfo, oldProxyInfo)) {
            this.sendProxyBroadcast(this.getDefaultProxy());
        }
    }

    private void handleDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Global.getString(this.mContext.getContentResolver(), "http_proxy");
        if (!TextUtils.isEmpty(proxy)) {
            String[] data = proxy.split(":");
            if (data.length == 0) {
                return;
            }
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyInfo p = new ProxyInfo(data[0], proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProxyBroadcast(ProxyInfo proxy) {
        if (proxy == null) {
            proxy = new ProxyInfo("", 0, "");
        }
        if (this.mPacManager.setCurrentProxyScriptUrl(proxy)) {
            return;
        }
        ConnectivityService.log("sending Proxy Broadcast for " + proxy);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("android.intent.extra.PROXY_INFO", proxy);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }

    private static void loge(String s, Throwable t) {
        Slog.e(TAG, s, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareVpn(String oldPackage, String newPackage, int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.prepare(oldPackage, newPackage);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVpnPackageAuthorization(String packageName, int userId, boolean authorized) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                vpn.setPackageAuthorization(packageName, authorized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).establish(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLegacyVpn(VpnProfile profile) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        LinkProperties egress = this.getActiveLinkProperties();
        if (egress == null) {
            throw new IllegalStateException("Missing active network connection");
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            this.mVpns.get(user).startLegacyVpn(profile, this.mKeyStore, egress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyVpnInfo getLegacyVpnInfo(int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(userId).getLegacyVpnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnInfo[] getAllVpnInfo() {
        this.enforceConnectivityInternalPermission();
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownEnabled) {
                return new VpnInfo[0];
            }
            ArrayList<VpnInfo> infoList = new ArrayList<VpnInfo>();
            for (int i = 0; i < this.mVpns.size(); ++i) {
                VpnInfo info = this.createVpnInfo(this.mVpns.valueAt(i));
                if (info == null) continue;
                infoList.add(info);
            }
            return infoList.toArray(new VpnInfo[infoList.size()]);
        }
    }

    private VpnInfo createVpnInfo(Vpn vpn) {
        LinkProperties linkProperties;
        VpnInfo info = vpn.getVpnInfo();
        if (info == null) {
            return null;
        }
        Network[] underlyingNetworks = vpn.getUnderlyingNetworks();
        if (underlyingNetworks == null) {
            NetworkAgentInfo defaultNetwork = this.getDefaultNetwork();
            if (defaultNetwork != null && defaultNetwork.linkProperties != null) {
                info.primaryUnderlyingIface = this.getDefaultNetwork().linkProperties.getInterfaceName();
            }
        } else if (underlyingNetworks.length > 0 && (linkProperties = this.getLinkProperties(underlyingNetworks[0])) != null) {
            info.primaryUnderlyingIface = linkProperties.getInterfaceName();
        }
        return info.primaryUnderlyingIface == null ? null : info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnConfig getVpnConfig(int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.getVpnConfig();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllVpnsCapabilities() {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mVpns.size(); ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                vpn.updateCapabilities();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockdownVpn() {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Lockdown VPN only available to AID_SYSTEM");
            return false;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mLockdownEnabled = LockdownVpnTracker.isEnabled();
            if (this.mLockdownEnabled) {
                byte[] profileTag = this.mKeyStore.get("LOCKDOWN_VPN");
                if (profileTag == null) {
                    Slog.e(TAG, "Lockdown VPN configured but cannot be read from keystore");
                    return false;
                }
                String profileName = new String(profileTag);
                VpnProfile profile = VpnProfile.decode(profileName, this.mKeyStore.get("VPN_" + profileName));
                if (profile == null) {
                    Slog.e(TAG, "Lockdown VPN configured invalid profile " + profileName);
                    this.setLockdownTracker(null);
                    return true;
                }
                int user = UserHandle.getUserId(Binder.getCallingUid());
                Vpn vpn = this.mVpns.get(user);
                if (vpn == null) {
                    Slog.w(TAG, "VPN for user " + user + " not ready yet. Skipping lockdown");
                    return false;
                }
                this.setLockdownTracker(new LockdownVpnTracker(this.mContext, this.mNetd, this, vpn, profile));
            } else {
                this.setLockdownTracker(null);
            }
        }
        return true;
    }

    @GuardedBy(value="mVpns")
    private void setLockdownTracker(LockdownVpnTracker tracker) {
        LockdownVpnTracker existing = this.mLockdownTracker;
        this.mLockdownTracker = null;
        if (existing != null) {
            existing.shutdown();
        }
        if (tracker != null) {
            this.mLockdownTracker = tracker;
            this.mLockdownTracker.init();
        }
    }

    @GuardedBy(value="mVpns")
    private void throwIfLockdownEnabled() {
        if (this.mLockdownEnabled) {
            throw new IllegalStateException("Unavailable in lockdown mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startAlwaysOnVpn(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.wtf(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            return vpn.startAlwaysOnVpn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlwaysOnVpnPackageSupported(int userId, String packageName) {
        this.enforceSettingsPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            return vpn.isAlwaysOnPackageSupported(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAlwaysOnVpnPackage(int userId, String packageName, boolean lockdown) {
        this.enforceConnectivityInternalPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (LockdownVpnTracker.isEnabled()) {
                return false;
            }
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            if (!vpn.setAlwaysOnPackage(packageName, lockdown)) {
                return false;
            }
            if (!this.startAlwaysOnVpn(userId)) {
                vpn.setAlwaysOnPackage(null, false);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlwaysOnVpnPackage(int userId) {
        this.enforceConnectivityInternalPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return null;
            }
            return vpn.getAlwaysOnPackage();
        }
    }

    @Override
    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProvisioningUrlBaseFromFile() {
        block28: {
            String element;
            FileReader fileReader = null;
            XmlPullParser parser = null;
            Configuration config = this.mContext.getResources().getConfiguration();
            try {
                fileReader = new FileReader(this.mProvisioningUrlFile);
                parser = Xml.newPullParser();
                parser.setInput(fileReader);
                XmlUtils.beginDocument(parser, TAG_PROVISIONING_URLS);
                while (true) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) break;
                    if (!element.equals(TAG_PROVISIONING_URL)) continue;
                    String mcc = parser.getAttributeValue(null, ATTR_MCC);
                    try {
                        String mnc;
                        if (mcc != null && Integer.parseInt(mcc) == config.mcc && (mnc = parser.getAttributeValue(null, ATTR_MNC)) != null && Integer.parseInt(mnc) == config.mnc) {
                            parser.next();
                            if (parser.getEventType() == 4) {
                                String string2 = parser.getText();
                                return string2;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        ConnectivityService.loge("NumberFormatException in getProvisioningUrlBaseFromFile: " + e);
                    }
                }
                element = null;
            }
            catch (FileNotFoundException e) {
                ConnectivityService.loge("Carrier Provisioning Urls file not found");
                break block28;
            }
            catch (XmlPullParserException e) {
                ConnectivityService.loge("Xml parser exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            catch (IOException e) {
                ConnectivityService.loge("I/O exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return element;
        }
        return null;
    }

    @Override
    public String getMobileProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile();
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17040325);
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioining_url from resource =" + url);
        } else {
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioning_url from File =" + url);
        }
        if (!TextUtils.isEmpty(url)) {
            String phoneNumber = this.mTelephonyManager.getLine1Number();
            if (TextUtils.isEmpty(phoneNumber)) {
                phoneNumber = "0000000000";
            }
            url = String.format(url, this.mTelephonyManager.getSimSerialNumber(), this.mTelephonyManager.getDeviceId(), phoneNumber);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        this.enforceConnectivityInternalPermission();
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            int id2 = 64512 + (networkType - -1);
            this.mNotifier.setProvNotificationVisible(visible, id2, action);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAirplaneMode(boolean enable) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "airplane_mode_on", ConnectivityService.encodeBool(enable));
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            intent.putExtra("state", enable);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStart(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn != null) {
                ConnectivityService.loge("Starting user already has a VPN");
                return;
            }
            userVpn = new Vpn(this.mHandler.getLooper(), this.mContext, this.mNetd, userId);
            this.mVpns.put(userId, userVpn);
            if (this.mUserManager.getUserInfo(userId).isPrimary() && LockdownVpnTracker.isEnabled()) {
                this.updateLockdownVpn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStop(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn == null) {
                ConnectivityService.loge("Stopped user has no VPN");
                return;
            }
            userVpn.onUserStopped();
            this.mVpns.delete(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserAdded(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int vpnsSize = this.mVpns.size();
            for (int i = 0; i < vpnsSize; ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                vpn.onUserAdded(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int vpnsSize = this.mVpns.size();
            for (int i = 0; i < vpnsSize; ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                vpn.onUserRemoved(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserUnlocked(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mUserManager.getUserInfo(userId).isPrimary() && LockdownVpnTracker.isEnabled()) {
                this.updateLockdownVpn();
            } else {
                this.startAlwaysOnVpn(userId);
            }
        }
    }

    private void ensureNetworkRequestHasType(NetworkRequest request) {
        if (request.type == NetworkRequest.Type.NONE) {
            throw new IllegalArgumentException("All NetworkRequests in ConnectivityService must have a type");
        }
    }

    private void ensureRequestableCapabilities(NetworkCapabilities networkCapabilities) {
        String badCapability = networkCapabilities.describeFirstNonRequestableCapability();
        if (badCapability != null) {
            throw new IllegalArgumentException("Cannot request network with " + badCapability);
        }
    }

    private void ensureSufficientPermissionsForRequest(NetworkCapabilities nc, int callerPid, int callerUid) {
        if (null != nc.getSSID() && !this.checkSettingsPermission(callerPid, callerUid)) {
            throw new SecurityException("Insufficient permissions to request a specific SSID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Integer> getSignalStrengthThresholds(NetworkAgentInfo nai) {
        TreeSet<Integer> thresholds = new TreeSet<Integer>();
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                if (!nri.request.networkCapabilities.hasSignalStrength() || !nai.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                thresholds.add(nri.request.networkCapabilities.getSignalStrength());
            }
        }
        return new ArrayList<Integer>(thresholds);
    }

    private void updateSignalStrengthThresholds(NetworkAgentInfo nai, String reason, NetworkRequest request) {
        ArrayList<Integer> thresholdsArray = this.getSignalStrengthThresholds(nai);
        Bundle thresholds = new Bundle();
        thresholds.putIntegerArrayList("thresholds", thresholdsArray);
        if (!"CONNECT".equals(reason)) {
            String detail = request != null && request.networkCapabilities.hasSignalStrength() ? reason + " " + request.networkCapabilities.getSignalStrength() : reason;
            ConnectivityService.log(String.format("updateSignalStrengthThresholds: %s, sending %s to %s", detail, Arrays.toString(thresholdsArray.toArray()), nai.name()));
        }
        nai.asyncChannel.sendMessage(528398, 0, 0, thresholds);
    }

    private void ensureValidNetworkSpecifier(NetworkCapabilities nc) {
        if (nc == null) {
            return;
        }
        NetworkSpecifier ns = nc.getNetworkSpecifier();
        if (ns == null) {
            return;
        }
        MatchAllNetworkSpecifier.checkNotMatchAllNetworkSpecifier(ns);
        ns.assertValidFromUid(Binder.getCallingUid());
    }

    @Override
    public NetworkRequest requestNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, int timeoutMs, IBinder binder, int legacyType) {
        NetworkRequest.Type type;
        NetworkRequest.Type type2 = type = networkCapabilities == null ? NetworkRequest.Type.TRACK_DEFAULT : NetworkRequest.Type.REQUEST;
        if (type == NetworkRequest.Type.TRACK_DEFAULT) {
            networkCapabilities = ConnectivityService.createDefaultNetworkCapabilitiesForUid(Binder.getCallingUid());
            this.enforceAccessPermission();
        } else {
            networkCapabilities = new NetworkCapabilities(networkCapabilities);
            this.enforceNetworkRequestPermissions(networkCapabilities);
            this.enforceMeteredApnPolicy(networkCapabilities);
        }
        this.ensureRequestableCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.restrictRequestUidsForCaller(networkCapabilities);
        if (timeoutMs < 0) {
            throw new IllegalArgumentException("Bad timeout specified");
        }
        this.ensureValidNetworkSpecifier(networkCapabilities);
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, legacyType, this.nextNetworkRequestId(), type);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder);
        ConnectivityService.log("requestNetwork for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(19, nri));
        if (timeoutMs > 0) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(20, nri), timeoutMs);
        }
        return networkRequest;
    }

    private void enforceNetworkRequestPermissions(NetworkCapabilities networkCapabilities) {
        if (!networkCapabilities.hasCapability(13)) {
            this.enforceConnectivityRestrictedNetworksPermission();
        } else {
            this.enforceChangePermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBandwidthUpdate(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = null;
        if (network == null) {
            return false;
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai != null) {
            nai.asyncChannel.sendMessage(528394);
            return true;
        }
        return false;
    }

    private boolean isSystem(int uid) {
        return uid < 10000;
    }

    private void enforceMeteredApnPolicy(NetworkCapabilities networkCapabilities) {
        int uid = Binder.getCallingUid();
        if (this.isSystem(uid)) {
            return;
        }
        if (networkCapabilities.hasCapability(11)) {
            return;
        }
        if (this.mPolicyManagerInternal.isUidRestrictedOnMeteredNetworks(uid)) {
            networkCapabilities.addCapability(11);
        }
    }

    @Override
    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        this.enforceNetworkRequestPermissions(networkCapabilities);
        this.enforceMeteredApnPolicy(networkCapabilities);
        this.ensureRequestableCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.ensureValidNetworkSpecifier(networkCapabilities);
        this.restrictRequestUidsForCaller(networkCapabilities);
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, -1, this.nextNetworkRequestId(), NetworkRequest.Type.REQUEST);
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation);
        ConnectivityService.log("pendingRequest for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(26, nri));
        return networkRequest;
    }

    private void releasePendingNetworkRequestWithDelay(PendingIntent operation) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation), this.mReleasePendingIntentDelayMs);
    }

    @Override
    public void releasePendingNetworkRequest(PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation));
    }

    private boolean hasWifiNetworkListenPermission(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        int[] transportTypes = nc.getTransportTypes();
        if (transportTypes.length != 1 || transportTypes[0] != 1) {
            return false;
        }
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", "ConnectivityService");
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    @Override
    public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder) {
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.restrictRequestUidsForCaller(nc);
        this.restrictBackgroundRequestForCaller(nc);
        this.ensureValidNetworkSpecifier(nc);
        NetworkRequest networkRequest = new NetworkRequest(nc, -1, this.nextNetworkRequestId(), NetworkRequest.Type.LISTEN);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
        return networkRequest;
    }

    @Override
    public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        this.ensureValidNetworkSpecifier(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        this.restrictRequestUidsForCaller(nc);
        NetworkRequest networkRequest = new NetworkRequest(nc, -1, this.nextNetworkRequestId(), NetworkRequest.Type.LISTEN);
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
    }

    @Override
    public void releaseNetworkRequest(NetworkRequest networkRequest) {
        this.ensureNetworkRequestHasType(networkRequest);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(22, ConnectivityService.getCallingUid(), 0, networkRequest));
    }

    @Override
    public void registerNetworkFactory(Messenger messenger, String name) {
        this.enforceConnectivityInternalPermission();
        NetworkFactoryInfo nfi = new NetworkFactoryInfo(name, messenger, new AsyncChannel());
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, nfi));
    }

    private void handleRegisterNetworkFactory(NetworkFactoryInfo nfi) {
        ConnectivityService.log("Got NetworkFactory Messenger for " + nfi.name);
        this.mNetworkFactoryInfos.put(nfi.messenger, nfi);
        nfi.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nfi.messenger);
    }

    @Override
    public void unregisterNetworkFactory(Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(23, messenger));
    }

    private void handleUnregisterNetworkFactory(Messenger messenger) {
        NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(messenger);
        if (nfi == null) {
            ConnectivityService.loge("Failed to find Messenger in unregisterNetworkFactory");
            return;
        }
        ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkAgentInfo getNetworkForRequest(int requestId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            return this.mNetworkForRequestId.get(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearNetworkForRequest(int requestId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            this.mNetworkForRequestId.remove(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNetworkForRequest(int requestId, NetworkAgentInfo nai) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            this.mNetworkForRequestId.put(requestId, nai);
        }
    }

    private NetworkAgentInfo getDefaultNetwork() {
        return this.getNetworkForRequest(this.mDefaultRequest.requestId);
    }

    private boolean isDefaultNetwork(NetworkAgentInfo nai) {
        return nai == this.getDefaultNetwork();
    }

    private boolean isDefaultRequest(NetworkRequestInfo nri) {
        return nri.request.requestId == this.mDefaultRequest.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int currentScore, NetworkMisc networkMisc) {
        this.enforceConnectivityInternalPermission();
        LinkProperties lp = new LinkProperties(linkProperties);
        lp.ensureDirectlyConnectedRoutes();
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        NetworkAgentInfo nai = new NetworkAgentInfo(messenger, new AsyncChannel(), new Network(this.reserveNetId()), new NetworkInfo(networkInfo), lp, nc, currentScore, this.mContext, this.mTrackerHandler, new NetworkMisc(networkMisc), this.mDefaultRequest, this);
        nai.networkCapabilities = this.mixInCapabilities(nai, nc);
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            nai.networkMonitor.systemReady = this.mSystemReady;
        }
        String extraInfo = networkInfo.getExtraInfo();
        String name = TextUtils.isEmpty(extraInfo) ? nai.networkCapabilities.getSSID() : extraInfo;
        this.addValidationLogs(nai.networkMonitor.getValidationLogs(), nai.network, name);
        ConnectivityService.log("registerNetworkAgent " + nai);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(18, nai));
        return nai.network.netId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterNetworkAgent(NetworkAgentInfo nai) {
        this.mNetworkAgentInfos.put(nai.messenger, nai);
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            this.mNetworkForNetId.put(nai.network.netId, nai);
        }
        nai.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nai.messenger);
        NetworkInfo networkInfo = nai.networkInfo;
        nai.networkInfo = null;
        this.updateNetworkInfo(nai, networkInfo);
        this.updateUids(nai, null, nai.networkCapabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkProperties(NetworkAgentInfo networkAgent, LinkProperties oldLp) {
        LinkProperties newLp = new LinkProperties(networkAgent.linkProperties);
        int netId = networkAgent.network.netId;
        if (networkAgent.clatd != null) {
            networkAgent.clatd.fixupLinkProperties(oldLp, newLp);
        }
        this.updateInterfaces(newLp, oldLp, netId, networkAgent.networkCapabilities);
        this.updateMtu(newLp, oldLp);
        this.updateTcpBufferSizes(networkAgent);
        this.updateRoutes(newLp, oldLp, netId);
        this.updateDnses(newLp, oldLp, netId);
        this.mDnsManager.updatePrivateDnsStatus(netId, newLp);
        networkAgent.updateClat(this.mNetd);
        if (this.isDefaultNetwork(networkAgent)) {
            this.handleApplyDefaultProxy(newLp.getHttpProxy());
        } else {
            this.updateProxy(newLp, oldLp, networkAgent);
        }
        if (!Objects.equals(newLp, oldLp)) {
            NetworkAgentInfo networkAgentInfo = networkAgent;
            synchronized (networkAgentInfo) {
                networkAgent.linkProperties = newLp;
            }
            this.notifyIfacesChangedForNetworkStats();
            this.notifyNetworkCallbacks(networkAgent, 524295);
        }
        this.mKeepaliveTracker.handleCheckKeepalivesStillValid(networkAgent);
    }

    private void wakeupModifyInterface(String iface, NetworkCapabilities caps, boolean add) {
        if (!caps.hasTransport(1)) {
            return;
        }
        int mark = this.mContext.getResources().getInteger(17694831);
        int mask = this.mContext.getResources().getInteger(17694832);
        if (mark == 0 || mask == 0) {
            return;
        }
        String prefix = "iface:" + iface;
        try {
            if (add) {
                this.mNetd.getNetdService().wakeupAddInterface(iface, prefix, mark, mask);
            } else {
                this.mNetd.getNetdService().wakeupDelInterface(iface, prefix, mark, mask);
            }
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception modifying wakeup packet monitoring: " + e);
        }
    }

    private void updateInterfaces(LinkProperties newLp, LinkProperties oldLp, int netId, NetworkCapabilities caps) {
        LinkProperties.CompareResult<String> interfaceDiff = new LinkProperties.CompareResult<String>(oldLp != null ? oldLp.getAllInterfaceNames() : null, newLp != null ? newLp.getAllInterfaceNames() : null);
        for (String iface : interfaceDiff.added) {
            try {
                ConnectivityService.log("Adding iface " + iface + " to network " + netId);
                this.mNetd.addInterfaceToNetwork(iface, netId);
                this.wakeupModifyInterface(iface, caps, true);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception adding interface: " + e);
            }
        }
        for (String iface : interfaceDiff.removed) {
            try {
                ConnectivityService.log("Removing iface " + iface + " from network " + netId);
                this.wakeupModifyInterface(iface, caps, false);
                this.mNetd.removeInterfaceFromNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception removing interface: " + e);
            }
        }
    }

    private boolean updateRoutes(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<RouteInfo> routeDiff = new LinkProperties.CompareResult<RouteInfo>(oldLp != null ? oldLp.getAllRoutes() : null, newLp != null ? newLp.getAllRoutes() : null);
        for (RouteInfo route : routeDiff.added) {
            if (route.hasGateway()) continue;
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getDestination().getAddress() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for non-gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.added) {
            if (!route.hasGateway()) continue;
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getGateway() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.removed) {
            try {
                this.mNetd.removeRoute(netId, route);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeRoute: " + e);
            }
        }
        return !routeDiff.added.isEmpty() || !routeDiff.removed.isEmpty();
    }

    private void updateDnses(LinkProperties newLp, LinkProperties oldLp, int netId) {
        if (oldLp != null && newLp.isIdenticalDnses(oldLp)) {
            return;
        }
        NetworkAgentInfo defaultNai = this.getDefaultNetwork();
        boolean isDefaultNetwork = defaultNai != null && defaultNai.network.netId == netId;
        List<InetAddress> dnses = newLp.getDnsServers();
        ConnectivityService.log("Setting DNS servers for network " + netId + " to " + dnses);
        try {
            this.mDnsManager.setDnsConfigurationForNetwork(netId, newLp, isDefaultNetwork);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception in setDnsConfigurationForNetwork: " + e);
        }
    }

    private String getNetworkPermission(NetworkCapabilities nc) {
        if (!nc.hasCapability(13)) {
            return "SYSTEM";
        }
        if (!nc.hasCapability(19)) {
            return "NETWORK";
        }
        return null;
    }

    private NetworkCapabilities mixInCapabilities(NetworkAgentInfo nai, NetworkCapabilities nc) {
        String diff;
        if (nai.everConnected && !nai.isVPN() && !nai.networkCapabilities.satisfiedByImmutableNetworkCapabilities(nc) && !TextUtils.isEmpty(diff = nai.networkCapabilities.describeImmutableDifferences(nc))) {
            Slog.wtf(TAG, "BUG: " + nai + " lost immutable capabilities:" + diff);
        }
        NetworkCapabilities newNc = new NetworkCapabilities(nc);
        if (nai.lastValidated) {
            newNc.addCapability(16);
        } else {
            newNc.removeCapability(16);
        }
        if (nai.lastCaptivePortalDetected) {
            newNc.addCapability(17);
        } else {
            newNc.removeCapability(17);
        }
        if (nai.isBackgroundNetwork()) {
            newNc.removeCapability(19);
        } else {
            newNc.addCapability(19);
        }
        if (nai.isSuspended()) {
            newNc.removeCapability(21);
        } else {
            newNc.addCapability(21);
        }
        return newNc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilities(int oldScore, NetworkAgentInfo nai, NetworkCapabilities nc) {
        NetworkCapabilities prevNc;
        String newPermission;
        NetworkCapabilities newNc = this.mixInCapabilities(nai, nc);
        if (Objects.equals(nai.networkCapabilities, newNc)) {
            return;
        }
        String oldPermission = this.getNetworkPermission(nai.networkCapabilities);
        if (!Objects.equals(oldPermission, newPermission = this.getNetworkPermission(newNc)) && nai.created && !nai.isVPN()) {
            try {
                this.mNetd.setNetworkPermission(nai.network.netId, newPermission);
            }
            catch (RemoteException e) {
                ConnectivityService.loge("Exception in setNetworkPermission: " + e);
            }
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            prevNc = nai.networkCapabilities;
            nai.networkCapabilities = newNc;
        }
        this.updateUids(nai, prevNc, newNc);
        if (nai.getCurrentScore() == oldScore && newNc.equalRequestableCapabilities(prevNc)) {
            this.processListenRequests(nai, true);
        } else {
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.notifyNetworkCallbacks(nai, 524294);
        }
        if (prevNc != null) {
            boolean roamingChanged;
            boolean meteredChanged = prevNc.hasCapability(11) != newNc.hasCapability(11);
            boolean bl = roamingChanged = prevNc.hasCapability(18) != newNc.hasCapability(18);
            if (meteredChanged || roamingChanged) {
                this.notifyIfacesChangedForNetworkStats();
            }
        }
        if (!newNc.hasTransport(4)) {
            this.updateAllVpnsCapabilities();
        }
    }

    private void updateUids(NetworkAgentInfo nai, NetworkCapabilities prevNc, NetworkCapabilities newNc) {
        Set<UidRange> newRanges;
        Set<UidRange> prevRanges = null == prevNc ? null : prevNc.getUids();
        Set<UidRange> set = newRanges = null == newNc ? null : newNc.getUids();
        if (null == prevRanges) {
            prevRanges = new ArraySet<UidRange>();
        }
        if (null == newRanges) {
            newRanges = new ArraySet<UidRange>();
        }
        ArraySet<UidRange> prevRangesCopy = new ArraySet<UidRange>(prevRanges);
        prevRanges.removeAll(newRanges);
        newRanges.removeAll(prevRangesCopy);
        try {
            if (!newRanges.isEmpty()) {
                UidRange[] addedRangesArray = new UidRange[newRanges.size()];
                newRanges.toArray(addedRangesArray);
                this.mNetd.addVpnUidRanges(nai.network.netId, addedRangesArray);
            }
            if (!prevRanges.isEmpty()) {
                UidRange[] removedRangesArray = new UidRange[prevRanges.size()];
                prevRanges.toArray(removedRangesArray);
                this.mNetd.removeVpnUidRanges(nai.network.netId, removedRangesArray);
            }
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception in updateUids: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateLinkProperties(NetworkAgentInfo nai, LinkProperties newLp) {
        if (this.getNetworkAgentInfoForNetId(nai.network.netId) != nai) {
            return;
        }
        newLp.ensureDirectlyConnectedRoutes();
        LinkProperties oldLp = nai.linkProperties;
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            nai.linkProperties = newLp;
        }
        if (nai.everConnected) {
            this.updateLinkProperties(nai, oldLp);
        }
    }

    private void sendUpdatedScoreToFactories(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.numNetworkRequests(); ++i) {
            NetworkRequest nr = nai.requestAt(i);
            if (nr.isListen()) continue;
            this.sendUpdatedScoreToFactories(nr, nai.getCurrentScore());
        }
    }

    private void sendUpdatedScoreToFactories(NetworkRequest networkRequest, int score) {
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            nfi.asyncChannel.sendMessage(536576, score, 0, networkRequest);
        }
    }

    private void sendPendingIntentForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType) {
        if (notificationType == 524290 && !nri.mPendingIntentSent) {
            Intent intent = new Intent();
            intent.putExtra("android.net.extra.NETWORK", networkAgent.network);
            intent.putExtra("android.net.extra.NETWORK_REQUEST", nri.request);
            nri.mPendingIntentSent = true;
            this.sendIntent(nri.mPendingIntent, intent);
        }
    }

    private void sendIntent(PendingIntent pendingIntent, Intent intent) {
        this.mPendingIntentWakeLock.acquire();
        try {
            ConnectivityService.log("Sending " + pendingIntent);
            pendingIntent.send(this.mContext, 0, intent, this, null);
        }
        catch (PendingIntent.CanceledException e) {
            ConnectivityService.log(pendingIntent + " was not sent, it had been canceled.");
            this.mPendingIntentWakeLock.release();
            this.releasePendingNetworkRequest(pendingIntent);
        }
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        ConnectivityService.log("Finished sending " + pendingIntent);
        this.mPendingIntentWakeLock.release();
        this.releasePendingNetworkRequestWithDelay(pendingIntent);
    }

    private void callCallbackForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType, int arg1) {
        if (nri.messenger == null) {
            return;
        }
        Bundle bundle = new Bundle();
        ConnectivityService.putParcelable(bundle, new NetworkRequest(nri.request));
        Message msg = Message.obtain();
        if (notificationType != 524293) {
            ConnectivityService.putParcelable(bundle, networkAgent.network);
        }
        switch (notificationType) {
            case 524290: {
                ConnectivityService.putParcelable(bundle, new NetworkCapabilities(networkAgent.networkCapabilities));
                ConnectivityService.putParcelable(bundle, new LinkProperties(networkAgent.linkProperties));
                break;
            }
            case 524291: {
                msg.arg1 = arg1;
                break;
            }
            case 524294: {
                NetworkCapabilities nc = this.networkCapabilitiesRestrictedForCallerPermissions(networkAgent.networkCapabilities, nri.mPid, nri.mUid);
                ConnectivityService.putParcelable(bundle, nc);
                break;
            }
            case 524295: {
                ConnectivityService.putParcelable(bundle, new LinkProperties(networkAgent.linkProperties));
            }
        }
        msg.what = notificationType;
        msg.setData(bundle);
        try {
            nri.messenger.send(msg);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("RemoteException caught trying to send a callback msg for " + nri.request);
        }
    }

    private static <T extends Parcelable> void putParcelable(Bundle bundle, T t) {
        bundle.putParcelable(t.getClass().getSimpleName(), t);
    }

    private void teardownUnneededNetwork(NetworkAgentInfo nai) {
        if (nai.numRequestNetworkRequests() != 0) {
            for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                NetworkRequest nr = nai.requestAt(i);
                if (nr.isListen()) continue;
                ConnectivityService.loge("Dead network still had at least " + nr);
                break;
            }
        }
        nai.asyncChannel.disconnect();
    }

    private void handleLingerComplete(NetworkAgentInfo oldNetwork) {
        if (oldNetwork == null) {
            ConnectivityService.loge("Unknown NetworkAgentInfo in handleLingerComplete");
            return;
        }
        ConnectivityService.log("handleLingerComplete for " + oldNetwork.name());
        oldNetwork.clearLingerState();
        if (this.unneeded(oldNetwork, UnneededFor.TEARDOWN)) {
            this.teardownUnneededNetwork(oldNetwork);
        } else {
            this.updateCapabilities(oldNetwork.getCurrentScore(), oldNetwork, oldNetwork.networkCapabilities);
        }
    }

    private void makeDefault(NetworkAgentInfo newNetwork) {
        ConnectivityService.log("Switching to new default network: " + newNetwork);
        this.setupDataActivityTracking(newNetwork);
        try {
            this.mNetd.setDefaultNetId(newNetwork.network.netId);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception setting default network :" + e);
        }
        this.notifyLockdownVpn(newNetwork);
        this.handleApplyDefaultProxy(newNetwork.linkProperties.getHttpProxy());
        this.updateTcpBufferSizes(newNetwork);
        this.mDnsManager.setDefaultDnsSystemProperties(newNetwork.linkProperties.getDnsServers());
        this.notifyIfacesChangedForNetworkStats();
    }

    private void processListenRequests(NetworkAgentInfo nai, boolean capabilitiesChanged) {
        NetworkRequest nr;
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            nr = nri.request;
            if (!nr.isListen() || !nai.isSatisfyingRequest(nr.requestId) || nai.satisfies(nr)) continue;
            nai.removeRequest(nri.request.requestId);
            this.callCallbackForRequest(nri, nai, 524292, 0);
        }
        if (capabilitiesChanged) {
            this.notifyNetworkCallbacks(nai, 524294);
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            nr = nri.request;
            if (!nr.isListen() || !nai.satisfies(nr) || nai.isSatisfyingRequest(nr.requestId)) continue;
            nai.addRequest(nr);
            this.notifyNetworkAvailable(nai, nri);
        }
    }

    private void rematchNetworkAndRequests(NetworkAgentInfo newNetwork, ReapUnvalidatedNetworks reapUnvalidatedNetworks, long now) {
        if (!newNetwork.everConnected) {
            return;
        }
        boolean keep = newNetwork.isVPN();
        boolean isNewDefault = false;
        NetworkAgentInfo oldDefaultNetwork = null;
        boolean wasBackgroundNetwork = newNetwork.isBackgroundNetwork();
        int score = newNetwork.getCurrentScore();
        ArrayList<NetworkAgentInfo> affectedNetworks = new ArrayList<NetworkAgentInfo>();
        ArrayList<NetworkRequestInfo> addedRequests = new ArrayList<NetworkRequestInfo>();
        NetworkCapabilities nc = newNetwork.networkCapabilities;
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            if (nri.request.isListen()) continue;
            NetworkAgentInfo currentNetwork = this.getNetworkForRequest(nri.request.requestId);
            boolean satisfies = newNetwork.satisfies(nri.request);
            if (newNetwork == currentNetwork && satisfies) {
                keep = true;
                continue;
            }
            if (satisfies) {
                if (currentNetwork != null && currentNetwork.getCurrentScore() >= score) continue;
                if (currentNetwork != null) {
                    currentNetwork.removeRequest(nri.request.requestId);
                    currentNetwork.lingerRequest(nri.request, now, this.mLingerDelayMs);
                    affectedNetworks.add(currentNetwork);
                }
                newNetwork.unlingerRequest(nri.request);
                this.setNetworkForRequest(nri.request.requestId, newNetwork);
                if (!newNetwork.addRequest(nri.request)) {
                    Slog.wtf(TAG, "BUG: " + newNetwork.name() + " already has " + nri.request);
                }
                addedRequests.add(nri);
                keep = true;
                this.sendUpdatedScoreToFactories(nri.request, score);
                if (!this.isDefaultRequest(nri)) continue;
                isNewDefault = true;
                oldDefaultNetwork = currentNetwork;
                if (currentNetwork == null) continue;
                this.mLingerMonitor.noteLingerDefaultNetwork(currentNetwork, newNetwork);
                continue;
            }
            if (!newNetwork.isSatisfyingRequest(nri.request.requestId)) continue;
            ConnectivityService.log("Network " + newNetwork.name() + " stopped satisfying request " + nri.request.requestId);
            newNetwork.removeRequest(nri.request.requestId);
            if (currentNetwork == newNetwork) {
                this.clearNetworkForRequest(nri.request.requestId);
                this.sendUpdatedScoreToFactories(nri.request, 0);
            } else {
                Slog.wtf(TAG, "BUG: Removing request " + nri.request.requestId + " from " + newNetwork.name() + " without updating mNetworkForRequestId or factories!");
            }
            this.callCallbackForRequest(nri, newNetwork, 524292, 0);
        }
        if (isNewDefault) {
            this.makeDefault(newNetwork);
            this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkEvent(now, newNetwork, oldDefaultNetwork);
            this.scheduleReleaseNetworkTransitionWakelock();
        }
        if (!newNetwork.networkCapabilities.equalRequestableCapabilities(nc)) {
            Slog.wtf(TAG, String.format("BUG: %s changed requestable capabilities during rematch: %s -> %s", newNetwork.name(), nc, newNetwork.networkCapabilities));
        }
        if (newNetwork.getCurrentScore() != score) {
            Slog.wtf(TAG, String.format("BUG: %s changed score during rematch: %d -> %d", newNetwork.name(), score, newNetwork.getCurrentScore()));
        }
        if (wasBackgroundNetwork != newNetwork.isBackgroundNetwork()) {
            this.updateCapabilities(score, newNetwork, newNetwork.networkCapabilities);
        } else {
            this.processListenRequests(newNetwork, false);
        }
        for (NetworkRequestInfo nri : addedRequests) {
            this.notifyNetworkAvailable(newNetwork, nri);
        }
        for (NetworkAgentInfo nai : affectedNetworks) {
            this.updateLingerState(nai, now);
        }
        this.updateLingerState(newNetwork, now);
        if (isNewDefault) {
            if (oldDefaultNetwork != null) {
                this.mLegacyTypeTracker.remove(oldDefaultNetwork.networkInfo.getType(), oldDefaultNetwork, true);
            }
            this.mDefaultInetConditionPublished = newNetwork.lastValidated ? 100 : 0;
            this.mLegacyTypeTracker.add(newNetwork.networkInfo.getType(), newNetwork);
            this.notifyLockdownVpn(newNetwork);
        }
        if (keep) {
            try {
                IBatteryStats bs = BatteryStatsService.getService();
                int type = newNetwork.networkInfo.getType();
                String baseIface = newNetwork.linkProperties.getInterfaceName();
                bs.noteNetworkInterfaceType(baseIface, type);
                for (LinkProperties stacked : newNetwork.linkProperties.getStackedLinks()) {
                    String stackedIface = stacked.getInterfaceName();
                    bs.noteNetworkInterfaceType(stackedIface, type);
                }
            }
            catch (RemoteException bs) {
                // empty catch block
            }
            for (int i = 0; i < newNetwork.numNetworkRequests(); ++i) {
                NetworkRequest nr = newNetwork.requestAt(i);
                if (nr.legacyType == -1 || !nr.isRequest()) continue;
                this.mLegacyTypeTracker.add(nr.legacyType, newNetwork);
            }
            if (newNetwork.isVPN()) {
                this.mLegacyTypeTracker.add(17, newNetwork);
            }
        }
        if (reapUnvalidatedNetworks == ReapUnvalidatedNetworks.REAP) {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                if (!this.unneeded(nai, UnneededFor.TEARDOWN)) continue;
                if (nai.getLingerExpiry() > 0L) {
                    this.updateLingerState(nai, now);
                    continue;
                }
                ConnectivityService.log("Reaping " + nai.name());
                this.teardownUnneededNetwork(nai);
            }
        }
    }

    private void rematchAllNetworksAndRequests(NetworkAgentInfo changed, int oldScore) {
        long now = SystemClock.elapsedRealtime();
        if (changed != null && oldScore < changed.getCurrentScore()) {
            this.rematchNetworkAndRequests(changed, ReapUnvalidatedNetworks.REAP, now);
        } else {
            Object[] nais = this.mNetworkAgentInfos.values().toArray(new NetworkAgentInfo[this.mNetworkAgentInfos.size()]);
            Arrays.sort(nais);
            for (Object nai : nais) {
                this.rematchNetworkAndRequests((NetworkAgentInfo)nai, nai != nais[nais.length - 1] ? ReapUnvalidatedNetworks.DONT_REAP : ReapUnvalidatedNetworks.REAP, now);
            }
        }
    }

    private void updateInetCondition(NetworkAgentInfo nai) {
        int newInetCondition;
        if (!nai.everValidated) {
            return;
        }
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        int n = newInetCondition = nai.lastValidated ? 100 : 0;
        if (newInetCondition == this.mDefaultInetConditionPublished) {
            return;
        }
        this.mDefaultInetConditionPublished = newInetCondition;
        this.sendInetConditionBroadcast(nai.networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLockdownVpn(NetworkAgentInfo nai) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                if (nai != null && nai.isVPN()) {
                    this.mLockdownTracker.onVpnStateChanged(nai.networkInfo);
                } else {
                    this.mLockdownTracker.onNetworkInfoChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkInfo(NetworkAgentInfo networkAgent, NetworkInfo newInfo) {
        NetworkInfo.State state = newInfo.getState();
        NetworkInfo oldInfo = null;
        int oldScore = networkAgent.getCurrentScore();
        Object object = networkAgent;
        synchronized (object) {
            oldInfo = networkAgent.networkInfo;
            networkAgent.networkInfo = newInfo;
        }
        this.notifyLockdownVpn(networkAgent);
        ConnectivityService.log(networkAgent.name() + " EVENT_NETWORK_INFO_CHANGED, going from " + (oldInfo == null ? "null" : oldInfo.getState()) + " to " + (Object)((Object)state));
        if (!networkAgent.created && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING && networkAgent.isVPN())) {
            networkAgent.networkCapabilities.addCapability(19);
            try {
                if (networkAgent.isVPN()) {
                    this.mNetd.createVirtualNetwork(networkAgent.network.netId, !networkAgent.linkProperties.getDnsServers().isEmpty(), networkAgent.networkMisc == null || !networkAgent.networkMisc.allowBypass);
                } else {
                    this.mNetd.createPhysicalNetwork(networkAgent.network.netId, this.getNetworkPermission(networkAgent.networkCapabilities));
                }
            }
            catch (Exception e) {
                ConnectivityService.loge("Error creating network " + networkAgent.network.netId + ": " + e.getMessage());
                return;
            }
            networkAgent.created = true;
        }
        if (!networkAgent.everConnected && state == NetworkInfo.State.CONNECTED) {
            networkAgent.everConnected = true;
            this.handlePerNetworkPrivateDnsConfig(networkAgent, this.mDnsManager.getPrivateDnsConfig());
            this.updateLinkProperties(networkAgent, null);
            this.notifyIfacesChangedForNetworkStats();
            networkAgent.networkMonitor.sendMessage(532481);
            this.scheduleUnvalidatedPrompt(networkAgent);
            if (networkAgent.isVPN()) {
                Object e = this.mProxyLock;
                synchronized (e) {
                    if (!this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = true;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(null);
                        }
                    }
                }
            }
            this.updateSignalStrengthThresholds(networkAgent, "CONNECT", null);
            long now = SystemClock.elapsedRealtime();
            this.rematchNetworkAndRequests(networkAgent, ReapUnvalidatedNetworks.REAP, now);
            this.notifyNetworkCallbacks(networkAgent, 524289);
        } else if (state == NetworkInfo.State.DISCONNECTED) {
            networkAgent.asyncChannel.disconnect();
            if (networkAgent.isVPN()) {
                object = this.mProxyLock;
                synchronized (object) {
                    if (this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = false;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(this.mDefaultProxy);
                        }
                    }
                }
                this.updateUids(networkAgent, networkAgent.networkCapabilities, null);
            }
            this.disconnectAndDestroyNetwork(networkAgent);
        } else if (oldInfo != null && oldInfo.getState() == NetworkInfo.State.SUSPENDED || state == NetworkInfo.State.SUSPENDED) {
            if (networkAgent.getCurrentScore() != oldScore) {
                this.rematchAllNetworksAndRequests(networkAgent, oldScore);
            }
            this.updateCapabilities(networkAgent.getCurrentScore(), networkAgent, networkAgent.networkCapabilities);
            this.notifyNetworkCallbacks(networkAgent, state == NetworkInfo.State.SUSPENDED ? 524297 : 524298);
            this.mLegacyTypeTracker.update(networkAgent);
        }
    }

    private void updateNetworkScore(NetworkAgentInfo nai, int score) {
        if (score < 0) {
            ConnectivityService.loge("updateNetworkScore for " + nai.name() + " got a negative score (" + score + ").  Bumping score to min of 0");
            score = 0;
        }
        int oldScore = nai.getCurrentScore();
        nai.setCurrentScore(score);
        this.rematchAllNetworksAndRequests(nai, oldScore);
        this.sendUpdatedScoreToFactories(nai);
    }

    protected void notifyNetworkAvailable(NetworkAgentInfo nai, NetworkRequestInfo nri) {
        this.mHandler.removeMessages(20, nri);
        if (nri.mPendingIntent != null) {
            this.sendPendingIntentForRequest(nri, nai, 524290);
            return;
        }
        this.callCallbackForRequest(nri, nai, 524290, 0);
    }

    private void sendLegacyNetworkBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type) {
        NetworkInfo info = new NetworkInfo(nai.networkInfo);
        info.setType(type);
        if (state != NetworkInfo.DetailedState.DISCONNECTED) {
            info.setDetailedState(state, null, info.getExtraInfo());
            this.sendConnectedBroadcast(info);
        } else {
            info.setDetailedState(state, info.getReason(), info.getExtraInfo());
            Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
            intent.putExtra("networkInfo", info);
            intent.putExtra("networkType", info.getType());
            if (info.isFailover()) {
                intent.putExtra("isFailover", true);
                nai.networkInfo.setFailover(false);
            }
            if (info.getReason() != null) {
                intent.putExtra("reason", info.getReason());
            }
            if (info.getExtraInfo() != null) {
                intent.putExtra("extraInfo", info.getExtraInfo());
            }
            NetworkAgentInfo newDefaultAgent = null;
            if (nai.isSatisfyingRequest(this.mDefaultRequest.requestId)) {
                newDefaultAgent = this.getDefaultNetwork();
                if (newDefaultAgent != null) {
                    intent.putExtra("otherNetwork", newDefaultAgent.networkInfo);
                } else {
                    intent.putExtra("noConnectivity", true);
                }
            }
            intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
            this.sendStickyBroadcast(intent);
            if (newDefaultAgent != null) {
                this.sendConnectedBroadcast(newDefaultAgent.networkInfo);
            }
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType, int arg1) {
        for (int i = 0; i < networkAgent.numNetworkRequests(); ++i) {
            NetworkRequest nr = networkAgent.requestAt(i);
            NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
            if (nri.mPendingIntent == null) {
                this.callCallbackForRequest(nri, networkAgent, notifyType, arg1);
                continue;
            }
            this.sendPendingIntentForRequest(nri, networkAgent, notifyType);
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType) {
        this.notifyNetworkCallbacks(networkAgent, notifyType, 0);
    }

    private Network[] getDefaultNetworks() {
        ArrayList<Network> defaultNetworks = new ArrayList<Network>();
        NetworkAgentInfo defaultNetwork = this.getDefaultNetwork();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            if (!nai.everConnected || nai != defaultNetwork && !nai.isVPN()) continue;
            defaultNetworks.add(nai.network);
        }
        return defaultNetworks.toArray(new Network[0]);
    }

    private void notifyIfacesChangedForNetworkStats() {
        try {
            this.mStatsService.forceUpdateIfaces(this.getDefaultNetworks());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVpnAddress(String address, int prefixLength) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).addAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVpnAddress(String address, int prefixLength) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).removeAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setUnderlyingNetworksForVpn(Network[] networks) {
        boolean success;
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            success = this.mVpns.get(user).setUnderlyingNetworks(networks);
        }
        if (success) {
            this.mHandler.post(() -> this.notifyIfacesChangedForNetworkStats());
        }
        return success;
    }

    @Override
    public String getCaptivePortalServerUrl() {
        this.enforceConnectivityInternalPermission();
        return NetworkMonitor.getCaptivePortalServerHttpUrl(this.mContext);
    }

    @Override
    public void startNattKeepalive(Network network, int intervalSeconds, Messenger messenger, IBinder binder, String srcAddr, int srcPort, String dstAddr) {
        this.enforceKeepalivePermission();
        this.mKeepaliveTracker.startNattKeepalive(this.getNetworkAgentInfoForNetwork(network), intervalSeconds, messenger, binder, srcAddr, srcPort, dstAddr, 4500);
    }

    @Override
    public void stopKeepalive(Network network, int slot) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(528396, slot, 0, network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void factoryReset() {
        this.enforceConnectivityInternalPermission();
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        this.setAirplaneMode(false);
        if (!this.mUserManager.hasUserRestriction("no_config_tethering")) {
            String pkgName = this.mContext.getOpPackageName();
            for (String tether : this.getTetheredIfaces()) {
                this.untether(tether, pkgName);
            }
        }
        if (!this.mUserManager.hasUserRestriction("no_config_vpn")) {
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                VpnConfig vpnConfig;
                String alwaysOnPackage = this.getAlwaysOnVpnPackage(userId);
                if (alwaysOnPackage != null) {
                    this.setAlwaysOnVpnPackage(userId, null, false);
                    this.setVpnPackageAuthorization(alwaysOnPackage, userId, false);
                }
                if (this.mLockdownEnabled && userId == 0) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mKeyStore.delete("LOCKDOWN_VPN");
                        this.mLockdownEnabled = false;
                        this.setLockdownTracker(null);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                if ((vpnConfig = this.getVpnConfig(userId)) != null) {
                    if (vpnConfig.legacy) {
                        this.prepareVpn("[Legacy VPN]", "[Legacy VPN]", userId);
                    } else {
                        this.setVpnPackageAuthorization(vpnConfig.user, userId, false);
                        this.prepareVpn(null, "[Legacy VPN]", userId);
                    }
                }
            }
        }
        Settings.Global.putString(this.mContext.getContentResolver(), "network_avoid_bad_wifi", null);
    }

    @Override
    public byte[] getNetworkWatchlistConfigHash() {
        NetworkWatchlistManager nwm = this.mContext.getSystemService(NetworkWatchlistManager.class);
        if (nwm == null) {
            ConnectivityService.loge("Unable to get NetworkWatchlistManager");
            return null;
        }
        return nwm.getWatchlistConfigHash();
    }

    @VisibleForTesting
    public NetworkMonitor createNetworkMonitor(Context context, Handler handler, NetworkAgentInfo nai, NetworkRequest defaultRequest) {
        return new NetworkMonitor(context, handler, nai, defaultRequest);
    }

    @VisibleForTesting
    MultinetworkPolicyTracker createMultinetworkPolicyTracker(Context c, Handler h, Runnable r) {
        return new MultinetworkPolicyTracker(c, h, r);
    }

    @VisibleForTesting
    public WakeupMessage makeWakeupMessage(Context c, Handler h, String s, int cmd, Object obj) {
        return new WakeupMessage(c, h, s, cmd, 0, 0, obj);
    }

    @VisibleForTesting
    public boolean hasService(String name) {
        return ServiceManager.checkService(name) != null;
    }

    @VisibleForTesting
    protected IpConnectivityMetrics.Logger metricsLogger() {
        return Preconditions.checkNotNull(LocalServices.getService(IpConnectivityMetrics.Logger.class), "no IpConnectivityMetrics service");
    }

    private void logNetworkEvent(NetworkAgentInfo nai, int evtype) {
        int[] transports = nai.networkCapabilities.getTransportTypes();
        this.mMetricsLog.log(nai.network.netId, transports, new NetworkEvent(evtype));
    }

    private static boolean toBool(int encodedBoolean) {
        return encodedBoolean != 0;
    }

    private static int encodeBool(boolean b) {
        return b ? 1 : 0;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new ShellCmd().exec(this, in, out, err, args, callback, resultReceiver);
    }

    static {
        sMagicDecoderRing = MessageUtils.findMessageNames(new Class[]{AsyncChannel.class, ConnectivityService.class, NetworkAgent.class, NetworkAgentInfo.class});
    }

    private class ShellCmd
    extends ShellCommand {
        private ShellCmd() {
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "airplane-mode": {
                        String action = this.getNextArg();
                        if ("enable".equals(action)) {
                            ConnectivityService.this.setAirplaneMode(true);
                            return 0;
                        }
                        if ("disable".equals(action)) {
                            ConnectivityService.this.setAirplaneMode(false);
                            return 0;
                        }
                        if (action == null) {
                            ContentResolver cr = ConnectivityService.this.mContext.getContentResolver();
                            int enabled = Settings.Global.getInt(cr, "airplane_mode_on");
                            pw.println(enabled == 0 ? "disabled" : "enabled");
                            return 0;
                        }
                        this.onHelp();
                        return -1;
                    }
                }
                return this.handleDefaultCommands(cmd);
            }
            catch (Exception e) {
                pw.println(e);
                return -1;
            }
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Connectivity service commands:");
            pw.println("  help");
            pw.println("    Print this help text.");
            pw.println("  airplane-mode [enable|disable]");
            pw.println("    Turn airplane mode on or off.");
            pw.println("  airplane-mode");
            pw.println("    Get airplane mode.");
        }
    }

    private class NetworkRequestInfo
    implements IBinder.DeathRecipient {
        final NetworkRequest request;
        final PendingIntent mPendingIntent;
        boolean mPendingIntentSent;
        private final IBinder mBinder;
        final int mPid;
        final int mUid;
        final Messenger messenger;

        NetworkRequestInfo(NetworkRequest r, PendingIntent pi) {
            this.request = r;
            ConnectivityService.this.ensureNetworkRequestHasType(this.request);
            this.mPendingIntent = pi;
            this.messenger = null;
            this.mBinder = null;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.enforceRequestCountLimit();
        }

        NetworkRequestInfo(Messenger m, NetworkRequest r, IBinder binder) {
            this.messenger = m;
            this.request = r;
            ConnectivityService.this.ensureNetworkRequestHasType(this.request);
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mPendingIntent = null;
            this.enforceRequestCountLimit();
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enforceRequestCountLimit() {
            SparseIntArray sparseIntArray = ConnectivityService.this.mUidToNetworkRequestCount;
            synchronized (sparseIntArray) {
                int networkRequests = ConnectivityService.this.mUidToNetworkRequestCount.get(this.mUid, 0) + 1;
                if (networkRequests >= 100) {
                    throw new ServiceSpecificException(1);
                }
                ConnectivityService.this.mUidToNetworkRequestCount.put(this.mUid, networkRequests);
            }
        }

        void unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        @Override
        public void binderDied() {
            ConnectivityService.log("ConnectivityService NetworkRequestInfo binderDied(" + this.request + ", " + this.mBinder + ")");
            ConnectivityService.this.releaseNetworkRequest(this.request);
        }

        public String toString() {
            return "uid/pid:" + this.mUid + "/" + this.mPid + " " + this.request + (this.mPendingIntent == null ? "" : " to trigger " + this.mPendingIntent);
        }
    }

    private static class NetworkFactoryInfo {
        public final String name;
        public final Messenger messenger;
        public final AsyncChannel asyncChannel;

        public NetworkFactoryInfo(String name, Messenger messenger, AsyncChannel asyncChannel) {
            this.name = name;
            this.messenger = messenger;
            this.asyncChannel = asyncChannel;
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final HashMap<Uri, Integer> mUriEventMap = new HashMap();
        private final Context mContext;
        private final Handler mHandler;

        SettingsObserver(Context context, Handler handler) {
            super(null);
            this.mContext = context;
            this.mHandler = handler;
        }

        void observe(Uri uri, int what) {
            this.mUriEventMap.put(uri, what);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(uri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            Slog.wtf(TAG, "Should never be reached.");
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Integer what = this.mUriEventMap.get(uri);
            if (what != null) {
                this.mHandler.obtainMessage(what).sendToTarget();
            } else {
                ConnectivityService.loge("No matching event to send for URI=" + uri);
            }
        }
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: 
                case 24: {
                    ConnectivityService.this.handleReleaseNetworkTransitionWakelock(msg.what);
                    break;
                }
                case 9: {
                    ConnectivityService.this.handleDeprecatedGlobalHttpProxy();
                    break;
                }
                case 16: {
                    ConnectivityService.this.handleApplyDefaultProxy((ProxyInfo)msg.obj);
                    break;
                }
                case 17: {
                    ConnectivityService.this.handleRegisterNetworkFactory((NetworkFactoryInfo)msg.obj);
                    break;
                }
                case 23: {
                    ConnectivityService.this.handleUnregisterNetworkFactory((Messenger)msg.obj);
                    break;
                }
                case 18: {
                    ConnectivityService.this.handleRegisterNetworkAgent((NetworkAgentInfo)msg.obj);
                    break;
                }
                case 19: 
                case 21: {
                    ConnectivityService.this.handleRegisterNetworkRequest((NetworkRequestInfo)msg.obj);
                    break;
                }
                case 26: 
                case 31: {
                    ConnectivityService.this.handleRegisterNetworkRequestWithIntent(msg);
                    break;
                }
                case 20: {
                    NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
                    ConnectivityService.this.handleTimedOutNetworkRequest(nri);
                    break;
                }
                case 27: {
                    ConnectivityService.this.handleReleaseNetworkRequestWithIntent((PendingIntent)msg.obj, msg.arg1);
                    break;
                }
                case 22: {
                    ConnectivityService.this.handleReleaseNetworkRequest((NetworkRequest)msg.obj, msg.arg1);
                    break;
                }
                case 28: {
                    Network network = (Network)msg.obj;
                    ConnectivityService.this.handleSetAcceptUnvalidated(network, ConnectivityService.toBool(msg.arg1), ConnectivityService.toBool(msg.arg2));
                    break;
                }
                case 35: {
                    ConnectivityService.this.handleSetAvoidUnvalidated((Network)msg.obj);
                    break;
                }
                case 29: {
                    ConnectivityService.this.handlePromptUnvalidated((Network)msg.obj);
                    break;
                }
                case 30: {
                    ConnectivityService.this.handleMobileDataAlwaysOn();
                    break;
                }
                case 528395: {
                    ConnectivityService.this.mKeepaliveTracker.handleStartKeepalive(msg);
                    break;
                }
                case 528396: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetwork((Network)msg.obj);
                    int slot = msg.arg1;
                    int reason = msg.arg2;
                    ConnectivityService.this.mKeepaliveTracker.handleStopKeepalive(nai, slot, reason);
                    break;
                }
                case 25: {
                    for (NetworkAgentInfo nai : ConnectivityService.this.mNetworkAgentInfos.values()) {
                        nai.networkMonitor.systemReady = true;
                    }
                    ConnectivityService.this.mMultipathPolicyTracker.start();
                    break;
                }
                case 36: {
                    ConnectivityService.this.handleReportNetworkConnectivity((Network)msg.obj, msg.arg1, ConnectivityService.toBool(msg.arg2));
                    break;
                }
                case 37: {
                    ConnectivityService.this.handlePrivateDnsSettingsChanged();
                    break;
                }
                case 38: {
                    ConnectivityService.this.handlePrivateDnsValidationUpdate((DnsManager.PrivateDnsValidationUpdate)msg.obj);
                }
            }
        }
    }

    private class NetworkStateTrackerHandler
    extends Handler {
        public NetworkStateTrackerHandler(Looper looper) {
            super(looper);
        }

        private boolean maybeHandleAsyncChannelMessage(Message msg) {
            switch (msg.what) {
                default: {
                    return false;
                }
                case 69632: {
                    ConnectivityService.this.handleAsyncChannelHalfConnect(msg);
                    break;
                }
                case 69635: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) break;
                    nai.asyncChannel.disconnect();
                    break;
                }
                case 69636: {
                    ConnectivityService.this.handleAsyncChannelDisconnected(msg);
                }
            }
            return true;
        }

        private void maybeHandleNetworkAgentMessage(Message msg) {
            NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
            if (nai == null) {
                return;
            }
            switch (msg.what) {
                case 528386: {
                    NetworkCapabilities networkCapabilities = (NetworkCapabilities)msg.obj;
                    if (networkCapabilities.hasCapability(17) || networkCapabilities.hasCapability(16) || networkCapabilities.hasCapability(19)) {
                        Slog.wtf(TAG, "BUG: " + nai + " has CS-managed capability.");
                    }
                    ConnectivityService.this.updateCapabilities(nai.getCurrentScore(), nai, networkCapabilities);
                    break;
                }
                case 528387: {
                    ConnectivityService.this.handleUpdateLinkProperties(nai, (LinkProperties)msg.obj);
                    break;
                }
                case 528385: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.updateNetworkInfo(nai, info);
                    break;
                }
                case 528388: {
                    Integer score = (Integer)msg.obj;
                    if (score == null) break;
                    ConnectivityService.this.updateNetworkScore(nai, score);
                    break;
                }
                case 528392: {
                    if (nai.everConnected && !nai.networkMisc.explicitlySelected) {
                        ConnectivityService.loge("ERROR: already-connected network explicitly selected.");
                    }
                    nai.networkMisc.explicitlySelected = true;
                    nai.networkMisc.acceptUnvalidated = (Boolean)msg.obj;
                    break;
                }
                case 528397: {
                    ConnectivityService.this.mKeepaliveTracker.handleEventPacketKeepalive(nai, msg);
                }
            }
        }

        private boolean maybeHandleNetworkMonitorMessage(Message msg) {
            switch (msg.what) {
                default: {
                    return false;
                }
                case 532482: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(msg.arg2);
                    if (nai == null) break;
                    boolean valid = msg.arg1 == 0;
                    boolean wasValidated = nai.lastValidated;
                    boolean wasDefault = ConnectivityService.this.isDefaultNetwork(nai);
                    String redirectUrl = msg.obj instanceof String ? (String)msg.obj : "";
                    String logMsg = !TextUtils.isEmpty(redirectUrl) ? " with redirect to " + redirectUrl : "";
                    ConnectivityService.log(nai.name() + " validation " + (valid ? "passed" : "failed") + logMsg);
                    if (valid != nai.lastValidated) {
                        if (wasDefault) {
                            ConnectivityService.this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkValidity(SystemClock.elapsedRealtime(), valid);
                        }
                        int oldScore = nai.getCurrentScore();
                        nai.lastValidated = valid;
                        nai.everValidated |= valid;
                        ConnectivityService.this.updateCapabilities(oldScore, nai, nai.networkCapabilities);
                        if (oldScore != nai.getCurrentScore()) {
                            ConnectivityService.this.sendUpdatedScoreToFactories(nai);
                        }
                        if (valid) {
                            ConnectivityService.this.handleFreshlyValidatedNetwork(nai);
                        }
                    }
                    ConnectivityService.this.updateInetCondition(nai);
                    Bundle redirectUrlBundle = new Bundle();
                    redirectUrlBundle.putString(NetworkAgent.REDIRECT_URL_KEY, redirectUrl);
                    nai.asyncChannel.sendMessage(528391, valid ? 1 : 2, 0, redirectUrlBundle);
                    if (!wasValidated || nai.lastValidated) break;
                    ConnectivityService.this.handleNetworkUnvalidated(nai);
                    break;
                }
                case 532490: {
                    int netId = msg.arg2;
                    boolean visible = ConnectivityService.toBool(msg.arg1);
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(netId);
                    if (nai != null && visible != nai.lastCaptivePortalDetected) {
                        int oldScore = nai.getCurrentScore();
                        nai.lastCaptivePortalDetected = visible;
                        nai.everCaptivePortalDetected |= visible;
                        if (nai.lastCaptivePortalDetected && 2 == this.getCaptivePortalMode()) {
                            ConnectivityService.log("Avoiding captive portal network: " + nai.name());
                            nai.asyncChannel.sendMessage(528399);
                            ConnectivityService.this.teardownUnneededNetwork(nai);
                            break;
                        }
                        ConnectivityService.this.updateCapabilities(oldScore, nai, nai.networkCapabilities);
                    }
                    if (!visible) {
                        ConnectivityService.this.mNotifier.clearNotification(netId);
                        break;
                    }
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_PROVISIONING_NOTIFICATION from unknown NetworkMonitor");
                        break;
                    }
                    if (nai.networkMisc.provisioningNotificationDisabled) break;
                    ConnectivityService.this.mNotifier.showNotification(netId, NetworkNotificationManager.NotificationType.SIGN_IN, nai, null, (PendingIntent)msg.obj, nai.networkMisc.explicitlySelected);
                    break;
                }
                case 532494: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(msg.arg2);
                    if (nai == null) break;
                    ConnectivityService.this.updatePrivateDns(nai, (DnsManager.PrivateDnsConfig)msg.obj);
                    break;
                }
            }
            return true;
        }

        private int getCaptivePortalMode() {
            return Settings.Global.getInt(ConnectivityService.this.mContext.getContentResolver(), "captive_portal_mode", 1);
        }

        private boolean maybeHandleNetworkAgentInfoMessage(Message msg) {
            block3: {
                switch (msg.what) {
                    default: {
                        return false;
                    }
                    case 1001: 
                }
                NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                if (nai == null || !ConnectivityService.this.isLiveNetworkAgent(nai, msg.what)) break block3;
                ConnectivityService.this.handleLingerComplete(nai);
            }
            return true;
        }

        @Override
        public void handleMessage(Message msg) {
            if (!(this.maybeHandleAsyncChannelMessage(msg) || this.maybeHandleNetworkMonitorMessage(msg) || this.maybeHandleNetworkAgentInfoMessage(msg))) {
                this.maybeHandleNetworkAgentMessage(msg);
            }
        }
    }

    private class LegacyTypeTracker {
        private static final boolean DBG = true;
        private static final boolean VDBG = false;
        private final ArrayList<NetworkAgentInfo>[] mTypeLists = new ArrayList[18];

        public void addSupportedType(int type) {
            if (this.mTypeLists[type] != null) {
                throw new IllegalStateException("legacy list for type " + type + "already initialized");
            }
            this.mTypeLists[type] = new ArrayList();
        }

        public boolean isTypeSupported(int type) {
            return ConnectivityManager.isNetworkTypeValid(type) && this.mTypeLists[type] != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetworkAgentInfo getNetworkForType(int type) {
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                if (this.isTypeSupported(type) && !this.mTypeLists[type].isEmpty()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.mTypeLists[type].get(0);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        private void maybeLogBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type, boolean isDefaultNetwork) {
            ConnectivityService.log("Sending " + (Object)((Object)state) + " broadcast for type " + type + " " + nai.name() + " isDefaultNetwork=" + isDefaultNetwork);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int type, NetworkAgentInfo nai) {
            if (!this.isTypeSupported(type)) {
                return;
            }
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list.contains(nai)) {
                return;
            }
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                list.add(nai);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                boolean isDefaultNetwork = ConnectivityService.this.isDefaultNetwork(nai);
                if (list.size() == 1 || isDefaultNetwork) {
                    this.maybeLogBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type, isDefaultNetwork);
                    ConnectivityService.this.sendLegacyNetworkBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int type, NetworkAgentInfo nai, boolean wasDefault) {
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list == null || list.isEmpty()) {
                return;
            }
            boolean wasFirstNetwork = list.get(0).equals(nai);
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                NetworkInfo.DetailedState state;
                block7: {
                    if (!list.remove(nai)) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return;
                    }
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    state = NetworkInfo.DetailedState.DISCONNECTED;
                    if (!wasFirstNetwork && !wasDefault) break block7;
                    this.maybeLogBroadcast(nai, state, type, wasDefault);
                    ConnectivityService.this.sendLegacyNetworkBroadcast(nai, state, type);
                }
                if (!list.isEmpty() && wasFirstNetwork) {
                    ConnectivityService.log("Other network available for type " + type + ", sending connected broadcast");
                    NetworkAgentInfo replacement = list.get(0);
                    this.maybeLogBroadcast(replacement, state, type, ConnectivityService.this.isDefaultNetwork(replacement));
                    ConnectivityService.this.sendLegacyNetworkBroadcast(replacement, state, type);
                }
                return;
            }
        }

        public void remove(NetworkAgentInfo nai, boolean wasDefault) {
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                this.remove(type, nai, wasDefault);
            }
        }

        public void update(NetworkAgentInfo nai) {
            boolean isDefault = ConnectivityService.this.isDefaultNetwork(nai);
            NetworkInfo.DetailedState state = nai.networkInfo.getDetailedState();
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                boolean isFirst;
                ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
                boolean contains = list != null && list.contains(nai);
                boolean bl = isFirst = contains && nai == list.get(0);
                if (!isFirst && (!contains || !isDefault)) continue;
                this.maybeLogBroadcast(nai, state, type, isDefault);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, state, type);
            }
        }

        private String naiToString(NetworkAgentInfo nai) {
            String name = nai != null ? nai.name() : "null";
            String state = nai.networkInfo != null ? (Object)((Object)nai.networkInfo.getState()) + "/" + (Object)((Object)nai.networkInfo.getDetailedState()) : "???/???";
            return name + " " + state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(IndentingPrintWriter pw) {
            pw.println("mLegacyTypeTracker:");
            pw.increaseIndent();
            pw.print("Supported types:");
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                if (this.mTypeLists[type] == null) continue;
                pw.print(" " + type);
            }
            pw.println();
            pw.println("Current state:");
            pw.increaseIndent();
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                for (int type = 0; type < this.mTypeLists.length; ++type) {
                    if (this.mTypeLists[type] == null || this.mTypeLists[type].isEmpty()) continue;
                    for (NetworkAgentInfo nai : this.mTypeLists[type]) {
                        pw.println(type + " " + this.naiToString(nai));
                    }
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println();
                return;
            }
        }
    }

    private static class ValidationLog {
        final Network mNetwork;
        final String mName;
        final LocalLog.ReadOnlyLocalLog mLog;

        ValidationLog(Network network, String name, LocalLog.ReadOnlyLocalLog log) {
            this.mNetwork = network;
            this.mName = name;
            this.mLog = log;
        }
    }

    private static enum UnneededFor {
        LINGER,
        TEARDOWN;

    }

    private static enum ReapUnvalidatedNetworks {
        REAP,
        DONT_REAP;

    }
}

