/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.BroadcastOptions;
import android.app.IAlarmCompleteListener;
import android.app.IAlarmListener;
import android.app.IAlarmManager;
import android.app.IUidObserver;
import android.app.PendingIntent;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelableException;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.system.Os;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.NtpTrustedTime;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.LocalLog;
import com.android.internal.util.StatLogger;
import com.android.server.AlarmManagerInternal;
import com.android.server.AppStateTracker;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Predicate;

class AlarmManagerService
extends SystemService {
    private static final int RTC_WAKEUP_MASK = 1;
    private static final int RTC_MASK = 2;
    private static final int ELAPSED_REALTIME_WAKEUP_MASK = 4;
    private static final int ELAPSED_REALTIME_MASK = 8;
    static final int TIME_CHANGED_MASK = 65536;
    static final int IS_WAKEUP_MASK = 5;
    static final int TYPE_NONWAKEUP_MASK = 1;
    static final String TAG = "AlarmManager";
    static final boolean localLOGV = false;
    static final boolean DEBUG_BATCH = false;
    static final boolean DEBUG_VALIDATE = false;
    static final boolean DEBUG_ALARM_CLOCK = false;
    static final boolean DEBUG_LISTENER_CALLBACK = false;
    static final boolean DEBUG_WAKELOCK = false;
    static final boolean DEBUG_BG_LIMIT = false;
    static final boolean DEBUG_STANDBY = false;
    static final boolean RECORD_ALARMS_IN_HISTORY = true;
    static final boolean RECORD_DEVICE_IDLE_ALARMS = false;
    static final int ALARM_EVENT = 1;
    static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    static final int ACTIVE_INDEX = 0;
    static final int WORKING_INDEX = 1;
    static final int FREQUENT_INDEX = 2;
    static final int RARE_INDEX = 3;
    static final int NEVER_INDEX = 4;
    private final Intent mBackgroundIntent = new Intent().addFlags(4);
    static final IncreasingTimeOrder sIncreasingTimeOrder = new IncreasingTimeOrder();
    static final boolean WAKEUP_STATS = false;
    private static final Intent NEXT_ALARM_CLOCK_CHANGED_INTENT = new Intent("android.app.action.NEXT_ALARM_CLOCK_CHANGED").addFlags(0x21000000);
    final LocalLog mLog = new LocalLog("AlarmManager");
    AppOpsManager mAppOps;
    DeviceIdleController.LocalService mLocalDeviceIdleController;
    private UsageStatsManagerInternal mUsageStatsManagerInternal;
    final Object mLock = new Object();
    SparseArray<ArrayList<Alarm>> mPendingBackgroundAlarms = new SparseArray();
    long mNativeData;
    private long mNextWakeup;
    private long mNextNonWakeup;
    private long mLastWakeupSet;
    private long mLastWakeup;
    private long mLastTrigger;
    private long mLastTickSet;
    private long mLastTickIssued;
    private long mLastTickReceived;
    private long mLastTickAdded;
    private long mLastTickRemoved;
    int mBroadcastRefCount = 0;
    PowerManager.WakeLock mWakeLock;
    boolean mLastWakeLockUnimportantForLogging;
    ArrayList<Alarm> mPendingNonWakeupAlarms = new ArrayList();
    ArrayList<InFlight> mInFlight = new ArrayList();
    final AlarmHandler mHandler = new AlarmHandler();
    ClockReceiver mClockReceiver;
    InteractiveStateReceiver mInteractiveStateReceiver;
    private UninstallReceiver mUninstallReceiver;
    final DeliveryTracker mDeliveryTracker = new DeliveryTracker();
    PendingIntent mTimeTickSender;
    PendingIntent mDateChangeSender;
    Random mRandom;
    boolean mInteractive = true;
    long mNonInteractiveStartTime;
    long mNonInteractiveTime;
    long mLastAlarmDeliveryTime;
    long mStartCurrentDelayTime;
    long mNextNonWakeupDeliveryTime;
    long mLastTimeChangeClockTime;
    long mLastTimeChangeRealtime;
    int mNumTimeChanged;
    private static final String SYSTEM_UI_SELF_PERMISSION = "android.permission.systemui.IDENTITY";
    int mSystemUiUid;
    final SparseLongArray mLastAllowWhileIdleDispatch = new SparseLongArray();
    final SparseBooleanArray mUseAllowWhileIdleShortTime = new SparseBooleanArray();
    final ArrayList<IdleDispatchEntry> mAllowWhileIdleDispatches = new ArrayList();
    private final StatLogger mStatLogger = new StatLogger(new String[]{"REBATCH_ALL_ALARMS", "REORDER_ALARMS_FOR_STANDBY"});
    Bundle mIdleOptions;
    private final SparseArray<AlarmManager.AlarmClockInfo> mNextAlarmClockForUser = new SparseArray();
    private final SparseArray<AlarmManager.AlarmClockInfo> mTmpSparseAlarmClockArray = new SparseArray();
    private final SparseBooleanArray mPendingSendNextAlarmClockChangedForUser = new SparseBooleanArray();
    private boolean mNextAlarmClockMayChange;
    private final SparseArray<AlarmManager.AlarmClockInfo> mHandlerSparseAlarmClockArray = new SparseArray();
    private AppStateTracker mAppStateTracker;
    private boolean mAppStandbyParole;
    private ArrayMap<Pair<String, Integer>, Long> mLastAlarmDeliveredForPackage = new ArrayMap();
    final Constants mConstants;
    static final int PRIO_TICK = 0;
    static final int PRIO_WAKEUP = 1;
    static final int PRIO_NORMAL = 2;
    final HashMap<String, PriorityClass> mPriorities = new HashMap();
    int mCurrentSeq = 0;
    final LinkedList<WakeupEvent> mRecentWakeups = new LinkedList();
    final long RECENT_WAKEUP_PERIOD = 86400000L;
    final Comparator<Alarm> mAlarmDispatchComparator = new Comparator<Alarm>(){

        @Override
        public int compare(Alarm lhs, Alarm rhs) {
            if (lhs.priorityClass.priority < rhs.priorityClass.priority) {
                return -1;
            }
            if (lhs.priorityClass.priority > rhs.priorityClass.priority) {
                return 1;
            }
            if (lhs.whenElapsed < rhs.whenElapsed) {
                return -1;
            }
            if (lhs.whenElapsed > rhs.whenElapsed) {
                return 1;
            }
            return 0;
        }
    };
    static final long MIN_FUZZABLE_INTERVAL = 10000L;
    static final BatchTimeOrder sBatchOrder = new BatchTimeOrder();
    final ArrayList<Batch> mAlarmBatches = new ArrayList();
    Alarm mPendingIdleUntil = null;
    Alarm mNextWakeFromIdle = null;
    ArrayList<Alarm> mPendingWhileIdleAlarms = new ArrayList();
    final SparseArray<ArrayMap<String, BroadcastStats>> mBroadcastStats = new SparseArray();
    int mNumDelayedAlarms = 0;
    long mTotalDelayTime = 0L;
    long mMaxDelayTime = 0L;
    private final IBinder mService = new IAlarmManager.Stub(){

        @Override
        public void set(String callingPackage, int type, long triggerAtTime, long windowLength, long interval, int flags, PendingIntent operation, IAlarmListener directReceiver, String listenerTag, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock) {
            int callingUid = Binder.getCallingUid();
            AlarmManagerService.this.mAppOps.checkPackage(callingUid, callingPackage);
            if (interval != 0L && directReceiver != null) {
                throw new IllegalArgumentException("Repeating alarms cannot use AlarmReceivers");
            }
            if (workSource != null) {
                AlarmManagerService.this.getContext().enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), callingUid, "AlarmManager.set");
            }
            flags &= 0xFFFFFFF5;
            if (callingUid != 1000) {
                flags &= 0xFFFFFFEF;
            }
            if (windowLength == 0L) {
                flags |= 1;
            }
            if (alarmClock != null) {
                flags |= 3;
            } else if (workSource == null && (callingUid < 10000 || UserHandle.isSameApp(callingUid, AlarmManagerService.this.mSystemUiUid) || AlarmManagerService.this.mAppStateTracker != null && AlarmManagerService.this.mAppStateTracker.isUidPowerSaveUserWhitelisted(callingUid))) {
                flags |= 8;
                flags &= 0xFFFFFFFB;
            }
            AlarmManagerService.this.setImpl(type, triggerAtTime, windowLength, interval, operation, directReceiver, listenerTag, flags, workSource, alarmClock, callingUid, callingPackage);
        }

        @Override
        public boolean setTime(long millis) {
            AlarmManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.SET_TIME", "setTime");
            return AlarmManagerService.this.setTimeImpl(millis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeZone(String tz) {
            AlarmManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.SET_TIME_ZONE", "setTimeZone");
            long oldId = Binder.clearCallingIdentity();
            try {
                AlarmManagerService.this.setTimeZoneImpl(tz);
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(PendingIntent operation, IAlarmListener listener) {
            if (operation == null && listener == null) {
                Slog.w(AlarmManagerService.TAG, "remove() with no intent or listener");
                return;
            }
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.removeLocked(operation, listener);
            }
        }

        @Override
        public long getNextWakeFromIdleTime() {
            return AlarmManagerService.this.getNextWakeFromIdleTimeImpl();
        }

        @Override
        public AlarmManager.AlarmClockInfo getNextAlarmClock(int userId) {
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, "getNextAlarmClock", null);
            return AlarmManagerService.this.getNextAlarmClockImpl(userId);
        }

        @Override
        public long currentNetworkTimeMillis() {
            NtpTrustedTime time = NtpTrustedTime.getInstance(AlarmManagerService.this.getContext());
            if (time.hasCache()) {
                return time.currentTimeMillis();
            }
            throw new ParcelableException(new DateTimeException("Missing NTP fix"));
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(AlarmManagerService.this.getContext(), AlarmManagerService.TAG, pw)) {
                return;
            }
            if (args.length > 0 && "--proto".equals(args[0])) {
                AlarmManagerService.this.dumpProto(fd);
            } else {
                AlarmManagerService.this.dumpImpl(pw);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new ShellCmd().exec(this, in, out, err, args, callback, resultReceiver);
        }
    };
    private final AppStateTracker.Listener mForceAppStandbyListener = new AppStateTracker.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unblockAllUnrestrictedAlarms() {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.sendAllUnrestrictedPendingBackgroundAlarmsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unblockAlarmsForUid(int uid) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.sendPendingBackgroundAlarmsLocked(uid, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unblockAlarmsForUidPackage(int uid, String packageName) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.sendPendingBackgroundAlarmsLocked(uid, packageName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidForeground(int uid, boolean foreground) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                if (foreground) {
                    AlarmManagerService.this.mUseAllowWhileIdleShortTime.put(uid, true);
                }
            }
        }
    };
    @GuardedBy(value="mLock")
    private int mSendCount = 0;
    @GuardedBy(value="mLock")
    private int mSendFinishCount = 0;
    @GuardedBy(value="mLock")
    private int mListenerCount = 0;
    @GuardedBy(value="mLock")
    private int mListenerFinishCount = 0;

    void calculateDeliveryPriorities(ArrayList<Alarm> alarms) {
        int N = alarms.size();
        for (int i = 0; i < N; ++i) {
            Alarm a = alarms.get(i);
            int alarmPrio = a.operation != null && "android.intent.action.TIME_TICK".equals(a.operation.getIntent().getAction()) ? 0 : (a.wakeup ? 1 : 2);
            PriorityClass packagePrio = a.priorityClass;
            String alarmPackage = a.sourcePackage;
            if (packagePrio == null) {
                packagePrio = this.mPriorities.get(alarmPackage);
            }
            if (packagePrio == null) {
                packagePrio = a.priorityClass = new PriorityClass();
                this.mPriorities.put(alarmPackage, packagePrio);
            }
            a.priorityClass = packagePrio;
            if (packagePrio.seq != this.mCurrentSeq) {
                packagePrio.priority = alarmPrio;
                packagePrio.seq = this.mCurrentSeq;
                continue;
            }
            if (alarmPrio >= packagePrio.priority) continue;
            packagePrio.priority = alarmPrio;
        }
    }

    public AlarmManagerService(Context context) {
        super(context);
        this.mConstants = new Constants(this.mHandler);
        this.publishLocalService(AlarmManagerInternal.class, new LocalService());
    }

    static long convertToElapsed(long when, int type) {
        boolean isRtc;
        boolean bl = isRtc = type == 1 || type == 0;
        if (isRtc) {
            when -= System.currentTimeMillis() - SystemClock.elapsedRealtime();
        }
        return when;
    }

    static long maxTriggerTime(long now, long triggerAtTime, long interval) {
        long futurity;
        long l = futurity = interval == 0L ? triggerAtTime - now : interval;
        if (futurity < 10000L) {
            futurity = 0L;
        }
        return AlarmManagerService.clampPositive(triggerAtTime + (long)(0.75 * (double)futurity));
    }

    static boolean addBatchLocked(ArrayList<Batch> list, Batch newBatch) {
        int index = Collections.binarySearch(list, newBatch, sBatchOrder);
        if (index < 0) {
            index = 0 - index - 1;
        }
        list.add(index, newBatch);
        return index == 0;
    }

    private void insertAndBatchAlarmLocked(Alarm alarm) {
        int whichBatch;
        int n = whichBatch = (alarm.flags & 1) != 0 ? -1 : this.attemptCoalesceLocked(alarm.whenElapsed, alarm.maxWhenElapsed);
        if (whichBatch < 0) {
            AlarmManagerService.addBatchLocked(this.mAlarmBatches, new Batch(alarm));
        } else {
            Batch batch = this.mAlarmBatches.get(whichBatch);
            if (batch.add(alarm)) {
                this.mAlarmBatches.remove(whichBatch);
                AlarmManagerService.addBatchLocked(this.mAlarmBatches, batch);
            }
        }
    }

    int attemptCoalesceLocked(long whenElapsed, long maxWhen) {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if ((b.flags & 1) != 0 || !b.canHold(whenElapsed, maxWhen)) continue;
            return i;
        }
        return -1;
    }

    static int getAlarmCount(ArrayList<Batch> batches) {
        int ret = 0;
        int size = batches.size();
        for (int i = 0; i < size; ++i) {
            ret += batches.get(i).size();
        }
        return ret;
    }

    boolean haveAlarmsTimeTickAlarm(ArrayList<Alarm> alarms) {
        if (alarms.size() == 0) {
            return false;
        }
        int batchSize = alarms.size();
        for (int j = 0; j < batchSize; ++j) {
            if (alarms.get((int)j).operation != this.mTimeTickSender) continue;
            return true;
        }
        return false;
    }

    boolean haveBatchesTimeTickAlarm(ArrayList<Batch> batches) {
        int numBatches = batches.size();
        for (int i = 0; i < numBatches; ++i) {
            if (!this.haveAlarmsTimeTickAlarm(batches.get((int)i).alarms)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebatchAllAlarms() {
        Object object = this.mLock;
        synchronized (object) {
            this.rebatchAllAlarmsLocked(true);
        }
    }

    void rebatchAllAlarmsLocked(boolean doValidate) {
        boolean newHasTick;
        long start = this.mStatLogger.getTime();
        int oldCount = AlarmManagerService.getAlarmCount(this.mAlarmBatches) + ArrayUtils.size(this.mPendingWhileIdleAlarms);
        boolean oldHasTick = this.haveBatchesTimeTickAlarm(this.mAlarmBatches) || this.haveAlarmsTimeTickAlarm(this.mPendingWhileIdleAlarms);
        ArrayList oldSet = (ArrayList)this.mAlarmBatches.clone();
        this.mAlarmBatches.clear();
        Alarm oldPendingIdleUntil = this.mPendingIdleUntil;
        long nowElapsed = SystemClock.elapsedRealtime();
        int oldBatches = oldSet.size();
        for (int batchNum = 0; batchNum < oldBatches; ++batchNum) {
            Batch batch = (Batch)oldSet.get(batchNum);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                this.reAddAlarmLocked(batch.get(i), nowElapsed, doValidate);
            }
        }
        if (oldPendingIdleUntil != null && oldPendingIdleUntil != this.mPendingIdleUntil) {
            Slog.wtf(TAG, "Rebatching: idle until changed from " + oldPendingIdleUntil + " to " + this.mPendingIdleUntil);
            if (this.mPendingIdleUntil == null) {
                this.restorePendingWhileIdleAlarmsLocked();
            }
        }
        int newCount = AlarmManagerService.getAlarmCount(this.mAlarmBatches) + ArrayUtils.size(this.mPendingWhileIdleAlarms);
        boolean bl = newHasTick = this.haveBatchesTimeTickAlarm(this.mAlarmBatches) || this.haveAlarmsTimeTickAlarm(this.mPendingWhileIdleAlarms);
        if (oldCount != newCount) {
            Slog.wtf(TAG, "Rebatching: total count changed from " + oldCount + " to " + newCount);
        }
        if (oldHasTick != newHasTick) {
            Slog.wtf(TAG, "Rebatching: hasTick changed from " + oldHasTick + " to " + newHasTick);
        }
        this.rescheduleKernelAlarmsLocked();
        this.updateNextAlarmClockLocked();
        this.mStatLogger.logDurationStat(0, start);
    }

    boolean reorderAlarmsBasedOnStandbyBuckets(ArraySet<Pair<String, Integer>> targetPackages) {
        long start = this.mStatLogger.getTime();
        ArrayList<Alarm> rescheduledAlarms = new ArrayList<Alarm>();
        for (int batchIndex = this.mAlarmBatches.size() - 1; batchIndex >= 0; --batchIndex) {
            Batch batch = this.mAlarmBatches.get(batchIndex);
            for (int alarmIndex = batch.size() - 1; alarmIndex >= 0; --alarmIndex) {
                Alarm alarm = batch.get(alarmIndex);
                Pair<String, Integer> packageUser = Pair.create(alarm.sourcePackage, UserHandle.getUserId(alarm.creatorUid));
                if (targetPackages != null && !targetPackages.contains(packageUser) || !this.adjustDeliveryTimeBasedOnStandbyBucketLocked(alarm)) continue;
                batch.remove(alarm);
                rescheduledAlarms.add(alarm);
            }
            if (batch.size() != 0) continue;
            this.mAlarmBatches.remove(batchIndex);
        }
        for (int i = 0; i < rescheduledAlarms.size(); ++i) {
            Alarm a = (Alarm)rescheduledAlarms.get(i);
            this.insertAndBatchAlarmLocked(a);
        }
        this.mStatLogger.logDurationStat(1, start);
        return rescheduledAlarms.size() > 0;
    }

    void reAddAlarmLocked(Alarm a, long nowElapsed, boolean doValidate) {
        a.when = a.origWhen;
        long whenElapsed = AlarmManagerService.convertToElapsed(a.when, a.type);
        long maxElapsed = a.windowLength == 0L ? whenElapsed : (a.windowLength > 0L ? AlarmManagerService.clampPositive(whenElapsed + a.windowLength) : AlarmManagerService.maxTriggerTime(nowElapsed, whenElapsed, a.repeatInterval));
        a.whenElapsed = whenElapsed;
        a.maxWhenElapsed = maxElapsed;
        this.setImplLocked(a, true, doValidate);
    }

    static long clampPositive(long val) {
        return val >= 0L ? val : Long.MAX_VALUE;
    }

    void sendPendingBackgroundAlarmsLocked(int uid, String packageName) {
        ArrayList<Alarm> alarmsToDeliver;
        ArrayList<Alarm> alarmsForUid = this.mPendingBackgroundAlarms.get(uid);
        if (alarmsForUid == null || alarmsForUid.size() == 0) {
            return;
        }
        if (packageName != null) {
            alarmsToDeliver = new ArrayList();
            for (int i = alarmsForUid.size() - 1; i >= 0; --i) {
                Alarm a = alarmsForUid.get(i);
                if (!a.matches(packageName)) continue;
                alarmsToDeliver.add(alarmsForUid.remove(i));
            }
            if (alarmsForUid.size() == 0) {
                this.mPendingBackgroundAlarms.remove(uid);
            }
        } else {
            alarmsToDeliver = alarmsForUid;
            this.mPendingBackgroundAlarms.remove(uid);
        }
        this.deliverPendingBackgroundAlarmsLocked(alarmsToDeliver, SystemClock.elapsedRealtime());
    }

    void sendAllUnrestrictedPendingBackgroundAlarmsLocked() {
        ArrayList<Alarm> alarmsToDeliver = new ArrayList<Alarm>();
        AlarmManagerService.findAllUnrestrictedPendingBackgroundAlarmsLockedInner(this.mPendingBackgroundAlarms, alarmsToDeliver, this::isBackgroundRestricted);
        if (alarmsToDeliver.size() > 0) {
            this.deliverPendingBackgroundAlarmsLocked(alarmsToDeliver, SystemClock.elapsedRealtime());
        }
    }

    @VisibleForTesting
    static void findAllUnrestrictedPendingBackgroundAlarmsLockedInner(SparseArray<ArrayList<Alarm>> pendingAlarms, ArrayList<Alarm> unrestrictedAlarms, Predicate<Alarm> isBackgroundRestricted) {
        for (int uidIndex = pendingAlarms.size() - 1; uidIndex >= 0; --uidIndex) {
            int uid = pendingAlarms.keyAt(uidIndex);
            ArrayList<Alarm> alarmsForUid = pendingAlarms.valueAt(uidIndex);
            for (int alarmIndex = alarmsForUid.size() - 1; alarmIndex >= 0; --alarmIndex) {
                Alarm alarm = alarmsForUid.get(alarmIndex);
                if (isBackgroundRestricted.test(alarm)) continue;
                unrestrictedAlarms.add(alarm);
                alarmsForUid.remove(alarmIndex);
            }
            if (alarmsForUid.size() != 0) continue;
            pendingAlarms.removeAt(uidIndex);
        }
    }

    private void deliverPendingBackgroundAlarmsLocked(ArrayList<Alarm> alarms, long nowELAPSED) {
        int N = alarms.size();
        boolean hasWakeup = false;
        for (int i = 0; i < N; ++i) {
            Alarm alarm = alarms.get(i);
            if (alarm.wakeup) {
                hasWakeup = true;
            }
            alarm.count = 1;
            if (alarm.repeatInterval <= 0L) continue;
            alarm.count = (int)((long)alarm.count + (nowELAPSED - alarm.expectedWhenElapsed) / alarm.repeatInterval);
            long delta = (long)alarm.count * alarm.repeatInterval;
            long nextElapsed = alarm.whenElapsed + delta;
            this.setImplLocked(alarm.type, alarm.when + delta, nextElapsed, alarm.windowLength, AlarmManagerService.maxTriggerTime(nowELAPSED, nextElapsed, alarm.repeatInterval), alarm.repeatInterval, alarm.operation, null, null, alarm.flags, true, alarm.workSource, alarm.alarmClock, alarm.uid, alarm.packageName);
        }
        if (!hasWakeup && this.checkAllowNonWakeupDelayLocked(nowELAPSED)) {
            if (this.mPendingNonWakeupAlarms.size() == 0) {
                this.mStartCurrentDelayTime = nowELAPSED;
                this.mNextNonWakeupDeliveryTime = nowELAPSED + this.currentNonWakeupFuzzLocked(nowELAPSED) * 3L / 2L;
            }
            this.mPendingNonWakeupAlarms.addAll(alarms);
            this.mNumDelayedAlarms += alarms.size();
        } else {
            if (this.mPendingNonWakeupAlarms.size() > 0) {
                alarms.addAll(this.mPendingNonWakeupAlarms);
                long thisDelayTime = nowELAPSED - this.mStartCurrentDelayTime;
                this.mTotalDelayTime += thisDelayTime;
                if (this.mMaxDelayTime < thisDelayTime) {
                    this.mMaxDelayTime = thisDelayTime;
                }
                this.mPendingNonWakeupAlarms.clear();
            }
            this.calculateDeliveryPriorities(alarms);
            Collections.sort(alarms, this.mAlarmDispatchComparator);
            this.deliverAlarmsLocked(alarms, nowELAPSED);
        }
    }

    void restorePendingWhileIdleAlarmsLocked() {
        if (this.mPendingWhileIdleAlarms.size() > 0) {
            ArrayList<Alarm> alarms = this.mPendingWhileIdleAlarms;
            this.mPendingWhileIdleAlarms = new ArrayList();
            long nowElapsed = SystemClock.elapsedRealtime();
            for (int i = alarms.size() - 1; i >= 0; --i) {
                Alarm a = alarms.get(i);
                this.reAddAlarmLocked(a, nowElapsed, false);
            }
        }
        this.rescheduleKernelAlarmsLocked();
        this.updateNextAlarmClockLocked();
        try {
            this.mTimeTickSender.send();
        }
        catch (PendingIntent.CanceledException canceledException) {
            // empty catch block
        }
    }

    @Override
    public void onStart() {
        this.mNativeData = this.init();
        this.mNextNonWakeup = 0L;
        this.mNextWakeup = 0L;
        this.setTimeZoneImpl(SystemProperties.get(TIMEZONE_PROPERTY));
        if (this.mNativeData != 0L) {
            long systemBuildTime = Environment.getRootDirectory().lastModified();
            if (System.currentTimeMillis() < systemBuildTime) {
                Slog.i(TAG, "Current time only " + System.currentTimeMillis() + ", advancing to build time " + systemBuildTime);
                this.setKernelTime(this.mNativeData, systemBuildTime);
            }
        }
        PackageManager packMan = this.getContext().getPackageManager();
        try {
            PermissionInfo sysUiPerm = packMan.getPermissionInfo(SYSTEM_UI_SELF_PERMISSION, 0);
            ApplicationInfo sysUi = packMan.getApplicationInfo(sysUiPerm.packageName, 0);
            if ((sysUi.privateFlags & 8) != 0) {
                this.mSystemUiUid = sysUi.uid;
            } else {
                Slog.e(TAG, "SysUI permission android.permission.systemui.IDENTITY defined by non-privileged app " + sysUi.packageName + " - ignoring");
            }
        }
        catch (PackageManager.NameNotFoundException sysUiPerm) {
            // empty catch block
        }
        if (this.mSystemUiUid <= 0) {
            Slog.wtf(TAG, "SysUI package not found!");
        }
        PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*alarm*");
        this.mTimeTickSender = PendingIntent.getBroadcastAsUser(this.getContext(), 0, new Intent("android.intent.action.TIME_TICK").addFlags(0x50200000), 0, UserHandle.ALL);
        Intent intent = new Intent("android.intent.action.DATE_CHANGED");
        intent.addFlags(0x20200000);
        this.mDateChangeSender = PendingIntent.getBroadcastAsUser(this.getContext(), 0, intent, 0x4000000, UserHandle.ALL);
        this.mClockReceiver = new ClockReceiver();
        this.mClockReceiver.scheduleTimeTickEvent();
        this.mClockReceiver.scheduleDateChangedEvent();
        this.mInteractiveStateReceiver = new InteractiveStateReceiver();
        this.mUninstallReceiver = new UninstallReceiver();
        if (this.mNativeData != 0L) {
            AlarmThread waitThread = new AlarmThread();
            waitThread.start();
        } else {
            Slog.w(TAG, "Failed to open alarm driver. Falling back to a handler.");
        }
        try {
            ActivityManager.getService().registerUidObserver(new UidObserver(), 14, -1, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.publishBinderService("alarm", this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mConstants.start(this.getContext().getContentResolver());
            this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
            this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
            this.mUsageStatsManagerInternal = LocalServices.getService(UsageStatsManagerInternal.class);
            this.mUsageStatsManagerInternal.addAppIdleStateChangeListener(new AppStandbyTracker());
            this.mAppStateTracker = LocalServices.getService(AppStateTracker.class);
            this.mAppStateTracker.addListener(this.mForceAppStandbyListener);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close(this.mNativeData);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setTimeImpl(long millis) {
        if (this.mNativeData == 0L) {
            Slog.w(TAG, "Not setting time since no alarm driver is available.");
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.setKernelTime(this.mNativeData, millis) == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeZoneImpl(String tz) {
        if (TextUtils.isEmpty(tz)) {
            return;
        }
        TimeZone zone = TimeZone.getTimeZone(tz);
        boolean timeZoneWasChanged = false;
        AlarmManagerService alarmManagerService = this;
        synchronized (alarmManagerService) {
            String current = SystemProperties.get(TIMEZONE_PROPERTY);
            if (current == null || !current.equals(zone.getID())) {
                timeZoneWasChanged = true;
                SystemProperties.set(TIMEZONE_PROPERTY, zone.getID());
            }
            int gmtOffset = zone.getOffset(System.currentTimeMillis());
            this.setKernelTimezone(this.mNativeData, -(gmtOffset / 60000));
        }
        TimeZone.setDefault(null);
        if (timeZoneWasChanged) {
            Intent intent = new Intent("android.intent.action.TIMEZONE_CHANGED");
            intent.addFlags(0x21200000);
            intent.putExtra("time-zone", zone.getID());
            this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImpl(PendingIntent operation) {
        if (operation == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeLocked(operation, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImpl(int type, long triggerAtTime, long windowLength, long interval, PendingIntent operation, IAlarmListener directReceiver, String listenerTag, int flags, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock, int callingUid, String callingPackage) {
        long maxElapsed;
        long minTrigger;
        long triggerElapsed;
        if (operation == null && directReceiver == null || operation != null && directReceiver != null) {
            Slog.w(TAG, "Alarms must either supply a PendingIntent or an AlarmReceiver");
            return;
        }
        if (windowLength > 43200000L) {
            Slog.w(TAG, "Window length " + windowLength + "ms suspiciously long; limiting to 1 hour");
            windowLength = 3600000L;
        }
        long minInterval = this.mConstants.MIN_INTERVAL;
        if (interval > 0L && interval < minInterval) {
            Slog.w(TAG, "Suspiciously short interval " + interval + " millis; expanding to " + minInterval / 1000L + " seconds");
            interval = minInterval;
        } else if (interval > this.mConstants.MAX_INTERVAL) {
            Slog.w(TAG, "Suspiciously long interval " + interval + " millis; clamping");
            interval = this.mConstants.MAX_INTERVAL;
        }
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Invalid alarm type " + type);
        }
        if (triggerAtTime < 0L) {
            long what = Binder.getCallingPid();
            Slog.w(TAG, "Invalid alarm trigger time! " + triggerAtTime + " from uid=" + callingUid + " pid=" + what);
            triggerAtTime = 0L;
        }
        long nowElapsed = SystemClock.elapsedRealtime();
        long nominalTrigger = AlarmManagerService.convertToElapsed(triggerAtTime, type);
        long l = triggerElapsed = nominalTrigger > (minTrigger = nowElapsed + this.mConstants.MIN_FUTURITY) ? nominalTrigger : minTrigger;
        if (windowLength == 0L) {
            maxElapsed = triggerElapsed;
        } else if (windowLength < 0L) {
            maxElapsed = AlarmManagerService.maxTriggerTime(nowElapsed, triggerElapsed, interval);
            windowLength = maxElapsed - triggerElapsed;
        } else {
            maxElapsed = triggerElapsed + windowLength;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.setImplLocked(type, triggerAtTime, triggerElapsed, windowLength, maxElapsed, interval, operation, directReceiver, listenerTag, flags, true, workSource, alarmClock, callingUid, callingPackage);
        }
    }

    private void setImplLocked(int type, long when, long whenElapsed, long windowLength, long maxWhen, long interval, PendingIntent operation, IAlarmListener directReceiver, String listenerTag, int flags, boolean doValidate, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock, int callingUid, String callingPackage) {
        Alarm a = new Alarm(type, when, whenElapsed, windowLength, maxWhen, interval, operation, directReceiver, listenerTag, workSource, flags, alarmClock, callingUid, callingPackage);
        try {
            if (ActivityManager.getService().isAppStartModeDisabled(callingUid, callingPackage)) {
                Slog.w(TAG, "Not setting alarm from " + callingUid + ":" + a + " -- package not allowed to start");
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.removeLocked(operation, directReceiver);
        this.setImplLocked(a, false, doValidate);
    }

    private long getMinDelayForBucketLocked(int bucket) {
        int index = bucket == 50 ? 4 : (bucket > 30 ? 3 : (bucket > 20 ? 2 : (bucket > 10 ? 1 : 0)));
        return this.mConstants.APP_STANDBY_MIN_DELAYS[index];
    }

    private boolean adjustDeliveryTimeBasedOnStandbyBucketLocked(Alarm alarm) {
        if (this.isExemptFromAppStandby(alarm)) {
            return false;
        }
        if (this.mAppStandbyParole) {
            if (alarm.whenElapsed > alarm.expectedWhenElapsed) {
                alarm.whenElapsed = alarm.expectedWhenElapsed;
                alarm.maxWhenElapsed = alarm.expectedMaxWhenElapsed;
                return true;
            }
            return false;
        }
        long oldWhenElapsed = alarm.whenElapsed;
        long oldMaxWhenElapsed = alarm.maxWhenElapsed;
        String sourcePackage = alarm.sourcePackage;
        int sourceUserId = UserHandle.getUserId(alarm.creatorUid);
        int standbyBucket = this.mUsageStatsManagerInternal.getAppStandbyBucket(sourcePackage, sourceUserId, SystemClock.elapsedRealtime());
        Pair<String, Integer> packageUser = Pair.create(sourcePackage, sourceUserId);
        long lastElapsed = this.mLastAlarmDeliveredForPackage.getOrDefault(packageUser, 0L);
        if (lastElapsed > 0L) {
            long minElapsed = lastElapsed + this.getMinDelayForBucketLocked(standbyBucket);
            if (alarm.expectedWhenElapsed < minElapsed) {
                alarm.whenElapsed = alarm.maxWhenElapsed = minElapsed;
            } else {
                alarm.whenElapsed = alarm.expectedWhenElapsed;
                alarm.maxWhenElapsed = alarm.expectedMaxWhenElapsed;
            }
        }
        return oldWhenElapsed != alarm.whenElapsed || oldMaxWhenElapsed != alarm.maxWhenElapsed;
    }

    private void setImplLocked(Alarm a, boolean rebatching, boolean doValidate) {
        if ((a.flags & 0x10) != 0) {
            long nowElapsed;
            int fuzz;
            if (this.mNextWakeFromIdle != null && a.whenElapsed > this.mNextWakeFromIdle.whenElapsed) {
                a.whenElapsed = a.maxWhenElapsed = this.mNextWakeFromIdle.whenElapsed;
                a.when = a.maxWhenElapsed;
            }
            if ((fuzz = AlarmManagerService.fuzzForDuration(a.whenElapsed - (nowElapsed = SystemClock.elapsedRealtime()))) > 0) {
                if (this.mRandom == null) {
                    this.mRandom = new Random();
                }
                int delta = this.mRandom.nextInt(fuzz);
                a.whenElapsed -= (long)delta;
                a.when = a.maxWhenElapsed = a.whenElapsed;
            }
        } else if (this.mPendingIdleUntil != null && (a.flags & 0xE) == 0) {
            this.mPendingWhileIdleAlarms.add(a);
            return;
        }
        this.adjustDeliveryTimeBasedOnStandbyBucketLocked(a);
        this.insertAndBatchAlarmLocked(a);
        if (a.alarmClock != null) {
            this.mNextAlarmClockMayChange = true;
        }
        boolean needRebatch = false;
        if ((a.flags & 0x10) != 0) {
            if (this.mPendingIdleUntil != a && this.mPendingIdleUntil != null) {
                Slog.wtfStack(TAG, "setImplLocked: idle until changed from " + this.mPendingIdleUntil + " to " + a);
            }
            this.mPendingIdleUntil = a;
            needRebatch = true;
        } else if ((a.flags & 2) != 0 && (this.mNextWakeFromIdle == null || this.mNextWakeFromIdle.whenElapsed > a.whenElapsed)) {
            this.mNextWakeFromIdle = a;
            if (this.mPendingIdleUntil != null) {
                needRebatch = true;
            }
        }
        if (!rebatching) {
            if (needRebatch) {
                this.rebatchAllAlarmsLocked(false);
            }
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int i2;
            pw.println("Current Alarm Manager state:");
            this.mConstants.dump(pw);
            pw.println();
            if (this.mAppStateTracker != null) {
                this.mAppStateTracker.dump(pw, "  ");
                pw.println();
            }
            pw.println("  App Standby Parole: " + this.mAppStandbyParole);
            pw.println();
            long nowRTC = System.currentTimeMillis();
            long nowELAPSED = SystemClock.elapsedRealtime();
            long nowUPTIME = SystemClock.uptimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            pw.print("  nowRTC=");
            pw.print(nowRTC);
            pw.print("=");
            pw.print(sdf.format(new Date(nowRTC)));
            pw.print(" nowELAPSED=");
            pw.print(nowELAPSED);
            pw.println();
            pw.print("  mLastTimeChangeClockTime=");
            pw.print(this.mLastTimeChangeClockTime);
            pw.print("=");
            pw.println(sdf.format(new Date(this.mLastTimeChangeClockTime)));
            pw.print("  mLastTimeChangeRealtime=");
            pw.println(this.mLastTimeChangeRealtime);
            pw.print("  mLastTickIssued=");
            pw.println(sdf.format(new Date(nowRTC - (nowELAPSED - this.mLastTickIssued))));
            pw.print("  mLastTickReceived=");
            pw.println(sdf.format(new Date(this.mLastTickReceived)));
            pw.print("  mLastTickSet=");
            pw.println(sdf.format(new Date(this.mLastTickSet)));
            pw.print("  mLastTickAdded=");
            pw.println(sdf.format(new Date(this.mLastTickAdded)));
            pw.print("  mLastTickRemoved=");
            pw.println(sdf.format(new Date(this.mLastTickRemoved)));
            SystemServiceManager ssm = LocalServices.getService(SystemServiceManager.class);
            if (ssm != null) {
                pw.println();
                pw.print("  RuntimeStarted=");
                pw.print(sdf.format(new Date(nowRTC - nowELAPSED + ssm.getRuntimeStartElapsedTime())));
                if (ssm.isRuntimeRestarted()) {
                    pw.print("  (Runtime restarted)");
                }
                pw.println();
                pw.print("  Runtime uptime (elapsed): ");
                TimeUtils.formatDuration(nowELAPSED, ssm.getRuntimeStartElapsedTime(), pw);
                pw.println();
                pw.print("  Runtime uptime (uptime): ");
                TimeUtils.formatDuration(nowUPTIME, ssm.getRuntimeStartUptime(), pw);
                pw.println();
            }
            pw.println();
            if (!this.mInteractive) {
                pw.print("  Time since non-interactive: ");
                TimeUtils.formatDuration(nowELAPSED - this.mNonInteractiveStartTime, pw);
                pw.println();
            }
            pw.print("  Max wakeup delay: ");
            TimeUtils.formatDuration(this.currentNonWakeupFuzzLocked(nowELAPSED), pw);
            pw.println();
            pw.print("  Time since last dispatch: ");
            TimeUtils.formatDuration(nowELAPSED - this.mLastAlarmDeliveryTime, pw);
            pw.println();
            pw.print("  Next non-wakeup delivery time: ");
            TimeUtils.formatDuration(nowELAPSED - this.mNextNonWakeupDeliveryTime, pw);
            pw.println();
            long nextWakeupRTC = this.mNextWakeup + (nowRTC - nowELAPSED);
            long nextNonWakeupRTC = this.mNextNonWakeup + (nowRTC - nowELAPSED);
            pw.print("  Next non-wakeup alarm: ");
            TimeUtils.formatDuration(this.mNextNonWakeup, nowELAPSED, pw);
            pw.print(" = ");
            pw.print(this.mNextNonWakeup);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextNonWakeupRTC)));
            pw.print("  Next wakeup alarm: ");
            TimeUtils.formatDuration(this.mNextWakeup, nowELAPSED, pw);
            pw.print(" = ");
            pw.print(this.mNextWakeup);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextWakeupRTC)));
            pw.print("    set at ");
            TimeUtils.formatDuration(this.mLastWakeupSet, nowELAPSED, pw);
            pw.println();
            pw.print("  Last wakeup: ");
            TimeUtils.formatDuration(this.mLastWakeup, nowELAPSED, pw);
            pw.print(" = ");
            pw.println(this.mLastWakeup);
            pw.print("  Last trigger: ");
            TimeUtils.formatDuration(this.mLastTrigger, nowELAPSED, pw);
            pw.print(" = ");
            pw.println(this.mLastTrigger);
            pw.print("  Num time change events: ");
            pw.println(this.mNumTimeChanged);
            pw.println();
            pw.println("  Next alarm clock information: ");
            TreeSet<Integer> users = new TreeSet<Integer>();
            for (i2 = 0; i2 < this.mNextAlarmClockForUser.size(); ++i2) {
                users.add(this.mNextAlarmClockForUser.keyAt(i2));
            }
            for (i2 = 0; i2 < this.mPendingSendNextAlarmClockChangedForUser.size(); ++i2) {
                users.add(this.mPendingSendNextAlarmClockChangedForUser.keyAt(i2));
            }
            Iterator<Object> i3 = users.iterator();
            while (i3.hasNext()) {
                int user = (Integer)i3.next();
                AlarmManager.AlarmClockInfo next = this.mNextAlarmClockForUser.get(user);
                long time = next != null ? next.getTriggerTime() : 0L;
                boolean pendingSend = this.mPendingSendNextAlarmClockChangedForUser.get(user);
                pw.print("    user:");
                pw.print(user);
                pw.print(" pendingSend:");
                pw.print(pendingSend);
                pw.print(" time:");
                pw.print(time);
                if (time > 0L) {
                    pw.print(" = ");
                    pw.print(sdf.format(new Date(time)));
                    pw.print(" = ");
                    TimeUtils.formatDuration(time, nowRTC, pw);
                }
                pw.println();
            }
            if (this.mAlarmBatches.size() > 0) {
                pw.println();
                pw.print("  Pending alarm batches: ");
                pw.println(this.mAlarmBatches.size());
                for (Batch b : this.mAlarmBatches) {
                    pw.print(b);
                    pw.println(':');
                    AlarmManagerService.dumpAlarmList(pw, b.alarms, "    ", nowELAPSED, nowRTC, sdf);
                }
            }
            pw.println();
            pw.println("  Pending user blocked background alarms: ");
            boolean blocked = false;
            for (i = 0; i < this.mPendingBackgroundAlarms.size(); ++i) {
                ArrayList<Alarm> blockedAlarms = this.mPendingBackgroundAlarms.valueAt(i);
                if (blockedAlarms == null || blockedAlarms.size() <= 0) continue;
                blocked = true;
                AlarmManagerService.dumpAlarmList(pw, blockedAlarms, "    ", nowELAPSED, nowRTC, sdf);
            }
            if (!blocked) {
                pw.println("    none");
            }
            pw.println("  mLastAlarmDeliveredForPackage:");
            for (i = 0; i < this.mLastAlarmDeliveredForPackage.size(); ++i) {
                Pair<String, Integer> packageUser = this.mLastAlarmDeliveredForPackage.keyAt(i);
                pw.print("    Package " + (String)packageUser.first + ", User " + packageUser.second + ":");
                TimeUtils.formatDuration((long)this.mLastAlarmDeliveredForPackage.valueAt(i), nowELAPSED, pw);
                pw.println();
            }
            pw.println();
            if (this.mPendingIdleUntil != null || this.mPendingWhileIdleAlarms.size() > 0) {
                pw.println();
                pw.println("    Idle mode state:");
                pw.print("      Idling until: ");
                if (this.mPendingIdleUntil != null) {
                    pw.println(this.mPendingIdleUntil);
                    this.mPendingIdleUntil.dump(pw, "        ", nowELAPSED, nowRTC, sdf);
                } else {
                    pw.println("null");
                }
                pw.println("      Pending alarms:");
                AlarmManagerService.dumpAlarmList(pw, this.mPendingWhileIdleAlarms, "      ", nowELAPSED, nowRTC, sdf);
            }
            if (this.mNextWakeFromIdle != null) {
                pw.println();
                pw.print("  Next wake from idle: ");
                pw.println(this.mNextWakeFromIdle);
                this.mNextWakeFromIdle.dump(pw, "    ", nowELAPSED, nowRTC, sdf);
            }
            pw.println();
            pw.print("  Past-due non-wakeup alarms: ");
            if (this.mPendingNonWakeupAlarms.size() > 0) {
                pw.println(this.mPendingNonWakeupAlarms.size());
                AlarmManagerService.dumpAlarmList(pw, this.mPendingNonWakeupAlarms, "    ", nowELAPSED, nowRTC, sdf);
            } else {
                pw.println("(none)");
            }
            pw.print("    Number of delayed alarms: ");
            pw.print(this.mNumDelayedAlarms);
            pw.print(", total delay time: ");
            TimeUtils.formatDuration(this.mTotalDelayTime, pw);
            pw.println();
            pw.print("    Max delay time: ");
            TimeUtils.formatDuration(this.mMaxDelayTime, pw);
            pw.print(", max non-interactive time: ");
            TimeUtils.formatDuration(this.mNonInteractiveTime, pw);
            pw.println();
            pw.println();
            pw.print("  Broadcast ref count: ");
            pw.println(this.mBroadcastRefCount);
            pw.print("  PendingIntent send count: ");
            pw.println(this.mSendCount);
            pw.print("  PendingIntent finish count: ");
            pw.println(this.mSendFinishCount);
            pw.print("  Listener send count: ");
            pw.println(this.mListenerCount);
            pw.print("  Listener finish count: ");
            pw.println(this.mListenerFinishCount);
            pw.println();
            if (this.mInFlight.size() > 0) {
                pw.println("Outstanding deliveries:");
                for (i = 0; i < this.mInFlight.size(); ++i) {
                    pw.print("   #");
                    pw.print(i);
                    pw.print(": ");
                    pw.println(this.mInFlight.get(i));
                }
                pw.println();
            }
            if (this.mLastAllowWhileIdleDispatch.size() > 0) {
                pw.println("  Last allow while idle dispatch times:");
                for (i = 0; i < this.mLastAllowWhileIdleDispatch.size(); ++i) {
                    pw.print("    UID ");
                    int uid = this.mLastAllowWhileIdleDispatch.keyAt(i);
                    UserHandle.formatUid(pw, uid);
                    pw.print(": ");
                    long lastTime = this.mLastAllowWhileIdleDispatch.valueAt(i);
                    TimeUtils.formatDuration(lastTime, nowELAPSED, pw);
                    long minInterval = this.getWhileIdleMinIntervalLocked(uid);
                    pw.print("  Next allowed:");
                    TimeUtils.formatDuration(lastTime + minInterval, nowELAPSED, pw);
                    pw.print(" (");
                    TimeUtils.formatDuration(minInterval, 0L, pw);
                    pw.print(")");
                    pw.println();
                }
            }
            pw.print("  mUseAllowWhileIdleShortTime: [");
            for (i = 0; i < this.mUseAllowWhileIdleShortTime.size(); ++i) {
                if (!this.mUseAllowWhileIdleShortTime.valueAt(i)) continue;
                UserHandle.formatUid(pw, this.mUseAllowWhileIdleShortTime.keyAt(i));
                pw.print(" ");
            }
            pw.println("]");
            pw.println();
            if (this.mLog.dump(pw, "  Recent problems", "    ")) {
                pw.println();
            }
            FilterStats[] topFilters = new FilterStats[10];
            Comparator<FilterStats> comparator = new Comparator<FilterStats>(){

                @Override
                public int compare(FilterStats lhs, FilterStats rhs) {
                    if (lhs.aggregateTime < rhs.aggregateTime) {
                        return 1;
                    }
                    if (lhs.aggregateTime > rhs.aggregateTime) {
                        return -1;
                    }
                    return 0;
                }
            };
            int len = 0;
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    BroadcastStats bs = uidStats.valueAt(ip);
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        int pos;
                        FilterStats fs = bs.filterStats.valueAt(is);
                        int n = pos = len > 0 ? Arrays.binarySearch(topFilters, 0, len, fs, comparator) : 0;
                        if (pos < 0) {
                            pos = -pos - 1;
                        }
                        if (pos >= topFilters.length) continue;
                        int copylen = topFilters.length - pos - 1;
                        if (copylen > 0) {
                            System.arraycopy(topFilters, pos, topFilters, pos + 1, copylen);
                        }
                        topFilters[pos] = fs;
                        if (len >= topFilters.length) continue;
                        ++len;
                    }
                }
            }
            if (len > 0) {
                pw.println("  Top Alarms:");
                for (int i4 = 0; i4 < len; ++i4) {
                    FilterStats fs = topFilters[i4];
                    pw.print("    ");
                    if (fs.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    TimeUtils.formatDuration(fs.aggregateTime, pw);
                    pw.print(" running, ");
                    pw.print(fs.numWakeup);
                    pw.print(" wakeups, ");
                    pw.print(fs.count);
                    pw.print(" alarms: ");
                    UserHandle.formatUid(pw, fs.mBroadcastStats.mUid);
                    pw.print(":");
                    pw.print(fs.mBroadcastStats.mPackageName);
                    pw.println();
                    pw.print("      ");
                    pw.print(fs.mTag);
                    pw.println();
                }
            }
            pw.println(" ");
            pw.println("  Alarm Stats:");
            ArrayList<FilterStats> tmpFilters = new ArrayList<FilterStats>();
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    BroadcastStats bs = uidStats.valueAt(ip);
                    pw.print("  ");
                    if (bs.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    UserHandle.formatUid(pw, bs.mUid);
                    pw.print(":");
                    pw.print(bs.mPackageName);
                    pw.print(" ");
                    TimeUtils.formatDuration(bs.aggregateTime, pw);
                    pw.print(" running, ");
                    pw.print(bs.numWakeup);
                    pw.println(" wakeups:");
                    tmpFilters.clear();
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        tmpFilters.add(bs.filterStats.valueAt(is));
                    }
                    Collections.sort(tmpFilters, comparator);
                    for (int i5 = 0; i5 < tmpFilters.size(); ++i5) {
                        FilterStats fs = (FilterStats)tmpFilters.get(i5);
                        pw.print("    ");
                        if (fs.nesting > 0) {
                            pw.print("*ACTIVE* ");
                        }
                        TimeUtils.formatDuration(fs.aggregateTime, pw);
                        pw.print(" ");
                        pw.print(fs.numWakeup);
                        pw.print(" wakes ");
                        pw.print(fs.count);
                        pw.print(" alarms, last ");
                        TimeUtils.formatDuration(fs.lastTime, nowELAPSED, pw);
                        pw.println(":");
                        pw.print("      ");
                        pw.print(fs.mTag);
                        pw.println();
                    }
                }
            }
            pw.println();
            this.mStatLogger.dump(pw, "  ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        Object object = this.mLock;
        synchronized (object) {
            int i;
            long nowRTC = System.currentTimeMillis();
            long nowElapsed = SystemClock.elapsedRealtime();
            proto.write(0x10300000001L, nowRTC);
            proto.write(1112396529666L, nowElapsed);
            proto.write(0x10300000003L, this.mLastTimeChangeClockTime);
            proto.write(1112396529668L, this.mLastTimeChangeRealtime);
            this.mConstants.dumpProto(proto, 1146756268037L);
            if (this.mAppStateTracker != null) {
                this.mAppStateTracker.dumpProto(proto, 1146756268038L);
            }
            proto.write(1133871366151L, this.mInteractive);
            if (!this.mInteractive) {
                proto.write(1112396529672L, nowElapsed - this.mNonInteractiveStartTime);
                proto.write(1112396529673L, this.currentNonWakeupFuzzLocked(nowElapsed));
                proto.write(1112396529674L, nowElapsed - this.mLastAlarmDeliveryTime);
                proto.write(1112396529675L, nowElapsed - this.mNextNonWakeupDeliveryTime);
            }
            proto.write(1112396529676L, this.mNextNonWakeup - nowElapsed);
            proto.write(1112396529677L, this.mNextWakeup - nowElapsed);
            proto.write(1112396529678L, nowElapsed - this.mLastWakeup);
            proto.write(1112396529679L, nowElapsed - this.mLastWakeupSet);
            proto.write(0x10300000010L, this.mNumTimeChanged);
            TreeSet<Integer> users = new TreeSet<Integer>();
            int nextAlarmClockForUserSize = this.mNextAlarmClockForUser.size();
            for (int i2 = 0; i2 < nextAlarmClockForUserSize; ++i2) {
                users.add(this.mNextAlarmClockForUser.keyAt(i2));
            }
            int pendingSendNextAlarmClockChangedForUserSize = this.mPendingSendNextAlarmClockChangedForUser.size();
            for (int i3 = 0; i3 < pendingSendNextAlarmClockChangedForUserSize; ++i3) {
                users.add(this.mPendingSendNextAlarmClockChangedForUser.keyAt(i3));
            }
            Iterator<Object> i3 = users.iterator();
            while (i3.hasNext()) {
                int user = (Integer)i3.next();
                AlarmManager.AlarmClockInfo next = this.mNextAlarmClockForUser.get(user);
                long time = next != null ? next.getTriggerTime() : 0L;
                boolean pendingSend = this.mPendingSendNextAlarmClockChangedForUser.get(user);
                long aToken = proto.start(2246267895826L);
                proto.write(0x10500000001L, user);
                proto.write(1133871366146L, pendingSend);
                proto.write(0x10300000003L, time);
                proto.end(aToken);
            }
            for (Batch b : this.mAlarmBatches) {
                b.writeToProto(proto, 2246267895827L, nowElapsed, nowRTC);
            }
            for (int i4 = 0; i4 < this.mPendingBackgroundAlarms.size(); ++i4) {
                ArrayList<Alarm> blockedAlarms = this.mPendingBackgroundAlarms.valueAt(i4);
                if (blockedAlarms == null) continue;
                for (Alarm a : blockedAlarms) {
                    a.writeToProto(proto, 2246267895828L, nowElapsed, nowRTC);
                }
            }
            if (this.mPendingIdleUntil != null) {
                this.mPendingIdleUntil.writeToProto(proto, 1146756268053L, nowElapsed, nowRTC);
            }
            for (Alarm a : this.mPendingWhileIdleAlarms) {
                a.writeToProto(proto, 2246267895830L, nowElapsed, nowRTC);
            }
            if (this.mNextWakeFromIdle != null) {
                this.mNextWakeFromIdle.writeToProto(proto, 1146756268055L, nowElapsed, nowRTC);
            }
            for (Alarm a : this.mPendingNonWakeupAlarms) {
                a.writeToProto(proto, 2246267895832L, nowElapsed, nowRTC);
            }
            proto.write(1120986464281L, this.mNumDelayedAlarms);
            proto.write(1112396529690L, this.mTotalDelayTime);
            proto.write(1112396529691L, this.mMaxDelayTime);
            proto.write(1112396529692L, this.mNonInteractiveTime);
            proto.write(1120986464285L, this.mBroadcastRefCount);
            proto.write(1120986464286L, this.mSendCount);
            proto.write(1120986464287L, this.mSendFinishCount);
            proto.write(1120986464288L, this.mListenerCount);
            proto.write(1120986464289L, this.mListenerFinishCount);
            for (InFlight f : this.mInFlight) {
                f.writeToProto(proto, 0x20B00000022L);
            }
            for (i = 0; i < this.mLastAllowWhileIdleDispatch.size(); ++i) {
                long token = proto.start(2246267895844L);
                int uid = this.mLastAllowWhileIdleDispatch.keyAt(i);
                long lastTime = this.mLastAllowWhileIdleDispatch.valueAt(i);
                proto.write(0x10500000001L, uid);
                proto.write(1112396529666L, lastTime);
                proto.write(0x10300000003L, lastTime + this.getWhileIdleMinIntervalLocked(uid));
                proto.end(token);
            }
            for (i = 0; i < this.mUseAllowWhileIdleShortTime.size(); ++i) {
                if (!this.mUseAllowWhileIdleShortTime.valueAt(i)) continue;
                proto.write(2220498092067L, this.mUseAllowWhileIdleShortTime.keyAt(i));
            }
            this.mLog.writeToProto(proto, 1146756268069L);
            FilterStats[] topFilters = new FilterStats[10];
            Comparator<FilterStats> comparator = new Comparator<FilterStats>(){

                @Override
                public int compare(FilterStats lhs, FilterStats rhs) {
                    if (lhs.aggregateTime < rhs.aggregateTime) {
                        return 1;
                    }
                    if (lhs.aggregateTime > rhs.aggregateTime) {
                        return -1;
                    }
                    return 0;
                }
            };
            int len = 0;
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    BroadcastStats bs = uidStats.valueAt(ip);
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        int pos;
                        FilterStats fs = bs.filterStats.valueAt(is);
                        int n = pos = len > 0 ? Arrays.binarySearch(topFilters, 0, len, fs, comparator) : 0;
                        if (pos < 0) {
                            pos = -pos - 1;
                        }
                        if (pos >= topFilters.length) continue;
                        int copylen = topFilters.length - pos - 1;
                        if (copylen > 0) {
                            System.arraycopy(topFilters, pos, topFilters, pos + 1, copylen);
                        }
                        topFilters[pos] = fs;
                        if (len >= topFilters.length) continue;
                        ++len;
                    }
                }
            }
            for (int i5 = 0; i5 < len; ++i5) {
                long token = proto.start(2246267895846L);
                FilterStats fs = topFilters[i5];
                proto.write(0x10500000001L, fs.mBroadcastStats.mUid);
                proto.write(1138166333442L, fs.mBroadcastStats.mPackageName);
                fs.writeToProto(proto, 1146756268035L);
                proto.end(token);
            }
            ArrayList<FilterStats> tmpFilters = new ArrayList<FilterStats>();
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    long token = proto.start(2246267895847L);
                    BroadcastStats bs = uidStats.valueAt(ip);
                    bs.writeToProto(proto, 0x10B00000001L);
                    tmpFilters.clear();
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        tmpFilters.add(bs.filterStats.valueAt(is));
                    }
                    Collections.sort(tmpFilters, comparator);
                    for (FilterStats fs : tmpFilters) {
                        fs.writeToProto(proto, 0x20B00000002L);
                    }
                    proto.end(token);
                }
            }
        }
        proto.flush();
    }

    private void logBatchesLocked(SimpleDateFormat sdf) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(2048);
        PrintWriter pw = new PrintWriter(bs);
        long nowRTC = System.currentTimeMillis();
        long nowELAPSED = SystemClock.elapsedRealtime();
        int NZ = this.mAlarmBatches.size();
        for (int iz = 0; iz < NZ; ++iz) {
            Batch bz = this.mAlarmBatches.get(iz);
            pw.append("Batch ");
            pw.print(iz);
            pw.append(": ");
            pw.println(bz);
            AlarmManagerService.dumpAlarmList(pw, bz.alarms, "  ", nowELAPSED, nowRTC, sdf);
            pw.flush();
            Slog.v(TAG, bs.toString());
            bs.reset();
        }
    }

    private boolean validateConsistencyLocked() {
        return true;
    }

    private Batch findFirstWakeupBatchLocked() {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasWakeups()) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextWakeFromIdleTimeImpl() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextWakeFromIdle != null ? this.mNextWakeFromIdle.whenElapsed : Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlarmManager.AlarmClockInfo getNextAlarmClockImpl(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextAlarmClockForUser.get(userId);
        }
    }

    private void updateNextAlarmClockLocked() {
        int userId;
        if (!this.mNextAlarmClockMayChange) {
            return;
        }
        this.mNextAlarmClockMayChange = false;
        SparseArray<AlarmManager.AlarmClockInfo> nextForUser = this.mTmpSparseAlarmClockArray;
        nextForUser.clear();
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            ArrayList<Alarm> alarms = this.mAlarmBatches.get((int)i).alarms;
            int M = alarms.size();
            for (int j = 0; j < M; ++j) {
                Alarm a = alarms.get(j);
                if (a.alarmClock == null) continue;
                int userId2 = UserHandle.getUserId(a.uid);
                AlarmManager.AlarmClockInfo current = this.mNextAlarmClockForUser.get(userId2);
                if (nextForUser.get(userId2) == null) {
                    nextForUser.put(userId2, a.alarmClock);
                    continue;
                }
                if (!a.alarmClock.equals(current) || current.getTriggerTime() > nextForUser.get(userId2).getTriggerTime()) continue;
                nextForUser.put(userId2, current);
            }
        }
        int NN = nextForUser.size();
        for (int i = 0; i < NN; ++i) {
            AlarmManager.AlarmClockInfo currentAlarm;
            AlarmManager.AlarmClockInfo newAlarm = nextForUser.valueAt(i);
            if (newAlarm.equals(currentAlarm = this.mNextAlarmClockForUser.get(userId = nextForUser.keyAt(i)))) continue;
            this.updateNextAlarmInfoForUserLocked(userId, newAlarm);
        }
        int NNN = this.mNextAlarmClockForUser.size();
        for (int i = NNN - 1; i >= 0; --i) {
            userId = this.mNextAlarmClockForUser.keyAt(i);
            if (nextForUser.get(userId) != null) continue;
            this.updateNextAlarmInfoForUserLocked(userId, null);
        }
    }

    private void updateNextAlarmInfoForUserLocked(int userId, AlarmManager.AlarmClockInfo alarmClock) {
        if (alarmClock != null) {
            this.mNextAlarmClockForUser.put(userId, alarmClock);
        } else {
            this.mNextAlarmClockForUser.remove(userId);
        }
        this.mPendingSendNextAlarmClockChangedForUser.put(userId, true);
        this.mHandler.removeMessages(2);
        this.mHandler.sendEmptyMessage(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNextAlarmClockChanged() {
        SparseArray<AlarmManager.AlarmClockInfo> pendingUsers = this.mHandlerSparseAlarmClockArray;
        pendingUsers.clear();
        Object object = this.mLock;
        synchronized (object) {
            int N = this.mPendingSendNextAlarmClockChangedForUser.size();
            for (int i = 0; i < N; ++i) {
                int userId = this.mPendingSendNextAlarmClockChangedForUser.keyAt(i);
                pendingUsers.append(userId, this.mNextAlarmClockForUser.get(userId));
            }
            this.mPendingSendNextAlarmClockChangedForUser.clear();
        }
        int N = pendingUsers.size();
        for (int i = 0; i < N; ++i) {
            int userId = pendingUsers.keyAt(i);
            AlarmManager.AlarmClockInfo alarmClock = pendingUsers.valueAt(i);
            Settings.System.putStringForUser(this.getContext().getContentResolver(), "next_alarm_formatted", AlarmManagerService.formatNextAlarm(this.getContext(), alarmClock, userId), userId);
            this.getContext().sendBroadcastAsUser(NEXT_ALARM_CLOCK_CHANGED_INTENT, new UserHandle(userId));
        }
    }

    private static String formatNextAlarm(Context context, AlarmManager.AlarmClockInfo info, int userId) {
        String skeleton = DateFormat.is24HourFormat(context, userId) ? "EHm" : "Ehma";
        String pattern = DateFormat.getBestDateTimePattern(Locale.getDefault(), skeleton);
        return info == null ? "" : DateFormat.format((CharSequence)pattern, info.getTriggerTime()).toString();
    }

    void rescheduleKernelAlarmsLocked() {
        long nextNonWakeup = 0L;
        if (this.mAlarmBatches.size() > 0) {
            Batch firstWakeup = this.findFirstWakeupBatchLocked();
            Batch firstBatch = this.mAlarmBatches.get(0);
            if (firstWakeup != null) {
                this.mNextWakeup = firstWakeup.start;
                this.mLastWakeupSet = SystemClock.elapsedRealtime();
                this.setLocked(2, firstWakeup.start);
            }
            if (firstBatch != firstWakeup) {
                nextNonWakeup = firstBatch.start;
            }
        }
        if (this.mPendingNonWakeupAlarms.size() > 0 && (nextNonWakeup == 0L || this.mNextNonWakeupDeliveryTime < nextNonWakeup)) {
            nextNonWakeup = this.mNextNonWakeupDeliveryTime;
        }
        if (nextNonWakeup != 0L) {
            this.mNextNonWakeup = nextNonWakeup;
            this.setLocked(3, nextNonWakeup);
        }
    }

    private void removeLocked(PendingIntent operation, IAlarmListener directReceiver) {
        int i;
        if (operation == null && directReceiver == null) {
            return;
        }
        boolean didRemove = false;
        Predicate<Alarm> whichAlarms = a -> a.matches(operation, directReceiver);
        for (i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(whichAlarms);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        for (i = this.mPendingWhileIdleAlarms.size() - 1; i >= 0; --i) {
            if (!this.mPendingWhileIdleAlarms.get(i).matches(operation, directReceiver)) continue;
            this.mPendingWhileIdleAlarms.remove(i);
        }
        for (i = this.mPendingBackgroundAlarms.size() - 1; i >= 0; --i) {
            ArrayList<Alarm> alarmsForUid = this.mPendingBackgroundAlarms.valueAt(i);
            for (int j = alarmsForUid.size() - 1; j >= 0; --j) {
                if (!alarmsForUid.get(j).matches(operation, directReceiver)) continue;
                alarmsForUid.remove(j);
            }
            if (alarmsForUid.size() != 0) continue;
            this.mPendingBackgroundAlarms.removeAt(i);
        }
        if (didRemove) {
            boolean restorePending = false;
            if (this.mPendingIdleUntil != null && this.mPendingIdleUntil.matches(operation, directReceiver)) {
                this.mPendingIdleUntil = null;
                restorePending = true;
            }
            if (this.mNextWakeFromIdle != null && this.mNextWakeFromIdle.matches(operation, directReceiver)) {
                this.mNextWakeFromIdle = null;
            }
            this.rebatchAllAlarmsLocked(true);
            if (restorePending) {
                this.restorePendingWhileIdleAlarmsLocked();
            }
            this.updateNextAlarmClockLocked();
        }
    }

    void removeLocked(int uid) {
        int i;
        if (uid == 1000) {
            Slog.wtf(TAG, "removeLocked: Shouldn't for UID=" + uid);
            return;
        }
        boolean didRemove = false;
        Predicate<Alarm> whichAlarms = a -> a.uid == uid;
        for (i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(whichAlarms);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        for (i = this.mPendingWhileIdleAlarms.size() - 1; i >= 0; --i) {
            Alarm a2 = this.mPendingWhileIdleAlarms.get(i);
            if (a2.uid != uid) continue;
            this.mPendingWhileIdleAlarms.remove(i);
        }
        for (i = this.mPendingBackgroundAlarms.size() - 1; i >= 0; --i) {
            ArrayList<Alarm> alarmsForUid = this.mPendingBackgroundAlarms.valueAt(i);
            for (int j = alarmsForUid.size() - 1; j >= 0; --j) {
                if (alarmsForUid.get((int)j).uid != uid) continue;
                alarmsForUid.remove(j);
            }
            if (alarmsForUid.size() != 0) continue;
            this.mPendingBackgroundAlarms.removeAt(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void removeLocked(String packageName) {
        int i;
        if (packageName == null) {
            return;
        }
        boolean didRemove = false;
        Predicate<Alarm> whichAlarms = a -> a.matches(packageName);
        boolean oldHasTick = this.haveBatchesTimeTickAlarm(this.mAlarmBatches);
        for (int i2 = this.mAlarmBatches.size() - 1; i2 >= 0; --i2) {
            Batch b = this.mAlarmBatches.get(i2);
            didRemove |= b.remove(whichAlarms);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i2);
        }
        boolean newHasTick = this.haveBatchesTimeTickAlarm(this.mAlarmBatches);
        if (oldHasTick != newHasTick) {
            Slog.wtf(TAG, "removeLocked: hasTick changed from " + oldHasTick + " to " + newHasTick);
        }
        for (i = this.mPendingWhileIdleAlarms.size() - 1; i >= 0; --i) {
            Alarm a2 = this.mPendingWhileIdleAlarms.get(i);
            if (!a2.matches(packageName)) continue;
            this.mPendingWhileIdleAlarms.remove(i);
        }
        for (i = this.mPendingBackgroundAlarms.size() - 1; i >= 0; --i) {
            ArrayList<Alarm> alarmsForUid = this.mPendingBackgroundAlarms.valueAt(i);
            for (int j = alarmsForUid.size() - 1; j >= 0; --j) {
                if (!alarmsForUid.get(j).matches(packageName)) continue;
                alarmsForUid.remove(j);
            }
            if (alarmsForUid.size() != 0) continue;
            this.mPendingBackgroundAlarms.removeAt(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void removeForStoppedLocked(int uid) {
        int i;
        if (uid == 1000) {
            Slog.wtf(TAG, "removeForStoppedLocked: Shouldn't for UID=" + uid);
            return;
        }
        boolean didRemove = false;
        Predicate<Alarm> whichAlarms = a -> {
            try {
                if (a.uid == uid && ActivityManager.getService().isAppStartModeDisabled(uid, a.packageName)) {
                    return true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        };
        for (i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(whichAlarms);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        for (i = this.mPendingWhileIdleAlarms.size() - 1; i >= 0; --i) {
            Alarm a2 = this.mPendingWhileIdleAlarms.get(i);
            if (a2.uid != uid) continue;
            this.mPendingWhileIdleAlarms.remove(i);
        }
        for (i = this.mPendingBackgroundAlarms.size() - 1; i >= 0; --i) {
            if (this.mPendingBackgroundAlarms.keyAt(i) != uid) continue;
            this.mPendingBackgroundAlarms.removeAt(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void removeUserLocked(int userHandle) {
        int i;
        if (userHandle == 0) {
            Slog.wtf(TAG, "removeForStoppedLocked: Shouldn't for user=" + userHandle);
            return;
        }
        boolean didRemove = false;
        Predicate<Alarm> whichAlarms = a -> UserHandle.getUserId(a.creatorUid) == userHandle;
        for (i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(whichAlarms);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        for (i = this.mPendingWhileIdleAlarms.size() - 1; i >= 0; --i) {
            if (UserHandle.getUserId(this.mPendingWhileIdleAlarms.get((int)i).creatorUid) != userHandle) continue;
            this.mPendingWhileIdleAlarms.remove(i);
        }
        for (i = this.mPendingBackgroundAlarms.size() - 1; i >= 0; --i) {
            if (UserHandle.getUserId(this.mPendingBackgroundAlarms.keyAt(i)) != userHandle) continue;
            this.mPendingBackgroundAlarms.removeAt(i);
        }
        for (i = this.mLastAllowWhileIdleDispatch.size() - 1; i >= 0; --i) {
            if (UserHandle.getUserId(this.mLastAllowWhileIdleDispatch.keyAt(i)) != userHandle) continue;
            this.mLastAllowWhileIdleDispatch.removeAt(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void interactiveStateChangedLocked(boolean interactive) {
        if (this.mInteractive != interactive) {
            this.mInteractive = interactive;
            long nowELAPSED = SystemClock.elapsedRealtime();
            if (interactive) {
                long dur;
                if (this.mPendingNonWakeupAlarms.size() > 0) {
                    long thisDelayTime = nowELAPSED - this.mStartCurrentDelayTime;
                    this.mTotalDelayTime += thisDelayTime;
                    if (this.mMaxDelayTime < thisDelayTime) {
                        this.mMaxDelayTime = thisDelayTime;
                    }
                    this.deliverAlarmsLocked(this.mPendingNonWakeupAlarms, nowELAPSED);
                    this.mPendingNonWakeupAlarms.clear();
                }
                if (this.mNonInteractiveStartTime > 0L && (dur = nowELAPSED - this.mNonInteractiveStartTime) > this.mNonInteractiveTime) {
                    this.mNonInteractiveTime = dur;
                }
            } else {
                this.mNonInteractiveStartTime = nowELAPSED;
            }
        }
    }

    boolean lookForPackageLocked(String packageName) {
        int i;
        for (i = 0; i < this.mAlarmBatches.size(); ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasPackage(packageName)) continue;
            return true;
        }
        for (i = 0; i < this.mPendingWhileIdleAlarms.size(); ++i) {
            Alarm a = this.mPendingWhileIdleAlarms.get(i);
            if (!a.matches(packageName)) continue;
            return true;
        }
        return false;
    }

    private void setLocked(int type, long when) {
        if (this.mNativeData != 0L) {
            long alarmNanoseconds;
            long alarmSeconds;
            if (when < 0L) {
                alarmSeconds = 0L;
                alarmNanoseconds = 0L;
            } else {
                alarmSeconds = when / 1000L;
                alarmNanoseconds = when % 1000L * 1000L * 1000L;
            }
            int result = this.set(this.mNativeData, type, alarmSeconds, alarmNanoseconds);
            if (result != 0) {
                long nowElapsed = SystemClock.elapsedRealtime();
                Slog.wtf(TAG, "Unable to set kernel alarm, now=" + nowElapsed + " type=" + type + " when=" + when + " @ (" + alarmSeconds + "," + alarmNanoseconds + "), ret = " + result + " = " + Os.strerror(result));
            }
        } else {
            Message msg = Message.obtain();
            msg.what = 1;
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, String label, long nowELAPSED, long nowRTC, SimpleDateFormat sdf) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", nowELAPSED, nowRTC, sdf);
        }
    }

    private static final String labelForType(int type) {
        switch (type) {
            case 1: {
                return "RTC";
            }
            case 0: {
                return "RTC_WAKEUP";
            }
            case 3: {
                return "ELAPSED";
            }
            case 2: {
                return "ELAPSED_WAKEUP";
            }
        }
        return "--unknown--";
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, long nowELAPSED, long nowRTC, SimpleDateFormat sdf) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            String label = AlarmManagerService.labelForType(a.type);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", nowELAPSED, nowRTC, sdf);
        }
    }

    private boolean isBackgroundRestricted(Alarm alarm) {
        boolean exemptOnBatterySaver;
        boolean bl = exemptOnBatterySaver = (alarm.flags & 4) != 0;
        if (alarm.alarmClock != null) {
            return false;
        }
        if (alarm.operation != null) {
            if (alarm.operation.isActivity()) {
                return false;
            }
            if (alarm.operation.isForegroundService()) {
                exemptOnBatterySaver = true;
            }
        }
        String sourcePackage = alarm.sourcePackage;
        int sourceUid = alarm.creatorUid;
        return this.mAppStateTracker != null && this.mAppStateTracker.areAlarmsRestricted(sourceUid, sourcePackage, exemptOnBatterySaver);
    }

    private native long init();

    private native void close(long var1);

    private native int set(long var1, int var3, long var4, long var6);

    private native int waitForAlarm(long var1);

    private native int setKernelTime(long var1, long var3);

    private native int setKernelTimezone(long var1, int var3);

    private long getWhileIdleMinIntervalLocked(int uid) {
        boolean ebs;
        boolean dozing = this.mPendingIdleUntil != null;
        boolean bl = ebs = this.mAppStateTracker != null && this.mAppStateTracker.isForceAllAppsStandbyEnabled();
        if (!dozing && !ebs) {
            return this.mConstants.ALLOW_WHILE_IDLE_SHORT_TIME;
        }
        if (dozing) {
            return this.mConstants.ALLOW_WHILE_IDLE_LONG_TIME;
        }
        if (this.mUseAllowWhileIdleShortTime.get(uid)) {
            return this.mConstants.ALLOW_WHILE_IDLE_SHORT_TIME;
        }
        return this.mConstants.ALLOW_WHILE_IDLE_LONG_TIME;
    }

    boolean triggerAlarmsLocked(ArrayList<Alarm> triggerList, long nowELAPSED, long nowRTC) {
        boolean hasWakeup = false;
        while (this.mAlarmBatches.size() > 0) {
            Batch batch = this.mAlarmBatches.get(0);
            if (batch.start > nowELAPSED) break;
            this.mAlarmBatches.remove(0);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                Alarm alarm = batch.get(i);
                if ((alarm.flags & 4) != 0) {
                    long lastTime = this.mLastAllowWhileIdleDispatch.get(alarm.creatorUid, -1L);
                    long minTime = lastTime + this.getWhileIdleMinIntervalLocked(alarm.creatorUid);
                    if (lastTime >= 0L && nowELAPSED < minTime) {
                        alarm.expectedWhenElapsed = alarm.whenElapsed = minTime;
                        if (alarm.maxWhenElapsed < minTime) {
                            alarm.maxWhenElapsed = minTime;
                        }
                        alarm.expectedMaxWhenElapsed = alarm.maxWhenElapsed;
                        this.setImplLocked(alarm, true, false);
                        continue;
                    }
                }
                if (this.isBackgroundRestricted(alarm)) {
                    ArrayList<Alarm> alarmsForUid = this.mPendingBackgroundAlarms.get(alarm.creatorUid);
                    if (alarmsForUid == null) {
                        alarmsForUid = new ArrayList();
                        this.mPendingBackgroundAlarms.put(alarm.creatorUid, alarmsForUid);
                    }
                    alarmsForUid.add(alarm);
                    continue;
                }
                alarm.count = 1;
                triggerList.add(alarm);
                if ((alarm.flags & 2) != 0) {
                    EventLogTags.writeDeviceIdleWakeFromIdle(this.mPendingIdleUntil != null ? 1 : 0, alarm.statsTag);
                }
                if (this.mPendingIdleUntil == alarm) {
                    this.mPendingIdleUntil = null;
                    this.rebatchAllAlarmsLocked(false);
                    this.restorePendingWhileIdleAlarmsLocked();
                }
                if (this.mNextWakeFromIdle == alarm) {
                    this.mNextWakeFromIdle = null;
                    this.rebatchAllAlarmsLocked(false);
                }
                if (alarm.repeatInterval > 0L) {
                    alarm.count = (int)((long)alarm.count + (nowELAPSED - alarm.expectedWhenElapsed) / alarm.repeatInterval);
                    long delta = (long)alarm.count * alarm.repeatInterval;
                    long nextElapsed = alarm.whenElapsed + delta;
                    this.setImplLocked(alarm.type, alarm.when + delta, nextElapsed, alarm.windowLength, AlarmManagerService.maxTriggerTime(nowELAPSED, nextElapsed, alarm.repeatInterval), alarm.repeatInterval, alarm.operation, null, null, alarm.flags, true, alarm.workSource, alarm.alarmClock, alarm.uid, alarm.packageName);
                }
                if (alarm.wakeup) {
                    hasWakeup = true;
                }
                if (alarm.alarmClock == null) continue;
                this.mNextAlarmClockMayChange = true;
            }
        }
        ++this.mCurrentSeq;
        this.calculateDeliveryPriorities(triggerList);
        Collections.sort(triggerList, this.mAlarmDispatchComparator);
        return hasWakeup;
    }

    void recordWakeupAlarms(ArrayList<Batch> batches, long nowELAPSED, long nowRTC) {
        int numBatches = batches.size();
        for (int nextBatch = 0; nextBatch < numBatches; ++nextBatch) {
            Batch b = batches.get(nextBatch);
            if (b.start > nowELAPSED) break;
            int numAlarms = b.alarms.size();
            for (int nextAlarm = 0; nextAlarm < numAlarms; ++nextAlarm) {
                Alarm a = b.alarms.get(nextAlarm);
                this.mRecentWakeups.add(a.makeWakeupEvent(nowRTC));
            }
        }
    }

    long currentNonWakeupFuzzLocked(long nowELAPSED) {
        long timeSinceOn = nowELAPSED - this.mNonInteractiveStartTime;
        if (timeSinceOn < 300000L) {
            return 120000L;
        }
        if (timeSinceOn < 1800000L) {
            return 900000L;
        }
        return 3600000L;
    }

    static int fuzzForDuration(long duration) {
        if (duration < 900000L) {
            return (int)duration;
        }
        if (duration < 5400000L) {
            return 900000;
        }
        return 1800000;
    }

    boolean checkAllowNonWakeupDelayLocked(long nowELAPSED) {
        if (this.mInteractive) {
            return false;
        }
        if (this.mLastAlarmDeliveryTime <= 0L) {
            return false;
        }
        if (this.mPendingNonWakeupAlarms.size() > 0 && this.mNextNonWakeupDeliveryTime < nowELAPSED) {
            return false;
        }
        long timeSinceLast = nowELAPSED - this.mLastAlarmDeliveryTime;
        return timeSinceLast <= this.currentNonWakeupFuzzLocked(nowELAPSED);
    }

    void deliverAlarmsLocked(ArrayList<Alarm> triggerList, long nowELAPSED) {
        this.mLastAlarmDeliveryTime = nowELAPSED;
        for (int i = 0; i < triggerList.size(); ++i) {
            boolean allowWhileIdle;
            Alarm alarm = triggerList.get(i);
            boolean bl = allowWhileIdle = (alarm.flags & 4) != 0;
            if (alarm.wakeup) {
                Trace.traceBegin(131072L, "Dispatch wakeup alarm to " + alarm.packageName);
            } else {
                Trace.traceBegin(131072L, "Dispatch non-wakeup alarm to " + alarm.packageName);
            }
            try {
                ActivityManager.noteAlarmStart(alarm.operation, alarm.workSource, alarm.uid, alarm.statsTag);
                this.mDeliveryTracker.deliverLocked(alarm, nowELAPSED, allowWhileIdle);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Failure sending alarm.", e);
            }
            Trace.traceEnd(131072L);
        }
    }

    private boolean isExemptFromAppStandby(Alarm a) {
        return a.alarmClock != null || UserHandle.isCore(a.creatorUid) || (a.flags & 8) != 0;
    }

    void setWakelockWorkSource(PendingIntent pi, WorkSource ws, int type, String tag, int knownUid, boolean first) {
        try {
            int uid;
            boolean unimportant = pi == this.mTimeTickSender;
            this.mWakeLock.setUnimportantForLogging(unimportant);
            if (first || this.mLastWakeLockUnimportantForLogging) {
                this.mWakeLock.setHistoryTag(tag);
            } else {
                this.mWakeLock.setHistoryTag(null);
            }
            this.mLastWakeLockUnimportantForLogging = unimportant;
            if (ws != null) {
                this.mWakeLock.setWorkSource(ws);
                return;
            }
            int n = uid = knownUid >= 0 ? knownUid : ActivityManager.getService().getUidForIntentSender(pi.getTarget());
            if (uid >= 0) {
                this.mWakeLock.setWorkSource(new WorkSource(uid));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWakeLock.setWorkSource(null);
    }

    private final BroadcastStats getStatsLocked(PendingIntent pi) {
        String pkg = pi.getCreatorPackage();
        int uid = pi.getCreatorUid();
        return this.getStatsLocked(uid, pkg);
    }

    private final BroadcastStats getStatsLocked(int uid, String pkgName) {
        BroadcastStats bs;
        ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.get(uid);
        if (uidStats == null) {
            uidStats = new ArrayMap();
            this.mBroadcastStats.put(uid, uidStats);
        }
        if ((bs = uidStats.get(pkgName)) == null) {
            bs = new BroadcastStats(uid, pkgName);
            uidStats.put(pkgName, bs);
        }
        return bs;
    }

    private class ShellCmd
    extends ShellCommand {
        private ShellCmd() {
        }

        IAlarmManager getBinderService() {
            return IAlarmManager.Stub.asInterface(AlarmManagerService.this.mService);
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "set-time": {
                        long millis = Long.parseLong(this.getNextArgRequired());
                        return this.getBinderService().setTime(millis) ? 0 : -1;
                    }
                    case "set-timezone": {
                        String tz = this.getNextArgRequired();
                        this.getBinderService().setTimeZone(tz);
                        return 0;
                    }
                }
                return this.handleDefaultCommands(cmd);
            }
            catch (Exception e) {
                pw.println(e);
                return -1;
            }
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Alarm manager service (alarm) commands:");
            pw.println("  help");
            pw.println("    Print this help text.");
            pw.println("  set-time TIME");
            pw.println("    Set the system clock time to TIME where TIME is milliseconds");
            pw.println("    since the Epoch.");
            pw.println("  set-timezone TZ");
            pw.println("    Set the system timezone to TZ where TZ is an Olson id.");
        }
    }

    class DeliveryTracker
    extends IAlarmCompleteListener.Stub
    implements PendingIntent.OnFinished {
        DeliveryTracker() {
        }

        private InFlight removeLocked(PendingIntent pi, Intent intent) {
            for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                if (AlarmManagerService.this.mInFlight.get((int)i).mPendingIntent != pi) continue;
                return AlarmManagerService.this.mInFlight.remove(i);
            }
            AlarmManagerService.this.mLog.w("No in-flight alarm for " + pi + " " + intent);
            return null;
        }

        private InFlight removeLocked(IBinder listener) {
            for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                if (AlarmManagerService.this.mInFlight.get((int)i).mListener != listener) continue;
                return AlarmManagerService.this.mInFlight.remove(i);
            }
            AlarmManagerService.this.mLog.w("No in-flight alarm for listener " + listener);
            return null;
        }

        private void updateStatsLocked(InFlight inflight) {
            long nowELAPSED = SystemClock.elapsedRealtime();
            BroadcastStats bs = inflight.mBroadcastStats;
            --bs.nesting;
            if (bs.nesting <= 0) {
                bs.nesting = 0;
                bs.aggregateTime += nowELAPSED - bs.startTime;
            }
            FilterStats fs = inflight.mFilterStats;
            --fs.nesting;
            if (fs.nesting <= 0) {
                fs.nesting = 0;
                fs.aggregateTime += nowELAPSED - fs.startTime;
            }
            ActivityManager.noteAlarmFinish(inflight.mPendingIntent, inflight.mWorkSource, inflight.mUid, inflight.mTag);
        }

        private void updateTrackingLocked(InFlight inflight) {
            if (inflight != null) {
                this.updateStatsLocked(inflight);
            }
            --AlarmManagerService.this.mBroadcastRefCount;
            if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                AlarmManagerService.this.mHandler.obtainMessage(4, 0).sendToTarget();
                AlarmManagerService.this.mWakeLock.release();
                if (AlarmManagerService.this.mInFlight.size() > 0) {
                    AlarmManagerService.this.mLog.w("Finished all dispatches with " + AlarmManagerService.this.mInFlight.size() + " remaining inflights");
                    for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                        AlarmManagerService.this.mLog.w("  Remaining #" + i + ": " + AlarmManagerService.this.mInFlight.get(i));
                    }
                    AlarmManagerService.this.mInFlight.clear();
                }
            } else if (AlarmManagerService.this.mInFlight.size() > 0) {
                InFlight inFlight = AlarmManagerService.this.mInFlight.get(0);
                AlarmManagerService.this.setWakelockWorkSource(inFlight.mPendingIntent, inFlight.mWorkSource, inFlight.mAlarmType, inFlight.mTag, -1, false);
            } else {
                AlarmManagerService.this.mLog.w("Alarm wakelock still held but sent queue empty");
                AlarmManagerService.this.mWakeLock.setWorkSource(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alarmComplete(IBinder who) {
            if (who == null) {
                AlarmManagerService.this.mLog.w("Invalid alarmComplete: uid=" + Binder.getCallingUid() + " pid=" + Binder.getCallingPid());
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    AlarmManagerService.this.mHandler.removeMessages(3, who);
                    InFlight inflight = this.removeLocked(who);
                    if (inflight != null) {
                        this.updateTrackingLocked(inflight);
                        AlarmManagerService.this.mListenerFinishCount++;
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendFinished(PendingIntent pi, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.mSendFinishCount++;
                this.updateTrackingLocked(this.removeLocked(pi, intent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarmTimedOut(IBinder who) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                InFlight inflight = this.removeLocked(who);
                if (inflight != null) {
                    this.updateTrackingLocked(inflight);
                    AlarmManagerService.this.mListenerFinishCount++;
                } else {
                    AlarmManagerService.this.mLog.w("Spurious timeout of listener " + who);
                }
            }
        }

        @GuardedBy(value="mLock")
        public void deliverLocked(Alarm alarm, long nowELAPSED, boolean allowWhileIdle) {
            if (alarm.operation != null) {
                AlarmManagerService.this.mSendCount++;
                if (alarm.priorityClass.priority == 0) {
                    AlarmManagerService.this.mLastTickIssued = nowELAPSED;
                }
                try {
                    alarm.operation.send(AlarmManagerService.this.getContext(), 0, AlarmManagerService.this.mBackgroundIntent.putExtra("android.intent.extra.ALARM_COUNT", alarm.count), AlarmManagerService.this.mDeliveryTracker, AlarmManagerService.this.mHandler, null, allowWhileIdle ? AlarmManagerService.this.mIdleOptions : null);
                }
                catch (PendingIntent.CanceledException e) {
                    if (alarm.operation == AlarmManagerService.this.mTimeTickSender) {
                        Slog.wtf(AlarmManagerService.TAG, "mTimeTickSender canceled");
                    }
                    if (alarm.repeatInterval > 0L) {
                        AlarmManagerService.this.removeImpl(alarm.operation);
                    }
                    AlarmManagerService.this.mSendFinishCount++;
                    return;
                }
            }
            AlarmManagerService.this.mListenerCount++;
            try {
                alarm.listener.doAlarm(this);
                AlarmManagerService.this.mHandler.sendMessageDelayed(AlarmManagerService.this.mHandler.obtainMessage(3, alarm.listener.asBinder()), AlarmManagerService.this.mConstants.LISTENER_TIMEOUT);
            }
            catch (Exception e) {
                AlarmManagerService.this.mListenerFinishCount++;
                return;
            }
            if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                AlarmManagerService.this.setWakelockWorkSource(alarm.operation, alarm.workSource, alarm.type, alarm.statsTag, alarm.operation == null ? alarm.uid : -1, true);
                AlarmManagerService.this.mWakeLock.acquire();
                AlarmManagerService.this.mHandler.obtainMessage(4, 1).sendToTarget();
            }
            InFlight inflight = new InFlight(AlarmManagerService.this, alarm.operation, alarm.listener, alarm.workSource, alarm.uid, alarm.packageName, alarm.type, alarm.statsTag, nowELAPSED);
            AlarmManagerService.this.mInFlight.add(inflight);
            ++AlarmManagerService.this.mBroadcastRefCount;
            if (allowWhileIdle) {
                AlarmManagerService.this.mLastAllowWhileIdleDispatch.put(alarm.creatorUid, nowELAPSED);
                if (AlarmManagerService.this.mAppStateTracker == null || AlarmManagerService.this.mAppStateTracker.isUidInForeground(alarm.creatorUid)) {
                    AlarmManagerService.this.mUseAllowWhileIdleShortTime.put(alarm.creatorUid, true);
                } else {
                    AlarmManagerService.this.mUseAllowWhileIdleShortTime.put(alarm.creatorUid, false);
                }
            }
            if (!AlarmManagerService.this.isExemptFromAppStandby(alarm)) {
                Pair<String, Integer> packageUser = Pair.create(alarm.sourcePackage, UserHandle.getUserId(alarm.creatorUid));
                AlarmManagerService.this.mLastAlarmDeliveredForPackage.put(packageUser, nowELAPSED);
            }
            BroadcastStats bs = inflight.mBroadcastStats;
            ++bs.count;
            if (bs.nesting == 0) {
                bs.nesting = 1;
                bs.startTime = nowELAPSED;
            } else {
                ++bs.nesting;
            }
            FilterStats fs = inflight.mFilterStats;
            ++fs.count;
            if (fs.nesting == 0) {
                fs.nesting = 1;
                fs.startTime = nowELAPSED;
            } else {
                ++fs.nesting;
            }
            if (alarm.type == 2 || alarm.type == 0) {
                ++bs.numWakeup;
                ++fs.numWakeup;
                ActivityManager.noteWakeupAlarm(alarm.operation, alarm.workSource, alarm.uid, alarm.packageName, alarm.statsTag);
            }
        }
    }

    final class AppStandbyTracker
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        AppStandbyTracker() {
        }

        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            AlarmManagerService.this.mHandler.removeMessages(5);
            AlarmManagerService.this.mHandler.obtainMessage(5, userId, -1, packageName).sendToTarget();
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            AlarmManagerService.this.mHandler.removeMessages(5);
            AlarmManagerService.this.mHandler.removeMessages(6);
            AlarmManagerService.this.mHandler.obtainMessage(6, isParoleOn).sendToTarget();
        }
    }

    final class UidObserver
    extends IUidObserver.Stub {
        UidObserver() {
        }

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            if (disabled) {
                AlarmManagerService.this.mHandler.postRemoveForStopped(uid);
            }
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
            if (disabled) {
                AlarmManagerService.this.mHandler.postRemoveForStopped(uid);
            }
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    }

    class UninstallReceiver
    extends BroadcastReceiver {
        public UninstallReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            filter.addDataScheme("package");
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
            IntentFilter sdFilter = new IntentFilter();
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
            sdFilter.addAction("android.intent.action.USER_STOPPED");
            sdFilter.addAction("android.intent.action.UID_REMOVED");
            AlarmManagerService.this.getContext().registerReceiver(this, sdFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                String[] pkgList = null;
                if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
                    for (String packageName : pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES")) {
                        if (!AlarmManagerService.this.lookForPackageLocked(packageName)) continue;
                        this.setResultCode(-1);
                        return;
                    }
                    return;
                }
                if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                    int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    if (userHandle >= 0) {
                        AlarmManagerService.this.removeUserLocked(userHandle);
                        for (int i = AlarmManagerService.this.mLastAlarmDeliveredForPackage.size() - 1; i >= 0; --i) {
                            Pair packageUser = (Pair)AlarmManagerService.this.mLastAlarmDeliveredForPackage.keyAt(i);
                            if ((Integer)packageUser.second != userHandle) continue;
                            AlarmManagerService.this.mLastAlarmDeliveredForPackage.removeAt(i);
                        }
                    }
                } else if ("android.intent.action.UID_REMOVED".equals(action)) {
                    if (uid >= 0) {
                        AlarmManagerService.this.mLastAllowWhileIdleDispatch.delete(uid);
                        AlarmManagerService.this.mUseAllowWhileIdleShortTime.delete(uid);
                    }
                } else {
                    String pkg;
                    if ("android.intent.action.PACKAGE_REMOVED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                        return;
                    }
                    Uri data = intent.getData();
                    if (data != null && (pkg = data.getSchemeSpecificPart()) != null) {
                        pkgList = new String[]{pkg};
                    }
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (int i = AlarmManagerService.this.mLastAlarmDeliveredForPackage.size() - 1; i >= 0; --i) {
                        Pair packageUser = (Pair)AlarmManagerService.this.mLastAlarmDeliveredForPackage.keyAt(i);
                        if (!ArrayUtils.contains(pkgList, (String)packageUser.first) || (Integer)packageUser.second != UserHandle.getUserId(uid)) continue;
                        AlarmManagerService.this.mLastAlarmDeliveredForPackage.removeAt(i);
                    }
                    for (String pkg : pkgList) {
                        if (uid >= 0) {
                            AlarmManagerService.this.removeLocked(uid);
                        } else {
                            AlarmManagerService.this.removeLocked(pkg);
                        }
                        AlarmManagerService.this.mPriorities.remove(pkg);
                        for (int i = AlarmManagerService.this.mBroadcastStats.size() - 1; i >= 0; --i) {
                            ArrayMap<String, BroadcastStats> uidStats = AlarmManagerService.this.mBroadcastStats.valueAt(i);
                            if (uidStats.remove(pkg) == null || uidStats.size() > 0) continue;
                            AlarmManagerService.this.mBroadcastStats.removeAt(i);
                        }
                    }
                }
            }
        }
    }

    class InteractiveStateReceiver
    extends BroadcastReceiver {
        public InteractiveStateReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_OFF");
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.setPriority(1000);
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.interactiveStateChangedLocked("android.intent.action.SCREEN_ON".equals(intent.getAction()));
            }
        }
    }

    class ClockReceiver
    extends BroadcastReceiver {
        public ClockReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.DATE_CHANGED");
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIME_TICK")) {
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    AlarmManagerService.this.mLastTickReceived = System.currentTimeMillis();
                }
                this.scheduleTimeTickEvent();
            } else if (intent.getAction().equals("android.intent.action.DATE_CHANGED")) {
                TimeZone zone = TimeZone.getTimeZone(SystemProperties.get(AlarmManagerService.TIMEZONE_PROPERTY));
                int gmtOffset = zone.getOffset(System.currentTimeMillis());
                AlarmManagerService.this.setKernelTimezone(AlarmManagerService.this.mNativeData, -(gmtOffset / 60000));
                this.scheduleDateChangedEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeTickEvent() {
            long currentTime = System.currentTimeMillis();
            long nextTime = 60000L * (currentTime / 60000L + 1L);
            long tickEventDelay = nextTime - currentTime;
            WorkSource workSource = null;
            AlarmManagerService.this.setImpl(3, SystemClock.elapsedRealtime() + tickEventDelay, 0L, 0L, AlarmManagerService.this.mTimeTickSender, null, null, 1, workSource, null, Process.myUid(), "android");
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.mLastTickSet = currentTime;
            }
        }

        public void scheduleDateChangedEvent() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(5, 1);
            WorkSource workSource = null;
            AlarmManagerService.this.setImpl(1, calendar.getTimeInMillis(), 0L, 0L, AlarmManagerService.this.mDateChangeSender, null, null, 1, workSource, null, Process.myUid(), "android");
        }
    }

    private class AlarmHandler
    extends Handler {
        public static final int ALARM_EVENT = 1;
        public static final int SEND_NEXT_ALARM_CLOCK_CHANGED = 2;
        public static final int LISTENER_TIMEOUT = 3;
        public static final int REPORT_ALARMS_ACTIVE = 4;
        public static final int APP_STANDBY_BUCKET_CHANGED = 5;
        public static final int APP_STANDBY_PAROLE_CHANGED = 6;
        public static final int REMOVE_FOR_STOPPED = 7;

        public void postRemoveForStopped(int uid) {
            this.obtainMessage(7, uid, 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ArrayList<Alarm> triggerList = new ArrayList<Alarm>();
                    Object object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        long nowRTC = System.currentTimeMillis();
                        long nowELAPSED = SystemClock.elapsedRealtime();
                        AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                        AlarmManagerService.this.updateNextAlarmClockLocked();
                    }
                    for (int i = 0; i < triggerList.size(); ++i) {
                        Alarm alarm = triggerList.get(i);
                        try {
                            alarm.operation.send();
                            continue;
                        }
                        catch (PendingIntent.CanceledException e) {
                            if (alarm.repeatInterval <= 0L) continue;
                            AlarmManagerService.this.removeImpl(alarm.operation);
                        }
                    }
                    break;
                }
                case 2: {
                    AlarmManagerService.this.sendNextAlarmClockChanged();
                    break;
                }
                case 3: {
                    AlarmManagerService.this.mDeliveryTracker.alarmTimedOut((IBinder)msg.obj);
                    break;
                }
                case 4: {
                    if (AlarmManagerService.this.mLocalDeviceIdleController == null) break;
                    AlarmManagerService.this.mLocalDeviceIdleController.setAlarmsActive(msg.arg1 != 0);
                    break;
                }
                case 6: {
                    Object object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        AlarmManagerService.this.mAppStandbyParole = (Boolean)msg.obj;
                        if (AlarmManagerService.this.reorderAlarmsBasedOnStandbyBuckets(null)) {
                            AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                            AlarmManagerService.this.updateNextAlarmClockLocked();
                        }
                        break;
                    }
                }
                case 5: {
                    Object object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        ArraySet<Pair<String, Integer>> filterPackages = new ArraySet<Pair<String, Integer>>();
                        filterPackages.add(Pair.create((String)msg.obj, msg.arg1));
                        if (AlarmManagerService.this.reorderAlarmsBasedOnStandbyBuckets(filterPackages)) {
                            AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                            AlarmManagerService.this.updateNextAlarmClockLocked();
                        }
                        break;
                    }
                }
                case 7: {
                    Object object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        AlarmManagerService.this.removeForStoppedLocked(msg.arg1);
                        break;
                    }
                }
            }
        }
    }

    private class AlarmThread
    extends Thread {
        public AlarmThread() {
            super(AlarmManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Alarm> triggerList = new ArrayList<Alarm>();
            while (true) {
                int result = AlarmManagerService.this.waitForAlarm(AlarmManagerService.this.mNativeData);
                long nowRTC = System.currentTimeMillis();
                long nowELAPSED = SystemClock.elapsedRealtime();
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    AlarmManagerService.this.mLastWakeup = nowELAPSED;
                }
                triggerList.clear();
                if ((result & 0x10000) != 0) {
                    long expectedClockTime;
                    long lastTimeChangeClockTime;
                    Object object2 = AlarmManagerService.this.mLock;
                    synchronized (object2) {
                        lastTimeChangeClockTime = AlarmManagerService.this.mLastTimeChangeClockTime;
                        expectedClockTime = lastTimeChangeClockTime + (nowELAPSED - AlarmManagerService.this.mLastTimeChangeRealtime);
                    }
                    if (lastTimeChangeClockTime == 0L || nowRTC < expectedClockTime - 1000L || nowRTC > expectedClockTime + 1000L) {
                        AlarmManagerService.this.removeImpl(AlarmManagerService.this.mTimeTickSender);
                        AlarmManagerService.this.removeImpl(AlarmManagerService.this.mDateChangeSender);
                        AlarmManagerService.this.rebatchAllAlarms();
                        AlarmManagerService.this.mClockReceiver.scheduleTimeTickEvent();
                        AlarmManagerService.this.mClockReceiver.scheduleDateChangedEvent();
                        object2 = AlarmManagerService.this.mLock;
                        synchronized (object2) {
                            ++AlarmManagerService.this.mNumTimeChanged;
                            AlarmManagerService.this.mLastTimeChangeClockTime = nowRTC;
                            AlarmManagerService.this.mLastTimeChangeRealtime = nowELAPSED;
                        }
                        Intent intent = new Intent("android.intent.action.TIME_SET");
                        intent.addFlags(0x25200000);
                        AlarmManagerService.this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
                        result |= 5;
                    }
                }
                if (result != 65536) {
                    object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        AlarmManagerService.this.mLastTrigger = nowELAPSED;
                        boolean hasWakeup = AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                        if (!hasWakeup && AlarmManagerService.this.checkAllowNonWakeupDelayLocked(nowELAPSED)) {
                            if (AlarmManagerService.this.mPendingNonWakeupAlarms.size() == 0) {
                                AlarmManagerService.this.mStartCurrentDelayTime = nowELAPSED;
                                AlarmManagerService.this.mNextNonWakeupDeliveryTime = nowELAPSED + AlarmManagerService.this.currentNonWakeupFuzzLocked(nowELAPSED) * 3L / 2L;
                            }
                            AlarmManagerService.this.mPendingNonWakeupAlarms.addAll(triggerList);
                            AlarmManagerService.this.mNumDelayedAlarms += triggerList.size();
                            AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                            AlarmManagerService.this.updateNextAlarmClockLocked();
                        } else {
                            if (AlarmManagerService.this.mPendingNonWakeupAlarms.size() > 0) {
                                AlarmManagerService.this.calculateDeliveryPriorities(AlarmManagerService.this.mPendingNonWakeupAlarms);
                                triggerList.addAll(AlarmManagerService.this.mPendingNonWakeupAlarms);
                                Collections.sort(triggerList, AlarmManagerService.this.mAlarmDispatchComparator);
                                long thisDelayTime = nowELAPSED - AlarmManagerService.this.mStartCurrentDelayTime;
                                AlarmManagerService.this.mTotalDelayTime += thisDelayTime;
                                if (AlarmManagerService.this.mMaxDelayTime < thisDelayTime) {
                                    AlarmManagerService.this.mMaxDelayTime = thisDelayTime;
                                }
                                AlarmManagerService.this.mPendingNonWakeupAlarms.clear();
                            }
                            ArraySet<Pair<String, Integer>> triggerPackages = new ArraySet<Pair<String, Integer>>();
                            for (int i = 0; i < triggerList.size(); ++i) {
                                Alarm a = triggerList.get(i);
                                if (AlarmManagerService.this.isExemptFromAppStandby(a)) continue;
                                triggerPackages.add(Pair.create(a.sourcePackage, UserHandle.getUserId(a.creatorUid)));
                            }
                            AlarmManagerService.this.deliverAlarmsLocked(triggerList, nowELAPSED);
                            AlarmManagerService.this.reorderAlarmsBasedOnStandbyBuckets(triggerPackages);
                            AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                            AlarmManagerService.this.updateNextAlarmClockLocked();
                        }
                    }
                }
                object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                }
            }
        }
    }

    @VisibleForTesting
    static class Alarm {
        public final int type;
        public final long origWhen;
        public final boolean wakeup;
        public final PendingIntent operation;
        public final IAlarmListener listener;
        public final String listenerTag;
        public final String statsTag;
        public final WorkSource workSource;
        public final int flags;
        public final AlarmManager.AlarmClockInfo alarmClock;
        public final int uid;
        public final int creatorUid;
        public final String packageName;
        public final String sourcePackage;
        public int count;
        public long when;
        public long windowLength;
        public long whenElapsed;
        public long maxWhenElapsed;
        public long expectedWhenElapsed;
        public long expectedMaxWhenElapsed;
        public long repeatInterval;
        public PriorityClass priorityClass;

        public Alarm(int _type, long _when, long _whenElapsed, long _windowLength, long _maxWhen, long _interval, PendingIntent _op, IAlarmListener _rec, String _listenerTag, WorkSource _ws, int _flags, AlarmManager.AlarmClockInfo _info, int _uid, String _pkgName) {
            this.type = _type;
            this.origWhen = _when;
            this.wakeup = _type == 2 || _type == 0;
            this.when = _when;
            this.whenElapsed = _whenElapsed;
            this.expectedWhenElapsed = _whenElapsed;
            this.windowLength = _windowLength;
            this.maxWhenElapsed = this.expectedMaxWhenElapsed = AlarmManagerService.clampPositive(_maxWhen);
            this.repeatInterval = _interval;
            this.operation = _op;
            this.listener = _rec;
            this.listenerTag = _listenerTag;
            this.statsTag = Alarm.makeTag(_op, _listenerTag, _type);
            this.workSource = _ws;
            this.flags = _flags;
            this.alarmClock = _info;
            this.uid = _uid;
            this.packageName = _pkgName;
            this.sourcePackage = this.operation != null ? this.operation.getCreatorPackage() : this.packageName;
            this.creatorUid = this.operation != null ? this.operation.getCreatorUid() : this.uid;
        }

        public static String makeTag(PendingIntent pi, String tag, int type) {
            String alarmString = type == 2 || type == 0 ? "*walarm*:" : "*alarm*:";
            return pi != null ? pi.getTag(alarmString) : alarmString + tag;
        }

        public WakeupEvent makeWakeupEvent(long nowRTC) {
            return new WakeupEvent(nowRTC, this.creatorUid, this.operation != null ? this.operation.getIntent().getAction() : "<listener>:" + this.listenerTag);
        }

        public boolean matches(PendingIntent pi, IAlarmListener rec) {
            return this.operation != null ? this.operation.equals(pi) : rec != null && this.listener.asBinder().equals(rec.asBinder());
        }

        public boolean matches(String packageName) {
            return packageName.equals(this.sourcePackage);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Alarm{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" type ");
            sb.append(this.type);
            sb.append(" when ");
            sb.append(this.when);
            sb.append(" ");
            sb.append(this.sourcePackage);
            sb.append('}');
            return sb.toString();
        }

        public void dump(PrintWriter pw, String prefix, long nowELAPSED, long nowRTC, SimpleDateFormat sdf) {
            boolean isRtc = this.type == 1 || this.type == 0;
            pw.print(prefix);
            pw.print("tag=");
            pw.println(this.statsTag);
            pw.print(prefix);
            pw.print("type=");
            pw.print(this.type);
            pw.print(" expectedWhenElapsed=");
            TimeUtils.formatDuration(this.expectedWhenElapsed, nowELAPSED, pw);
            pw.print(" expectedMaxWhenElapsed=");
            TimeUtils.formatDuration(this.expectedMaxWhenElapsed, nowELAPSED, pw);
            pw.print(" whenElapsed=");
            TimeUtils.formatDuration(this.whenElapsed, nowELAPSED, pw);
            pw.print(" maxWhenElapsed=");
            TimeUtils.formatDuration(this.maxWhenElapsed, nowELAPSED, pw);
            pw.print(" when=");
            if (isRtc) {
                pw.print(sdf.format(new Date(this.when)));
            } else {
                TimeUtils.formatDuration(this.when, nowELAPSED, pw);
            }
            pw.println();
            pw.print(prefix);
            pw.print("window=");
            TimeUtils.formatDuration(this.windowLength, pw);
            pw.print(" repeatInterval=");
            pw.print(this.repeatInterval);
            pw.print(" count=");
            pw.print(this.count);
            pw.print(" flags=0x");
            pw.println(Integer.toHexString(this.flags));
            if (this.alarmClock != null) {
                pw.print(prefix);
                pw.println("Alarm clock:");
                pw.print(prefix);
                pw.print("  triggerTime=");
                pw.println(sdf.format(new Date(this.alarmClock.getTriggerTime())));
                pw.print(prefix);
                pw.print("  showIntent=");
                pw.println(this.alarmClock.getShowIntent());
            }
            pw.print(prefix);
            pw.print("operation=");
            pw.println(this.operation);
            if (this.listener != null) {
                pw.print(prefix);
                pw.print("listener=");
                pw.println(this.listener.asBinder());
            }
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId, long nowElapsed, long nowRTC) {
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, this.statsTag);
            proto.write(1159641169922L, this.type);
            proto.write(0x10300000003L, this.whenElapsed - nowElapsed);
            proto.write(1112396529668L, this.windowLength);
            proto.write(1112396529669L, this.repeatInterval);
            proto.write(1120986464262L, this.count);
            proto.write(1120986464263L, this.flags);
            if (this.alarmClock != null) {
                this.alarmClock.writeToProto(proto, 1146756268040L);
            }
            if (this.operation != null) {
                this.operation.writeToProto(proto, 1146756268041L);
            }
            if (this.listener != null) {
                proto.write(1138166333450L, this.listener.asBinder().toString());
            }
            proto.end(token);
        }
    }

    public static class IncreasingTimeOrder
    implements Comparator<Alarm> {
        @Override
        public int compare(Alarm a1, Alarm a2) {
            long when1 = a1.whenElapsed;
            long when2 = a2.whenElapsed;
            if (when1 > when2) {
                return 1;
            }
            if (when1 < when2) {
                return -1;
            }
            return 0;
        }
    }

    private final class LocalService
    implements AlarmManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAlarmsForUid(int uid) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.removeLocked(uid);
            }
        }
    }

    static final class BroadcastStats {
        final int mUid;
        final String mPackageName;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;
        final ArrayMap<String, FilterStats> filterStats = new ArrayMap();

        BroadcastStats(int uid, String packageName) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }

        public String toString() {
            return "BroadcastStats{uid=" + this.mUid + ", packageName=" + this.mPackageName + ", aggregateTime=" + this.aggregateTime + ", count=" + this.count + ", numWakeup=" + this.numWakeup + ", startTime=" + this.startTime + ", nesting=" + this.nesting + "}";
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.mUid);
            proto.write(1138166333442L, this.mPackageName);
            proto.write(0x10300000003L, this.aggregateTime);
            proto.write(1120986464260L, this.count);
            proto.write(0x10500000005L, this.numWakeup);
            proto.write(1112396529670L, this.startTime);
            proto.write(1120986464263L, this.nesting);
            proto.end(token);
        }
    }

    static final class FilterStats {
        final BroadcastStats mBroadcastStats;
        final String mTag;
        long lastTime;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;

        FilterStats(BroadcastStats broadcastStats, String tag) {
            this.mBroadcastStats = broadcastStats;
            this.mTag = tag;
        }

        public String toString() {
            return "FilterStats{tag=" + this.mTag + ", lastTime=" + this.lastTime + ", aggregateTime=" + this.aggregateTime + ", count=" + this.count + ", numWakeup=" + this.numWakeup + ", startTime=" + this.startTime + ", nesting=" + this.nesting + "}";
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, this.mTag);
            proto.write(1112396529666L, this.lastTime);
            proto.write(0x10300000003L, this.aggregateTime);
            proto.write(1120986464260L, this.count);
            proto.write(0x10500000005L, this.numWakeup);
            proto.write(1112396529670L, this.startTime);
            proto.write(1120986464263L, this.nesting);
            proto.end(token);
        }
    }

    static final class InFlight {
        final PendingIntent mPendingIntent;
        final long mWhenElapsed;
        final IBinder mListener;
        final WorkSource mWorkSource;
        final int mUid;
        final String mTag;
        final BroadcastStats mBroadcastStats;
        final FilterStats mFilterStats;
        final int mAlarmType;

        InFlight(AlarmManagerService service, PendingIntent pendingIntent, IAlarmListener listener, WorkSource workSource, int uid, String alarmPkg, int alarmType, String tag, long nowELAPSED) {
            this.mPendingIntent = pendingIntent;
            this.mWhenElapsed = nowELAPSED;
            this.mListener = listener != null ? listener.asBinder() : null;
            this.mWorkSource = workSource;
            this.mUid = uid;
            this.mTag = tag;
            this.mBroadcastStats = pendingIntent != null ? service.getStatsLocked(pendingIntent) : service.getStatsLocked(uid, alarmPkg);
            FilterStats fs = this.mBroadcastStats.filterStats.get(this.mTag);
            if (fs == null) {
                fs = new FilterStats(this.mBroadcastStats, this.mTag);
                this.mBroadcastStats.filterStats.put(this.mTag, fs);
            }
            fs.lastTime = nowELAPSED;
            this.mFilterStats = fs;
            this.mAlarmType = alarmType;
        }

        public String toString() {
            return "InFlight{pendingIntent=" + this.mPendingIntent + ", when=" + this.mWhenElapsed + ", workSource=" + this.mWorkSource + ", uid=" + this.mUid + ", tag=" + this.mTag + ", broadcastStats=" + this.mBroadcastStats + ", filterStats=" + this.mFilterStats + ", alarmType=" + this.mAlarmType + "}";
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.mUid);
            proto.write(1138166333442L, this.mTag);
            proto.write(0x10300000003L, this.mWhenElapsed);
            proto.write(1159641169924L, this.mAlarmType);
            if (this.mPendingIntent != null) {
                this.mPendingIntent.writeToProto(proto, 1146756268037L);
            }
            if (this.mBroadcastStats != null) {
                this.mBroadcastStats.writeToProto(proto, 1146756268038L);
            }
            if (this.mFilterStats != null) {
                this.mFilterStats.writeToProto(proto, 1146756268039L);
            }
            if (this.mWorkSource != null) {
                this.mWorkSource.writeToProto(proto, 1146756268040L);
            }
            proto.end(token);
        }
    }

    static class BatchTimeOrder
    implements Comparator<Batch> {
        BatchTimeOrder() {
        }

        @Override
        public int compare(Batch b1, Batch b2) {
            long when1 = b1.start;
            long when2 = b2.start;
            if (when1 > when2) {
                return 1;
            }
            if (when1 < when2) {
                return -1;
            }
            return 0;
        }
    }

    final class Batch {
        long start;
        long end;
        int flags;
        final ArrayList<Alarm> alarms = new ArrayList();

        Batch() {
            this.start = 0L;
            this.end = Long.MAX_VALUE;
            this.flags = 0;
        }

        Batch(Alarm seed) {
            this.start = seed.whenElapsed;
            this.end = AlarmManagerService.clampPositive(seed.maxWhenElapsed);
            this.flags = seed.flags;
            this.alarms.add(seed);
            if (seed.operation == AlarmManagerService.this.mTimeTickSender) {
                AlarmManagerService.this.mLastTickAdded = System.currentTimeMillis();
            }
        }

        int size() {
            return this.alarms.size();
        }

        Alarm get(int index) {
            return this.alarms.get(index);
        }

        boolean canHold(long whenElapsed, long maxWhen) {
            return this.end >= whenElapsed && this.start <= maxWhen;
        }

        boolean add(Alarm alarm) {
            boolean newStart = false;
            int index = Collections.binarySearch(this.alarms, alarm, sIncreasingTimeOrder);
            if (index < 0) {
                index = 0 - index - 1;
            }
            this.alarms.add(index, alarm);
            if (alarm.operation == AlarmManagerService.this.mTimeTickSender) {
                AlarmManagerService.this.mLastTickAdded = System.currentTimeMillis();
            }
            if (alarm.whenElapsed > this.start) {
                this.start = alarm.whenElapsed;
                newStart = true;
            }
            if (alarm.maxWhenElapsed < this.end) {
                this.end = alarm.maxWhenElapsed;
            }
            this.flags |= alarm.flags;
            return newStart;
        }

        boolean remove(Alarm alarm) {
            return this.remove((Alarm a) -> a == alarm);
        }

        boolean remove(Predicate<Alarm> predicate) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int newFlags = 0;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (predicate.test(alarm)) {
                    this.alarms.remove(i);
                    didRemove = true;
                    if (alarm.alarmClock != null) {
                        AlarmManagerService.this.mNextAlarmClockMayChange = true;
                    }
                    if (alarm.operation != AlarmManagerService.this.mTimeTickSender) continue;
                    AlarmManagerService.this.mLastTickRemoved = System.currentTimeMillis();
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhenElapsed < newEnd) {
                    newEnd = alarm.maxWhenElapsed;
                }
                newFlags |= alarm.flags;
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
                this.flags = newFlags;
            }
            return didRemove;
        }

        boolean hasPackage(String packageName) {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if (!a.matches(packageName)) continue;
                return true;
            }
            return false;
        }

        boolean hasWakeups() {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if ((a.type & 1) != 0) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(40);
            b.append("Batch{");
            b.append(Integer.toHexString(this.hashCode()));
            b.append(" num=");
            b.append(this.size());
            b.append(" start=");
            b.append(this.start);
            b.append(" end=");
            b.append(this.end);
            if (this.flags != 0) {
                b.append(" flgs=0x");
                b.append(Integer.toHexString(this.flags));
            }
            b.append('}');
            return b.toString();
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId, long nowElapsed, long nowRTC) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, this.start);
            proto.write(1112396529666L, this.end);
            proto.write(1120986464259L, this.flags);
            for (Alarm a : this.alarms) {
                a.writeToProto(proto, 2246267895812L, nowElapsed, nowRTC);
            }
            proto.end(token);
        }
    }

    static final class WakeupEvent {
        public long when;
        public int uid;
        public String action;

        public WakeupEvent(long theTime, int theUid, String theAction) {
            this.when = theTime;
            this.uid = theUid;
            this.action = theAction;
        }
    }

    final class PriorityClass {
        int seq;
        int priority;

        PriorityClass() {
            this.seq = AlarmManagerService.this.mCurrentSeq - 1;
            this.priority = 2;
        }
    }

    private final class Constants
    extends ContentObserver {
        private static final String KEY_MIN_FUTURITY = "min_futurity";
        private static final String KEY_MIN_INTERVAL = "min_interval";
        private static final String KEY_MAX_INTERVAL = "max_interval";
        private static final String KEY_ALLOW_WHILE_IDLE_SHORT_TIME = "allow_while_idle_short_time";
        private static final String KEY_ALLOW_WHILE_IDLE_LONG_TIME = "allow_while_idle_long_time";
        private static final String KEY_ALLOW_WHILE_IDLE_WHITELIST_DURATION = "allow_while_idle_whitelist_duration";
        private static final String KEY_LISTENER_TIMEOUT = "listener_timeout";
        private final String[] KEYS_APP_STANDBY_DELAY;
        private static final long DEFAULT_MIN_FUTURITY = 5000L;
        private static final long DEFAULT_MIN_INTERVAL = 60000L;
        private static final long DEFAULT_MAX_INTERVAL = 31536000000L;
        private static final long DEFAULT_ALLOW_WHILE_IDLE_SHORT_TIME = 5000L;
        private static final long DEFAULT_ALLOW_WHILE_IDLE_LONG_TIME = 540000L;
        private static final long DEFAULT_ALLOW_WHILE_IDLE_WHITELIST_DURATION = 10000L;
        private static final long DEFAULT_LISTENER_TIMEOUT = 5000L;
        private final long[] DEFAULT_APP_STANDBY_DELAYS;
        public long MIN_FUTURITY;
        public long MIN_INTERVAL;
        public long MAX_INTERVAL;
        public long ALLOW_WHILE_IDLE_SHORT_TIME;
        public long ALLOW_WHILE_IDLE_LONG_TIME;
        public long ALLOW_WHILE_IDLE_WHITELIST_DURATION;
        public long LISTENER_TIMEOUT;
        public long[] APP_STANDBY_MIN_DELAYS;
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;
        private long mLastAllowWhileIdleWhitelistDuration;

        public Constants(Handler handler) {
            super(handler);
            this.KEYS_APP_STANDBY_DELAY = new String[]{"standby_active_delay", "standby_working_delay", "standby_frequent_delay", "standby_rare_delay", "standby_never_delay"};
            this.DEFAULT_APP_STANDBY_DELAYS = new long[]{0L, 360000L, 1800000L, 0x6DDD00L, 864000000L};
            this.MIN_FUTURITY = 5000L;
            this.MIN_INTERVAL = 60000L;
            this.MAX_INTERVAL = 31536000000L;
            this.ALLOW_WHILE_IDLE_SHORT_TIME = 5000L;
            this.ALLOW_WHILE_IDLE_LONG_TIME = 540000L;
            this.ALLOW_WHILE_IDLE_WHITELIST_DURATION = 10000L;
            this.LISTENER_TIMEOUT = 5000L;
            this.APP_STANDBY_MIN_DELAYS = new long[this.DEFAULT_APP_STANDBY_DELAYS.length];
            this.mParser = new KeyValueListParser(',');
            this.mLastAllowWhileIdleWhitelistDuration = -1L;
            this.updateAllowWhileIdleWhitelistDurationLocked();
        }

        public void start(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("alarm_manager_constants"), false, this);
            this.updateConstants();
        }

        public void updateAllowWhileIdleWhitelistDurationLocked() {
            if (this.mLastAllowWhileIdleWhitelistDuration != this.ALLOW_WHILE_IDLE_WHITELIST_DURATION) {
                this.mLastAllowWhileIdleWhitelistDuration = this.ALLOW_WHILE_IDLE_WHITELIST_DURATION;
                BroadcastOptions opts = BroadcastOptions.makeBasic();
                opts.setTemporaryAppWhitelistDuration(this.ALLOW_WHILE_IDLE_WHITELIST_DURATION);
                AlarmManagerService.this.mIdleOptions = opts.toBundle();
            }
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "alarm_manager_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(AlarmManagerService.TAG, "Bad alarm manager settings", e);
                }
                this.MIN_FUTURITY = this.mParser.getLong(KEY_MIN_FUTURITY, 5000L);
                this.MIN_INTERVAL = this.mParser.getLong(KEY_MIN_INTERVAL, 60000L);
                this.MAX_INTERVAL = this.mParser.getLong(KEY_MAX_INTERVAL, 31536000000L);
                this.ALLOW_WHILE_IDLE_SHORT_TIME = this.mParser.getLong(KEY_ALLOW_WHILE_IDLE_SHORT_TIME, 5000L);
                this.ALLOW_WHILE_IDLE_LONG_TIME = this.mParser.getLong(KEY_ALLOW_WHILE_IDLE_LONG_TIME, 540000L);
                this.ALLOW_WHILE_IDLE_WHITELIST_DURATION = this.mParser.getLong(KEY_ALLOW_WHILE_IDLE_WHITELIST_DURATION, 10000L);
                this.LISTENER_TIMEOUT = this.mParser.getLong(KEY_LISTENER_TIMEOUT, 5000L);
                this.APP_STANDBY_MIN_DELAYS[0] = this.mParser.getDurationMillis(this.KEYS_APP_STANDBY_DELAY[0], this.DEFAULT_APP_STANDBY_DELAYS[0]);
                for (int i = 1; i < this.KEYS_APP_STANDBY_DELAY.length; ++i) {
                    this.APP_STANDBY_MIN_DELAYS[i] = this.mParser.getDurationMillis(this.KEYS_APP_STANDBY_DELAY[i], Math.max(this.APP_STANDBY_MIN_DELAYS[i - 1], this.DEFAULT_APP_STANDBY_DELAYS[i]));
                }
                this.updateAllowWhileIdleWhitelistDurationLocked();
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings:");
            pw.print("    ");
            pw.print(KEY_MIN_FUTURITY);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_FUTURITY, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MIN_INTERVAL);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_INTERVAL, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_INTERVAL);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_INTERVAL, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LISTENER_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LISTENER_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_ALLOW_WHILE_IDLE_SHORT_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.ALLOW_WHILE_IDLE_SHORT_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_ALLOW_WHILE_IDLE_LONG_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.ALLOW_WHILE_IDLE_LONG_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_ALLOW_WHILE_IDLE_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.ALLOW_WHILE_IDLE_WHITELIST_DURATION, pw);
            pw.println();
            for (int i = 0; i < this.KEYS_APP_STANDBY_DELAY.length; ++i) {
                pw.print("    ");
                pw.print(this.KEYS_APP_STANDBY_DELAY[i]);
                pw.print("=");
                TimeUtils.formatDuration(this.APP_STANDBY_MIN_DELAYS[i], pw);
                pw.println();
            }
        }

        void dumpProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, this.MIN_FUTURITY);
            proto.write(1112396529666L, this.MIN_INTERVAL);
            proto.write(1112396529671L, this.MAX_INTERVAL);
            proto.write(0x10300000003L, this.LISTENER_TIMEOUT);
            proto.write(1112396529668L, this.ALLOW_WHILE_IDLE_SHORT_TIME);
            proto.write(1112396529669L, this.ALLOW_WHILE_IDLE_LONG_TIME);
            proto.write(1112396529670L, this.ALLOW_WHILE_IDLE_WHITELIST_DURATION);
            proto.end(token);
        }
    }

    static interface Stats {
        public static final int REBATCH_ALL_ALARMS = 0;
        public static final int REORDER_ALARMS_FOR_STANDBY = 1;
    }

    static final class IdleDispatchEntry {
        int uid;
        String pkg;
        String tag;
        String op;
        long elapsedRealtime;
        long argRealtime;

        IdleDispatchEntry() {
        }
    }
}

