/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.R;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubtitleView
extends View
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static float INNER_PADDING_RATIO = 0.125f;
    private static int COLOR_BEVEL_DARK = Integer.MIN_VALUE;
    private static int COLOR_BEVEL_LIGHT = -2130706433;
    private float mCornerRadius;
    private float mOutlineWidth;
    private float mShadowRadius;
    private float mShadowOffsetX;
    private float mShadowOffsetY;
    private RectF mLineBounds;
    private SpannableStringBuilder mText;
    private Layout.Alignment mAlignment;
    private TextPaint mTextPaint;
    private Paint mPaint;
    private int mForegroundColor;
    private int mBackgroundColor;
    private int mEdgeColor;
    private int mEdgeType;
    private boolean mHasMeasurements;
    private int mLastMeasuredWidth;
    private StaticLayout mLayout;
    private float mSpacingMult;
    private float mSpacingAdd;
    private int mInnerPaddingX;

    private void $$robo$$com_android_internal_widget_SubtitleView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_SubtitleView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_SubtitleView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_widget_SubtitleView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mLineBounds = new RectF();
        this.mText = new SpannableStringBuilder();
        this.mSpacingMult = 1.0f;
        this.mSpacingAdd = 0.0f;
        this.mInnerPaddingX = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        CharSequence text = "";
        int textSize = 15;
        int n = a.getIndexCount();
        block6: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 18: {
                    text = a.getText(attr2);
                    continue block6;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr2, (int)this.mSpacingAdd);
                    continue block6;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr2, this.mSpacingMult);
                    continue block6;
                }
                case 0: {
                    textSize = a.getDimensionPixelSize(attr2, textSize);
                }
            }
        }
        Resources res = this.getContext().getResources();
        this.mCornerRadius = res.getDimensionPixelSize(17105313);
        this.mOutlineWidth = res.getDimensionPixelSize(17105314);
        this.mShadowRadius = res.getDimensionPixelSize(17105316);
        this.mShadowOffsetY = this.mShadowOffsetX = (float)res.getDimensionPixelSize(17105315);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setSubpixelText(true);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.setText(text);
        this.setTextSize(textSize);
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setText(int resId) {
        CharSequence text = this.getContext().getText(resId);
        this.setText(text);
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setText(CharSequence text) {
        this.mText.clear();
        this.mText.append(text);
        this.mHasMeasurements = false;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setForegroundColor(int color2) {
        this.mForegroundColor = color2;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setEdgeType(int edgeType) {
        this.mEdgeType = edgeType;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setEdgeColor(int color2) {
        this.mEdgeColor = color2;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setTextSize(float size) {
        if (this.mTextPaint.getTextSize() != size) {
            this.mTextPaint.setTextSize(size);
            this.mInnerPaddingX = (int)(size * 0.125f + 0.5f);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setTypeface(Typeface typeface) {
        if (this.mTextPaint.getTypeface() != typeface) {
            this.mTextPaint.setTypeface(typeface);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setAlignment(Layout.Alignment textAlignment) {
        if (this.mAlignment != textAlignment) {
            this.mAlignment = textAlignment;
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.getSize(widthMeasureSpec);
        if (this.computeMeasurements(widthSpec)) {
            StaticLayout layout2 = this.mLayout;
            int paddingX = this.mPaddingLeft + this.mPaddingRight + this.mInnerPaddingX * 2;
            int width = layout2.getWidth() + paddingX;
            int height = layout2.getHeight() + this.mPaddingTop + this.mPaddingBottom;
            this.setMeasuredDimension(width, height);
        } else {
            this.setMeasuredDimension(0x1000000, 0x1000000);
        }
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        this.computeMeasurements(width);
    }

    private final boolean $$robo$$com_android_internal_widget_SubtitleView$computeMeasurements(int maxWidth) {
        if (this.mHasMeasurements && maxWidth == this.mLastMeasuredWidth) {
            return true;
        }
        int paddingX = this.mPaddingLeft + this.mPaddingRight + this.mInnerPaddingX * 2;
        if ((maxWidth -= paddingX) <= 0) {
            return false;
        }
        this.mHasMeasurements = true;
        this.mLastMeasuredWidth = maxWidth;
        this.mLayout = StaticLayout.Builder.obtain(this.mText, 0, this.mText.length(), this.mTextPaint, maxWidth).setAlignment(this.mAlignment).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setUseLineSpacingFromFallbacks(true).build();
        return true;
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$setStyle(int styleId) {
        Context context = this.mContext;
        ContentResolver cr = context.getContentResolver();
        CaptioningManager.CaptionStyle style2 = styleId == -1 ? CaptioningManager.CaptionStyle.getCustomStyle(cr) : CaptioningManager.CaptionStyle.PRESETS[styleId];
        CaptioningManager.CaptionStyle defStyle = CaptioningManager.CaptionStyle.DEFAULT;
        this.mForegroundColor = style2.hasForegroundColor() ? style2.foregroundColor : defStyle.foregroundColor;
        this.mBackgroundColor = style2.hasBackgroundColor() ? style2.backgroundColor : defStyle.backgroundColor;
        this.mEdgeType = style2.hasEdgeType() ? style2.edgeType : defStyle.edgeType;
        this.mEdgeColor = style2.hasEdgeColor() ? style2.edgeColor : defStyle.edgeColor;
        this.mHasMeasurements = false;
        Typeface typeface = style2.getTypeface();
        this.setTypeface(typeface);
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_SubtitleView$onDraw(Canvas c) {
        int edgeType;
        StaticLayout layout2 = this.mLayout;
        if (layout2 == null) {
            return;
        }
        int saveCount = c.save();
        int innerPaddingX = this.mInnerPaddingX;
        c.translate(this.mPaddingLeft + innerPaddingX, this.mPaddingTop);
        int lineCount = layout2.getLineCount();
        TextPaint textPaint = this.mTextPaint;
        Paint paint = this.mPaint;
        RectF bounds = this.mLineBounds;
        if (Color.alpha(this.mBackgroundColor) > 0) {
            float cornerRadius = this.mCornerRadius;
            float previousBottom = layout2.getLineTop(0);
            paint.setColor(this.mBackgroundColor);
            paint.setStyle(Paint.Style.FILL);
            for (int i = 0; i < lineCount; ++i) {
                bounds.left = layout2.getLineLeft(i) - (float)innerPaddingX;
                bounds.right = layout2.getLineRight(i) + (float)innerPaddingX;
                bounds.top = previousBottom;
                previousBottom = bounds.bottom = (float)layout2.getLineBottom(i);
                c.drawRoundRect(bounds, cornerRadius, cornerRadius, paint);
            }
        }
        if ((edgeType = this.mEdgeType) == 1) {
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.mOutlineWidth);
            textPaint.setColor(this.mEdgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            for (int i = 0; i < lineCount; ++i) {
                layout2.drawText(c, i, i);
            }
        } else if (edgeType == 2) {
            textPaint.setShadowLayer(this.mShadowRadius, this.mShadowOffsetX, this.mShadowOffsetY, this.mEdgeColor);
        } else if (edgeType == 3 || edgeType == 4) {
            boolean raised = edgeType == 3;
            int colorUp = raised ? -1 : this.mEdgeColor;
            int colorDown = raised ? this.mEdgeColor : -1;
            float offset = this.mShadowRadius / 2.0f;
            textPaint.setColor(this.mForegroundColor);
            textPaint.setStyle(Paint.Style.FILL);
            textPaint.setShadowLayer(this.mShadowRadius, -offset, -offset, colorUp);
            for (int i = 0; i < lineCount; ++i) {
                layout2.drawText(c, i, i);
            }
            textPaint.setShadowLayer(this.mShadowRadius, offset, offset, colorDown);
        }
        textPaint.setColor(this.mForegroundColor);
        textPaint.setStyle(Paint.Style.FILL);
        for (int i = 0; i < lineCount; ++i) {
            layout2.drawText(c, i, i);
        }
        textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        c.restoreToCount(saveCount);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SubtitleView$__constructor__(context);
    }

    public SubtitleView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SubtitleView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SubtitleView$__constructor__(context, attributeSet);
    }

    public SubtitleView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SubtitleView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_SubtitleView$__constructor__(context, attributeSet, n);
    }

    public SubtitleView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SubtitleView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_SubtitleView$__constructor__(context, attributeSet, n, n2);
    }

    public SubtitleView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SubtitleView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    public void setText(int n) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$com_android_internal_widget_SubtitleView$setText(int ), this, n);
    }

    public void setText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$com_android_internal_widget_SubtitleView$setText(java.lang.CharSequence ), this, charSequence);
    }

    public void setForegroundColor(int n) {
        InvokeDynamicSupport.bootstrap("setForegroundColor", $$robo$$com_android_internal_widget_SubtitleView$setForegroundColor(int ), this, n);
    }

    @Override
    public void setBackgroundColor(int n) {
        InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$com_android_internal_widget_SubtitleView$setBackgroundColor(int ), this, n);
    }

    public void setEdgeType(int n) {
        InvokeDynamicSupport.bootstrap("setEdgeType", $$robo$$com_android_internal_widget_SubtitleView$setEdgeType(int ), this, n);
    }

    public void setEdgeColor(int n) {
        InvokeDynamicSupport.bootstrap("setEdgeColor", $$robo$$com_android_internal_widget_SubtitleView$setEdgeColor(int ), this, n);
    }

    public void setTextSize(float f) {
        InvokeDynamicSupport.bootstrap("setTextSize", $$robo$$com_android_internal_widget_SubtitleView$setTextSize(float ), this, f);
    }

    public void setTypeface(Typeface typeface) {
        InvokeDynamicSupport.bootstrap("setTypeface", $$robo$$com_android_internal_widget_SubtitleView$setTypeface(android.graphics.Typeface ), this, typeface);
    }

    public void setAlignment(Layout.Alignment alignment) {
        InvokeDynamicSupport.bootstrap("setAlignment", $$robo$$com_android_internal_widget_SubtitleView$setAlignment(android.text.Layout$Alignment ), this, alignment);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_SubtitleView$onMeasure(int int ), this, n, n2);
    }

    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_SubtitleView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    private boolean computeMeasurements(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("computeMeasurements", $$robo$$com_android_internal_widget_SubtitleView$computeMeasurements(int ), this, n);
    }

    public void setStyle(int n) {
        InvokeDynamicSupport.bootstrap("setStyle", $$robo$$com_android_internal_widget_SubtitleView$setStyle(int ), this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_SubtitleView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    public /* synthetic */ SubtitleView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubtitleView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

