/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.AbsSavedState;
import android.view.Display;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.widget.AdapterHelper;
import com.android.internal.widget.ChildHelper;
import com.android.internal.widget.DefaultItemAnimator;
import com.android.internal.widget.GapWorker;
import com.android.internal.widget.NestedScrollingChild;
import com.android.internal.widget.RecyclerViewAccessibilityDelegate;
import com.android.internal.widget.ScrollingView;
import com.android.internal.widget.ViewInfoStore;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RecyclerView
extends ViewGroup
implements ScrollingView,
NestedScrollingChild,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "RecyclerView";
    static boolean DEBUG = false;
    private static int[] NESTED_SCROLLING_ATTRS;
    private static int[] CLIP_TO_PADDING_ATTR;
    static boolean FORCE_INVALIDATE_DISPLAY_LIST;
    static boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC;
    static boolean POST_UPDATES_ON_ANIMATION;
    private static boolean ALLOW_THREAD_GAP_WORK;
    private static boolean FORCE_ABS_FOCUS_SEARCH_DIRECTION;
    private static boolean IGNORE_DETACHED_FOCUSED_CHILD;
    static boolean DISPATCH_TEMP_DETACH = false;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    public static int NO_POSITION = -1;
    public static long NO_ID = -1L;
    public static int INVALID_TYPE = -1;
    public static int TOUCH_SLOP_DEFAULT = 0;
    public static int TOUCH_SLOP_PAGING = 1;
    static int MAX_SCROLL_DURATION = 2000;
    static String TRACE_SCROLL_TAG = "RV Scroll";
    private static String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    private static String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    private static String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    static String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    static String TRACE_PREFETCH_TAG = "RV Prefetch";
    static String TRACE_NESTED_PREFETCH_TAG = "RV Nested Prefetch";
    static String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    private static Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE;
    private RecyclerViewDataObserver mObserver;
    Recycler mRecycler;
    private SavedState mPendingSavedState;
    AdapterHelper mAdapterHelper;
    ChildHelper mChildHelper;
    ViewInfoStore mViewInfoStore;
    boolean mClipToPadding;
    Runnable mUpdateChildViewsRunnable;
    Rect mTempRect;
    private Rect mTempRect2;
    RectF mTempRectF;
    Adapter mAdapter;
    @VisibleForTesting
    LayoutManager mLayout;
    RecyclerListener mRecyclerListener;
    ArrayList<ItemDecoration> mItemDecorations;
    private ArrayList<OnItemTouchListener> mOnItemTouchListeners;
    private OnItemTouchListener mActiveOnItemTouchListener;
    boolean mIsAttached;
    boolean mHasFixedSize;
    @VisibleForTesting
    boolean mFirstLayoutComplete;
    private int mEatRequestLayout;
    boolean mLayoutRequestEaten;
    boolean mLayoutFrozen;
    private boolean mIgnoreMotionEventTillDown;
    private int mEatenAccessibilityChangeFlags;
    boolean mAdapterUpdateDuringMeasure;
    private AccessibilityManager mAccessibilityManager;
    private List<OnChildAttachStateChangeListener> mOnChildAttachStateListeners;
    boolean mDataSetHasChangedAfterLayout;
    private int mLayoutOrScrollCounter;
    private int mDispatchScrollCounter;
    private EdgeEffect mLeftGlow;
    private EdgeEffect mTopGlow;
    private EdgeEffect mRightGlow;
    private EdgeEffect mBottomGlow;
    ItemAnimator mItemAnimator;
    private static int INVALID_POINTER = -1;
    public static int SCROLL_STATE_IDLE = 0;
    public static int SCROLL_STATE_DRAGGING = 1;
    public static int SCROLL_STATE_SETTLING = 2;
    static long FOREVER_NS = Long.MAX_VALUE;
    private int mScrollState;
    private int mScrollPointerId;
    private VelocityTracker mVelocityTracker;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mLastTouchX;
    private int mLastTouchY;
    private int mTouchSlop;
    private OnFlingListener mOnFlingListener;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private float mScrollFactor;
    private boolean mPreserveFocusAfterLayout;
    ViewFlinger mViewFlinger;
    GapWorker mGapWorker;
    GapWorker.LayoutPrefetchRegistryImpl mPrefetchRegistry;
    State mState;
    private OnScrollListener mScrollListener;
    private List<OnScrollListener> mScrollListeners;
    boolean mItemsAddedOrRemoved;
    boolean mItemsChanged;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener;
    boolean mPostedAnimatorRunner;
    RecyclerViewAccessibilityDelegate mAccessibilityDelegate;
    private ChildDrawingOrderCallback mChildDrawingOrderCallback;
    private int[] mMinMaxLayoutPositions;
    private int[] mScrollOffset;
    private int[] mScrollConsumed;
    private int[] mNestedOffsets;
    @VisibleForTesting
    List<ViewHolder> mPendingAccessibilityImportanceChange;
    private Runnable mItemAnimatorRunner;
    static Interpolator sQuinticInterpolator;
    private ViewInfoStore.ProcessCallback mViewInfoProcessCallback;

    private void $$robo$$com_android_internal_widget_RecyclerView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_RecyclerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_RecyclerView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mObserver = new RecyclerViewDataObserver(this);
        this.mRecycler = new Recycler(this);
        this.mViewInfoStore = new ViewInfoStore();
        this.mUpdateChildViewsRunnable = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecyclerView this$0;

            private void $$robo$$com_android_internal_widget_RecyclerView_1$__constructor__(RecyclerView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_1$run() {
                if (!this.this$0.mFirstLayoutComplete || this.this$0.isLayoutRequested()) {
                    return;
                }
                if (!this.this$0.mIsAttached) {
                    this.this$0.requestLayout();
                    return;
                }
                if (this.this$0.mLayoutFrozen) {
                    this.this$0.mLayoutRequestEaten = true;
                    return;
                }
                this.this$0.consumePendingUpdateOperations();
            }

            private void __constructor__(RecyclerView recyclerView) {
                this.$$robo$$com_android_internal_widget_RecyclerView_1$__constructor__(recyclerView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_1$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_RecyclerView_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTempRect = new Rect();
        this.mTempRect2 = new Rect();
        this.mTempRectF = new RectF();
        this.mItemDecorations = new ArrayList();
        this.mOnItemTouchListeners = new ArrayList();
        this.mEatRequestLayout = 0;
        this.mDataSetHasChangedAfterLayout = false;
        this.mLayoutOrScrollCounter = 0;
        this.mDispatchScrollCounter = 0;
        this.mItemAnimator = new DefaultItemAnimator();
        this.mScrollState = 0;
        this.mScrollPointerId = -1;
        this.mScrollFactor = Float.MIN_VALUE;
        this.mPreserveFocusAfterLayout = true;
        this.mViewFlinger = new ViewFlinger(this);
        this.mPrefetchRegistry = ALLOW_THREAD_GAP_WORK ? new GapWorker.LayoutPrefetchRegistryImpl() : null;
        this.mState = new State();
        this.mItemsAddedOrRemoved = false;
        this.mItemsChanged = false;
        this.mItemAnimatorListener = new ItemAnimatorRestoreListener(this);
        this.mPostedAnimatorRunner = false;
        this.mMinMaxLayoutPositions = new int[2];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.mNestedOffsets = new int[2];
        this.mPendingAccessibilityImportanceChange = new ArrayList<ViewHolder>();
        this.mItemAnimatorRunner = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecyclerView this$0;

            private void $$robo$$com_android_internal_widget_RecyclerView_2$__constructor__(RecyclerView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_2$run() {
                if (this.this$0.mItemAnimator != null) {
                    this.this$0.mItemAnimator.runPendingAnimations();
                }
                this.this$0.mPostedAnimatorRunner = false;
            }

            private void __constructor__(RecyclerView recyclerView) {
                this.$$robo$$com_android_internal_widget_RecyclerView_2$__constructor__(recyclerView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_2$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_RecyclerView_2$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mViewInfoProcessCallback = new ViewInfoStore.ProcessCallback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecyclerView this$0;

            private void $$robo$$com_android_internal_widget_RecyclerView_4$__constructor__(RecyclerView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_4$processDisappeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo info, ItemAnimator.ItemHolderInfo postInfo) {
                this.this$0.mRecycler.unscrapView(viewHolder);
                this.this$0.animateDisappearance(viewHolder, info, postInfo);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_4$processAppeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo preInfo, ItemAnimator.ItemHolderInfo info) {
                this.this$0.animateAppearance(viewHolder, preInfo, info);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_4$processPersistent(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo preInfo, ItemAnimator.ItemHolderInfo postInfo) {
                viewHolder.setIsRecyclable(false);
                if (this.this$0.mDataSetHasChangedAfterLayout) {
                    if (this.this$0.mItemAnimator.animateChange(viewHolder, viewHolder, preInfo, postInfo)) {
                        this.this$0.postAnimationRunner();
                    }
                } else if (this.this$0.mItemAnimator.animatePersistence(viewHolder, preInfo, postInfo)) {
                    this.this$0.postAnimationRunner();
                }
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_4$unused(ViewHolder viewHolder) {
                this.this$0.mLayout.removeAndRecycleView(viewHolder.itemView, this.this$0.mRecycler);
            }

            private void __constructor__(RecyclerView recyclerView) {
                this.$$robo$$com_android_internal_widget_RecyclerView_4$__constructor__(recyclerView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_4$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            @Override
            public void processDisappeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                InvokeDynamicSupport.bootstrap("processDisappeared", $$robo$$com_android_internal_widget_RecyclerView_4$processDisappeared(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            @Override
            public void processAppeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                InvokeDynamicSupport.bootstrap("processAppeared", $$robo$$com_android_internal_widget_RecyclerView_4$processAppeared(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            @Override
            public void processPersistent(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                InvokeDynamicSupport.bootstrap("processPersistent", $$robo$$com_android_internal_widget_RecyclerView_4$processPersistent(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            @Override
            public void unused(ViewHolder viewHolder) {
                InvokeDynamicSupport.bootstrap("unused", $$robo$$com_android_internal_widget_RecyclerView_4$unused(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, CLIP_TO_PADDING_ATTR, defStyle, 0);
            this.mClipToPadding = a.getBoolean(0, true);
            a.recycle();
        } else {
            this.mClipToPadding = true;
        }
        this.setScrollContainer(true);
        this.setFocusableInTouchMode(true);
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.setWillNotDraw(this.getOverScrollMode() == 2);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
        this.initAdapterManager();
        this.initChildrenHelper();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this));
        boolean nestedScrollingEnabled = true;
        if (attrs != null) {
            int defStyleRes = 0;
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyle, defStyleRes);
            String layoutManagerName = a.getString(2);
            int descendantFocusability = a.getInt(1, -1);
            if (descendantFocusability == -1) {
                this.setDescendantFocusability(262144);
            }
            a.recycle();
            this.createLayoutManager(context, layoutManagerName, attrs, defStyle, defStyleRes);
            if (Build.VERSION.SDK_INT >= 21) {
                a = context.obtainStyledAttributes(attrs, NESTED_SCROLLING_ATTRS, defStyle, defStyleRes);
                nestedScrollingEnabled = a.getBoolean(0, true);
                a.recycle();
            }
        } else {
            this.setDescendantFocusability(262144);
        }
        this.setNestedScrollingEnabled(nestedScrollingEnabled);
    }

    private final RecyclerViewAccessibilityDelegate $$robo$$com_android_internal_widget_RecyclerView$getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setAccessibilityDelegateCompat(RecyclerViewAccessibilityDelegate accessibilityDelegate) {
        this.mAccessibilityDelegate = accessibilityDelegate;
        this.setAccessibilityDelegate(this.mAccessibilityDelegate);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$createLayoutManager(Context context, String className, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (className != null && (className = className.trim()).length() != 0) {
            className = this.getFullClassName(context, className);
            try {
                Constructor<LayoutManager> constructor;
                ClassLoader classLoader = this.isInEditMode() ? this.getClass().getClassLoader() : context.getClassLoader();
                Class<LayoutManager> layoutManagerClass = classLoader.loadClass(className).asSubclass(LayoutManager.class);
                Object[] constructorArgs = null;
                try {
                    constructor = layoutManagerClass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                    constructorArgs = new Object[]{context, attrs, defStyleAttr, defStyleRes};
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructor = layoutManagerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        e1.initCause(e);
                        throw new IllegalStateException(attrs.getPositionDescription() + ": Error creating LayoutManager " + className, e1);
                    }
                }
                constructor.setAccessible(true);
                this.setLayoutManager(constructor.newInstance(constructorArgs));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Unable to find LayoutManager " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Cannot access non-public constructor " + className, e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Class is not a LayoutManager " + className, e);
            }
        }
    }

    private final String $$robo$$com_android_internal_widget_RecyclerView$getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        if (className.contains(".")) {
            return className;
        }
        return RecyclerView.class.getPackage().getName() + '.' + className;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$initChildrenHelper() {
        this.mChildHelper = new ChildHelper(new ChildHelper.Callback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecyclerView this$0;

            private void $$robo$$com_android_internal_widget_RecyclerView_5$__constructor__(RecyclerView this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$com_android_internal_widget_RecyclerView_5$getChildCount() {
                return this.this$0.getChildCount();
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$addView(View child, int index) {
                this.this$0.addView(child, index);
                this.this$0.dispatchChildAttached(child);
            }

            private final int $$robo$$com_android_internal_widget_RecyclerView_5$indexOfChild(View view) {
                return this.this$0.indexOfChild(view);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$removeViewAt(int index) {
                View child = this.this$0.getChildAt(index);
                if (child != null) {
                    this.this$0.dispatchChildDetached(child);
                }
                this.this$0.removeViewAt(index);
            }

            private final View $$robo$$com_android_internal_widget_RecyclerView_5$getChildAt(int offset) {
                return this.this$0.getChildAt(offset);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$removeAllViews() {
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    this.this$0.dispatchChildDetached(this.getChildAt(i));
                }
                this.this$0.removeAllViews();
            }

            private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_5$getChildViewHolder(View view) {
                return RecyclerView.getChildViewHolderInt(view);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$attachViewToParent(View child, int index, ViewGroup.LayoutParams layoutParams) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    if (!vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("Called attach on a child which is not detached: " + vh);
                    }
                    vh.clearTmpDetachFlag();
                }
                this.this$0.attachViewToParent(child, index, layoutParams);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$detachViewFromParent(int offset) {
                ViewHolder vh;
                View view = this.getChildAt(offset);
                if (view != null && (vh = RecyclerView.getChildViewHolderInt(view)) != null) {
                    if (vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("called detach on an already detached child " + vh);
                    }
                    vh.addFlags(256);
                }
                this.this$0.detachViewFromParent(offset);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$onEnteredHiddenState(View child) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    vh.onEnteredHiddenState(this.this$0);
                }
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_5$onLeftHiddenState(View child) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    vh.onLeftHiddenState(this.this$0);
                }
            }

            private void __constructor__(RecyclerView recyclerView) {
                this.$$robo$$com_android_internal_widget_RecyclerView_5$__constructor__(recyclerView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_5$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            @Override
            public int getChildCount() {
                return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$com_android_internal_widget_RecyclerView_5$getChildCount(), this);
            }

            @Override
            public void addView(View view, int n) {
                InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_RecyclerView_5$addView(android.view.View int ), this, view, n);
            }

            @Override
            public int indexOfChild(View view) {
                return (int)InvokeDynamicSupport.bootstrap("indexOfChild", $$robo$$com_android_internal_widget_RecyclerView_5$indexOfChild(android.view.View ), this, view);
            }

            @Override
            public void removeViewAt(int n) {
                InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$com_android_internal_widget_RecyclerView_5$removeViewAt(int ), this, n);
            }

            @Override
            public View getChildAt(int n) {
                return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$com_android_internal_widget_RecyclerView_5$getChildAt(int ), this, n);
            }

            @Override
            public void removeAllViews() {
                InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$com_android_internal_widget_RecyclerView_5$removeAllViews(), this);
            }

            @Override
            public ViewHolder getChildViewHolder(View view) {
                return InvokeDynamicSupport.bootstrap("getChildViewHolder", $$robo$$com_android_internal_widget_RecyclerView_5$getChildViewHolder(android.view.View ), this, view);
            }

            @Override
            public void attachViewToParent(View view, int n, ViewGroup.LayoutParams layoutParams) {
                InvokeDynamicSupport.bootstrap("attachViewToParent", $$robo$$com_android_internal_widget_RecyclerView_5$attachViewToParent(android.view.View int android.view.ViewGroup$LayoutParams ), this, view, n, layoutParams);
            }

            @Override
            public void detachViewFromParent(int n) {
                InvokeDynamicSupport.bootstrap("detachViewFromParent", $$robo$$com_android_internal_widget_RecyclerView_5$detachViewFromParent(int ), this, n);
            }

            @Override
            public void onEnteredHiddenState(View view) {
                InvokeDynamicSupport.bootstrap("onEnteredHiddenState", $$robo$$com_android_internal_widget_RecyclerView_5$onEnteredHiddenState(android.view.View ), this, view);
            }

            @Override
            public void onLeftHiddenState(View view) {
                InvokeDynamicSupport.bootstrap("onLeftHiddenState", $$robo$$com_android_internal_widget_RecyclerView_5$onLeftHiddenState(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$initAdapterManager() {
        this.mAdapterHelper = new AdapterHelper(new AdapterHelper.Callback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecyclerView this$0;

            private void $$robo$$com_android_internal_widget_RecyclerView_6$__constructor__(RecyclerView this$0) {
                this.this$0 = this$0;
            }

            private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_6$findViewHolder(int position) {
                ViewHolder vh = this.this$0.findViewHolderForPosition(position, true);
                if (vh == null) {
                    return null;
                }
                if (this.this$0.mChildHelper.isHidden(vh.itemView)) {
                    return null;
                }
                return vh;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForRemovingInvisible(int start, int count) {
                this.this$0.offsetPositionRecordsForRemove(start, count, true);
                this.this$0.mItemsAddedOrRemoved = true;
                this.this$0.mState.mDeletedInvisibleItemCountSincePreviousLayout += count;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForRemovingLaidOutOrNewView(int positionStart, int itemCount) {
                this.this$0.offsetPositionRecordsForRemove(positionStart, itemCount, false);
                this.this$0.mItemsAddedOrRemoved = true;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$markViewHoldersUpdated(int positionStart, int itemCount, Object payload) {
                this.this$0.viewRangeUpdate(positionStart, itemCount, payload);
                this.this$0.mItemsChanged = true;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$onDispatchFirstPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$dispatchUpdate(AdapterHelper.UpdateOp op) {
                switch (op.cmd) {
                    case 1: {
                        this.this$0.mLayout.onItemsAdded(this.this$0, op.positionStart, op.itemCount);
                        break;
                    }
                    case 2: {
                        this.this$0.mLayout.onItemsRemoved(this.this$0, op.positionStart, op.itemCount);
                        break;
                    }
                    case 4: {
                        this.this$0.mLayout.onItemsUpdated(this.this$0, op.positionStart, op.itemCount, op.payload);
                        break;
                    }
                    case 8: {
                        this.this$0.mLayout.onItemsMoved(this.this$0, op.positionStart, op.itemCount, 1);
                    }
                }
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$onDispatchSecondPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForAdd(int positionStart, int itemCount) {
                this.this$0.offsetPositionRecordsForInsert(positionStart, itemCount);
                this.this$0.mItemsAddedOrRemoved = true;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForMove(int from, int to) {
                this.this$0.offsetPositionRecordsForMove(from, to);
                this.this$0.mItemsAddedOrRemoved = true;
            }

            private void __constructor__(RecyclerView recyclerView) {
                this.$$robo$$com_android_internal_widget_RecyclerView_6$__constructor__(recyclerView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_6$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            @Override
            public ViewHolder findViewHolder(int n) {
                return InvokeDynamicSupport.bootstrap("findViewHolder", $$robo$$com_android_internal_widget_RecyclerView_6$findViewHolder(int ), this, n);
            }

            @Override
            public void offsetPositionsForRemovingInvisible(int n, int n2) {
                InvokeDynamicSupport.bootstrap("offsetPositionsForRemovingInvisible", $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForRemovingInvisible(int int ), this, n, n2);
            }

            @Override
            public void offsetPositionsForRemovingLaidOutOrNewView(int n, int n2) {
                InvokeDynamicSupport.bootstrap("offsetPositionsForRemovingLaidOutOrNewView", $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForRemovingLaidOutOrNewView(int int ), this, n, n2);
            }

            @Override
            public void markViewHoldersUpdated(int n, int n2, Object object) {
                InvokeDynamicSupport.bootstrap("markViewHoldersUpdated", $$robo$$com_android_internal_widget_RecyclerView_6$markViewHoldersUpdated(int int java.lang.Object ), this, n, n2, object);
            }

            @Override
            public void onDispatchFirstPass(AdapterHelper.UpdateOp updateOp) {
                InvokeDynamicSupport.bootstrap("onDispatchFirstPass", $$robo$$com_android_internal_widget_RecyclerView_6$onDispatchFirstPass(com.android.internal.widget.AdapterHelper$UpdateOp ), this, updateOp);
            }

            void dispatchUpdate(AdapterHelper.UpdateOp updateOp) {
                InvokeDynamicSupport.bootstrap("dispatchUpdate", $$robo$$com_android_internal_widget_RecyclerView_6$dispatchUpdate(com.android.internal.widget.AdapterHelper$UpdateOp ), this, updateOp);
            }

            @Override
            public void onDispatchSecondPass(AdapterHelper.UpdateOp updateOp) {
                InvokeDynamicSupport.bootstrap("onDispatchSecondPass", $$robo$$com_android_internal_widget_RecyclerView_6$onDispatchSecondPass(com.android.internal.widget.AdapterHelper$UpdateOp ), this, updateOp);
            }

            @Override
            public void offsetPositionsForAdd(int n, int n2) {
                InvokeDynamicSupport.bootstrap("offsetPositionsForAdd", $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForAdd(int int ), this, n, n2);
            }

            @Override
            public void offsetPositionsForMove(int n, int n2) {
                InvokeDynamicSupport.bootstrap("offsetPositionsForMove", $$robo$$com_android_internal_widget_RecyclerView_6$offsetPositionsForMove(int int ), this, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setHasFixedSize(boolean hasFixedSize) {
        this.mHasFixedSize = hasFixedSize;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$hasFixedSize() {
        return this.mHasFixedSize;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setClipToPadding(boolean clipToPadding) {
        if (clipToPadding != this.mClipToPadding) {
            this.invalidateGlows();
        }
        this.mClipToPadding = clipToPadding;
        super.setClipToPadding(clipToPadding);
        if (this.mFirstLayoutComplete) {
            this.requestLayout();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$getClipToPadding() {
        return this.mClipToPadding;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setScrollingTouchSlop(int slopConstant) {
        ViewConfiguration vc = ViewConfiguration.get(this.getContext());
        switch (slopConstant) {
            default: {
                Log.w("RecyclerView", "setScrollingTouchSlop(): bad argument constant " + slopConstant + "; using default value");
            }
            case 0: {
                this.mTouchSlop = vc.getScaledTouchSlop();
                break;
            }
            case 1: {
                this.mTouchSlop = vc.getScaledPagingTouchSlop();
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$swapAdapter(Adapter adapter, boolean removeAndRecycleExistingViews) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, true, removeAndRecycleExistingViews);
        this.setDataSetChangedAfterLayout();
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setAdapter(Adapter adapter) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, false, true);
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeAndRecycleViews() {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        if (this.mLayout != null) {
            this.mLayout.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        }
        this.mRecycler.clear();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setAdapterInternal(Adapter adapter, boolean compatibleWithPrevious, boolean removeAndRecycleViews) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!compatibleWithPrevious || removeAndRecycleViews) {
            this.removeAndRecycleViews();
        }
        this.mAdapterHelper.reset();
        Adapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
            adapter.onAttachedToRecyclerView(this);
        }
        if (this.mLayout != null) {
            this.mLayout.onAdapterChanged(oldAdapter, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(oldAdapter, this.mAdapter, compatibleWithPrevious);
        this.mState.mStructureChanged = true;
        this.markKnownViewsInvalid();
    }

    private final Adapter $$robo$$com_android_internal_widget_RecyclerView$getAdapter() {
        return this.mAdapter;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setRecyclerListener(RecyclerListener listener) {
        this.mRecyclerListener = listener;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getBaseline() {
        if (this.mLayout != null) {
            return this.mLayout.getBaseline();
        }
        return super.getBaseline();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addOnChildAttachStateChangeListener(OnChildAttachStateChangeListener listener) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList<OnChildAttachStateChangeListener>();
        }
        this.mOnChildAttachStateListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeOnChildAttachStateChangeListener(OnChildAttachStateChangeListener listener) {
        if (this.mOnChildAttachStateListeners == null) {
            return;
        }
        this.mOnChildAttachStateListeners.remove(listener);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$clearOnChildAttachStateChangeListeners() {
        if (this.mOnChildAttachStateListeners != null) {
            this.mOnChildAttachStateListeners.clear();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setLayoutManager(LayoutManager layout2) {
        if (layout2 == this.mLayout) {
            return;
        }
        this.stopScroll();
        if (this.mLayout != null) {
            if (this.mItemAnimator != null) {
                this.mItemAnimator.endAnimations();
            }
            this.mLayout.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
            this.mRecycler.clear();
            if (this.mIsAttached) {
                this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
            }
            this.mLayout.setRecyclerView(null);
            this.mLayout = null;
        } else {
            this.mRecycler.clear();
        }
        this.mChildHelper.removeAllViewsUnfiltered();
        this.mLayout = layout2;
        if (layout2 != null) {
            if (layout2.mRecyclerView != null) {
                throw new IllegalArgumentException("LayoutManager " + layout2 + " is already attached to a RecyclerView: " + layout2.mRecyclerView);
            }
            this.mLayout.setRecyclerView(this);
            if (this.mIsAttached) {
                this.mLayout.dispatchAttachedToWindow(this);
            }
        }
        this.mRecycler.updateViewCacheSize();
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setOnFlingListener(OnFlingListener onFlingListener) {
        this.mOnFlingListener = onFlingListener;
    }

    private final OnFlingListener $$robo$$com_android_internal_widget_RecyclerView$getOnFlingListener() {
        return this.mOnFlingListener;
    }

    private final Parcelable $$robo$$com_android_internal_widget_RecyclerView$onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSavedState != null) {
            state.copyFrom(this.mPendingSavedState);
        } else {
            state.mLayoutState = this.mLayout != null ? this.mLayout.onSaveInstanceState() : null;
        }
        return state;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        this.mPendingSavedState = (SavedState)state;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        if (this.mLayout != null && this.mPendingSavedState.mLayoutState != null) {
            this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addAnimatingView(ViewHolder viewHolder) {
        View view = viewHolder.itemView;
        boolean alreadyParented = view.getParent() == this;
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
        if (viewHolder.isTmpDetached()) {
            this.mChildHelper.attachViewToParent(view, -1, view.getLayoutParams(), true);
        } else if (!alreadyParented) {
            this.mChildHelper.addView(view, true);
        } else {
            this.mChildHelper.hide(view);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$removeAnimatingView(View view) {
        this.eatRequestLayout();
        boolean removed = this.mChildHelper.removeViewIfHidden(view);
        if (removed) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            this.mRecycler.unscrapView(viewHolder);
            this.mRecycler.recycleViewHolderInternal(viewHolder);
        }
        this.resumeRequestLayout(!removed);
        return removed;
    }

    private final LayoutManager $$robo$$com_android_internal_widget_RecyclerView$getLayoutManager() {
        return this.mLayout;
    }

    private final RecycledViewPool $$robo$$com_android_internal_widget_RecyclerView$getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setRecycledViewPool(RecycledViewPool pool) {
        this.mRecycler.setRecycledViewPool(pool);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setViewCacheExtension(ViewCacheExtension extension) {
        this.mRecycler.setViewCacheExtension(extension);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setItemViewCacheSize(int size) {
        this.mRecycler.setViewCacheSize(size);
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getScrollState() {
        return this.mScrollState;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
        if (state != 2) {
            this.stopScrollersInternal();
        }
        this.dispatchOnScrollStateChanged(state);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addItemDecoration(ItemDecoration decor, int index) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (index < 0) {
            this.mItemDecorations.add(decor);
        } else {
            this.mItemDecorations.add(index, decor);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addItemDecoration(ItemDecoration decor) {
        this.addItemDecoration(decor, -1);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeItemDecoration(ItemDecoration decor) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(decor);
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(this.getOverScrollMode() == 2);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setChildDrawingOrderCallback(ChildDrawingOrderCallback childDrawingOrderCallback) {
        if (childDrawingOrderCallback == this.mChildDrawingOrderCallback) {
            return;
        }
        this.mChildDrawingOrderCallback = childDrawingOrderCallback;
        this.setChildrenDrawingOrderEnabled(this.mChildDrawingOrderCallback != null);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_widget_RecyclerView$setOnScrollListener(OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addOnScrollListener(OnScrollListener listener) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList<OnScrollListener>();
        }
        this.mScrollListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeOnScrollListener(OnScrollListener listener) {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.remove(listener);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$clearOnScrollListeners() {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.clear();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$scrollToPosition(int position) {
        if (this.mLayoutFrozen) {
            return;
        }
        this.stopScroll();
        if (this.mLayout == null) {
            Log.e("RecyclerView", "Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$jumpToPositionForSmoothScroller(int position) {
        if (this.mLayout == null) {
            return;
        }
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$smoothScrollToPosition(int position) {
        if (this.mLayoutFrozen) {
            return;
        }
        if (this.mLayout == null) {
            Log.e("RecyclerView", "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.smoothScrollToPosition(this, this.mState, position);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$scrollTo(int x, int y) {
        Log.w("RecyclerView", "RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$scrollBy(int x, int y) {
        if (this.mLayout == null) {
            Log.e("RecyclerView", "Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutFrozen) {
            return;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (canScrollHorizontal || canScrollVertical) {
            this.scrollByInternal(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0, null);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$consumePendingUpdateOperations() {
        if (!this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout) {
            Trace.beginSection("RV FullInvalidate");
            this.dispatchLayout();
            Trace.endSection();
            return;
        }
        if (!this.mAdapterHelper.hasPendingUpdates()) {
            return;
        }
        if (this.mAdapterHelper.hasAnyUpdateTypes(4) && !this.mAdapterHelper.hasAnyUpdateTypes(11)) {
            Trace.beginSection("RV PartialInvalidate");
            this.eatRequestLayout();
            this.onEnterLayoutOrScroll();
            this.mAdapterHelper.preProcess();
            if (!this.mLayoutRequestEaten) {
                if (this.hasUpdatedView()) {
                    this.dispatchLayout();
                } else {
                    this.mAdapterHelper.consumePostponedUpdates();
                }
            }
            this.resumeRequestLayout(true);
            this.onExitLayoutOrScroll();
            Trace.endSection();
        } else if (this.mAdapterHelper.hasPendingUpdates()) {
            Trace.beginSection("RV FullInvalidate");
            this.dispatchLayout();
            Trace.endSection();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$hasUpdatedView() {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder == null || holder.shouldIgnore() || !holder.isUpdated()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$scrollByInternal(int x, int y, MotionEvent ev) {
        int unconsumedX = 0;
        int unconsumedY = 0;
        int consumedX = 0;
        int consumedY = 0;
        this.consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            this.eatRequestLayout();
            this.onEnterLayoutOrScroll();
            Trace.beginSection("RV Scroll");
            if (x != 0) {
                consumedX = this.mLayout.scrollHorizontallyBy(x, this.mRecycler, this.mState);
                unconsumedX = x - consumedX;
            }
            if (y != 0) {
                consumedY = this.mLayout.scrollVerticallyBy(y, this.mRecycler, this.mState);
                unconsumedY = y - consumedY;
            }
            Trace.endSection();
            this.repositionShadowingViews();
            this.onExitLayoutOrScroll();
            this.resumeRequestLayout(false);
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        if (this.dispatchNestedScroll(consumedX, consumedY, unconsumedX, unconsumedY, this.mScrollOffset)) {
            this.mLastTouchX -= this.mScrollOffset[0];
            this.mLastTouchY -= this.mScrollOffset[1];
            if (ev != null) {
                ev.offsetLocation(this.mScrollOffset[0], this.mScrollOffset[1]);
            }
            this.mNestedOffsets[0] = this.mNestedOffsets[0] + this.mScrollOffset[0];
            this.mNestedOffsets[1] = this.mNestedOffsets[1] + this.mScrollOffset[1];
        } else if (this.getOverScrollMode() != 2) {
            if (ev != null) {
                this.pullGlows(ev.getX(), unconsumedX, ev.getY(), unconsumedY);
            }
            this.considerReleasingGlowsOnScroll(x, y);
        }
        if (consumedX != 0 || consumedY != 0) {
            this.dispatchOnScrolled(consumedX, consumedY);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        return consumedX != 0 || consumedY != 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollOffset() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollOffset(this.mState) : 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollExtent() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollExtent(this.mState) : 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollRange() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollRange(this.mState) : 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollOffset() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollOffset(this.mState) : 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollExtent() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollExtent(this.mState) : 0;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollRange() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollRange(this.mState) : 0;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$eatRequestLayout() {
        ++this.mEatRequestLayout;
        if (this.mEatRequestLayout == 1 && !this.mLayoutFrozen) {
            this.mLayoutRequestEaten = false;
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$resumeRequestLayout(boolean performLayoutChildren) {
        if (this.mEatRequestLayout < 1) {
            this.mEatRequestLayout = 1;
        }
        if (!performLayoutChildren) {
            this.mLayoutRequestEaten = false;
        }
        if (this.mEatRequestLayout == 1) {
            if (performLayoutChildren && this.mLayoutRequestEaten && !this.mLayoutFrozen && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            if (!this.mLayoutFrozen) {
                this.mLayoutRequestEaten = false;
            }
        }
        --this.mEatRequestLayout;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setLayoutFrozen(boolean frozen) {
        if (frozen != this.mLayoutFrozen) {
            this.assertNotInLayoutOrScroll("Do not setLayoutFrozen in layout or scroll");
            if (!frozen) {
                this.mLayoutFrozen = false;
                if (this.mLayoutRequestEaten && this.mLayout != null && this.mAdapter != null) {
                    this.requestLayout();
                }
                this.mLayoutRequestEaten = false;
            } else {
                long now = SystemClock.uptimeMillis();
                MotionEvent cancelEvent = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                this.onTouchEvent(cancelEvent);
                this.mLayoutFrozen = true;
                this.mIgnoreMotionEventTillDown = true;
                this.stopScroll();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isLayoutFrozen() {
        return this.mLayoutFrozen;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$smoothScrollBy(int dx, int dy) {
        this.smoothScrollBy(dx, dy, null);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$smoothScrollBy(int dx, int dy, Interpolator interpolator2) {
        if (this.mLayout == null) {
            Log.e("RecyclerView", "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutFrozen) {
            return;
        }
        if (!this.mLayout.canScrollHorizontally()) {
            dx = 0;
        }
        if (!this.mLayout.canScrollVertically()) {
            dy = 0;
        }
        if (dx != 0 || dy != 0) {
            this.mViewFlinger.smoothScrollBy(dx, dy, interpolator2);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$fling(int velocityX, int velocityY) {
        if (this.mLayout == null) {
            Log.e("RecyclerView", "Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return false;
        }
        if (this.mLayoutFrozen) {
            return false;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (!canScrollHorizontal || Math.abs(velocityX) < this.mMinFlingVelocity) {
            velocityX = 0;
        }
        if (!canScrollVertical || Math.abs(velocityY) < this.mMinFlingVelocity) {
            velocityY = 0;
        }
        if (velocityX == 0 && velocityY == 0) {
            return false;
        }
        if (!this.dispatchNestedPreFling(velocityX, velocityY)) {
            boolean canScroll = canScrollHorizontal || canScrollVertical;
            this.dispatchNestedFling(velocityX, velocityY, canScroll);
            if (this.mOnFlingListener != null && this.mOnFlingListener.onFling(velocityX, velocityY)) {
                return true;
            }
            if (canScroll) {
                velocityX = Math.max(-this.mMaxFlingVelocity, Math.min(velocityX, this.mMaxFlingVelocity));
                velocityY = Math.max(-this.mMaxFlingVelocity, Math.min(velocityY, this.mMaxFlingVelocity));
                this.mViewFlinger.fling(velocityX, velocityY);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$stopScroll() {
        this.setScrollState(0);
        this.stopScrollersInternal();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$stopScrollersInternal() {
        this.mViewFlinger.stop();
        if (this.mLayout != null) {
            this.mLayout.stopSmoothScroller();
        }
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$pullGlows(float x, float overscrollX, float y, float overscrollY) {
        boolean invalidate = false;
        if (overscrollX < 0.0f) {
            this.ensureLeftGlow();
            this.mLeftGlow.onPull(-overscrollX / (float)this.getWidth(), 1.0f - y / (float)this.getHeight());
            invalidate = true;
        } else if (overscrollX > 0.0f) {
            this.ensureRightGlow();
            this.mRightGlow.onPull(overscrollX / (float)this.getWidth(), y / (float)this.getHeight());
            invalidate = true;
        }
        if (overscrollY < 0.0f) {
            this.ensureTopGlow();
            this.mTopGlow.onPull(-overscrollY / (float)this.getHeight(), x / (float)this.getWidth());
            invalidate = true;
        } else if (overscrollY > 0.0f) {
            this.ensureBottomGlow();
            this.mBottomGlow.onPull(overscrollY / (float)this.getHeight(), 1.0f - x / (float)this.getWidth());
            invalidate = true;
        }
        if (invalidate || overscrollX != 0.0f || overscrollY != 0.0f) {
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$releaseGlows() {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null) {
            this.mLeftGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mTopGlow != null) {
            this.mTopGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mRightGlow != null) {
            this.mRightGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mBottomGlow != null) {
            this.mBottomGlow.onRelease();
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$considerReleasingGlowsOnScroll(int dx, int dy) {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished() && dx > 0) {
            this.mLeftGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished() && dx < 0) {
            this.mRightGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished() && dy > 0) {
            this.mTopGlow.onRelease();
            needsInvalidate = true;
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished() && dy < 0) {
            this.mBottomGlow.onRelease();
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$absorbGlows(int velocityX, int velocityY) {
        if (velocityX < 0) {
            this.ensureLeftGlow();
            this.mLeftGlow.onAbsorb(-velocityX);
        } else if (velocityX > 0) {
            this.ensureRightGlow();
            this.mRightGlow.onAbsorb(velocityX);
        }
        if (velocityY < 0) {
            this.ensureTopGlow();
            this.mTopGlow.onAbsorb(-velocityY);
        } else if (velocityY > 0) {
            this.ensureBottomGlow();
            this.mBottomGlow.onAbsorb(velocityY);
        }
        if (velocityX != 0 || velocityY != 0) {
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$ensureLeftGlow() {
        if (this.mLeftGlow != null) {
            return;
        }
        this.mLeftGlow = new EdgeEffect(this.getContext());
        if (this.mClipToPadding) {
            this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mLeftGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$ensureRightGlow() {
        if (this.mRightGlow != null) {
            return;
        }
        this.mRightGlow = new EdgeEffect(this.getContext());
        if (this.mClipToPadding) {
            this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mRightGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$ensureTopGlow() {
        if (this.mTopGlow != null) {
            return;
        }
        this.mTopGlow = new EdgeEffect(this.getContext());
        if (this.mClipToPadding) {
            this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mTopGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$ensureBottomGlow() {
        if (this.mBottomGlow != null) {
            return;
        }
        this.mBottomGlow = new EdgeEffect(this.getContext());
        if (this.mClipToPadding) {
            this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mBottomGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    private final View $$robo$$com_android_internal_widget_RecyclerView$focusSearch(View focused, int direction) {
        View result = this.mLayout.onInterceptFocusSearch(focused, direction);
        if (result != null) {
            return result;
        }
        boolean canRunFocusFailure = this.mAdapter != null && this.mLayout != null && !this.isComputingLayout() && !this.mLayoutFrozen;
        FocusFinder ff = FocusFinder.getInstance();
        if (canRunFocusFailure && (direction == 2 || direction == 1)) {
            boolean needsFocusFailureLayout = false;
            if (this.mLayout.canScrollVertically()) {
                int absDir = direction == 2 ? 130 : 33;
                View found = ff.findNextFocus(this, focused, absDir);
                boolean bl = needsFocusFailureLayout = found == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    direction = absDir;
                }
            }
            if (!needsFocusFailureLayout && this.mLayout.canScrollHorizontally()) {
                boolean rtl = this.mLayout.getLayoutDirection() == 1;
                int absDir = direction == 2 ^ rtl ? 66 : 17;
                View found = ff.findNextFocus(this, focused, absDir);
                boolean bl = needsFocusFailureLayout = found == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    direction = absDir;
                }
            }
            if (needsFocusFailureLayout) {
                this.consumePendingUpdateOperations();
                View focusedItemView = this.findContainingItemView(focused);
                if (focusedItemView == null) {
                    return null;
                }
                this.eatRequestLayout();
                this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
                this.resumeRequestLayout(false);
            }
            result = ff.findNextFocus(this, focused, direction);
        } else {
            result = ff.findNextFocus(this, focused, direction);
            if (result == null && canRunFocusFailure) {
                this.consumePendingUpdateOperations();
                View focusedItemView = this.findContainingItemView(focused);
                if (focusedItemView == null) {
                    return null;
                }
                this.eatRequestLayout();
                result = this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
                this.resumeRequestLayout(false);
            }
        }
        return this.isPreferredNextFocus(focused, result, direction) ? result : super.focusSearch(focused, direction);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isPreferredNextFocus(View focused, View next, int direction) {
        if (next == null || next == this) {
            return false;
        }
        if (focused == null) {
            return true;
        }
        if (direction == 2 || direction == 1) {
            int absHorizontal;
            boolean rtl = this.mLayout.getLayoutDirection() == 1;
            int n = absHorizontal = direction == 2 ^ rtl ? 66 : 17;
            if (this.isPreferredNextFocusAbsolute(focused, next, absHorizontal)) {
                return true;
            }
            if (direction == 2) {
                return this.isPreferredNextFocusAbsolute(focused, next, 130);
            }
            return this.isPreferredNextFocusAbsolute(focused, next, 33);
        }
        return this.isPreferredNextFocusAbsolute(focused, next, direction);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isPreferredNextFocusAbsolute(View focused, View next, int direction) {
        this.mTempRect.set(0, 0, focused.getWidth(), focused.getHeight());
        this.mTempRect2.set(0, 0, next.getWidth(), next.getHeight());
        this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
        this.offsetDescendantRectToMyCoords(next, this.mTempRect2);
        switch (direction) {
            case 17: {
                return (this.mTempRect.right > this.mTempRect2.right || this.mTempRect.left >= this.mTempRect2.right) && this.mTempRect.left > this.mTempRect2.left;
            }
            case 66: {
                return (this.mTempRect.left < this.mTempRect2.left || this.mTempRect.right <= this.mTempRect2.left) && this.mTempRect.right < this.mTempRect2.right;
            }
            case 33: {
                return (this.mTempRect.bottom > this.mTempRect2.bottom || this.mTempRect.top >= this.mTempRect2.bottom) && this.mTempRect.top > this.mTempRect2.top;
            }
            case 130: {
                return (this.mTempRect.top < this.mTempRect2.top || this.mTempRect.bottom <= this.mTempRect2.top) && this.mTempRect.bottom < this.mTempRect2.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be absolute. received:" + direction);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$requestChildFocus(View child, View focused) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, child, focused) && focused != null) {
            this.mTempRect.set(0, 0, focused.getWidth(), focused.getHeight());
            ViewGroup.LayoutParams focusedLayoutParams = focused.getLayoutParams();
            if (focusedLayoutParams instanceof LayoutParams) {
                LayoutParams lp = (LayoutParams)focusedLayoutParams;
                if (!lp.mInsetsDirty) {
                    Rect insets = lp.mDecorInsets;
                    this.mTempRect.left -= insets.left;
                    this.mTempRect.right += insets.right;
                    this.mTempRect.top -= insets.top;
                    this.mTempRect.bottom += insets.bottom;
                }
            }
            this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
            this.offsetRectIntoDescendantCoords(child, this.mTempRect);
            this.requestChildRectangleOnScreen(child, this.mTempRect, !this.mFirstLayoutComplete);
        }
        super.requestChildFocus(child, focused);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mLayout.requestChildRectangleOnScreen(this, child, rect, immediate);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (this.mLayout == null || !this.mLayout.onAddFocusables(this, views, direction, focusableMode)) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        if (this.isComputingLayout()) {
            return false;
        }
        return super.onRequestFocusInDescendants(direction, previouslyFocusedRect);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        this.mIsAttached = true;
        boolean bl = this.mFirstLayoutComplete = this.mFirstLayoutComplete && !this.isLayoutRequested();
        if (this.mLayout != null) {
            this.mLayout.dispatchAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
        if (ALLOW_THREAD_GAP_WORK) {
            this.mGapWorker = GapWorker.sGapWorker.get();
            if (this.mGapWorker == null) {
                float displayRefreshRate;
                this.mGapWorker = new GapWorker();
                Display display = this.getDisplay();
                float refreshRate = 60.0f;
                if (!this.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
                    refreshRate = displayRefreshRate;
                }
                this.mGapWorker.mFrameIntervalNs = (long)(1.0E9f / refreshRate);
                GapWorker.sGapWorker.set(this.mGapWorker);
            }
            this.mGapWorker.add(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        this.stopScroll();
        this.mIsAttached = false;
        if (this.mLayout != null) {
            this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
        }
        this.mPendingAccessibilityImportanceChange.clear();
        this.removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.onDetach();
        if (ALLOW_THREAD_GAP_WORK) {
            this.mGapWorker.remove(this);
            this.mGapWorker = null;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isAttachedToWindow() {
        return this.mIsAttached;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$assertInLayoutOrScroll(String message) {
        if (!this.isComputingLayout()) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method unless RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(message);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$assertNotInLayoutOrScroll(String message) {
        if (this.isComputingLayout()) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(message);
        }
        if (this.mDispatchScrollCounter > 0) {
            Log.w("RecyclerView", "Cannot call this method in a scroll callback. Scroll callbacks might be run during a measure & layout pass where you cannot change the RecyclerView data. Any method call that might change the structure of the RecyclerView or the adapter contents should be postponed to the next frame.", new IllegalStateException(""));
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$addOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.remove(listener);
        if (this.mActiveOnItemTouchListener == listener) {
            this.mActiveOnItemTouchListener = null;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$dispatchOnItemTouchIntercept(MotionEvent e) {
        int action = e.getAction();
        if (action == 3 || action == 0) {
            this.mActiveOnItemTouchListener = null;
        }
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            if (!listener.onInterceptTouchEvent(this, e) || action == 3) continue;
            this.mActiveOnItemTouchListener = listener;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$dispatchOnItemTouch(MotionEvent e) {
        int action = e.getAction();
        if (this.mActiveOnItemTouchListener != null) {
            if (action == 0) {
                this.mActiveOnItemTouchListener = null;
            } else {
                this.mActiveOnItemTouchListener.onTouchEvent(this, e);
                if (action == 3 || action == 1) {
                    this.mActiveOnItemTouchListener = null;
                }
                return true;
            }
        }
        if (action != 0) {
            int listenerCount = this.mOnItemTouchListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
                if (!listener.onInterceptTouchEvent(this, e)) continue;
                this.mActiveOnItemTouchListener = listener;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$onInterceptTouchEvent(MotionEvent e) {
        if (this.mLayoutFrozen) {
            return false;
        }
        if (this.dispatchOnItemTouchIntercept(e)) {
            this.cancelTouch();
            return true;
        }
        if (this.mLayout == null) {
            return false;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = e.getActionMasked();
        int actionIndex = e.getActionIndex();
        switch (action) {
            case 0: {
                if (this.mIgnoreMotionEventTillDown) {
                    this.mIgnoreMotionEventTillDown = false;
                }
                this.mScrollPointerId = e.getPointerId(0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                if (this.mScrollState == 2) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                }
                this.mNestedOffsets[1] = 0;
                this.mNestedOffsets[0] = 0;
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis);
                break;
            }
            case 5: {
                this.mScrollPointerId = e.getPointerId(actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = e.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e("RecyclerView", "Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?");
                    return false;
                }
                int x = (int)(e.getX(index) + 0.5f);
                int y = (int)(e.getY(index) + 0.5f);
                if (this.mScrollState == 1) break;
                int dx = x - this.mInitialTouchX;
                int dy = y - this.mInitialTouchY;
                boolean startScroll = false;
                if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                    this.mLastTouchX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                    this.mLastTouchY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (!startScroll) break;
                this.setScrollState(1);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                this.mVelocityTracker.clear();
                this.stopNestedScroll();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        return this.mScrollState == 1;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            listener.onRequestDisallowInterceptTouchEvent(disallowIntercept);
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$onTouchEvent(MotionEvent e) {
        if (this.mLayoutFrozen || this.mIgnoreMotionEventTillDown) {
            return false;
        }
        if (this.dispatchOnItemTouch(e)) {
            this.cancelTouch();
            return true;
        }
        if (this.mLayout == null) {
            return false;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        boolean eventAddedToVelocityTracker = false;
        MotionEvent vtev = MotionEvent.obtain(e);
        int action = e.getActionMasked();
        int actionIndex = e.getActionIndex();
        if (action == 0) {
            this.mNestedOffsets[1] = 0;
            this.mNestedOffsets[0] = 0;
        }
        vtev.offsetLocation(this.mNestedOffsets[0], this.mNestedOffsets[1]);
        switch (action) {
            case 0: {
                this.mScrollPointerId = e.getPointerId(0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis);
                break;
            }
            case 5: {
                this.mScrollPointerId = e.getPointerId(actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int y;
                int dy;
                int index = e.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e("RecyclerView", "Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?");
                    return false;
                }
                int x = (int)(e.getX(index) + 0.5f);
                int dx = this.mLastTouchX - x;
                if (this.dispatchNestedPreScroll(dx, dy = this.mLastTouchY - (y = (int)(e.getY(index) + 0.5f)), this.mScrollConsumed, this.mScrollOffset)) {
                    dx -= this.mScrollConsumed[0];
                    dy -= this.mScrollConsumed[1];
                    vtev.offsetLocation(this.mScrollOffset[0], this.mScrollOffset[1]);
                    this.mNestedOffsets[0] = this.mNestedOffsets[0] + this.mScrollOffset[0];
                    this.mNestedOffsets[1] = this.mNestedOffsets[1] + this.mScrollOffset[1];
                }
                if (this.mScrollState != 1) {
                    boolean startScroll = false;
                    if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                        dx = dx > 0 ? (dx -= this.mTouchSlop) : (dx += this.mTouchSlop);
                        startScroll = true;
                    }
                    if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                        dy = dy > 0 ? (dy -= this.mTouchSlop) : (dy += this.mTouchSlop);
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState != 1) break;
                this.mLastTouchX = x - this.mScrollOffset[0];
                this.mLastTouchY = y - this.mScrollOffset[1];
                if (this.scrollByInternal(canScrollHorizontally ? dx : 0, canScrollVertically ? dy : 0, vtev)) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.mGapWorker == null || dx == 0 && dy == 0) break;
                this.mGapWorker.postFromTraversal(this, dx, dy);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                float yvel;
                this.mVelocityTracker.addMovement(vtev);
                eventAddedToVelocityTracker = true;
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaxFlingVelocity);
                float xvel = canScrollHorizontally ? -this.mVelocityTracker.getXVelocity(this.mScrollPointerId) : 0.0f;
                float f = yvel = canScrollVertically ? -this.mVelocityTracker.getYVelocity(this.mScrollPointerId) : 0.0f;
                if (xvel == 0.0f && yvel == 0.0f || !this.fling((int)xvel, (int)yvel)) {
                    this.setScrollState(0);
                }
                this.resetTouch();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        if (!eventAddedToVelocityTracker) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$resetTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.stopNestedScroll();
        this.releaseGlows();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$cancelTouch() {
        this.resetTouch();
        this.setScrollState(0);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onPointerUp(MotionEvent e) {
        int actionIndex = e.getActionIndex();
        if (e.getPointerId(actionIndex) == this.mScrollPointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = e.getPointerId(newIndex);
            this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(newIndex) + 0.5f);
            this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(newIndex) + 0.5f);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$onGenericMotionEvent(MotionEvent event) {
        if (this.mLayout == null) {
            return false;
        }
        if (this.mLayoutFrozen) {
            return false;
        }
        if ((event.getSource() & 2) != 0 && event.getAction() == 8) {
            float vScroll = this.mLayout.canScrollVertically() ? -event.getAxisValue(9) : 0.0f;
            float hScroll = this.mLayout.canScrollHorizontally() ? event.getAxisValue(10) : 0.0f;
            if (vScroll != 0.0f || hScroll != 0.0f) {
                float scrollFactor = this.getScrollFactor();
                this.scrollByInternal((int)(hScroll * scrollFactor), (int)(vScroll * scrollFactor), event);
            }
        }
        return false;
    }

    private final float $$robo$$com_android_internal_widget_RecyclerView$getScrollFactor() {
        if (this.mScrollFactor == Float.MIN_VALUE) {
            TypedValue outValue = new TypedValue();
            if (this.getContext().getTheme().resolveAttribute(16842829, outValue, true)) {
                this.mScrollFactor = outValue.getDimension(this.getContext().getResources().getDisplayMetrics());
            } else {
                return 0.0f;
            }
        }
        return this.mScrollFactor;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onMeasure(int widthSpec, int heightSpec) {
        if (this.mLayout == null) {
            this.defaultOnMeasure(widthSpec, heightSpec);
            return;
        }
        if (this.mLayout.mAutoMeasure) {
            int widthMode = View.MeasureSpec.getMode(widthSpec);
            int heightMode = View.MeasureSpec.getMode(heightSpec);
            boolean skipMeasure = widthMode == 0x40000000 && heightMode == 0x40000000;
            this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
            if (skipMeasure || this.mAdapter == null) {
                return;
            }
            if (this.mState.mLayoutStep == 1) {
                this.dispatchLayoutStep1();
            }
            this.mLayout.setMeasureSpecs(widthSpec, heightSpec);
            this.mState.mIsMeasuring = true;
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(widthSpec, heightSpec);
            if (this.mLayout.shouldMeasureTwice()) {
                this.mLayout.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000));
                this.mState.mIsMeasuring = true;
                this.dispatchLayoutStep2();
                this.mLayout.setMeasuredDimensionFromChildren(widthSpec, heightSpec);
            }
        } else {
            if (this.mHasFixedSize) {
                this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
                return;
            }
            if (this.mAdapterUpdateDuringMeasure) {
                this.eatRequestLayout();
                this.onEnterLayoutOrScroll();
                this.processAdapterUpdatesAndSetAnimationFlags();
                this.onExitLayoutOrScroll();
                if (this.mState.mRunPredictiveAnimations) {
                    this.mState.mInPreLayout = true;
                } else {
                    this.mAdapterHelper.consumeUpdatesInOnePass();
                    this.mState.mInPreLayout = false;
                }
                this.mAdapterUpdateDuringMeasure = false;
                this.resumeRequestLayout(false);
            }
            this.mState.mItemCount = this.mAdapter != null ? this.mAdapter.getItemCount() : 0;
            this.eatRequestLayout();
            this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
            this.resumeRequestLayout(false);
            this.mState.mInPreLayout = false;
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$defaultOnMeasure(int widthSpec, int heightSpec) {
        int width = LayoutManager.chooseSize(widthSpec, this.getPaddingLeft() + this.getPaddingRight(), this.getMinimumWidth());
        int height = LayoutManager.chooseSize(heightSpec, this.getPaddingTop() + this.getPaddingBottom(), this.getMinimumHeight());
        this.setMeasuredDimension(width, height);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.invalidateGlows();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setItemAnimator(ItemAnimator animator2) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
            this.mItemAnimator.setListener(null);
        }
        this.mItemAnimator = animator2;
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onEnterLayoutOrScroll() {
        ++this.mLayoutOrScrollCounter;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onExitLayoutOrScroll() {
        --this.mLayoutOrScrollCounter;
        if (this.mLayoutOrScrollCounter < 1) {
            this.mLayoutOrScrollCounter = 0;
            this.dispatchContentChangedIfNecessary();
            this.dispatchPendingImportantForAccessibilityChanges();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isAccessibilityEnabled() {
        return this.mAccessibilityManager != null && this.mAccessibilityManager.isEnabled();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchContentChangedIfNecessary() {
        int flags = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (flags != 0 && this.isAccessibilityEnabled()) {
            AccessibilityEvent event = AccessibilityEvent.obtain();
            event.setEventType(2048);
            event.setContentChangeTypes(flags);
            this.sendAccessibilityEventUnchecked(event);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isComputingLayout() {
        return this.mLayoutOrScrollCounter > 0;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$shouldDeferAccessibilityEvent(AccessibilityEvent event) {
        if (this.isComputingLayout()) {
            int type = 0;
            if (event != null) {
                type = event.getContentChangeTypes();
            }
            if (type == 0) {
                type = 0;
            }
            this.mEatenAccessibilityChangeFlags |= type;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (this.shouldDeferAccessibilityEvent(event)) {
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    private final ItemAnimator $$robo$$com_android_internal_widget_RecyclerView$getItemAnimator() {
        return this.mItemAnimator;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            this.postOnAnimation(this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$predictiveItemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$processAdapterUpdatesAndSetAnimationFlags() {
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.reset();
            this.mLayout.onItemsChanged(this);
        }
        if (this.predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.preProcess();
        } else {
            this.mAdapterHelper.consumeUpdatesInOnePass();
        }
        boolean animationTypeSupported = this.mItemsAddedOrRemoved || this.mItemsChanged;
        this.mState.mRunSimpleAnimations = !(!this.mFirstLayoutComplete || this.mItemAnimator == null || !this.mDataSetHasChangedAfterLayout && !animationTypeSupported && !this.mLayout.mRequestedSimpleAnimations || this.mDataSetHasChangedAfterLayout && !this.mAdapter.hasStableIds());
        this.mState.mRunPredictiveAnimations = this.mState.mRunSimpleAnimations && animationTypeSupported && !this.mDataSetHasChangedAfterLayout && this.predictiveItemAnimationsEnabled();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchLayout() {
        if (this.mAdapter == null) {
            Log.e("RecyclerView", "No adapter attached; skipping layout");
            return;
        }
        if (this.mLayout == null) {
            Log.e("RecyclerView", "No layout manager attached; skipping layout");
            return;
        }
        this.mState.mIsMeasuring = false;
        if (this.mState.mLayoutStep == 1) {
            this.dispatchLayoutStep1();
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else if (this.mAdapterHelper.hasUpdates() || this.mLayout.getWidth() != this.getWidth() || this.mLayout.getHeight() != this.getHeight()) {
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else {
            this.mLayout.setExactMeasureSpecsFrom(this);
        }
        this.dispatchLayoutStep3();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$saveFocusInfo() {
        ViewHolder focusedVh;
        View child = null;
        if (this.mPreserveFocusAfterLayout && this.hasFocus() && this.mAdapter != null) {
            child = this.getFocusedChild();
        }
        ViewHolder viewHolder = focusedVh = child == null ? null : this.findContainingViewHolder(child);
        if (focusedVh == null) {
            this.resetFocusInfo();
        } else {
            long l = this.mState.mFocusedItemId = this.mAdapter.hasStableIds() ? focusedVh.getItemId() : -1L;
            this.mState.mFocusedItemPosition = this.mDataSetHasChangedAfterLayout ? -1 : (focusedVh.isRemoved() ? focusedVh.mOldPosition : focusedVh.getAdapterPosition());
            this.mState.mFocusedSubChildId = this.getDeepestFocusedViewWithId(focusedVh.itemView);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$resetFocusInfo() {
        this.mState.mFocusedItemId = -1L;
        this.mState.mFocusedItemPosition = -1;
        this.mState.mFocusedSubChildId = -1;
    }

    private final View $$robo$$com_android_internal_widget_RecyclerView$findNextViewToFocus() {
        ViewHolder nextFocus;
        int startFocusSearchIndex = this.mState.mFocusedItemPosition != -1 ? this.mState.mFocusedItemPosition : 0;
        int itemCount = this.mState.getItemCount();
        for (int i = startFocusSearchIndex; i < itemCount && (nextFocus = this.findViewHolderForAdapterPosition(i)) != null; ++i) {
            if (!nextFocus.itemView.hasFocusable()) continue;
            return nextFocus.itemView;
        }
        int limit = Math.min(itemCount, startFocusSearchIndex);
        for (int i = limit - 1; i >= 0; --i) {
            nextFocus = this.findViewHolderForAdapterPosition(i);
            if (nextFocus == null) {
                return null;
            }
            if (!nextFocus.itemView.hasFocusable()) continue;
            return nextFocus.itemView;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$recoverFocusFromState() {
        if (!this.mPreserveFocusAfterLayout || this.mAdapter == null || !this.hasFocus() || this.getDescendantFocusability() == 393216 || this.getDescendantFocusability() == 131072 && this.isFocused()) {
            return;
        }
        if (!this.isFocused()) {
            View focusedChild = this.getFocusedChild();
            if (IGNORE_DETACHED_FOCUSED_CHILD && (focusedChild.getParent() == null || !focusedChild.hasFocus())) {
                if (this.mChildHelper.getChildCount() == 0) {
                    this.requestFocus();
                    return;
                }
            } else if (!this.mChildHelper.isHidden(focusedChild)) {
                return;
            }
        }
        ViewHolder focusTarget = null;
        if (this.mState.mFocusedItemId != -1L && this.mAdapter.hasStableIds()) {
            focusTarget = this.findViewHolderForItemId(this.mState.mFocusedItemId);
        }
        View viewToFocus = null;
        if (focusTarget == null || this.mChildHelper.isHidden(focusTarget.itemView) || !focusTarget.itemView.hasFocusable()) {
            if (this.mChildHelper.getChildCount() > 0) {
                viewToFocus = this.findNextViewToFocus();
            }
        } else {
            viewToFocus = focusTarget.itemView;
        }
        if (viewToFocus != null) {
            Object child;
            if ((long)this.mState.mFocusedSubChildId != -1L && (child = viewToFocus.findViewById(this.mState.mFocusedSubChildId)) != null && ((View)child).isFocusable()) {
                viewToFocus = child;
            }
            viewToFocus.requestFocus();
        }
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getDeepestFocusedViewWithId(View view) {
        int lastKnownId = view.getId();
        while (!view.isFocused() && view instanceof ViewGroup && view.hasFocus()) {
            int id2 = (view = ((ViewGroup)view).getFocusedChild()).getId();
            if (id2 == -1) continue;
            lastKnownId = view.getId();
        }
        return lastKnownId;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep1() {
        int i;
        this.mState.assertLayoutStep(1);
        this.mState.mIsMeasuring = false;
        this.eatRequestLayout();
        this.mViewInfoStore.clear();
        this.onEnterLayoutOrScroll();
        this.processAdapterUpdatesAndSetAnimationFlags();
        this.saveFocusInfo();
        this.mState.mTrackOldChangeHolders = this.mState.mRunSimpleAnimations && this.mItemsChanged;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        this.mState.mInPreLayout = this.mState.mRunPredictiveAnimations;
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.mRunSimpleAnimations) {
            int count = this.mChildHelper.getChildCount();
            for (i = 0; i < count; ++i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                if (holder.shouldIgnore() || holder.isInvalid() && !this.mAdapter.hasStableIds()) continue;
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, holder, ItemAnimator.buildAdapterChangeFlagsForAnimations(holder), holder.getUnmodifiedPayloads());
                this.mViewInfoStore.addToPreLayout(holder, animationInfo);
                if (!this.mState.mTrackOldChangeHolders || !holder.isUpdated() || holder.isRemoved() || holder.shouldIgnore() || holder.isInvalid()) continue;
                long key = this.getChangedHolderKey(holder);
                this.mViewInfoStore.addToOldChangeHolders(key, holder);
            }
        }
        if (this.mState.mRunPredictiveAnimations) {
            this.saveOldPositions();
            boolean didStructureChange = this.mState.mStructureChanged;
            this.mState.mStructureChanged = false;
            this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
            this.mState.mStructureChanged = didStructureChange;
            for (i = 0; i < this.mChildHelper.getChildCount(); ++i) {
                View child = this.mChildHelper.getChildAt(i);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
                if (viewHolder.shouldIgnore() || this.mViewInfoStore.isInPreLayout(viewHolder)) continue;
                int flags = ItemAnimator.buildAdapterChangeFlagsForAnimations(viewHolder);
                boolean wasHidden = viewHolder.hasAnyOfTheFlags(8192);
                if (!wasHidden) {
                    flags |= 0x1000;
                }
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, viewHolder, flags, viewHolder.getUnmodifiedPayloads());
                if (wasHidden) {
                    this.recordAnimationInfoIfBouncedHiddenView(viewHolder, animationInfo);
                    continue;
                }
                this.mViewInfoStore.addToAppearedInPreLayoutHolders(viewHolder, animationInfo);
            }
            this.clearOldPositions();
        } else {
            this.clearOldPositions();
        }
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
        this.mState.mLayoutStep = 2;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep2() {
        this.eatRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.assertLayoutStep(6);
        this.mAdapterHelper.consumeUpdatesInOnePass();
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.mState.mDeletedInvisibleItemCountSincePreviousLayout = 0;
        this.mState.mInPreLayout = false;
        this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
        this.mState.mStructureChanged = false;
        this.mPendingSavedState = null;
        this.mState.mRunSimpleAnimations = this.mState.mRunSimpleAnimations && this.mItemAnimator != null;
        this.mState.mLayoutStep = 4;
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep3() {
        this.mState.assertLayoutStep(4);
        this.eatRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.mLayoutStep = 1;
        if (this.mState.mRunSimpleAnimations) {
            for (int i = this.mChildHelper.getChildCount() - 1; i >= 0; --i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                if (holder.shouldIgnore()) continue;
                long key = this.getChangedHolderKey(holder);
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPostLayoutInformation(this.mState, holder);
                ViewHolder oldChangeViewHolder = this.mViewInfoStore.getFromOldChangeHolders(key);
                if (oldChangeViewHolder != null && !oldChangeViewHolder.shouldIgnore()) {
                    boolean oldDisappearing = this.mViewInfoStore.isDisappearing(oldChangeViewHolder);
                    boolean newDisappearing = this.mViewInfoStore.isDisappearing(holder);
                    if (oldDisappearing && oldChangeViewHolder == holder) {
                        this.mViewInfoStore.addToPostLayout(holder, animationInfo);
                        continue;
                    }
                    ItemAnimator.ItemHolderInfo preInfo = this.mViewInfoStore.popFromPreLayout(oldChangeViewHolder);
                    this.mViewInfoStore.addToPostLayout(holder, animationInfo);
                    ItemAnimator.ItemHolderInfo postInfo = this.mViewInfoStore.popFromPostLayout(holder);
                    if (preInfo == null) {
                        this.handleMissingPreInfoForChangeError(key, holder, oldChangeViewHolder);
                        continue;
                    }
                    this.animateChange(oldChangeViewHolder, holder, preInfo, postInfo, oldDisappearing, newDisappearing);
                    continue;
                }
                this.mViewInfoStore.addToPostLayout(holder, animationInfo);
            }
            this.mViewInfoStore.process(this.mViewInfoProcessCallback);
        }
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        this.mState.mPreviousLayoutItemCount = this.mState.mItemCount;
        this.mDataSetHasChangedAfterLayout = false;
        this.mState.mRunSimpleAnimations = false;
        this.mState.mRunPredictiveAnimations = false;
        this.mLayout.mRequestedSimpleAnimations = false;
        if (this.mRecycler.mChangedScrap != null) {
            this.mRecycler.mChangedScrap.clear();
        }
        if (this.mLayout.mPrefetchMaxObservedInInitialPrefetch) {
            this.mLayout.mPrefetchMaxCountObserved = 0;
            this.mLayout.mPrefetchMaxObservedInInitialPrefetch = false;
            this.mRecycler.updateViewCacheSize();
        }
        this.mLayout.onLayoutCompleted(this.mState);
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
        this.mViewInfoStore.clear();
        if (this.didChildRangeChange(this.mMinMaxLayoutPositions[0], this.mMinMaxLayoutPositions[1])) {
            this.dispatchOnScrolled(0, 0);
        }
        this.recoverFocusFromState();
        this.resetFocusInfo();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$handleMissingPreInfoForChangeError(long key, ViewHolder holder, ViewHolder oldChangeViewHolder) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            long otherKey;
            View view = this.mChildHelper.getChildAt(i);
            ViewHolder other = RecyclerView.getChildViewHolderInt(view);
            if (other == holder || (otherKey = this.getChangedHolderKey(other)) != key) continue;
            if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
                throw new IllegalStateException("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:" + other + " \n View Holder 2:" + holder);
            }
            throw new IllegalStateException("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:" + other + " \n View Holder 2:" + holder);
        }
        Log.e("RecyclerView", "Problem while matching changed view holders with the newones. The pre-layout information for the change holder " + oldChangeViewHolder + " cannot be found but it is necessary for " + holder);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$recordAnimationInfoIfBouncedHiddenView(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo animationInfo) {
        viewHolder.setFlags(0, 8192);
        if (this.mState.mTrackOldChangeHolders && viewHolder.isUpdated() && !viewHolder.isRemoved() && !viewHolder.shouldIgnore()) {
            long key = this.getChangedHolderKey(viewHolder);
            this.mViewInfoStore.addToOldChangeHolders(key, viewHolder);
        }
        this.mViewInfoStore.addToPreLayout(viewHolder, animationInfo);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$findMinMaxChildLayoutPositions(int[] into) {
        int count = this.mChildHelper.getChildCount();
        if (count == 0) {
            into[0] = -1;
            into[1] = -1;
            return;
        }
        int minPositionPreLayout = Integer.MAX_VALUE;
        int maxPositionPreLayout = Integer.MIN_VALUE;
        for (int i = 0; i < count; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder.shouldIgnore()) continue;
            int pos = holder.getLayoutPosition();
            if (pos < minPositionPreLayout) {
                minPositionPreLayout = pos;
            }
            if (pos <= maxPositionPreLayout) continue;
            maxPositionPreLayout = pos;
        }
        into[0] = minPositionPreLayout;
        into[1] = maxPositionPreLayout;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$didChildRangeChange(int minPositionPreLayout, int maxPositionPreLayout) {
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        return this.mMinMaxLayoutPositions[0] != minPositionPreLayout || this.mMinMaxLayoutPositions[1] != maxPositionPreLayout;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$removeDetachedView(View child, boolean animate) {
        ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
        if (vh != null) {
            if (vh.isTmpDetached()) {
                vh.clearTmpDetachFlag();
            } else if (!vh.shouldIgnore()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + vh);
            }
        }
        this.dispatchChildDetached(child);
        super.removeDetachedView(child, animate);
    }

    private final long $$robo$$com_android_internal_widget_RecyclerView$getChangedHolderKey(ViewHolder holder) {
        return this.mAdapter.hasStableIds() ? holder.getItemId() : (long)holder.mPosition;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$animateAppearance(ViewHolder itemHolder, ItemAnimator.ItemHolderInfo preLayoutInfo, ItemAnimator.ItemHolderInfo postLayoutInfo) {
        itemHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateAppearance(itemHolder, preLayoutInfo, postLayoutInfo)) {
            this.postAnimationRunner();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$animateDisappearance(ViewHolder holder, ItemAnimator.ItemHolderInfo preLayoutInfo, ItemAnimator.ItemHolderInfo postLayoutInfo) {
        this.addAnimatingView(holder);
        holder.setIsRecyclable(false);
        if (this.mItemAnimator.animateDisappearance(holder, preLayoutInfo, postLayoutInfo)) {
            this.postAnimationRunner();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$animateChange(ViewHolder oldHolder, ViewHolder newHolder, ItemAnimator.ItemHolderInfo preInfo, ItemAnimator.ItemHolderInfo postInfo, boolean oldHolderDisappearing, boolean newHolderDisappearing) {
        oldHolder.setIsRecyclable(false);
        if (oldHolderDisappearing) {
            this.addAnimatingView(oldHolder);
        }
        if (oldHolder != newHolder) {
            if (newHolderDisappearing) {
                this.addAnimatingView(newHolder);
            }
            oldHolder.mShadowedHolder = newHolder;
            this.addAnimatingView(oldHolder);
            this.mRecycler.unscrapView(oldHolder);
            newHolder.setIsRecyclable(false);
            newHolder.mShadowingHolder = oldHolder;
        }
        if (this.mItemAnimator.animateChange(oldHolder, newHolder, preInfo, postInfo)) {
            this.postAnimationRunner();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onLayout(boolean changed, int l, int t, int r, int b) {
        Trace.beginSection("RV OnLayout");
        this.dispatchLayout();
        Trace.endSection();
        this.mFirstLayoutComplete = true;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$requestLayout() {
        if (this.mEatRequestLayout == 0 && !this.mLayoutFrozen) {
            super.requestLayout();
        } else {
            this.mLayoutRequestEaten = true;
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$markItemDecorInsetsDirty() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.markItemDecorInsetsDirty();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$draw(Canvas c) {
        int restore;
        super.draw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDrawOver(c, this, this.mState);
        }
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished()) {
            restore = c.save();
            int padding = this.mClipToPadding ? this.getPaddingBottom() : 0;
            c.rotate(270.0f);
            c.translate(-this.getHeight() + padding, 0.0f);
            needsInvalidate = this.mLeftGlow != null && this.mLeftGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished()) {
            restore = c.save();
            if (this.mClipToPadding) {
                c.translate(this.getPaddingLeft(), this.getPaddingTop());
            }
            needsInvalidate |= this.mTopGlow != null && this.mTopGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished()) {
            restore = c.save();
            int width = this.getWidth();
            int padding = this.mClipToPadding ? this.getPaddingTop() : 0;
            c.rotate(90.0f);
            c.translate(-padding, -width);
            needsInvalidate |= this.mRightGlow != null && this.mRightGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished()) {
            restore = c.save();
            c.rotate(180.0f);
            if (this.mClipToPadding) {
                c.translate(-this.getWidth() + this.getPaddingRight(), -this.getHeight() + this.getPaddingBottom());
            } else {
                c.translate(-this.getWidth(), -this.getHeight());
            }
            needsInvalidate |= this.mBottomGlow != null && this.mBottomGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (!needsInvalidate && this.mItemAnimator != null && this.mItemDecorations.size() > 0 && this.mItemAnimator.isRunning()) {
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onDraw(Canvas c) {
        super.onDraw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDraw(c, this, this.mState);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && this.mLayout.checkLayoutParams((LayoutParams)p);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_RecyclerView$generateDefaultLayoutParams() {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateDefaultLayoutParams();
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_RecyclerView$generateLayoutParams(AttributeSet attrs) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(this.getContext(), attrs);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_RecyclerView$generateLayoutParams(ViewGroup.LayoutParams p) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(p);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$isAnimating() {
        return this.mItemAnimator != null && this.mItemAnimator.isRunning();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$saveOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.saveOldPosition();
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$clearOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForMove(int from, int to) {
        int inBetweenOffset;
        int end;
        int start;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        if (from < to) {
            start = from;
            end = to;
            inBetweenOffset = -1;
        } else {
            start = to;
            end = from;
            inBetweenOffset = 1;
        }
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
            if (holder.mPosition == from) {
                holder.offsetPosition(to - from, false);
            } else {
                holder.offsetPosition(inBetweenOffset, false);
            }
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForMove(from, to);
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForInsert(int positionStart, int itemCount) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart) continue;
            holder.offsetPosition(itemCount, false);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForInsert(positionStart, itemCount);
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForRemove(int positionStart, int itemCount, boolean applyToPreLayout) {
        int positionEnd = positionStart + itemCount;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            if (holder.mPosition >= positionEnd) {
                holder.offsetPosition(-itemCount, applyToPreLayout);
                this.mState.mStructureChanged = true;
                continue;
            }
            if (holder.mPosition < positionStart) continue;
            holder.flagRemovedAndOffsetPosition(positionStart - 1, -itemCount, applyToPreLayout);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForRemove(positionStart, itemCount, applyToPreLayout);
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$viewRangeUpdate(int positionStart, int itemCount, Object payload) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        int positionEnd = positionStart + itemCount;
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart || holder.mPosition >= positionEnd) continue;
            holder.addFlags(2);
            holder.addChangePayload(payload);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.viewRangeUpdate(positionStart, itemCount);
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$canReuseUpdatedViewHolder(ViewHolder viewHolder) {
        return this.mItemAnimator == null || this.mItemAnimator.canReuseUpdatedViewHolder(viewHolder, viewHolder.getUnmodifiedPayloads());
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setDataSetChangedAfterLayout() {
        if (this.mDataSetHasChangedAfterLayout) {
            return;
        }
        this.mDataSetHasChangedAfterLayout = true;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            holder.addFlags(512);
        }
        this.mRecycler.setAdapterPositionsAsUnknown();
        this.markKnownViewsInvalid();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$markKnownViewsInvalid() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            holder.addFlags(6);
        }
        this.markItemDecorInsetsDirty();
        this.mRecycler.markKnownViewsInvalid();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$getPreserveFocusAfterLayout() {
        return this.mPreserveFocusAfterLayout;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$setPreserveFocusAfterLayout(boolean preserveFocusAfterLayout) {
        this.mPreserveFocusAfterLayout = preserveFocusAfterLayout;
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$getChildViewHolder(View child) {
        ViewParent parent = child.getParent();
        if (parent != null && parent != this) {
            throw new IllegalArgumentException("View " + child + " is not a direct child of " + this);
        }
        return RecyclerView.getChildViewHolderInt(child);
    }

    private final View $$robo$$com_android_internal_widget_RecyclerView$findContainingItemView(View view) {
        ViewParent parent = view.getParent();
        while (parent != null && parent != this && parent instanceof View) {
            view = (View)((Object)parent);
            parent = view.getParent();
        }
        return parent == this ? view : null;
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findContainingViewHolder(View view) {
        View itemView = this.findContainingItemView(view);
        return itemView == null ? null : this.getChildViewHolder(itemView);
    }

    private static final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$getChildViewHolderInt(View child) {
        if (child == null) {
            return null;
        }
        return ((LayoutParams)child.getLayoutParams()).mViewHolder;
    }

    @Deprecated
    private final int $$robo$$com_android_internal_widget_RecyclerView$getChildPosition(View child) {
        return this.getChildAdapterPosition(child);
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getChildAdapterPosition(View child) {
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getAdapterPosition() : -1;
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getChildLayoutPosition(View child) {
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getLayoutPosition() : -1;
    }

    private final long $$robo$$com_android_internal_widget_RecyclerView$getChildItemId(View child) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return -1L;
        }
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getItemId() : -1L;
    }

    @Deprecated
    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForLayoutPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForAdapterPosition(int position) {
        if (this.mDataSetHasChangedAfterLayout) {
            return null;
        }
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || this.getAdapterPositionFor(holder) != position) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForPosition(int position, boolean checkNewPosition) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || (!checkNewPosition ? holder.getLayoutPosition() != position : holder.mPosition != position)) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForItemId(long id2) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return null;
        }
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || holder.getItemId() != id2) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    private final View $$robo$$com_android_internal_widget_RecyclerView$findChildViewUnder(float x, float y) {
        int count = this.mChildHelper.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.mChildHelper.getChildAt(i);
            float translationX = child.getTranslationX();
            float translationY = child.getTranslationY();
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$offsetChildrenVertical(int dy) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetTopAndBottom(dy);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onChildAttachedToWindow(View child) {
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onChildDetachedFromWindow(View child) {
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$offsetChildrenHorizontal(int dx) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetLeftAndRight(dx);
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$getDecoratedBoundsWithMargins(View view, Rect outBounds) {
        RecyclerView.getDecoratedBoundsWithMarginsInt(view, outBounds);
    }

    private static final void $$robo$$com_android_internal_widget_RecyclerView$getDecoratedBoundsWithMarginsInt(View view, Rect outBounds) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        Rect insets = lp.mDecorInsets;
        outBounds.set(view.getLeft() - insets.left - lp.leftMargin, view.getTop() - insets.top - lp.topMargin, view.getRight() + insets.right + lp.rightMargin, view.getBottom() + insets.bottom + lp.bottomMargin);
    }

    private final Rect $$robo$$com_android_internal_widget_RecyclerView$getItemDecorInsetsForChild(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (!lp.mInsetsDirty) {
            return lp.mDecorInsets;
        }
        if (this.mState.isPreLayout() && (lp.isItemChanged() || lp.isViewInvalid())) {
            return lp.mDecorInsets;
        }
        Rect insets = lp.mDecorInsets;
        insets.set(0, 0, 0, 0);
        int decorCount = this.mItemDecorations.size();
        for (int i = 0; i < decorCount; ++i) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i).getItemOffsets(this.mTempRect, child, this, this.mState);
            insets.left += this.mTempRect.left;
            insets.top += this.mTempRect.top;
            insets.right += this.mTempRect.right;
            insets.bottom += this.mTempRect.bottom;
        }
        lp.mInsetsDirty = false;
        return insets;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onScrolled(int dx, int dy) {
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchOnScrolled(int hresult, int vresult) {
        ++this.mDispatchScrollCounter;
        int scrollX = this.getScrollX();
        int scrollY = this.getScrollY();
        this.onScrollChanged(scrollX, scrollY, scrollX, scrollY);
        this.onScrolled(hresult, vresult);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolled(this, hresult, vresult);
        }
        if (this.mScrollListeners != null) {
            for (int i = this.mScrollListeners.size() - 1; i >= 0; --i) {
                this.mScrollListeners.get(i).onScrolled(this, hresult, vresult);
            }
        }
        --this.mDispatchScrollCounter;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$onScrollStateChanged(int state) {
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchOnScrollStateChanged(int state) {
        if (this.mLayout != null) {
            this.mLayout.onScrollStateChanged(state);
        }
        this.onScrollStateChanged(state);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(this, state);
        }
        if (this.mScrollListeners != null) {
            for (int i = this.mScrollListeners.size() - 1; i >= 0; --i) {
                this.mScrollListeners.get(i).onScrollStateChanged(this, state);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RecyclerView$hasPendingAdapterUpdates() {
        return !this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout || this.mAdapterHelper.hasPendingUpdates();
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$repositionShadowingViews() {
        int count = this.mChildHelper.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mChildHelper.getChildAt(i);
            ViewHolder holder = this.getChildViewHolder(view);
            if (holder == null || holder.mShadowingHolder == null) continue;
            View shadowingView = holder.mShadowingHolder.itemView;
            int left = view.getLeft();
            int top = view.getTop();
            if (left == shadowingView.getLeft() && top == shadowingView.getTop()) continue;
            shadowingView.layout(left, top, left + shadowingView.getWidth(), top + shadowingView.getHeight());
        }
    }

    private static final RecyclerView $$robo$$com_android_internal_widget_RecyclerView$findNestedRecyclerView(View view) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        if (view instanceof RecyclerView) {
            return (RecyclerView)view;
        }
        ViewGroup parent = (ViewGroup)view;
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView descendant = RecyclerView.findNestedRecyclerView(child);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    private static final void $$robo$$com_android_internal_widget_RecyclerView$clearNestedRecyclerViewIfNotNested(ViewHolder holder) {
        if (holder.mNestedRecyclerView != null) {
            View item = (View)holder.mNestedRecyclerView.get();
            while (item != null) {
                if (item == holder.itemView) {
                    return;
                }
                ViewParent parent = item.getParent();
                if (parent instanceof View) {
                    item = (View)((Object)parent);
                    continue;
                }
                item = null;
            }
            holder.mNestedRecyclerView = null;
        }
    }

    private final long $$robo$$com_android_internal_widget_RecyclerView$getNanoTime() {
        if (ALLOW_THREAD_GAP_WORK) {
            return (long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        }
        return 0L;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchChildDetached(View child) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
        this.onChildDetachedFromWindow(child);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewDetachedFromWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            int cnt = this.mOnChildAttachStateListeners.size();
            for (int i = cnt - 1; i >= 0; --i) {
                this.mOnChildAttachStateListeners.get(i).onChildViewDetachedFromWindow(child);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchChildAttached(View child) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
        this.onChildAttachedToWindow(child);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewAttachedToWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            int cnt = this.mOnChildAttachStateListeners.size();
            for (int i = cnt - 1; i >= 0; --i) {
                this.mOnChildAttachStateListeners.get(i).onChildViewAttachedToWindow(child);
            }
        }
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_widget_RecyclerView$setChildImportantForAccessibilityInternal(ViewHolder viewHolder, int importantForAccessibility) {
        if (this.isComputingLayout()) {
            viewHolder.mPendingAccessibilityState = importantForAccessibility;
            this.mPendingAccessibilityImportanceChange.add(viewHolder);
            return false;
        }
        viewHolder.itemView.setImportantForAccessibility(importantForAccessibility);
        return true;
    }

    private final void $$robo$$com_android_internal_widget_RecyclerView$dispatchPendingImportantForAccessibilityChanges() {
        for (int i = this.mPendingAccessibilityImportanceChange.size() - 1; i >= 0; --i) {
            int state;
            ViewHolder viewHolder = this.mPendingAccessibilityImportanceChange.get(i);
            if (viewHolder.itemView.getParent() != this || viewHolder.shouldIgnore() || (state = viewHolder.mPendingAccessibilityState) == -1) continue;
            viewHolder.itemView.setImportantForAccessibility(state);
            viewHolder.mPendingAccessibilityState = -1;
        }
        this.mPendingAccessibilityImportanceChange.clear();
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getAdapterPositionFor(ViewHolder viewHolder) {
        if (viewHolder.hasAnyOfTheFlags(524) || !viewHolder.isBound()) {
            return -1;
        }
        return this.mAdapterHelper.applyPendingUpdatesToPosition(viewHolder.mPosition);
    }

    private final int $$robo$$com_android_internal_widget_RecyclerView$getChildDrawingOrder(int childCount, int i) {
        if (this.mChildDrawingOrderCallback == null) {
            return super.getChildDrawingOrder(childCount, i);
        }
        return this.mChildDrawingOrderCallback.onGetChildDrawingOrder(childCount, i);
    }

    static void __staticInitializer__() {
        NESTED_SCROLLING_ATTRS = new int[]{16843830};
        CLIP_TO_PADDING_ATTR = new int[]{16842987};
        FORCE_INVALIDATE_DISPLAY_LIST = Build.VERSION.SDK_INT == 18 || Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 20;
        ALLOW_SIZE_IN_UNSPECIFIED_SPEC = Build.VERSION.SDK_INT >= 23;
        POST_UPDATES_ON_ANIMATION = Build.VERSION.SDK_INT >= 16;
        ALLOW_THREAD_GAP_WORK = Build.VERSION.SDK_INT >= 21;
        FORCE_ABS_FOCUS_SEARCH_DIRECTION = Build.VERSION.SDK_INT <= 15;
        IGNORE_DETACHED_FOCUSED_CHILD = Build.VERSION.SDK_INT <= 15;
        LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
        sQuinticInterpolator = new Interpolator(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_widget_RecyclerView_3$__constructor__() {
            }

            private final float $$robo$$com_android_internal_widget_RecyclerView_3$getInterpolation(float t) {
                return (t -= 1.0f) * t * t * t * t + 1.0f;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_RecyclerView_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_3$__constructor__(), this);
            }

            @Override
            public float getInterpolation(float f) {
                return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$com_android_internal_widget_RecyclerView_3$getInterpolation(float ), this, f);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_RecyclerView$__constructor__(context);
    }

    public RecyclerView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_RecyclerView$__constructor__(context, attributeSet);
    }

    public RecyclerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_RecyclerView$__constructor__(context, attributeSet, n);
    }

    public RecyclerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    public RecyclerViewAccessibilityDelegate getCompatAccessibilityDelegate() {
        return InvokeDynamicSupport.bootstrap("getCompatAccessibilityDelegate", $$robo$$com_android_internal_widget_RecyclerView$getCompatAccessibilityDelegate(), this);
    }

    public void setAccessibilityDelegateCompat(RecyclerViewAccessibilityDelegate recyclerViewAccessibilityDelegate) {
        InvokeDynamicSupport.bootstrap("setAccessibilityDelegateCompat", $$robo$$com_android_internal_widget_RecyclerView$setAccessibilityDelegateCompat(com.android.internal.widget.RecyclerViewAccessibilityDelegate ), this, recyclerViewAccessibilityDelegate);
    }

    private void createLayoutManager(Context context, String string2, AttributeSet attributeSet, int n, int n2) {
        InvokeDynamicSupport.bootstrap("createLayoutManager", $$robo$$com_android_internal_widget_RecyclerView$createLayoutManager(android.content.Context java.lang.String android.util.AttributeSet int int ), this, context, string2, attributeSet, n, n2);
    }

    private String getFullClassName(Context context, String string2) {
        return InvokeDynamicSupport.bootstrap("getFullClassName", $$robo$$com_android_internal_widget_RecyclerView$getFullClassName(android.content.Context java.lang.String ), this, context, string2);
    }

    private void initChildrenHelper() {
        InvokeDynamicSupport.bootstrap("initChildrenHelper", $$robo$$com_android_internal_widget_RecyclerView$initChildrenHelper(), this);
    }

    void initAdapterManager() {
        InvokeDynamicSupport.bootstrap("initAdapterManager", $$robo$$com_android_internal_widget_RecyclerView$initAdapterManager(), this);
    }

    public void setHasFixedSize(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasFixedSize", $$robo$$com_android_internal_widget_RecyclerView$setHasFixedSize(boolean ), this, bl);
    }

    public boolean hasFixedSize() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFixedSize", $$robo$$com_android_internal_widget_RecyclerView$hasFixedSize(), this);
    }

    @Override
    public void setClipToPadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipToPadding", $$robo$$com_android_internal_widget_RecyclerView$setClipToPadding(boolean ), this, bl);
    }

    @Override
    public boolean getClipToPadding() {
        return (boolean)InvokeDynamicSupport.bootstrap("getClipToPadding", $$robo$$com_android_internal_widget_RecyclerView$getClipToPadding(), this);
    }

    public void setScrollingTouchSlop(int n) {
        InvokeDynamicSupport.bootstrap("setScrollingTouchSlop", $$robo$$com_android_internal_widget_RecyclerView$setScrollingTouchSlop(int ), this, n);
    }

    public void swapAdapter(Adapter adapter, boolean bl) {
        InvokeDynamicSupport.bootstrap("swapAdapter", $$robo$$com_android_internal_widget_RecyclerView$swapAdapter(com.android.internal.widget.RecyclerView$Adapter boolean ), this, adapter, bl);
    }

    public void setAdapter(Adapter adapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$com_android_internal_widget_RecyclerView$setAdapter(com.android.internal.widget.RecyclerView$Adapter ), this, adapter);
    }

    void removeAndRecycleViews() {
        InvokeDynamicSupport.bootstrap("removeAndRecycleViews", $$robo$$com_android_internal_widget_RecyclerView$removeAndRecycleViews(), this);
    }

    private void setAdapterInternal(Adapter adapter, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setAdapterInternal", $$robo$$com_android_internal_widget_RecyclerView$setAdapterInternal(com.android.internal.widget.RecyclerView$Adapter boolean boolean ), this, adapter, bl, bl2);
    }

    public Adapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$com_android_internal_widget_RecyclerView$getAdapter(), this);
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        InvokeDynamicSupport.bootstrap("setRecyclerListener", $$robo$$com_android_internal_widget_RecyclerView$setRecyclerListener(com.android.internal.widget.RecyclerView$RecyclerListener ), this, recyclerListener);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$com_android_internal_widget_RecyclerView$getBaseline(), this);
    }

    public void addOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        InvokeDynamicSupport.bootstrap("addOnChildAttachStateChangeListener", $$robo$$com_android_internal_widget_RecyclerView$addOnChildAttachStateChangeListener(com.android.internal.widget.RecyclerView$OnChildAttachStateChangeListener ), this, onChildAttachStateChangeListener);
    }

    public void removeOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        InvokeDynamicSupport.bootstrap("removeOnChildAttachStateChangeListener", $$robo$$com_android_internal_widget_RecyclerView$removeOnChildAttachStateChangeListener(com.android.internal.widget.RecyclerView$OnChildAttachStateChangeListener ), this, onChildAttachStateChangeListener);
    }

    public void clearOnChildAttachStateChangeListeners() {
        InvokeDynamicSupport.bootstrap("clearOnChildAttachStateChangeListeners", $$robo$$com_android_internal_widget_RecyclerView$clearOnChildAttachStateChangeListeners(), this);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        InvokeDynamicSupport.bootstrap("setLayoutManager", $$robo$$com_android_internal_widget_RecyclerView$setLayoutManager(com.android.internal.widget.RecyclerView$LayoutManager ), this, layoutManager);
    }

    public void setOnFlingListener(OnFlingListener onFlingListener) {
        InvokeDynamicSupport.bootstrap("setOnFlingListener", $$robo$$com_android_internal_widget_RecyclerView$setOnFlingListener(com.android.internal.widget.RecyclerView$OnFlingListener ), this, onFlingListener);
    }

    public OnFlingListener getOnFlingListener() {
        return InvokeDynamicSupport.bootstrap("getOnFlingListener", $$robo$$com_android_internal_widget_RecyclerView$getOnFlingListener(), this);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_widget_RecyclerView$onSaveInstanceState(), this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_widget_RecyclerView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$com_android_internal_widget_RecyclerView$dispatchSaveInstanceState(android.util.SparseArray<android.os.Parcelable> ), this, sparseArray);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$com_android_internal_widget_RecyclerView$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), this, sparseArray);
    }

    private void addAnimatingView(ViewHolder viewHolder) {
        InvokeDynamicSupport.bootstrap("addAnimatingView", $$robo$$com_android_internal_widget_RecyclerView$addAnimatingView(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
    }

    boolean removeAnimatingView(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAnimatingView", $$robo$$com_android_internal_widget_RecyclerView$removeAnimatingView(android.view.View ), this, view);
    }

    public LayoutManager getLayoutManager() {
        return InvokeDynamicSupport.bootstrap("getLayoutManager", $$robo$$com_android_internal_widget_RecyclerView$getLayoutManager(), this);
    }

    public RecycledViewPool getRecycledViewPool() {
        return InvokeDynamicSupport.bootstrap("getRecycledViewPool", $$robo$$com_android_internal_widget_RecyclerView$getRecycledViewPool(), this);
    }

    public void setRecycledViewPool(RecycledViewPool recycledViewPool) {
        InvokeDynamicSupport.bootstrap("setRecycledViewPool", $$robo$$com_android_internal_widget_RecyclerView$setRecycledViewPool(com.android.internal.widget.RecyclerView$RecycledViewPool ), this, recycledViewPool);
    }

    public void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
        InvokeDynamicSupport.bootstrap("setViewCacheExtension", $$robo$$com_android_internal_widget_RecyclerView$setViewCacheExtension(com.android.internal.widget.RecyclerView$ViewCacheExtension ), this, viewCacheExtension);
    }

    public void setItemViewCacheSize(int n) {
        InvokeDynamicSupport.bootstrap("setItemViewCacheSize", $$robo$$com_android_internal_widget_RecyclerView$setItemViewCacheSize(int ), this, n);
    }

    public int getScrollState() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollState", $$robo$$com_android_internal_widget_RecyclerView$getScrollState(), this);
    }

    void setScrollState(int n) {
        InvokeDynamicSupport.bootstrap("setScrollState", $$robo$$com_android_internal_widget_RecyclerView$setScrollState(int ), this, n);
    }

    public void addItemDecoration(ItemDecoration itemDecoration, int n) {
        InvokeDynamicSupport.bootstrap("addItemDecoration", $$robo$$com_android_internal_widget_RecyclerView$addItemDecoration(com.android.internal.widget.RecyclerView$ItemDecoration int ), this, itemDecoration, n);
    }

    public void addItemDecoration(ItemDecoration itemDecoration) {
        InvokeDynamicSupport.bootstrap("addItemDecoration", $$robo$$com_android_internal_widget_RecyclerView$addItemDecoration(com.android.internal.widget.RecyclerView$ItemDecoration ), this, itemDecoration);
    }

    public void removeItemDecoration(ItemDecoration itemDecoration) {
        InvokeDynamicSupport.bootstrap("removeItemDecoration", $$robo$$com_android_internal_widget_RecyclerView$removeItemDecoration(com.android.internal.widget.RecyclerView$ItemDecoration ), this, itemDecoration);
    }

    public void setChildDrawingOrderCallback(ChildDrawingOrderCallback childDrawingOrderCallback) {
        InvokeDynamicSupport.bootstrap("setChildDrawingOrderCallback", $$robo$$com_android_internal_widget_RecyclerView$setChildDrawingOrderCallback(com.android.internal.widget.RecyclerView$ChildDrawingOrderCallback ), this, childDrawingOrderCallback);
    }

    @Deprecated
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        InvokeDynamicSupport.bootstrap("setOnScrollListener", $$robo$$com_android_internal_widget_RecyclerView$setOnScrollListener(com.android.internal.widget.RecyclerView$OnScrollListener ), this, onScrollListener);
    }

    public void addOnScrollListener(OnScrollListener onScrollListener) {
        InvokeDynamicSupport.bootstrap("addOnScrollListener", $$robo$$com_android_internal_widget_RecyclerView$addOnScrollListener(com.android.internal.widget.RecyclerView$OnScrollListener ), this, onScrollListener);
    }

    public void removeOnScrollListener(OnScrollListener onScrollListener) {
        InvokeDynamicSupport.bootstrap("removeOnScrollListener", $$robo$$com_android_internal_widget_RecyclerView$removeOnScrollListener(com.android.internal.widget.RecyclerView$OnScrollListener ), this, onScrollListener);
    }

    public void clearOnScrollListeners() {
        InvokeDynamicSupport.bootstrap("clearOnScrollListeners", $$robo$$com_android_internal_widget_RecyclerView$clearOnScrollListeners(), this);
    }

    public void scrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("scrollToPosition", $$robo$$com_android_internal_widget_RecyclerView$scrollToPosition(int ), this, n);
    }

    void jumpToPositionForSmoothScroller(int n) {
        InvokeDynamicSupport.bootstrap("jumpToPositionForSmoothScroller", $$robo$$com_android_internal_widget_RecyclerView$jumpToPositionForSmoothScroller(int ), this, n);
    }

    public void smoothScrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$com_android_internal_widget_RecyclerView$smoothScrollToPosition(int ), this, n);
    }

    @Override
    public void scrollTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollTo", $$robo$$com_android_internal_widget_RecyclerView$scrollTo(int int ), this, n, n2);
    }

    @Override
    public void scrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollBy", $$robo$$com_android_internal_widget_RecyclerView$scrollBy(int int ), this, n, n2);
    }

    void consumePendingUpdateOperations() {
        InvokeDynamicSupport.bootstrap("consumePendingUpdateOperations", $$robo$$com_android_internal_widget_RecyclerView$consumePendingUpdateOperations(), this);
    }

    private boolean hasUpdatedView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUpdatedView", $$robo$$com_android_internal_widget_RecyclerView$hasUpdatedView(), this);
    }

    boolean scrollByInternal(int n, int n2, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollByInternal", $$robo$$com_android_internal_widget_RecyclerView$scrollByInternal(int int android.view.MotionEvent ), this, n, n2, motionEvent);
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollOffset", $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollOffset(), this);
    }

    @Override
    public int computeHorizontalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollExtent", $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollExtent(), this);
    }

    @Override
    public int computeHorizontalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$com_android_internal_widget_RecyclerView$computeHorizontalScrollRange(), this);
    }

    @Override
    public int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollOffset(), this);
    }

    @Override
    public int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollExtent(), this);
    }

    @Override
    public int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$com_android_internal_widget_RecyclerView$computeVerticalScrollRange(), this);
    }

    void eatRequestLayout() {
        InvokeDynamicSupport.bootstrap("eatRequestLayout", $$robo$$com_android_internal_widget_RecyclerView$eatRequestLayout(), this);
    }

    void resumeRequestLayout(boolean bl) {
        InvokeDynamicSupport.bootstrap("resumeRequestLayout", $$robo$$com_android_internal_widget_RecyclerView$resumeRequestLayout(boolean ), this, bl);
    }

    public void setLayoutFrozen(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutFrozen", $$robo$$com_android_internal_widget_RecyclerView$setLayoutFrozen(boolean ), this, bl);
    }

    public boolean isLayoutFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutFrozen", $$robo$$com_android_internal_widget_RecyclerView$isLayoutFrozen(), this);
    }

    public void smoothScrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView$smoothScrollBy(int int ), this, n, n2);
    }

    public void smoothScrollBy(int n, int n2, Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView$smoothScrollBy(int int android.view.animation.Interpolator ), this, n, n2, interpolator2);
    }

    public boolean fling(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("fling", $$robo$$com_android_internal_widget_RecyclerView$fling(int int ), this, n, n2);
    }

    public void stopScroll() {
        InvokeDynamicSupport.bootstrap("stopScroll", $$robo$$com_android_internal_widget_RecyclerView$stopScroll(), this);
    }

    private void stopScrollersInternal() {
        InvokeDynamicSupport.bootstrap("stopScrollersInternal", $$robo$$com_android_internal_widget_RecyclerView$stopScrollersInternal(), this);
    }

    public int getMinFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrap("getMinFlingVelocity", $$robo$$com_android_internal_widget_RecyclerView$getMinFlingVelocity(), this);
    }

    public int getMaxFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxFlingVelocity", $$robo$$com_android_internal_widget_RecyclerView$getMaxFlingVelocity(), this);
    }

    private void pullGlows(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("pullGlows", $$robo$$com_android_internal_widget_RecyclerView$pullGlows(float float float float ), this, f, f2, f3, f4);
    }

    private void releaseGlows() {
        InvokeDynamicSupport.bootstrap("releaseGlows", $$robo$$com_android_internal_widget_RecyclerView$releaseGlows(), this);
    }

    void considerReleasingGlowsOnScroll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("considerReleasingGlowsOnScroll", $$robo$$com_android_internal_widget_RecyclerView$considerReleasingGlowsOnScroll(int int ), this, n, n2);
    }

    void absorbGlows(int n, int n2) {
        InvokeDynamicSupport.bootstrap("absorbGlows", $$robo$$com_android_internal_widget_RecyclerView$absorbGlows(int int ), this, n, n2);
    }

    void ensureLeftGlow() {
        InvokeDynamicSupport.bootstrap("ensureLeftGlow", $$robo$$com_android_internal_widget_RecyclerView$ensureLeftGlow(), this);
    }

    void ensureRightGlow() {
        InvokeDynamicSupport.bootstrap("ensureRightGlow", $$robo$$com_android_internal_widget_RecyclerView$ensureRightGlow(), this);
    }

    void ensureTopGlow() {
        InvokeDynamicSupport.bootstrap("ensureTopGlow", $$robo$$com_android_internal_widget_RecyclerView$ensureTopGlow(), this);
    }

    void ensureBottomGlow() {
        InvokeDynamicSupport.bootstrap("ensureBottomGlow", $$robo$$com_android_internal_widget_RecyclerView$ensureBottomGlow(), this);
    }

    void invalidateGlows() {
        InvokeDynamicSupport.bootstrap("invalidateGlows", $$robo$$com_android_internal_widget_RecyclerView$invalidateGlows(), this);
    }

    @Override
    public View focusSearch(View view, int n) {
        return InvokeDynamicSupport.bootstrap("focusSearch", $$robo$$com_android_internal_widget_RecyclerView$focusSearch(android.view.View int ), this, view, n);
    }

    private boolean isPreferredNextFocus(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreferredNextFocus", $$robo$$com_android_internal_widget_RecyclerView$isPreferredNextFocus(android.view.View android.view.View int ), this, view, view2, n);
    }

    private boolean isPreferredNextFocusAbsolute(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreferredNextFocusAbsolute", $$robo$$com_android_internal_widget_RecyclerView$isPreferredNextFocusAbsolute(android.view.View android.view.View int ), this, view, view2, n);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        InvokeDynamicSupport.bootstrap("requestChildFocus", $$robo$$com_android_internal_widget_RecyclerView$requestChildFocus(android.view.View android.view.View ), this, view, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$com_android_internal_widget_RecyclerView$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), this, view, rect, bl);
    }

    @Override
    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addFocusables", $$robo$$com_android_internal_widget_RecyclerView$addFocusables(java.util.ArrayList<android.view.View> int int ), this, arrayList, n, n2);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestFocusInDescendants", $$robo$$com_android_internal_widget_RecyclerView$onRequestFocusInDescendants(int android.graphics.Rect ), this, n, rect);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView$onDetachedFromWindow(), this);
    }

    @Override
    public boolean isAttachedToWindow() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView$isAttachedToWindow(), this);
    }

    void assertInLayoutOrScroll(String string2) {
        InvokeDynamicSupport.bootstrap("assertInLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView$assertInLayoutOrScroll(java.lang.String ), this, string2);
    }

    void assertNotInLayoutOrScroll(String string2) {
        InvokeDynamicSupport.bootstrap("assertNotInLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView$assertNotInLayoutOrScroll(java.lang.String ), this, string2);
    }

    public void addOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        InvokeDynamicSupport.bootstrap("addOnItemTouchListener", $$robo$$com_android_internal_widget_RecyclerView$addOnItemTouchListener(com.android.internal.widget.RecyclerView$OnItemTouchListener ), this, onItemTouchListener);
    }

    public void removeOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        InvokeDynamicSupport.bootstrap("removeOnItemTouchListener", $$robo$$com_android_internal_widget_RecyclerView$removeOnItemTouchListener(com.android.internal.widget.RecyclerView$OnItemTouchListener ), this, onItemTouchListener);
    }

    private boolean dispatchOnItemTouchIntercept(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchOnItemTouchIntercept", $$robo$$com_android_internal_widget_RecyclerView$dispatchOnItemTouchIntercept(android.view.MotionEvent ), this, motionEvent);
    }

    private boolean dispatchOnItemTouch(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchOnItemTouch", $$robo$$com_android_internal_widget_RecyclerView$dispatchOnItemTouch(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_RecyclerView$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        InvokeDynamicSupport.bootstrap("requestDisallowInterceptTouchEvent", $$robo$$com_android_internal_widget_RecyclerView$requestDisallowInterceptTouchEvent(boolean ), this, bl);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_RecyclerView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void resetTouch() {
        InvokeDynamicSupport.bootstrap("resetTouch", $$robo$$com_android_internal_widget_RecyclerView$resetTouch(), this);
    }

    private void cancelTouch() {
        InvokeDynamicSupport.bootstrap("cancelTouch", $$robo$$com_android_internal_widget_RecyclerView$cancelTouch(), this);
    }

    private void onPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onPointerUp", $$robo$$com_android_internal_widget_RecyclerView$onPointerUp(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$com_android_internal_widget_RecyclerView$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private float getScrollFactor() {
        return (float)InvokeDynamicSupport.bootstrap("getScrollFactor", $$robo$$com_android_internal_widget_RecyclerView$getScrollFactor(), this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_RecyclerView$onMeasure(int int ), this, n, n2);
    }

    void defaultOnMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("defaultOnMeasure", $$robo$$com_android_internal_widget_RecyclerView$defaultOnMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$com_android_internal_widget_RecyclerView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    public void setItemAnimator(ItemAnimator itemAnimator) {
        InvokeDynamicSupport.bootstrap("setItemAnimator", $$robo$$com_android_internal_widget_RecyclerView$setItemAnimator(com.android.internal.widget.RecyclerView$ItemAnimator ), this, itemAnimator);
    }

    void onEnterLayoutOrScroll() {
        InvokeDynamicSupport.bootstrap("onEnterLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView$onEnterLayoutOrScroll(), this);
    }

    void onExitLayoutOrScroll() {
        InvokeDynamicSupport.bootstrap("onExitLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView$onExitLayoutOrScroll(), this);
    }

    boolean isAccessibilityEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityEnabled", $$robo$$com_android_internal_widget_RecyclerView$isAccessibilityEnabled(), this);
    }

    private void dispatchContentChangedIfNecessary() {
        InvokeDynamicSupport.bootstrap("dispatchContentChangedIfNecessary", $$robo$$com_android_internal_widget_RecyclerView$dispatchContentChangedIfNecessary(), this);
    }

    public boolean isComputingLayout() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComputingLayout", $$robo$$com_android_internal_widget_RecyclerView$isComputingLayout(), this);
    }

    boolean shouldDeferAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDeferAccessibilityEvent", $$robo$$com_android_internal_widget_RecyclerView$shouldDeferAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventUnchecked", $$robo$$com_android_internal_widget_RecyclerView$sendAccessibilityEventUnchecked(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    public ItemAnimator getItemAnimator() {
        return InvokeDynamicSupport.bootstrap("getItemAnimator", $$robo$$com_android_internal_widget_RecyclerView$getItemAnimator(), this);
    }

    void postAnimationRunner() {
        InvokeDynamicSupport.bootstrap("postAnimationRunner", $$robo$$com_android_internal_widget_RecyclerView$postAnimationRunner(), this);
    }

    private boolean predictiveItemAnimationsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("predictiveItemAnimationsEnabled", $$robo$$com_android_internal_widget_RecyclerView$predictiveItemAnimationsEnabled(), this);
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        InvokeDynamicSupport.bootstrap("processAdapterUpdatesAndSetAnimationFlags", $$robo$$com_android_internal_widget_RecyclerView$processAdapterUpdatesAndSetAnimationFlags(), this);
    }

    void dispatchLayout() {
        InvokeDynamicSupport.bootstrap("dispatchLayout", $$robo$$com_android_internal_widget_RecyclerView$dispatchLayout(), this);
    }

    private void saveFocusInfo() {
        InvokeDynamicSupport.bootstrap("saveFocusInfo", $$robo$$com_android_internal_widget_RecyclerView$saveFocusInfo(), this);
    }

    private void resetFocusInfo() {
        InvokeDynamicSupport.bootstrap("resetFocusInfo", $$robo$$com_android_internal_widget_RecyclerView$resetFocusInfo(), this);
    }

    private View findNextViewToFocus() {
        return InvokeDynamicSupport.bootstrap("findNextViewToFocus", $$robo$$com_android_internal_widget_RecyclerView$findNextViewToFocus(), this);
    }

    private void recoverFocusFromState() {
        InvokeDynamicSupport.bootstrap("recoverFocusFromState", $$robo$$com_android_internal_widget_RecyclerView$recoverFocusFromState(), this);
    }

    private int getDeepestFocusedViewWithId(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getDeepestFocusedViewWithId", $$robo$$com_android_internal_widget_RecyclerView$getDeepestFocusedViewWithId(android.view.View ), this, view);
    }

    private void dispatchLayoutStep1() {
        InvokeDynamicSupport.bootstrap("dispatchLayoutStep1", $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep1(), this);
    }

    private void dispatchLayoutStep2() {
        InvokeDynamicSupport.bootstrap("dispatchLayoutStep2", $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep2(), this);
    }

    private void dispatchLayoutStep3() {
        InvokeDynamicSupport.bootstrap("dispatchLayoutStep3", $$robo$$com_android_internal_widget_RecyclerView$dispatchLayoutStep3(), this);
    }

    private void handleMissingPreInfoForChangeError(long l, ViewHolder viewHolder, ViewHolder viewHolder2) {
        InvokeDynamicSupport.bootstrap("handleMissingPreInfoForChangeError", $$robo$$com_android_internal_widget_RecyclerView$handleMissingPreInfoForChangeError(long com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ViewHolder ), this, l, viewHolder, viewHolder2);
    }

    void recordAnimationInfoIfBouncedHiddenView(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo) {
        InvokeDynamicSupport.bootstrap("recordAnimationInfoIfBouncedHiddenView", $$robo$$com_android_internal_widget_RecyclerView$recordAnimationInfoIfBouncedHiddenView(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo);
    }

    private void findMinMaxChildLayoutPositions(int[] nArray) {
        InvokeDynamicSupport.bootstrap("findMinMaxChildLayoutPositions", $$robo$$com_android_internal_widget_RecyclerView$findMinMaxChildLayoutPositions(int[] ), this, nArray);
    }

    private boolean didChildRangeChange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("didChildRangeChange", $$robo$$com_android_internal_widget_RecyclerView$didChildRangeChange(int int ), this, n, n2);
    }

    @Override
    protected void removeDetachedView(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeDetachedView", $$robo$$com_android_internal_widget_RecyclerView$removeDetachedView(android.view.View boolean ), this, view, bl);
    }

    long getChangedHolderKey(ViewHolder viewHolder) {
        return (long)InvokeDynamicSupport.bootstrap("getChangedHolderKey", $$robo$$com_android_internal_widget_RecyclerView$getChangedHolderKey(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
    }

    void animateAppearance(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        InvokeDynamicSupport.bootstrap("animateAppearance", $$robo$$com_android_internal_widget_RecyclerView$animateAppearance(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo, itemHolderInfo2);
    }

    void animateDisappearance(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        InvokeDynamicSupport.bootstrap("animateDisappearance", $$robo$$com_android_internal_widget_RecyclerView$animateDisappearance(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo ), this, viewHolder, itemHolderInfo, itemHolderInfo2);
    }

    private void animateChange(ViewHolder viewHolder, ViewHolder viewHolder2, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("animateChange", $$robo$$com_android_internal_widget_RecyclerView$animateChange(com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo com.android.internal.widget.RecyclerView$ItemAnimator$ItemHolderInfo boolean boolean ), this, viewHolder, viewHolder2, itemHolderInfo, itemHolderInfo2, bl, bl2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_RecyclerView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$com_android_internal_widget_RecyclerView$requestLayout(), this);
    }

    void markItemDecorInsetsDirty() {
        InvokeDynamicSupport.bootstrap("markItemDecorInsetsDirty", $$robo$$com_android_internal_widget_RecyclerView$markItemDecorInsetsDirty(), this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_widget_RecyclerView$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_RecyclerView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_widget_RecyclerView$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_RecyclerView$generateDefaultLayoutParams(), this);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_RecyclerView$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_RecyclerView$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    public boolean isAnimating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnimating", $$robo$$com_android_internal_widget_RecyclerView$isAnimating(), this);
    }

    void saveOldPositions() {
        InvokeDynamicSupport.bootstrap("saveOldPositions", $$robo$$com_android_internal_widget_RecyclerView$saveOldPositions(), this);
    }

    void clearOldPositions() {
        InvokeDynamicSupport.bootstrap("clearOldPositions", $$robo$$com_android_internal_widget_RecyclerView$clearOldPositions(), this);
    }

    void offsetPositionRecordsForMove(int n, int n2) {
        InvokeDynamicSupport.bootstrap("offsetPositionRecordsForMove", $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForMove(int int ), this, n, n2);
    }

    void offsetPositionRecordsForInsert(int n, int n2) {
        InvokeDynamicSupport.bootstrap("offsetPositionRecordsForInsert", $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForInsert(int int ), this, n, n2);
    }

    void offsetPositionRecordsForRemove(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("offsetPositionRecordsForRemove", $$robo$$com_android_internal_widget_RecyclerView$offsetPositionRecordsForRemove(int int boolean ), this, n, n2, bl);
    }

    void viewRangeUpdate(int n, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("viewRangeUpdate", $$robo$$com_android_internal_widget_RecyclerView$viewRangeUpdate(int int java.lang.Object ), this, n, n2, object);
    }

    boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
        return (boolean)InvokeDynamicSupport.bootstrap("canReuseUpdatedViewHolder", $$robo$$com_android_internal_widget_RecyclerView$canReuseUpdatedViewHolder(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
    }

    void setDataSetChangedAfterLayout() {
        InvokeDynamicSupport.bootstrap("setDataSetChangedAfterLayout", $$robo$$com_android_internal_widget_RecyclerView$setDataSetChangedAfterLayout(), this);
    }

    void markKnownViewsInvalid() {
        InvokeDynamicSupport.bootstrap("markKnownViewsInvalid", $$robo$$com_android_internal_widget_RecyclerView$markKnownViewsInvalid(), this);
    }

    public void invalidateItemDecorations() {
        InvokeDynamicSupport.bootstrap("invalidateItemDecorations", $$robo$$com_android_internal_widget_RecyclerView$invalidateItemDecorations(), this);
    }

    public boolean getPreserveFocusAfterLayout() {
        return (boolean)InvokeDynamicSupport.bootstrap("getPreserveFocusAfterLayout", $$robo$$com_android_internal_widget_RecyclerView$getPreserveFocusAfterLayout(), this);
    }

    public void setPreserveFocusAfterLayout(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPreserveFocusAfterLayout", $$robo$$com_android_internal_widget_RecyclerView$setPreserveFocusAfterLayout(boolean ), this, bl);
    }

    public ViewHolder getChildViewHolder(View view) {
        return InvokeDynamicSupport.bootstrap("getChildViewHolder", $$robo$$com_android_internal_widget_RecyclerView$getChildViewHolder(android.view.View ), this, view);
    }

    public View findContainingItemView(View view) {
        return InvokeDynamicSupport.bootstrap("findContainingItemView", $$robo$$com_android_internal_widget_RecyclerView$findContainingItemView(android.view.View ), this, view);
    }

    public ViewHolder findContainingViewHolder(View view) {
        return InvokeDynamicSupport.bootstrap("findContainingViewHolder", $$robo$$com_android_internal_widget_RecyclerView$findContainingViewHolder(android.view.View ), this, view);
    }

    static ViewHolder getChildViewHolderInt(View view) {
        return InvokeDynamicSupport.bootstrapStatic("getChildViewHolderInt", $$robo$$com_android_internal_widget_RecyclerView$getChildViewHolderInt(android.view.View ), (View)view);
    }

    @Deprecated
    public int getChildPosition(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getChildPosition", $$robo$$com_android_internal_widget_RecyclerView$getChildPosition(android.view.View ), this, view);
    }

    public int getChildAdapterPosition(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getChildAdapterPosition", $$robo$$com_android_internal_widget_RecyclerView$getChildAdapterPosition(android.view.View ), this, view);
    }

    public int getChildLayoutPosition(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getChildLayoutPosition", $$robo$$com_android_internal_widget_RecyclerView$getChildLayoutPosition(android.view.View ), this, view);
    }

    public long getChildItemId(View view) {
        return (long)InvokeDynamicSupport.bootstrap("getChildItemId", $$robo$$com_android_internal_widget_RecyclerView$getChildItemId(android.view.View ), this, view);
    }

    @Deprecated
    public ViewHolder findViewHolderForPosition(int n) {
        return InvokeDynamicSupport.bootstrap("findViewHolderForPosition", $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForPosition(int ), this, n);
    }

    public ViewHolder findViewHolderForLayoutPosition(int n) {
        return InvokeDynamicSupport.bootstrap("findViewHolderForLayoutPosition", $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForLayoutPosition(int ), this, n);
    }

    public ViewHolder findViewHolderForAdapterPosition(int n) {
        return InvokeDynamicSupport.bootstrap("findViewHolderForAdapterPosition", $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForAdapterPosition(int ), this, n);
    }

    ViewHolder findViewHolderForPosition(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("findViewHolderForPosition", $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForPosition(int boolean ), this, n, bl);
    }

    public ViewHolder findViewHolderForItemId(long l) {
        return InvokeDynamicSupport.bootstrap("findViewHolderForItemId", $$robo$$com_android_internal_widget_RecyclerView$findViewHolderForItemId(long ), this, l);
    }

    public View findChildViewUnder(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("findChildViewUnder", $$robo$$com_android_internal_widget_RecyclerView$findChildViewUnder(float float ), this, f, f2);
    }

    @Override
    public boolean drawChild(Canvas canvas, View view, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawChild", $$robo$$com_android_internal_widget_RecyclerView$drawChild(android.graphics.Canvas android.view.View long ), this, canvas, view, l);
    }

    public void offsetChildrenVertical(int n) {
        InvokeDynamicSupport.bootstrap("offsetChildrenVertical", $$robo$$com_android_internal_widget_RecyclerView$offsetChildrenVertical(int ), this, n);
    }

    public void onChildAttachedToWindow(View view) {
        InvokeDynamicSupport.bootstrap("onChildAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView$onChildAttachedToWindow(android.view.View ), this, view);
    }

    public void onChildDetachedFromWindow(View view) {
        InvokeDynamicSupport.bootstrap("onChildDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView$onChildDetachedFromWindow(android.view.View ), this, view);
    }

    public void offsetChildrenHorizontal(int n) {
        InvokeDynamicSupport.bootstrap("offsetChildrenHorizontal", $$robo$$com_android_internal_widget_RecyclerView$offsetChildrenHorizontal(int ), this, n);
    }

    public void getDecoratedBoundsWithMargins(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("getDecoratedBoundsWithMargins", $$robo$$com_android_internal_widget_RecyclerView$getDecoratedBoundsWithMargins(android.view.View android.graphics.Rect ), this, view, rect);
    }

    static void getDecoratedBoundsWithMarginsInt(View view, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("getDecoratedBoundsWithMarginsInt", $$robo$$com_android_internal_widget_RecyclerView$getDecoratedBoundsWithMarginsInt(android.view.View android.graphics.Rect ), (View)view, (Rect)rect);
    }

    Rect getItemDecorInsetsForChild(View view) {
        return InvokeDynamicSupport.bootstrap("getItemDecorInsetsForChild", $$robo$$com_android_internal_widget_RecyclerView$getItemDecorInsetsForChild(android.view.View ), this, view);
    }

    public void onScrolled(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onScrolled", $$robo$$com_android_internal_widget_RecyclerView$onScrolled(int int ), this, n, n2);
    }

    void dispatchOnScrolled(int n, int n2) {
        InvokeDynamicSupport.bootstrap("dispatchOnScrolled", $$robo$$com_android_internal_widget_RecyclerView$dispatchOnScrolled(int int ), this, n, n2);
    }

    public void onScrollStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$com_android_internal_widget_RecyclerView$onScrollStateChanged(int ), this, n);
    }

    void dispatchOnScrollStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("dispatchOnScrollStateChanged", $$robo$$com_android_internal_widget_RecyclerView$dispatchOnScrollStateChanged(int ), this, n);
    }

    public boolean hasPendingAdapterUpdates() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPendingAdapterUpdates", $$robo$$com_android_internal_widget_RecyclerView$hasPendingAdapterUpdates(), this);
    }

    void repositionShadowingViews() {
        InvokeDynamicSupport.bootstrap("repositionShadowingViews", $$robo$$com_android_internal_widget_RecyclerView$repositionShadowingViews(), this);
    }

    static RecyclerView findNestedRecyclerView(View view) {
        return InvokeDynamicSupport.bootstrapStatic("findNestedRecyclerView", $$robo$$com_android_internal_widget_RecyclerView$findNestedRecyclerView(android.view.View ), (View)view);
    }

    static void clearNestedRecyclerViewIfNotNested(ViewHolder viewHolder) {
        InvokeDynamicSupport.bootstrapStatic("clearNestedRecyclerViewIfNotNested", $$robo$$com_android_internal_widget_RecyclerView$clearNestedRecyclerViewIfNotNested(com.android.internal.widget.RecyclerView$ViewHolder ), (ViewHolder)viewHolder);
    }

    long getNanoTime() {
        return (long)InvokeDynamicSupport.bootstrap("getNanoTime", $$robo$$com_android_internal_widget_RecyclerView$getNanoTime(), this);
    }

    void dispatchChildDetached(View view) {
        InvokeDynamicSupport.bootstrap("dispatchChildDetached", $$robo$$com_android_internal_widget_RecyclerView$dispatchChildDetached(android.view.View ), this, view);
    }

    void dispatchChildAttached(View view) {
        InvokeDynamicSupport.bootstrap("dispatchChildAttached", $$robo$$com_android_internal_widget_RecyclerView$dispatchChildAttached(android.view.View ), this, view);
    }

    boolean setChildImportantForAccessibilityInternal(ViewHolder viewHolder, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setChildImportantForAccessibilityInternal", $$robo$$com_android_internal_widget_RecyclerView$setChildImportantForAccessibilityInternal(com.android.internal.widget.RecyclerView$ViewHolder int ), this, viewHolder, n);
    }

    void dispatchPendingImportantForAccessibilityChanges() {
        InvokeDynamicSupport.bootstrap("dispatchPendingImportantForAccessibilityChanges", $$robo$$com_android_internal_widget_RecyclerView$dispatchPendingImportantForAccessibilityChanges(), this);
    }

    int getAdapterPositionFor(ViewHolder viewHolder) {
        return (int)InvokeDynamicSupport.bootstrap("getAdapterPositionFor", $$robo$$com_android_internal_widget_RecyclerView$getAdapterPositionFor(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
    }

    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getChildDrawingOrder", $$robo$$com_android_internal_widget_RecyclerView$getChildDrawingOrder(int int ), this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(RecyclerView.class);
    }

    public /* synthetic */ RecyclerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecyclerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ChildDrawingOrderCallback {
        public int onGetChildDrawingOrder(int var1, int var2);
    }

    public static abstract class ItemAnimator
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int FLAG_CHANGED = 2;
        public static int FLAG_REMOVED = 8;
        public static int FLAG_INVALIDATED = 4;
        public static int FLAG_MOVED = 2048;
        public static int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        private ItemAnimatorListener mListener;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners;
        private long mAddDuration;
        private long mRemoveDuration;
        private long mMoveDuration;
        private long mChangeDuration;

        private void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$__constructor__() {
            this.mListener = null;
            this.mFinishedListeners = new ArrayList();
            this.mAddDuration = 120L;
            this.mRemoveDuration = 120L;
            this.mMoveDuration = 250L;
            this.mChangeDuration = 250L;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getMoveDuration() {
            return this.mMoveDuration;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setMoveDuration(long moveDuration) {
            this.mMoveDuration = moveDuration;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getAddDuration() {
            return this.mAddDuration;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setAddDuration(long addDuration) {
            this.mAddDuration = addDuration;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getRemoveDuration() {
            return this.mRemoveDuration;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setRemoveDuration(long removeDuration) {
            this.mRemoveDuration = removeDuration;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getChangeDuration() {
            return this.mChangeDuration;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setChangeDuration(long changeDuration) {
            this.mChangeDuration = changeDuration;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setListener(ItemAnimatorListener listener) {
            this.mListener = listener;
        }

        private final ItemHolderInfo $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$recordPreLayoutInformation(State state, ViewHolder viewHolder, int changeFlags, List<Object> payloads) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        private final ItemHolderInfo $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$recordPostLayoutInformation(State state, ViewHolder viewHolder) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        public abstract boolean animateDisappearance(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public abstract boolean animateAppearance(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public abstract boolean animatePersistence(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public abstract boolean animateChange(ViewHolder var1, ViewHolder var2, ItemHolderInfo var3, ItemHolderInfo var4);

        private static final int $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$buildAdapterChangeFlagsForAnimations(ViewHolder viewHolder) {
            int flags = viewHolder.mFlags & 0xE;
            if (viewHolder.isInvalid()) {
                return 4;
            }
            if ((flags & 4) == 0) {
                int oldPos = viewHolder.getOldPosition();
                int pos = viewHolder.getAdapterPosition();
                if (oldPos != -1 && pos != -1 && oldPos != pos) {
                    flags |= 0x800;
                }
            }
            return flags;
        }

        public abstract void runPendingAnimations();

        public abstract void endAnimation(ViewHolder var1);

        public abstract void endAnimations();

        public abstract boolean isRunning();

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationFinished(ViewHolder viewHolder) {
            this.onAnimationFinished(viewHolder);
            if (this.mListener != null) {
                this.mListener.onAnimationFinished(viewHolder);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$onAnimationFinished(ViewHolder viewHolder) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationStarted(ViewHolder viewHolder) {
            this.onAnimationStarted(viewHolder);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$onAnimationStarted(ViewHolder viewHolder) {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$isRunning(ItemAnimatorFinishedListener listener) {
            boolean running = this.isRunning();
            if (listener != null) {
                if (!running) {
                    listener.onAnimationsFinished();
                } else {
                    this.mFinishedListeners.add(listener);
                }
            }
            return running;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$canReuseUpdatedViewHolder(ViewHolder viewHolder) {
            return true;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$canReuseUpdatedViewHolder(ViewHolder viewHolder, List<Object> payloads) {
            return this.canReuseUpdatedViewHolder(viewHolder);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationsFinished() {
            int count = this.mFinishedListeners.size();
            for (int i = 0; i < count; ++i) {
                this.mFinishedListeners.get(i).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        private final ItemHolderInfo $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$obtainHolderInfo() {
            return new ItemHolderInfo();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$__constructor__();
        }

        public ItemAnimator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$__constructor__(), this);
        }

        public long getMoveDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getMoveDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getMoveDuration(), this);
        }

        public void setMoveDuration(long l) {
            InvokeDynamicSupport.bootstrap("setMoveDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setMoveDuration(long ), this, l);
        }

        public long getAddDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getAddDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getAddDuration(), this);
        }

        public void setAddDuration(long l) {
            InvokeDynamicSupport.bootstrap("setAddDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setAddDuration(long ), this, l);
        }

        public long getRemoveDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getRemoveDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getRemoveDuration(), this);
        }

        public void setRemoveDuration(long l) {
            InvokeDynamicSupport.bootstrap("setRemoveDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setRemoveDuration(long ), this, l);
        }

        public long getChangeDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getChangeDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$getChangeDuration(), this);
        }

        public void setChangeDuration(long l) {
            InvokeDynamicSupport.bootstrap("setChangeDuration", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setChangeDuration(long ), this, l);
        }

        void setListener(ItemAnimatorListener itemAnimatorListener) {
            InvokeDynamicSupport.bootstrap("setListener", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$setListener(com.android.internal.widget.RecyclerView$ItemAnimator$ItemAnimatorListener ), this, itemAnimatorListener);
        }

        public ItemHolderInfo recordPreLayoutInformation(State state, ViewHolder viewHolder, int n, List<Object> list) {
            return InvokeDynamicSupport.bootstrap("recordPreLayoutInformation", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$recordPreLayoutInformation(com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$ViewHolder int java.util.List<java.lang.Object> ), this, state, viewHolder, n, list);
        }

        public ItemHolderInfo recordPostLayoutInformation(State state, ViewHolder viewHolder) {
            return InvokeDynamicSupport.bootstrap("recordPostLayoutInformation", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$recordPostLayoutInformation(com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$ViewHolder ), this, state, viewHolder);
        }

        static int buildAdapterChangeFlagsForAnimations(ViewHolder viewHolder) {
            return (int)InvokeDynamicSupport.bootstrapStatic("buildAdapterChangeFlagsForAnimations", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$buildAdapterChangeFlagsForAnimations(com.android.internal.widget.RecyclerView$ViewHolder ), (ViewHolder)viewHolder);
        }

        public void dispatchAnimationFinished(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("dispatchAnimationFinished", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationFinished(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public void onAnimationFinished(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("onAnimationFinished", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$onAnimationFinished(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public void dispatchAnimationStarted(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("dispatchAnimationStarted", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationStarted(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public void onAnimationStarted(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("onAnimationStarted", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$onAnimationStarted(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public boolean isRunning(ItemAnimatorFinishedListener itemAnimatorFinishedListener) {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$isRunning(com.android.internal.widget.RecyclerView$ItemAnimator$ItemAnimatorFinishedListener ), this, itemAnimatorFinishedListener);
        }

        public boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
            return (boolean)InvokeDynamicSupport.bootstrap("canReuseUpdatedViewHolder", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$canReuseUpdatedViewHolder(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public boolean canReuseUpdatedViewHolder(ViewHolder viewHolder, List<Object> list) {
            return (boolean)InvokeDynamicSupport.bootstrap("canReuseUpdatedViewHolder", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$canReuseUpdatedViewHolder(com.android.internal.widget.RecyclerView$ViewHolder java.util.List<java.lang.Object> ), this, viewHolder, list);
        }

        public void dispatchAnimationsFinished() {
            InvokeDynamicSupport.bootstrap("dispatchAnimationsFinished", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$dispatchAnimationsFinished(), this);
        }

        public ItemHolderInfo obtainHolderInfo() {
            return InvokeDynamicSupport.bootstrap("obtainHolderInfo", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator$obtainHolderInfo(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemAnimator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class ItemHolderInfo
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public int left;
            public int top;
            public int right;
            public int bottom;
            public int changeFlags;

            private void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$__constructor__() {
            }

            private final ItemHolderInfo $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$setFrom(ViewHolder holder) {
                return this.setFrom(holder, 0);
            }

            private final ItemHolderInfo $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$setFrom(ViewHolder holder, int flags) {
                View view = holder.itemView;
                this.left = view.getLeft();
                this.top = view.getTop();
                this.right = view.getRight();
                this.bottom = view.getBottom();
                return this;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$__constructor__();
            }

            public ItemHolderInfo() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$__constructor__(), this);
            }

            public ItemHolderInfo setFrom(ViewHolder viewHolder) {
                return InvokeDynamicSupport.bootstrap("setFrom", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$setFrom(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
            }

            public ItemHolderInfo setFrom(ViewHolder viewHolder, int n) {
                return InvokeDynamicSupport.bootstrap("setFrom", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimator_ItemHolderInfo$setFrom(com.android.internal.widget.RecyclerView$ViewHolder int ), this, viewHolder, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemHolderInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        static interface ItemAnimatorListener {
            public void onAnimationFinished(ViewHolder var1);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AdapterChanges {
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RecyclerView this$0;

        private void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimatorRestoreListener$__constructor__(RecyclerView recyclerView) {
            this.this$0 = recyclerView;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemAnimatorRestoreListener$onAnimationFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (item.mShadowedHolder != null && item.mShadowingHolder == null) {
                item.mShadowedHolder = null;
            }
            item.mShadowingHolder = null;
            if (!item.shouldBeKeptAsChild() && !this.this$0.removeAnimatingView(item.itemView) && item.isTmpDetached()) {
                this.this$0.removeDetachedView(item.itemView, false);
            }
        }

        private void __constructor__(RecyclerView recyclerView) {
            this.$$robo$$com_android_internal_widget_RecyclerView_ItemAnimatorRestoreListener$__constructor__(recyclerView);
        }

        public ItemAnimatorRestoreListener(RecyclerView recyclerView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimatorRestoreListener$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        @Override
        public void onAnimationFinished(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("onAnimationFinished", $$robo$$com_android_internal_widget_RecyclerView_ItemAnimatorRestoreListener$onAnimationFinished(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        public /* synthetic */ ItemAnimatorRestoreListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemAnimatorRestoreListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class OnFlingListener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_OnFlingListener$__constructor__() {
        }

        public abstract boolean onFling(int var1, int var2);

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_OnFlingListener$__constructor__();
        }

        public OnFlingListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_OnFlingListener$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnFlingListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int STEP_START = 1;
        static int STEP_LAYOUT = 2;
        static int STEP_ANIMATIONS = 4;
        private int mTargetPosition;
        private SparseArray<Object> mData;
        int mPreviousLayoutItemCount;
        int mDeletedInvisibleItemCountSincePreviousLayout;
        int mLayoutStep;
        int mItemCount;
        boolean mStructureChanged;
        boolean mInPreLayout;
        boolean mTrackOldChangeHolders;
        boolean mIsMeasuring;
        boolean mRunSimpleAnimations;
        boolean mRunPredictiveAnimations;
        int mFocusedItemPosition;
        long mFocusedItemId;
        int mFocusedSubChildId;

        private void $$robo$$com_android_internal_widget_RecyclerView_State$__constructor__() {
            this.mTargetPosition = -1;
            this.mPreviousLayoutItemCount = 0;
            this.mDeletedInvisibleItemCountSincePreviousLayout = 0;
            this.mLayoutStep = 1;
            this.mItemCount = 0;
            this.mStructureChanged = false;
            this.mInPreLayout = false;
            this.mTrackOldChangeHolders = false;
            this.mIsMeasuring = false;
            this.mRunSimpleAnimations = false;
            this.mRunPredictiveAnimations = false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_State$assertLayoutStep(int accepted) {
            if ((accepted & this.mLayoutStep) == 0) {
                throw new IllegalStateException("Layout state should be one of " + Integer.toBinaryString(accepted) + " but it is " + Integer.toBinaryString(this.mLayoutStep));
            }
        }

        private final State $$robo$$com_android_internal_widget_RecyclerView_State$reset() {
            this.mTargetPosition = -1;
            if (this.mData != null) {
                this.mData.clear();
            }
            this.mItemCount = 0;
            this.mStructureChanged = false;
            this.mIsMeasuring = false;
            return this;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_State$prepareForNestedPrefetch(Adapter adapter) {
            this.mLayoutStep = 1;
            this.mItemCount = adapter.getItemCount();
            this.mStructureChanged = false;
            this.mInPreLayout = false;
            this.mTrackOldChangeHolders = false;
            this.mIsMeasuring = false;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$isMeasuring() {
            return this.mIsMeasuring;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$isPreLayout() {
            return this.mInPreLayout;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$willRunPredictiveAnimations() {
            return this.mRunPredictiveAnimations;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$willRunSimpleAnimations() {
            return this.mRunSimpleAnimations;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_State$remove(int resourceId) {
            if (this.mData == null) {
                return;
            }
            this.mData.remove(resourceId);
        }

        private final <T> T $$robo$$com_android_internal_widget_RecyclerView_State$get(int resourceId) {
            if (this.mData == null) {
                return null;
            }
            return (T)this.mData.get(resourceId);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_State$put(int resourceId, Object data) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(resourceId, data);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_State$getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$hasTargetScrollPosition() {
            return this.mTargetPosition != -1;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_State$didStructureChange() {
            return this.mStructureChanged;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_State$getItemCount() {
            return this.mInPreLayout ? this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout : this.mItemCount;
        }

        private final String $$robo$$com_android_internal_widget_RecyclerView_State$toString() {
            return "State{mTargetPosition=" + this.mTargetPosition + ", mData=" + this.mData + ", mItemCount=" + this.mItemCount + ", mPreviousLayoutItemCount=" + this.mPreviousLayoutItemCount + ", mDeletedInvisibleItemCountSincePreviousLayout=" + this.mDeletedInvisibleItemCountSincePreviousLayout + ", mStructureChanged=" + this.mStructureChanged + ", mInPreLayout=" + this.mInPreLayout + ", mRunSimpleAnimations=" + this.mRunSimpleAnimations + ", mRunPredictiveAnimations=" + this.mRunPredictiveAnimations + '}';
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_State$__constructor__();
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_State$__constructor__(), this);
        }

        void assertLayoutStep(int n) {
            InvokeDynamicSupport.bootstrap("assertLayoutStep", $$robo$$com_android_internal_widget_RecyclerView_State$assertLayoutStep(int ), this, n);
        }

        State reset() {
            return InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_RecyclerView_State$reset(), this);
        }

        void prepareForNestedPrefetch(Adapter adapter) {
            InvokeDynamicSupport.bootstrap("prepareForNestedPrefetch", $$robo$$com_android_internal_widget_RecyclerView_State$prepareForNestedPrefetch(com.android.internal.widget.RecyclerView$Adapter ), this, adapter);
        }

        public boolean isMeasuring() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMeasuring", $$robo$$com_android_internal_widget_RecyclerView_State$isMeasuring(), this);
        }

        public boolean isPreLayout() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPreLayout", $$robo$$com_android_internal_widget_RecyclerView_State$isPreLayout(), this);
        }

        public boolean willRunPredictiveAnimations() {
            return (boolean)InvokeDynamicSupport.bootstrap("willRunPredictiveAnimations", $$robo$$com_android_internal_widget_RecyclerView_State$willRunPredictiveAnimations(), this);
        }

        public boolean willRunSimpleAnimations() {
            return (boolean)InvokeDynamicSupport.bootstrap("willRunSimpleAnimations", $$robo$$com_android_internal_widget_RecyclerView_State$willRunSimpleAnimations(), this);
        }

        public void remove(int n) {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_widget_RecyclerView_State$remove(int ), this, n);
        }

        public <T> T get(int n) {
            return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_widget_RecyclerView_State$get(int ), this, n);
        }

        public void put(int n, Object object) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$com_android_internal_widget_RecyclerView_State$put(int java.lang.Object ), this, n, object);
        }

        public int getTargetScrollPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getTargetScrollPosition", $$robo$$com_android_internal_widget_RecyclerView_State$getTargetScrollPosition(), this);
        }

        public boolean hasTargetScrollPosition() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasTargetScrollPosition", $$robo$$com_android_internal_widget_RecyclerView_State$hasTargetScrollPosition(), this);
        }

        public boolean didStructureChange() {
            return (boolean)InvokeDynamicSupport.bootstrap("didStructureChange", $$robo$$com_android_internal_widget_RecyclerView_State$didStructureChange(), this);
        }

        public int getItemCount() {
            return (int)InvokeDynamicSupport.bootstrap("getItemCount", $$robo$$com_android_internal_widget_RecyclerView_State$getItemCount(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_RecyclerView_State$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface LayoutState {
        }
    }

    public static class SavedState
    extends AbsSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Parcelable mLayoutState;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(Parcel in) {
            this.mLayoutState = in.readParcelable(LayoutManager.class.getClassLoader());
        }

        private void $$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(Parcelable superState) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.mLayoutState, 0);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SavedState$copyFrom(SavedState other) {
            this.mLayoutState = other.mLayoutState;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_RecyclerView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_widget_RecyclerView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(parcelable);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_widget_RecyclerView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        void copyFrom(SavedState savedState) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$com_android_internal_widget_RecyclerView_SavedState$copyFrom(com.android.internal.widget.RecyclerView$SavedState ), this, savedState);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$__constructor__() {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$hasObservers() {
            return !this.mObservers.isEmpty();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onChanged();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeChanged(int positionStart, int itemCount) {
            this.notifyItemRangeChanged(positionStart, itemCount, null);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeChanged(int positionStart, int itemCount, Object payload) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount, payload);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemMoved(int fromPosition, int toPosition) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeMoved(fromPosition, toPosition, 1);
            }
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$__constructor__();
        }

        public AdapterDataObservable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$__constructor__(), this);
        }

        public boolean hasObservers() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasObservers", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$hasObservers(), this);
        }

        public void notifyChanged() {
            InvokeDynamicSupport.bootstrap("notifyChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyChanged(), this);
        }

        public void notifyItemRangeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeChanged(int int ), this, n, n2);
        }

        public void notifyItemRangeChanged(int n, int n2, Object object) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeChanged(int int java.lang.Object ), this, n, n2, object);
        }

        public void notifyItemRangeInserted(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeInserted", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeInserted(int int ), this, n, n2);
        }

        public void notifyItemRangeRemoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeRemoved", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemRangeRemoved(int int ), this, n, n2);
        }

        public void notifyItemMoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemMoved", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObservable$notifyItemMoved(int int ), this, n, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterDataObservable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SmoothScroller
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mTargetPosition;
        private RecyclerView mRecyclerView;
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private boolean mRunning;
        private View mTargetView;
        private Action mRecyclingAction;

        private void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$__constructor__() {
            this.mTargetPosition = -1;
            this.mRecyclingAction = new Action(0, 0);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$start(RecyclerView recyclerView, LayoutManager layoutManager) {
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            this.mRecyclerView.mState.mTargetPosition = this.mTargetPosition;
            this.mRunning = true;
            this.mPendingInitialRun = true;
            this.mTargetView = this.findViewByPosition(this.getTargetPosition());
            this.onStart();
            this.mRecyclerView.mViewFlinger.postOnAnimation();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$setTargetPosition(int targetPosition) {
            this.mTargetPosition = targetPosition;
        }

        private final LayoutManager $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getLayoutManager() {
            return this.mLayoutManager;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$stop() {
            if (!this.mRunning) {
                return;
            }
            this.onStop();
            this.mRecyclerView.mState.mTargetPosition = -1;
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mRunning = false;
            this.mLayoutManager.onSmoothScrollerStopped(this);
            this.mLayoutManager = null;
            this.mRecyclerView = null;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$isRunning() {
            return this.mRunning;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getTargetPosition() {
            return this.mTargetPosition;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$onAnimation(int dx, int dy) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (!this.mRunning || this.mTargetPosition == -1 || recyclerView == null) {
                this.stop();
            }
            this.mPendingInitialRun = false;
            if (this.mTargetView != null) {
                if (this.getChildPosition(this.mTargetView) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, recyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.runIfNecessary(recyclerView);
                    this.stop();
                } else {
                    Log.e("RecyclerView", "Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                this.onSeekTargetStep(dx, dy, recyclerView.mState, this.mRecyclingAction);
                boolean hadJumpTarget = this.mRecyclingAction.hasJumpTarget();
                this.mRecyclingAction.runIfNecessary(recyclerView);
                if (hadJumpTarget) {
                    if (this.mRunning) {
                        this.mPendingInitialRun = true;
                        recyclerView.mViewFlinger.postOnAnimation();
                    } else {
                        this.stop();
                    }
                }
            }
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getChildPosition(View view) {
            return this.mRecyclerView.getChildLayoutPosition(view);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getChildCount() {
            return this.mRecyclerView.mLayout.getChildCount();
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$findViewByPosition(int position) {
            return this.mRecyclerView.mLayout.findViewByPosition(position);
        }

        @Deprecated
        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$instantScrollToPosition(int position) {
            this.mRecyclerView.scrollToPosition(position);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$onChildAttachedToWindow(View child) {
            if (this.getChildPosition(child) == this.getTargetPosition()) {
                this.mTargetView = child;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$normalize(PointF scrollVector) {
            double magnitude = Math.sqrt(scrollVector.x * scrollVector.x + scrollVector.y * scrollVector.y);
            scrollVector.x = (float)((double)scrollVector.x / magnitude);
            scrollVector.y = (float)((double)scrollVector.y / magnitude);
        }

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onSeekTargetStep(int var1, int var2, State var3, Action var4);

        protected abstract void onTargetFound(View var1, State var2, Action var3);

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$__constructor__();
        }

        public SmoothScroller() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$__constructor__(), this);
        }

        void start(RecyclerView recyclerView, LayoutManager layoutManager) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$start(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$LayoutManager ), this, recyclerView, layoutManager);
        }

        public void setTargetPosition(int n) {
            InvokeDynamicSupport.bootstrap("setTargetPosition", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$setTargetPosition(int ), this, n);
        }

        public LayoutManager getLayoutManager() {
            return InvokeDynamicSupport.bootstrap("getLayoutManager", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getLayoutManager(), this);
        }

        protected void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$stop(), this);
        }

        public boolean isPendingInitialRun() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPendingInitialRun", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$isPendingInitialRun(), this);
        }

        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$isRunning(), this);
        }

        public int getTargetPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getTargetPosition", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getTargetPosition(), this);
        }

        private void onAnimation(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onAnimation", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$onAnimation(int int ), this, n, n2);
        }

        public int getChildPosition(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getChildPosition", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getChildPosition(android.view.View ), this, view);
        }

        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$getChildCount(), this);
        }

        public View findViewByPosition(int n) {
            return InvokeDynamicSupport.bootstrap("findViewByPosition", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$findViewByPosition(int ), this, n);
        }

        @Deprecated
        public void instantScrollToPosition(int n) {
            InvokeDynamicSupport.bootstrap("instantScrollToPosition", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$instantScrollToPosition(int ), this, n);
        }

        protected void onChildAttachedToWindow(View view) {
            InvokeDynamicSupport.bootstrap("onChildAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$onChildAttachedToWindow(android.view.View ), this, view);
        }

        protected void normalize(PointF pointF) {
            InvokeDynamicSupport.bootstrap("normalize", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller$normalize(android.graphics.PointF ), this, pointF);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmoothScroller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface ScrollVectorProvider {
            public PointF computeScrollVectorForPosition(int var1);
        }

        public static class Action
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public static int UNDEFINED_DURATION = Integer.MIN_VALUE;
            private int mDx;
            private int mDy;
            private int mDuration;
            private int mJumpToPosition;
            private Interpolator mInterpolator;
            private boolean mChanged;
            private int mConsecutiveUpdates;

            private void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int dx, int dy) {
            }

            private void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int dx, int dy, int duration) {
            }

            private void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int dx, int dy, int duration, Interpolator interpolator2) {
                this.mJumpToPosition = -1;
                this.mChanged = false;
                this.mConsecutiveUpdates = 0;
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator2;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$jumpTo(int targetPosition) {
                this.mJumpToPosition = targetPosition;
            }

            private final boolean $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$hasJumpTarget() {
                return this.mJumpToPosition >= 0;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$runIfNecessary(RecyclerView recyclerView) {
                if (this.mJumpToPosition >= 0) {
                    int position = this.mJumpToPosition;
                    this.mJumpToPosition = -1;
                    recyclerView.jumpToPositionForSmoothScroller(position);
                    this.mChanged = false;
                    return;
                }
                if (this.mChanged) {
                    this.validate();
                    if (this.mInterpolator == null) {
                        if (this.mDuration == Integer.MIN_VALUE) {
                            recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy);
                        } else {
                            recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration);
                        }
                    } else {
                        recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration, this.mInterpolator);
                    }
                    ++this.mConsecutiveUpdates;
                    if (this.mConsecutiveUpdates > 10) {
                        Log.e("RecyclerView", "Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.mChanged = false;
                } else {
                    this.mConsecutiveUpdates = 0;
                }
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$validate() {
                if (this.mInterpolator != null && this.mDuration < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.mDuration < 1) {
                    throw new IllegalStateException("Scroll duration must be a positive number");
                }
            }

            private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDx() {
                return this.mDx;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDx(int dx) {
                this.mChanged = true;
                this.mDx = dx;
            }

            private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDy() {
                return this.mDy;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDy(int dy) {
                this.mChanged = true;
                this.mDy = dy;
            }

            private final int $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDuration() {
                return this.mDuration;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDuration(int duration) {
                this.mChanged = true;
                this.mDuration = duration;
            }

            private final Interpolator $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getInterpolator() {
                return this.mInterpolator;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setInterpolator(Interpolator interpolator2) {
                this.mChanged = true;
                this.mInterpolator = interpolator2;
            }

            private final void $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$update(int dx, int dy, int duration, Interpolator interpolator2) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator2;
                this.mChanged = true;
            }

            private void __constructor__(int n, int n2) {
                this.$$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(n, n2);
            }

            public Action(int n, int n2) {
                this(n, n2, Integer.MIN_VALUE, null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int int ), this, n, n2);
            }

            private void __constructor__(int n, int n2, int n3) {
                this.$$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(n, n2, n3);
            }

            public Action(int n, int n2, int n3) {
                this(n, n2, n3, null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int int int ), this, n, n2, n3);
            }

            private void __constructor__(int n, int n2, int n3, Interpolator interpolator2) {
                this.$$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(n, n2, n3, interpolator2);
            }

            public Action(int n, int n2, int n3, Interpolator interpolator2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$__constructor__(int int int android.view.animation.Interpolator ), this, n, n2, n3, interpolator2);
            }

            public void jumpTo(int n) {
                InvokeDynamicSupport.bootstrap("jumpTo", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$jumpTo(int ), this, n);
            }

            boolean hasJumpTarget() {
                return (boolean)InvokeDynamicSupport.bootstrap("hasJumpTarget", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$hasJumpTarget(), this);
            }

            void runIfNecessary(RecyclerView recyclerView) {
                InvokeDynamicSupport.bootstrap("runIfNecessary", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$runIfNecessary(com.android.internal.widget.RecyclerView ), this, recyclerView);
            }

            private void validate() {
                InvokeDynamicSupport.bootstrap("validate", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$validate(), this);
            }

            public int getDx() {
                return (int)InvokeDynamicSupport.bootstrap("getDx", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDx(), this);
            }

            public void setDx(int n) {
                InvokeDynamicSupport.bootstrap("setDx", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDx(int ), this, n);
            }

            public int getDy() {
                return (int)InvokeDynamicSupport.bootstrap("getDy", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDy(), this);
            }

            public void setDy(int n) {
                InvokeDynamicSupport.bootstrap("setDy", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDy(int ), this, n);
            }

            public int getDuration() {
                return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getDuration(), this);
            }

            public void setDuration(int n) {
                InvokeDynamicSupport.bootstrap("setDuration", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setDuration(int ), this, n);
            }

            public Interpolator getInterpolator() {
                return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$getInterpolator(), this);
            }

            public void setInterpolator(Interpolator interpolator2) {
                InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$setInterpolator(android.view.animation.Interpolator ), this, interpolator2);
            }

            public void update(int n, int n2, int n3, Interpolator interpolator2) {
                InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_widget_RecyclerView_SmoothScroller_Action$update(int int int android.view.animation.Interpolator ), this, n, n2, n3, interpolator2);
            }

            public /* synthetic */ Action() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Action)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class AdapterDataObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onChanged() {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeChanged(int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.onItemRangeChanged(positionStart, itemCount);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeInserted(int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeRemoved(int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$__constructor__();
        }

        public AdapterDataObserver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$__constructor__(), this);
        }

        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onChanged(), this);
        }

        public void onItemRangeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeChanged(int int ), this, n, n2);
        }

        public void onItemRangeChanged(int n, int n2, Object object) {
            InvokeDynamicSupport.bootstrap("onItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeChanged(int int java.lang.Object ), this, n, n2, object);
        }

        public void onItemRangeInserted(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemRangeInserted", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeInserted(int int ), this, n, n2);
        }

        public void onItemRangeRemoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemRangeRemoved", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeRemoved(int int ), this, n, n2);
        }

        public void onItemRangeMoved(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onItemRangeMoved", $$robo$$com_android_internal_widget_RecyclerView_AdapterDataObserver$onItemRangeMoved(int int int ), this, n, n2, n3);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterDataObserver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ViewHolder mViewHolder;
        Rect mDecorInsets;
        boolean mInsetsDirty;
        boolean mPendingInvalidate;

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.mDecorInsets = new Rect();
            this.mInsetsDirty = true;
            this.mPendingInvalidate = false;
        }

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(int width, int height) {
            this.mDecorInsets = new Rect();
            this.mInsetsDirty = true;
            this.mPendingInvalidate = false;
        }

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.mDecorInsets = new Rect();
            this.mInsetsDirty = true;
            this.mPendingInvalidate = false;
        }

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
            this.mDecorInsets = new Rect();
            this.mInsetsDirty = true;
            this.mPendingInvalidate = false;
        }

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(LayoutParams source) {
            this.mDecorInsets = new Rect();
            this.mInsetsDirty = true;
            this.mPendingInvalidate = false;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isItemChanged() {
            return this.mViewHolder.isUpdated();
        }

        @Deprecated
        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewPosition() {
            return this.mViewHolder.getPosition();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewLayoutPosition() {
            return this.mViewHolder.getLayoutPosition();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewAdapterPosition() {
            return this.mViewHolder.getAdapterPosition();
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), this, marginLayoutParams);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.LayoutParams)layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$__constructor__(com.android.internal.widget.RecyclerView$LayoutParams ), this, layoutParams);
        }

        public boolean viewNeedsUpdate() {
            return (boolean)InvokeDynamicSupport.bootstrap("viewNeedsUpdate", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$viewNeedsUpdate(), this);
        }

        public boolean isViewInvalid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isViewInvalid", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isViewInvalid(), this);
        }

        public boolean isItemRemoved() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItemRemoved", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isItemRemoved(), this);
        }

        public boolean isItemChanged() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItemChanged", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$isItemChanged(), this);
        }

        @Deprecated
        public int getViewPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getViewPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewPosition(), this);
        }

        public int getViewLayoutPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getViewLayoutPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewLayoutPosition(), this);
        }

        public int getViewAdapterPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getViewAdapterPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutParams$getViewAdapterPosition(), this);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ViewHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public View itemView;
        WeakReference<RecyclerView> mNestedRecyclerView;
        int mPosition;
        int mOldPosition;
        long mItemId;
        int mItemViewType;
        int mPreLayoutPosition;
        ViewHolder mShadowedHolder;
        ViewHolder mShadowingHolder;
        static int FLAG_BOUND = 1;
        static int FLAG_UPDATE = 2;
        static int FLAG_INVALID = 4;
        static int FLAG_REMOVED = 8;
        static int FLAG_NOT_RECYCLABLE = 16;
        static int FLAG_RETURNED_FROM_SCRAP = 32;
        static int FLAG_IGNORE = 128;
        static int FLAG_TMP_DETACHED = 256;
        static int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        static int FLAG_ADAPTER_FULLUPDATE = 1024;
        static int FLAG_MOVED = 2048;
        static int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        static int PENDING_ACCESSIBILITY_STATE_NOT_SET = -1;
        static int FLAG_BOUNCED_FROM_HIDDEN_LIST = 8192;
        private int mFlags;
        private static List<Object> FULLUPDATE_PAYLOADS;
        List<Object> mPayloads;
        List<Object> mUnmodifiedPayloads;
        private int mIsRecyclableCount;
        private Recycler mScrapContainer;
        private boolean mInChangeScrap;
        private int mWasImportantForAccessibilityBeforeHidden;
        @VisibleForTesting
        int mPendingAccessibilityState;
        RecyclerView mOwnerRecyclerView;

        private void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$__constructor__(View itemView) {
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mItemViewType = -1;
            this.mPreLayoutPosition = -1;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            this.mPayloads = null;
            this.mUnmodifiedPayloads = null;
            this.mIsRecyclableCount = 0;
            this.mScrapContainer = null;
            this.mInChangeScrap = false;
            this.mWasImportantForAccessibilityBeforeHidden = 0;
            this.mPendingAccessibilityState = -1;
            if (itemView == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = itemView;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$flagRemovedAndOffsetPosition(int mNewPosition, int offset, boolean applyToPreLayout) {
            this.addFlags(8);
            this.offsetPosition(offset, applyToPreLayout);
            this.mPosition = mNewPosition;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$offsetPosition(int offset, boolean applyToPreLayout) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (applyToPreLayout) {
                this.mPreLayoutPosition += offset;
            }
            this.mPosition += offset;
            if (this.itemView.getLayoutParams() != null) {
                ((LayoutParams)this.itemView.getLayoutParams()).mInsetsDirty = true;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$shouldIgnore() {
            return (this.mFlags & 0x80) != 0;
        }

        @Deprecated
        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getLayoutPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getAdapterPosition() {
            if (this.mOwnerRecyclerView == null) {
                return -1;
            }
            return this.mOwnerRecyclerView.getAdapterPositionFor(this);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getOldPosition() {
            return this.mOldPosition;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getItemId() {
            return this.mItemId;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getItemViewType() {
            return this.mItemViewType;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isScrap() {
            return this.mScrapContainer != null;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$unScrap() {
            this.mScrapContainer.unscrapView(this);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$wasReturnedFromScrap() {
            return (this.mFlags & 0x20) != 0;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearReturnedFromScrapFlag() {
            this.mFlags &= 0xFFFFFFDF;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearTmpDetachFlag() {
            this.mFlags &= 0xFFFFFEFF;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$stopIgnoring() {
            this.mFlags &= 0xFFFFFF7F;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setScrapContainer(Recycler recycler, boolean isChangeScrap) {
            this.mScrapContainer = recycler;
            this.mInChangeScrap = isChangeScrap;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isInvalid() {
            return (this.mFlags & 4) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$needsUpdate() {
            return (this.mFlags & 2) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isBound() {
            return (this.mFlags & 1) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isRemoved() {
            return (this.mFlags & 8) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$hasAnyOfTheFlags(int flags) {
            return (this.mFlags & flags) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isTmpDetached() {
            return (this.mFlags & 0x100) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isAdapterPositionUnknown() {
            return (this.mFlags & 0x200) != 0 || this.isInvalid();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags & mask;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$addFlags(int flags) {
            this.mFlags |= flags;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$addChangePayload(Object payload) {
            if (payload == null) {
                this.addFlags(1024);
            } else if ((this.mFlags & 0x400) == 0) {
                this.createPayloadsIfNeeded();
                this.mPayloads.add(payload);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$createPayloadsIfNeeded() {
            if (this.mPayloads == null) {
                this.mPayloads = new ArrayList<Object>();
                this.mUnmodifiedPayloads = Collections.unmodifiableList(this.mPayloads);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearPayload() {
            if (this.mPayloads != null) {
                this.mPayloads.clear();
            }
            this.mFlags &= 0xFFFFFBFF;
        }

        private final List<Object> $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getUnmodifiedPayloads() {
            if ((this.mFlags & 0x400) == 0) {
                if (this.mPayloads == null || this.mPayloads.size() == 0) {
                    return FULLUPDATE_PAYLOADS;
                }
                return this.mUnmodifiedPayloads;
            }
            return FULLUPDATE_PAYLOADS;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            this.clearPayload();
            this.mWasImportantForAccessibilityBeforeHidden = 0;
            this.mPendingAccessibilityState = -1;
            RecyclerView.clearNestedRecyclerViewIfNotNested(this);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$onEnteredHiddenState(RecyclerView parent) {
            this.mWasImportantForAccessibilityBeforeHidden = this.itemView.getImportantForAccessibility();
            parent.setChildImportantForAccessibilityInternal(this, 4);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$onLeftHiddenState(RecyclerView parent) {
            parent.setChildImportantForAccessibilityInternal(this, this.mWasImportantForAccessibilityBeforeHidden);
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        private final String $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$toString() {
            StringBuilder sb = new StringBuilder("ViewHolder{" + Integer.toHexString(this.hashCode()) + " position=" + this.mPosition + " id=" + this.mItemId + ", oldPos=" + this.mOldPosition + ", pLpos:" + this.mPreLayoutPosition);
            if (this.isScrap()) {
                sb.append(" scrap ").append(this.mInChangeScrap ? "[changeScrap]" : "[attachedScrap]");
            }
            if (this.isInvalid()) {
                sb.append(" invalid");
            }
            if (!this.isBound()) {
                sb.append(" unbound");
            }
            if (this.needsUpdate()) {
                sb.append(" update");
            }
            if (this.isRemoved()) {
                sb.append(" removed");
            }
            if (this.shouldIgnore()) {
                sb.append(" ignored");
            }
            if (this.isTmpDetached()) {
                sb.append(" tmpDetached");
            }
            if (!this.isRecyclable()) {
                sb.append(" not recyclable(" + this.mIsRecyclableCount + ")");
            }
            if (this.isAdapterPositionUnknown()) {
                sb.append(" undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                sb.append(" no parent");
            }
            sb.append("}");
            return sb.toString();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setIsRecyclable(boolean recyclable) {
            int n = this.mIsRecyclableCount = recyclable ? this.mIsRecyclableCount - 1 : this.mIsRecyclableCount + 1;
            if (this.mIsRecyclableCount < 0) {
                this.mIsRecyclableCount = 0;
                Log.e("View", "isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this);
            } else if (!recyclable && this.mIsRecyclableCount == 1) {
                this.mFlags |= 0x10;
            } else if (recyclable && this.mIsRecyclableCount == 0) {
                this.mFlags &= 0xFFFFFFEF;
            }
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isRecyclable() {
            return (this.mFlags & 0x10) == 0 && !this.itemView.hasTransientState();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$shouldBeKeptAsChild() {
            return (this.mFlags & 0x10) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$doesTransientStatePreventRecycling() {
            return (this.mFlags & 0x10) == 0 && this.itemView.hasTransientState();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isUpdated() {
            return (this.mFlags & 2) != 0;
        }

        static void __staticInitializer__() {
            FULLUPDATE_PAYLOADS = Collections.EMPTY_LIST;
        }

        private void __constructor__(View view) {
            this.$$robo$$com_android_internal_widget_RecyclerView_ViewHolder$__constructor__(view);
        }

        public ViewHolder(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$__constructor__(android.view.View ), this, view);
        }

        void flagRemovedAndOffsetPosition(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("flagRemovedAndOffsetPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$flagRemovedAndOffsetPosition(int int boolean ), this, n, n2, bl);
        }

        void offsetPosition(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("offsetPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$offsetPosition(int boolean ), this, n, bl);
        }

        void clearOldPosition() {
            InvokeDynamicSupport.bootstrap("clearOldPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearOldPosition(), this);
        }

        void saveOldPosition() {
            InvokeDynamicSupport.bootstrap("saveOldPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$saveOldPosition(), this);
        }

        boolean shouldIgnore() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldIgnore", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$shouldIgnore(), this);
        }

        @Deprecated
        public int getPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getPosition(), this);
        }

        public int getLayoutPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getLayoutPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getLayoutPosition(), this);
        }

        public int getAdapterPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getAdapterPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getAdapterPosition(), this);
        }

        public int getOldPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getOldPosition", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getOldPosition(), this);
        }

        public long getItemId() {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getItemId(), this);
        }

        public int getItemViewType() {
            return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getItemViewType(), this);
        }

        boolean isScrap() {
            return (boolean)InvokeDynamicSupport.bootstrap("isScrap", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isScrap(), this);
        }

        void unScrap() {
            InvokeDynamicSupport.bootstrap("unScrap", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$unScrap(), this);
        }

        boolean wasReturnedFromScrap() {
            return (boolean)InvokeDynamicSupport.bootstrap("wasReturnedFromScrap", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$wasReturnedFromScrap(), this);
        }

        void clearReturnedFromScrapFlag() {
            InvokeDynamicSupport.bootstrap("clearReturnedFromScrapFlag", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearReturnedFromScrapFlag(), this);
        }

        void clearTmpDetachFlag() {
            InvokeDynamicSupport.bootstrap("clearTmpDetachFlag", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearTmpDetachFlag(), this);
        }

        void stopIgnoring() {
            InvokeDynamicSupport.bootstrap("stopIgnoring", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$stopIgnoring(), this);
        }

        void setScrapContainer(Recycler recycler, boolean bl) {
            InvokeDynamicSupport.bootstrap("setScrapContainer", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setScrapContainer(com.android.internal.widget.RecyclerView$Recycler boolean ), this, recycler, bl);
        }

        boolean isInvalid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInvalid", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isInvalid(), this);
        }

        boolean needsUpdate() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsUpdate", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$needsUpdate(), this);
        }

        boolean isBound() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBound", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isBound(), this);
        }

        boolean isRemoved() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRemoved", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isRemoved(), this);
        }

        boolean hasAnyOfTheFlags(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasAnyOfTheFlags", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$hasAnyOfTheFlags(int ), this, n);
        }

        boolean isTmpDetached() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTmpDetached", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isTmpDetached(), this);
        }

        boolean isAdapterPositionUnknown() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAdapterPositionUnknown", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isAdapterPositionUnknown(), this);
        }

        void setFlags(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setFlags", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setFlags(int int ), this, n, n2);
        }

        void addFlags(int n) {
            InvokeDynamicSupport.bootstrap("addFlags", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$addFlags(int ), this, n);
        }

        void addChangePayload(Object object) {
            InvokeDynamicSupport.bootstrap("addChangePayload", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$addChangePayload(java.lang.Object ), this, object);
        }

        private void createPayloadsIfNeeded() {
            InvokeDynamicSupport.bootstrap("createPayloadsIfNeeded", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$createPayloadsIfNeeded(), this);
        }

        void clearPayload() {
            InvokeDynamicSupport.bootstrap("clearPayload", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$clearPayload(), this);
        }

        List<Object> getUnmodifiedPayloads() {
            return InvokeDynamicSupport.bootstrap("getUnmodifiedPayloads", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$getUnmodifiedPayloads(), this);
        }

        void resetInternal() {
            InvokeDynamicSupport.bootstrap("resetInternal", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$resetInternal(), this);
        }

        private void onEnteredHiddenState(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onEnteredHiddenState", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$onEnteredHiddenState(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        private void onLeftHiddenState(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onLeftHiddenState", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$onLeftHiddenState(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$toString(), this);
        }

        public void setIsRecyclable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setIsRecyclable", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$setIsRecyclable(boolean ), this, bl);
        }

        public boolean isRecyclable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRecyclable", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isRecyclable(), this);
        }

        private boolean shouldBeKeptAsChild() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldBeKeptAsChild", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$shouldBeKeptAsChild(), this);
        }

        private boolean doesTransientStatePreventRecycling() {
            return (boolean)InvokeDynamicSupport.bootstrap("doesTransientStatePreventRecycling", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$doesTransientStatePreventRecycling(), this);
        }

        boolean isUpdated() {
            return (boolean)InvokeDynamicSupport.bootstrap("isUpdated", $$robo$$com_android_internal_widget_RecyclerView_ViewHolder$isUpdated(), this);
        }

        static {
            RobolectricInternals.classInitializing(ViewHolder.class);
        }

        public /* synthetic */ ViewHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnChildAttachStateChangeListener {
        public void onChildViewAttachedToWindow(View var1);

        public void onChildViewDetachedFromWindow(View var1);
    }

    public static interface RecyclerListener {
        public void onViewRecycled(ViewHolder var1);
    }

    public static abstract class OnScrollListener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$onScrollStateChanged(RecyclerView recyclerView, int newState) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$onScrolled(RecyclerView recyclerView, int dx, int dy) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$__constructor__();
        }

        public OnScrollListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$__constructor__(), this);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int n) {
            InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$onScrollStateChanged(com.android.internal.widget.RecyclerView int ), this, recyclerView, n);
        }

        public void onScrolled(RecyclerView recyclerView, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onScrolled", $$robo$$com_android_internal_widget_RecyclerView_OnScrollListener$onScrolled(com.android.internal.widget.RecyclerView int int ), this, recyclerView, n, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnScrollListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleOnItemTouchListener
    implements OnItemTouchListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$__constructor__() {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onTouchEvent(RecyclerView rv, MotionEvent e) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$__constructor__();
        }

        public SimpleOnItemTouchListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$__constructor__(), this);
        }

        @Override
        public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onInterceptTouchEvent(com.android.internal.widget.RecyclerView android.view.MotionEvent ), this, recyclerView, motionEvent);
        }

        @Override
        public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onTouchEvent(com.android.internal.widget.RecyclerView android.view.MotionEvent ), this, recyclerView, motionEvent);
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean bl) {
            InvokeDynamicSupport.bootstrap("onRequestDisallowInterceptTouchEvent", $$robo$$com_android_internal_widget_RecyclerView_SimpleOnItemTouchListener$onRequestDisallowInterceptTouchEvent(boolean ), this, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleOnItemTouchListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(RecyclerView var1, MotionEvent var2);

        public void onTouchEvent(RecyclerView var1, MotionEvent var2);

        public void onRequestDisallowInterceptTouchEvent(boolean var1);
    }

    public static abstract class ItemDecoration
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDraw(Canvas c, RecyclerView parent, State state) {
            this.onDraw(c, parent);
        }

        @Deprecated
        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDraw(Canvas c, RecyclerView parent) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDrawOver(Canvas c, RecyclerView parent, State state) {
            this.onDrawOver(c, parent);
        }

        @Deprecated
        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDrawOver(Canvas c, RecyclerView parent) {
        }

        @Deprecated
        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$getItemOffsets(Rect outRect, int itemPosition, RecyclerView parent) {
            outRect.set(0, 0, 0, 0);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$getItemOffsets(Rect outRect, View view, RecyclerView parent, State state) {
            this.getItemOffsets(outRect, ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition(), parent);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$__constructor__();
        }

        public ItemDecoration() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$__constructor__(), this);
        }

        public void onDraw(Canvas canvas, RecyclerView recyclerView, State state) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDraw(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), this, canvas, recyclerView, state);
        }

        @Deprecated
        public void onDraw(Canvas canvas, RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDraw(android.graphics.Canvas com.android.internal.widget.RecyclerView ), this, canvas, recyclerView);
        }

        public void onDrawOver(Canvas canvas, RecyclerView recyclerView, State state) {
            InvokeDynamicSupport.bootstrap("onDrawOver", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDrawOver(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), this, canvas, recyclerView, state);
        }

        @Deprecated
        public void onDrawOver(Canvas canvas, RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onDrawOver", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$onDrawOver(android.graphics.Canvas com.android.internal.widget.RecyclerView ), this, canvas, recyclerView);
        }

        @Deprecated
        public void getItemOffsets(Rect rect, int n, RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("getItemOffsets", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$getItemOffsets(android.graphics.Rect int com.android.internal.widget.RecyclerView ), this, rect, n, recyclerView);
        }

        public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, State state) {
            InvokeDynamicSupport.bootstrap("getItemOffsets", $$robo$$com_android_internal_widget_RecyclerView_ItemDecoration$getItemOffsets(android.graphics.Rect android.view.View com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), this, rect, view, recyclerView, state);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemDecoration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class LayoutManager
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ChildHelper mChildHelper;
        RecyclerView mRecyclerView;
        SmoothScroller mSmoothScroller;
        boolean mRequestedSimpleAnimations;
        boolean mIsAttachedToWindow;
        boolean mAutoMeasure;
        private boolean mMeasurementCacheEnabled;
        private boolean mItemPrefetchEnabled;
        int mPrefetchMaxCountObserved;
        boolean mPrefetchMaxObservedInInitialPrefetch;
        private int mWidthMode;
        private int mHeightMode;
        private int mWidth;
        private int mHeight;

        private void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$__constructor__() {
            this.mRequestedSimpleAnimations = false;
            this.mIsAttachedToWindow = false;
            this.mAutoMeasure = false;
            this.mMeasurementCacheEnabled = true;
            this.mItemPrefetchEnabled = true;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setRecyclerView(RecyclerView recyclerView) {
            if (recyclerView == null) {
                this.mRecyclerView = null;
                this.mChildHelper = null;
                this.mWidth = 0;
                this.mHeight = 0;
            } else {
                this.mRecyclerView = recyclerView;
                this.mChildHelper = recyclerView.mChildHelper;
                this.mWidth = recyclerView.getWidth();
                this.mHeight = recyclerView.getHeight();
            }
            this.mWidthMode = 0x40000000;
            this.mHeightMode = 0x40000000;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasureSpecs(int wSpec, int hSpec) {
            this.mWidth = View.MeasureSpec.getSize(wSpec);
            this.mWidthMode = View.MeasureSpec.getMode(wSpec);
            if (this.mWidthMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mWidth = 0;
            }
            this.mHeight = View.MeasureSpec.getSize(hSpec);
            this.mHeightMode = View.MeasureSpec.getMode(hSpec);
            if (this.mHeightMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mHeight = 0;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimensionFromChildren(int widthSpec, int heightSpec) {
            int count = this.getChildCount();
            if (count == 0) {
                this.mRecyclerView.defaultOnMeasure(widthSpec, heightSpec);
                return;
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                Rect bounds = this.mRecyclerView.mTempRect;
                this.getDecoratedBoundsWithMargins(child, bounds);
                if (bounds.left < minX) {
                    minX = bounds.left;
                }
                if (bounds.right > maxX) {
                    maxX = bounds.right;
                }
                if (bounds.top < minY) {
                    minY = bounds.top;
                }
                if (bounds.bottom <= maxY) continue;
                maxY = bounds.bottom;
            }
            this.mRecyclerView.mTempRect.set(minX, minY, maxX, maxY);
            this.setMeasuredDimension(this.mRecyclerView.mTempRect, widthSpec, heightSpec);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimension(Rect childrenBounds, int wSpec, int hSpec) {
            int usedWidth = childrenBounds.width() + this.getPaddingLeft() + this.getPaddingRight();
            int usedHeight = childrenBounds.height() + this.getPaddingTop() + this.getPaddingBottom();
            int width = LayoutManager.chooseSize(wSpec, usedWidth, this.getMinimumWidth());
            int height = LayoutManager.chooseSize(hSpec, usedHeight, this.getMinimumHeight());
            this.setMeasuredDimension(width, height);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestLayout() {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.requestLayout();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$assertInLayoutOrScroll(String message) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertInLayoutOrScroll(message);
            }
        }

        private static final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$chooseSize(int spec, int desired, int min) {
            int mode = View.MeasureSpec.getMode(spec);
            int size = View.MeasureSpec.getSize(spec);
            switch (mode) {
                case 0x40000000: {
                    return size;
                }
                case -2147483648: {
                    return Math.min(size, Math.max(desired, min));
                }
            }
            return Math.max(desired, min);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$assertNotInLayoutOrScroll(String message) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertNotInLayoutOrScroll(message);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setAutoMeasureEnabled(boolean enabled) {
            this.mAutoMeasure = enabled;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isAutoMeasureEnabled() {
            return this.mAutoMeasure;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$supportsPredictiveItemAnimations() {
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setItemPrefetchEnabled(boolean enabled) {
            if (enabled != this.mItemPrefetchEnabled) {
                this.mItemPrefetchEnabled = enabled;
                this.mPrefetchMaxCountObserved = 0;
                if (this.mRecyclerView != null) {
                    this.mRecyclerView.mRecycler.updateViewCacheSize();
                }
            }
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isItemPrefetchEnabled() {
            return this.mItemPrefetchEnabled;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$collectAdjacentPrefetchPositions(int dx, int dy, State state, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$collectInitialPrefetchPositions(int adapterItemCount, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$dispatchAttachedToWindow(RecyclerView view) {
            this.mIsAttachedToWindow = true;
            this.onAttachedToWindow(view);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$dispatchDetachedFromWindow(RecyclerView view, Recycler recycler) {
            this.mIsAttachedToWindow = false;
            this.onDetachedFromWindow(view, recycler);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isAttachedToWindow() {
            return this.mIsAttachedToWindow;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$postOnAnimation(Runnable action) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.postOnAnimation(action);
            }
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeCallbacks(Runnable action) {
            if (this.mRecyclerView != null) {
                return this.mRecyclerView.removeCallbacks(action);
            }
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAttachedToWindow(RecyclerView view) {
        }

        @Deprecated
        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onDetachedFromWindow(RecyclerView view) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onDetachedFromWindow(RecyclerView view, Recycler recycler) {
            this.onDetachedFromWindow(view);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getClipToPadding() {
            return this.mRecyclerView != null && this.mRecyclerView.mClipToPadding;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onLayoutChildren(Recycler recycler, State state) {
            Log.e("RecyclerView", "You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onLayoutCompleted(State state) {
        }

        public abstract LayoutParams generateDefaultLayoutParams();

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$checkLayoutParams(LayoutParams lp) {
            return lp != null;
        }

        private final LayoutParams $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
            return new LayoutParams(lp);
        }

        private final LayoutParams $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$generateLayoutParams(Context c, AttributeSet attrs) {
            return new LayoutParams(c, attrs);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollHorizontallyBy(int dx, Recycler recycler, State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollVerticallyBy(int dy, Recycler recycler, State state) {
            return 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$canScrollHorizontally() {
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$canScrollVertically() {
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollToPosition(int position) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$smoothScrollToPosition(RecyclerView recyclerView, State state, int position) {
            Log.e("RecyclerView", "You must override smoothScrollToPosition to support smooth scrolling");
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$startSmoothScroll(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller != null && smoothScroller != this.mSmoothScroller && this.mSmoothScroller.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isSmoothScrolling() {
            return this.mSmoothScroller != null && this.mSmoothScroller.isRunning();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getLayoutDirection() {
            return this.mRecyclerView.getLayoutDirection();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$endAnimation(View view) {
            if (this.mRecyclerView.mItemAnimator != null) {
                this.mRecyclerView.mItemAnimator.endAnimation(RecyclerView.getChildViewHolderInt(view));
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addDisappearingView(View child) {
            this.addDisappearingView(child, -1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addDisappearingView(View child, int index) {
            this.addViewInt(child, index, true);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addView(View child) {
            this.addView(child, -1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addView(View child, int index) {
            this.addViewInt(child, index, false);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addViewInt(View child, int index, boolean disappearing) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
            if (disappearing || holder.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(holder);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(holder);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (holder.wasReturnedFromScrap() || holder.isScrap()) {
                if (holder.isScrap()) {
                    holder.unScrap();
                } else {
                    holder.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.attachViewToParent(child, index, child.getLayoutParams(), false);
            } else if (child.getParent() == this.mRecyclerView) {
                int currentIndex = this.mChildHelper.indexOfChild(child);
                if (index == -1) {
                    index = this.mChildHelper.getChildCount();
                }
                if (currentIndex == -1) {
                    throw new IllegalStateException("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:" + this.mRecyclerView.indexOfChild(child));
                }
                if (currentIndex != index) {
                    this.mRecyclerView.mLayout.moveView(currentIndex, index);
                }
            } else {
                this.mChildHelper.addView(child, index, false);
                lp.mInsetsDirty = true;
                if (this.mSmoothScroller != null && this.mSmoothScroller.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(child);
                }
            }
            if (lp.mPendingInvalidate) {
                holder.itemView.invalidate();
                lp.mPendingInvalidate = false;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeView(View child) {
            this.mChildHelper.removeView(child);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeViewAt(int index) {
            View child = this.getChildAt(index);
            if (child != null) {
                this.mChildHelper.removeViewAt(index);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAllViews() {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                this.mChildHelper.removeViewAt(i);
            }
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getBaseline() {
            return -1;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPosition(View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getItemViewType(View view) {
            return RecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$findContainingItemView(View view) {
            if (this.mRecyclerView == null) {
                return null;
            }
            View found = this.mRecyclerView.findContainingItemView(view);
            if (found == null) {
                return null;
            }
            if (this.mChildHelper.isHidden(found)) {
                return null;
            }
            return found;
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$findViewByPosition(int position) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh == null || vh.getLayoutPosition() != position || vh.shouldIgnore() || !this.mRecyclerView.mState.isPreLayout() && vh.isRemoved()) continue;
                return child;
            }
            return null;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachView(View child) {
            int ind = this.mChildHelper.indexOfChild(child);
            if (ind >= 0) {
                this.detachViewInternal(ind, child);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachViewAt(int index) {
            this.detachViewInternal(index, this.getChildAt(index));
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachViewInternal(int index, View view) {
            this.mChildHelper.detachViewFromParent(index);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(View child, int index, LayoutParams lp) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
            if (vh.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(vh);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(vh);
            }
            this.mChildHelper.attachViewToParent(child, index, lp, vh.isRemoved());
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(View child, int index) {
            this.attachView(child, index, (LayoutParams)child.getLayoutParams());
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(View child) {
            this.attachView(child, -1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeDetachedView(View child) {
            this.mRecyclerView.removeDetachedView(child, false);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$moveView(int fromIndex, int toIndex) {
            View view = this.getChildAt(fromIndex);
            if (view == null) {
                throw new IllegalArgumentException("Cannot move a child from non-existing index:" + fromIndex);
            }
            this.detachViewAt(fromIndex);
            this.attachView(view, toIndex);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapView(View child, Recycler recycler) {
            int index = this.mChildHelper.indexOfChild(child);
            this.scrapOrRecycleView(recycler, index, child);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapViewAt(int index, Recycler recycler) {
            View child = this.getChildAt(index);
            this.scrapOrRecycleView(recycler, index, child);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleView(View child, Recycler recycler) {
            this.removeView(child);
            recycler.recycleView(child);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleViewAt(int index, Recycler recycler) {
            View view = this.getChildAt(index);
            this.removeViewAt(index);
            recycler.recycleView(view);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildCount() {
            return this.mChildHelper != null ? this.mChildHelper.getChildCount() : 0;
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildAt(int index) {
            return this.mChildHelper != null ? this.mChildHelper.getChildAt(index) : null;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getWidthMode() {
            return this.mWidthMode;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getHeightMode() {
            return this.mHeightMode;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getWidth() {
            return this.mWidth;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getHeight() {
            return this.mHeight;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingLeft() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingLeft() : 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingTop() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingTop() : 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingRight() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingRight() : 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingBottom() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingBottom() : 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingStart() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingStart() : 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingEnd() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingEnd() : 0;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isFocused() {
            return this.mRecyclerView != null && this.mRecyclerView.isFocused();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$hasFocus() {
            return this.mRecyclerView != null && this.mRecyclerView.hasFocus();
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getFocusedChild() {
            if (this.mRecyclerView == null) {
                return null;
            }
            View focused = this.mRecyclerView.getFocusedChild();
            if (focused == null || this.mChildHelper.isHidden(focused)) {
                return null;
            }
            return focused;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getItemCount() {
            Adapter a = this.mRecyclerView != null ? this.mRecyclerView.getAdapter() : null;
            return a != null ? a.getItemCount() : 0;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$offsetChildrenHorizontal(int dx) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenHorizontal(dx);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$offsetChildrenVertical(int dy) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenVertical(dy);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$ignoreView(View view) {
            if (view.getParent() != this.mRecyclerView || this.mRecyclerView.indexOfChild(view) == -1) {
                throw new IllegalArgumentException("View should be fully attached to be ignored");
            }
            ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
            vh.addFlags(128);
            this.mRecyclerView.mViewInfoStore.removeViewHolder(vh);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$stopIgnoringView(View view) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
            vh.stopIgnoring();
            vh.resetInternal();
            vh.addFlags(4);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapAttachedViews(Recycler recycler) {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                this.scrapOrRecycleView(recycler, i, v);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrapOrRecycleView(Recycler recycler, int index, View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.shouldIgnore()) {
                return;
            }
            if (viewHolder.isInvalid() && !viewHolder.isRemoved() && !this.mRecyclerView.mAdapter.hasStableIds()) {
                this.removeViewAt(index);
                recycler.recycleViewHolderInternal(viewHolder);
            } else {
                this.detachViewAt(index);
                recycler.scrapView(view);
                this.mRecyclerView.mViewInfoStore.onViewDetached(viewHolder);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleScrapInt(Recycler recycler) {
            int scrapCount = recycler.getScrapCount();
            for (int i = scrapCount - 1; i >= 0; --i) {
                View scrap = recycler.getScrapViewAt(i);
                ViewHolder vh = RecyclerView.getChildViewHolderInt(scrap);
                if (vh.shouldIgnore()) continue;
                vh.setIsRecyclable(false);
                if (vh.isTmpDetached()) {
                    this.mRecyclerView.removeDetachedView(scrap, false);
                }
                if (this.mRecyclerView.mItemAnimator != null) {
                    this.mRecyclerView.mItemAnimator.endAnimation(vh);
                }
                vh.setIsRecyclable(true);
                recycler.quickRecycleScrapView(scrap);
            }
            recycler.clearScrap();
            if (scrapCount > 0) {
                this.mRecyclerView.invalidate();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$measureChild(View child, int widthUsed, int heightUsed) {
            int heightSpec;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(child, widthSpec, heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically()), lp)) {
                child.measure(widthSpec, heightSpec);
            }
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldReMeasureChild(View child, int widthSpec, int heightSpec, LayoutParams lp) {
            return !this.mMeasurementCacheEnabled || !LayoutManager.isMeasurementUpToDate(child.getMeasuredWidth(), widthSpec, lp.width) || !LayoutManager.isMeasurementUpToDate(child.getMeasuredHeight(), heightSpec, lp.height);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldMeasureChild(View child, int widthSpec, int heightSpec, LayoutParams lp) {
            return child.isLayoutRequested() || !this.mMeasurementCacheEnabled || !LayoutManager.isMeasurementUpToDate(child.getWidth(), widthSpec, lp.width) || !LayoutManager.isMeasurementUpToDate(child.getHeight(), heightSpec, lp.height);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isMeasurementCacheEnabled() {
            return this.mMeasurementCacheEnabled;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasurementCacheEnabled(boolean measurementCacheEnabled) {
            this.mMeasurementCacheEnabled = measurementCacheEnabled;
        }

        private static final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isMeasurementUpToDate(int childSize, int spec, int dimension) {
            int specMode = View.MeasureSpec.getMode(spec);
            int specSize = View.MeasureSpec.getSize(spec);
            if (dimension > 0 && childSize != dimension) {
                return false;
            }
            switch (specMode) {
                case 0: {
                    return true;
                }
                case -2147483648: {
                    return specSize >= childSize;
                }
                case 0x40000000: {
                    return specSize == childSize;
                }
            }
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$measureChildWithMargins(View child, int widthUsed, int heightUsed) {
            int heightSpec;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(child, widthSpec, heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically()), lp)) {
                child.measure(widthSpec, heightSpec);
            }
        }

        @Deprecated
        private static final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildMeasureSpec(int parentSize, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = 0x40000000;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
            }
            return View.MeasureSpec.makeMeasureSpec(resultSize, resultMode);
        }

        private static final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildMeasureSpec(int parentSize, int parentMode, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else if (childDimension == -1) {
                    switch (parentMode) {
                        case -2147483648: 
                        case 0x40000000: {
                            resultSize = size;
                            resultMode = parentMode;
                            break;
                        }
                        case 0: {
                            resultSize = 0;
                            resultMode = 0;
                        }
                    }
                } else if (childDimension == -2) {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = parentMode;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = parentMode == Integer.MIN_VALUE || parentMode == 0x40000000 ? Integer.MIN_VALUE : 0;
            }
            return View.MeasureSpec.makeMeasureSpec(resultSize, resultMode);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedMeasuredWidth(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredWidth() + insets.left + insets.right;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedMeasuredHeight(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredHeight() + insets.top + insets.bottom;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$layoutDecorated(View child, int left, int top, int right, int bottom) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            child.layout(left + insets.left, top + insets.top, right - insets.right, bottom - insets.bottom);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$layoutDecoratedWithMargins(View child, int left, int top, int right, int bottom) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = lp.mDecorInsets;
            child.layout(left + insets.left + lp.leftMargin, top + insets.top + lp.topMargin, right - insets.right - lp.rightMargin, bottom - insets.bottom - lp.bottomMargin);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getTransformedBoundingBox(View child, boolean includeDecorInsets, Rect out) {
            Matrix childMatrix;
            if (includeDecorInsets) {
                Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
                out.set(-insets.left, -insets.top, child.getWidth() + insets.right, child.getHeight() + insets.bottom);
            } else {
                out.set(0, 0, child.getWidth(), child.getHeight());
            }
            if (this.mRecyclerView != null && (childMatrix = child.getMatrix()) != null && !childMatrix.isIdentity()) {
                RectF tempRectF = this.mRecyclerView.mTempRectF;
                tempRectF.set(out);
                childMatrix.mapRect(tempRectF);
                out.set((int)Math.floor(tempRectF.left), (int)Math.floor(tempRectF.top), (int)Math.ceil(tempRectF.right), (int)Math.ceil(tempRectF.bottom));
            }
            out.offset(child.getLeft(), child.getTop());
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedBoundsWithMargins(View view, Rect outBounds) {
            RecyclerView.getDecoratedBoundsWithMarginsInt(view, outBounds);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedLeft(View child) {
            return child.getLeft() - this.getLeftDecorationWidth(child);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedTop(View child) {
            return child.getTop() - this.getTopDecorationHeight(child);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedRight(View child) {
            return child.getRight() + this.getRightDecorationWidth(child);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedBottom(View child) {
            return child.getBottom() + this.getBottomDecorationHeight(child);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$calculateItemDecorationsForChild(View child, Rect outRect) {
            if (this.mRecyclerView == null) {
                outRect.set(0, 0, 0, 0);
                return;
            }
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            outRect.set(insets);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getTopDecorationHeight(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.top;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getBottomDecorationHeight(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.bottom;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getLeftDecorationWidth(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.left;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getRightDecorationWidth(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.right;
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onFocusSearchFailed(View focused, int direction, Recycler recycler, State state) {
            return null;
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInterceptFocusSearch(View focused, int direction) {
            return null;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestChildRectangleOnScreen(RecyclerView parent, View child, Rect rect, boolean immediate) {
            int dy;
            int parentLeft = this.getPaddingLeft();
            int parentTop = this.getPaddingTop();
            int parentRight = this.getWidth() - this.getPaddingRight();
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            int childLeft = child.getLeft() + rect.left - child.getScrollX();
            int childTop = child.getTop() + rect.top - child.getScrollY();
            int childRight = childLeft + rect.width();
            int childBottom = childTop + rect.height();
            int offScreenLeft = Math.min(0, childLeft - parentLeft);
            int offScreenTop = Math.min(0, childTop - parentTop);
            int offScreenRight = Math.max(0, childRight - parentRight);
            int offScreenBottom = Math.max(0, childBottom - parentBottom);
            int dx = this.getLayoutDirection() == 1 ? (offScreenRight != 0 ? offScreenRight : Math.max(offScreenLeft, childRight - parentRight)) : (offScreenLeft != 0 ? offScreenLeft : Math.min(childLeft - parentLeft, offScreenRight));
            int n = dy = offScreenTop != 0 ? offScreenTop : Math.min(childTop - parentTop, offScreenBottom);
            if (dx != 0 || dy != 0) {
                if (immediate) {
                    parent.scrollBy(dx, dy);
                } else {
                    parent.smoothScrollBy(dx, dy);
                }
                return true;
            }
            return false;
        }

        @Deprecated
        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRequestChildFocus(RecyclerView parent, View child, View focused) {
            return this.isSmoothScrolling() || parent.isComputingLayout();
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRequestChildFocus(RecyclerView parent, State state, View child, View focused) {
            return this.onRequestChildFocus(parent, child, focused);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAdapterChanged(Adapter oldAdapter, Adapter newAdapter) {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAddFocusables(RecyclerView recyclerView, ArrayList<View> views, int direction, int focusableMode) {
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsChanged(RecyclerView recyclerView) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
            this.onItemsUpdated(recyclerView, positionStart, itemCount);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollExtent(State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollOffset(State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollRange(State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollExtent(State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollOffset(State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollRange(State state) {
            return 0;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onMeasure(Recycler recycler, State state, int widthSpec, int heightSpec) {
            this.mRecyclerView.defaultOnMeasure(widthSpec, heightSpec);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimension(int widthSize, int heightSize) {
            this.mRecyclerView.setMeasuredDimension(widthSize, heightSize);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getMinimumWidth() {
            return this.mRecyclerView.getMinimumWidth();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getMinimumHeight() {
            return this.mRecyclerView.getMinimumHeight();
        }

        private final Parcelable $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onSaveInstanceState() {
            return null;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRestoreInstanceState(Parcelable state) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$stopSmoothScroller() {
            if (this.mSmoothScroller != null) {
                this.mSmoothScroller.stop();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onScrollStateChanged(int state) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleAllViews(Recycler recycler) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View view = this.getChildAt(i);
                if (RecyclerView.getChildViewHolderInt(view).shouldIgnore()) continue;
                this.removeAndRecycleViewAt(i, recycler);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            this.onInitializeAccessibilityNodeInfo(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, info);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfo(Recycler recycler, State state, AccessibilityNodeInfo info) {
            if (this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1)) {
                info.addAction(8192);
                info.setScrollable(true);
            }
            if (this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollHorizontally(1)) {
                info.addAction(4096);
                info.setScrollable(true);
            }
            AccessibilityNodeInfo.CollectionInfo collectionInfo = AccessibilityNodeInfo.CollectionInfo.obtain(this.getRowCountForAccessibility(recycler, state), this.getColumnCountForAccessibility(recycler, state), this.isLayoutHierarchical(recycler, state), this.getSelectionModeForAccessibility(recycler, state));
            info.setCollectionInfo(collectionInfo);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityEvent(AccessibilityEvent event) {
            this.onInitializeAccessibilityEvent(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, event);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityEvent(Recycler recycler, State state, AccessibilityEvent event) {
            if (this.mRecyclerView == null || event == null) {
                return;
            }
            event.setScrollable(this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1) || this.mRecyclerView.canScrollHorizontally(1));
            if (this.mRecyclerView.mAdapter != null) {
                event.setItemCount(this.mRecyclerView.mAdapter.getItemCount());
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfoForItem(View host, AccessibilityNodeInfo info) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(host);
            if (vh != null && !vh.isRemoved() && !this.mChildHelper.isHidden(vh.itemView)) {
                this.onInitializeAccessibilityNodeInfoForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, host, info);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfoForItem(Recycler recycler, State state, View host, AccessibilityNodeInfo info) {
            int rowIndexGuess = this.canScrollVertically() ? this.getPosition(host) : 0;
            int columnIndexGuess = this.canScrollHorizontally() ? this.getPosition(host) : 0;
            AccessibilityNodeInfo.CollectionItemInfo itemInfo = AccessibilityNodeInfo.CollectionItemInfo.obtain(rowIndexGuess, 1, columnIndexGuess, 1, false, false);
            info.setCollectionItemInfo(itemInfo);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getSelectionModeForAccessibility(Recycler recycler, State state) {
            return 0;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getRowCountForAccessibility(Recycler recycler, State state) {
            if (this.mRecyclerView == null || this.mRecyclerView.mAdapter == null) {
                return 1;
            }
            return this.canScrollVertically() ? this.mRecyclerView.mAdapter.getItemCount() : 1;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getColumnCountForAccessibility(Recycler recycler, State state) {
            if (this.mRecyclerView == null || this.mRecyclerView.mAdapter == null) {
                return 1;
            }
            return this.canScrollHorizontally() ? this.mRecyclerView.mAdapter.getItemCount() : 1;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isLayoutHierarchical(Recycler recycler, State state) {
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityAction(int action, Bundle args) {
            return this.performAccessibilityAction(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, action, args);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityAction(Recycler recycler, State state, int action, Bundle args) {
            if (this.mRecyclerView == null) {
                return false;
            }
            int vScroll = 0;
            int hScroll = 0;
            switch (action) {
                case 8192: {
                    if (this.mRecyclerView.canScrollVertically(-1)) {
                        vScroll = -(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
                    }
                    if (!this.mRecyclerView.canScrollHorizontally(-1)) break;
                    hScroll = -(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
                    break;
                }
                case 4096: {
                    if (this.mRecyclerView.canScrollVertically(1)) {
                        vScroll = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                    }
                    if (!this.mRecyclerView.canScrollHorizontally(1)) break;
                    hScroll = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                }
            }
            if (vScroll == 0 && hScroll == 0) {
                return false;
            }
            this.mRecyclerView.smoothScrollBy(hScroll, vScroll);
            return true;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityActionForItem(View view, int action, Bundle args) {
            return this.performAccessibilityActionForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, action, args);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityActionForItem(Recycler recycler, State state, View view, int action, Bundle args) {
            return false;
        }

        private static final Properties $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getProperties(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            Properties properties = new Properties();
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyleAttr, defStyleRes);
            properties.orientation = a.getInt(0, 1);
            properties.spanCount = a.getInt(4, 1);
            properties.reverseLayout = a.getBoolean(3, false);
            properties.stackFromEnd = a.getBoolean(5, false);
            a.recycle();
            return properties;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            this.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec(recyclerView.getWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(recyclerView.getHeight(), 0x40000000));
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldMeasureTwice() {
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$hasFlexibleChildInBothOrientations() {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.width >= 0 || lp.height >= 0) continue;
                return true;
            }
            return false;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_LayoutManager$__constructor__();
        }

        public LayoutManager() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$__constructor__(), this);
        }

        void setRecyclerView(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("setRecyclerView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setRecyclerView(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        void setMeasureSpecs(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMeasureSpecs", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasureSpecs(int int ), this, n, n2);
        }

        void setMeasuredDimensionFromChildren(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMeasuredDimensionFromChildren", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimensionFromChildren(int int ), this, n, n2);
        }

        public void setMeasuredDimension(Rect rect, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMeasuredDimension", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimension(android.graphics.Rect int int ), this, rect, n, n2);
        }

        public void requestLayout() {
            InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestLayout(), this);
        }

        public void assertInLayoutOrScroll(String string2) {
            InvokeDynamicSupport.bootstrap("assertInLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$assertInLayoutOrScroll(java.lang.String ), this, string2);
        }

        public static int chooseSize(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("chooseSize", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$chooseSize(int int int ), (int)n, (int)n2, (int)n3);
        }

        public void assertNotInLayoutOrScroll(String string2) {
            InvokeDynamicSupport.bootstrap("assertNotInLayoutOrScroll", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$assertNotInLayoutOrScroll(java.lang.String ), this, string2);
        }

        public void setAutoMeasureEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAutoMeasureEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setAutoMeasureEnabled(boolean ), this, bl);
        }

        public boolean isAutoMeasureEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAutoMeasureEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isAutoMeasureEnabled(), this);
        }

        public boolean supportsPredictiveItemAnimations() {
            return (boolean)InvokeDynamicSupport.bootstrap("supportsPredictiveItemAnimations", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$supportsPredictiveItemAnimations(), this);
        }

        public void setItemPrefetchEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setItemPrefetchEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setItemPrefetchEnabled(boolean ), this, bl);
        }

        public boolean isItemPrefetchEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItemPrefetchEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isItemPrefetchEnabled(), this);
        }

        public void collectAdjacentPrefetchPositions(int n, int n2, State state, LayoutPrefetchRegistry layoutPrefetchRegistry) {
            InvokeDynamicSupport.bootstrap("collectAdjacentPrefetchPositions", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$collectAdjacentPrefetchPositions(int int com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$LayoutManager$LayoutPrefetchRegistry ), this, n, n2, state, layoutPrefetchRegistry);
        }

        public void collectInitialPrefetchPositions(int n, LayoutPrefetchRegistry layoutPrefetchRegistry) {
            InvokeDynamicSupport.bootstrap("collectInitialPrefetchPositions", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$collectInitialPrefetchPositions(int com.android.internal.widget.RecyclerView$LayoutManager$LayoutPrefetchRegistry ), this, n, layoutPrefetchRegistry);
        }

        void dispatchAttachedToWindow(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("dispatchAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$dispatchAttachedToWindow(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        void dispatchDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("dispatchDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$dispatchDetachedFromWindow(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$Recycler ), this, recyclerView, recycler);
        }

        public boolean isAttachedToWindow() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isAttachedToWindow(), this);
        }

        public void postOnAnimation(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("postOnAnimation", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$postOnAnimation(java.lang.Runnable ), this, runnable);
        }

        public boolean removeCallbacks(Runnable runnable) {
            return (boolean)InvokeDynamicSupport.bootstrap("removeCallbacks", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeCallbacks(java.lang.Runnable ), this, runnable);
        }

        public void onAttachedToWindow(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAttachedToWindow(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        @Deprecated
        public void onDetachedFromWindow(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onDetachedFromWindow(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public void onDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onDetachedFromWindow(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$Recycler ), this, recyclerView, recycler);
        }

        public boolean getClipToPadding() {
            return (boolean)InvokeDynamicSupport.bootstrap("getClipToPadding", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getClipToPadding(), this);
        }

        public void onLayoutChildren(Recycler recycler, State state) {
            InvokeDynamicSupport.bootstrap("onLayoutChildren", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onLayoutChildren(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
        }

        public void onLayoutCompleted(State state) {
            InvokeDynamicSupport.bootstrap("onLayoutCompleted", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onLayoutCompleted(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public boolean checkLayoutParams(LayoutParams layoutParams) {
            return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$checkLayoutParams(com.android.internal.widget.RecyclerView$LayoutParams ), this, layoutParams);
        }

        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
            return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        public LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
            return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$generateLayoutParams(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        public int scrollHorizontallyBy(int n, Recycler recycler, State state) {
            return (int)InvokeDynamicSupport.bootstrap("scrollHorizontallyBy", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollHorizontallyBy(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, n, recycler, state);
        }

        public int scrollVerticallyBy(int n, Recycler recycler, State state) {
            return (int)InvokeDynamicSupport.bootstrap("scrollVerticallyBy", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollVerticallyBy(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, n, recycler, state);
        }

        public boolean canScrollHorizontally() {
            return (boolean)InvokeDynamicSupport.bootstrap("canScrollHorizontally", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$canScrollHorizontally(), this);
        }

        public boolean canScrollVertically() {
            return (boolean)InvokeDynamicSupport.bootstrap("canScrollVertically", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$canScrollVertically(), this);
        }

        public void scrollToPosition(int n) {
            InvokeDynamicSupport.bootstrap("scrollToPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrollToPosition(int ), this, n);
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, State state, int n) {
            InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$smoothScrollToPosition(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State int ), this, recyclerView, state, n);
        }

        public void startSmoothScroll(SmoothScroller smoothScroller) {
            InvokeDynamicSupport.bootstrap("startSmoothScroll", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$startSmoothScroll(com.android.internal.widget.RecyclerView$SmoothScroller ), this, smoothScroller);
        }

        public boolean isSmoothScrolling() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSmoothScrolling", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isSmoothScrolling(), this);
        }

        public int getLayoutDirection() {
            return (int)InvokeDynamicSupport.bootstrap("getLayoutDirection", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getLayoutDirection(), this);
        }

        public void endAnimation(View view) {
            InvokeDynamicSupport.bootstrap("endAnimation", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$endAnimation(android.view.View ), this, view);
        }

        public void addDisappearingView(View view) {
            InvokeDynamicSupport.bootstrap("addDisappearingView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addDisappearingView(android.view.View ), this, view);
        }

        public void addDisappearingView(View view, int n) {
            InvokeDynamicSupport.bootstrap("addDisappearingView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addDisappearingView(android.view.View int ), this, view, n);
        }

        public void addView(View view) {
            InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addView(android.view.View ), this, view);
        }

        public void addView(View view, int n) {
            InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addView(android.view.View int ), this, view, n);
        }

        private void addViewInt(View view, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("addViewInt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$addViewInt(android.view.View int boolean ), this, view, n, bl);
        }

        public void removeView(View view) {
            InvokeDynamicSupport.bootstrap("removeView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeView(android.view.View ), this, view);
        }

        public void removeViewAt(int n) {
            InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeViewAt(int ), this, n);
        }

        public void removeAllViews() {
            InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAllViews(), this);
        }

        public int getBaseline() {
            return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getBaseline(), this);
        }

        public int getPosition(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPosition(android.view.View ), this, view);
        }

        public int getItemViewType(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getItemViewType(android.view.View ), this, view);
        }

        public View findContainingItemView(View view) {
            return InvokeDynamicSupport.bootstrap("findContainingItemView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$findContainingItemView(android.view.View ), this, view);
        }

        public View findViewByPosition(int n) {
            return InvokeDynamicSupport.bootstrap("findViewByPosition", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$findViewByPosition(int ), this, n);
        }

        public void detachView(View view) {
            InvokeDynamicSupport.bootstrap("detachView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachView(android.view.View ), this, view);
        }

        public void detachViewAt(int n) {
            InvokeDynamicSupport.bootstrap("detachViewAt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachViewAt(int ), this, n);
        }

        private void detachViewInternal(int n, View view) {
            InvokeDynamicSupport.bootstrap("detachViewInternal", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachViewInternal(int android.view.View ), this, n, view);
        }

        public void attachView(View view, int n, LayoutParams layoutParams) {
            InvokeDynamicSupport.bootstrap("attachView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(android.view.View int com.android.internal.widget.RecyclerView$LayoutParams ), this, view, n, layoutParams);
        }

        public void attachView(View view, int n) {
            InvokeDynamicSupport.bootstrap("attachView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(android.view.View int ), this, view, n);
        }

        public void attachView(View view) {
            InvokeDynamicSupport.bootstrap("attachView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$attachView(android.view.View ), this, view);
        }

        public void removeDetachedView(View view) {
            InvokeDynamicSupport.bootstrap("removeDetachedView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeDetachedView(android.view.View ), this, view);
        }

        public void moveView(int n, int n2) {
            InvokeDynamicSupport.bootstrap("moveView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$moveView(int int ), this, n, n2);
        }

        public void detachAndScrapView(View view, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("detachAndScrapView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapView(android.view.View com.android.internal.widget.RecyclerView$Recycler ), this, view, recycler);
        }

        public void detachAndScrapViewAt(int n, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("detachAndScrapViewAt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapViewAt(int com.android.internal.widget.RecyclerView$Recycler ), this, n, recycler);
        }

        public void removeAndRecycleView(View view, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("removeAndRecycleView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleView(android.view.View com.android.internal.widget.RecyclerView$Recycler ), this, view, recycler);
        }

        public void removeAndRecycleViewAt(int n, Recycler recycler) {
            InvokeDynamicSupport.bootstrap("removeAndRecycleViewAt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleViewAt(int com.android.internal.widget.RecyclerView$Recycler ), this, n, recycler);
        }

        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildCount(), this);
        }

        public View getChildAt(int n) {
            return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildAt(int ), this, n);
        }

        public int getWidthMode() {
            return (int)InvokeDynamicSupport.bootstrap("getWidthMode", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getWidthMode(), this);
        }

        public int getHeightMode() {
            return (int)InvokeDynamicSupport.bootstrap("getHeightMode", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getHeightMode(), this);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getWidth(), this);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getHeight(), this);
        }

        public int getPaddingLeft() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingLeft", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingLeft(), this);
        }

        public int getPaddingTop() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingTop", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingTop(), this);
        }

        public int getPaddingRight() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingRight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingRight(), this);
        }

        public int getPaddingBottom() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingBottom", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingBottom(), this);
        }

        public int getPaddingStart() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingStart", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingStart(), this);
        }

        public int getPaddingEnd() {
            return (int)InvokeDynamicSupport.bootstrap("getPaddingEnd", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getPaddingEnd(), this);
        }

        public boolean isFocused() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFocused", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isFocused(), this);
        }

        public boolean hasFocus() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocus", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$hasFocus(), this);
        }

        public View getFocusedChild() {
            return InvokeDynamicSupport.bootstrap("getFocusedChild", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getFocusedChild(), this);
        }

        public int getItemCount() {
            return (int)InvokeDynamicSupport.bootstrap("getItemCount", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getItemCount(), this);
        }

        public void offsetChildrenHorizontal(int n) {
            InvokeDynamicSupport.bootstrap("offsetChildrenHorizontal", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$offsetChildrenHorizontal(int ), this, n);
        }

        public void offsetChildrenVertical(int n) {
            InvokeDynamicSupport.bootstrap("offsetChildrenVertical", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$offsetChildrenVertical(int ), this, n);
        }

        public void ignoreView(View view) {
            InvokeDynamicSupport.bootstrap("ignoreView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$ignoreView(android.view.View ), this, view);
        }

        public void stopIgnoringView(View view) {
            InvokeDynamicSupport.bootstrap("stopIgnoringView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$stopIgnoringView(android.view.View ), this, view);
        }

        public void detachAndScrapAttachedViews(Recycler recycler) {
            InvokeDynamicSupport.bootstrap("detachAndScrapAttachedViews", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$detachAndScrapAttachedViews(com.android.internal.widget.RecyclerView$Recycler ), this, recycler);
        }

        private void scrapOrRecycleView(Recycler recycler, int n, View view) {
            InvokeDynamicSupport.bootstrap("scrapOrRecycleView", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$scrapOrRecycleView(com.android.internal.widget.RecyclerView$Recycler int android.view.View ), this, recycler, n, view);
        }

        void removeAndRecycleScrapInt(Recycler recycler) {
            InvokeDynamicSupport.bootstrap("removeAndRecycleScrapInt", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleScrapInt(com.android.internal.widget.RecyclerView$Recycler ), this, recycler);
        }

        public void measureChild(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrap("measureChild", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$measureChild(android.view.View int int ), this, view, n, n2);
        }

        boolean shouldReMeasureChild(View view, int n, int n2, LayoutParams layoutParams) {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldReMeasureChild", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldReMeasureChild(android.view.View int int com.android.internal.widget.RecyclerView$LayoutParams ), this, view, n, n2, layoutParams);
        }

        boolean shouldMeasureChild(View view, int n, int n2, LayoutParams layoutParams) {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldMeasureChild", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldMeasureChild(android.view.View int int com.android.internal.widget.RecyclerView$LayoutParams ), this, view, n, n2, layoutParams);
        }

        public boolean isMeasurementCacheEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMeasurementCacheEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isMeasurementCacheEnabled(), this);
        }

        public void setMeasurementCacheEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMeasurementCacheEnabled", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasurementCacheEnabled(boolean ), this, bl);
        }

        private static boolean isMeasurementUpToDate(int n, int n2, int n3) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isMeasurementUpToDate", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isMeasurementUpToDate(int int int ), (int)n, (int)n2, (int)n3);
        }

        public void measureChildWithMargins(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrap("measureChildWithMargins", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$measureChildWithMargins(android.view.View int int ), this, view, n, n2);
        }

        @Deprecated
        public static int getChildMeasureSpec(int n, int n2, int n3, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getChildMeasureSpec", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildMeasureSpec(int int int boolean ), (int)n, (int)n2, (int)n3, (boolean)bl);
        }

        public static int getChildMeasureSpec(int n, int n2, int n3, int n4, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getChildMeasureSpec", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getChildMeasureSpec(int int int int boolean ), (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl);
        }

        public int getDecoratedMeasuredWidth(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedMeasuredWidth", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedMeasuredWidth(android.view.View ), this, view);
        }

        public int getDecoratedMeasuredHeight(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedMeasuredHeight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedMeasuredHeight(android.view.View ), this, view);
        }

        public void layoutDecorated(View view, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("layoutDecorated", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$layoutDecorated(android.view.View int int int int ), this, view, n, n2, n3, n4);
        }

        public void layoutDecoratedWithMargins(View view, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("layoutDecoratedWithMargins", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$layoutDecoratedWithMargins(android.view.View int int int int ), this, view, n, n2, n3, n4);
        }

        public void getTransformedBoundingBox(View view, boolean bl, Rect rect) {
            InvokeDynamicSupport.bootstrap("getTransformedBoundingBox", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getTransformedBoundingBox(android.view.View boolean android.graphics.Rect ), this, view, bl, rect);
        }

        public void getDecoratedBoundsWithMargins(View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("getDecoratedBoundsWithMargins", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedBoundsWithMargins(android.view.View android.graphics.Rect ), this, view, rect);
        }

        public int getDecoratedLeft(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedLeft", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedLeft(android.view.View ), this, view);
        }

        public int getDecoratedTop(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedTop", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedTop(android.view.View ), this, view);
        }

        public int getDecoratedRight(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedRight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedRight(android.view.View ), this, view);
        }

        public int getDecoratedBottom(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getDecoratedBottom", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getDecoratedBottom(android.view.View ), this, view);
        }

        public void calculateItemDecorationsForChild(View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("calculateItemDecorationsForChild", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$calculateItemDecorationsForChild(android.view.View android.graphics.Rect ), this, view, rect);
        }

        public int getTopDecorationHeight(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getTopDecorationHeight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getTopDecorationHeight(android.view.View ), this, view);
        }

        public int getBottomDecorationHeight(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getBottomDecorationHeight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getBottomDecorationHeight(android.view.View ), this, view);
        }

        public int getLeftDecorationWidth(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getLeftDecorationWidth", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getLeftDecorationWidth(android.view.View ), this, view);
        }

        public int getRightDecorationWidth(View view) {
            return (int)InvokeDynamicSupport.bootstrap("getRightDecorationWidth", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getRightDecorationWidth(android.view.View ), this, view);
        }

        public View onFocusSearchFailed(View view, int n, Recycler recycler, State state) {
            return InvokeDynamicSupport.bootstrap("onFocusSearchFailed", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onFocusSearchFailed(android.view.View int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, view, n, recycler, state);
        }

        public View onInterceptFocusSearch(View view, int n) {
            return InvokeDynamicSupport.bootstrap("onInterceptFocusSearch", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInterceptFocusSearch(android.view.View int ), this, view, n);
        }

        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestChildRectangleOnScreen(com.android.internal.widget.RecyclerView android.view.View android.graphics.Rect boolean ), this, recyclerView, view, rect, bl);
        }

        @Deprecated
        public boolean onRequestChildFocus(RecyclerView recyclerView, View view, View view2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onRequestChildFocus", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRequestChildFocus(com.android.internal.widget.RecyclerView android.view.View android.view.View ), this, recyclerView, view, view2);
        }

        public boolean onRequestChildFocus(RecyclerView recyclerView, State state, View view, View view2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onRequestChildFocus", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRequestChildFocus(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State android.view.View android.view.View ), this, recyclerView, state, view, view2);
        }

        public void onAdapterChanged(Adapter adapter, Adapter adapter2) {
            InvokeDynamicSupport.bootstrap("onAdapterChanged", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAdapterChanged(com.android.internal.widget.RecyclerView$Adapter com.android.internal.widget.RecyclerView$Adapter ), this, adapter, adapter2);
        }

        public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> arrayList, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onAddFocusables", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onAddFocusables(com.android.internal.widget.RecyclerView java.util.ArrayList<android.view.View> int int ), this, recyclerView, arrayList, n, n2);
        }

        public void onItemsChanged(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onItemsChanged", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsChanged(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public void onItemsAdded(RecyclerView recyclerView, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemsAdded", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsAdded(com.android.internal.widget.RecyclerView int int ), this, recyclerView, n, n2);
        }

        public void onItemsRemoved(RecyclerView recyclerView, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemsRemoved", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsRemoved(com.android.internal.widget.RecyclerView int int ), this, recyclerView, n, n2);
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemsUpdated", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsUpdated(com.android.internal.widget.RecyclerView int int ), this, recyclerView, n, n2);
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n, int n2, Object object) {
            InvokeDynamicSupport.bootstrap("onItemsUpdated", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsUpdated(com.android.internal.widget.RecyclerView int int java.lang.Object ), this, recyclerView, n, n2, object);
        }

        public void onItemsMoved(RecyclerView recyclerView, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onItemsMoved", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onItemsMoved(com.android.internal.widget.RecyclerView int int int ), this, recyclerView, n, n2, n3);
        }

        public int computeHorizontalScrollExtent(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollExtent", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollExtent(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public int computeHorizontalScrollOffset(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollOffset", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollOffset(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public int computeHorizontalScrollRange(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeHorizontalScrollRange(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public int computeVerticalScrollExtent(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollExtent(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public int computeVerticalScrollOffset(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollOffset(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public int computeVerticalScrollRange(State state) {
            return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$computeVerticalScrollRange(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        public void onMeasure(Recycler recycler, State state, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onMeasure(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State int int ), this, recycler, state, n, n2);
        }

        public void setMeasuredDimension(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMeasuredDimension", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setMeasuredDimension(int int ), this, n, n2);
        }

        public int getMinimumWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getMinimumWidth", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getMinimumWidth(), this);
        }

        public int getMinimumHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getMinimumHeight(), this);
        }

        public Parcelable onSaveInstanceState() {
            return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onSaveInstanceState(), this);
        }

        public void onRestoreInstanceState(Parcelable parcelable) {
            InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
        }

        void stopSmoothScroller() {
            InvokeDynamicSupport.bootstrap("stopSmoothScroller", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$stopSmoothScroller(), this);
        }

        private void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            InvokeDynamicSupport.bootstrap("onSmoothScrollerStopped", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onSmoothScrollerStopped(com.android.internal.widget.RecyclerView$SmoothScroller ), this, smoothScroller);
        }

        public void onScrollStateChanged(int n) {
            InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onScrollStateChanged(int ), this, n);
        }

        public void removeAndRecycleAllViews(Recycler recycler) {
            InvokeDynamicSupport.bootstrap("removeAndRecycleAllViews", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$removeAndRecycleAllViews(com.android.internal.widget.RecyclerView$Recycler ), this, recycler);
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
        }

        public void onInitializeAccessibilityNodeInfo(Recycler recycler, State state, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfo(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State android.view.accessibility.AccessibilityNodeInfo ), this, recycler, state, accessibilityNodeInfo);
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
        }

        public void onInitializeAccessibilityEvent(Recycler recycler, State state, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityEvent(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State android.view.accessibility.AccessibilityEvent ), this, recycler, state, accessibilityEvent);
        }

        void onInitializeAccessibilityNodeInfoForItem(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoForItem", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfoForItem(android.view.View android.view.accessibility.AccessibilityNodeInfo ), this, view, accessibilityNodeInfo);
        }

        public void onInitializeAccessibilityNodeInfoForItem(Recycler recycler, State state, View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoForItem", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$onInitializeAccessibilityNodeInfoForItem(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State android.view.View android.view.accessibility.AccessibilityNodeInfo ), this, recycler, state, view, accessibilityNodeInfo);
        }

        public void requestSimpleAnimationsInNextLayout() {
            InvokeDynamicSupport.bootstrap("requestSimpleAnimationsInNextLayout", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$requestSimpleAnimationsInNextLayout(), this);
        }

        public int getSelectionModeForAccessibility(Recycler recycler, State state) {
            return (int)InvokeDynamicSupport.bootstrap("getSelectionModeForAccessibility", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getSelectionModeForAccessibility(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
        }

        public int getRowCountForAccessibility(Recycler recycler, State state) {
            return (int)InvokeDynamicSupport.bootstrap("getRowCountForAccessibility", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getRowCountForAccessibility(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
        }

        public int getColumnCountForAccessibility(Recycler recycler, State state) {
            return (int)InvokeDynamicSupport.bootstrap("getColumnCountForAccessibility", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getColumnCountForAccessibility(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
        }

        public boolean isLayoutHierarchical(Recycler recycler, State state) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLayoutHierarchical", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$isLayoutHierarchical(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
        }

        boolean performAccessibilityAction(int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityAction(int android.os.Bundle ), this, n, bundle);
        }

        public boolean performAccessibilityAction(Recycler recycler, State state, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityAction(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State int android.os.Bundle ), this, recycler, state, n, bundle);
        }

        boolean performAccessibilityActionForItem(View view, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionForItem", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityActionForItem(android.view.View int android.os.Bundle ), this, view, n, bundle);
        }

        public boolean performAccessibilityActionForItem(Recycler recycler, State state, View view, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionForItem", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$performAccessibilityActionForItem(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State android.view.View int android.os.Bundle ), this, recycler, state, view, n, bundle);
        }

        public static Properties getProperties(Context context, AttributeSet attributeSet, int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("getProperties", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$getProperties(android.content.Context android.util.AttributeSet int int ), (Context)context, (AttributeSet)attributeSet, (int)n, (int)n2);
        }

        void setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("setExactMeasureSpecsFrom", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$setExactMeasureSpecsFrom(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        boolean shouldMeasureTwice() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldMeasureTwice", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$shouldMeasureTwice(), this);
        }

        boolean hasFlexibleChildInBothOrientations() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFlexibleChildInBothOrientations", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager$hasFlexibleChildInBothOrientations(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutManager)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Properties
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public int orientation;
            public int spanCount;
            public boolean reverseLayout;
            public boolean stackFromEnd;

            private void $$robo$$com_android_internal_widget_RecyclerView_LayoutManager_Properties$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_RecyclerView_LayoutManager_Properties$__constructor__();
            }

            public Properties() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_LayoutManager_Properties$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Properties)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface LayoutPrefetchRegistry {
            public void addPosition(int var1, int var2);
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        public /* synthetic */ Object __robo_data__;
        private AdapterDataObservable mObservable;
        private boolean mHasStableIds;

        private void $$robo$$com_android_internal_widget_RecyclerView_Adapter$__constructor__() {
            this.mObservable = new AdapterDataObservable();
            this.mHasStableIds = false;
        }

        public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

        public abstract void onBindViewHolder(VH var1, int var2);

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onBindViewHolder(VH holder, int position, List<Object> payloads) {
            this.onBindViewHolder(holder, position);
        }

        private final VH $$robo$$com_android_internal_widget_RecyclerView_Adapter$createViewHolder(ViewGroup parent, int viewType) {
            Trace.beginSection("RV CreateView");
            VH holder = this.onCreateViewHolder(parent, viewType);
            ((ViewHolder)holder).mItemViewType = viewType;
            Trace.endSection();
            return holder;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$bindViewHolder(VH holder, int position) {
            ((ViewHolder)holder).mPosition = position;
            if (this.hasStableIds()) {
                ((ViewHolder)holder).mItemId = this.getItemId(position);
            }
            ((ViewHolder)holder).setFlags(1, 519);
            Trace.beginSection("RV OnBindView");
            this.onBindViewHolder(holder, position, ((ViewHolder)holder).getUnmodifiedPayloads());
            ((ViewHolder)holder).clearPayload();
            ViewGroup.LayoutParams layoutParams = ((ViewHolder)holder).itemView.getLayoutParams();
            if (layoutParams instanceof LayoutParams) {
                ((LayoutParams)layoutParams).mInsetsDirty = true;
            }
            Trace.endSection();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_Adapter$getItemViewType(int position) {
            return 0;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$setHasStableIds(boolean hasStableIds) {
            if (this.hasObservers()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.mHasStableIds = hasStableIds;
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_Adapter$getItemId(int position) {
            return -1L;
        }

        public abstract int getItemCount();

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_Adapter$hasStableIds() {
            return this.mHasStableIds;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewRecycled(VH holder) {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_Adapter$onFailedToRecycleView(VH holder) {
            return false;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewAttachedToWindow(VH holder) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewDetachedFromWindow(VH holder) {
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_Adapter$hasObservers() {
            return this.mObservable.hasObservers();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$registerAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$unregisterAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.unregisterObserver(observer);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onAttachedToRecyclerView(RecyclerView recyclerView) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$onDetachedFromRecyclerView(RecyclerView recyclerView) {
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemChanged(int position) {
            this.mObservable.notifyItemRangeChanged(position, 1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemChanged(int position, Object payload) {
            this.mObservable.notifyItemRangeChanged(position, 1, payload);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeChanged(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemInserted(int position) {
            this.mObservable.notifyItemRangeInserted(position, 1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemMoved(int fromPosition, int toPosition) {
            this.mObservable.notifyItemMoved(fromPosition, toPosition);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeInserted(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeInserted(positionStart, itemCount);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRemoved(int position) {
            this.mObservable.notifyItemRangeRemoved(position, 1);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeRemoved(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeRemoved(positionStart, itemCount);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_Adapter$__constructor__();
        }

        public Adapter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_Adapter$__constructor__(), this);
        }

        public void onBindViewHolder(VH VH, int n, List<Object> list) {
            InvokeDynamicSupport.bootstrap("onBindViewHolder", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onBindViewHolder(VH int java.util.List<java.lang.Object> ), this, VH, n, list);
        }

        public VH createViewHolder(ViewGroup viewGroup, int n) {
            return (VH)InvokeDynamicSupport.bootstrap("createViewHolder", $$robo$$com_android_internal_widget_RecyclerView_Adapter$createViewHolder(android.view.ViewGroup int ), this, viewGroup, n);
        }

        public void bindViewHolder(VH VH, int n) {
            InvokeDynamicSupport.bootstrap("bindViewHolder", $$robo$$com_android_internal_widget_RecyclerView_Adapter$bindViewHolder(VH int ), this, VH, n);
        }

        public int getItemViewType(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$com_android_internal_widget_RecyclerView_Adapter$getItemViewType(int ), this, n);
        }

        public void setHasStableIds(boolean bl) {
            InvokeDynamicSupport.bootstrap("setHasStableIds", $$robo$$com_android_internal_widget_RecyclerView_Adapter$setHasStableIds(boolean ), this, bl);
        }

        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_widget_RecyclerView_Adapter$getItemId(int ), this, n);
        }

        public boolean hasStableIds() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$com_android_internal_widget_RecyclerView_Adapter$hasStableIds(), this);
        }

        public void onViewRecycled(VH VH) {
            InvokeDynamicSupport.bootstrap("onViewRecycled", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewRecycled(VH ), this, VH);
        }

        public boolean onFailedToRecycleView(VH VH) {
            return (boolean)InvokeDynamicSupport.bootstrap("onFailedToRecycleView", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onFailedToRecycleView(VH ), this, VH);
        }

        public void onViewAttachedToWindow(VH VH) {
            InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewAttachedToWindow(VH ), this, VH);
        }

        public void onViewDetachedFromWindow(VH VH) {
            InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onViewDetachedFromWindow(VH ), this, VH);
        }

        public boolean hasObservers() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasObservers", $$robo$$com_android_internal_widget_RecyclerView_Adapter$hasObservers(), this);
        }

        public void registerAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            InvokeDynamicSupport.bootstrap("registerAdapterDataObserver", $$robo$$com_android_internal_widget_RecyclerView_Adapter$registerAdapterDataObserver(com.android.internal.widget.RecyclerView$AdapterDataObserver ), this, adapterDataObserver);
        }

        public void unregisterAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            InvokeDynamicSupport.bootstrap("unregisterAdapterDataObserver", $$robo$$com_android_internal_widget_RecyclerView_Adapter$unregisterAdapterDataObserver(com.android.internal.widget.RecyclerView$AdapterDataObserver ), this, adapterDataObserver);
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onAttachedToRecyclerView", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onAttachedToRecyclerView(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
            InvokeDynamicSupport.bootstrap("onDetachedFromRecyclerView", $$robo$$com_android_internal_widget_RecyclerView_Adapter$onDetachedFromRecyclerView(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public void notifyDataSetChanged() {
            InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyDataSetChanged(), this);
        }

        public void notifyItemChanged(int n) {
            InvokeDynamicSupport.bootstrap("notifyItemChanged", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemChanged(int ), this, n);
        }

        public void notifyItemChanged(int n, Object object) {
            InvokeDynamicSupport.bootstrap("notifyItemChanged", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemChanged(int java.lang.Object ), this, n, object);
        }

        public void notifyItemRangeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeChanged(int int ), this, n, n2);
        }

        public void notifyItemRangeChanged(int n, int n2, Object object) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeChanged(int int java.lang.Object ), this, n, n2, object);
        }

        public void notifyItemInserted(int n) {
            InvokeDynamicSupport.bootstrap("notifyItemInserted", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemInserted(int ), this, n);
        }

        public void notifyItemMoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemMoved", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemMoved(int int ), this, n, n2);
        }

        public void notifyItemRangeInserted(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeInserted", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeInserted(int int ), this, n, n2);
        }

        public void notifyItemRemoved(int n) {
            InvokeDynamicSupport.bootstrap("notifyItemRemoved", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRemoved(int ), this, n);
        }

        public void notifyItemRangeRemoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("notifyItemRangeRemoved", $$robo$$com_android_internal_widget_RecyclerView_Adapter$notifyItemRangeRemoved(int int ), this, n, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Adapter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ViewCacheExtension
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_RecyclerView_ViewCacheExtension$__constructor__() {
        }

        public abstract View getViewForPositionAndType(Recycler var1, int var2, int var3);

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_ViewCacheExtension$__constructor__();
        }

        public ViewCacheExtension() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ViewCacheExtension$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewCacheExtension)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Recycler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ArrayList<ViewHolder> mAttachedScrap;
        ArrayList<ViewHolder> mChangedScrap;
        ArrayList<ViewHolder> mCachedViews;
        private List<ViewHolder> mUnmodifiableAttachedScrap;
        private int mRequestedCacheMax;
        int mViewCacheMax;
        RecycledViewPool mRecyclerPool;
        private ViewCacheExtension mViewCacheExtension;
        static int DEFAULT_CACHE_SIZE = 2;
        /* synthetic */ RecyclerView this$0;

        private void $$robo$$com_android_internal_widget_RecyclerView_Recycler$__constructor__(RecyclerView this$0) {
            this.this$0 = this$0;
            this.mAttachedScrap = new ArrayList();
            this.mChangedScrap = null;
            this.mCachedViews = new ArrayList();
            this.mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
            this.mRequestedCacheMax = 2;
            this.mViewCacheMax = 2;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$clear() {
            this.mAttachedScrap.clear();
            this.recycleAndClearCachedViews();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$setViewCacheSize(int viewCount) {
            this.mRequestedCacheMax = viewCount;
            this.updateViewCacheSize();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$updateViewCacheSize() {
            int extraCache = this.this$0.mLayout != null ? this.this$0.mLayout.mPrefetchMaxCountObserved : 0;
            this.mViewCacheMax = this.mRequestedCacheMax + extraCache;
            for (int i = this.mCachedViews.size() - 1; i >= 0 && this.mCachedViews.size() > this.mViewCacheMax; --i) {
                this.recycleCachedViewAt(i);
            }
        }

        private final List<ViewHolder> $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_Recycler$validateViewHolderForOffsetPosition(ViewHolder holder) {
            int type;
            if (holder.isRemoved()) {
                return this.this$0.mState.isPreLayout();
            }
            if (holder.mPosition < 0 || holder.mPosition >= this.this$0.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + holder);
            }
            if (!this.this$0.mState.isPreLayout() && (type = this.this$0.mAdapter.getItemViewType(holder.mPosition)) != holder.getItemViewType()) {
                return false;
            }
            if (this.this$0.mAdapter.hasStableIds()) {
                return holder.getItemId() == this.this$0.mAdapter.getItemId(holder.mPosition);
            }
            return true;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_Recycler$tryBindViewHolderByDeadline(ViewHolder holder, int offsetPosition, int position, long deadlineNs) {
            holder.mOwnerRecyclerView = this.this$0;
            int viewType = holder.getItemViewType();
            long startBindNs = this.this$0.getNanoTime();
            if (deadlineNs != Long.MAX_VALUE && !this.mRecyclerPool.willBindInTime(viewType, startBindNs, deadlineNs)) {
                return false;
            }
            this.this$0.mAdapter.bindViewHolder(holder, offsetPosition);
            long endBindNs = this.this$0.getNanoTime();
            this.mRecyclerPool.factorInBindTime(holder.getItemViewType(), endBindNs - startBindNs);
            this.attachAccessibilityDelegate(holder.itemView);
            if (this.this$0.mState.isPreLayout()) {
                holder.mPreLayoutPosition = position;
            }
            return true;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$bindViewToPosition(View view, int position) {
            LayoutParams rvLayoutParams;
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder == null) {
                throw new IllegalArgumentException("The view does not have a ViewHolder. You cannot pass arbitrary views to this method, they should be created by the Adapter");
            }
            int offsetPosition = this.this$0.mAdapterHelper.findPositionOffset(position);
            if (offsetPosition < 0 || offsetPosition >= this.this$0.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ").state:" + this.this$0.mState.getItemCount());
            }
            this.tryBindViewHolderByDeadline(holder, offsetPosition, position, Long.MAX_VALUE);
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp == null) {
                rvLayoutParams = (LayoutParams)this.this$0.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams(rvLayoutParams);
            } else if (!this.this$0.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)this.this$0.generateLayoutParams(lp);
                holder.itemView.setLayoutParams(rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mInsetsDirty = true;
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = holder.itemView.getParent() == null;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_Recycler$convertPreLayoutPositionToPostLayout(int position) {
            if (position < 0 || position >= this.this$0.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("invalid position " + position + ". State item count is " + this.this$0.mState.getItemCount());
            }
            if (!this.this$0.mState.isPreLayout()) {
                return position;
            }
            return this.this$0.mAdapterHelper.findPositionOffset(position);
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_Recycler$getViewForPosition(int position) {
            return this.getViewForPosition(position, false);
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_Recycler$getViewForPosition(int position, boolean dryRun) {
            return this.tryGetViewHolderForPositionByDeadline((int)position, (boolean)dryRun, (long)Long.MAX_VALUE).itemView;
        }

        private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_Recycler$tryGetViewHolderForPositionByDeadline(int position, boolean dryRun, long deadlineNs) {
            LayoutParams rvLayoutParams;
            if (position < 0 || position >= this.this$0.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("Invalid item position " + position + "(" + position + "). Item count:" + this.this$0.mState.getItemCount());
            }
            boolean fromScrapOrHiddenOrCache = false;
            ViewHolder holder = null;
            if (this.this$0.mState.isPreLayout()) {
                holder = this.getChangedScrapViewForPosition(position);
                boolean bl = fromScrapOrHiddenOrCache = holder != null;
            }
            if (holder == null && (holder = this.getScrapOrHiddenOrCachedHolderForPosition(position, dryRun)) != null) {
                if (!this.validateViewHolderForOffsetPosition(holder)) {
                    if (!dryRun) {
                        holder.addFlags(4);
                        if (holder.isScrap()) {
                            this.this$0.removeDetachedView(holder.itemView, false);
                            holder.unScrap();
                        } else if (holder.wasReturnedFromScrap()) {
                            holder.clearReturnedFromScrapFlag();
                        }
                        this.recycleViewHolderInternal(holder);
                    }
                    holder = null;
                } else {
                    fromScrapOrHiddenOrCache = true;
                }
            }
            if (holder == null) {
                View view;
                int offsetPosition = this.this$0.mAdapterHelper.findPositionOffset(position);
                if (offsetPosition < 0 || offsetPosition >= this.this$0.mAdapter.getItemCount()) {
                    throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ").state:" + this.this$0.mState.getItemCount());
                }
                int type = this.this$0.mAdapter.getItemViewType(offsetPosition);
                if (this.this$0.mAdapter.hasStableIds() && (holder = this.getScrapOrCachedViewForId(this.this$0.mAdapter.getItemId(offsetPosition), type, dryRun)) != null) {
                    holder.mPosition = offsetPosition;
                    fromScrapOrHiddenOrCache = true;
                }
                if (holder == null && this.mViewCacheExtension != null && (view = this.mViewCacheExtension.getViewForPositionAndType(this, position, type)) != null) {
                    holder = this.this$0.getChildViewHolder(view);
                    if (holder == null) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view which does not have a ViewHolder");
                    }
                    if (holder.shouldIgnore()) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view that is ignored. You must call stopIgnoring before returning this view.");
                    }
                }
                if (holder == null && (holder = this.getRecycledViewPool().getRecycledView(type)) != null) {
                    holder.resetInternal();
                    if (FORCE_INVALIDATE_DISPLAY_LIST) {
                        this.invalidateDisplayListInt(holder);
                    }
                }
                if (holder == null) {
                    RecyclerView innerView;
                    long start = this.this$0.getNanoTime();
                    if (deadlineNs != Long.MAX_VALUE && !this.mRecyclerPool.willCreateInTime(type, start, deadlineNs)) {
                        return null;
                    }
                    holder = this.this$0.mAdapter.createViewHolder(this.this$0, type);
                    if (ALLOW_THREAD_GAP_WORK && (innerView = RecyclerView.findNestedRecyclerView(holder.itemView)) != null) {
                        holder.mNestedRecyclerView = new WeakReference<RecyclerView>(innerView);
                    }
                    long end = this.this$0.getNanoTime();
                    this.mRecyclerPool.factorInCreateTime(type, end - start);
                }
            }
            if (fromScrapOrHiddenOrCache && !this.this$0.mState.isPreLayout() && holder.hasAnyOfTheFlags(8192)) {
                holder.setFlags(0, 8192);
                if (this.this$0.mState.mRunSimpleAnimations) {
                    int changeFlags = ItemAnimator.buildAdapterChangeFlagsForAnimations(holder);
                    ItemAnimator.ItemHolderInfo info = this.this$0.mItemAnimator.recordPreLayoutInformation(this.this$0.mState, holder, changeFlags |= 0x1000, holder.getUnmodifiedPayloads());
                    this.this$0.recordAnimationInfoIfBouncedHiddenView(holder, info);
                }
            }
            boolean bound = false;
            if (this.this$0.mState.isPreLayout() && holder.isBound()) {
                holder.mPreLayoutPosition = position;
            } else if (!holder.isBound() || holder.needsUpdate() || holder.isInvalid()) {
                int offsetPosition = this.this$0.mAdapterHelper.findPositionOffset(position);
                bound = this.tryBindViewHolderByDeadline(holder, offsetPosition, position, deadlineNs);
            }
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp == null) {
                rvLayoutParams = (LayoutParams)this.this$0.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams(rvLayoutParams);
            } else if (!this.this$0.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)this.this$0.generateLayoutParams(lp);
                holder.itemView.setLayoutParams(rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = fromScrapOrHiddenOrCache && bound;
            return holder;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$attachAccessibilityDelegate(View itemView) {
            if (this.this$0.isAccessibilityEnabled()) {
                if (itemView.getImportantForAccessibility() == 0) {
                    itemView.setImportantForAccessibility(1);
                }
                if (itemView.getAccessibilityDelegate() == null) {
                    itemView.setAccessibilityDelegate(this.this$0.mAccessibilityDelegate.getItemDelegate());
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$invalidateDisplayListInt(ViewHolder holder) {
            if (holder.itemView instanceof ViewGroup) {
                this.invalidateDisplayListInt((ViewGroup)holder.itemView, false);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$invalidateDisplayListInt(ViewGroup viewGroup, boolean invalidateThis) {
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                View view = viewGroup.getChildAt(i);
                if (!(view instanceof ViewGroup)) continue;
                this.invalidateDisplayListInt((ViewGroup)view, true);
            }
            if (!invalidateThis) {
                return;
            }
            if (viewGroup.getVisibility() == 4) {
                viewGroup.setVisibility(0);
                viewGroup.setVisibility(4);
            } else {
                int visibility = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(visibility);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder.isTmpDetached()) {
                this.this$0.removeDetachedView(view, false);
            }
            if (holder.isScrap()) {
                holder.unScrap();
            } else if (holder.wasReturnedFromScrap()) {
                holder.clearReturnedFromScrapFlag();
            }
            this.recycleViewHolderInternal(holder);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleViewInternal(View view) {
            this.recycleViewHolderInternal(RecyclerView.getChildViewHolderInt(view));
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleAndClearCachedViews() {
            int count = this.mCachedViews.size();
            for (int i = count - 1; i >= 0; --i) {
                this.recycleCachedViewAt(i);
            }
            this.mCachedViews.clear();
            if (ALLOW_THREAD_GAP_WORK) {
                this.this$0.mPrefetchRegistry.clearPrefetchPositions();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleCachedViewAt(int cachedViewIndex) {
            ViewHolder viewHolder = this.mCachedViews.get(cachedViewIndex);
            this.addViewHolderToRecycledViewPool(viewHolder, true);
            this.mCachedViews.remove(cachedViewIndex);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleViewHolderInternal(ViewHolder holder) {
            if (holder.isScrap() || holder.itemView.getParent() != null) {
                throw new IllegalArgumentException("Scrapped or attached views may not be recycled. isScrap:" + holder.isScrap() + " isAttached:" + (holder.itemView.getParent() != null));
            }
            if (holder.isTmpDetached()) {
                throw new IllegalArgumentException("Tmp detached view should be removed from RecyclerView before it can be recycled: " + holder);
            }
            if (holder.shouldIgnore()) {
                throw new IllegalArgumentException("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle.");
            }
            boolean transientStatePreventsRecycling = holder.doesTransientStatePreventRecycling();
            boolean forceRecycle = this.this$0.mAdapter != null && transientStatePreventsRecycling && this.this$0.mAdapter.onFailedToRecycleView(holder);
            boolean cached = false;
            boolean recycled = false;
            if (forceRecycle || holder.isRecyclable()) {
                if (this.mViewCacheMax > 0 && !holder.hasAnyOfTheFlags(526)) {
                    int cachedViewSize = this.mCachedViews.size();
                    if (cachedViewSize >= this.mViewCacheMax && cachedViewSize > 0) {
                        this.recycleCachedViewAt(0);
                        --cachedViewSize;
                    }
                    int targetCacheIndex = cachedViewSize;
                    if (ALLOW_THREAD_GAP_WORK && cachedViewSize > 0 && !this.this$0.mPrefetchRegistry.lastPrefetchIncludedPosition(holder.mPosition)) {
                        int cachedPos;
                        int cacheIndex;
                        for (cacheIndex = cachedViewSize - 1; cacheIndex >= 0 && this.this$0.mPrefetchRegistry.lastPrefetchIncludedPosition(cachedPos = this.mCachedViews.get((int)cacheIndex).mPosition); --cacheIndex) {
                        }
                        targetCacheIndex = cacheIndex + 1;
                    }
                    this.mCachedViews.add(targetCacheIndex, holder);
                    cached = true;
                }
                if (!cached) {
                    this.addViewHolderToRecycledViewPool(holder, true);
                    recycled = true;
                }
            }
            this.this$0.mViewInfoStore.removeViewHolder(holder);
            if (!cached && !recycled && transientStatePreventsRecycling) {
                holder.mOwnerRecyclerView = null;
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$addViewHolderToRecycledViewPool(ViewHolder holder, boolean dispatchRecycled) {
            RecyclerView.clearNestedRecyclerViewIfNotNested(holder);
            holder.itemView.setAccessibilityDelegate(null);
            if (dispatchRecycled) {
                this.dispatchViewRecycled(holder);
            }
            holder.mOwnerRecyclerView = null;
            this.getRecycledViewPool().putRecycledView(holder);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$quickRecycleScrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            holder.mScrapContainer = null;
            holder.mInChangeScrap = false;
            holder.clearReturnedFromScrapFlag();
            this.recycleViewHolderInternal(holder);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$scrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder.hasAnyOfTheFlags(12) || !holder.isUpdated() || this.this$0.canReuseUpdatedViewHolder(holder)) {
                if (holder.isInvalid() && !holder.isRemoved() && !this.this$0.mAdapter.hasStableIds()) {
                    throw new IllegalArgumentException("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool.");
                }
                holder.setScrapContainer(this, false);
                this.mAttachedScrap.add(holder);
            } else {
                if (this.mChangedScrap == null) {
                    this.mChangedScrap = new ArrayList();
                }
                holder.setScrapContainer(this, true);
                this.mChangedScrap.add(holder);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$unscrapView(ViewHolder holder) {
            if (holder.mInChangeScrap) {
                this.mChangedScrap.remove(holder);
            } else {
                this.mAttachedScrap.remove(holder);
            }
            holder.mScrapContainer = null;
            holder.mInChangeScrap = false;
            holder.clearReturnedFromScrapFlag();
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapCount() {
            return this.mAttachedScrap.size();
        }

        private final View $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapViewAt(int index) {
            return this.mAttachedScrap.get((int)index).itemView;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$clearScrap() {
            this.mAttachedScrap.clear();
            if (this.mChangedScrap != null) {
                this.mChangedScrap.clear();
            }
        }

        private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_Recycler$getChangedScrapViewForPosition(int position) {
            int offsetPosition;
            int changedScrapSize;
            if (this.mChangedScrap == null || (changedScrapSize = this.mChangedScrap.size()) == 0) {
                return null;
            }
            for (int i = 0; i < changedScrapSize; ++i) {
                ViewHolder holder = this.mChangedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position) continue;
                holder.addFlags(32);
                return holder;
            }
            if (this.this$0.mAdapter.hasStableIds() && (offsetPosition = this.this$0.mAdapterHelper.findPositionOffset(position)) > 0 && offsetPosition < this.this$0.mAdapter.getItemCount()) {
                long id2 = this.this$0.mAdapter.getItemId(offsetPosition);
                for (int i = 0; i < changedScrapSize; ++i) {
                    ViewHolder holder = this.mChangedScrap.get(i);
                    if (holder.wasReturnedFromScrap() || holder.getItemId() != id2) continue;
                    holder.addFlags(32);
                    return holder;
                }
            }
            return null;
        }

        private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapOrHiddenOrCachedHolderForPosition(int position, boolean dryRun) {
            View view;
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position || holder.isInvalid() || !this.this$0.mState.mInPreLayout && holder.isRemoved()) continue;
                holder.addFlags(32);
                return holder;
            }
            if (!dryRun && (view = this.this$0.mChildHelper.findHiddenNonRemovedView(position)) != null) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
                this.this$0.mChildHelper.unhide(view);
                int layoutIndex = this.this$0.mChildHelper.indexOfChild(view);
                if (layoutIndex == -1) {
                    throw new IllegalStateException("layout index should not be -1 after unhiding a view:" + vh);
                }
                this.this$0.mChildHelper.detachViewFromParent(layoutIndex);
                this.scrapView(view);
                vh.addFlags(8224);
                return vh;
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = 0; i < cacheSize; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.isInvalid() || holder.getLayoutPosition() != position) continue;
                if (!dryRun) {
                    this.mCachedViews.remove(i);
                }
                return holder;
            }
            return null;
        }

        private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapOrCachedViewForId(long id2, int type, boolean dryRun) {
            int count = this.mAttachedScrap.size();
            for (int i = count - 1; i >= 0; --i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.getItemId() != id2 || holder.wasReturnedFromScrap()) continue;
                if (type == holder.getItemViewType()) {
                    holder.addFlags(32);
                    if (holder.isRemoved() && !this.this$0.mState.isPreLayout()) {
                        holder.setFlags(2, 14);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.mAttachedScrap.remove(i);
                this.this$0.removeDetachedView(holder.itemView, false);
                this.quickRecycleScrapView(holder.itemView);
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = cacheSize - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.getItemId() != id2) continue;
                if (type == holder.getItemViewType()) {
                    if (!dryRun) {
                        this.mCachedViews.remove(i);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.recycleCachedViewAt(i);
                return null;
            }
            return null;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$dispatchViewRecycled(ViewHolder holder) {
            if (this.this$0.mRecyclerListener != null) {
                this.this$0.mRecyclerListener.onViewRecycled(holder);
            }
            if (this.this$0.mAdapter != null) {
                this.this$0.mAdapter.onViewRecycled(holder);
            }
            if (this.this$0.mState != null) {
                this.this$0.mViewInfoStore.removeViewHolder(holder);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$onAdapterChanged(Adapter oldAdapter, Adapter newAdapter, boolean compatibleWithPrevious) {
            this.clear();
            this.getRecycledViewPool().onAdapterChanged(oldAdapter, newAdapter, compatibleWithPrevious);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForMove(int from, int to) {
            int inBetweenOffset;
            int end;
            int start;
            if (from < to) {
                start = from;
                end = to;
                inBetweenOffset = -1;
            } else {
                start = to;
                end = from;
                inBetweenOffset = 1;
            }
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
                if (holder.mPosition == from) {
                    holder.offsetPosition(to - from, false);
                    continue;
                }
                holder.offsetPosition(inBetweenOffset, false);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForInsert(int insertedAt, int count) {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.mPosition < insertedAt) continue;
                holder.offsetPosition(count, true);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForRemove(int removedFrom, int count, boolean applyToPreLayout) {
            int removedEnd = removedFrom + count;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                if (holder.mPosition >= removedEnd) {
                    holder.offsetPosition(-count, applyToPreLayout);
                    continue;
                }
                if (holder.mPosition < removedFrom) continue;
                holder.addFlags(8);
                this.recycleCachedViewAt(i);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$setViewCacheExtension(ViewCacheExtension extension) {
            this.mViewCacheExtension = extension;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$setRecycledViewPool(RecycledViewPool pool) {
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detach();
            }
            this.mRecyclerPool = pool;
            if (pool != null) {
                this.mRecyclerPool.attach(this.this$0.getAdapter());
            }
        }

        private final RecycledViewPool $$robo$$com_android_internal_widget_RecyclerView_Recycler$getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
            }
            return this.mRecyclerPool;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$viewRangeUpdate(int positionStart, int itemCount) {
            int positionEnd = positionStart + itemCount;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                int pos;
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || (pos = holder.getLayoutPosition()) < positionStart || pos >= positionEnd) continue;
                holder.addFlags(2);
                this.recycleCachedViewAt(i);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$setAdapterPositionsAsUnknown() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                holder.addFlags(512);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$markKnownViewsInvalid() {
            if (this.this$0.mAdapter != null && this.this$0.mAdapter.hasStableIds()) {
                int cachedCount = this.mCachedViews.size();
                for (int i = 0; i < cachedCount; ++i) {
                    ViewHolder holder = this.mCachedViews.get(i);
                    if (holder == null) continue;
                    holder.addFlags(6);
                    holder.addChangePayload(null);
                }
            } else {
                this.recycleAndClearCachedViews();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$clearOldPositions() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                holder.clearOldPosition();
            }
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                this.mAttachedScrap.get(i).clearOldPosition();
            }
            if (this.mChangedScrap != null) {
                int changedScrapCount = this.mChangedScrap.size();
                for (int i = 0; i < changedScrapCount; ++i) {
                    this.mChangedScrap.get(i).clearOldPosition();
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_Recycler$markItemDecorInsetsDirty() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                LayoutParams layoutParams = (LayoutParams)holder.itemView.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.mInsetsDirty = true;
            }
        }

        private void __constructor__(RecyclerView recyclerView) {
            this.$$robo$$com_android_internal_widget_RecyclerView_Recycler$__constructor__(recyclerView);
        }

        public Recycler(RecyclerView recyclerView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_Recycler$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_widget_RecyclerView_Recycler$clear(), this);
        }

        public void setViewCacheSize(int n) {
            InvokeDynamicSupport.bootstrap("setViewCacheSize", $$robo$$com_android_internal_widget_RecyclerView_Recycler$setViewCacheSize(int ), this, n);
        }

        void updateViewCacheSize() {
            InvokeDynamicSupport.bootstrap("updateViewCacheSize", $$robo$$com_android_internal_widget_RecyclerView_Recycler$updateViewCacheSize(), this);
        }

        public List<ViewHolder> getScrapList() {
            return InvokeDynamicSupport.bootstrap("getScrapList", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapList(), this);
        }

        boolean validateViewHolderForOffsetPosition(ViewHolder viewHolder) {
            return (boolean)InvokeDynamicSupport.bootstrap("validateViewHolderForOffsetPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$validateViewHolderForOffsetPosition(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        private boolean tryBindViewHolderByDeadline(ViewHolder viewHolder, int n, int n2, long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("tryBindViewHolderByDeadline", $$robo$$com_android_internal_widget_RecyclerView_Recycler$tryBindViewHolderByDeadline(com.android.internal.widget.RecyclerView$ViewHolder int int long ), this, viewHolder, n, n2, l);
        }

        public void bindViewToPosition(View view, int n) {
            InvokeDynamicSupport.bootstrap("bindViewToPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$bindViewToPosition(android.view.View int ), this, view, n);
        }

        public int convertPreLayoutPositionToPostLayout(int n) {
            return (int)InvokeDynamicSupport.bootstrap("convertPreLayoutPositionToPostLayout", $$robo$$com_android_internal_widget_RecyclerView_Recycler$convertPreLayoutPositionToPostLayout(int ), this, n);
        }

        public View getViewForPosition(int n) {
            return InvokeDynamicSupport.bootstrap("getViewForPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getViewForPosition(int ), this, n);
        }

        View getViewForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getViewForPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getViewForPosition(int boolean ), this, n, bl);
        }

        ViewHolder tryGetViewHolderForPositionByDeadline(int n, boolean bl, long l) {
            return InvokeDynamicSupport.bootstrap("tryGetViewHolderForPositionByDeadline", $$robo$$com_android_internal_widget_RecyclerView_Recycler$tryGetViewHolderForPositionByDeadline(int boolean long ), this, n, bl, l);
        }

        private void attachAccessibilityDelegate(View view) {
            InvokeDynamicSupport.bootstrap("attachAccessibilityDelegate", $$robo$$com_android_internal_widget_RecyclerView_Recycler$attachAccessibilityDelegate(android.view.View ), this, view);
        }

        private void invalidateDisplayListInt(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("invalidateDisplayListInt", $$robo$$com_android_internal_widget_RecyclerView_Recycler$invalidateDisplayListInt(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        private void invalidateDisplayListInt(ViewGroup viewGroup, boolean bl) {
            InvokeDynamicSupport.bootstrap("invalidateDisplayListInt", $$robo$$com_android_internal_widget_RecyclerView_Recycler$invalidateDisplayListInt(android.view.ViewGroup boolean ), this, viewGroup, bl);
        }

        public void recycleView(View view) {
            InvokeDynamicSupport.bootstrap("recycleView", $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleView(android.view.View ), this, view);
        }

        void recycleViewInternal(View view) {
            InvokeDynamicSupport.bootstrap("recycleViewInternal", $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleViewInternal(android.view.View ), this, view);
        }

        void recycleAndClearCachedViews() {
            InvokeDynamicSupport.bootstrap("recycleAndClearCachedViews", $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleAndClearCachedViews(), this);
        }

        void recycleCachedViewAt(int n) {
            InvokeDynamicSupport.bootstrap("recycleCachedViewAt", $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleCachedViewAt(int ), this, n);
        }

        void recycleViewHolderInternal(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("recycleViewHolderInternal", $$robo$$com_android_internal_widget_RecyclerView_Recycler$recycleViewHolderInternal(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        void addViewHolderToRecycledViewPool(ViewHolder viewHolder, boolean bl) {
            InvokeDynamicSupport.bootstrap("addViewHolderToRecycledViewPool", $$robo$$com_android_internal_widget_RecyclerView_Recycler$addViewHolderToRecycledViewPool(com.android.internal.widget.RecyclerView$ViewHolder boolean ), this, viewHolder, bl);
        }

        void quickRecycleScrapView(View view) {
            InvokeDynamicSupport.bootstrap("quickRecycleScrapView", $$robo$$com_android_internal_widget_RecyclerView_Recycler$quickRecycleScrapView(android.view.View ), this, view);
        }

        void scrapView(View view) {
            InvokeDynamicSupport.bootstrap("scrapView", $$robo$$com_android_internal_widget_RecyclerView_Recycler$scrapView(android.view.View ), this, view);
        }

        void unscrapView(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("unscrapView", $$robo$$com_android_internal_widget_RecyclerView_Recycler$unscrapView(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        int getScrapCount() {
            return (int)InvokeDynamicSupport.bootstrap("getScrapCount", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapCount(), this);
        }

        View getScrapViewAt(int n) {
            return InvokeDynamicSupport.bootstrap("getScrapViewAt", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapViewAt(int ), this, n);
        }

        void clearScrap() {
            InvokeDynamicSupport.bootstrap("clearScrap", $$robo$$com_android_internal_widget_RecyclerView_Recycler$clearScrap(), this);
        }

        ViewHolder getChangedScrapViewForPosition(int n) {
            return InvokeDynamicSupport.bootstrap("getChangedScrapViewForPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getChangedScrapViewForPosition(int ), this, n);
        }

        ViewHolder getScrapOrHiddenOrCachedHolderForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getScrapOrHiddenOrCachedHolderForPosition", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapOrHiddenOrCachedHolderForPosition(int boolean ), this, n, bl);
        }

        ViewHolder getScrapOrCachedViewForId(long l, int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getScrapOrCachedViewForId", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getScrapOrCachedViewForId(long int boolean ), this, l, n, bl);
        }

        void dispatchViewRecycled(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("dispatchViewRecycled", $$robo$$com_android_internal_widget_RecyclerView_Recycler$dispatchViewRecycled(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAdapterChanged", $$robo$$com_android_internal_widget_RecyclerView_Recycler$onAdapterChanged(com.android.internal.widget.RecyclerView$Adapter com.android.internal.widget.RecyclerView$Adapter boolean ), this, adapter, adapter2, bl);
        }

        void offsetPositionRecordsForMove(int n, int n2) {
            InvokeDynamicSupport.bootstrap("offsetPositionRecordsForMove", $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForMove(int int ), this, n, n2);
        }

        void offsetPositionRecordsForInsert(int n, int n2) {
            InvokeDynamicSupport.bootstrap("offsetPositionRecordsForInsert", $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForInsert(int int ), this, n, n2);
        }

        void offsetPositionRecordsForRemove(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("offsetPositionRecordsForRemove", $$robo$$com_android_internal_widget_RecyclerView_Recycler$offsetPositionRecordsForRemove(int int boolean ), this, n, n2, bl);
        }

        void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
            InvokeDynamicSupport.bootstrap("setViewCacheExtension", $$robo$$com_android_internal_widget_RecyclerView_Recycler$setViewCacheExtension(com.android.internal.widget.RecyclerView$ViewCacheExtension ), this, viewCacheExtension);
        }

        void setRecycledViewPool(RecycledViewPool recycledViewPool) {
            InvokeDynamicSupport.bootstrap("setRecycledViewPool", $$robo$$com_android_internal_widget_RecyclerView_Recycler$setRecycledViewPool(com.android.internal.widget.RecyclerView$RecycledViewPool ), this, recycledViewPool);
        }

        RecycledViewPool getRecycledViewPool() {
            return InvokeDynamicSupport.bootstrap("getRecycledViewPool", $$robo$$com_android_internal_widget_RecyclerView_Recycler$getRecycledViewPool(), this);
        }

        void viewRangeUpdate(int n, int n2) {
            InvokeDynamicSupport.bootstrap("viewRangeUpdate", $$robo$$com_android_internal_widget_RecyclerView_Recycler$viewRangeUpdate(int int ), this, n, n2);
        }

        void setAdapterPositionsAsUnknown() {
            InvokeDynamicSupport.bootstrap("setAdapterPositionsAsUnknown", $$robo$$com_android_internal_widget_RecyclerView_Recycler$setAdapterPositionsAsUnknown(), this);
        }

        void markKnownViewsInvalid() {
            InvokeDynamicSupport.bootstrap("markKnownViewsInvalid", $$robo$$com_android_internal_widget_RecyclerView_Recycler$markKnownViewsInvalid(), this);
        }

        void clearOldPositions() {
            InvokeDynamicSupport.bootstrap("clearOldPositions", $$robo$$com_android_internal_widget_RecyclerView_Recycler$clearOldPositions(), this);
        }

        void markItemDecorInsetsDirty() {
            InvokeDynamicSupport.bootstrap("markItemDecorInsetsDirty", $$robo$$com_android_internal_widget_RecyclerView_Recycler$markItemDecorInsetsDirty(), this);
        }

        public /* synthetic */ Recycler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Recycler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RecycledViewPool
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DEFAULT_MAX_SCRAP = 5;
        SparseArray<ScrapData> mScrap;
        private int mAttachCount;

        private void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$__constructor__() {
            this.mScrap = new SparseArray();
            this.mAttachCount = 0;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$clear() {
            for (int i = 0; i < this.mScrap.size(); ++i) {
                ScrapData data = this.mScrap.valueAt(i);
                data.mScrapHeap.clear();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$setMaxRecycledViews(int viewType, int max) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mMaxScrap = max;
            ArrayList<ViewHolder> scrapHeap = scrapData.mScrapHeap;
            if (scrapHeap != null) {
                while (scrapHeap.size() > max) {
                    scrapHeap.remove(scrapHeap.size() - 1);
                }
            }
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getRecycledViewCount(int viewType) {
            return this.getScrapDataForType((int)viewType).mScrapHeap.size();
        }

        private final ViewHolder $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getRecycledView(int viewType) {
            ScrapData scrapData = this.mScrap.get(viewType);
            if (scrapData != null && !scrapData.mScrapHeap.isEmpty()) {
                ArrayList<ViewHolder> scrapHeap = scrapData.mScrapHeap;
                return scrapHeap.remove(scrapHeap.size() - 1);
            }
            return null;
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$size() {
            int count = 0;
            for (int i = 0; i < this.mScrap.size(); ++i) {
                ArrayList<ViewHolder> viewHolders = this.mScrap.valueAt((int)i).mScrapHeap;
                if (viewHolders == null) continue;
                count += viewHolders.size();
            }
            return count;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$putRecycledView(ViewHolder scrap) {
            int viewType = scrap.getItemViewType();
            ArrayList<ViewHolder> scrapHeap = this.getScrapDataForType((int)viewType).mScrapHeap;
            if (this.mScrap.get((int)viewType).mMaxScrap <= scrapHeap.size()) {
                return;
            }
            scrap.resetInternal();
            scrapHeap.add(scrap);
        }

        private final long $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$runningAverage(long oldAverage, long newValue) {
            if (oldAverage == 0L) {
                return newValue;
            }
            return oldAverage / 4L * 3L + newValue / 4L;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$factorInCreateTime(int viewType, long createTimeNs) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mCreateRunningAverageNs = this.runningAverage(scrapData.mCreateRunningAverageNs, createTimeNs);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$factorInBindTime(int viewType, long bindTimeNs) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mBindRunningAverageNs = this.runningAverage(scrapData.mBindRunningAverageNs, bindTimeNs);
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$willCreateInTime(int viewType, long approxCurrentNs, long deadlineNs) {
            long expectedDurationNs = this.getScrapDataForType((int)viewType).mCreateRunningAverageNs;
            return expectedDurationNs == 0L || approxCurrentNs + expectedDurationNs < deadlineNs;
        }

        private final boolean $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$willBindInTime(int viewType, long approxCurrentNs, long deadlineNs) {
            long expectedDurationNs = this.getScrapDataForType((int)viewType).mBindRunningAverageNs;
            return expectedDurationNs == 0L || approxCurrentNs + expectedDurationNs < deadlineNs;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$attach(Adapter adapter) {
            ++this.mAttachCount;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$detach() {
            --this.mAttachCount;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$onAdapterChanged(Adapter oldAdapter, Adapter newAdapter, boolean compatibleWithPrevious) {
            if (oldAdapter != null) {
                this.detach();
            }
            if (!compatibleWithPrevious && this.mAttachCount == 0) {
                this.clear();
            }
            if (newAdapter != null) {
                this.attach(newAdapter);
            }
        }

        private final ScrapData $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getScrapDataForType(int viewType) {
            ScrapData scrapData = this.mScrap.get(viewType);
            if (scrapData == null) {
                scrapData = new ScrapData();
                this.mScrap.put(viewType, scrapData);
            }
            return scrapData;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$__constructor__();
        }

        public RecycledViewPool() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$__constructor__(), this);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$clear(), this);
        }

        public void setMaxRecycledViews(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMaxRecycledViews", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$setMaxRecycledViews(int int ), this, n, n2);
        }

        public int getRecycledViewCount(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getRecycledViewCount", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getRecycledViewCount(int ), this, n);
        }

        public ViewHolder getRecycledView(int n) {
            return InvokeDynamicSupport.bootstrap("getRecycledView", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getRecycledView(int ), this, n);
        }

        int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$size(), this);
        }

        public void putRecycledView(ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("putRecycledView", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$putRecycledView(com.android.internal.widget.RecyclerView$ViewHolder ), this, viewHolder);
        }

        long runningAverage(long l, long l2) {
            return (long)InvokeDynamicSupport.bootstrap("runningAverage", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$runningAverage(long long ), this, l, l2);
        }

        void factorInCreateTime(int n, long l) {
            InvokeDynamicSupport.bootstrap("factorInCreateTime", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$factorInCreateTime(int long ), this, n, l);
        }

        void factorInBindTime(int n, long l) {
            InvokeDynamicSupport.bootstrap("factorInBindTime", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$factorInBindTime(int long ), this, n, l);
        }

        boolean willCreateInTime(int n, long l, long l2) {
            return (boolean)InvokeDynamicSupport.bootstrap("willCreateInTime", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$willCreateInTime(int long long ), this, n, l, l2);
        }

        boolean willBindInTime(int n, long l, long l2) {
            return (boolean)InvokeDynamicSupport.bootstrap("willBindInTime", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$willBindInTime(int long long ), this, n, l, l2);
        }

        void attach(Adapter adapter) {
            InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$attach(com.android.internal.widget.RecyclerView$Adapter ), this, adapter);
        }

        void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$detach(), this);
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAdapterChanged", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$onAdapterChanged(com.android.internal.widget.RecyclerView$Adapter com.android.internal.widget.RecyclerView$Adapter boolean ), this, adapter, adapter2, bl);
        }

        private ScrapData getScrapDataForType(int n) {
            return InvokeDynamicSupport.bootstrap("getScrapDataForType", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool$getScrapDataForType(int ), this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecycledViewPool)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class ScrapData
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            ArrayList<ViewHolder> mScrapHeap;
            int mMaxScrap;
            long mCreateRunningAverageNs;
            long mBindRunningAverageNs;

            private void $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool_ScrapData$__constructor__() {
                this.mScrapHeap = new ArrayList();
                this.mMaxScrap = 5;
                this.mCreateRunningAverageNs = 0L;
                this.mBindRunningAverageNs = 0L;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool_ScrapData$__constructor__();
            }

            public ScrapData() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_RecycledViewPool_ScrapData$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrapData)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RecyclerView this$0;

        private void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$__constructor__(RecyclerView recyclerView) {
            this.this$0 = recyclerView;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onChanged() {
            this.this$0.assertNotInLayoutOrScroll(null);
            this.this$0.mState.mStructureChanged = true;
            this.this$0.setDataSetChangedAfterLayout();
            if (!this.this$0.mAdapterHelper.hasPendingUpdates()) {
                this.this$0.requestLayout();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.this$0.assertNotInLayoutOrScroll(null);
            if (this.this$0.mAdapterHelper.onItemRangeChanged(positionStart, itemCount, payload)) {
                this.triggerUpdateProcessor();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeInserted(int positionStart, int itemCount) {
            this.this$0.assertNotInLayoutOrScroll(null);
            if (this.this$0.mAdapterHelper.onItemRangeInserted(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeRemoved(int positionStart, int itemCount) {
            this.this$0.assertNotInLayoutOrScroll(null);
            if (this.this$0.mAdapterHelper.onItemRangeRemoved(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.this$0.assertNotInLayoutOrScroll(null);
            if (this.this$0.mAdapterHelper.onItemRangeMoved(fromPosition, toPosition, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$triggerUpdateProcessor() {
            if (POST_UPDATES_ON_ANIMATION && this.this$0.mHasFixedSize && this.this$0.mIsAttached) {
                this.this$0.postOnAnimation(this.this$0.mUpdateChildViewsRunnable);
            } else {
                this.this$0.mAdapterUpdateDuringMeasure = true;
                this.this$0.requestLayout();
            }
        }

        private void __constructor__(RecyclerView recyclerView) {
            this.$$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$__constructor__(recyclerView);
        }

        public RecyclerViewDataObserver(RecyclerView recyclerView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onChanged(), this);
        }

        @Override
        public void onItemRangeChanged(int n, int n2, Object object) {
            InvokeDynamicSupport.bootstrap("onItemRangeChanged", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeChanged(int int java.lang.Object ), this, n, n2, object);
        }

        @Override
        public void onItemRangeInserted(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemRangeInserted", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeInserted(int int ), this, n, n2);
        }

        @Override
        public void onItemRangeRemoved(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onItemRangeRemoved", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeRemoved(int int ), this, n, n2);
        }

        @Override
        public void onItemRangeMoved(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onItemRangeMoved", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$onItemRangeMoved(int int int ), this, n, n2, n3);
        }

        void triggerUpdateProcessor() {
            InvokeDynamicSupport.bootstrap("triggerUpdateProcessor", $$robo$$com_android_internal_widget_RecyclerView_RecyclerViewDataObserver$triggerUpdateProcessor(), this);
        }

        public /* synthetic */ RecyclerViewDataObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecyclerViewDataObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ViewFlinger
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mLastFlingX;
        private int mLastFlingY;
        private OverScroller mScroller;
        Interpolator mInterpolator;
        private boolean mEatRunOnAnimationRequest;
        private boolean mReSchedulePostAnimationCallback;
        /* synthetic */ RecyclerView this$0;

        private void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$__constructor__(RecyclerView this$0) {
            this.this$0 = this$0;
            this.mInterpolator = sQuinticInterpolator;
            this.mEatRunOnAnimationRequest = false;
            this.mReSchedulePostAnimationCallback = false;
            this.mScroller = new OverScroller(this$0.getContext(), sQuinticInterpolator);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$run() {
            if (this.this$0.mLayout == null) {
                this.stop();
                return;
            }
            this.disableRunOnAnimationRequests();
            this.this$0.consumePendingUpdateOperations();
            OverScroller scroller = this.mScroller;
            SmoothScroller smoothScroller = this.this$0.mLayout.mSmoothScroller;
            if (scroller.computeScrollOffset()) {
                boolean fullyConsumedAny;
                int x = scroller.getCurrX();
                int y = scroller.getCurrY();
                int dx = x - this.mLastFlingX;
                int dy = y - this.mLastFlingY;
                int hresult = 0;
                int vresult = 0;
                this.mLastFlingX = x;
                this.mLastFlingY = y;
                int overscrollX = 0;
                int overscrollY = 0;
                if (this.this$0.mAdapter != null) {
                    this.this$0.eatRequestLayout();
                    this.this$0.onEnterLayoutOrScroll();
                    Trace.beginSection("RV Scroll");
                    if (dx != 0) {
                        hresult = this.this$0.mLayout.scrollHorizontallyBy(dx, this.this$0.mRecycler, this.this$0.mState);
                        overscrollX = dx - hresult;
                    }
                    if (dy != 0) {
                        vresult = this.this$0.mLayout.scrollVerticallyBy(dy, this.this$0.mRecycler, this.this$0.mState);
                        overscrollY = dy - vresult;
                    }
                    Trace.endSection();
                    this.this$0.repositionShadowingViews();
                    this.this$0.onExitLayoutOrScroll();
                    this.this$0.resumeRequestLayout(false);
                    if (smoothScroller != null && !smoothScroller.isPendingInitialRun() && smoothScroller.isRunning()) {
                        int adapterSize = this.this$0.mState.getItemCount();
                        if (adapterSize == 0) {
                            smoothScroller.stop();
                        } else if (smoothScroller.getTargetPosition() >= adapterSize) {
                            smoothScroller.setTargetPosition(adapterSize - 1);
                            smoothScroller.onAnimation(dx - overscrollX, dy - overscrollY);
                        } else {
                            smoothScroller.onAnimation(dx - overscrollX, dy - overscrollY);
                        }
                    }
                }
                if (!this.this$0.mItemDecorations.isEmpty()) {
                    this.this$0.invalidate();
                }
                if (this.this$0.getOverScrollMode() != 2) {
                    this.this$0.considerReleasingGlowsOnScroll(dx, dy);
                }
                if (overscrollX != 0 || overscrollY != 0) {
                    int vel = (int)scroller.getCurrVelocity();
                    int velX = 0;
                    if (overscrollX != x) {
                        velX = overscrollX < 0 ? -vel : (overscrollX > 0 ? vel : 0);
                    }
                    int velY = 0;
                    if (overscrollY != y) {
                        int n = overscrollY < 0 ? -vel : (velY = overscrollY > 0 ? vel : 0);
                    }
                    if (this.this$0.getOverScrollMode() != 2) {
                        this.this$0.absorbGlows(velX, velY);
                    }
                    if (!(velX == 0 && overscrollX != x && scroller.getFinalX() != 0 || velY == 0 && overscrollY != y && scroller.getFinalY() != 0)) {
                        scroller.abortAnimation();
                    }
                }
                if (hresult != 0 || vresult != 0) {
                    this.this$0.dispatchOnScrolled(hresult, vresult);
                }
                if (!this.this$0.awakenScrollBars()) {
                    this.this$0.invalidate();
                }
                boolean fullyConsumedVertical = dy != 0 && this.this$0.mLayout.canScrollVertically() && vresult == dy;
                boolean fullyConsumedHorizontal = dx != 0 && this.this$0.mLayout.canScrollHorizontally() && hresult == dx;
                boolean bl = fullyConsumedAny = dx == 0 && dy == 0 || fullyConsumedHorizontal || fullyConsumedVertical;
                if (scroller.isFinished() || !fullyConsumedAny) {
                    this.this$0.setScrollState(0);
                    if (ALLOW_THREAD_GAP_WORK) {
                        this.this$0.mPrefetchRegistry.clearPrefetchPositions();
                    }
                } else {
                    this.postOnAnimation();
                    if (this.this$0.mGapWorker != null) {
                        this.this$0.mGapWorker.postFromTraversal(this.this$0, dx, dy);
                    }
                }
            }
            if (smoothScroller != null) {
                if (smoothScroller.isPendingInitialRun()) {
                    smoothScroller.onAnimation(0, 0);
                }
                if (!this.mReSchedulePostAnimationCallback) {
                    smoothScroller.stop();
                }
            }
            this.enableRunOnAnimationRequests();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$disableRunOnAnimationRequests() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$enableRunOnAnimationRequests() {
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.postOnAnimation();
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.this$0.removeCallbacks(this);
                this.this$0.postOnAnimation(this);
            }
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$fling(int velocityX, int velocityY) {
            this.this$0.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.fling(0, 0, velocityX, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int dx, int dy) {
            this.smoothScrollBy(dx, dy, 0, 0);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int dx, int dy, int vx, int vy) {
            this.smoothScrollBy(dx, dy, this.computeScrollDuration(dx, dy, vx, vy));
        }

        private final float $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$distanceInfluenceForSnapDuration(float f) {
            f -= 0.5f;
            f = (float)((double)f * 0.4712389167638204);
            return (float)Math.sin(f);
        }

        private final int $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$computeScrollDuration(int dx, int dy, int vx, int vy) {
            int duration;
            int absDy;
            int absDx = Math.abs(dx);
            boolean horizontal = absDx > (absDy = Math.abs(dy));
            int velocity = (int)Math.sqrt(vx * vx + vy * vy);
            int delta = (int)Math.sqrt(dx * dx + dy * dy);
            int containerSize = horizontal ? this.this$0.getWidth() : this.this$0.getHeight();
            int halfContainerSize = containerSize / 2;
            float distanceRatio = Math.min(1.0f, 1.0f * (float)delta / (float)containerSize);
            float distance = (float)halfContainerSize + (float)halfContainerSize * this.distanceInfluenceForSnapDuration(distanceRatio);
            if (velocity > 0) {
                duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
            } else {
                float absDelta = horizontal ? absDx : absDy;
                duration = (int)((absDelta / (float)containerSize + 1.0f) * 300.0f);
            }
            return Math.min(duration, 2000);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int dx, int dy, int duration) {
            this.smoothScrollBy(dx, dy, duration, sQuinticInterpolator);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int dx, int dy, Interpolator interpolator2) {
            this.smoothScrollBy(dx, dy, this.computeScrollDuration(dx, dy, 0, 0), interpolator2 == null ? sQuinticInterpolator : interpolator2);
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int dx, int dy, int duration, Interpolator interpolator2) {
            if (this.mInterpolator != interpolator2) {
                this.mInterpolator = interpolator2;
                this.mScroller = new OverScroller(this.this$0.getContext(), interpolator2);
            }
            this.this$0.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, dx, dy, duration);
            this.postOnAnimation();
        }

        private final void $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$stop() {
            this.this$0.removeCallbacks(this);
            this.mScroller.abortAnimation();
        }

        private void __constructor__(RecyclerView recyclerView) {
            this.$$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$__constructor__(recyclerView);
        }

        public ViewFlinger(RecyclerView recyclerView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$__constructor__(com.android.internal.widget.RecyclerView ), this, recyclerView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$run(), this);
        }

        private void disableRunOnAnimationRequests() {
            InvokeDynamicSupport.bootstrap("disableRunOnAnimationRequests", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$disableRunOnAnimationRequests(), this);
        }

        private void enableRunOnAnimationRequests() {
            InvokeDynamicSupport.bootstrap("enableRunOnAnimationRequests", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$enableRunOnAnimationRequests(), this);
        }

        void postOnAnimation() {
            InvokeDynamicSupport.bootstrap("postOnAnimation", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$postOnAnimation(), this);
        }

        public void fling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("fling", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$fling(int int ), this, n, n2);
        }

        public void smoothScrollBy(int n, int n2) {
            InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int int ), this, n, n2);
        }

        public void smoothScrollBy(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int int int int ), this, n, n2, n3, n4);
        }

        private float distanceInfluenceForSnapDuration(float f) {
            return (float)InvokeDynamicSupport.bootstrap("distanceInfluenceForSnapDuration", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$distanceInfluenceForSnapDuration(float ), this, f);
        }

        private int computeScrollDuration(int n, int n2, int n3, int n4) {
            return (int)InvokeDynamicSupport.bootstrap("computeScrollDuration", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$computeScrollDuration(int int int int ), this, n, n2, n3, n4);
        }

        public void smoothScrollBy(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int int int ), this, n, n2, n3);
        }

        public void smoothScrollBy(int n, int n2, Interpolator interpolator2) {
            InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int int android.view.animation.Interpolator ), this, n, n2, interpolator2);
        }

        public void smoothScrollBy(int n, int n2, int n3, Interpolator interpolator2) {
            InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$smoothScrollBy(int int int android.view.animation.Interpolator ), this, n, n2, n3, interpolator2);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$com_android_internal_widget_RecyclerView_ViewFlinger$stop(), this);
        }

        public /* synthetic */ ViewFlinger() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewFlinger)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

