/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class NotificationActionListLayout
extends LinearLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mGravity;
    private int mTotalWidth;
    private ArrayList<Pair<Integer, TextView>> mMeasureOrderTextViews;
    private ArrayList<View> mMeasureOrderOther;
    private boolean mEmphasizedMode;
    private int mDefaultPaddingBottom;
    private int mDefaultPaddingTop;
    private int mEmphasizedHeight;
    private int mRegularHeight;
    public static Comparator<Pair<Integer, TextView>> MEASURE_ORDER_COMPARATOR;

    private void $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mTotalWidth = 0;
        this.mMeasureOrderTextViews = new ArrayList();
        this.mMeasureOrderOther = new ArrayList();
        int[] attrIds = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrIds, defStyleAttr, defStyleRes);
        this.mGravity = ta.getInt(0, 0);
        ta.recycle();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mEmphasizedMode) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int N = this.getChildCount();
        int textViews = 0;
        int otherViews = 0;
        int notGoneChildren = 0;
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView) {
                ++textViews;
            } else {
                ++otherViews;
            }
            if (c.getVisibility() == 8) continue;
            ++notGoneChildren;
        }
        boolean needRebuild = false;
        if (textViews != this.mMeasureOrderTextViews.size() || otherViews != this.mMeasureOrderOther.size()) {
            needRebuild = true;
        }
        if (!needRebuild) {
            int size = this.mMeasureOrderTextViews.size();
            for (int i = 0; i < size; ++i) {
                Pair<Integer, TextView> pair = this.mMeasureOrderTextViews.get(i);
                if (((Integer)pair.first).intValue() == ((TextView)pair.second).getText().length()) continue;
                needRebuild = true;
            }
        }
        if (needRebuild) {
            this.rebuildMeasureOrder(textViews, otherViews);
        }
        boolean constrained = View.MeasureSpec.getMode(widthMeasureSpec) != 0;
        int innerWidth = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        int otherSize = this.mMeasureOrderOther.size();
        int usedWidth = 0;
        int measuredChildren = 0;
        for (int i = 0; i < N; ++i) {
            View c = i < otherSize ? this.mMeasureOrderOther.get(i) : (View)this.mMeasureOrderTextViews.get((int)(i - otherSize)).second;
            if (c.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)c.getLayoutParams();
            int usedWidthForChild = usedWidth;
            if (constrained) {
                int availableWidth = innerWidth - usedWidth;
                int maxWidthForChild = availableWidth / (notGoneChildren - measuredChildren);
                usedWidthForChild = innerWidth - maxWidthForChild;
            }
            this.measureChildWithMargins(c, widthMeasureSpec, usedWidthForChild, heightMeasureSpec, 0);
            usedWidth += c.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            ++measuredChildren;
        }
        this.mTotalWidth = usedWidth + this.mPaddingRight + this.mPaddingLeft;
        this.setMeasuredDimension(NotificationActionListLayout.resolveSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), NotificationActionListLayout.resolveSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$rebuildMeasureOrder(int capacityText, int capacityOther) {
        this.clearMeasureOrder();
        this.mMeasureOrderTextViews.ensureCapacity(capacityText);
        this.mMeasureOrderOther.ensureCapacity(capacityOther);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView && ((TextView)c).getText().length() > 0) {
                this.mMeasureOrderTextViews.add(Pair.create(((TextView)c).getText().length(), (TextView)c));
                continue;
            }
            this.mMeasureOrderOther.add(c);
        }
        this.mMeasureOrderTextViews.sort(MEASURE_ORDER_COMPARATOR);
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$clearMeasureOrder() {
        this.mMeasureOrderOther.clear();
        this.mMeasureOrderTextViews.clear();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewAdded(View child) {
        super.onViewAdded(child);
        this.clearMeasureOrder();
        if (child.getBackground() instanceof RippleDrawable) {
            ((RippleDrawable)child.getBackground()).setForceSoftware(true);
        }
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.clearMeasureOrder();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childLeft;
        boolean centerAligned;
        if (this.mEmphasizedMode) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        boolean bl = centerAligned = (this.mGravity & 1) != 0;
        if (centerAligned) {
            childLeft = this.mPaddingLeft + left + (right - left) / 2 - this.mTotalWidth / 2;
        } else {
            childLeft = this.mPaddingLeft;
            int absoluteGravity = Gravity.getAbsoluteGravity(0x800003, this.getLayoutDirection());
            if (absoluteGravity == 5) {
                childLeft += right - left - this.mTotalWidth;
            }
        }
        int height = bottom - top;
        int innerHeight = height - paddingTop - this.mPaddingBottom;
        int count = this.getChildCount();
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childIndex = start + dir * i;
            View child = this.getChildAt(childIndex);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childTop = paddingTop + (innerHeight - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
            child.layout(childLeft += lp.leftMargin, childTop, childLeft + childWidth, childTop + childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onFinishInflate() {
        super.onFinishInflate();
        this.mDefaultPaddingBottom = this.getPaddingBottom();
        this.mDefaultPaddingTop = this.getPaddingTop();
        this.updateHeights();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$updateHeights() {
        int paddingTop = this.getResources().getDimensionPixelSize(17105198);
        int paddingBottom = this.getResources().getDimensionPixelSize(17105199);
        this.mEmphasizedHeight = paddingBottom + paddingTop + this.getResources().getDimensionPixelSize(17105188);
        this.mRegularHeight = this.getResources().getDimensionPixelSize(17105189);
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$setEmphasizedMode(boolean emphasizedMode) {
        int height;
        this.mEmphasizedMode = emphasizedMode;
        if (emphasizedMode) {
            int paddingTop = this.getResources().getDimensionPixelSize(17105198);
            int paddingBottom = this.getResources().getDimensionPixelSize(17105199);
            height = this.mEmphasizedHeight;
            int buttonPaddingInternal = this.getResources().getDimensionPixelSize(17104942);
            this.setPaddingRelative(this.getPaddingStart(), paddingTop - buttonPaddingInternal, this.getPaddingEnd(), paddingBottom - buttonPaddingInternal);
        } else {
            this.setPaddingRelative(this.getPaddingStart(), this.mDefaultPaddingTop, this.getPaddingEnd(), this.mDefaultPaddingBottom);
            height = this.mRegularHeight;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.height = height;
        this.setLayoutParams(layoutParams);
    }

    private final int $$robo$$com_android_internal_widget_NotificationActionListLayout$getExtraMeasureHeight() {
        if (this.mEmphasizedMode) {
            return this.mEmphasizedHeight - this.mRegularHeight;
        }
        return 0;
    }

    static void __staticInitializer__() {
        MEASURE_ORDER_COMPARATOR = (a, b) -> ((Integer)a.first).compareTo((Integer)b.first);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(context, attributeSet);
    }

    public NotificationActionListLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(context, attributeSet, n);
    }

    public NotificationActionListLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(context, attributeSet, n, n2);
    }

    public NotificationActionListLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_NotificationActionListLayout$onMeasure(int int ), this, n, n2);
    }

    private void rebuildMeasureOrder(int n, int n2) {
        InvokeDynamicSupport.bootstrap("rebuildMeasureOrder", $$robo$$com_android_internal_widget_NotificationActionListLayout$rebuildMeasureOrder(int int ), this, n, n2);
    }

    private void clearMeasureOrder() {
        InvokeDynamicSupport.bootstrap("clearMeasureOrder", $$robo$$com_android_internal_widget_NotificationActionListLayout$clearMeasureOrder(), this);
    }

    @Override
    public void onViewAdded(View view) {
        InvokeDynamicSupport.bootstrap("onViewAdded", $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewAdded(android.view.View ), this, view);
    }

    @Override
    public void onViewRemoved(View view) {
        InvokeDynamicSupport.bootstrap("onViewRemoved", $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewRemoved(android.view.View ), this, view);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_NotificationActionListLayout$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_NotificationActionListLayout$onFinishInflate(), this);
    }

    private void updateHeights() {
        InvokeDynamicSupport.bootstrap("updateHeights", $$robo$$com_android_internal_widget_NotificationActionListLayout$updateHeights(), this);
    }

    @RemotableViewMethod
    public void setEmphasizedMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEmphasizedMode", $$robo$$com_android_internal_widget_NotificationActionListLayout$setEmphasizedMode(boolean ), this, bl);
    }

    public int getExtraMeasureHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getExtraMeasureHeight", $$robo$$com_android_internal_widget_NotificationActionListLayout$getExtraMeasureHeight(), this);
    }

    static {
        RobolectricInternals.classInitializing(NotificationActionListLayout.class);
    }

    public /* synthetic */ NotificationActionListLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationActionListLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

