/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.app.Person;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.util.NotificationColorUtil;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class MessagingLayout
extends FrameLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static float COLOR_SHIFT_AMOUNT = 60.0f;
    private static Pattern IGNORABLE_CHAR_PATTERN;
    private static Pattern SPECIAL_CHAR_PATTERN;
    private static Consumer<MessagingMessage> REMOVE_MESSAGE;
    public static Interpolator LINEAR_OUT_SLOW_IN;
    public static Interpolator FAST_OUT_LINEAR_IN;
    public static Interpolator FAST_OUT_SLOW_IN;
    public static View.OnLayoutChangeListener MESSAGING_PROPERTY_ANIMATOR;
    private List<MessagingMessage> mMessages;
    private List<MessagingMessage> mHistoricMessages;
    private MessagingLinearLayout mMessagingLinearLayout;
    private boolean mShowHistoricMessages;
    private ArrayList<MessagingGroup> mGroups;
    private TextView mTitleView;
    private int mLayoutColor;
    private int mSenderTextColor;
    private int mMessageTextColor;
    private int mAvatarSize;
    private Paint mPaint;
    private Paint mTextPaint;
    private CharSequence mConversationTitle;
    private Icon mAvatarReplacement;
    private boolean mIsOneToOne;
    private ArrayList<MessagingGroup> mAddedGroups;
    private Person mUser;
    private CharSequence mNameReplacement;
    private boolean mDisplayImagesAtEnd;

    private void $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(Context context) {
        this.mMessages = new ArrayList<MessagingMessage>();
        this.mHistoricMessages = new ArrayList<MessagingMessage>();
        this.mGroups = new ArrayList();
        this.mPaint = new Paint(1);
        this.mTextPaint = new Paint();
        this.mAddedGroups = new ArrayList();
    }

    private void $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mMessages = new ArrayList<MessagingMessage>();
        this.mHistoricMessages = new ArrayList<MessagingMessage>();
        this.mGroups = new ArrayList();
        this.mPaint = new Paint(1);
        this.mTextPaint = new Paint();
        this.mAddedGroups = new ArrayList();
    }

    private void $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mMessages = new ArrayList<MessagingMessage>();
        this.mHistoricMessages = new ArrayList<MessagingMessage>();
        this.mGroups = new ArrayList();
        this.mPaint = new Paint(1);
        this.mTextPaint = new Paint();
        this.mAddedGroups = new ArrayList();
    }

    private void $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mMessages = new ArrayList<MessagingMessage>();
        this.mHistoricMessages = new ArrayList<MessagingMessage>();
        this.mGroups = new ArrayList();
        this.mPaint = new Paint(1);
        this.mTextPaint = new Paint();
        this.mAddedGroups = new ArrayList();
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$onFinishInflate() {
        super.onFinishInflate();
        this.mMessagingLinearLayout = (MessagingLinearLayout)this.findViewById(16909125);
        this.mMessagingLinearLayout.setMessagingLayout(this);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int size = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        Rect rect = new Rect(0, 0, size, size);
        this.mMessagingLinearLayout.setClipBounds(rect);
        this.mTitleView = (TextView)this.findViewById(16908310);
        this.mAvatarSize = this.getResources().getDimensionPixelSize(0x1050115);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setAntiAlias(true);
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setAvatarReplacement(Icon icon) {
        this.mAvatarReplacement = icon;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setNameReplacement(CharSequence nameReplacement) {
        this.mNameReplacement = nameReplacement;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setDisplayImagesAtEnd(boolean atEnd) {
        this.mDisplayImagesAtEnd = atEnd;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setData(Bundle extras) {
        Parcelable[] messages = extras.getParcelableArray("android.messages");
        List<Notification.MessagingStyle.Message> newMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(messages);
        Parcelable[] histMessages = extras.getParcelableArray("android.messages.historic");
        List<Notification.MessagingStyle.Message> newHistoricMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(histMessages);
        this.setUser((Person)extras.getParcelable("android.messagingUser"));
        this.mConversationTitle = null;
        TextView headerText = (TextView)this.findViewById(16908938);
        if (headerText != null) {
            this.mConversationTitle = headerText.getText();
        }
        this.addRemoteInputHistoryToMessages(newMessages, extras.getCharSequenceArray("android.remoteInputHistory"));
        boolean showSpinner = extras.getBoolean("android.remoteInputSpinner", false);
        this.bind(newMessages, newHistoricMessages, showSpinner);
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$addRemoteInputHistoryToMessages(List<Notification.MessagingStyle.Message> newMessages, CharSequence[] remoteInputHistory) {
        if (remoteInputHistory == null || remoteInputHistory.length == 0) {
            return;
        }
        for (int i = remoteInputHistory.length - 1; i >= 0; --i) {
            CharSequence message = remoteInputHistory[i];
            newMessages.add(new Notification.MessagingStyle.Message(message, 0L, null, true));
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$bind(List<Notification.MessagingStyle.Message> newMessages, List<Notification.MessagingStyle.Message> newHistoricMessages, boolean showSpinner) {
        List<MessagingMessage> historicMessages = this.createMessages(newHistoricMessages, true);
        List<MessagingMessage> messages = this.createMessages(newMessages, false);
        ArrayList<MessagingGroup> oldGroups = new ArrayList<MessagingGroup>(this.mGroups);
        this.addMessagesToGroups(historicMessages, messages, showSpinner);
        this.removeGroups(oldGroups);
        this.mMessages.forEach(REMOVE_MESSAGE);
        this.mHistoricMessages.forEach(REMOVE_MESSAGE);
        this.mMessages = messages;
        this.mHistoricMessages = historicMessages;
        this.updateHistoricMessageVisibility();
        this.updateTitleAndNamesDisplay();
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$removeGroups(ArrayList<MessagingGroup> oldGroups) {
        int size = oldGroups.size();
        for (int i = 0; i < size; ++i) {
            MessagingGroup group = oldGroups.get(i);
            if (this.mGroups.contains(group)) continue;
            List<MessagingMessage> messages = group.getMessages();
            Runnable endRunnable = () -> {
                this.mMessagingLinearLayout.removeTransientView(group);
                group.recycle();
            };
            boolean wasShown = group.isShown();
            this.mMessagingLinearLayout.removeView(group);
            if (wasShown && !MessagingLinearLayout.isGone(group)) {
                this.mMessagingLinearLayout.addTransientView(group, 0);
                group.removeGroupAnimated(endRunnable);
            } else {
                endRunnable.run();
            }
            this.mMessages.removeAll(messages);
            this.mHistoricMessages.removeAll(messages);
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$updateTitleAndNamesDisplay() {
        MessagingGroup group;
        int i;
        ArrayMap<CharSequence, String> uniqueNames = new ArrayMap<CharSequence, String>();
        ArrayMap<Character, String> uniqueCharacters = new ArrayMap<Character, String>();
        for (int i2 = 0; i2 < this.mGroups.size(); ++i2) {
            MessagingGroup group2 = this.mGroups.get(i2);
            CharSequence senderName = group2.getSenderName();
            if (!group2.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || uniqueNames.containsKey(senderName)) continue;
            String pureSenderName = IGNORABLE_CHAR_PATTERN.matcher(senderName).replaceAll("");
            char c = pureSenderName.charAt(0);
            if (uniqueCharacters.containsKey(Character.valueOf(c))) {
                CharSequence existingName = (CharSequence)uniqueCharacters.get(Character.valueOf(c));
                if (existingName != null) {
                    uniqueNames.put(existingName, this.findNameSplit((String)existingName));
                    uniqueCharacters.put(Character.valueOf(c), null);
                }
                uniqueNames.put(senderName, this.findNameSplit((String)senderName));
                continue;
            }
            uniqueNames.put(senderName, Character.toString(c));
            uniqueCharacters.put(Character.valueOf(c), pureSenderName);
        }
        ArrayMap<CharSequence, Icon> cachedAvatars = new ArrayMap<CharSequence, Icon>();
        for (i = 0; i < this.mGroups.size(); ++i) {
            String symbol;
            Icon cachedIcon;
            group = this.mGroups.get(i);
            boolean isOwnMessage = group.getSender() == this.mUser;
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || this.mIsOneToOne && this.mAvatarReplacement != null && !isOwnMessage || (cachedIcon = group.getAvatarSymbolIfMatching(senderName, symbol = (String)uniqueNames.get(senderName), this.mLayoutColor)) == null) continue;
            cachedAvatars.put(senderName, cachedIcon);
        }
        for (i = 0; i < this.mGroups.size(); ++i) {
            group = this.mGroups.get(i);
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName)) continue;
            if (this.mIsOneToOne && this.mAvatarReplacement != null && group.getSender() != this.mUser) {
                group.setAvatar(this.mAvatarReplacement);
                continue;
            }
            Icon cachedIcon = (Icon)cachedAvatars.get(senderName);
            if (cachedIcon == null) {
                cachedIcon = this.createAvatarSymbol(senderName, (String)uniqueNames.get(senderName), this.mLayoutColor);
                cachedAvatars.put(senderName, cachedIcon);
            }
            group.setCreatedAvatar(cachedIcon, senderName, (String)uniqueNames.get(senderName), this.mLayoutColor);
        }
    }

    private final Icon $$robo$$com_android_internal_widget_MessagingLayout$createAvatarSymbol(CharSequence senderName, String symbol, int layoutColor) {
        if (symbol.isEmpty() || TextUtils.isDigitsOnly(symbol) || SPECIAL_CHAR_PATTERN.matcher(symbol).find()) {
            Icon avatarIcon = Icon.createWithResource(this.getContext(), 17302956);
            avatarIcon.setTint(this.findColor(senderName, layoutColor));
            return avatarIcon;
        }
        Bitmap bitmap = Bitmap.createBitmap(this.mAvatarSize, this.mAvatarSize, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float radius = (float)this.mAvatarSize / 2.0f;
        int color2 = this.findColor(senderName, layoutColor);
        this.mPaint.setColor(color2);
        canvas.drawCircle(radius, radius, radius, this.mPaint);
        boolean needDarkText = ColorUtils.calculateLuminance(color2) > 0.5;
        this.mTextPaint.setColor(needDarkText ? -16777216 : -1);
        this.mTextPaint.setTextSize(symbol.length() == 1 ? (float)this.mAvatarSize * 0.5f : (float)this.mAvatarSize * 0.3f);
        int yPos = (int)(radius - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        canvas.drawText(symbol, radius, yPos, this.mTextPaint);
        return Icon.createWithBitmap(bitmap);
    }

    private final int $$robo$$com_android_internal_widget_MessagingLayout$findColor(CharSequence senderName, int layoutColor) {
        double luminance = NotificationColorUtil.calculateLuminance(layoutColor);
        float shift = (float)(Math.abs(senderName.hashCode()) % 5) / 4.0f - 0.5f;
        shift = (float)((double)shift + Math.max((double)0.3f - luminance, 0.0));
        shift = (float)((double)shift - Math.max((double)0.3f - (1.0 - luminance), 0.0));
        return NotificationColorUtil.getShiftedColor(layoutColor, (int)(shift * 60.0f));
    }

    private final String $$robo$$com_android_internal_widget_MessagingLayout$findNameSplit(String existingName) {
        String[] split = existingName.split(" ");
        if (split.length > 1) {
            return Character.toString(split[0].charAt(0)) + Character.toString(split[1].charAt(0));
        }
        return existingName.substring(0, 1);
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setIsOneToOne(boolean oneToOne) {
        this.mIsOneToOne = oneToOne;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setSenderTextColor(int color2) {
        this.mSenderTextColor = color2;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLayout$setMessageTextColor(int color2) {
        this.mMessageTextColor = color2;
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$setUser(Person user) {
        this.mUser = user;
        if (this.mUser.getIcon() == null) {
            Icon userIcon = Icon.createWithResource(this.getContext(), 17302956);
            userIcon.setTint(this.mLayoutColor);
            this.mUser = this.mUser.toBuilder().setIcon(userIcon).build();
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$addMessagesToGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, boolean showSpinner) {
        ArrayList<List<MessagingMessage>> groups = new ArrayList<List<MessagingMessage>>();
        ArrayList<Person> senders = new ArrayList<Person>();
        this.findGroups(historicMessages, messages, groups, senders);
        this.createGroupViews(groups, senders, showSpinner);
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$createGroupViews(List<List<MessagingMessage>> groups, List<Person> senders, boolean showSpinner) {
        this.mGroups.clear();
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            MessagingMessage message;
            List<MessagingMessage> group = groups.get(groupIndex);
            MessagingGroup newGroup = null;
            for (int messageIndex = group.size() - 1; messageIndex >= 0 && (newGroup = (message = group.get(messageIndex)).getGroup()) == null; --messageIndex) {
            }
            if (newGroup == null) {
                newGroup = MessagingGroup.createGroup(this.mMessagingLinearLayout);
                this.mAddedGroups.add(newGroup);
            }
            newGroup.setDisplayImagesAtEnd(this.mDisplayImagesAtEnd);
            newGroup.setLayoutColor(this.mLayoutColor);
            newGroup.setTextColors(this.mSenderTextColor, this.mMessageTextColor);
            Person sender = senders.get(groupIndex);
            CharSequence nameOverride = null;
            if (sender != this.mUser && this.mNameReplacement != null) {
                nameOverride = this.mNameReplacement;
            }
            newGroup.setSender(sender, nameOverride);
            newGroup.setSending(groupIndex == groups.size() - 1 && showSpinner);
            this.mGroups.add(newGroup);
            if (this.mMessagingLinearLayout.indexOfChild(newGroup) != groupIndex) {
                this.mMessagingLinearLayout.removeView(newGroup);
                this.mMessagingLinearLayout.addView((View)newGroup, groupIndex);
            }
            newGroup.setMessages(group);
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$findGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, List<List<MessagingMessage>> groups, List<Person> senders) {
        CharSequence currentSenderKey = null;
        ArrayList<MessagingMessage> currentGroup = null;
        int histSize = historicMessages.size();
        for (int i = 0; i < histSize + messages.size(); ++i) {
            CharSequence key;
            MessagingMessage message = i < histSize ? historicMessages.get(i) : messages.get(i - histSize);
            boolean isNewGroup = currentGroup == null;
            Person sender = message.getMessage().getSenderPerson();
            CharSequence charSequence = key = sender == null ? null : (sender.getKey() == null ? sender.getName() : sender.getKey());
            if (isNewGroup |= !TextUtils.equals(key, currentSenderKey)) {
                currentGroup = new ArrayList<MessagingMessage>();
                groups.add(currentGroup);
                if (sender == null) {
                    sender = this.mUser;
                }
                senders.add(sender);
                currentSenderKey = key;
            }
            currentGroup.add(message);
        }
    }

    private final List<MessagingMessage> $$robo$$com_android_internal_widget_MessagingLayout$createMessages(List<Notification.MessagingStyle.Message> newMessages, boolean historic) {
        ArrayList<MessagingMessage> result = new ArrayList<MessagingMessage>();
        for (int i = 0; i < newMessages.size(); ++i) {
            Notification.MessagingStyle.Message m = newMessages.get(i);
            MessagingMessage message = this.findAndRemoveMatchingMessage(m);
            if (message == null) {
                message = MessagingMessage.createMessage(this, m);
            }
            message.setIsHistoric(historic);
            result.add(message);
        }
        return result;
    }

    private final MessagingMessage $$robo$$com_android_internal_widget_MessagingLayout$findAndRemoveMatchingMessage(Notification.MessagingStyle.Message m) {
        MessagingMessage existing;
        int i;
        for (i = 0; i < this.mMessages.size(); ++i) {
            existing = this.mMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mMessages.remove(i);
            return existing;
        }
        for (i = 0; i < this.mHistoricMessages.size(); ++i) {
            existing = this.mHistoricMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mHistoricMessages.remove(i);
            return existing;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$showHistoricMessages(boolean show) {
        this.mShowHistoricMessages = show;
        this.updateHistoricMessageVisibility();
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$updateHistoricMessageVisibility() {
        int numHistoric = this.mHistoricMessages.size();
        for (int i = 0; i < numHistoric; ++i) {
            MessagingMessage existing = this.mHistoricMessages.get(i);
            existing.setVisibility(this.mShowHistoricMessages ? 0 : 8);
        }
        int numGroups = this.mGroups.size();
        for (int i = 0; i < numGroups; ++i) {
            MessagingGroup group = this.mGroups.get(i);
            int visibleChildren = 0;
            List<MessagingMessage> messages = group.getMessages();
            int numGroupMessages = messages.size();
            for (int j = 0; j < numGroupMessages; ++j) {
                MessagingMessage message = messages.get(j);
                if (message.getVisibility() == 8) continue;
                ++visibleChildren;
            }
            if (visibleChildren > 0 && group.getVisibility() == 8) {
                group.setVisibility(0);
                continue;
            }
            if (visibleChildren != 0 || group.getVisibility() == 8) continue;
            group.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedGroups.isEmpty()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MessagingLayout this$0;

                private void $$robo$$com_android_internal_widget_MessagingLayout_1$__constructor__(MessagingLayout this$0) {
                    this.this$0 = this$0;
                }

                private final boolean $$robo$$com_android_internal_widget_MessagingLayout_1$onPreDraw() {
                    for (MessagingGroup group : this.this$0.mAddedGroups) {
                        if (!group.isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(group.getAvatar());
                        MessagingPropertyAnimator.fadeIn(group.getSenderView());
                        MessagingPropertyAnimator.startLocalTranslationFrom(group, group.getHeight(), LINEAR_OUT_SLOW_IN);
                    }
                    this.this$0.mAddedGroups.clear();
                    this.this$0.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }

                private void __constructor__(MessagingLayout messagingLayout) {
                    this.$$robo$$com_android_internal_widget_MessagingLayout_1$__constructor__(messagingLayout);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLayout_1$__constructor__(com.android.internal.widget.MessagingLayout ), this, messagingLayout);
                }

                @Override
                public boolean onPreDraw() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$com_android_internal_widget_MessagingLayout_1$onPreDraw(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final MessagingLinearLayout $$robo$$com_android_internal_widget_MessagingLayout$getMessagingLinearLayout() {
        return this.mMessagingLinearLayout;
    }

    private final ArrayList<MessagingGroup> $$robo$$com_android_internal_widget_MessagingLayout$getMessagingGroups() {
        return this.mGroups;
    }

    static void __staticInitializer__() {
        IGNORABLE_CHAR_PATTERN = Pattern.compile("[\\p{C}\\p{Z}]");
        SPECIAL_CHAR_PATTERN = Pattern.compile("[!@#$%&*()_+=|<>?{}\\[\\]~-]");
        REMOVE_MESSAGE = MessagingMessage::removeMessage;
        LINEAR_OUT_SLOW_IN = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
        FAST_OUT_LINEAR_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
        FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
        MESSAGING_PROPERTY_ANIMATOR = new MessagingPropertyAnimator();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_MessagingLayout$__constructor__(context);
    }

    public MessagingLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_MessagingLayout$__constructor__(context, attributeSet);
    }

    public MessagingLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_MessagingLayout$__constructor__(context, attributeSet, n);
    }

    public MessagingLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_MessagingLayout$__constructor__(context, attributeSet, n, n2);
    }

    public MessagingLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_MessagingLayout$onFinishInflate(), this);
    }

    @RemotableViewMethod
    public void setAvatarReplacement(Icon icon) {
        InvokeDynamicSupport.bootstrap("setAvatarReplacement", $$robo$$com_android_internal_widget_MessagingLayout$setAvatarReplacement(android.graphics.drawable.Icon ), this, icon);
    }

    @RemotableViewMethod
    public void setNameReplacement(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setNameReplacement", $$robo$$com_android_internal_widget_MessagingLayout$setNameReplacement(java.lang.CharSequence ), this, charSequence);
    }

    @RemotableViewMethod
    public void setDisplayImagesAtEnd(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDisplayImagesAtEnd", $$robo$$com_android_internal_widget_MessagingLayout$setDisplayImagesAtEnd(boolean ), this, bl);
    }

    @RemotableViewMethod
    public void setData(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setData", $$robo$$com_android_internal_widget_MessagingLayout$setData(android.os.Bundle ), this, bundle);
    }

    private void addRemoteInputHistoryToMessages(List<Notification.MessagingStyle.Message> list, CharSequence[] charSequenceArray) {
        InvokeDynamicSupport.bootstrap("addRemoteInputHistoryToMessages", $$robo$$com_android_internal_widget_MessagingLayout$addRemoteInputHistoryToMessages(java.util.List<android.app.Notification$MessagingStyle$Message> java.lang.CharSequence[] ), this, list, charSequenceArray);
    }

    private void bind(List<Notification.MessagingStyle.Message> list, List<Notification.MessagingStyle.Message> list2, boolean bl) {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$com_android_internal_widget_MessagingLayout$bind(java.util.List<android.app.Notification$MessagingStyle$Message> java.util.List<android.app.Notification$MessagingStyle$Message> boolean ), this, list, list2, bl);
    }

    private void removeGroups(ArrayList<MessagingGroup> arrayList) {
        InvokeDynamicSupport.bootstrap("removeGroups", $$robo$$com_android_internal_widget_MessagingLayout$removeGroups(java.util.ArrayList<com.android.internal.widget.MessagingGroup> ), this, arrayList);
    }

    private void updateTitleAndNamesDisplay() {
        InvokeDynamicSupport.bootstrap("updateTitleAndNamesDisplay", $$robo$$com_android_internal_widget_MessagingLayout$updateTitleAndNamesDisplay(), this);
    }

    public Icon createAvatarSymbol(CharSequence charSequence, String string2, int n) {
        return InvokeDynamicSupport.bootstrap("createAvatarSymbol", $$robo$$com_android_internal_widget_MessagingLayout$createAvatarSymbol(java.lang.CharSequence java.lang.String int ), this, charSequence, string2, n);
    }

    private int findColor(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findColor", $$robo$$com_android_internal_widget_MessagingLayout$findColor(java.lang.CharSequence int ), this, charSequence, n);
    }

    private String findNameSplit(String string2) {
        return InvokeDynamicSupport.bootstrap("findNameSplit", $$robo$$com_android_internal_widget_MessagingLayout$findNameSplit(java.lang.String ), this, string2);
    }

    @RemotableViewMethod
    public void setLayoutColor(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutColor", $$robo$$com_android_internal_widget_MessagingLayout$setLayoutColor(int ), this, n);
    }

    @RemotableViewMethod
    public void setIsOneToOne(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsOneToOne", $$robo$$com_android_internal_widget_MessagingLayout$setIsOneToOne(boolean ), this, bl);
    }

    @RemotableViewMethod
    public void setSenderTextColor(int n) {
        InvokeDynamicSupport.bootstrap("setSenderTextColor", $$robo$$com_android_internal_widget_MessagingLayout$setSenderTextColor(int ), this, n);
    }

    @RemotableViewMethod
    public void setMessageTextColor(int n) {
        InvokeDynamicSupport.bootstrap("setMessageTextColor", $$robo$$com_android_internal_widget_MessagingLayout$setMessageTextColor(int ), this, n);
    }

    public void setUser(Person person) {
        InvokeDynamicSupport.bootstrap("setUser", $$robo$$com_android_internal_widget_MessagingLayout$setUser(android.app.Person ), this, person);
    }

    private void addMessagesToGroups(List<MessagingMessage> list, List<MessagingMessage> list2, boolean bl) {
        InvokeDynamicSupport.bootstrap("addMessagesToGroups", $$robo$$com_android_internal_widget_MessagingLayout$addMessagesToGroups(java.util.List<com.android.internal.widget.MessagingMessage> java.util.List<com.android.internal.widget.MessagingMessage> boolean ), this, list, list2, bl);
    }

    private void createGroupViews(List<List<MessagingMessage>> list, List<Person> list2, boolean bl) {
        InvokeDynamicSupport.bootstrap("createGroupViews", $$robo$$com_android_internal_widget_MessagingLayout$createGroupViews(java.util.List<java.util.List<com.android.internal.widget.MessagingMessage>> java.util.List<android.app.Person> boolean ), this, list, list2, bl);
    }

    private void findGroups(List<MessagingMessage> list, List<MessagingMessage> list2, List<List<MessagingMessage>> list3, List<Person> list4) {
        InvokeDynamicSupport.bootstrap("findGroups", $$robo$$com_android_internal_widget_MessagingLayout$findGroups(java.util.List<com.android.internal.widget.MessagingMessage> java.util.List<com.android.internal.widget.MessagingMessage> java.util.List<java.util.List<com.android.internal.widget.MessagingMessage>> java.util.List<android.app.Person> ), this, list, list2, list3, list4);
    }

    private List<MessagingMessage> createMessages(List<Notification.MessagingStyle.Message> list, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createMessages", $$robo$$com_android_internal_widget_MessagingLayout$createMessages(java.util.List<android.app.Notification$MessagingStyle$Message> boolean ), this, list, bl);
    }

    private MessagingMessage findAndRemoveMatchingMessage(Notification.MessagingStyle.Message message) {
        return InvokeDynamicSupport.bootstrap("findAndRemoveMatchingMessage", $$robo$$com_android_internal_widget_MessagingLayout$findAndRemoveMatchingMessage(android.app.Notification$MessagingStyle$Message ), this, message);
    }

    public void showHistoricMessages(boolean bl) {
        InvokeDynamicSupport.bootstrap("showHistoricMessages", $$robo$$com_android_internal_widget_MessagingLayout$showHistoricMessages(boolean ), this, bl);
    }

    private void updateHistoricMessageVisibility() {
        InvokeDynamicSupport.bootstrap("updateHistoricMessageVisibility", $$robo$$com_android_internal_widget_MessagingLayout$updateHistoricMessageVisibility(), this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_MessagingLayout$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    public MessagingLinearLayout getMessagingLinearLayout() {
        return InvokeDynamicSupport.bootstrap("getMessagingLinearLayout", $$robo$$com_android_internal_widget_MessagingLayout$getMessagingLinearLayout(), this);
    }

    public ArrayList<MessagingGroup> getMessagingGroups() {
        return InvokeDynamicSupport.bootstrap("getMessagingGroups", $$robo$$com_android_internal_widget_MessagingLayout$getMessagingGroups(), this);
    }

    static {
        RobolectricInternals.classInitializing(MessagingLayout.class);
    }

    public /* synthetic */ MessagingLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

