/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pools;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.LocalImageResolver;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingMessageState;
import com.android.internal.widget.MessagingTextMessage;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class MessagingImageMessage
extends ImageView
implements MessagingMessage,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MessagingImageMessage";
    private static Pools.SimplePool<MessagingImageMessage> sInstancePool;
    private MessagingMessageState mState;
    private int mMinImageHeight;
    private Path mPath;
    private int mImageRounding;
    private int mMaxImageHeight;
    private int mIsolatedSize;
    private int mExtraSpacing;
    private Drawable mDrawable;
    private float mAspectRatio;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mIsIsolated;

    private void $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mState = new MessagingMessageState(this);
        this.mPath = new Path();
        this.mMinImageHeight = context.getResources().getDimensionPixelSize(17105177);
        this.mMaxImageHeight = context.getResources().getDimensionPixelSize(17105176);
        this.mImageRounding = context.getResources().getDimensionPixelSize(17105178);
        this.mExtraSpacing = context.getResources().getDimensionPixelSize(17105175);
        this.setMaxHeight(this.mMaxImageHeight);
        this.mIsolatedSize = this.getResources().getDimensionPixelSize(0x1050115);
    }

    private final MessagingMessageState $$robo$$com_android_internal_widget_MessagingImageMessage$getState() {
        return this.mState;
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingImageMessage$setMessage(Notification.MessagingStyle.Message message) {
        Drawable drawable2;
        MessagingMessage.super.setMessage(message);
        try {
            drawable2 = LocalImageResolver.resolveImage(message.getDataUri(), this.getContext());
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            return false;
        }
        int intrinsicHeight = drawable2.getIntrinsicHeight();
        if (intrinsicHeight == 0) {
            Log.w("MessagingImageMessage", "Drawable with 0 intrinsic height was returned");
            return false;
        }
        this.mDrawable = drawable2;
        this.mAspectRatio = (float)this.mDrawable.getIntrinsicWidth() / (float)intrinsicHeight;
        this.setImageDrawable(drawable2);
        this.setContentDescription(message.getText());
        return true;
    }

    private static final MessagingMessage $$robo$$com_android_internal_widget_MessagingImageMessage$createMessage(MessagingLayout layout2, Notification.MessagingStyle.Message m) {
        boolean created;
        MessagingLinearLayout messagingLinearLayout = layout2.getMessagingLinearLayout();
        MessagingImageMessage createdMessage = sInstancePool.acquire();
        if (createdMessage == null) {
            createdMessage = (MessagingImageMessage)LayoutInflater.from(layout2.getContext()).inflate(17367197, (ViewGroup)messagingLinearLayout, false);
            createdMessage.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        if (!(created = createdMessage.setMessage(m))) {
            createdMessage.recycle();
            return MessagingTextMessage.createMessage(layout2, m);
        }
        return createdMessage;
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$onDraw(Canvas canvas) {
        canvas.save();
        canvas.clipPath(this.getRoundedRectPath());
        int width = (int)Math.max((float)this.getActualWidth(), (float)this.getActualHeight() * this.mAspectRatio);
        int height = (int)((float)width / this.mAspectRatio);
        int left = (int)((float)(this.getActualWidth() - width) / 2.0f);
        this.mDrawable.setBounds(left, 0, left + width, height);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    private final Path $$robo$$com_android_internal_widget_MessagingImageMessage$getRoundedRectPath() {
        int left = 0;
        int right = this.getActualWidth();
        int top = 0;
        int bottom = this.getActualHeight();
        this.mPath.reset();
        int width = right - left;
        float roundnessX = this.mImageRounding;
        float roundnessY = this.mImageRounding;
        roundnessX = Math.min((float)(width / 2), roundnessX);
        roundnessY = Math.min((float)((bottom - top) / 2), roundnessY);
        this.mPath.moveTo(left, (float)top + roundnessY);
        this.mPath.quadTo(left, top, (float)left + roundnessX, top);
        this.mPath.lineTo((float)right - roundnessX, top);
        this.mPath.quadTo(right, top, right, (float)top + roundnessY);
        this.mPath.lineTo(right, (float)bottom - roundnessY);
        this.mPath.quadTo(right, bottom, (float)right - roundnessX, bottom);
        this.mPath.lineTo((float)left + roundnessX, bottom);
        this.mPath.quadTo(left, bottom, left, (float)bottom - roundnessY);
        this.mPath.close();
        return this.mPath;
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$recycle() {
        MessagingMessage.super.recycle();
        this.setImageBitmap(null);
        this.mDrawable = null;
        sInstancePool.release(this);
    }

    private static final void $$robo$$com_android_internal_widget_MessagingImageMessage$dropCache() {
        sInstancePool = new Pools.SynchronizedPool<MessagingImageMessage>(10);
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getMeasuredType() {
        boolean measuredTooSmall;
        int measuredHeight = this.getMeasuredHeight();
        int minImageHeight = this.mIsIsolated ? this.mIsolatedSize : this.mMinImageHeight;
        boolean bl = measuredTooSmall = measuredHeight < minImageHeight && measuredHeight != this.mDrawable.getIntrinsicHeight();
        if (measuredTooSmall) {
            return 2;
        }
        if (!this.mIsIsolated && measuredHeight != this.mDrawable.getIntrinsicHeight()) {
            return 1;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$setMaxDisplayedLines(int lines) {
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIsIsolated) {
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), View.MeasureSpec.getSize(heightMeasureSpec));
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setActualWidth(this.getStaticWidth());
        this.setActualHeight(this.getHeight());
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getConsumedLines() {
        return 3;
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$setActualWidth(int actualWidth) {
        this.mActualWidth = actualWidth;
        this.invalidate();
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getActualWidth() {
        return this.mActualWidth;
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$setActualHeight(int actualHeight) {
        this.mActualHeight = actualHeight;
        this.invalidate();
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getActualHeight() {
        return this.mActualHeight;
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getStaticWidth() {
        if (this.mIsIsolated) {
            return this.getWidth();
        }
        return (int)((float)this.getHeight() * this.mAspectRatio);
    }

    private final void $$robo$$com_android_internal_widget_MessagingImageMessage$setIsolated(boolean isolated) {
        if (this.mIsIsolated != isolated) {
            this.mIsIsolated = isolated;
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            layoutParams.topMargin = isolated ? 0 : this.mExtraSpacing;
            this.setLayoutParams(layoutParams);
        }
    }

    private final int $$robo$$com_android_internal_widget_MessagingImageMessage$getExtraSpacing() {
        return this.mExtraSpacing;
    }

    static void __staticInitializer__() {
        sInstancePool = new Pools.SynchronizedPool<MessagingImageMessage>(10);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(context);
    }

    public MessagingImageMessage(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(context, attributeSet);
    }

    public MessagingImageMessage(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(context, attributeSet, n);
    }

    public MessagingImageMessage(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(context, attributeSet, n, n2);
    }

    public MessagingImageMessage(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingImageMessage$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public MessagingMessageState getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_widget_MessagingImageMessage$getState(), this);
    }

    @Override
    public boolean setMessage(Notification.MessagingStyle.Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("setMessage", $$robo$$com_android_internal_widget_MessagingImageMessage$setMessage(android.app.Notification$MessagingStyle$Message ), this, message);
    }

    static MessagingMessage createMessage(MessagingLayout messagingLayout, Notification.MessagingStyle.Message message) {
        return InvokeDynamicSupport.bootstrapStatic("createMessage", $$robo$$com_android_internal_widget_MessagingImageMessage$createMessage(com.android.internal.widget.MessagingLayout android.app.Notification$MessagingStyle$Message ), (MessagingLayout)messagingLayout, (Notification.MessagingStyle.Message)message);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_MessagingImageMessage$onDraw(android.graphics.Canvas ), this, canvas);
    }

    public Path getRoundedRectPath() {
        return InvokeDynamicSupport.bootstrap("getRoundedRectPath", $$robo$$com_android_internal_widget_MessagingImageMessage$getRoundedRectPath(), this);
    }

    @Override
    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$com_android_internal_widget_MessagingImageMessage$recycle(), this);
    }

    public static void dropCache() {
        InvokeDynamicSupport.bootstrapStatic("dropCache", $$robo$$com_android_internal_widget_MessagingImageMessage$dropCache());
    }

    @Override
    public int getMeasuredType() {
        return (int)InvokeDynamicSupport.bootstrap("getMeasuredType", $$robo$$com_android_internal_widget_MessagingImageMessage$getMeasuredType(), this);
    }

    @Override
    public void setMaxDisplayedLines(int n) {
        InvokeDynamicSupport.bootstrap("setMaxDisplayedLines", $$robo$$com_android_internal_widget_MessagingImageMessage$setMaxDisplayedLines(int ), this, n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_MessagingImageMessage$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_MessagingImageMessage$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public int getConsumedLines() {
        return (int)InvokeDynamicSupport.bootstrap("getConsumedLines", $$robo$$com_android_internal_widget_MessagingImageMessage$getConsumedLines(), this);
    }

    public void setActualWidth(int n) {
        InvokeDynamicSupport.bootstrap("setActualWidth", $$robo$$com_android_internal_widget_MessagingImageMessage$setActualWidth(int ), this, n);
    }

    public int getActualWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getActualWidth", $$robo$$com_android_internal_widget_MessagingImageMessage$getActualWidth(), this);
    }

    public void setActualHeight(int n) {
        InvokeDynamicSupport.bootstrap("setActualHeight", $$robo$$com_android_internal_widget_MessagingImageMessage$setActualHeight(int ), this, n);
    }

    public int getActualHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getActualHeight", $$robo$$com_android_internal_widget_MessagingImageMessage$getActualHeight(), this);
    }

    public int getStaticWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getStaticWidth", $$robo$$com_android_internal_widget_MessagingImageMessage$getStaticWidth(), this);
    }

    public void setIsolated(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsolated", $$robo$$com_android_internal_widget_MessagingImageMessage$setIsolated(boolean ), this, bl);
    }

    @Override
    public int getExtraSpacing() {
        return (int)InvokeDynamicSupport.bootstrap("getExtraSpacing", $$robo$$com_android_internal_widget_MessagingImageMessage$getExtraSpacing(), this);
    }

    static {
        RobolectricInternals.classInitializing(MessagingImageMessage.class);
    }

    public /* synthetic */ MessagingImageMessage() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingImageMessage)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

