/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Person;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pools;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RemoteViews;
import com.android.internal.widget.ImageFloatingTextView;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class MessagingGroup
extends LinearLayout
implements MessagingLinearLayout.MessagingChild,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static Pools.SimplePool<MessagingGroup> sInstancePool;
    private MessagingLinearLayout mMessageContainer;
    private ImageFloatingTextView mSenderName;
    private ImageView mAvatarView;
    private String mAvatarSymbol;
    private int mLayoutColor;
    private CharSequence mAvatarName;
    private Icon mAvatarIcon;
    private int mTextColor;
    private int mSendingTextColor;
    private List<MessagingMessage> mMessages;
    private ArrayList<MessagingMessage> mAddedMessages;
    private boolean mFirstLayout;
    private boolean mIsHidingAnimated;
    private boolean mNeedsGeneratedAvatar;
    private Person mSender;
    private boolean mImagesAtEnd;
    private ViewGroup mImageContainer;
    private MessagingImageMessage mIsolatedMessage;
    private boolean mTransformingImages;
    private Point mDisplaySize;
    private ProgressBar mSendingSpinner;
    private View mSendingSpinnerContainer;

    private void $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(Context context) {
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
        this.mAddedMessages = new ArrayList();
        this.mDisplaySize = new Point();
    }

    private void $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(Context context, AttributeSet attrs) {
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
        this.mAddedMessages = new ArrayList();
        this.mDisplaySize = new Point();
    }

    private void $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
        this.mAddedMessages = new ArrayList();
        this.mDisplaySize = new Point();
    }

    private void $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
        this.mAddedMessages = new ArrayList();
        this.mDisplaySize = new Point();
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$onFinishInflate() {
        super.onFinishInflate();
        this.mMessageContainer = (MessagingLinearLayout)this.findViewById(16908931);
        this.mSenderName = (ImageFloatingTextView)this.findViewById(16909061);
        this.mAvatarView = (ImageView)this.findViewById(16909060);
        this.mImageContainer = (ViewGroup)this.findViewById(16909063);
        this.mSendingSpinner = (ProgressBar)this.findViewById(16909064);
        this.mSendingSpinnerContainer = this.findViewById(16909065);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mDisplaySize.x = displayMetrics.widthPixels;
        this.mDisplaySize.y = displayMetrics.heightPixels;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$updateClipRect() {
        Rect clipRect;
        if (this.mSenderName.getVisibility() != 8 && !this.mTransformingImages) {
            ViewGroup parent = (ViewGroup)this.mSenderName.getParent();
            int top = this.getDistanceFromParent(this.mSenderName, parent) - this.getDistanceFromParent(this.mMessageContainer, parent) + this.mSenderName.getHeight();
            int size = Math.max(this.mDisplaySize.x, this.mDisplaySize.y);
            clipRect = new Rect(0, top, size, size);
        } else {
            clipRect = null;
        }
        this.mMessageContainer.setClipBounds(clipRect);
    }

    private final int $$robo$$com_android_internal_widget_MessagingGroup$getDistanceFromParent(View searchedView, ViewGroup parent) {
        int position = 0;
        for (View view = searchedView; view != parent; view = (View)((Object)view.getParent())) {
            position = (int)((float)position + ((float)view.getTop() + view.getTranslationY()));
        }
        return position;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setSender(Person sender, CharSequence nameOverride) {
        this.mSender = sender;
        if (nameOverride == null) {
            nameOverride = sender.getName();
        }
        this.mSenderName.setText(nameOverride);
        boolean bl = this.mNeedsGeneratedAvatar = sender.getIcon() == null;
        if (!this.mNeedsGeneratedAvatar) {
            this.setAvatar(sender.getIcon());
        }
        this.mAvatarView.setVisibility(0);
        this.mSenderName.setVisibility(TextUtils.isEmpty(nameOverride) ? 8 : 0);
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setSending(boolean sending) {
        int visibility;
        int n = visibility = sending ? 0 : 8;
        if (this.mSendingSpinnerContainer.getVisibility() != visibility) {
            this.mSendingSpinnerContainer.setVisibility(visibility);
            this.updateMessageColor();
        }
    }

    private final int $$robo$$com_android_internal_widget_MessagingGroup$calculateSendingTextColor() {
        TypedValue alphaValue = new TypedValue();
        this.mContext.getResources().getValue(17105236, alphaValue, true);
        float alpha = alphaValue.getFloat();
        return Color.valueOf(Color.red(this.mTextColor), Color.green(this.mTextColor), Color.blue(this.mTextColor), alpha).toArgb();
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setAvatar(Icon icon) {
        this.mAvatarIcon = icon;
        this.mAvatarView.setImageIcon(icon);
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
    }

    private static final MessagingGroup $$robo$$com_android_internal_widget_MessagingGroup$createGroup(MessagingLinearLayout layout2) {
        MessagingGroup createdGroup = sInstancePool.acquire();
        if (createdGroup == null) {
            createdGroup = (MessagingGroup)LayoutInflater.from(layout2.getContext()).inflate(17367196, (ViewGroup)layout2, false);
            createdGroup.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        layout2.addView(createdGroup);
        return createdGroup;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$removeMessage(MessagingMessage messagingMessage) {
        View view = messagingMessage.getView();
        boolean wasShown = view.isShown();
        ViewGroup messageParent = (ViewGroup)view.getParent();
        if (messageParent == null) {
            return;
        }
        messageParent.removeView(view);
        Runnable recycleRunnable = () -> {
            messageParent.removeTransientView(view);
            messagingMessage.recycle();
        };
        if (wasShown && !MessagingLinearLayout.isGone(view)) {
            messageParent.addTransientView(view, 0);
            this.performRemoveAnimation(view, recycleRunnable);
        } else {
            recycleRunnable.run();
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$recycle() {
        if (this.mIsolatedMessage != null) {
            this.mImageContainer.removeView(this.mIsolatedMessage);
        }
        for (int i = 0; i < this.mMessages.size(); ++i) {
            MessagingMessage message = this.mMessages.get(i);
            this.mMessageContainer.removeView(message.getView());
            message.recycle();
        }
        this.setAvatar(null);
        this.mAvatarView.setAlpha(1.0f);
        this.mAvatarView.setTranslationY(0.0f);
        this.mSenderName.setAlpha(1.0f);
        this.mSenderName.setTranslationY(0.0f);
        this.setAlpha(1.0f);
        this.mIsolatedMessage = null;
        this.mMessages = null;
        this.mAddedMessages.clear();
        this.mFirstLayout = true;
        MessagingPropertyAnimator.recycle(this);
        sInstancePool.release(this);
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$removeGroupAnimated(Runnable endAction) {
        this.performRemoveAnimation(this, () -> {
            this.setAlpha(1.0f);
            MessagingPropertyAnimator.setToLaidOutPosition(this);
            if (endAction != null) {
                endAction.run();
            }
        });
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$performRemoveAnimation(View message, Runnable endAction) {
        this.performRemoveAnimation(message, -message.getHeight(), endAction);
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$performRemoveAnimation(View view, int disappearTranslation, Runnable endAction) {
        MessagingPropertyAnimator.startLocalTranslationTo(view, disappearTranslation, MessagingLayout.FAST_OUT_LINEAR_IN);
        MessagingPropertyAnimator.fadeOut(view, endAction);
    }

    private final CharSequence $$robo$$com_android_internal_widget_MessagingGroup$getSenderName() {
        return this.mSenderName.getText();
    }

    private static final void $$robo$$com_android_internal_widget_MessagingGroup$dropCache() {
        sInstancePool = new Pools.SynchronizedPool<MessagingGroup>(10);
    }

    private final int $$robo$$com_android_internal_widget_MessagingGroup$getMeasuredType() {
        if (this.mIsolatedMessage != null) {
            return 1;
        }
        boolean hasNormal = false;
        for (int i = this.mMessageContainer.getChildCount() - 1; i >= 0; --i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (child.getVisibility() == 8 || !(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            int type = ((MessagingLinearLayout.MessagingChild)((Object)child)).getMeasuredType();
            boolean tooSmall = type == 2;
            MessagingLinearLayout.LayoutParams lp = (MessagingLinearLayout.LayoutParams)child.getLayoutParams();
            if (tooSmall |= lp.hide) {
                if (hasNormal) {
                    return 1;
                }
                return 2;
            }
            if (type == 1) {
                return 1;
            }
            hasNormal = true;
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_widget_MessagingGroup$getConsumedLines() {
        int result = 0;
        for (int i = 0; i < this.mMessageContainer.getChildCount(); ++i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (!(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            result += ((MessagingLinearLayout.MessagingChild)((Object)child)).getConsumedLines();
        }
        result = this.mIsolatedMessage != null ? Math.max(result, 1) : result;
        return result + 1;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setMaxDisplayedLines(int lines) {
        this.mMessageContainer.setMaxDisplayedLines(lines);
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$hideAnimated() {
        this.setIsHidingAnimated(true);
        this.removeGroupAnimated(() -> this.setIsHidingAnimated(false));
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingGroup$isHidingAnimated() {
        return this.mIsHidingAnimated;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setIsHidingAnimated(boolean isHiding) {
        ViewParent parent = this.getParent();
        this.mIsHidingAnimated = isHiding;
        this.invalidate();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).invalidate();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingGroup$hasOverlappingRendering() {
        return false;
    }

    private final Icon $$robo$$com_android_internal_widget_MessagingGroup$getAvatarSymbolIfMatching(CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (this.mAvatarName.equals(avatarName) && this.mAvatarSymbol.equals(avatarSymbol) && layoutColor == this.mLayoutColor) {
            return this.mAvatarIcon;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setCreatedAvatar(Icon cachedIcon, CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (!this.mAvatarName.equals(avatarName) || !this.mAvatarSymbol.equals(avatarSymbol) || layoutColor != this.mLayoutColor) {
            this.setAvatar(cachedIcon);
            this.mAvatarSymbol = avatarSymbol;
            this.setLayoutColor(layoutColor);
            this.mAvatarName = avatarName;
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setTextColors(int senderTextColor, int messageTextColor) {
        this.mTextColor = messageTextColor;
        this.mSendingTextColor = this.calculateSendingTextColor();
        this.updateMessageColor();
        this.mSenderName.setTextColor(senderTextColor);
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setLayoutColor(int layoutColor) {
        if (layoutColor != this.mLayoutColor) {
            this.mLayoutColor = layoutColor;
            this.mSendingSpinner.setIndeterminateTintList(ColorStateList.valueOf(this.mLayoutColor));
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$updateMessageColor() {
        if (this.mMessages != null) {
            int color2 = this.mSendingSpinnerContainer.getVisibility() == 0 ? this.mSendingTextColor : this.mTextColor;
            for (MessagingMessage message : this.mMessages) {
                message.setColor(message.getMessage().isRemoteInputHistory() ? color2 : this.mTextColor);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setMessages(List<MessagingMessage> group) {
        int textMessageIndex = 0;
        MessagingImageMessage isolatedMessage = null;
        for (int messageIndex = 0; messageIndex < group.size(); ++messageIndex) {
            MessagingMessage message = group.get(messageIndex);
            if (message.getGroup() != this) {
                message.setMessagingGroup(this);
                this.mAddedMessages.add(message);
            }
            boolean isImage = message instanceof MessagingImageMessage;
            if (this.mImagesAtEnd && isImage) {
                isolatedMessage = (MessagingImageMessage)message;
                continue;
            }
            if (this.removeFromParentIfDifferent(message, this.mMessageContainer)) {
                ViewGroup.LayoutParams layoutParams = message.getView().getLayoutParams();
                if (layoutParams != null && !(layoutParams instanceof MessagingLinearLayout.LayoutParams)) {
                    message.getView().setLayoutParams(this.mMessageContainer.generateDefaultLayoutParams());
                }
                this.mMessageContainer.addView(message.getView(), textMessageIndex);
            }
            if (isImage) {
                ((MessagingImageMessage)message).setIsolated(false);
            }
            if (textMessageIndex != this.mMessageContainer.indexOfChild(message.getView())) {
                this.mMessageContainer.removeView(message.getView());
                this.mMessageContainer.addView(message.getView(), textMessageIndex);
            }
            ++textMessageIndex;
        }
        if (isolatedMessage != null) {
            if (this.removeFromParentIfDifferent(isolatedMessage, this.mImageContainer)) {
                this.mImageContainer.removeAllViews();
                this.mImageContainer.addView(isolatedMessage.getView());
            }
            isolatedMessage.setIsolated(true);
        } else if (this.mIsolatedMessage != null) {
            this.mImageContainer.removeAllViews();
        }
        this.mIsolatedMessage = isolatedMessage;
        this.updateImageContainerVisibility();
        this.mMessages = group;
        this.updateMessageColor();
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$updateImageContainerVisibility() {
        this.mImageContainer.setVisibility(this.mIsolatedMessage != null && this.mImagesAtEnd ? 0 : 8);
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingGroup$removeFromParentIfDifferent(MessagingMessage message, ViewGroup newParent) {
        ViewParent parent = message.getView().getParent();
        if (parent != newParent) {
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(message.getView());
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedMessages.isEmpty()) {
            boolean firstLayout = this.mFirstLayout;
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, firstLayout){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ boolean val$firstLayout;
                /* synthetic */ MessagingGroup this$0;

                private void $$robo$$com_android_internal_widget_MessagingGroup_1$__constructor__(MessagingGroup this$0, boolean bl) {
                    this.this$0 = this$0;
                    this.val$firstLayout = bl;
                }

                private final boolean $$robo$$com_android_internal_widget_MessagingGroup_1$onPreDraw() {
                    for (MessagingMessage message : this.this$0.mAddedMessages) {
                        if (!message.getView().isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(message.getView());
                        if (this.val$firstLayout) continue;
                        MessagingPropertyAnimator.startLocalTranslationFrom(message.getView(), message.getView().getHeight(), MessagingLayout.LINEAR_OUT_SLOW_IN);
                    }
                    this.this$0.mAddedMessages.clear();
                    this.this$0.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }

                private void __constructor__(MessagingGroup messagingGroup, boolean bl) {
                    this.$$robo$$com_android_internal_widget_MessagingGroup_1$__constructor__(messagingGroup, bl);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingGroup_1$__constructor__(com.android.internal.widget.MessagingGroup boolean ), this, messagingGroup, bl);
                }

                @Override
                public boolean onPreDraw() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$com_android_internal_widget_MessagingGroup_1$onPreDraw(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        this.mFirstLayout = false;
        this.updateClipRect();
    }

    private final int $$robo$$com_android_internal_widget_MessagingGroup$calculateGroupCompatibility(MessagingGroup otherGroup) {
        if (TextUtils.equals(this.getSenderName(), otherGroup.getSenderName())) {
            int result = 1;
            for (int i = 0; i < this.mMessages.size() && i < otherGroup.mMessages.size(); ++i) {
                MessagingMessage otherMessage;
                MessagingMessage ownMessage = this.mMessages.get(this.mMessages.size() - 1 - i);
                if (!ownMessage.sameAs(otherMessage = otherGroup.mMessages.get(otherGroup.mMessages.size() - 1 - i))) {
                    return result;
                }
                ++result;
            }
            return result;
        }
        return 0;
    }

    private final View $$robo$$com_android_internal_widget_MessagingGroup$getSenderView() {
        return this.mSenderName;
    }

    private final View $$robo$$com_android_internal_widget_MessagingGroup$getAvatar() {
        return this.mAvatarView;
    }

    private final MessagingLinearLayout $$robo$$com_android_internal_widget_MessagingGroup$getMessageContainer() {
        return this.mMessageContainer;
    }

    private final MessagingImageMessage $$robo$$com_android_internal_widget_MessagingGroup$getIsolatedMessage() {
        return this.mIsolatedMessage;
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingGroup$needsGeneratedAvatar() {
        return this.mNeedsGeneratedAvatar;
    }

    private final Person $$robo$$com_android_internal_widget_MessagingGroup$getSender() {
        return this.mSender;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setTransformingImages(boolean transformingImages) {
        this.mTransformingImages = transformingImages;
    }

    private final void $$robo$$com_android_internal_widget_MessagingGroup$setDisplayImagesAtEnd(boolean atEnd) {
        if (this.mImagesAtEnd != atEnd) {
            this.mImagesAtEnd = atEnd;
            this.updateImageContainerVisibility();
        }
    }

    private final List<MessagingMessage> $$robo$$com_android_internal_widget_MessagingGroup$getMessages() {
        return this.mMessages;
    }

    static void __staticInitializer__() {
        sInstancePool = new Pools.SynchronizedPool<MessagingGroup>(10);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_MessagingGroup$__constructor__(context);
    }

    public MessagingGroup(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_MessagingGroup$__constructor__(context, attributeSet);
    }

    public MessagingGroup(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_MessagingGroup$__constructor__(context, attributeSet, n);
    }

    public MessagingGroup(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_MessagingGroup$__constructor__(context, attributeSet, n, n2);
    }

    public MessagingGroup(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingGroup$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_MessagingGroup$onFinishInflate(), this);
    }

    public void updateClipRect() {
        InvokeDynamicSupport.bootstrap("updateClipRect", $$robo$$com_android_internal_widget_MessagingGroup$updateClipRect(), this);
    }

    private int getDistanceFromParent(View view, ViewGroup viewGroup) {
        return (int)InvokeDynamicSupport.bootstrap("getDistanceFromParent", $$robo$$com_android_internal_widget_MessagingGroup$getDistanceFromParent(android.view.View android.view.ViewGroup ), this, view, viewGroup);
    }

    public void setSender(Person person, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setSender", $$robo$$com_android_internal_widget_MessagingGroup$setSender(android.app.Person java.lang.CharSequence ), this, person, charSequence);
    }

    public void setSending(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSending", $$robo$$com_android_internal_widget_MessagingGroup$setSending(boolean ), this, bl);
    }

    private int calculateSendingTextColor() {
        return (int)InvokeDynamicSupport.bootstrap("calculateSendingTextColor", $$robo$$com_android_internal_widget_MessagingGroup$calculateSendingTextColor(), this);
    }

    public void setAvatar(Icon icon) {
        InvokeDynamicSupport.bootstrap("setAvatar", $$robo$$com_android_internal_widget_MessagingGroup$setAvatar(android.graphics.drawable.Icon ), this, icon);
    }

    static MessagingGroup createGroup(MessagingLinearLayout messagingLinearLayout) {
        return InvokeDynamicSupport.bootstrapStatic("createGroup", $$robo$$com_android_internal_widget_MessagingGroup$createGroup(com.android.internal.widget.MessagingLinearLayout ), (MessagingLinearLayout)messagingLinearLayout);
    }

    public void removeMessage(MessagingMessage messagingMessage) {
        InvokeDynamicSupport.bootstrap("removeMessage", $$robo$$com_android_internal_widget_MessagingGroup$removeMessage(com.android.internal.widget.MessagingMessage ), this, messagingMessage);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$com_android_internal_widget_MessagingGroup$recycle(), this);
    }

    public void removeGroupAnimated(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("removeGroupAnimated", $$robo$$com_android_internal_widget_MessagingGroup$removeGroupAnimated(java.lang.Runnable ), this, runnable);
    }

    public void performRemoveAnimation(View view, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("performRemoveAnimation", $$robo$$com_android_internal_widget_MessagingGroup$performRemoveAnimation(android.view.View java.lang.Runnable ), this, view, runnable);
    }

    private void performRemoveAnimation(View view, int n, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("performRemoveAnimation", $$robo$$com_android_internal_widget_MessagingGroup$performRemoveAnimation(android.view.View int java.lang.Runnable ), this, view, n, runnable);
    }

    public CharSequence getSenderName() {
        return InvokeDynamicSupport.bootstrap("getSenderName", $$robo$$com_android_internal_widget_MessagingGroup$getSenderName(), this);
    }

    public static void dropCache() {
        InvokeDynamicSupport.bootstrapStatic("dropCache", $$robo$$com_android_internal_widget_MessagingGroup$dropCache());
    }

    @Override
    public int getMeasuredType() {
        return (int)InvokeDynamicSupport.bootstrap("getMeasuredType", $$robo$$com_android_internal_widget_MessagingGroup$getMeasuredType(), this);
    }

    @Override
    public int getConsumedLines() {
        return (int)InvokeDynamicSupport.bootstrap("getConsumedLines", $$robo$$com_android_internal_widget_MessagingGroup$getConsumedLines(), this);
    }

    @Override
    public void setMaxDisplayedLines(int n) {
        InvokeDynamicSupport.bootstrap("setMaxDisplayedLines", $$robo$$com_android_internal_widget_MessagingGroup$setMaxDisplayedLines(int ), this, n);
    }

    @Override
    public void hideAnimated() {
        InvokeDynamicSupport.bootstrap("hideAnimated", $$robo$$com_android_internal_widget_MessagingGroup$hideAnimated(), this);
    }

    @Override
    public boolean isHidingAnimated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidingAnimated", $$robo$$com_android_internal_widget_MessagingGroup$isHidingAnimated(), this);
    }

    private void setIsHidingAnimated(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsHidingAnimated", $$robo$$com_android_internal_widget_MessagingGroup$setIsHidingAnimated(boolean ), this, bl);
    }

    @Override
    public boolean hasOverlappingRendering() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasOverlappingRendering", $$robo$$com_android_internal_widget_MessagingGroup$hasOverlappingRendering(), this);
    }

    public Icon getAvatarSymbolIfMatching(CharSequence charSequence, String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getAvatarSymbolIfMatching", $$robo$$com_android_internal_widget_MessagingGroup$getAvatarSymbolIfMatching(java.lang.CharSequence java.lang.String int ), this, charSequence, string2, n);
    }

    public void setCreatedAvatar(Icon icon, CharSequence charSequence, String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCreatedAvatar", $$robo$$com_android_internal_widget_MessagingGroup$setCreatedAvatar(android.graphics.drawable.Icon java.lang.CharSequence java.lang.String int ), this, icon, charSequence, string2, n);
    }

    public void setTextColors(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTextColors", $$robo$$com_android_internal_widget_MessagingGroup$setTextColors(int int ), this, n, n2);
    }

    public void setLayoutColor(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutColor", $$robo$$com_android_internal_widget_MessagingGroup$setLayoutColor(int ), this, n);
    }

    private void updateMessageColor() {
        InvokeDynamicSupport.bootstrap("updateMessageColor", $$robo$$com_android_internal_widget_MessagingGroup$updateMessageColor(), this);
    }

    public void setMessages(List<MessagingMessage> list) {
        InvokeDynamicSupport.bootstrap("setMessages", $$robo$$com_android_internal_widget_MessagingGroup$setMessages(java.util.List<com.android.internal.widget.MessagingMessage> ), this, list);
    }

    private void updateImageContainerVisibility() {
        InvokeDynamicSupport.bootstrap("updateImageContainerVisibility", $$robo$$com_android_internal_widget_MessagingGroup$updateImageContainerVisibility(), this);
    }

    private boolean removeFromParentIfDifferent(MessagingMessage messagingMessage, ViewGroup viewGroup) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeFromParentIfDifferent", $$robo$$com_android_internal_widget_MessagingGroup$removeFromParentIfDifferent(com.android.internal.widget.MessagingMessage android.view.ViewGroup ), this, messagingMessage, viewGroup);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_MessagingGroup$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    public int calculateGroupCompatibility(MessagingGroup messagingGroup) {
        return (int)InvokeDynamicSupport.bootstrap("calculateGroupCompatibility", $$robo$$com_android_internal_widget_MessagingGroup$calculateGroupCompatibility(com.android.internal.widget.MessagingGroup ), this, messagingGroup);
    }

    public View getSenderView() {
        return InvokeDynamicSupport.bootstrap("getSenderView", $$robo$$com_android_internal_widget_MessagingGroup$getSenderView(), this);
    }

    public View getAvatar() {
        return InvokeDynamicSupport.bootstrap("getAvatar", $$robo$$com_android_internal_widget_MessagingGroup$getAvatar(), this);
    }

    public MessagingLinearLayout getMessageContainer() {
        return InvokeDynamicSupport.bootstrap("getMessageContainer", $$robo$$com_android_internal_widget_MessagingGroup$getMessageContainer(), this);
    }

    public MessagingImageMessage getIsolatedMessage() {
        return InvokeDynamicSupport.bootstrap("getIsolatedMessage", $$robo$$com_android_internal_widget_MessagingGroup$getIsolatedMessage(), this);
    }

    public boolean needsGeneratedAvatar() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsGeneratedAvatar", $$robo$$com_android_internal_widget_MessagingGroup$needsGeneratedAvatar(), this);
    }

    public Person getSender() {
        return InvokeDynamicSupport.bootstrap("getSender", $$robo$$com_android_internal_widget_MessagingGroup$getSender(), this);
    }

    public void setTransformingImages(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTransformingImages", $$robo$$com_android_internal_widget_MessagingGroup$setTransformingImages(boolean ), this, bl);
    }

    public void setDisplayImagesAtEnd(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDisplayImagesAtEnd", $$robo$$com_android_internal_widget_MessagingGroup$setDisplayImagesAtEnd(boolean ), this, bl);
    }

    public List<MessagingMessage> getMessages() {
        return InvokeDynamicSupport.bootstrap("getMessages", $$robo$$com_android_internal_widget_MessagingGroup$getMessages(), this);
    }

    static {
        RobolectricInternals.classInitializing(MessagingGroup.class);
    }

    public /* synthetic */ MessagingGroup() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingGroup)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

