/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.SparseArray;
import android.view.DisplayListCanvas;
import android.view.MotionEvent;
import android.view.RenderNodeAnimator;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import com.android.internal.widget.LockPatternUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LockPatternView
extends View
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int ASPECT_SQUARE = 0;
    private static int ASPECT_LOCK_WIDTH = 1;
    private static int ASPECT_LOCK_HEIGHT = 2;
    private static boolean PROFILE_DRAWING = false;
    private CellState[][] mCellStates;
    private int mDotSize;
    private int mDotSizeActivated;
    private int mPathWidth;
    private boolean mDrawingProfilingStarted;
    private Paint mPaint;
    private Paint mPathPaint;
    private static int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static float DRAG_THRESHHOLD = 0.0f;
    public static int VIRTUAL_BASE_VIEW_ID = 1;
    public static boolean DEBUG_A11Y = false;
    private static String TAG = "LockPatternView";
    private OnPatternListener mOnPatternListener;
    private ArrayList<Cell> mPattern;
    private boolean[][] mPatternDrawLookup;
    private float mInProgressX;
    private float mInProgressY;
    private long mAnimatingPeriodStart;
    private long[] mLineFadeStart;
    private DisplayMode mPatternDisplayMode;
    private boolean mInputEnabled;
    private boolean mInStealthMode;
    private boolean mEnableHapticFeedback;
    private boolean mPatternInProgress;
    private boolean mFadePattern;
    private float mHitFactor;
    private float mSquareWidth;
    private float mSquareHeight;
    private Path mCurrentPath;
    private Rect mInvalidate;
    private Rect mTmpInvalidateRect;
    private int mAspect;
    private int mRegularColor;
    private int mErrorColor;
    private int mSuccessColor;
    private Interpolator mFastOutSlowInInterpolator;
    private Interpolator mLinearOutSlowInInterpolator;
    private PatternExploreByTouchHelper mExploreByTouchHelper;
    private AudioManager mAudioManager;
    private Drawable mSelectedDrawable;
    private Drawable mNotSelectedDrawable;
    private boolean mUseLockPatternDrawable;

    private void $$robo$$com_android_internal_widget_LockPatternView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_LockPatternView$__constructor__(Context context, AttributeSet attrs) {
        this.mDrawingProfilingStarted = false;
        this.mPaint = new Paint();
        this.mPathPaint = new Paint();
        this.mPattern = new ArrayList(9);
        this.mPatternDrawLookup = new boolean[3][3];
        this.mInProgressX = -1.0f;
        this.mInProgressY = -1.0f;
        this.mLineFadeStart = new long[9];
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.mInputEnabled = true;
        this.mInStealthMode = false;
        this.mEnableHapticFeedback = true;
        this.mPatternInProgress = false;
        this.mFadePattern = true;
        this.mHitFactor = 0.6f;
        this.mCurrentPath = new Path();
        this.mInvalidate = new Rect();
        this.mTmpInvalidateRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LockPatternView, 0x1110066, 16974998);
        String aspect = a.getString(0);
        this.mAspect = "square".equals(aspect) ? 0 : ("lock_width".equals(aspect) ? 1 : ("lock_height".equals(aspect) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mRegularColor = a.getColor(3, 0);
        this.mErrorColor = a.getColor(1, 0);
        this.mSuccessColor = a.getColor(4, 0);
        int pathColor = a.getColor(2, this.mRegularColor);
        this.mPathPaint.setColor(pathColor);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPathWidth = this.getResources().getDimensionPixelSize(17105160);
        this.mPathPaint.setStrokeWidth(this.mPathWidth);
        this.mDotSize = this.getResources().getDimensionPixelSize(17105161);
        this.mDotSizeActivated = this.getResources().getDimensionPixelSize(17105162);
        this.mUseLockPatternDrawable = this.getResources().getBoolean(17957116);
        if (this.mUseLockPatternDrawable) {
            this.mSelectedDrawable = this.getResources().getDrawable(17302932);
            this.mNotSelectedDrawable = this.getResources().getDrawable(17302930);
        }
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mCellStates = new CellState[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mCellStates[i][j] = new CellState();
                this.mCellStates[i][j].radius = this.mDotSize / 2;
                this.mCellStates[i][j].row = i;
                this.mCellStates[i][j].col = j;
            }
        }
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mExploreByTouchHelper = new PatternExploreByTouchHelper(this, this);
        this.setAccessibilityDelegate(this.mExploreByTouchHelper);
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        a.recycle();
    }

    private final CellState[][] $$robo$$com_android_internal_widget_LockPatternView$getCellStates() {
        return this.mCellStates;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternView$isInStealthMode() {
        return this.mInStealthMode;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternView$isTactileFeedbackEnabled() {
        return this.mEnableHapticFeedback;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setInStealthMode(boolean inStealthMode) {
        this.mInStealthMode = inStealthMode;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setFadePattern(boolean fadePattern) {
        this.mFadePattern = fadePattern;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setTactileFeedbackEnabled(boolean tactileFeedbackEnabled) {
        this.mEnableHapticFeedback = tactileFeedbackEnabled;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setPattern(DisplayMode displayMode, List<Cell> pattern) {
        this.mPattern.clear();
        this.mPattern.addAll(pattern);
        this.clearPatternDrawLookup();
        for (Cell cell : pattern) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell first = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(first.getColumn());
            this.mInProgressY = this.getCenterYForRow(first.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimation(CellState cellState, float startAlpha, float endAlpha, float startTranslationY, float endTranslationY, float startScale, float endScale, long delay, long duration, Interpolator interpolator2, Runnable finishRunnable) {
        if (this.isHardwareAccelerated()) {
            this.startCellStateAnimationHw(cellState, startAlpha, endAlpha, startTranslationY, endTranslationY, startScale, endScale, delay, duration, interpolator2, finishRunnable);
        } else {
            this.startCellStateAnimationSw(cellState, startAlpha, endAlpha, startTranslationY, endTranslationY, startScale, endScale, delay, duration, interpolator2, finishRunnable);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimationSw(CellState cellState, float startAlpha, float endAlpha, float startTranslationY, float endTranslationY, float startScale, float endScale, long delay, long duration, Interpolator interpolator2, Runnable finishRunnable) {
        cellState.alpha = startAlpha;
        cellState.translationY = startTranslationY;
        cellState.radius = (float)(this.mDotSize / 2) * startScale;
        ValueAnimator animator2 = ValueAnimator.ofFloat(0.0f, 1.0f);
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, cellState, startAlpha, endAlpha, startTranslationY, endTranslationY, startScale, endScale){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$cellState;
            /* synthetic */ float val$startAlpha;
            /* synthetic */ float val$endAlpha;
            /* synthetic */ float val$startTranslationY;
            /* synthetic */ float val$endTranslationY;
            /* synthetic */ float val$startScale;
            /* synthetic */ float val$endScale;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_1$__constructor__(LockPatternView this$0, CellState cellState, float f, float f2, float f3, float f4, float f5, float f6) {
                this.this$0 = this$0;
                this.val$cellState = cellState;
                this.val$startAlpha = f;
                this.val$endAlpha = f2;
                this.val$startTranslationY = f3;
                this.val$endTranslationY = f4;
                this.val$startScale = f5;
                this.val$endScale = f6;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_1$onAnimationUpdate(ValueAnimator animation) {
                float t = ((Float)animation.getAnimatedValue()).floatValue();
                this.val$cellState.alpha = (1.0f - t) * this.val$startAlpha + t * this.val$endAlpha;
                this.val$cellState.translationY = (1.0f - t) * this.val$startTranslationY + t * this.val$endTranslationY;
                this.val$cellState.radius = (float)(this.this$0.mDotSize / 2) * ((1.0f - t) * this.val$startScale + t * this.val$endScale);
                this.this$0.invalidate();
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState, float f, float f2, float f3, float f4, float f5, float f6) {
                this.$$robo$$com_android_internal_widget_LockPatternView_1$__constructor__(lockPatternView, cellState, f, f2, f3, f4, f5, f6);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_1$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState float float float float float float ), this, lockPatternView, cellState, f, f2, f3, f4, f5, f6);
            }

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_LockPatternView_1$onAnimationUpdate(android.animation.ValueAnimator ), this, valueAnimator);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        animator2.addListener((Animator.AnimatorListener)new ShadowedObject(this, finishRunnable){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Runnable val$finishRunnable;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_2$__constructor__(LockPatternView this$0, Runnable runnable) {
                this.this$0 = this$0;
                this.val$finishRunnable = runnable;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_2$onAnimationEnd(Animator animation) {
                if (this.val$finishRunnable != null) {
                    this.val$finishRunnable.run();
                }
            }

            private void __constructor__(LockPatternView lockPatternView, Runnable runnable) {
                this.$$robo$$com_android_internal_widget_LockPatternView_2$__constructor__(lockPatternView, runnable);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_2$__constructor__(com.android.internal.widget.LockPatternView java.lang.Runnable ), this, lockPatternView, runnable);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_LockPatternView_2$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        animator2.start();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimationHw(CellState cellState, float startAlpha, float endAlpha, float startTranslationY, float endTranslationY, float startScale, float endScale, long delay, long duration, Interpolator interpolator2, Runnable finishRunnable) {
        cellState.alpha = endAlpha;
        cellState.translationY = endTranslationY;
        cellState.radius = (float)(this.mDotSize / 2) * endScale;
        cellState.hwAnimating = true;
        cellState.hwCenterY = CanvasProperty.createFloat(this.getCenterYForRow(cellState.row) + startTranslationY);
        cellState.hwCenterX = CanvasProperty.createFloat(this.getCenterXForColumn(cellState.col));
        cellState.hwRadius = CanvasProperty.createFloat((float)(this.mDotSize / 2) * startScale);
        this.mPaint.setColor(this.getCurrentColor(false));
        this.mPaint.setAlpha((int)(startAlpha * 255.0f));
        cellState.hwPaint = CanvasProperty.createPaint(new Paint(this.mPaint));
        this.startRtFloatAnimation(cellState.hwCenterY, this.getCenterYForRow(cellState.row) + endTranslationY, delay, duration, interpolator2);
        this.startRtFloatAnimation(cellState.hwRadius, (float)(this.mDotSize / 2) * endScale, delay, duration, interpolator2);
        this.startRtAlphaAnimation(cellState, endAlpha, delay, duration, interpolator2, (Animator.AnimatorListener)new ShadowedObject(this, cellState, finishRunnable){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$cellState;
            /* synthetic */ Runnable val$finishRunnable;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_3$__constructor__(LockPatternView this$0, CellState cellState, Runnable runnable) {
                this.this$0 = this$0;
                this.val$cellState = cellState;
                this.val$finishRunnable = runnable;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_3$onAnimationEnd(Animator animation) {
                this.val$cellState.hwAnimating = false;
                if (this.val$finishRunnable != null) {
                    this.val$finishRunnable.run();
                }
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState, Runnable runnable) {
                this.$$robo$$com_android_internal_widget_LockPatternView_3$__constructor__(lockPatternView, cellState, runnable);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_3$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState java.lang.Runnable ), this, lockPatternView, cellState, runnable);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_LockPatternView_3$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startRtAlphaAnimation(CellState cellState, float endAlpha, long delay, long duration, Interpolator interpolator2, Animator.AnimatorListener listener) {
        RenderNodeAnimator animator2 = new RenderNodeAnimator(cellState.hwPaint, 1, (int)(endAlpha * 255.0f));
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.setTarget(this);
        animator2.addListener(listener);
        animator2.start();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startRtFloatAnimation(CanvasProperty<Float> property, float endValue, long delay, long duration, Interpolator interpolator2) {
        RenderNodeAnimator animator2 = new RenderNodeAnimator(property, endValue);
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.setTarget(this);
        animator2.start();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$notifyCellAdded() {
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
        this.mExploreByTouchHelper.invalidateRoot();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$notifyPatternStarted() {
        this.sendAccessEvent(17040140);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternStart();
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$notifyPatternDetected() {
        this.sendAccessEvent(17040139);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternDetected(this.mPattern);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$notifyPatternCleared() {
        this.sendAccessEvent(17040138);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCleared();
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$clearPattern() {
        this.resetPattern();
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternView$dispatchHoverEvent(MotionEvent event) {
        boolean handled = super.dispatchHoverEvent(event);
        return handled |= this.mExploreByTouchHelper.dispatchHoverEvent(event);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
                this.mLineFadeStart[i + j] = 0L;
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$disableInput() {
        this.mInputEnabled = false;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$enableInput() {
        this.mInputEnabled = true;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$onSizeChanged(int w, int h, int oldw, int oldh) {
        int width = w - this.mPaddingLeft - this.mPaddingRight;
        this.mSquareWidth = (float)width / 3.0f;
        int height = h - this.mPaddingTop - this.mPaddingBottom;
        this.mSquareHeight = (float)height / 3.0f;
        this.mExploreByTouchHelper.invalidateRoot();
        if (this.mUseLockPatternDrawable) {
            this.mNotSelectedDrawable.setBounds(this.mPaddingLeft, this.mPaddingTop, width, height);
            this.mSelectedDrawable.setBounds(this.mPaddingLeft, this.mPaddingTop, width, height);
        }
    }

    private final int $$robo$$com_android_internal_widget_LockPatternView$resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int viewWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int viewHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        switch (this.mAspect) {
            case 0: {
                viewWidth = viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 1: {
                viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 2: {
                viewWidth = Math.min(viewWidth, viewHeight);
            }
        }
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    private final Cell $$robo$$com_android_internal_widget_LockPatternView$detectAndAddHit(float x, float y) {
        Cell cell = this.checkForNewHit(x, y);
        if (cell != null) {
            Cell fillInGapCell = null;
            ArrayList<Cell> pattern = this.mPattern;
            if (!pattern.isEmpty()) {
                Cell lastCell = pattern.get(pattern.size() - 1);
                int dRow = cell.row - lastCell.row;
                int dColumn = cell.column - lastCell.column;
                int fillInRow = lastCell.row;
                int fillInColumn = lastCell.column;
                if (Math.abs(dRow) == 2 && Math.abs(dColumn) != 1) {
                    fillInRow = lastCell.row + (dRow > 0 ? 1 : -1);
                }
                if (Math.abs(dColumn) == 2 && Math.abs(dRow) != 1) {
                    fillInColumn = lastCell.column + (dColumn > 0 ? 1 : -1);
                }
                fillInGapCell = Cell.of(fillInRow, fillInColumn);
            }
            if (fillInGapCell != null && !this.mPatternDrawLookup[fillInGapCell.row][fillInGapCell.column]) {
                this.addCellToPattern(fillInGapCell);
            }
            this.addCellToPattern(cell);
            if (this.mEnableHapticFeedback) {
                this.performHapticFeedback(1, 3);
            }
            return cell;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$addCellToPattern(Cell newCell) {
        this.mPatternDrawLookup[newCell.getRow()][newCell.getColumn()] = true;
        this.mPattern.add(newCell);
        if (!this.mInStealthMode) {
            this.startCellActivatedAnimation(newCell);
        }
        this.notifyCellAdded();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startCellActivatedAnimation(Cell cell) {
        CellState cellState = this.mCellStates[cell.row][cell.column];
        this.startRadiusAnimation(this.mDotSize / 2, this.mDotSizeActivated / 2, 96L, this.mLinearOutSlowInInterpolator, cellState, new Runnable(this, cellState){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$cellState;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_4$__constructor__(LockPatternView this$0, CellState cellState) {
                this.this$0 = this$0;
                this.val$cellState = cellState;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_4$run() {
                this.this$0.startRadiusAnimation(this.this$0.mDotSizeActivated / 2, this.this$0.mDotSize / 2, 192L, this.this$0.mFastOutSlowInInterpolator, this.val$cellState, null);
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState) {
                this.$$robo$$com_android_internal_widget_LockPatternView_4$__constructor__(lockPatternView, cellState);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_4$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState ), this, lockPatternView, cellState);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_LockPatternView_4$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.startLineEndAnimation(cellState, this.mInProgressX, this.mInProgressY, this.getCenterXForColumn(cell.column), this.getCenterYForRow(cell.row));
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startLineEndAnimation(CellState state, float startX, float startY, float targetX, float targetY) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, state, startX, targetX, startY, targetY){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$state;
            /* synthetic */ float val$startX;
            /* synthetic */ float val$targetX;
            /* synthetic */ float val$startY;
            /* synthetic */ float val$targetY;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_5$__constructor__(LockPatternView this$0, CellState cellState, float f, float f2, float f3, float f4) {
                this.this$0 = this$0;
                this.val$state = cellState;
                this.val$startX = f;
                this.val$targetX = f2;
                this.val$startY = f3;
                this.val$targetY = f4;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_5$onAnimationUpdate(ValueAnimator animation) {
                float t = ((Float)animation.getAnimatedValue()).floatValue();
                this.val$state.lineEndX = (1.0f - t) * this.val$startX + t * this.val$targetX;
                this.val$state.lineEndY = (1.0f - t) * this.val$startY + t * this.val$targetY;
                this.this$0.invalidate();
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState, float f, float f2, float f3, float f4) {
                this.$$robo$$com_android_internal_widget_LockPatternView_5$__constructor__(lockPatternView, cellState, f, f2, f3, f4);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_5$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState float float float float ), this, lockPatternView, cellState, f, f2, f3, f4);
            }

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_LockPatternView_5$onAnimationUpdate(android.animation.ValueAnimator ), this, valueAnimator);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new ShadowedObject(this, state){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$state;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_6$__constructor__(LockPatternView this$0, CellState cellState) {
                this.this$0 = this$0;
                this.val$state = cellState;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_6$onAnimationEnd(Animator animation) {
                this.val$state.lineAnimator = null;
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState) {
                this.$$robo$$com_android_internal_widget_LockPatternView_6$__constructor__(lockPatternView, cellState);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_6$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState ), this, lockPatternView, cellState);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_LockPatternView_6$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        valueAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        valueAnimator.setDuration(100L);
        valueAnimator.start();
        state.lineAnimator = valueAnimator;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$startRadiusAnimation(float start, float end, long duration, Interpolator interpolator2, CellState state, Runnable endRunnable) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(start, end);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, state){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CellState val$state;
            /* synthetic */ LockPatternView this$0;

            private void $$robo$$com_android_internal_widget_LockPatternView_7$__constructor__(LockPatternView this$0, CellState cellState) {
                this.this$0 = this$0;
                this.val$state = cellState;
            }

            private final void $$robo$$com_android_internal_widget_LockPatternView_7$onAnimationUpdate(ValueAnimator animation) {
                this.val$state.radius = ((Float)animation.getAnimatedValue()).floatValue();
                this.this$0.invalidate();
            }

            private void __constructor__(LockPatternView lockPatternView, CellState cellState) {
                this.$$robo$$com_android_internal_widget_LockPatternView_7$__constructor__(lockPatternView, cellState);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_7$__constructor__(com.android.internal.widget.LockPatternView com.android.internal.widget.LockPatternView$CellState ), this, lockPatternView, cellState);
            }

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_LockPatternView_7$onAnimationUpdate(android.animation.ValueAnimator ), this, valueAnimator);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        if (endRunnable != null) {
            valueAnimator.addListener((Animator.AnimatorListener)new ShadowedObject(this, endRunnable){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Runnable val$endRunnable;
                /* synthetic */ LockPatternView this$0;

                private void $$robo$$com_android_internal_widget_LockPatternView_8$__constructor__(LockPatternView this$0, Runnable runnable) {
                    this.this$0 = this$0;
                    this.val$endRunnable = runnable;
                }

                private final void $$robo$$com_android_internal_widget_LockPatternView_8$onAnimationEnd(Animator animation) {
                    this.val$endRunnable.run();
                }

                private void __constructor__(LockPatternView lockPatternView, Runnable runnable) {
                    this.$$robo$$com_android_internal_widget_LockPatternView_8$__constructor__(lockPatternView, runnable);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_8$__constructor__(com.android.internal.widget.LockPatternView java.lang.Runnable ), this, lockPatternView, runnable);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_LockPatternView_8$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        valueAnimator.setInterpolator(interpolator2);
        valueAnimator.setDuration(duration);
        valueAnimator.start();
    }

    private final Cell $$robo$$com_android_internal_widget_LockPatternView$checkForNewHit(float x, float y) {
        int rowHit = this.getRowHit(y);
        if (rowHit < 0) {
            return null;
        }
        int columnHit = this.getColumnHit(x);
        if (columnHit < 0) {
            return null;
        }
        if (this.mPatternDrawLookup[rowHit][columnHit]) {
            return null;
        }
        return Cell.of(rowHit, columnHit);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternView$getRowHit(float y) {
        float squareHeight = this.mSquareHeight;
        float hitSize = squareHeight * this.mHitFactor;
        float offset = (float)this.mPaddingTop + (squareHeight - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitTop = offset + squareHeight * (float)i;
            if (!(y >= hitTop) || !(y <= hitTop + hitSize)) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_widget_LockPatternView$getColumnHit(float x) {
        float squareWidth = this.mSquareWidth;
        float hitSize = squareWidth * this.mHitFactor;
        float offset = (float)this.mPaddingLeft + (squareWidth - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitLeft = offset + squareWidth * (float)i;
            if (!(x >= hitLeft) || !(x <= hitLeft + hitSize)) continue;
            return i;
        }
        return -1;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternView$onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        return super.onHoverEvent(event);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternView$onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.handleActionDown(event);
                return true;
            }
            case 1: {
                this.handleActionUp();
                return true;
            }
            case 2: {
                this.handleActionMove(event);
                return true;
            }
            case 3: {
                if (this.mPatternInProgress) {
                    this.setPatternInProgress(false);
                    this.resetPattern();
                    this.notifyPatternCleared();
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$setPatternInProgress(boolean progress) {
        this.mPatternInProgress = progress;
        this.mExploreByTouchHelper.invalidateRoot();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$handleActionMove(MotionEvent event) {
        float radius = this.mPathWidth;
        int historySize = event.getHistorySize();
        this.mTmpInvalidateRect.setEmpty();
        boolean invalidateNow = false;
        for (int i = 0; i < historySize + 1; ++i) {
            float x = i < historySize ? event.getHistoricalX(i) : event.getX();
            float y = i < historySize ? event.getHistoricalY(i) : event.getY();
            Cell hitCell = this.detectAndAddHit(x, y);
            int patternSize = this.mPattern.size();
            if (hitCell != null && patternSize == 1) {
                this.setPatternInProgress(true);
                this.notifyPatternStarted();
            }
            float dx = Math.abs(x - this.mInProgressX);
            float dy = Math.abs(y - this.mInProgressY);
            if (dx > 0.0f || dy > 0.0f) {
                invalidateNow = true;
            }
            if (!this.mPatternInProgress || patternSize <= 0) continue;
            ArrayList<Cell> pattern = this.mPattern;
            Cell lastCell = pattern.get(patternSize - 1);
            float lastCellCenterX = this.getCenterXForColumn(lastCell.column);
            float lastCellCenterY = this.getCenterYForRow(lastCell.row);
            float left = Math.min(lastCellCenterX, x) - radius;
            float right = Math.max(lastCellCenterX, x) + radius;
            float top = Math.min(lastCellCenterY, y) - radius;
            float bottom = Math.max(lastCellCenterY, y) + radius;
            if (hitCell != null) {
                float width = this.mSquareWidth * 0.5f;
                float height = this.mSquareHeight * 0.5f;
                float hitCellCenterX = this.getCenterXForColumn(hitCell.column);
                float hitCellCenterY = this.getCenterYForRow(hitCell.row);
                left = Math.min(hitCellCenterX - width, left);
                right = Math.max(hitCellCenterX + width, right);
                top = Math.min(hitCellCenterY - height, top);
                bottom = Math.max(hitCellCenterY + height, bottom);
            }
            this.mTmpInvalidateRect.union(Math.round(left), Math.round(top), Math.round(right), Math.round(bottom));
        }
        this.mInProgressX = event.getX();
        this.mInProgressY = event.getY();
        if (invalidateNow) {
            this.mInvalidate.union(this.mTmpInvalidateRect);
            this.invalidate(this.mInvalidate);
            this.mInvalidate.set(this.mTmpInvalidateRect);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$sendAccessEvent(int resId) {
        this.announceForAccessibility(this.mContext.getString(resId));
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$handleActionUp() {
        if (!this.mPattern.isEmpty()) {
            this.setPatternInProgress(false);
            this.cancelLineAnimations();
            this.notifyPatternDetected();
            if (this.mFadePattern) {
                this.clearPatternDrawLookup();
                this.mPatternDisplayMode = DisplayMode.Correct;
            }
            this.invalidate();
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$cancelLineAnimations() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                CellState state = this.mCellStates[i][j];
                if (state.lineAnimator == null) continue;
                state.lineAnimator.cancel();
                state.lineEndX = Float.MIN_VALUE;
                state.lineEndY = Float.MIN_VALUE;
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$handleActionDown(MotionEvent event) {
        this.resetPattern();
        float x = event.getX();
        float y = event.getY();
        Cell hitCell = this.detectAndAddHit(x, y);
        if (hitCell != null) {
            this.setPatternInProgress(true);
            this.mPatternDisplayMode = DisplayMode.Correct;
            this.notifyPatternStarted();
        } else if (this.mPatternInProgress) {
            this.setPatternInProgress(false);
            this.notifyPatternCleared();
        }
        if (hitCell != null) {
            float startX = this.getCenterXForColumn(hitCell.column);
            float startY = this.getCenterYForRow(hitCell.row);
            float widthOffset = this.mSquareWidth / 2.0f;
            float heightOffset = this.mSquareHeight / 2.0f;
            this.invalidate((int)(startX - widthOffset), (int)(startY - heightOffset), (int)(startX + widthOffset), (int)(startY + heightOffset));
        }
        this.mInProgressX = x;
        this.mInProgressY = y;
    }

    private final float $$robo$$com_android_internal_widget_LockPatternView$getCenterXForColumn(int column) {
        return (float)this.mPaddingLeft + (float)column * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private final float $$robo$$com_android_internal_widget_LockPatternView$getCenterYForRow(int row) {
        return (float)this.mPaddingTop + (float)row * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$onDraw(Canvas canvas) {
        boolean drawPath;
        ArrayList<Cell> pattern = this.mPattern;
        int count = pattern.size();
        boolean[][] drawLookup = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            boolean needToUpdateInProgressPoint;
            int oneCycle = (count + 1) * 700;
            int spotInCycle = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % oneCycle;
            int numCircles = spotInCycle / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < numCircles; ++i) {
                Cell cell = pattern.get(i);
                drawLookup[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = needToUpdateInProgressPoint = numCircles > 0 && numCircles < count;
            if (needToUpdateInProgressPoint) {
                float percentageOfNextCircle = (float)(spotInCycle % 700) / 700.0f;
                Cell currentCell = pattern.get(numCircles - 1);
                float centerX = this.getCenterXForColumn(currentCell.column);
                float centerY = this.getCenterYForRow(currentCell.row);
                Cell nextCell = pattern.get(numCircles);
                float dx = percentageOfNextCircle * (this.getCenterXForColumn(nextCell.column) - centerX);
                float dy = percentageOfNextCircle * (this.getCenterYForRow(nextCell.row) - centerY);
                this.mInProgressX = centerX + dx;
                this.mInProgressY = centerY + dy;
            }
            this.invalidate();
        }
        Path currentPath = this.mCurrentPath;
        currentPath.rewind();
        for (int i = 0; i < 3; ++i) {
            float centerY = this.getCenterYForRow(i);
            for (int j = 0; j < 3; ++j) {
                CellState cellState = this.mCellStates[i][j];
                float centerX = this.getCenterXForColumn(j);
                float translationY = cellState.translationY;
                if (this.mUseLockPatternDrawable) {
                    this.drawCellDrawable(canvas, i, j, cellState.radius, drawLookup[i][j]);
                    continue;
                }
                if (this.isHardwareAccelerated() && cellState.hwAnimating) {
                    DisplayListCanvas displayListCanvas = (DisplayListCanvas)canvas;
                    displayListCanvas.drawCircle(cellState.hwCenterX, cellState.hwCenterY, cellState.hwRadius, cellState.hwPaint);
                    continue;
                }
                this.drawCircle(canvas, (int)centerX, (float)((int)centerY) + translationY, cellState.radius, drawLookup[i][j], cellState.alpha);
            }
        }
        boolean bl = drawPath = !this.mInStealthMode;
        if (drawPath) {
            this.mPathPaint.setColor(this.getCurrentColor(true));
            boolean anyCircles = false;
            float lastX = 0.0f;
            float lastY = 0.0f;
            long elapsedRealtime = SystemClock.elapsedRealtime();
            for (int i = 0; i < count; ++i) {
                Cell cell = pattern.get(i);
                if (!drawLookup[cell.row][cell.column]) break;
                anyCircles = true;
                if (this.mLineFadeStart[i] == 0L) {
                    this.mLineFadeStart[i] = SystemClock.elapsedRealtime();
                }
                float centerX = this.getCenterXForColumn(cell.column);
                float centerY = this.getCenterYForRow(cell.row);
                if (i != 0) {
                    int lineFadeVal = (int)Math.min((float)(elapsedRealtime - this.mLineFadeStart[i]) / 2.0f, 255.0f);
                    CellState state = this.mCellStates[cell.row][cell.column];
                    currentPath.rewind();
                    currentPath.moveTo(lastX, lastY);
                    if (state.lineEndX != Float.MIN_VALUE && state.lineEndY != Float.MIN_VALUE) {
                        currentPath.lineTo(state.lineEndX, state.lineEndY);
                        if (this.mFadePattern) {
                            this.mPathPaint.setAlpha(255 - lineFadeVal);
                        } else {
                            this.mPathPaint.setAlpha(255);
                        }
                    } else {
                        currentPath.lineTo(centerX, centerY);
                        if (this.mFadePattern) {
                            this.mPathPaint.setAlpha(255 - lineFadeVal);
                        } else {
                            this.mPathPaint.setAlpha(255);
                        }
                    }
                    canvas.drawPath(currentPath, this.mPathPaint);
                }
                lastX = centerX;
                lastY = centerY;
            }
            if ((this.mPatternInProgress || this.mPatternDisplayMode == DisplayMode.Animate) && anyCircles) {
                currentPath.rewind();
                currentPath.moveTo(lastX, lastY);
                currentPath.lineTo(this.mInProgressX, this.mInProgressY);
                this.mPathPaint.setAlpha((int)(this.calculateLastSegmentAlpha(this.mInProgressX, this.mInProgressY, lastX, lastY) * 255.0f));
                canvas.drawPath(currentPath, this.mPathPaint);
            }
        }
    }

    private final float $$robo$$com_android_internal_widget_LockPatternView$calculateLastSegmentAlpha(float x, float y, float lastX, float lastY) {
        float diffX = x - lastX;
        float diffY = y - lastY;
        float dist = (float)Math.sqrt(diffX * diffX + diffY * diffY);
        float frac = dist / this.mSquareWidth;
        return Math.min(1.0f, Math.max(0.0f, (frac - 0.3f) * 4.0f));
    }

    private final int $$robo$$com_android_internal_widget_LockPatternView$getCurrentColor(boolean partOfPattern) {
        if (!partOfPattern || this.mInStealthMode || this.mPatternInProgress) {
            return this.mRegularColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            return this.mErrorColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Correct || this.mPatternDisplayMode == DisplayMode.Animate) {
            return this.mSuccessColor;
        }
        throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$drawCircle(Canvas canvas, float centerX, float centerY, float radius, boolean partOfPattern, float alpha) {
        this.mPaint.setColor(this.getCurrentColor(partOfPattern));
        this.mPaint.setAlpha((int)(alpha * 255.0f));
        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$drawCellDrawable(Canvas canvas, int i, int j, float radius, boolean partOfPattern) {
        Rect dst = new Rect((int)((float)this.mPaddingLeft + (float)j * this.mSquareWidth), (int)((float)this.mPaddingTop + (float)i * this.mSquareHeight), (int)((float)this.mPaddingLeft + (float)(j + 1) * this.mSquareWidth), (int)((float)this.mPaddingTop + (float)(i + 1) * this.mSquareHeight));
        float scale = radius / (float)(this.mDotSize / 2);
        canvas.save();
        canvas.clipRect(dst);
        canvas.scale(scale, scale, dst.centerX(), dst.centerY());
        if (!partOfPattern || scale > 1.0f) {
            this.mNotSelectedDrawable.draw(canvas);
        } else {
            this.mSelectedDrawable.draw(canvas);
        }
        canvas.restore();
    }

    private final Parcelable $$robo$$com_android_internal_widget_LockPatternView$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mEnableHapticFeedback, null);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternView$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.stringToPattern(ss.getSerializedPattern()));
        this.mPatternDisplayMode = DisplayMode.values()[ss.getDisplayMode()];
        this.mInputEnabled = ss.isInputEnabled();
        this.mInStealthMode = ss.isInStealthMode();
        this.mEnableHapticFeedback = ss.isTactileFeedbackEnabled();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_LockPatternView$__constructor__(context);
    }

    public LockPatternView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_LockPatternView$__constructor__(context, attributeSet);
    }

    public LockPatternView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    public CellState[][] getCellStates() {
        return InvokeDynamicSupport.bootstrap("getCellStates", $$robo$$com_android_internal_widget_LockPatternView$getCellStates(), this);
    }

    public boolean isInStealthMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInStealthMode", $$robo$$com_android_internal_widget_LockPatternView$isInStealthMode(), this);
    }

    public boolean isTactileFeedbackEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTactileFeedbackEnabled", $$robo$$com_android_internal_widget_LockPatternView$isTactileFeedbackEnabled(), this);
    }

    public void setInStealthMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInStealthMode", $$robo$$com_android_internal_widget_LockPatternView$setInStealthMode(boolean ), this, bl);
    }

    public void setFadePattern(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFadePattern", $$robo$$com_android_internal_widget_LockPatternView$setFadePattern(boolean ), this, bl);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTactileFeedbackEnabled", $$robo$$com_android_internal_widget_LockPatternView$setTactileFeedbackEnabled(boolean ), this, bl);
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        InvokeDynamicSupport.bootstrap("setOnPatternListener", $$robo$$com_android_internal_widget_LockPatternView$setOnPatternListener(com.android.internal.widget.LockPatternView$OnPatternListener ), this, onPatternListener);
    }

    public void setPattern(DisplayMode displayMode, List<Cell> list) {
        InvokeDynamicSupport.bootstrap("setPattern", $$robo$$com_android_internal_widget_LockPatternView$setPattern(com.android.internal.widget.LockPatternView$DisplayMode java.util.List<com.android.internal.widget.LockPatternView$Cell> ), this, displayMode, list);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        InvokeDynamicSupport.bootstrap("setDisplayMode", $$robo$$com_android_internal_widget_LockPatternView$setDisplayMode(com.android.internal.widget.LockPatternView$DisplayMode ), this, displayMode);
    }

    public void startCellStateAnimation(CellState cellState, float f, float f2, float f3, float f4, float f5, float f6, long l, long l2, Interpolator interpolator2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startCellStateAnimation", $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimation(com.android.internal.widget.LockPatternView$CellState float float float float float float long long android.view.animation.Interpolator java.lang.Runnable ), this, cellState, f, f2, f3, f4, f5, f6, l, l2, interpolator2, runnable);
    }

    private void startCellStateAnimationSw(CellState cellState, float f, float f2, float f3, float f4, float f5, float f6, long l, long l2, Interpolator interpolator2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startCellStateAnimationSw", $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimationSw(com.android.internal.widget.LockPatternView$CellState float float float float float float long long android.view.animation.Interpolator java.lang.Runnable ), this, cellState, f, f2, f3, f4, f5, f6, l, l2, interpolator2, runnable);
    }

    private void startCellStateAnimationHw(CellState cellState, float f, float f2, float f3, float f4, float f5, float f6, long l, long l2, Interpolator interpolator2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startCellStateAnimationHw", $$robo$$com_android_internal_widget_LockPatternView$startCellStateAnimationHw(com.android.internal.widget.LockPatternView$CellState float float float float float float long long android.view.animation.Interpolator java.lang.Runnable ), this, cellState, f, f2, f3, f4, f5, f6, l, l2, interpolator2, runnable);
    }

    private void startRtAlphaAnimation(CellState cellState, float f, long l, long l2, Interpolator interpolator2, Animator.AnimatorListener animatorListener) {
        InvokeDynamicSupport.bootstrap("startRtAlphaAnimation", $$robo$$com_android_internal_widget_LockPatternView$startRtAlphaAnimation(com.android.internal.widget.LockPatternView$CellState float long long android.view.animation.Interpolator android.animation.Animator$AnimatorListener ), this, cellState, f, l, l2, interpolator2, animatorListener);
    }

    private void startRtFloatAnimation(CanvasProperty<Float> canvasProperty, float f, long l, long l2, Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("startRtFloatAnimation", $$robo$$com_android_internal_widget_LockPatternView$startRtFloatAnimation(android.graphics.CanvasProperty<java.lang.Float> float long long android.view.animation.Interpolator ), this, canvasProperty, f, l, l2, interpolator2);
    }

    private void notifyCellAdded() {
        InvokeDynamicSupport.bootstrap("notifyCellAdded", $$robo$$com_android_internal_widget_LockPatternView$notifyCellAdded(), this);
    }

    private void notifyPatternStarted() {
        InvokeDynamicSupport.bootstrap("notifyPatternStarted", $$robo$$com_android_internal_widget_LockPatternView$notifyPatternStarted(), this);
    }

    private void notifyPatternDetected() {
        InvokeDynamicSupport.bootstrap("notifyPatternDetected", $$robo$$com_android_internal_widget_LockPatternView$notifyPatternDetected(), this);
    }

    private void notifyPatternCleared() {
        InvokeDynamicSupport.bootstrap("notifyPatternCleared", $$robo$$com_android_internal_widget_LockPatternView$notifyPatternCleared(), this);
    }

    public void clearPattern() {
        InvokeDynamicSupport.bootstrap("clearPattern", $$robo$$com_android_internal_widget_LockPatternView$clearPattern(), this);
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$com_android_internal_widget_LockPatternView$dispatchHoverEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void resetPattern() {
        InvokeDynamicSupport.bootstrap("resetPattern", $$robo$$com_android_internal_widget_LockPatternView$resetPattern(), this);
    }

    private void clearPatternDrawLookup() {
        InvokeDynamicSupport.bootstrap("clearPatternDrawLookup", $$robo$$com_android_internal_widget_LockPatternView$clearPatternDrawLookup(), this);
    }

    public void disableInput() {
        InvokeDynamicSupport.bootstrap("disableInput", $$robo$$com_android_internal_widget_LockPatternView$disableInput(), this);
    }

    public void enableInput() {
        InvokeDynamicSupport.bootstrap("enableInput", $$robo$$com_android_internal_widget_LockPatternView$enableInput(), this);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$com_android_internal_widget_LockPatternView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    private int resolveMeasured(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("resolveMeasured", $$robo$$com_android_internal_widget_LockPatternView$resolveMeasured(int int ), this, n, n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_LockPatternView$onMeasure(int int ), this, n, n2);
    }

    private Cell detectAndAddHit(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("detectAndAddHit", $$robo$$com_android_internal_widget_LockPatternView$detectAndAddHit(float float ), this, f, f2);
    }

    private void addCellToPattern(Cell cell) {
        InvokeDynamicSupport.bootstrap("addCellToPattern", $$robo$$com_android_internal_widget_LockPatternView$addCellToPattern(com.android.internal.widget.LockPatternView$Cell ), this, cell);
    }

    private void startCellActivatedAnimation(Cell cell) {
        InvokeDynamicSupport.bootstrap("startCellActivatedAnimation", $$robo$$com_android_internal_widget_LockPatternView$startCellActivatedAnimation(com.android.internal.widget.LockPatternView$Cell ), this, cell);
    }

    private void startLineEndAnimation(CellState cellState, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("startLineEndAnimation", $$robo$$com_android_internal_widget_LockPatternView$startLineEndAnimation(com.android.internal.widget.LockPatternView$CellState float float float float ), this, cellState, f, f2, f3, f4);
    }

    private void startRadiusAnimation(float f, float f2, long l, Interpolator interpolator2, CellState cellState, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startRadiusAnimation", $$robo$$com_android_internal_widget_LockPatternView$startRadiusAnimation(float float long android.view.animation.Interpolator com.android.internal.widget.LockPatternView$CellState java.lang.Runnable ), this, f, f2, l, interpolator2, cellState, runnable);
    }

    private Cell checkForNewHit(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("checkForNewHit", $$robo$$com_android_internal_widget_LockPatternView$checkForNewHit(float float ), this, f, f2);
    }

    private int getRowHit(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getRowHit", $$robo$$com_android_internal_widget_LockPatternView$getRowHit(float ), this, f);
    }

    private int getColumnHit(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getColumnHit", $$robo$$com_android_internal_widget_LockPatternView$getColumnHit(float ), this, f);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$com_android_internal_widget_LockPatternView$onHoverEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_LockPatternView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void setPatternInProgress(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPatternInProgress", $$robo$$com_android_internal_widget_LockPatternView$setPatternInProgress(boolean ), this, bl);
    }

    private void handleActionMove(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleActionMove", $$robo$$com_android_internal_widget_LockPatternView$handleActionMove(android.view.MotionEvent ), this, motionEvent);
    }

    private void sendAccessEvent(int n) {
        InvokeDynamicSupport.bootstrap("sendAccessEvent", $$robo$$com_android_internal_widget_LockPatternView$sendAccessEvent(int ), this, n);
    }

    private void handleActionUp() {
        InvokeDynamicSupport.bootstrap("handleActionUp", $$robo$$com_android_internal_widget_LockPatternView$handleActionUp(), this);
    }

    private void cancelLineAnimations() {
        InvokeDynamicSupport.bootstrap("cancelLineAnimations", $$robo$$com_android_internal_widget_LockPatternView$cancelLineAnimations(), this);
    }

    private void handleActionDown(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleActionDown", $$robo$$com_android_internal_widget_LockPatternView$handleActionDown(android.view.MotionEvent ), this, motionEvent);
    }

    private float getCenterXForColumn(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getCenterXForColumn", $$robo$$com_android_internal_widget_LockPatternView$getCenterXForColumn(int ), this, n);
    }

    private float getCenterYForRow(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getCenterYForRow", $$robo$$com_android_internal_widget_LockPatternView$getCenterYForRow(int ), this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_LockPatternView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    private float calculateLastSegmentAlpha(float f, float f2, float f3, float f4) {
        return (float)InvokeDynamicSupport.bootstrap("calculateLastSegmentAlpha", $$robo$$com_android_internal_widget_LockPatternView$calculateLastSegmentAlpha(float float float float ), this, f, f2, f3, f4);
    }

    private int getCurrentColor(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentColor", $$robo$$com_android_internal_widget_LockPatternView$getCurrentColor(boolean ), this, bl);
    }

    private void drawCircle(Canvas canvas, float f, float f2, float f3, boolean bl, float f4) {
        InvokeDynamicSupport.bootstrap("drawCircle", $$robo$$com_android_internal_widget_LockPatternView$drawCircle(android.graphics.Canvas float float float boolean float ), this, canvas, f, f2, f3, bl, f4);
    }

    private void drawCellDrawable(Canvas canvas, int n, int n2, float f, boolean bl) {
        InvokeDynamicSupport.bootstrap("drawCellDrawable", $$robo$$com_android_internal_widget_LockPatternView$drawCellDrawable(android.graphics.Canvas int int float boolean ), this, canvas, n, n2, f, bl);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_widget_LockPatternView$onSaveInstanceState(), this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_widget_LockPatternView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    public /* synthetic */ LockPatternView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LockPatternView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PatternExploreByTouchHelper
    extends ExploreByTouchHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Rect mTempRect;
        private SparseArray<VirtualViewContainer> mItems;
        /* synthetic */ LockPatternView this$0;

        private void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$__constructor__(LockPatternView lockPatternView, View forView) {
            this.this$0 = lockPatternView;
            this.mTempRect = new Rect();
            this.mItems = new SparseArray();
            for (int i = 1; i < 10; ++i) {
                this.mItems.put(i, new VirtualViewContainer(this, this.getTextForVirtualView(i)));
            }
        }

        private final int $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVirtualViewAt(float x, float y) {
            int id2 = this.getVirtualViewIdForHit(x, y);
            return id2;
        }

        private final void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVisibleVirtualViews(IntArray virtualViewIds) {
            if (!this.this$0.mPatternInProgress) {
                return;
            }
            for (int i = 1; i < 10; ++i) {
                virtualViewIds.add(i);
            }
        }

        private final void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            VirtualViewContainer container = this.mItems.get(virtualViewId);
            if (container != null) {
                event.getText().add(container.description);
            }
        }

        private final void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onPopulateAccessibilityEvent(host, event);
            if (!this.this$0.mPatternInProgress) {
                CharSequence contentDescription = this.this$0.getContext().getText(17040135);
                event.setContentDescription(contentDescription);
            }
        }

        private final void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setText(this.getTextForVirtualView(virtualViewId));
            node.setContentDescription(this.getTextForVirtualView(virtualViewId));
            if (this.this$0.mPatternInProgress) {
                node.setFocusable(true);
                if (this.isClickable(virtualViewId)) {
                    node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
                    node.setClickable(this.isClickable(virtualViewId));
                }
            }
            Rect bounds = this.getBoundsForVirtualView(virtualViewId);
            node.setBoundsInParent(bounds);
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$isClickable(int virtualViewId) {
            if (virtualViewId != Integer.MIN_VALUE) {
                int row = (virtualViewId - 1) / 3;
                int col = (virtualViewId - 1) % 3;
                return !this.this$0.mPatternDrawLookup[row][col];
            }
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    return this.onItemClicked(virtualViewId);
                }
            }
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onItemClicked(int index) {
            this.invalidateVirtualView(index);
            this.sendEventForVirtualView(index, 1);
            return true;
        }

        private final Rect $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getBoundsForVirtualView(int virtualViewId) {
            int ordinal = virtualViewId - 1;
            Rect bounds = this.mTempRect;
            int row = ordinal / 3;
            int col = ordinal % 3;
            CellState cell = this.this$0.mCellStates[row][col];
            float centerX = this.this$0.getCenterXForColumn(col);
            float centerY = this.this$0.getCenterYForRow(row);
            float cellheight = this.this$0.mSquareHeight * this.this$0.mHitFactor * 0.5f;
            float cellwidth = this.this$0.mSquareWidth * this.this$0.mHitFactor * 0.5f;
            bounds.left = (int)(centerX - cellwidth);
            bounds.right = (int)(centerX + cellwidth);
            bounds.top = (int)(centerY - cellheight);
            bounds.bottom = (int)(centerY + cellheight);
            return bounds;
        }

        private final CharSequence $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getTextForVirtualView(int virtualViewId) {
            Resources res = this.this$0.getResources();
            return res.getString(17040137, virtualViewId);
        }

        private final int $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVirtualViewIdForHit(float x, float y) {
            int rowHit = this.this$0.getRowHit(y);
            if (rowHit < 0) {
                return Integer.MIN_VALUE;
            }
            int columnHit = this.this$0.getColumnHit(x);
            if (columnHit < 0) {
                return Integer.MIN_VALUE;
            }
            boolean dotAvailable = this.this$0.mPatternDrawLookup[rowHit][columnHit];
            int dotId = rowHit * 3 + columnHit + 1;
            int view = dotAvailable ? dotId : Integer.MIN_VALUE;
            return view;
        }

        private void __constructor__(LockPatternView lockPatternView, View view) {
            this.$$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$__constructor__(lockPatternView, view);
        }

        public PatternExploreByTouchHelper(LockPatternView lockPatternView, View view) {
            super(view);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$__constructor__(com.android.internal.widget.LockPatternView android.view.View ), this, lockPatternView, view);
        }

        @Override
        protected int getVirtualViewAt(float f, float f2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewAt", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVirtualViewAt(float float ), this, f, f2);
        }

        @Override
        protected void getVisibleVirtualViews(IntArray intArray) {
            InvokeDynamicSupport.bootstrap("getVisibleVirtualViews", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVisibleVirtualViews(android.util.IntArray ), this, intArray);
        }

        @Override
        protected void onPopulateEventForVirtualView(int n, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateEventForVirtualView", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateEventForVirtualView(int android.view.accessibility.AccessibilityEvent ), this, n, accessibilityEvent);
        }

        @Override
        public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateAccessibilityEvent(android.view.View android.view.accessibility.AccessibilityEvent ), this, view, accessibilityEvent);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onPopulateNodeForVirtualView", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPopulateNodeForVirtualView(int android.view.accessibility.AccessibilityNodeInfo ), this, n, accessibilityNodeInfo);
        }

        private boolean isClickable(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isClickable", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$isClickable(int ), this, n);
        }

        @Override
        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPerformActionForVirtualView", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onPerformActionForVirtualView(int int android.os.Bundle ), this, n, n2, bundle);
        }

        boolean onItemClicked(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("onItemClicked", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$onItemClicked(int ), this, n);
        }

        private Rect getBoundsForVirtualView(int n) {
            return InvokeDynamicSupport.bootstrap("getBoundsForVirtualView", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getBoundsForVirtualView(int ), this, n);
        }

        private CharSequence getTextForVirtualView(int n) {
            return InvokeDynamicSupport.bootstrap("getTextForVirtualView", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getTextForVirtualView(int ), this, n);
        }

        private int getVirtualViewIdForHit(float f, float f2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewIdForHit", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper$getVirtualViewIdForHit(float float ), this, f, f2);
        }

        public /* synthetic */ PatternExploreByTouchHelper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternExploreByTouchHelper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class VirtualViewContainer
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            CharSequence description;
            /* synthetic */ PatternExploreByTouchHelper this$1;

            private void $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper_VirtualViewContainer$__constructor__(PatternExploreByTouchHelper this$1, CharSequence description) {
                this.this$1 = this$1;
                this.description = description;
            }

            private void __constructor__(PatternExploreByTouchHelper patternExploreByTouchHelper, CharSequence charSequence) {
                this.$$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper_VirtualViewContainer$__constructor__(patternExploreByTouchHelper, charSequence);
            }

            public VirtualViewContainer(PatternExploreByTouchHelper patternExploreByTouchHelper, CharSequence charSequence) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_PatternExploreByTouchHelper_VirtualViewContainer$__constructor__(com.android.internal.widget.LockPatternView$PatternExploreByTouchHelper java.lang.CharSequence ), this, patternExploreByTouchHelper, charSequence);
            }

            public /* synthetic */ VirtualViewContainer() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VirtualViewContainer)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mSerializedPattern;
        private int mDisplayMode;
        private boolean mInputEnabled;
        private boolean mInStealthMode;
        private boolean mTactileFeedbackEnabled;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(Parcelable superState, String serializedPattern, int displayMode, boolean inputEnabled, boolean inStealthMode, boolean tactileFeedbackEnabled) {
            this.mSerializedPattern = serializedPattern;
            this.mDisplayMode = displayMode;
            this.mInputEnabled = inputEnabled;
            this.mInStealthMode = inStealthMode;
            this.mTactileFeedbackEnabled = tactileFeedbackEnabled;
        }

        private void $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(Parcel in) {
            this.mSerializedPattern = in.readString();
            this.mDisplayMode = in.readInt();
            this.mInputEnabled = (Boolean)in.readValue(null);
            this.mInStealthMode = (Boolean)in.readValue(null);
            this.mTactileFeedbackEnabled = (Boolean)in.readValue(null);
        }

        private final String $$robo$$com_android_internal_widget_LockPatternView_SavedState$getSerializedPattern() {
            return this.mSerializedPattern;
        }

        private final int $$robo$$com_android_internal_widget_LockPatternView_SavedState$getDisplayMode() {
            return this.mDisplayMode;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_SavedState$isInputEnabled() {
            return this.mInputEnabled;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_SavedState$isInStealthMode() {
            return this.mInStealthMode;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternView_SavedState$isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        private final void $$robo$$com_android_internal_widget_LockPatternView_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.mSerializedPattern);
            dest.writeInt(this.mDisplayMode);
            dest.writeValue(this.mInputEnabled);
            dest.writeValue(this.mInStealthMode);
            dest.writeValue(this.mTactileFeedbackEnabled);
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(Parcelable x0, String x1, int x2, boolean x3, boolean x4, boolean x5, 1 x6) {
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in, null);
                }

                private final SavedState[] $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_LockPatternView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_widget_LockPatternView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
            this.$$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(parcelable, string2, n, bl, bl2, bl3);
        }

        public SavedState(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(android.os.Parcelable java.lang.String int boolean boolean boolean ), this, parcelable, string2, n, bl, bl2, bl3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        public String getSerializedPattern() {
            return InvokeDynamicSupport.bootstrap("getSerializedPattern", $$robo$$com_android_internal_widget_LockPatternView_SavedState$getSerializedPattern(), this);
        }

        public int getDisplayMode() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayMode", $$robo$$com_android_internal_widget_LockPatternView_SavedState$getDisplayMode(), this);
        }

        public boolean isInputEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInputEnabled", $$robo$$com_android_internal_widget_LockPatternView_SavedState$isInputEnabled(), this);
        }

        public boolean isInStealthMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInStealthMode", $$robo$$com_android_internal_widget_LockPatternView_SavedState$isInStealthMode(), this);
        }

        public boolean isTactileFeedbackEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTactileFeedbackEnabled", $$robo$$com_android_internal_widget_LockPatternView_SavedState$isTactileFeedbackEnabled(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_widget_LockPatternView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3, 1 var7_7) {
            this.$$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(parcelable, string2, n, bl, bl2, bl3, var7_7);
        }

        public /* synthetic */ SavedState(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3, 1 var7_7) {
            this(parcelable, string2, n, bl, bl2, bl3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(android.os.Parcelable java.lang.String int boolean boolean boolean com.android.internal.widget.LockPatternView$1 ), this, parcelable, string2, n, bl, bl2, bl3, var7_7);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_SavedState$__constructor__(android.os.Parcel com.android.internal.widget.LockPatternView$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnPatternListener {
        public void onPatternStart();

        public void onPatternCleared();

        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternDetected(List<Cell> var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DisplayMode
    extends Enum<DisplayMode> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ DisplayMode Correct;
        public static /* enum */ DisplayMode Animate;
        public static /* enum */ DisplayMode Wrong;
        private static /* synthetic */ DisplayMode[] $VALUES;

        private static final DisplayMode[] $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$values() {
            return (DisplayMode[])$VALUES.clone();
        }

        private static final DisplayMode $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$valueOf(String name) {
            return Enum.valueOf(DisplayMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            Correct = new DisplayMode();
            Animate = new DisplayMode();
            Wrong = new DisplayMode();
            $VALUES = new DisplayMode[]{Correct, Animate, Wrong};
        }

        public static DisplayMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$values());
        }

        public static DisplayMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_widget_LockPatternView_DisplayMode$__constructor__(string2, n);
        }

        public DisplayMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_DisplayMode$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DisplayMode.class);
        }

        public /* synthetic */ DisplayMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CellState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int row;
        int col;
        boolean hwAnimating;
        CanvasProperty<Float> hwRadius;
        CanvasProperty<Float> hwCenterX;
        CanvasProperty<Float> hwCenterY;
        CanvasProperty<Paint> hwPaint;
        float radius;
        float translationY;
        float alpha;
        public float lineEndX;
        public float lineEndY;
        public ValueAnimator lineAnimator;

        private void $$robo$$com_android_internal_widget_LockPatternView_CellState$__constructor__() {
            this.alpha = 1.0f;
            this.lineEndX = Float.MIN_VALUE;
            this.lineEndY = Float.MIN_VALUE;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_LockPatternView_CellState$__constructor__();
        }

        public CellState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_CellState$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Cell
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int row;
        int column;
        private static Cell[][] sCells;

        private static final Cell[][] $$robo$$com_android_internal_widget_LockPatternView_Cell$createCells() {
            Cell[][] res = new Cell[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    res[i][j] = new Cell(i, j);
                }
            }
            return res;
        }

        private void $$robo$$com_android_internal_widget_LockPatternView_Cell$__constructor__(int row, int column) {
            Cell.checkRange(row, column);
            this.row = row;
            this.column = column;
        }

        private final int $$robo$$com_android_internal_widget_LockPatternView_Cell$getRow() {
            return this.row;
        }

        private final int $$robo$$com_android_internal_widget_LockPatternView_Cell$getColumn() {
            return this.column;
        }

        private static final Cell $$robo$$com_android_internal_widget_LockPatternView_Cell$of(int row, int column) {
            Cell.checkRange(row, column);
            return sCells[row][column];
        }

        private static final void $$robo$$com_android_internal_widget_LockPatternView_Cell$checkRange(int row, int column) {
            if (row < 0 || row > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (column < 0 || column > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        private final String $$robo$$com_android_internal_widget_LockPatternView_Cell$toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }

        static void __staticInitializer__() {
            sCells = Cell.createCells();
        }

        private static Cell[][] createCells() {
            return InvokeDynamicSupport.bootstrapStatic("createCells", $$robo$$com_android_internal_widget_LockPatternView_Cell$createCells());
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_LockPatternView_Cell$__constructor__(n, n2);
        }

        public Cell(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternView_Cell$__constructor__(int int ), this, n, n2);
        }

        public int getRow() {
            return (int)InvokeDynamicSupport.bootstrap("getRow", $$robo$$com_android_internal_widget_LockPatternView_Cell$getRow(), this);
        }

        public int getColumn() {
            return (int)InvokeDynamicSupport.bootstrap("getColumn", $$robo$$com_android_internal_widget_LockPatternView_Cell$getColumn(), this);
        }

        public static Cell of(int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("of", $$robo$$com_android_internal_widget_LockPatternView_Cell$of(int int ), (int)n, (int)n2);
        }

        private static void checkRange(int n, int n2) {
            InvokeDynamicSupport.bootstrapStatic("checkRange", $$robo$$com_android_internal_widget_LockPatternView_Cell$checkRange(int int ), (int)n, (int)n2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_LockPatternView_Cell$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(Cell.class);
        }

        public /* synthetic */ Cell() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cell)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

