/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.widget.LinearSmoothScroller;
import com.android.internal.widget.OrientationHelper;
import com.android.internal.widget.RecyclerView;
import com.android.internal.widget.ScrollbarHelper;
import com.android.internal.widget.helper.ItemTouchHelper;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LinearLayoutManager
extends RecyclerView.LayoutManager
implements ItemTouchHelper.ViewDropHandler,
RecyclerView.SmoothScroller.ScrollVectorProvider,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "LinearLayoutManager";
    static boolean DEBUG = false;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    public static int INVALID_OFFSET = Integer.MIN_VALUE;
    private static float MAX_SCROLL_FACTOR = 0.33333334f;
    int mOrientation;
    private LayoutState mLayoutState;
    OrientationHelper mOrientationHelper;
    private boolean mLastStackFromEnd;
    private boolean mReverseLayout;
    boolean mShouldReverseLayout;
    private boolean mStackFromEnd;
    private boolean mSmoothScrollbarEnabled;
    int mPendingScrollPosition;
    int mPendingScrollPositionOffset;
    private boolean mRecycleChildrenOnDetach;
    SavedState mPendingSavedState;
    AnchorInfo mAnchorInfo;
    private LayoutChunkResult mLayoutChunkResult;
    private int mInitialItemPrefetchCount;

    private void $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(Context context, int orientation, boolean reverseLayout) {
        this.mReverseLayout = false;
        this.mShouldReverseLayout = false;
        this.mStackFromEnd = false;
        this.mSmoothScrollbarEnabled = true;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mPendingSavedState = null;
        this.mAnchorInfo = new AnchorInfo(this);
        this.mLayoutChunkResult = new LayoutChunkResult();
        this.mInitialItemPrefetchCount = 2;
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
        this.setAutoMeasureEnabled(true);
    }

    private void $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mReverseLayout = false;
        this.mShouldReverseLayout = false;
        this.mStackFromEnd = false;
        this.mSmoothScrollbarEnabled = true;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mPendingSavedState = null;
        this.mAnchorInfo = new AnchorInfo(this);
        this.mLayoutChunkResult = new LayoutChunkResult();
        this.mInitialItemPrefetchCount = 2;
        RecyclerView.LayoutManager.Properties properties = LinearLayoutManager.getProperties(context, attrs, defStyleAttr, defStyleRes);
        this.setOrientation(properties.orientation);
        this.setReverseLayout(properties.reverseLayout);
        this.setStackFromEnd(properties.stackFromEnd);
        this.setAutoMeasureEnabled(true);
    }

    private final RecyclerView.LayoutParams $$robo$$com_android_internal_widget_LinearLayoutManager$generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setRecycleChildrenOnDetach(boolean recycleChildrenOnDetach) {
        this.mRecycleChildrenOnDetach = recycleChildrenOnDetach;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.getChildCount() > 0) {
            event.setFromIndex(this.findFirstVisibleItemPosition());
            event.setToIndex(this.findLastVisibleItemPosition());
        }
    }

    private final Parcelable $$robo$$com_android_internal_widget_LinearLayoutManager$onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState state = new SavedState();
        if (this.getChildCount() > 0) {
            boolean didLayoutFromEnd;
            this.ensureLayoutState();
            state.mAnchorLayoutFromEnd = didLayoutFromEnd = this.mLastStackFromEnd ^ this.mShouldReverseLayout;
            if (didLayoutFromEnd) {
                View refChild = this.getChildClosestToEnd();
                state.mAnchorOffset = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(refChild);
                state.mAnchorPosition = this.getPosition(refChild);
            } else {
                View refChild = this.getChildClosestToStart();
                state.mAnchorPosition = this.getPosition(refChild);
                state.mAnchorOffset = this.mOrientationHelper.getDecoratedStart(refChild) - this.mOrientationHelper.getStartAfterPadding();
            }
        } else {
            state.invalidateAnchor();
        }
        return state;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = (SavedState)state;
            this.requestLayout();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$canScrollVertically() {
        return this.mOrientation == 1;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setStackFromEnd(boolean stackFromEnd) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mStackFromEnd == stackFromEnd) {
            return;
        }
        this.mStackFromEnd = stackFromEnd;
        this.requestLayout();
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$getStackFromEnd() {
        return this.mStackFromEnd;
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$getOrientation() {
        return this.mOrientation;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation:" + orientation);
        }
        this.assertNotInLayoutOrScroll(null);
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mOrientationHelper = null;
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation == 1 || !this.isLayoutRTL() ? this.mReverseLayout : !this.mReverseLayout;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$getReverseLayout() {
        return this.mReverseLayout;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setReverseLayout(boolean reverseLayout) {
        this.assertNotInLayoutOrScroll(null);
        if (reverseLayout == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = reverseLayout;
        this.requestLayout();
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findViewByPosition(int position) {
        View child;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return null;
        }
        int firstChild = this.getPosition(this.getChildAt(0));
        int viewPosition = position - firstChild;
        if (viewPosition >= 0 && viewPosition < childCount && this.getPosition(child = this.getChildAt(viewPosition)) == position) {
            return child;
        }
        return super.findViewByPosition(position);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$getExtraLayoutSpace(RecyclerView.State state) {
        if (state.hasTargetScrollPosition()) {
            return this.mOrientationHelper.getTotalSpace();
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext());
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll(linearSmoothScroller);
    }

    private final PointF $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollVectorForPosition(int targetPosition) {
        int direction;
        if (this.getChildCount() == 0) {
            return null;
        }
        int firstChildPos = this.getPosition(this.getChildAt(0));
        int n = direction = targetPosition < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
        if (this.mOrientation == 0) {
            return new PointF(direction, 0.0f);
        }
        return new PointF(0.0f, direction);
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int endOffset;
        int startOffset;
        View existing;
        int extraForStart;
        int extraForEnd;
        if ((this.mPendingSavedState != null || this.mPendingScrollPosition != -1) && state.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor()) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
        }
        this.ensureLayoutState();
        this.mLayoutState.mRecycle = false;
        this.resolveShouldLayoutReverse();
        if (!this.mAnchorInfo.mValid || this.mPendingScrollPosition != -1 || this.mPendingSavedState != null) {
            this.mAnchorInfo.reset();
            this.mAnchorInfo.mLayoutFromEnd = this.mShouldReverseLayout ^ this.mStackFromEnd;
            this.updateAnchorInfoForLayout(recycler, state, this.mAnchorInfo);
            this.mAnchorInfo.mValid = true;
        }
        int extra = this.getExtraLayoutSpace(state);
        if (this.mLayoutState.mLastScrollDelta >= 0) {
            extraForEnd = extra;
            extraForStart = 0;
        } else {
            extraForStart = extra;
            extraForEnd = 0;
        }
        extraForStart += this.mOrientationHelper.getStartAfterPadding();
        extraForEnd += this.mOrientationHelper.getEndPadding();
        if (state.isPreLayout() && this.mPendingScrollPosition != -1 && this.mPendingScrollPositionOffset != Integer.MIN_VALUE && (existing = this.findViewByPosition(this.mPendingScrollPosition)) != null) {
            int upcomingOffset;
            int current;
            if (this.mShouldReverseLayout) {
                current = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(existing);
                upcomingOffset = current - this.mPendingScrollPositionOffset;
            } else {
                current = this.mOrientationHelper.getDecoratedStart(existing) - this.mOrientationHelper.getStartAfterPadding();
                upcomingOffset = this.mPendingScrollPositionOffset - current;
            }
            if (upcomingOffset > 0) {
                extraForStart += upcomingOffset;
            } else {
                extraForEnd -= upcomingOffset;
            }
        }
        int firstLayoutDirection = this.mAnchorInfo.mLayoutFromEnd ? (this.mShouldReverseLayout ? 1 : -1) : (this.mShouldReverseLayout ? -1 : 1);
        this.onAnchorReady(recycler, state, this.mAnchorInfo, firstLayoutDirection);
        this.detachAndScrapAttachedViews(recycler);
        this.mLayoutState.mInfinite = this.resolveIsInfinite();
        this.mLayoutState.mIsPreLayout = state.isPreLayout();
        if (this.mAnchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
            int firstElement = this.mLayoutState.mCurrentPosition;
            if (this.mLayoutState.mAvailable > 0) {
                extraForEnd += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForStart = this.mLayoutState.mAvailable;
                this.updateLayoutStateToFillStart(firstElement, startOffset);
                this.mLayoutState.mExtra = extraForStart;
                this.fill(recycler, this.mLayoutState, state, false);
                startOffset = this.mLayoutState.mOffset;
            }
        } else {
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
            int lastElement = this.mLayoutState.mCurrentPosition;
            if (this.mLayoutState.mAvailable > 0) {
                extraForStart += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForEnd = this.mLayoutState.mAvailable;
                this.updateLayoutStateToFillEnd(lastElement, endOffset);
                this.mLayoutState.mExtra = extraForEnd;
                this.fill(recycler, this.mLayoutState, state, false);
                endOffset = this.mLayoutState.mOffset;
            }
        }
        if (this.getChildCount() > 0) {
            int fixOffset;
            if (this.mShouldReverseLayout ^ this.mStackFromEnd) {
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            } else {
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            }
        }
        this.layoutForPredictiveAnimations(recycler, state, startOffset, endOffset);
        if (!state.isPreLayout()) {
            this.mOrientationHelper.onLayoutComplete();
        } else {
            this.mAnchorInfo.reset();
        }
        this.mLastStackFromEnd = this.mStackFromEnd;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mAnchorInfo.reset();
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo, int firstLayoutItemDirection) {
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$layoutForPredictiveAnimations(RecyclerView.Recycler recycler, RecyclerView.State state, int startOffset, int endOffset) {
        if (!state.willRunPredictiveAnimations() || this.getChildCount() == 0 || state.isPreLayout() || !this.supportsPredictiveItemAnimations()) {
            return;
        }
        int scrapExtraStart = 0;
        int scrapExtraEnd = 0;
        List<RecyclerView.ViewHolder> scrapList = recycler.getScrapList();
        int scrapSize = scrapList.size();
        int firstChildPos = this.getPosition(this.getChildAt(0));
        for (int i = 0; i < scrapSize; ++i) {
            int direction;
            RecyclerView.ViewHolder scrap = scrapList.get(i);
            if (scrap.isRemoved()) continue;
            int position = scrap.getLayoutPosition();
            int n = direction = position < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
            if (direction == -1) {
                scrapExtraStart += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
                continue;
            }
            scrapExtraEnd += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
        }
        this.mLayoutState.mScrapList = scrapList;
        if (scrapExtraStart > 0) {
            View anchor = this.getChildClosestToStart();
            this.updateLayoutStateToFillStart(this.getPosition(anchor), startOffset);
            this.mLayoutState.mExtra = scrapExtraStart;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.assignPositionFromScrapList();
            this.fill(recycler, this.mLayoutState, state, false);
        }
        if (scrapExtraEnd > 0) {
            View anchor = this.getChildClosestToEnd();
            this.updateLayoutStateToFillEnd(this.getPosition(anchor), endOffset);
            this.mLayoutState.mExtra = scrapExtraEnd;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.assignPositionFromScrapList();
            this.fill(recycler, this.mLayoutState, state, false);
        }
        this.mLayoutState.mScrapList = null;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorInfoForLayout(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingData(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildren(recycler, state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = this.mStackFromEnd ? state.getItemCount() - 1 : 0;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorFromChildren(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        View referenceChild;
        if (this.getChildCount() == 0) {
            return false;
        }
        View focused = this.getFocusedChild();
        if (focused != null && anchorInfo.isViewValidAsAnchor(focused, state)) {
            anchorInfo.assignFromViewAndKeepVisibleRect(focused);
            return true;
        }
        if (this.mLastStackFromEnd != this.mStackFromEnd) {
            return false;
        }
        View view = referenceChild = anchorInfo.mLayoutFromEnd ? this.findReferenceChildClosestToEnd(recycler, state) : this.findReferenceChildClosestToStart(recycler, state);
        if (referenceChild != null) {
            anchorInfo.assignFromView(referenceChild);
            if (!state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
                boolean notVisible;
                boolean bl = notVisible = this.mOrientationHelper.getDecoratedStart(referenceChild) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd(referenceChild) < this.mOrientationHelper.getStartAfterPadding();
                if (notVisible) {
                    anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                }
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorFromPendingData(RecyclerView.State state, AnchorInfo anchorInfo) {
        if (state.isPreLayout() || this.mPendingScrollPosition == -1) {
            return false;
        }
        if (this.mPendingScrollPosition < 0 || this.mPendingScrollPosition >= state.getItemCount()) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            return false;
        }
        anchorInfo.mPosition = this.mPendingScrollPosition;
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor()) {
            anchorInfo.mLayoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
            anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingSavedState.mAnchorOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingSavedState.mAnchorOffset;
            return true;
        }
        if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
            View child = this.findViewByPosition(this.mPendingScrollPosition);
            if (child != null) {
                int childSize = this.mOrientationHelper.getDecoratedMeasurement(child);
                if (childSize > this.mOrientationHelper.getTotalSpace()) {
                    anchorInfo.assignCoordinateFromPadding();
                    return true;
                }
                int startGap = this.mOrientationHelper.getDecoratedStart(child) - this.mOrientationHelper.getStartAfterPadding();
                if (startGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding();
                    anchorInfo.mLayoutFromEnd = false;
                    return true;
                }
                int endGap = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(child);
                if (endGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getEndAfterPadding();
                    anchorInfo.mLayoutFromEnd = true;
                    return true;
                }
                anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(child) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart(child);
            } else {
                if (this.getChildCount() > 0) {
                    int pos = this.getPosition(this.getChildAt(0));
                    anchorInfo.mLayoutFromEnd = this.mPendingScrollPosition < pos == this.mShouldReverseLayout;
                }
                anchorInfo.assignCoordinateFromPadding();
            }
            return true;
        }
        anchorInfo.mLayoutFromEnd = this.mShouldReverseLayout;
        anchorInfo.mCoordinate = this.mShouldReverseLayout ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingScrollPositionOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
        return true;
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$fixLayoutEndGap(int endOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = this.mOrientationHelper.getEndAfterPadding() - endOffset;
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(-gap, recycler, state);
        if (canOffsetChildren && (gap = this.mOrientationHelper.getEndAfterPadding() - (endOffset += fixOffset)) > 0) {
            this.mOrientationHelper.offsetChildren(gap);
            return gap + fixOffset;
        }
        return fixOffset;
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$fixLayoutStartGap(int startOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = startOffset - this.mOrientationHelper.getStartAfterPadding();
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(gap, recycler, state);
        if (canOffsetChildren && (gap = (startOffset += fixOffset) - this.mOrientationHelper.getStartAfterPadding()) > 0) {
            this.mOrientationHelper.offsetChildren(-gap);
            return fixOffset - gap;
        }
        return fixOffset;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillEnd(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillEnd(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillEnd(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - offset;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mLayoutDirection = 1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillStart(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillStart(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillStart(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = offset - this.mOrientationHelper.getStartAfterPadding();
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
        this.mLayoutState.mLayoutDirection = -1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$ensureLayoutState() {
        if (this.mLayoutState == null) {
            this.mLayoutState = this.createLayoutState();
        }
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = OrientationHelper.createOrientationHelper(this, this.mOrientation);
        }
    }

    private final LayoutState $$robo$$com_android_internal_widget_LinearLayoutManager$createLayoutState() {
        return new LayoutState();
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$scrollToPosition(int position) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$scrollToPositionWithOffset(int position, int offset) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = offset;
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollOffset(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled, this.mShouldReverseLayout);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollExtent(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollExtent(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollRange(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollRange(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutState(int layoutDirection, int requiredSpace, boolean canUseExistingSpace, RecyclerView.State state) {
        int scrollingOffset;
        this.mLayoutState.mInfinite = this.resolveIsInfinite();
        this.mLayoutState.mExtra = this.getExtraLayoutSpace(state);
        this.mLayoutState.mLayoutDirection = layoutDirection;
        if (layoutDirection == 1) {
            this.mLayoutState.mExtra += this.mOrientationHelper.getEndPadding();
            View child = this.getChildClosestToEnd();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd(child);
            scrollingOffset = this.mOrientationHelper.getDecoratedEnd(child) - this.mOrientationHelper.getEndAfterPadding();
        } else {
            View child = this.getChildClosestToStart();
            this.mLayoutState.mExtra += this.mOrientationHelper.getStartAfterPadding();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart(child);
            scrollingOffset = -this.mOrientationHelper.getDecoratedStart(child) + this.mOrientationHelper.getStartAfterPadding();
        }
        this.mLayoutState.mAvailable = requiredSpace;
        if (canUseExistingSpace) {
            this.mLayoutState.mAvailable -= scrollingOffset;
        }
        this.mLayoutState.mScrollingOffset = scrollingOffset;
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$resolveIsInfinite() {
        return this.mOrientationHelper.getMode() == 0 && this.mOrientationHelper.getEnd() == 0;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$collectPrefetchPositionsForLayoutState(RecyclerView.State state, LayoutState layoutState, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int pos = layoutState.mCurrentPosition;
        if (pos >= 0 && pos < state.getItemCount()) {
            layoutPrefetchRegistry.addPosition(pos, layoutState.mScrollingOffset);
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$collectInitialPrefetchPositions(int adapterItemCount, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int anchorPos;
        boolean fromEnd;
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor()) {
            fromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
            anchorPos = this.mPendingSavedState.mAnchorPosition;
        } else {
            this.resolveShouldLayoutReverse();
            fromEnd = this.mShouldReverseLayout;
            anchorPos = this.mPendingScrollPosition == -1 ? (fromEnd ? adapterItemCount - 1 : 0) : this.mPendingScrollPosition;
        }
        int direction = fromEnd ? -1 : 1;
        int targetPos = anchorPos;
        for (int i = 0; i < this.mInitialItemPrefetchCount && targetPos >= 0 && targetPos < adapterItemCount; targetPos += direction, ++i) {
            layoutPrefetchRegistry.addPosition(targetPos, 0);
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$setInitialPrefetchItemCount(int itemCount) {
        this.mInitialItemPrefetchCount = itemCount;
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$getInitialItemPrefetchCount() {
        return this.mInitialItemPrefetchCount;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$collectAdjacentPrefetchPositions(int dx, int dy, RecyclerView.State state, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int delta;
        int n = delta = this.mOrientation == 0 ? dx : dy;
        if (this.getChildCount() == 0 || delta == 0) {
            return;
        }
        int layoutDirection = delta > 0 ? 1 : -1;
        int absDy = Math.abs(delta);
        this.updateLayoutState(layoutDirection, absDy, true, state);
        this.collectPrefetchPositionsForLayoutState(state, this.mLayoutState, layoutPrefetchRegistry);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$scrollBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.mLayoutState.mRecycle = true;
        this.ensureLayoutState();
        int layoutDirection = dy > 0 ? 1 : -1;
        int absDy = Math.abs(dy);
        this.updateLayoutState(layoutDirection, absDy, true, state);
        int consumed = this.mLayoutState.mScrollingOffset + this.fill(recycler, this.mLayoutState, state, false);
        if (consumed < 0) {
            return 0;
        }
        int scrolled = absDy > consumed ? layoutDirection * consumed : dy;
        this.mOrientationHelper.offsetChildren(-scrolled);
        this.mLayoutState.mLastScrollDelta = scrolled;
        return scrolled;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$assertNotInLayoutOrScroll(String message) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(message);
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$recycleChildren(RecyclerView.Recycler recycler, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        if (endIndex > startIndex) {
            for (int i = endIndex - 1; i >= startIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        } else {
            for (int i = startIndex; i > endIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$recycleViewsFromStart(RecyclerView.Recycler recycler, int dt) {
        if (dt < 0) {
            return;
        }
        int limit = dt;
        int childCount = this.getChildCount();
        if (this.mShouldReverseLayout) {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit && this.mOrientationHelper.getTransformedEndWithDecoration(child) <= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit && this.mOrientationHelper.getTransformedEndWithDecoration(child) <= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$recycleViewsFromEnd(RecyclerView.Recycler recycler, int dt) {
        int childCount = this.getChildCount();
        if (dt < 0) {
            return;
        }
        int limit = this.mOrientationHelper.getEnd() - dt;
        if (this.mShouldReverseLayout) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit && this.mOrientationHelper.getTransformedStartWithDecoration(child) >= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        } else {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit && this.mOrientationHelper.getTransformedStartWithDecoration(child) >= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$recycleByLayoutState(RecyclerView.Recycler recycler, LayoutState layoutState) {
        if (!layoutState.mRecycle || layoutState.mInfinite) {
            return;
        }
        if (layoutState.mLayoutDirection == -1) {
            this.recycleViewsFromEnd(recycler, layoutState.mScrollingOffset);
        } else {
            this.recycleViewsFromStart(recycler, layoutState.mScrollingOffset);
        }
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$fill(RecyclerView.Recycler recycler, LayoutState layoutState, RecyclerView.State state, boolean stopOnFocusable) {
        int start = layoutState.mAvailable;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            if (layoutState.mAvailable < 0) {
                layoutState.mScrollingOffset += layoutState.mAvailable;
            }
            this.recycleByLayoutState(recycler, layoutState);
        }
        int remainingSpace = layoutState.mAvailable + layoutState.mExtra;
        LayoutChunkResult layoutChunkResult = this.mLayoutChunkResult;
        while ((layoutState.mInfinite || remainingSpace > 0) && layoutState.hasMore(state)) {
            layoutChunkResult.resetInternal();
            this.layoutChunk(recycler, state, layoutState, layoutChunkResult);
            if (layoutChunkResult.mFinished) break;
            layoutState.mOffset += layoutChunkResult.mConsumed * layoutState.mLayoutDirection;
            if (!layoutChunkResult.mIgnoreConsumed || this.mLayoutState.mScrapList != null || !state.isPreLayout()) {
                layoutState.mAvailable -= layoutChunkResult.mConsumed;
                remainingSpace -= layoutChunkResult.mConsumed;
            }
            if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
                layoutState.mScrollingOffset += layoutChunkResult.mConsumed;
                if (layoutState.mAvailable < 0) {
                    layoutState.mScrollingOffset += layoutState.mAvailable;
                }
                this.recycleByLayoutState(recycler, layoutState);
            }
            if (!stopOnFocusable || !layoutChunkResult.mFocusable) continue;
            break;
        }
        return start - layoutState.mAvailable;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutState layoutState, LayoutChunkResult result) {
        int top;
        int bottom;
        int left;
        int right;
        View view = layoutState.next(recycler);
        if (view == null) {
            result.mFinished = true;
            return;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (layoutState.mScrapList == null) {
            if (this.mShouldReverseLayout == (layoutState.mLayoutDirection == -1)) {
                this.addView(view);
            } else {
                this.addView(view, 0);
            }
        } else if (this.mShouldReverseLayout == (layoutState.mLayoutDirection == -1)) {
            this.addDisappearingView(view);
        } else {
            this.addDisappearingView(view, 0);
        }
        this.measureChildWithMargins(view, 0, 0);
        result.mConsumed = this.mOrientationHelper.getDecoratedMeasurement(view);
        if (this.mOrientation == 1) {
            if (this.isLayoutRTL()) {
                right = this.getWidth() - this.getPaddingRight();
                left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                left = this.getPaddingLeft();
                right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = layoutState.mOffset - result.mConsumed;
            } else {
                top = layoutState.mOffset;
                bottom = layoutState.mOffset + result.mConsumed;
            }
        } else {
            top = this.getPaddingTop();
            bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            if (layoutState.mLayoutDirection == -1) {
                right = layoutState.mOffset;
                left = layoutState.mOffset - result.mConsumed;
            } else {
                left = layoutState.mOffset;
                right = layoutState.mOffset + result.mConsumed;
            }
        }
        this.layoutDecoratedWithMargins(view, left, top, right, bottom);
        if (params.isItemRemoved() || params.isItemChanged()) {
            result.mIgnoreConsumed = true;
        }
        result.mFocusable = view.isFocusable();
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$shouldMeasureTwice() {
        return this.getHeightMode() != 0x40000000 && this.getWidthMode() != 0x40000000 && this.hasFlexibleChildInBothOrientations();
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$convertFocusDirectionToLayoutDirection(int focusDirection) {
        switch (focusDirection) {
            case 1: {
                if (this.mOrientation == 1) {
                    return -1;
                }
                if (this.isLayoutRTL()) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                if (this.mOrientation == 1) {
                    return 1;
                }
                if (this.isLayoutRTL()) {
                    return -1;
                }
                return 1;
            }
            case 33: {
                return this.mOrientation == 1 ? -1 : Integer.MIN_VALUE;
            }
            case 130: {
                return this.mOrientation == 1 ? 1 : Integer.MIN_VALUE;
            }
            case 17: {
                return this.mOrientation == 0 ? -1 : Integer.MIN_VALUE;
            }
            case 66: {
                return this.mOrientation == 0 ? 1 : Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$getChildClosestToStart() {
        return this.getChildAt(this.mShouldReverseLayout ? this.getChildCount() - 1 : 0);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$getChildClosestToEnd() {
        return this.getChildAt(this.mShouldReverseLayout ? 0 : this.getChildCount() - 1);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleChildClosestToStart(boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(this.getChildCount() - 1, -1, completelyVisible, acceptPartiallyVisible);
        }
        return this.findOneVisibleChild(0, this.getChildCount(), completelyVisible, acceptPartiallyVisible);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleChildClosestToEnd(boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(0, this.getChildCount(), completelyVisible, acceptPartiallyVisible);
        }
        return this.findOneVisibleChild(this.getChildCount() - 1, -1, completelyVisible, acceptPartiallyVisible);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChildClosestToEnd(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.mShouldReverseLayout ? this.findFirstReferenceChild(recycler, state) : this.findLastReferenceChild(recycler, state);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChildClosestToStart(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.mShouldReverseLayout ? this.findLastReferenceChild(recycler, state) : this.findFirstReferenceChild(recycler, state);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.findReferenceChild(recycler, state, 0, this.getChildCount(), state.getItemCount());
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findLastReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.findReferenceChild(recycler, state, this.getChildCount() - 1, -1, state.getItemCount());
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state, int start, int end, int itemCount) {
        this.ensureLayoutState();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundsStart = this.mOrientationHelper.getStartAfterPadding();
        int boundsEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) >= boundsEnd || this.mOrientationHelper.getDecoratedEnd(view) < boundsStart) {
                if (outOfBoundsMatch != null) continue;
                outOfBoundsMatch = view;
                continue;
            }
            return view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.getChildCount(), false, true);
        return child == null ? -1 : this.getPosition(child);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.getChildCount(), true, false);
        return child == null ? -1 : this.getPosition(child);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$findLastVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.getChildCount() - 1, -1, false, true);
        return child == null ? -1 : this.getPosition(child);
    }

    private final int $$robo$$com_android_internal_widget_LinearLayoutManager$findLastCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.getChildCount() - 1, -1, true, false);
        return child == null ? -1 : this.getPosition(child);
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible, boolean acceptPartiallyVisible) {
        this.ensureLayoutState();
        int start = this.mOrientationHelper.getStartAfterPadding();
        int end = this.mOrientationHelper.getEndAfterPadding();
        int next = toIndex > fromIndex ? 1 : -1;
        View partiallyVisible = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.getChildAt(i);
            int childStart = this.mOrientationHelper.getDecoratedStart(child);
            int childEnd = this.mOrientationHelper.getDecoratedEnd(child);
            if (childStart >= end || childEnd <= start) continue;
            if (completelyVisible) {
                if (childStart >= start && childEnd <= end) {
                    return child;
                }
                if (!acceptPartiallyVisible || partiallyVisible != null) continue;
                partiallyVisible = child;
                continue;
            }
            return child;
        }
        return partiallyVisible;
    }

    private final View $$robo$$com_android_internal_widget_LinearLayoutManager$onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.resolveShouldLayoutReverse();
        if (this.getChildCount() == 0) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        if (layoutDir == Integer.MIN_VALUE) {
            return null;
        }
        this.ensureLayoutState();
        View referenceChild = layoutDir == -1 ? this.findReferenceChildClosestToStart(recycler, state) : this.findReferenceChildClosestToEnd(recycler, state);
        if (referenceChild == null) {
            return null;
        }
        this.ensureLayoutState();
        int maxScroll = (int)(0.33333334f * (float)this.mOrientationHelper.getTotalSpace());
        this.updateLayoutState(layoutDir, maxScroll, false, state);
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
        this.mLayoutState.mRecycle = false;
        this.fill(recycler, this.mLayoutState, state, true);
        View nextFocus = layoutDir == -1 ? this.getChildClosestToStart() : this.getChildClosestToEnd();
        if (nextFocus == referenceChild || !nextFocus.isFocusable()) {
            return null;
        }
        return nextFocus;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$logChildren() {
        Log.d("LinearLayoutManager", "internal representation of views on the screen");
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            Log.d("LinearLayoutManager", "item " + this.getPosition(child) + ", coord:" + this.mOrientationHelper.getDecoratedStart(child));
        }
        Log.d("LinearLayoutManager", "==============");
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$validateChildOrder() {
        Log.d("LinearLayoutManager", "validating child count " + this.getChildCount());
        if (this.getChildCount() < 1) {
            return;
        }
        int lastPos = this.getPosition(this.getChildAt(0));
        int lastScreenLoc = this.mOrientationHelper.getDecoratedStart(this.getChildAt(0));
        if (this.mShouldReverseLayout) {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc <= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        } else {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc >= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager$supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && this.mLastStackFromEnd == this.mStackFromEnd;
    }

    private final void $$robo$$com_android_internal_widget_LinearLayoutManager$prepareForDrop(View view, View target, int x, int y) {
        int dropDirection;
        this.assertNotInLayoutOrScroll("Cannot drop a view during a scroll or layout calculation");
        this.ensureLayoutState();
        this.resolveShouldLayoutReverse();
        int myPos = this.getPosition(view);
        int targetPos = this.getPosition(target);
        int n = dropDirection = myPos < targetPos ? 1 : -1;
        if (this.mShouldReverseLayout) {
            if (dropDirection == 1) {
                this.scrollToPositionWithOffset(targetPos, this.mOrientationHelper.getEndAfterPadding() - (this.mOrientationHelper.getDecoratedStart(target) + this.mOrientationHelper.getDecoratedMeasurement(view)));
            } else {
                this.scrollToPositionWithOffset(targetPos, this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(target));
            }
        } else if (dropDirection == -1) {
            this.scrollToPositionWithOffset(targetPos, this.mOrientationHelper.getDecoratedStart(target));
        } else {
            this.scrollToPositionWithOffset(targetPos, this.mOrientationHelper.getDecoratedEnd(target) - this.mOrientationHelper.getDecoratedMeasurement(view));
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(context);
    }

    public LinearLayoutManager(Context context) {
        this(context, 1, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, int n, boolean bl) {
        this.$$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(context, n, bl);
    }

    public LinearLayoutManager(Context context, int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(android.content.Context int boolean ), this, context, n, bl);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(context, attributeSet, n, n2);
    }

    public LinearLayoutManager(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_LinearLayoutManager$generateDefaultLayoutParams(), this);
    }

    public boolean getRecycleChildrenOnDetach() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRecycleChildrenOnDetach", $$robo$$com_android_internal_widget_LinearLayoutManager$getRecycleChildrenOnDetach(), this);
    }

    public void setRecycleChildrenOnDetach(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRecycleChildrenOnDetach", $$robo$$com_android_internal_widget_LinearLayoutManager$setRecycleChildrenOnDetach(boolean ), this, bl);
    }

    @Override
    public void onDetachedFromWindow(RecyclerView recyclerView, RecyclerView.Recycler recycler) {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_LinearLayoutManager$onDetachedFromWindow(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$Recycler ), this, recyclerView, recycler);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$com_android_internal_widget_LinearLayoutManager$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_widget_LinearLayoutManager$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_widget_LinearLayoutManager$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public boolean canScrollHorizontally() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScrollHorizontally", $$robo$$com_android_internal_widget_LinearLayoutManager$canScrollHorizontally(), this);
    }

    @Override
    public boolean canScrollVertically() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScrollVertically", $$robo$$com_android_internal_widget_LinearLayoutManager$canScrollVertically(), this);
    }

    public void setStackFromEnd(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStackFromEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$setStackFromEnd(boolean ), this, bl);
    }

    public boolean getStackFromEnd() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStackFromEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$getStackFromEnd(), this);
    }

    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$com_android_internal_widget_LinearLayoutManager$getOrientation(), this);
    }

    public void setOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$com_android_internal_widget_LinearLayoutManager$setOrientation(int ), this, n);
    }

    private void resolveShouldLayoutReverse() {
        InvokeDynamicSupport.bootstrap("resolveShouldLayoutReverse", $$robo$$com_android_internal_widget_LinearLayoutManager$resolveShouldLayoutReverse(), this);
    }

    public boolean getReverseLayout() {
        return (boolean)InvokeDynamicSupport.bootstrap("getReverseLayout", $$robo$$com_android_internal_widget_LinearLayoutManager$getReverseLayout(), this);
    }

    public void setReverseLayout(boolean bl) {
        InvokeDynamicSupport.bootstrap("setReverseLayout", $$robo$$com_android_internal_widget_LinearLayoutManager$setReverseLayout(boolean ), this, bl);
    }

    @Override
    public View findViewByPosition(int n) {
        return InvokeDynamicSupport.bootstrap("findViewByPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$findViewByPosition(int ), this, n);
    }

    protected int getExtraLayoutSpace(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("getExtraLayoutSpace", $$robo$$com_android_internal_widget_LinearLayoutManager$getExtraLayoutSpace(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$smoothScrollToPosition(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State int ), this, recyclerView, state, n);
    }

    @Override
    public PointF computeScrollVectorForPosition(int n) {
        return InvokeDynamicSupport.bootstrap("computeScrollVectorForPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollVectorForPosition(int ), this, n);
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("onLayoutChildren", $$robo$$com_android_internal_widget_LinearLayoutManager$onLayoutChildren(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
    }

    @Override
    public void onLayoutCompleted(RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("onLayoutCompleted", $$robo$$com_android_internal_widget_LinearLayoutManager$onLayoutCompleted(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    void onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo, int n) {
        InvokeDynamicSupport.bootstrap("onAnchorReady", $$robo$$com_android_internal_widget_LinearLayoutManager$onAnchorReady(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$AnchorInfo int ), this, recycler, state, anchorInfo, n);
    }

    private void layoutForPredictiveAnimations(RecyclerView.Recycler recycler, RecyclerView.State state, int n, int n2) {
        InvokeDynamicSupport.bootstrap("layoutForPredictiveAnimations", $$robo$$com_android_internal_widget_LinearLayoutManager$layoutForPredictiveAnimations(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State int int ), this, recycler, state, n, n2);
    }

    private void updateAnchorInfoForLayout(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        InvokeDynamicSupport.bootstrap("updateAnchorInfoForLayout", $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorInfoForLayout(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$AnchorInfo ), this, recycler, state, anchorInfo);
    }

    private boolean updateAnchorFromChildren(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAnchorFromChildren", $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorFromChildren(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$AnchorInfo ), this, recycler, state, anchorInfo);
    }

    private boolean updateAnchorFromPendingData(RecyclerView.State state, AnchorInfo anchorInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAnchorFromPendingData", $$robo$$com_android_internal_widget_LinearLayoutManager$updateAnchorFromPendingData(com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$AnchorInfo ), this, state, anchorInfo);
    }

    private int fixLayoutEndGap(int n, RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("fixLayoutEndGap", $$robo$$com_android_internal_widget_LinearLayoutManager$fixLayoutEndGap(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State boolean ), this, n, recycler, state, bl);
    }

    private int fixLayoutStartGap(int n, RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("fixLayoutStartGap", $$robo$$com_android_internal_widget_LinearLayoutManager$fixLayoutStartGap(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State boolean ), this, n, recycler, state, bl);
    }

    private void updateLayoutStateToFillEnd(AnchorInfo anchorInfo) {
        InvokeDynamicSupport.bootstrap("updateLayoutStateToFillEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillEnd(com.android.internal.widget.LinearLayoutManager$AnchorInfo ), this, anchorInfo);
    }

    private void updateLayoutStateToFillEnd(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateLayoutStateToFillEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillEnd(int int ), this, n, n2);
    }

    private void updateLayoutStateToFillStart(AnchorInfo anchorInfo) {
        InvokeDynamicSupport.bootstrap("updateLayoutStateToFillStart", $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillStart(com.android.internal.widget.LinearLayoutManager$AnchorInfo ), this, anchorInfo);
    }

    private void updateLayoutStateToFillStart(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateLayoutStateToFillStart", $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutStateToFillStart(int int ), this, n, n2);
    }

    protected boolean isLayoutRTL() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutRTL", $$robo$$com_android_internal_widget_LinearLayoutManager$isLayoutRTL(), this);
    }

    void ensureLayoutState() {
        InvokeDynamicSupport.bootstrap("ensureLayoutState", $$robo$$com_android_internal_widget_LinearLayoutManager$ensureLayoutState(), this);
    }

    LayoutState createLayoutState() {
        return InvokeDynamicSupport.bootstrap("createLayoutState", $$robo$$com_android_internal_widget_LinearLayoutManager$createLayoutState(), this);
    }

    @Override
    public void scrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("scrollToPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$scrollToPosition(int ), this, n);
    }

    public void scrollToPositionWithOffset(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollToPositionWithOffset", $$robo$$com_android_internal_widget_LinearLayoutManager$scrollToPositionWithOffset(int int ), this, n, n2);
    }

    @Override
    public int scrollHorizontallyBy(int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("scrollHorizontallyBy", $$robo$$com_android_internal_widget_LinearLayoutManager$scrollHorizontallyBy(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, n, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("scrollVerticallyBy", $$robo$$com_android_internal_widget_LinearLayoutManager$scrollVerticallyBy(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, n, recycler, state);
    }

    @Override
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollOffset", $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollOffset(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollOffset(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollExtent", $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollExtent(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollExtent(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$com_android_internal_widget_LinearLayoutManager$computeHorizontalScrollRange(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    @Override
    public int computeVerticalScrollRange(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$com_android_internal_widget_LinearLayoutManager$computeVerticalScrollRange(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    private int computeScrollOffset(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeScrollOffset", $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollOffset(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    private int computeScrollExtent(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeScrollExtent", $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollExtent(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    private int computeScrollRange(RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("computeScrollRange", $$robo$$com_android_internal_widget_LinearLayoutManager$computeScrollRange(com.android.internal.widget.RecyclerView$State ), this, state);
    }

    public void setSmoothScrollbarEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSmoothScrollbarEnabled", $$robo$$com_android_internal_widget_LinearLayoutManager$setSmoothScrollbarEnabled(boolean ), this, bl);
    }

    public boolean isSmoothScrollbarEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmoothScrollbarEnabled", $$robo$$com_android_internal_widget_LinearLayoutManager$isSmoothScrollbarEnabled(), this);
    }

    private void updateLayoutState(int n, int n2, boolean bl, RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("updateLayoutState", $$robo$$com_android_internal_widget_LinearLayoutManager$updateLayoutState(int int boolean com.android.internal.widget.RecyclerView$State ), this, n, n2, bl, state);
    }

    boolean resolveIsInfinite() {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveIsInfinite", $$robo$$com_android_internal_widget_LinearLayoutManager$resolveIsInfinite(), this);
    }

    void collectPrefetchPositionsForLayoutState(RecyclerView.State state, LayoutState layoutState, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        InvokeDynamicSupport.bootstrap("collectPrefetchPositionsForLayoutState", $$robo$$com_android_internal_widget_LinearLayoutManager$collectPrefetchPositionsForLayoutState(com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$LayoutState com.android.internal.widget.RecyclerView$LayoutManager$LayoutPrefetchRegistry ), this, state, layoutState, layoutPrefetchRegistry);
    }

    @Override
    public void collectInitialPrefetchPositions(int n, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        InvokeDynamicSupport.bootstrap("collectInitialPrefetchPositions", $$robo$$com_android_internal_widget_LinearLayoutManager$collectInitialPrefetchPositions(int com.android.internal.widget.RecyclerView$LayoutManager$LayoutPrefetchRegistry ), this, n, layoutPrefetchRegistry);
    }

    public void setInitialPrefetchItemCount(int n) {
        InvokeDynamicSupport.bootstrap("setInitialPrefetchItemCount", $$robo$$com_android_internal_widget_LinearLayoutManager$setInitialPrefetchItemCount(int ), this, n);
    }

    public int getInitialItemPrefetchCount() {
        return (int)InvokeDynamicSupport.bootstrap("getInitialItemPrefetchCount", $$robo$$com_android_internal_widget_LinearLayoutManager$getInitialItemPrefetchCount(), this);
    }

    @Override
    public void collectAdjacentPrefetchPositions(int n, int n2, RecyclerView.State state, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        InvokeDynamicSupport.bootstrap("collectAdjacentPrefetchPositions", $$robo$$com_android_internal_widget_LinearLayoutManager$collectAdjacentPrefetchPositions(int int com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$LayoutManager$LayoutPrefetchRegistry ), this, n, n2, state, layoutPrefetchRegistry);
    }

    int scrollBy(int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return (int)InvokeDynamicSupport.bootstrap("scrollBy", $$robo$$com_android_internal_widget_LinearLayoutManager$scrollBy(int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, n, recycler, state);
    }

    @Override
    public void assertNotInLayoutOrScroll(String string2) {
        InvokeDynamicSupport.bootstrap("assertNotInLayoutOrScroll", $$robo$$com_android_internal_widget_LinearLayoutManager$assertNotInLayoutOrScroll(java.lang.String ), this, string2);
    }

    private void recycleChildren(RecyclerView.Recycler recycler, int n, int n2) {
        InvokeDynamicSupport.bootstrap("recycleChildren", $$robo$$com_android_internal_widget_LinearLayoutManager$recycleChildren(com.android.internal.widget.RecyclerView$Recycler int int ), this, recycler, n, n2);
    }

    private void recycleViewsFromStart(RecyclerView.Recycler recycler, int n) {
        InvokeDynamicSupport.bootstrap("recycleViewsFromStart", $$robo$$com_android_internal_widget_LinearLayoutManager$recycleViewsFromStart(com.android.internal.widget.RecyclerView$Recycler int ), this, recycler, n);
    }

    private void recycleViewsFromEnd(RecyclerView.Recycler recycler, int n) {
        InvokeDynamicSupport.bootstrap("recycleViewsFromEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$recycleViewsFromEnd(com.android.internal.widget.RecyclerView$Recycler int ), this, recycler, n);
    }

    private void recycleByLayoutState(RecyclerView.Recycler recycler, LayoutState layoutState) {
        InvokeDynamicSupport.bootstrap("recycleByLayoutState", $$robo$$com_android_internal_widget_LinearLayoutManager$recycleByLayoutState(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.LinearLayoutManager$LayoutState ), this, recycler, layoutState);
    }

    int fill(RecyclerView.Recycler recycler, LayoutState layoutState, RecyclerView.State state, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("fill", $$robo$$com_android_internal_widget_LinearLayoutManager$fill(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.LinearLayoutManager$LayoutState com.android.internal.widget.RecyclerView$State boolean ), this, recycler, layoutState, state, bl);
    }

    void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutState layoutState, LayoutChunkResult layoutChunkResult) {
        InvokeDynamicSupport.bootstrap("layoutChunk", $$robo$$com_android_internal_widget_LinearLayoutManager$layoutChunk(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State com.android.internal.widget.LinearLayoutManager$LayoutState com.android.internal.widget.LinearLayoutManager$LayoutChunkResult ), this, recycler, state, layoutState, layoutChunkResult);
    }

    @Override
    boolean shouldMeasureTwice() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldMeasureTwice", $$robo$$com_android_internal_widget_LinearLayoutManager$shouldMeasureTwice(), this);
    }

    int convertFocusDirectionToLayoutDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("convertFocusDirectionToLayoutDirection", $$robo$$com_android_internal_widget_LinearLayoutManager$convertFocusDirectionToLayoutDirection(int ), this, n);
    }

    private View getChildClosestToStart() {
        return InvokeDynamicSupport.bootstrap("getChildClosestToStart", $$robo$$com_android_internal_widget_LinearLayoutManager$getChildClosestToStart(), this);
    }

    private View getChildClosestToEnd() {
        return InvokeDynamicSupport.bootstrap("getChildClosestToEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$getChildClosestToEnd(), this);
    }

    private View findFirstVisibleChildClosestToStart(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("findFirstVisibleChildClosestToStart", $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleChildClosestToStart(boolean boolean ), this, bl, bl2);
    }

    private View findFirstVisibleChildClosestToEnd(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("findFirstVisibleChildClosestToEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleChildClosestToEnd(boolean boolean ), this, bl, bl2);
    }

    private View findReferenceChildClosestToEnd(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return InvokeDynamicSupport.bootstrap("findReferenceChildClosestToEnd", $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChildClosestToEnd(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
    }

    private View findReferenceChildClosestToStart(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return InvokeDynamicSupport.bootstrap("findReferenceChildClosestToStart", $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChildClosestToStart(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
    }

    private View findFirstReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return InvokeDynamicSupport.bootstrap("findFirstReferenceChild", $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstReferenceChild(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
    }

    private View findLastReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return InvokeDynamicSupport.bootstrap("findLastReferenceChild", $$robo$$com_android_internal_widget_LinearLayoutManager$findLastReferenceChild(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, recycler, state);
    }

    View findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("findReferenceChild", $$robo$$com_android_internal_widget_LinearLayoutManager$findReferenceChild(com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State int int int ), this, recycler, state, n, n2, n3);
    }

    public int findFirstVisibleItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("findFirstVisibleItemPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstVisibleItemPosition(), this);
    }

    public int findFirstCompletelyVisibleItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("findFirstCompletelyVisibleItemPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$findFirstCompletelyVisibleItemPosition(), this);
    }

    public int findLastVisibleItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("findLastVisibleItemPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$findLastVisibleItemPosition(), this);
    }

    public int findLastCompletelyVisibleItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("findLastCompletelyVisibleItemPosition", $$robo$$com_android_internal_widget_LinearLayoutManager$findLastCompletelyVisibleItemPosition(), this);
    }

    View findOneVisibleChild(int n, int n2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("findOneVisibleChild", $$robo$$com_android_internal_widget_LinearLayoutManager$findOneVisibleChild(int int boolean boolean ), this, n, n2, bl, bl2);
    }

    @Override
    public View onFocusSearchFailed(View view, int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return InvokeDynamicSupport.bootstrap("onFocusSearchFailed", $$robo$$com_android_internal_widget_LinearLayoutManager$onFocusSearchFailed(android.view.View int com.android.internal.widget.RecyclerView$Recycler com.android.internal.widget.RecyclerView$State ), this, view, n, recycler, state);
    }

    private void logChildren() {
        InvokeDynamicSupport.bootstrap("logChildren", $$robo$$com_android_internal_widget_LinearLayoutManager$logChildren(), this);
    }

    void validateChildOrder() {
        InvokeDynamicSupport.bootstrap("validateChildOrder", $$robo$$com_android_internal_widget_LinearLayoutManager$validateChildOrder(), this);
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsPredictiveItemAnimations", $$robo$$com_android_internal_widget_LinearLayoutManager$supportsPredictiveItemAnimations(), this);
    }

    @Override
    public void prepareForDrop(View view, View view2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("prepareForDrop", $$robo$$com_android_internal_widget_LinearLayoutManager$prepareForDrop(android.view.View android.view.View int int ), this, view, view2, n, n2);
    }

    public /* synthetic */ LinearLayoutManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinearLayoutManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static class LayoutChunkResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int mConsumed;
        public boolean mFinished;
        public boolean mIgnoreConsumed;
        public boolean mFocusable;

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutChunkResult$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutChunkResult$resetInternal() {
            this.mConsumed = 0;
            this.mFinished = false;
            this.mIgnoreConsumed = false;
            this.mFocusable = false;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_LayoutChunkResult$__constructor__();
        }

        public LayoutChunkResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutChunkResult$__constructor__(), this);
        }

        void resetInternal() {
            InvokeDynamicSupport.bootstrap("resetInternal", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutChunkResult$resetInternal(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutChunkResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class AnchorInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mPosition;
        int mCoordinate;
        boolean mLayoutFromEnd;
        boolean mValid;
        /* synthetic */ LinearLayoutManager this$0;

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$__constructor__(LinearLayoutManager this$0) {
            this.this$0 = this$0;
            this.reset();
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$reset() {
            this.mPosition = -1;
            this.mCoordinate = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
            this.mValid = false;
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignCoordinateFromPadding() {
            this.mCoordinate = this.mLayoutFromEnd ? this.this$0.mOrientationHelper.getEndAfterPadding() : this.this$0.mOrientationHelper.getStartAfterPadding();
        }

        private final String $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$toString() {
            return "AnchorInfo{mPosition=" + this.mPosition + ", mCoordinate=" + this.mCoordinate + ", mLayoutFromEnd=" + this.mLayoutFromEnd + ", mValid=" + this.mValid + '}';
        }

        private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$isViewValidAsAnchor(View child, RecyclerView.State state) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            return !lp.isItemRemoved() && lp.getViewLayoutPosition() >= 0 && lp.getViewLayoutPosition() < state.getItemCount();
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignFromViewAndKeepVisibleRect(View child) {
            int spaceChange = this.this$0.mOrientationHelper.getTotalSpaceChange();
            if (spaceChange >= 0) {
                this.assignFromView(child);
                return;
            }
            this.mPosition = this.this$0.getPosition(child);
            if (this.mLayoutFromEnd) {
                int previousStartMargin;
                int layoutStart;
                int startReference;
                int childSize;
                int estimatedChildStart;
                int startMargin;
                int prevLayoutEnd = this.this$0.mOrientationHelper.getEndAfterPadding() - spaceChange;
                int childEnd = this.this$0.mOrientationHelper.getDecoratedEnd(child);
                int previousEndMargin = prevLayoutEnd - childEnd;
                this.mCoordinate = this.this$0.mOrientationHelper.getEndAfterPadding() - previousEndMargin;
                if (previousEndMargin > 0 && (startMargin = (estimatedChildStart = this.mCoordinate - (childSize = this.this$0.mOrientationHelper.getDecoratedMeasurement(child))) - (startReference = (layoutStart = this.this$0.mOrientationHelper.getStartAfterPadding()) + Math.min(previousStartMargin = this.this$0.mOrientationHelper.getDecoratedStart(child) - layoutStart, 0))) < 0) {
                    this.mCoordinate += Math.min(previousEndMargin, -startMargin);
                }
            } else {
                int childStart = this.this$0.mOrientationHelper.getDecoratedStart(child);
                int startMargin = childStart - this.this$0.mOrientationHelper.getStartAfterPadding();
                this.mCoordinate = childStart;
                if (startMargin > 0) {
                    int estimatedEnd = childStart + this.this$0.mOrientationHelper.getDecoratedMeasurement(child);
                    int previousLayoutEnd = this.this$0.mOrientationHelper.getEndAfterPadding() - spaceChange;
                    int previousEndMargin = previousLayoutEnd - this.this$0.mOrientationHelper.getDecoratedEnd(child);
                    int endReference = this.this$0.mOrientationHelper.getEndAfterPadding() - Math.min(0, previousEndMargin);
                    int endMargin = endReference - estimatedEnd;
                    if (endMargin < 0) {
                        this.mCoordinate -= Math.min(startMargin, -endMargin);
                    }
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignFromView(View child) {
            this.mCoordinate = this.mLayoutFromEnd ? this.this$0.mOrientationHelper.getDecoratedEnd(child) + this.this$0.mOrientationHelper.getTotalSpaceChange() : this.this$0.mOrientationHelper.getDecoratedStart(child);
            this.mPosition = this.this$0.getPosition(child);
        }

        private void __constructor__(LinearLayoutManager linearLayoutManager) {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$__constructor__(linearLayoutManager);
        }

        public AnchorInfo(LinearLayoutManager linearLayoutManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$__constructor__(com.android.internal.widget.LinearLayoutManager ), this, linearLayoutManager);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$reset(), this);
        }

        void assignCoordinateFromPadding() {
            InvokeDynamicSupport.bootstrap("assignCoordinateFromPadding", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignCoordinateFromPadding(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$toString(), this);
        }

        boolean isViewValidAsAnchor(View view, RecyclerView.State state) {
            return (boolean)InvokeDynamicSupport.bootstrap("isViewValidAsAnchor", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$isViewValidAsAnchor(android.view.View com.android.internal.widget.RecyclerView$State ), this, view, state);
        }

        public void assignFromViewAndKeepVisibleRect(View view) {
            InvokeDynamicSupport.bootstrap("assignFromViewAndKeepVisibleRect", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignFromViewAndKeepVisibleRect(android.view.View ), this, view);
        }

        public void assignFromView(View view) {
            InvokeDynamicSupport.bootstrap("assignFromView", $$robo$$com_android_internal_widget_LinearLayoutManager_AnchorInfo$assignFromView(android.view.View ), this, view);
        }

        public /* synthetic */ AnchorInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnchorInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mAnchorPosition;
        int mAnchorOffset;
        boolean mAnchorLayoutFromEnd;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__() {
        }

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(Parcel in) {
            this.mAnchorPosition = in.readInt();
            this.mAnchorOffset = in.readInt();
            this.mAnchorLayoutFromEnd = in.readInt() == 1;
        }

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(SavedState other) {
            this.mAnchorPosition = other.mAnchorPosition;
            this.mAnchorOffset = other.mAnchorOffset;
            this.mAnchorLayoutFromEnd = other.mAnchorLayoutFromEnd;
        }

        private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$hasValidAnchor() {
            return this.mAnchorPosition >= 0;
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$invalidateAnchor() {
            this.mAnchorPosition = -1;
        }

        private final int $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$describeContents() {
            return 0;
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mAnchorPosition);
            dest.writeInt(this.mAnchorOffset);
            dest.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__();
        }

        public SavedState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(SavedState savedState) {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(savedState);
        }

        public SavedState(SavedState savedState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$__constructor__(com.android.internal.widget.LinearLayoutManager$SavedState ), this, savedState);
        }

        boolean hasValidAnchor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasValidAnchor", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$hasValidAnchor(), this);
        }

        void invalidateAnchor() {
            InvokeDynamicSupport.bootstrap("invalidateAnchor", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$invalidateAnchor(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_widget_LinearLayoutManager_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static String TAG = "LLM#LayoutState";
        static int LAYOUT_START = -1;
        static int LAYOUT_END = 1;
        static int INVALID_LAYOUT = Integer.MIN_VALUE;
        static int ITEM_DIRECTION_HEAD = -1;
        static int ITEM_DIRECTION_TAIL = 1;
        static int SCROLLING_OFFSET_NaN = Integer.MIN_VALUE;
        boolean mRecycle;
        int mOffset;
        int mAvailable;
        int mCurrentPosition;
        int mItemDirection;
        int mLayoutDirection;
        int mScrollingOffset;
        int mExtra;
        boolean mIsPreLayout;
        int mLastScrollDelta;
        List<RecyclerView.ViewHolder> mScrapList;
        boolean mInfinite;

        private void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$__constructor__() {
            this.mRecycle = true;
            this.mExtra = 0;
            this.mIsPreLayout = false;
            this.mScrapList = null;
        }

        private final boolean $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$hasMore(RecyclerView.State state) {
            return this.mCurrentPosition >= 0 && this.mCurrentPosition < state.getItemCount();
        }

        private final View $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$next(RecyclerView.Recycler recycler) {
            if (this.mScrapList != null) {
                return this.nextViewFromScrapList();
            }
            View view = recycler.getViewForPosition(this.mCurrentPosition);
            this.mCurrentPosition += this.mItemDirection;
            return view;
        }

        private final View $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$nextViewFromScrapList() {
            int size = this.mScrapList.size();
            for (int i = 0; i < size; ++i) {
                View view = this.mScrapList.get((int)i).itemView;
                RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (lp.isItemRemoved() || this.mCurrentPosition != lp.getViewLayoutPosition()) continue;
                this.assignPositionFromScrapList(view);
                return view;
            }
            return null;
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$assignPositionFromScrapList() {
            this.assignPositionFromScrapList(null);
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$assignPositionFromScrapList(View ignore) {
            View closest = this.nextViewInLimitedList(ignore);
            this.mCurrentPosition = closest == null ? -1 : ((RecyclerView.LayoutParams)closest.getLayoutParams()).getViewLayoutPosition();
        }

        private final View $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$nextViewInLimitedList(View ignore) {
            int size = this.mScrapList.size();
            View closest = null;
            int closestDistance = Integer.MAX_VALUE;
            for (int i = 0; i < size; ++i) {
                int distance;
                View view = this.mScrapList.get((int)i).itemView;
                RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (view == ignore || lp.isItemRemoved() || (distance = (lp.getViewLayoutPosition() - this.mCurrentPosition) * this.mItemDirection) < 0 || distance >= closestDistance) continue;
                closest = view;
                closestDistance = distance;
                if (distance == 0) break;
            }
            return closest;
        }

        private final void $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$log() {
            Log.d("LLM#LayoutState", "avail:" + this.mAvailable + ", ind:" + this.mCurrentPosition + ", dir:" + this.mItemDirection + ", offset:" + this.mOffset + ", layoutDir:" + this.mLayoutDirection);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$__constructor__();
        }

        public LayoutState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$__constructor__(), this);
        }

        boolean hasMore(RecyclerView.State state) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasMore", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$hasMore(com.android.internal.widget.RecyclerView$State ), this, state);
        }

        View next(RecyclerView.Recycler recycler) {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$next(com.android.internal.widget.RecyclerView$Recycler ), this, recycler);
        }

        private View nextViewFromScrapList() {
            return InvokeDynamicSupport.bootstrap("nextViewFromScrapList", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$nextViewFromScrapList(), this);
        }

        public void assignPositionFromScrapList() {
            InvokeDynamicSupport.bootstrap("assignPositionFromScrapList", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$assignPositionFromScrapList(), this);
        }

        public void assignPositionFromScrapList(View view) {
            InvokeDynamicSupport.bootstrap("assignPositionFromScrapList", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$assignPositionFromScrapList(android.view.View ), this, view);
        }

        public View nextViewInLimitedList(View view) {
            return InvokeDynamicSupport.bootstrap("nextViewInLimitedList", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$nextViewInLimitedList(android.view.View ), this, view);
        }

        void log() {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_widget_LinearLayoutManager_LayoutState$log(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

