/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ListMenuItemView
extends LinearLayout
implements MenuView.ItemView,
AbsListView.SelectionBoundsAdjuster,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ListMenuItemView";
    private MenuItemImpl mItemData;
    private ImageView mIconView;
    private RadioButton mRadioButton;
    private TextView mTitleView;
    private CheckBox mCheckBox;
    private TextView mShortcutView;
    private ImageView mSubMenuArrowView;
    private ImageView mGroupDivider;
    private LinearLayout mContent;
    private Drawable mBackground;
    private int mTextAppearance;
    private Context mTextAppearanceContext;
    private boolean mPreserveIconSpacing;
    private Drawable mSubMenuArrow;
    private boolean mHasListDivider;
    private int mMenuType;
    private LayoutInflater mInflater;
    private boolean mForceShowIcon;

    private void $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, defStyleAttr, defStyleRes);
        this.mBackground = a.getDrawable(5);
        this.mTextAppearance = a.getResourceId(1, -1);
        this.mPreserveIconSpacing = a.getBoolean(8, false);
        this.mTextAppearanceContext = context;
        this.mSubMenuArrow = a.getDrawable(7);
        TypedArray b = context.getTheme().obtainStyledAttributes(null, new int[]{16843049}, 16842861, 0);
        this.mHasListDivider = b.hasValue(0);
        a.recycle();
        b.recycle();
    }

    private void $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(Context context, AttributeSet attrs) {
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$onFinishInflate() {
        super.onFinishInflate();
        this.setBackgroundDrawable(this.mBackground);
        this.mTitleView = (TextView)this.findViewById(16908310);
        if (this.mTextAppearance != -1) {
            this.mTitleView.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.mShortcutView = (TextView)this.findViewById(16909296);
        this.mSubMenuArrowView = (ImageView)this.findViewById(16909357);
        if (this.mSubMenuArrowView != null) {
            this.mSubMenuArrowView.setImageDrawable(this.mSubMenuArrow);
        }
        this.mGroupDivider = (ImageView)this.findViewById(16908930);
        this.mContent = (LinearLayout)this.findViewById(0x1020002);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.mMenuType = menuType;
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setTitle(itemData.getTitleForItemView(this));
        this.setCheckable(itemData.isCheckable());
        this.setShortcut(itemData.shouldShowShortcut(), itemData.getShortcut());
        this.setIcon(itemData.getIcon());
        this.setEnabled(itemData.isEnabled());
        this.setSubMenuArrowVisible(itemData.hasSubMenu());
        this.setContentDescription(itemData.getContentDescription());
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$addContentView(View v) {
        this.addContentView(v, -1);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$addContentView(View v, int index) {
        if (this.mContent != null) {
            this.mContent.addView(v, index);
        } else {
            this.addView(v, index);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setForceShowIcon(boolean forceShow) {
        this.mPreserveIconSpacing = this.mForceShowIcon = forceShow;
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setTitle(CharSequence title) {
        if (title != null) {
            this.mTitleView.setText(title);
            if (this.mTitleView.getVisibility() != 0) {
                this.mTitleView.setVisibility(0);
            }
        } else if (this.mTitleView.getVisibility() != 8) {
            this.mTitleView.setVisibility(8);
        }
    }

    private final MenuItemImpl $$robo$$com_android_internal_view_menu_ListMenuItemView$getItemData() {
        return this.mItemData;
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setCheckable(boolean checkable) {
        CompoundButton otherCompoundButton;
        CompoundButton compoundButton;
        if (!checkable && this.mRadioButton == null && this.mCheckBox == null) {
            return;
        }
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
            otherCompoundButton = this.mCheckBox;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
            otherCompoundButton = this.mRadioButton;
        }
        if (checkable) {
            int newVisibility;
            compoundButton.setChecked(this.mItemData.isChecked());
            int n = newVisibility = checkable ? 0 : 8;
            if (compoundButton.getVisibility() != newVisibility) {
                compoundButton.setVisibility(newVisibility);
            }
            if (otherCompoundButton != null && otherCompoundButton.getVisibility() != 8) {
                otherCompoundButton.setVisibility(8);
            }
        } else {
            if (this.mCheckBox != null) {
                this.mCheckBox.setVisibility(8);
            }
            if (this.mRadioButton != null) {
                this.mRadioButton.setVisibility(8);
            }
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setChecked(boolean checked) {
        CompoundButton compoundButton;
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
        }
        compoundButton.setChecked(checked);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setSubMenuArrowVisible(boolean hasSubmenu) {
        if (this.mSubMenuArrowView != null) {
            this.mSubMenuArrowView.setVisibility(hasSubmenu ? 0 : 8);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setShortcut(boolean showShortcut, char shortcutKey) {
        int newVisibility;
        int n = newVisibility = showShortcut && this.mItemData.shouldShowShortcut() ? 0 : 8;
        if (newVisibility == 0) {
            this.mShortcutView.setText(this.mItemData.getShortcutLabel());
        }
        if (this.mShortcutView.getVisibility() != newVisibility) {
            this.mShortcutView.setVisibility(newVisibility);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setIcon(Drawable icon) {
        boolean showIcon;
        boolean bl = showIcon = this.mItemData.shouldShowIcon() || this.mForceShowIcon;
        if (!showIcon && !this.mPreserveIconSpacing) {
            return;
        }
        if (this.mIconView == null && icon == null && !this.mPreserveIconSpacing) {
            return;
        }
        if (this.mIconView == null) {
            this.insertIconView();
        }
        if (icon != null || this.mPreserveIconSpacing) {
            this.mIconView.setImageDrawable(showIcon ? icon : null);
            if (this.mIconView.getVisibility() != 0) {
                this.mIconView.setVisibility(0);
            }
        } else {
            this.mIconView.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIconView != null && this.mPreserveIconSpacing) {
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            LinearLayout.LayoutParams iconLp = (LinearLayout.LayoutParams)this.mIconView.getLayoutParams();
            if (lp.height > 0 && iconLp.width <= 0) {
                iconLp.width = lp.height;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$insertIconView() {
        LayoutInflater inflater = this.getInflater();
        this.mIconView = (ImageView)inflater.inflate(17367169, (ViewGroup)this, false);
        this.addContentView(this.mIconView, 0);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$insertRadioButton() {
        LayoutInflater inflater = this.getInflater();
        this.mRadioButton = (RadioButton)inflater.inflate(17367171, (ViewGroup)this, false);
        this.addContentView(this.mRadioButton);
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$insertCheckBox() {
        LayoutInflater inflater = this.getInflater();
        this.mCheckBox = (CheckBox)inflater.inflate(17367168, (ViewGroup)this, false);
        this.addContentView(this.mCheckBox);
    }

    private final boolean $$robo$$com_android_internal_view_menu_ListMenuItemView$prefersCondensedTitle() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_ListMenuItemView$showsIcon() {
        return this.mForceShowIcon;
    }

    private final LayoutInflater $$robo$$com_android_internal_view_menu_ListMenuItemView$getInflater() {
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from(this.mContext);
        }
        return this.mInflater;
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.mItemData != null && this.mItemData.hasSubMenu()) {
            info.setCanOpenPopup(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$setGroupDividerEnabled(boolean groupDividerEnabled) {
        if (this.mGroupDivider != null) {
            this.mGroupDivider.setVisibility(!this.mHasListDivider && groupDividerEnabled ? 0 : 8);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ListMenuItemView$adjustListItemSelectionBounds(Rect rect) {
        if (this.mGroupDivider != null && this.mGroupDivider.getVisibility() == 0) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mGroupDivider.getLayoutParams();
            rect.top += this.mGroupDivider.getHeight() + lp.topMargin + lp.bottomMargin;
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(context, attributeSet, n, n2);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(context, attributeSet, n);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(context, attributeSet);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16844018);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ListMenuItemView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_view_menu_ListMenuItemView$onFinishInflate(), this);
    }

    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_view_menu_ListMenuItemView$initialize(com.android.internal.view.menu.MenuItemImpl int ), this, menuItemImpl, n);
    }

    private void addContentView(View view) {
        InvokeDynamicSupport.bootstrap("addContentView", $$robo$$com_android_internal_view_menu_ListMenuItemView$addContentView(android.view.View ), this, view);
    }

    private void addContentView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addContentView", $$robo$$com_android_internal_view_menu_ListMenuItemView$addContentView(android.view.View int ), this, view, n);
    }

    public void setForceShowIcon(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceShowIcon", $$robo$$com_android_internal_view_menu_ListMenuItemView$setForceShowIcon(boolean ), this, bl);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_ListMenuItemView$setTitle(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public MenuItemImpl getItemData() {
        return InvokeDynamicSupport.bootstrap("getItemData", $$robo$$com_android_internal_view_menu_ListMenuItemView$getItemData(), this);
    }

    @Override
    public void setCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$com_android_internal_view_menu_ListMenuItemView$setCheckable(boolean ), this, bl);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_view_menu_ListMenuItemView$setChecked(boolean ), this, bl);
    }

    private void setSubMenuArrowVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSubMenuArrowVisible", $$robo$$com_android_internal_view_menu_ListMenuItemView$setSubMenuArrowVisible(boolean ), this, bl);
    }

    @Override
    public void setShortcut(boolean bl, char c) {
        InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_ListMenuItemView$setShortcut(boolean char ), this, bl, c);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_ListMenuItemView$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_view_menu_ListMenuItemView$onMeasure(int int ), this, n, n2);
    }

    private void insertIconView() {
        InvokeDynamicSupport.bootstrap("insertIconView", $$robo$$com_android_internal_view_menu_ListMenuItemView$insertIconView(), this);
    }

    private void insertRadioButton() {
        InvokeDynamicSupport.bootstrap("insertRadioButton", $$robo$$com_android_internal_view_menu_ListMenuItemView$insertRadioButton(), this);
    }

    private void insertCheckBox() {
        InvokeDynamicSupport.bootstrap("insertCheckBox", $$robo$$com_android_internal_view_menu_ListMenuItemView$insertCheckBox(), this);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return (boolean)InvokeDynamicSupport.bootstrap("prefersCondensedTitle", $$robo$$com_android_internal_view_menu_ListMenuItemView$prefersCondensedTitle(), this);
    }

    @Override
    public boolean showsIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsIcon", $$robo$$com_android_internal_view_menu_ListMenuItemView$showsIcon(), this);
    }

    private LayoutInflater getInflater() {
        return InvokeDynamicSupport.bootstrap("getInflater", $$robo$$com_android_internal_view_menu_ListMenuItemView$getInflater(), this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$com_android_internal_view_menu_ListMenuItemView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    public void setGroupDividerEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupDividerEnabled", $$robo$$com_android_internal_view_menu_ListMenuItemView$setGroupDividerEnabled(boolean ), this, bl);
    }

    @Override
    public void adjustListItemSelectionBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("adjustListItemSelectionBounds", $$robo$$com_android_internal_view_menu_ListMenuItemView$adjustListItemSelectionBounds(android.graphics.Rect ), this, rect);
    }

    public /* synthetic */ ListMenuItemView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListMenuItemView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

